/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ElementFilter {
    private static final Set<ElementKind> CONSTRUCTOR_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.CONSTRUCTOR));
    private static final Set<ElementKind> FIELD_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT));
    private static final Set<ElementKind> METHOD_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.METHOD));
    private static final Set<ElementKind> PACKAGE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.PACKAGE));
    private static final Set<ElementKind> MODULE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.MODULE));
    private static final Set<ElementKind> TYPE_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.RECORD, ElementKind.ANNOTATION_TYPE));
    private static final Set<ElementKind> RECORD_COMPONENT_KIND = Set.of(ElementKind.RECORD_COMPONENT);

    private ElementFilter() {
    }

    public static List<VariableElement> fieldsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, FIELD_KINDS, VariableElement.class);
    }

    public static Set<VariableElement> fieldsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, FIELD_KINDS, VariableElement.class);
    }

    public static List<RecordComponentElement> recordComponentsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, RECORD_COMPONENT_KIND, RecordComponentElement.class);
    }

    public static Set<RecordComponentElement> recordComponentsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, RECORD_COMPONENT_KIND, RecordComponentElement.class);
    }

    public static List<ExecutableElement> constructorsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> constructorsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static List<ExecutableElement> methodsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, METHOD_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> methodsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, METHOD_KIND, ExecutableElement.class);
    }

    public static List<TypeElement> typesIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, TYPE_KINDS, TypeElement.class);
    }

    public static Set<TypeElement> typesIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, TYPE_KINDS, TypeElement.class);
    }

    public static List<PackageElement> packagesIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, PACKAGE_KIND, PackageElement.class);
    }

    public static Set<PackageElement> packagesIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, PACKAGE_KIND, PackageElement.class);
    }

    public static List<ModuleElement> modulesIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, MODULE_KIND, ModuleElement.class);
    }

    public static Set<ModuleElement> modulesIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, MODULE_KIND, ModuleElement.class);
    }

    private static <E extends Element> List<E> listFilter(Iterable<? extends Element> iterable, Set<ElementKind> set, Class<E> clazz) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : iterable) {
            if (!set.contains((Object)element.getKind())) continue;
            arrayList.add((Element)clazz.cast(element));
        }
        return arrayList;
    }

    private static <E extends Element> Set<E> setFilter(Set<? extends Element> set, Set<ElementKind> set2, Class<E> clazz) {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Element element : set) {
            if (!set2.contains((Object)element.getKind())) continue;
            linkedHashSet.add((Element)clazz.cast(element));
        }
        return linkedHashSet;
    }

    public static List<ModuleElement.ExportsDirective> exportsIn(Iterable<? extends ModuleElement.Directive> iterable) {
        return ElementFilter.listFilter(iterable, ModuleElement.DirectiveKind.EXPORTS, ModuleElement.ExportsDirective.class);
    }

    public static List<ModuleElement.OpensDirective> opensIn(Iterable<? extends ModuleElement.Directive> iterable) {
        return ElementFilter.listFilter(iterable, ModuleElement.DirectiveKind.OPENS, ModuleElement.OpensDirective.class);
    }

    public static List<ModuleElement.ProvidesDirective> providesIn(Iterable<? extends ModuleElement.Directive> iterable) {
        return ElementFilter.listFilter(iterable, ModuleElement.DirectiveKind.PROVIDES, ModuleElement.ProvidesDirective.class);
    }

    public static List<ModuleElement.RequiresDirective> requiresIn(Iterable<? extends ModuleElement.Directive> iterable) {
        return ElementFilter.listFilter(iterable, ModuleElement.DirectiveKind.REQUIRES, ModuleElement.RequiresDirective.class);
    }

    public static List<ModuleElement.UsesDirective> usesIn(Iterable<? extends ModuleElement.Directive> iterable) {
        return ElementFilter.listFilter(iterable, ModuleElement.DirectiveKind.USES, ModuleElement.UsesDirective.class);
    }

    private static <D extends ModuleElement.Directive> List<D> listFilter(Iterable<? extends ModuleElement.Directive> iterable, ModuleElement.DirectiveKind directiveKind, Class<D> clazz) {
        ArrayList<ModuleElement.Directive> arrayList = new ArrayList<ModuleElement.Directive>();
        for (ModuleElement.Directive directive : iterable) {
            if (directive.getKind() != directiveKind) continue;
            arrayList.add((ModuleElement.Directive)clazz.cast(directive));
        }
        return arrayList;
    }
}

