/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.tidb.mysql.model;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.tidb.mysql.model.TiDBMySQLDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.osgi.framework.Version;

public class TiDBMySQLDataSourceInfo
extends JDBCDataSourceInfo {
    private static final Log log = Log.getLog(TiDBMySQLDataSourceInfo.class);
    private final TiDBMySQLDataSource dataSource;

    public TiDBMySQLDataSourceInfo(TiDBMySQLDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super(metaData);
        this.dataSource = dataSource;
    }

    public boolean supportsMultipleResults() {
        return true;
    }

    public boolean needsTableMetaForColumnResolution() {
        return true;
    }

    public String getDatabaseProductVersion() {
        return this.dataSource.getServerVersion();
    }

    public Version getDatabaseVersion() {
        String tidbVersion = this.getDatabaseProductVersion();
        String[] tidbVersionArray = tidbVersion.split("-");
        if (tidbVersionArray.length < 3 || !tidbVersionArray[1].equals("TiDB")) {
            return new Version(0, 0, 0);
        }
        String realTiDBVersion = tidbVersionArray[2].substring(1);
        String[] realTiDBVersionArray = realTiDBVersion.split("\\.");
        if (realTiDBVersionArray.length != 3) {
            return new Version(0, 0, 0);
        }
        try {
            int major = Integer.parseInt(realTiDBVersionArray[0]);
            int minor = Integer.parseInt(realTiDBVersionArray[1]);
            int patch = Integer.parseInt(realTiDBVersionArray[2]);
            return new Version(major, minor, patch);
        }
        catch (NumberFormatException e) {
            log.error((Object)e);
            return new Version(0, 0, 0);
        }
    }
}

