/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.concurrent.TimedSemaphore;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimedSemaphoreTest
extends AbstractLangTest {
    private static final long PERIOD_MILLIS = 500L;
    private static final Duration DURATION = Duration.ofMillis(500L);
    private static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    private static final int LIMIT = 10;

    private void prepareStartTimer(ScheduledExecutorService service, ScheduledFuture<?> future) {
        service.scheduleAtFixedRate((Runnable)EasyMock.anyObject(), EasyMock.eq((long)500L), EasyMock.eq((long)500L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)UNIT))));
        EasyMock.expectLastCall().andReturn(future);
    }

    @Test
    public void testAcquireLimit() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        int count = 10;
        CountDownLatch latch = new CountDownLatch(9);
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 1);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 10, 9);
        semaphore.setLimit(9);
        t.start();
        latch.await();
        Assertions.assertEquals((int)9, (int)semaphore.getAcquireCount(), (String)"Wrong semaphore count");
        semaphore.endOfPeriod();
        t.join();
        Assertions.assertEquals((int)1, (int)semaphore.getAcquireCount(), (String)"Wrong semaphore count (2)");
        Assertions.assertEquals((int)9, (int)semaphore.getLastAcquiresPerPeriod(), (String)"Wrong acquire() count");
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testAcquireMultiplePeriods() throws InterruptedException {
        int count = 1000;
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(50L, TimeUnit.MILLISECONDS, 1);
        semaphore.setLimit(250);
        CountDownLatch latch = new CountDownLatch(1000);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 1000, 1000);
        t.start();
        latch.await();
        semaphore.shutdown();
        Assertions.assertTrue((semaphore.getPeriodEnds() > 0 ? 1 : 0) != 0, (String)"End of period not reached");
    }

    @Test
    public void testAcquireMultipleThreads() throws InterruptedException {
        int i;
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 1);
        semaphore.latch = new CountDownLatch(1);
        int count = 10;
        SemaphoreThread[] threads = new SemaphoreThread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new SemaphoreThread(semaphore, null, 1, 0);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            semaphore.latch.await();
            Assertions.assertEquals((int)1, (int)semaphore.getAcquireCount(), (String)"Wrong count");
            semaphore.latch = new CountDownLatch(1);
            semaphore.endOfPeriod();
            Assertions.assertEquals((int)1, (int)semaphore.getLastAcquiresPerPeriod(), (String)"Wrong acquire count");
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testAcquireNoLimit() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 0);
        int count = 1000;
        CountDownLatch latch = new CountDownLatch(1000);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 1000, 1000);
        t.start();
        latch.await();
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testGetAvailablePermits() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((int)(10 - i), (int)semaphore.getAvailablePermits(), (String)("Wrong available count at " + i));
            semaphore.acquire();
        }
        semaphore.endOfPeriod();
        Assertions.assertEquals((int)10, (int)semaphore.getAvailablePermits(), (String)"Wrong available count in new period");
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testGetAverageCallsPerPeriod() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        semaphore.acquire();
        semaphore.endOfPeriod();
        Assertions.assertEquals((double)1.0, (double)semaphore.getAverageCallsPerPeriod(), (double)0.005, (String)"Wrong average (1)");
        semaphore.acquire();
        semaphore.acquire();
        semaphore.endOfPeriod();
        Assertions.assertEquals((double)1.5, (double)semaphore.getAverageCallsPerPeriod(), (double)0.005, (String)"Wrong average (2)");
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testInit() {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        EasyMock.replay((Object[])new Object[]{service});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        EasyMock.verify((Object[])new Object[]{service});
        Assertions.assertEquals((Object)service, (Object)semaphore.getExecutorService(), (String)"Wrong service");
        Assertions.assertEquals((long)500L, (long)semaphore.getPeriod(), (String)"Wrong period");
        Assertions.assertEquals((Object)((Object)UNIT), (Object)((Object)semaphore.getUnit()), (String)"Wrong unit");
        Assertions.assertEquals((int)0, (int)semaphore.getLastAcquiresPerPeriod(), (String)"Statistic available");
        Assertions.assertEquals((double)0.0, (double)semaphore.getAverageCallsPerPeriod(), (double)0.05, (String)"Average available");
        Assertions.assertFalse((boolean)semaphore.isShutdown(), (String)"Already shutdown");
        Assertions.assertEquals((int)10, (int)semaphore.getLimit(), (String)"Wrong limit");
    }

    @Test
    public void testInitDefaultService() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        ScheduledThreadPoolExecutor exec = (ScheduledThreadPoolExecutor)semaphore.getExecutorService();
        Assertions.assertFalse((boolean)exec.getContinueExistingPeriodicTasksAfterShutdownPolicy(), (String)"Wrong periodic task policy");
        Assertions.assertFalse((boolean)exec.getExecuteExistingDelayedTasksAfterShutdownPolicy(), (String)"Wrong delayed task policy");
        Assertions.assertFalse((boolean)exec.isShutdown(), (String)"Already shutdown");
        semaphore.shutdown();
    }

    @Test
    public void testInitInvalidPeriod() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TimedSemaphore(0L, UNIT, 10));
    }

    @Test
    public void testPassAfterShutdown() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        semaphore.shutdown();
        Assertions.assertThrows(IllegalStateException.class, () -> ((TimedSemaphore)semaphore).acquire());
    }

    @Test
    public void testShutdownMultipleTimes() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 10);
        semaphore.acquire();
        for (int i = 0; i < 10; ++i) {
            semaphore.shutdown();
        }
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testShutdownOwnExecutor() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        semaphore.shutdown();
        Assertions.assertTrue((boolean)semaphore.isShutdown(), (String)"Not shutdown");
        Assertions.assertTrue((boolean)semaphore.getExecutorService().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testShutdownSharedExecutorNoTask() {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        EasyMock.replay((Object[])new Object[]{service});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        semaphore.shutdown();
        Assertions.assertTrue((boolean)semaphore.isShutdown(), (String)"Not shutdown");
        EasyMock.verify((Object[])new Object[]{service});
    }

    @Test
    public void testShutdownSharedExecutorTask() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 10);
        semaphore.acquire();
        semaphore.shutdown();
        Assertions.assertTrue((boolean)semaphore.isShutdown(), (String)"Not shutdown");
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testStartTimer() throws InterruptedException {
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(500L, UNIT, 10);
        ScheduledFuture<?> future = semaphore.startTimer();
        Assertions.assertNotNull(future, (String)"No future returned");
        ThreadUtils.sleepQuietly((Duration)DURATION);
        int trials = 10;
        int count = 0;
        do {
            Thread.sleep(500L);
            Assertions.assertFalse((count++ > 10 ? 1 : 0) != 0, (String)"endOfPeriod() not called!");
        } while (semaphore.getPeriodEnds() <= 0);
        semaphore.shutdown();
    }

    @Test
    public void testTryAcquire() throws InterruptedException {
        TimedSemaphore semaphore = new TimedSemaphore(500L, TimeUnit.SECONDS, 10);
        TryAcquireThread[] threads = new TryAcquireThread[30];
        CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new TryAcquireThread(semaphore, latch);
            threads[i].start();
        }
        latch.countDown();
        int permits = 0;
        for (TryAcquireThread t : threads) {
            t.join();
            if (!t.acquired) continue;
            ++permits;
        }
        Assertions.assertEquals((int)10, (int)permits, (String)"Wrong number of permits granted");
    }

    @Test
    public void testTryAcquireAfterShutdown() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        semaphore.shutdown();
        Assertions.assertThrows(IllegalStateException.class, () -> ((TimedSemaphore)semaphore).tryAcquire());
    }

    private static final class SemaphoreThread
    extends Thread {
        private final TimedSemaphore semaphore;
        private final CountDownLatch latch;
        private final int count;
        private final int latchCount;

        SemaphoreThread(TimedSemaphore b, CountDownLatch l, int c, int lc) {
            this.semaphore = b;
            this.latch = l;
            this.count = c;
            this.latchCount = lc;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    this.semaphore.acquire();
                    if (i >= this.latchCount) continue;
                    this.latch.countDown();
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class TimedSemaphoreTestImpl
    extends TimedSemaphore {
        ScheduledFuture<?> schedFuture;
        volatile CountDownLatch latch;
        private int periodEnds;

        TimedSemaphoreTestImpl(long timePeriod, TimeUnit timeUnit, int limit) {
            super(timePeriod, timeUnit, limit);
        }

        TimedSemaphoreTestImpl(ScheduledExecutorService service, long timePeriod, TimeUnit timeUnit, int limit) {
            super(service, timePeriod, timeUnit, limit);
        }

        public synchronized void acquire() throws InterruptedException {
            super.acquire();
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        protected synchronized void endOfPeriod() {
            super.endOfPeriod();
            ++this.periodEnds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getPeriodEnds() {
            TimedSemaphoreTestImpl timedSemaphoreTestImpl = this;
            synchronized (timedSemaphoreTestImpl) {
                return this.periodEnds;
            }
        }

        protected ScheduledFuture<?> startTimer() {
            return this.schedFuture != null ? this.schedFuture : super.startTimer();
        }
    }

    private static final class TryAcquireThread
    extends Thread {
        private final TimedSemaphore semaphore;
        private final CountDownLatch latch;
        private boolean acquired;

        TryAcquireThread(TimedSemaphore s, CountDownLatch l) {
            this.semaphore = s;
            this.latch = l;
        }

        @Override
        public void run() {
            try {
                if (this.latch.await(10L, TimeUnit.SECONDS)) {
                    this.acquired = this.semaphore.tryAcquire();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

