/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExportTask
extends Task {
    @NotNull
    static final String EXPORT_TASK_CLASS = "com.unboundid.directory.server.tasks.ExportTask";
    @NotNull
    private static final String ATTR_APPEND_TO_LDIF = "ds-task-export-append-to-ldif";
    @NotNull
    private static final String ATTR_BACKEND_ID = "ds-task-export-backend-id";
    @NotNull
    private static final String ATTR_COMPRESS = "ds-task-export-compress-ldif";
    @NotNull
    private static final String ATTR_ENCRYPT = "ds-task-export-encrypt-ldif";
    @NotNull
    private static final String ATTR_ENCRYPTION_PASSPHRASE_FILE = "ds-task-export-encryption-passphrase-file";
    @NotNull
    private static final String ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID = "ds-task-export-encryption-settings-definition-id";
    @NotNull
    private static final String ATTR_EXCLUDE_ATTRIBUTE = "ds-task-export-exclude-attribute";
    @NotNull
    private static final String ATTR_EXCLUDE_BRANCH = "ds-task-export-exclude-branch";
    @NotNull
    private static final String ATTR_EXCLUDE_FILTER = "ds-task-export-exclude-filter";
    @NotNull
    private static final String ATTR_INCLUDE_ATTRIBUTE = "ds-task-export-include-attribute";
    @NotNull
    private static final String ATTR_INCLUDE_BRANCH = "ds-task-export-include-branch";
    @NotNull
    private static final String ATTR_INCLUDE_FILTER = "ds-task-export-include-filter";
    @NotNull
    private static final String ATTR_LDIF_FILE = "ds-task-export-ldif-file";
    @NotNull
    private static final String ATTR_MAX_MEGABYTES_PER_SECOND = "ds-task-export-max-megabytes-per-second";
    @NotNull
    private static final String ATTR_SIGN = "ds-task-export-sign-hash";
    @NotNull
    private static final String ATTR_WRAP_COLUMN = "ds-task-export-wrap-column";
    @NotNull
    private static final String OC_EXPORT_TASK = "ds-task-export";
    @NotNull
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-export-backend-id", TaskMessages.INFO_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKEND_ID_EXPORT.get(), String.class, true, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_LDIF_FILE = new TaskProperty("ds-task-export-ldif-file", TaskMessages.INFO_DISPLAY_NAME_LDIF_FILE.get(), TaskMessages.INFO_DESCRIPTION_LDIF_FILE_EXPORT.get(), String.class, true, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_APPEND_TO_LDIF = new TaskProperty("ds-task-export-append-to-ldif", TaskMessages.INFO_DISPLAY_NAME_APPEND_TO_LDIF.get(), TaskMessages.INFO_DESCRIPTION_APPEND_TO_LDIF.get(), Boolean.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_INCLUDE_BRANCH = new TaskProperty("ds-task-export-include-branch", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_BRANCH_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_EXCLUDE_BRANCH = new TaskProperty("ds-task-export-exclude-branch", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_BRANCH_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_INCLUDE_FILTER = new TaskProperty("ds-task-export-include-filter", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_FILTER_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_EXCLUDE_FILTER = new TaskProperty("ds-task-export-exclude-filter", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_FILTER_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_INCLUDE_ATTRIBUTE = new TaskProperty("ds-task-export-include-attribute", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_ATTRIBUTE_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_EXCLUDE_ATTRIBUTE = new TaskProperty("ds-task-export-exclude-attribute", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_ATTRIBUTE_EXPORT.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_WRAP_COLUMN = new TaskProperty("ds-task-export-wrap-column", TaskMessages.INFO_DISPLAY_NAME_WRAP_COLUMN.get(), TaskMessages.INFO_DESCRIPTION_WRAP_COLUMN.get(), Long.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_COMPRESS = new TaskProperty("ds-task-export-compress-ldif", TaskMessages.INFO_DISPLAY_NAME_COMPRESS.get(), TaskMessages.INFO_DESCRIPTION_COMPRESS_EXPORT.get(), Boolean.class, false, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_ENCRYPT = new TaskProperty("ds-task-export-encrypt-ldif", TaskMessages.INFO_DISPLAY_NAME_ENCRYPT.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPT_EXPORT.get(), Boolean.class, false, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_ENCRYPTION_PASSPHRASE_FILE = new TaskProperty("ds-task-export-encryption-passphrase-file", TaskMessages.INFO_DISPLAY_NAME_ENCRYPTION_PASSPHRASE_FILE.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPTION_PASSPHRASE_FILE.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID = new TaskProperty("ds-task-export-encryption-settings-definition-id", TaskMessages.INFO_DISPLAY_NAME_ENCRYPTION_SETTINGS_DEFINITION_ID.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPTION_SETTINGS_DEFINITION_ID.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_SIGN = new TaskProperty("ds-task-export-sign-hash", TaskMessages.INFO_DISPLAY_NAME_SIGN.get(), TaskMessages.INFO_DESCRIPTION_SIGN_EXPORT.get(), Boolean.class, false, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_MAX_MEGABYTES_PER_SECOND = new TaskProperty("ds-task-export-max-megabytes-per-second", TaskMessages.INFO_DISPLAY_NAME_EXPORT_MAX_MEGABYTES_PER_SECOND.get(), TaskMessages.INFO_DESCRIPTION_EXPORT_MAX_MEGABYTES_PER_SECOND.get(), Long.class, false, false, true);
    private static final long serialVersionUID = -6807534587873728959L;
    private final boolean appendToLDIF;
    private final boolean compress;
    private final boolean encrypt;
    private final boolean sign;
    private final int wrapColumn;
    @Nullable
    private final Integer maxMegabytesPerSecond;
    @NotNull
    private final List<String> excludeAttributes;
    @NotNull
    private final List<String> excludeBranches;
    @NotNull
    private final List<String> excludeFilters;
    @NotNull
    private final List<String> includeAttributes;
    @NotNull
    private final List<String> includeBranches;
    @NotNull
    private final List<String> includeFilters;
    @NotNull
    private final String backendID;
    @Nullable
    private final String encryptionPassphraseFile;
    @Nullable
    private final String encryptionSettingsDefinitionID;
    @NotNull
    private final String ldifFile;

    public ExportTask() {
        this.appendToLDIF = false;
        this.compress = false;
        this.encrypt = false;
        this.sign = false;
        this.wrapColumn = -1;
        this.maxMegabytesPerSecond = null;
        this.encryptionPassphraseFile = null;
        this.encryptionSettingsDefinitionID = null;
        this.excludeAttributes = null;
        this.excludeBranches = null;
        this.excludeFilters = null;
        this.includeAttributes = null;
        this.includeBranches = null;
        this.includeFilters = null;
        this.backendID = null;
        this.ldifFile = null;
    }

    public ExportTask(@Nullable String taskID, @NotNull String backendID, @NotNull String ldifFile) {
        this(taskID, backendID, ldifFile, false, null, null, null, null, null, null, -1, false, false, false, null, null, null, null, null);
    }

    public ExportTask(@Nullable String taskID, @NotNull String backendID, @NotNull String ldifFile, boolean appendToLDIF, @Nullable List<String> includeBranches, @Nullable List<String> excludeBranches, @Nullable List<String> includeFilters, @Nullable List<String> excludeFilters, @Nullable List<String> includeAttributes, @Nullable List<String> excludeAttributes, int wrapColumn, boolean compress, boolean encrypt, boolean sign, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, backendID, ldifFile, appendToLDIF, includeBranches, excludeBranches, includeFilters, excludeFilters, includeAttributes, excludeAttributes, wrapColumn, compress, encrypt, null, null, sign, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public ExportTask(@Nullable String taskID, @NotNull String backendID, @NotNull String ldifFile, boolean appendToLDIF, @Nullable List<String> includeBranches, @Nullable List<String> excludeBranches, @Nullable List<String> includeFilters, @Nullable List<String> excludeFilters, @Nullable List<String> includeAttributes, @Nullable List<String> excludeAttributes, int wrapColumn, boolean compress, boolean encrypt, @Nullable String encryptionPassphraseFile, @Nullable String encryptionSettingsDefinitionID, boolean sign, @Nullable Integer maxMegabytesPerSecond, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, backendID, ldifFile, appendToLDIF, includeBranches, excludeBranches, includeFilters, excludeFilters, includeAttributes, excludeAttributes, wrapColumn, compress, encrypt, encryptionPassphraseFile, encryptionSettingsDefinitionID, sign, maxMegabytesPerSecond, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ExportTask(@Nullable String taskID, @NotNull String backendID, @NotNull String ldifFile, boolean appendToLDIF, @Nullable List<String> includeBranches, @Nullable List<String> excludeBranches, @Nullable List<String> includeFilters, @Nullable List<String> excludeFilters, @Nullable List<String> includeAttributes, @Nullable List<String> excludeAttributes, int wrapColumn, boolean compress, boolean encrypt, @Nullable String encryptionPassphraseFile, @Nullable String encryptionSettingsDefinitionID, boolean sign, @Nullable Integer maxMegabytesPerSecond, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, EXPORT_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(backendID, ldifFile);
        this.backendID = backendID;
        this.ldifFile = ldifFile;
        this.appendToLDIF = appendToLDIF;
        this.wrapColumn = wrapColumn;
        this.compress = compress;
        this.encrypt = encrypt;
        this.encryptionPassphraseFile = encryptionPassphraseFile;
        this.encryptionSettingsDefinitionID = encryptionSettingsDefinitionID;
        this.sign = sign;
        this.maxMegabytesPerSecond = maxMegabytesPerSecond;
        this.includeBranches = includeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(includeBranches);
        this.excludeBranches = excludeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(excludeBranches);
        this.includeFilters = includeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(includeFilters);
        this.excludeFilters = excludeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(excludeFilters);
        this.includeAttributes = includeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(includeAttributes);
        this.excludeAttributes = excludeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(excludeAttributes);
    }

    public ExportTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.backendID = entry.getAttributeValue(ATTR_BACKEND_ID);
        if (this.backendID == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_BACKEND_ID.get(this.getTaskEntryDN()));
        }
        this.ldifFile = entry.getAttributeValue(ATTR_LDIF_FILE);
        if (this.ldifFile == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_LDIF_FILE.get(this.getTaskEntryDN()));
        }
        this.appendToLDIF = ExportTask.parseBooleanValue(entry, ATTR_APPEND_TO_LDIF, false);
        this.includeBranches = ExportTask.parseStringList(entry, ATTR_INCLUDE_BRANCH);
        this.excludeBranches = ExportTask.parseStringList(entry, ATTR_EXCLUDE_BRANCH);
        this.includeFilters = ExportTask.parseStringList(entry, ATTR_INCLUDE_FILTER);
        this.excludeFilters = ExportTask.parseStringList(entry, ATTR_EXCLUDE_FILTER);
        this.includeAttributes = ExportTask.parseStringList(entry, ATTR_INCLUDE_ATTRIBUTE);
        this.excludeAttributes = ExportTask.parseStringList(entry, ATTR_EXCLUDE_ATTRIBUTE);
        String wrapStr = entry.getAttributeValue(ATTR_WRAP_COLUMN);
        if (wrapStr == null) {
            this.wrapColumn = -1;
        } else {
            try {
                this.wrapColumn = Integer.parseInt(wrapStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_EXPORT_TASK_CANNOT_PARSE_WRAP_COLUMN.get(this.getTaskEntryDN(), wrapStr), e);
            }
        }
        this.compress = ExportTask.parseBooleanValue(entry, ATTR_COMPRESS, false);
        this.encrypt = ExportTask.parseBooleanValue(entry, ATTR_ENCRYPT, false);
        this.encryptionPassphraseFile = entry.getAttributeValue(ATTR_ENCRYPTION_PASSPHRASE_FILE);
        this.encryptionSettingsDefinitionID = entry.getAttributeValue(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID);
        this.sign = ExportTask.parseBooleanValue(entry, ATTR_SIGN, false);
        this.maxMegabytesPerSecond = entry.getAttributeValueAsInteger(ATTR_MAX_MEGABYTES_PER_SECOND);
    }

    public ExportTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(EXPORT_TASK_CLASS, properties);
        boolean a = false;
        boolean c = false;
        boolean e = false;
        boolean s = false;
        Integer maxMB = null;
        long w = 0L;
        String b = null;
        String encID = null;
        String encPWFile = null;
        String l = null;
        String[] eA = StaticUtils.NO_STRINGS;
        String[] eB = StaticUtils.NO_STRINGS;
        String[] eF = StaticUtils.NO_STRINGS;
        String[] iA = StaticUtils.NO_STRINGS;
        String[] iB = StaticUtils.NO_STRINGS;
        String[] iF = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                b = ExportTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_LDIF_FILE)) {
                l = ExportTask.parseString(p, values, l);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_APPEND_TO_LDIF)) {
                a = ExportTask.parseBoolean(p, values, a);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_BRANCH)) {
                iB = ExportTask.parseStrings(p, values, iB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_BRANCH)) {
                eB = ExportTask.parseStrings(p, values, eB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_FILTER)) {
                iF = ExportTask.parseStrings(p, values, iF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_FILTER)) {
                eF = ExportTask.parseStrings(p, values, eF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_ATTRIBUTE)) {
                iA = ExportTask.parseStrings(p, values, iA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_ATTRIBUTE)) {
                eA = ExportTask.parseStrings(p, values, eA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_WRAP_COLUMN)) {
                w = ExportTask.parseLong(p, values, w);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_COMPRESS)) {
                c = ExportTask.parseBoolean(p, values, c);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPT)) {
                e = ExportTask.parseBoolean(p, values, e);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPTION_PASSPHRASE_FILE)) {
                encPWFile = ExportTask.parseString(p, values, encPWFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID)) {
                encID = ExportTask.parseString(p, values, encID);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SIGN)) {
                s = ExportTask.parseBoolean(p, values, s);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_MAX_MEGABYTES_PER_SECOND)) continue;
            Long maxMBLong = ExportTask.parseLong(p, values, null);
            if (maxMBLong == null) {
                maxMB = null;
                continue;
            }
            maxMB = maxMBLong.intValue();
        }
        if (b == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_BACKEND_ID.get(this.getTaskEntryDN()));
        }
        if (l == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_LDIF_FILE.get(this.getTaskEntryDN()));
        }
        this.backendID = b;
        this.ldifFile = l;
        this.appendToLDIF = a;
        this.includeAttributes = Collections.unmodifiableList(Arrays.asList(iA));
        this.excludeAttributes = Collections.unmodifiableList(Arrays.asList(eA));
        this.includeBranches = Collections.unmodifiableList(Arrays.asList(iB));
        this.excludeBranches = Collections.unmodifiableList(Arrays.asList(eB));
        this.includeFilters = Collections.unmodifiableList(Arrays.asList(iF));
        this.excludeFilters = Collections.unmodifiableList(Arrays.asList(eF));
        this.wrapColumn = (int)w;
        this.compress = c;
        this.encrypt = e;
        this.encryptionPassphraseFile = encPWFile;
        this.encryptionSettingsDefinitionID = encID;
        this.sign = s;
        this.maxMegabytesPerSecond = maxMB;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_EXPORT.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_EXPORT.get();
    }

    @NotNull
    public String getBackendID() {
        return this.backendID;
    }

    @NotNull
    public String getLDIFFile() {
        return this.ldifFile;
    }

    public boolean appendToLDIF() {
        return this.appendToLDIF;
    }

    @NotNull
    public List<String> getIncludeBranches() {
        return this.includeBranches;
    }

    @NotNull
    public List<String> getExcludeBranches() {
        return this.excludeBranches;
    }

    @NotNull
    public List<String> getIncludeFilters() {
        return this.includeFilters;
    }

    @NotNull
    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    @NotNull
    public List<String> getIncludeAttributes() {
        return this.includeAttributes;
    }

    @NotNull
    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public boolean compress() {
        return this.compress;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    @Nullable
    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    @Nullable
    public String getEncryptionSettingsDefinitionID() {
        return this.encryptionSettingsDefinitionID;
    }

    public boolean sign() {
        return this.sign;
    }

    @Nullable
    public Integer getMaxMegabytesPerSecond() {
        return this.maxMegabytesPerSecond;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_EXPORT_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(20);
        attrs.add(new Attribute(ATTR_BACKEND_ID, this.backendID));
        attrs.add(new Attribute(ATTR_LDIF_FILE, this.ldifFile));
        attrs.add(new Attribute(ATTR_APPEND_TO_LDIF, String.valueOf(this.appendToLDIF)));
        attrs.add(new Attribute(ATTR_COMPRESS, String.valueOf(this.compress)));
        attrs.add(new Attribute(ATTR_ENCRYPT, String.valueOf(this.encrypt)));
        attrs.add(new Attribute(ATTR_SIGN, String.valueOf(this.sign)));
        if (!this.includeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_BRANCH, this.includeBranches));
        }
        if (!this.excludeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_BRANCH, this.excludeBranches));
        }
        if (!this.includeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_ATTRIBUTE, this.includeAttributes));
        }
        if (!this.excludeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_ATTRIBUTE, this.excludeAttributes));
        }
        if (!this.includeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_FILTER, this.includeFilters));
        }
        if (!this.excludeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_FILTER, this.excludeFilters));
        }
        if (this.wrapColumn > 0) {
            attrs.add(new Attribute(ATTR_WRAP_COLUMN, String.valueOf(this.wrapColumn)));
        }
        if (this.encryptionPassphraseFile != null) {
            attrs.add(new Attribute(ATTR_ENCRYPTION_PASSPHRASE_FILE, this.encryptionPassphraseFile));
        }
        if (this.encryptionSettingsDefinitionID != null) {
            attrs.add(new Attribute(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID, this.encryptionSettingsDefinitionID));
        }
        if (this.maxMegabytesPerSecond != null) {
            attrs.add(new Attribute(ATTR_MAX_MEGABYTES_PER_SECOND, String.valueOf(this.maxMegabytesPerSecond)));
        }
        return attrs;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKEND_ID, PROPERTY_LDIF_FILE, PROPERTY_APPEND_TO_LDIF, PROPERTY_INCLUDE_BRANCH, PROPERTY_EXCLUDE_BRANCH, PROPERTY_INCLUDE_FILTER, PROPERTY_EXCLUDE_FILTER, PROPERTY_INCLUDE_ATTRIBUTE, PROPERTY_EXCLUDE_ATTRIBUTE, PROPERTY_WRAP_COLUMN, PROPERTY_COMPRESS, PROPERTY_ENCRYPT, PROPERTY_ENCRYPTION_PASSPHRASE_FILE, PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, PROPERTY_SIGN, PROPERTY_MAX_MEGABYTES_PER_SECOND);
        return Collections.unmodifiableList(propList);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(30));
        props.put(PROPERTY_BACKEND_ID, Collections.singletonList(this.backendID));
        props.put(PROPERTY_LDIF_FILE, Collections.singletonList(this.ldifFile));
        props.put(PROPERTY_APPEND_TO_LDIF, Collections.singletonList(this.appendToLDIF));
        props.put(PROPERTY_INCLUDE_BRANCH, Collections.unmodifiableList(this.includeBranches));
        props.put(PROPERTY_EXCLUDE_BRANCH, Collections.unmodifiableList(this.excludeBranches));
        props.put(PROPERTY_INCLUDE_FILTER, Collections.unmodifiableList(this.includeFilters));
        props.put(PROPERTY_EXCLUDE_FILTER, Collections.unmodifiableList(this.excludeFilters));
        props.put(PROPERTY_INCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.includeAttributes));
        props.put(PROPERTY_EXCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.excludeAttributes));
        props.put(PROPERTY_WRAP_COLUMN, Collections.singletonList(Long.valueOf(this.wrapColumn)));
        props.put(PROPERTY_COMPRESS, Collections.singletonList(this.compress));
        props.put(PROPERTY_ENCRYPT, Collections.singletonList(this.encrypt));
        if (this.encryptionPassphraseFile == null) {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.emptyList());
        } else {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.singletonList(this.encryptionPassphraseFile));
        }
        if (this.encryptionSettingsDefinitionID == null) {
            props.put(PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, Collections.singletonList(this.encryptionSettingsDefinitionID));
        }
        props.put(PROPERTY_SIGN, Collections.singletonList(this.sign));
        if (this.maxMegabytesPerSecond == null) {
            props.put(PROPERTY_MAX_MEGABYTES_PER_SECOND, Collections.emptyList());
        } else {
            props.put(PROPERTY_MAX_MEGABYTES_PER_SECOND, Collections.singletonList(this.maxMegabytesPerSecond.longValue()));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

