/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.valueconverter;

import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class UIDtoStringConverter
implements IValueConverter<String> {
    private static final String SEPARATOR = ":";

    public String toValue(String string, INode node) throws ValueConverterException {
        if (string == null) {
            return null;
        }
        CharSequence[] ids = string.split(SEPARATOR);
        int i = 0;
        while (i < ids.length) {
            CharSequence id = ids[i];
            if (id != null && ((String)id).startsWith("\"") && ((String)id).endsWith("\"")) {
                try {
                    ids[i] = Strings.convertFromJavaString((String)((String)id).substring(1, ((String)id).length() - 1), (boolean)true);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }
            ++i;
        }
        return String.join((CharSequence)SEPARATOR, ids);
    }

    public String toString(String value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        CharSequence[] ids = value.split(SEPARATOR);
        int i = 0;
        while (i < ids.length) {
            CharSequence id = ids[i];
            if (id != null && !((String)id).matches("[A-Za-z0-9_]*")) {
                ids[i] = this.toEscapedString((String)id);
            }
            ++i;
        }
        return String.join((CharSequence)SEPARATOR, ids);
    }

    protected String toEscapedString(String value) {
        return "\"" + Strings.convertToJavaString((String)value, (boolean)false) + "\"";
    }
}

