/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.calendar.ZoneInfo;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;
import sun.util.resources.ParallelListResourceBundle;
import sun.util.resources.TimeZoneNamesBundle;

public class LocaleResources {
    private final Locale locale;
    private final LocaleData localeData;
    private final LocaleProviderAdapter.Type type;
    private ConcurrentMap<String, ResourceReference> cache = new ConcurrentHashMap<String, ResourceReference>();
    private ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private static final String BREAK_ITERATOR_INFO = "BII.";
    private static final String CALENDAR_DATA = "CALD.";
    private static final String COLLATION_DATA_CACHEKEY = "COLD";
    private static final String DECIMAL_FORMAT_SYMBOLS_DATA_CACHEKEY = "DFSD";
    private static final String CURRENCY_NAMES = "CN.";
    private static final String LOCALE_NAMES = "LN.";
    private static final String TIME_ZONE_NAMES = "TZN.";
    private static final String ZONE_IDS_CACHEKEY = "ZID";
    private static final String CALENDAR_NAMES = "CALN.";
    private static final String NUMBER_PATTERNS_CACHEKEY = "NP";
    private static final String DATE_TIME_PATTERN = "DTP.";
    private static final Object NULLOBJECT = new Object();

    LocaleResources(ResourceBundleBasedAdapter resourceBundleBasedAdapter, Locale locale) {
        this.locale = locale;
        this.localeData = resourceBundleBasedAdapter.getLocaleData();
        this.type = ((LocaleProviderAdapter)((Object)resourceBundleBasedAdapter)).getAdapterType();
    }

    private void removeEmptyReferences() {
        Reference<Object> reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            this.cache.remove(((ResourceReference)reference).getCacheKey());
        }
    }

    Object getBreakIteratorInfo(String string) {
        Object object;
        String string2 = BREAK_ITERATOR_INFO + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if (resourceReference == null || (object = resourceReference.get()) == null) {
            object = this.localeData.getBreakIteratorInfo(this.locale).getObject(string);
            this.cache.put(string2, new ResourceReference(string2, object, this.referenceQueue));
        }
        return object;
    }

    int getCalendarData(String string) {
        Integer n;
        String string2 = CALENDAR_DATA + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if (resourceReference == null || (n = (Integer)resourceReference.get()) == null) {
            ResourceBundle resourceBundle = this.localeData.getCalendarData(this.locale);
            n = resourceBundle.containsKey(string) ? Integer.valueOf(Integer.parseInt(resourceBundle.getString(string))) : Integer.valueOf(0);
            this.cache.put(string2, new ResourceReference(string2, n, this.referenceQueue));
        }
        return n;
    }

    public String getCollationData() {
        String string = "Rule";
        String string2 = "";
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(COLLATION_DATA_CACHEKEY);
        if (resourceReference == null || (string2 = (String)resourceReference.get()) == null) {
            ResourceBundle resourceBundle = this.localeData.getCollationData(this.locale);
            if (resourceBundle.containsKey(string)) {
                string2 = resourceBundle.getString(string);
            }
            this.cache.put(COLLATION_DATA_CACHEKEY, new ResourceReference(COLLATION_DATA_CACHEKEY, string2, this.referenceQueue));
        }
        return string2;
    }

    public Object[] getDecimalFormatSymbolsData() {
        Object[] objectArray;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(DECIMAL_FORMAT_SYMBOLS_DATA_CACHEKEY);
        if (resourceReference == null || (objectArray = (Object[])resourceReference.get()) == null) {
            String string;
            ResourceBundle resourceBundle = this.localeData.getNumberFormatData(this.locale);
            objectArray = new Object[3];
            String string2 = this.locale.getUnicodeLocaleType("nu");
            if (string2 != null && resourceBundle.containsKey(string = string2 + ".NumberElements")) {
                objectArray[0] = resourceBundle.getStringArray(string);
            }
            if (objectArray[0] == null && resourceBundle.containsKey("DefaultNumberingSystem") && resourceBundle.containsKey(string = resourceBundle.getString("DefaultNumberingSystem") + ".NumberElements")) {
                objectArray[0] = resourceBundle.getStringArray(string);
            }
            if (objectArray[0] == null) {
                objectArray[0] = resourceBundle.getStringArray("NumberElements");
            }
            this.cache.put(DECIMAL_FORMAT_SYMBOLS_DATA_CACHEKEY, new ResourceReference(DECIMAL_FORMAT_SYMBOLS_DATA_CACHEKEY, objectArray, this.referenceQueue));
        }
        return objectArray;
    }

    public String getCurrencyName(String string) {
        OpenListResourceBundle openListResourceBundle;
        Object object = null;
        String string2 = CURRENCY_NAMES + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if (resourceReference != null) {
            Object t = resourceReference.get();
            object = t;
            if (t != null) {
                if (object.equals(NULLOBJECT)) {
                    object = null;
                }
                return (String)object;
            }
        }
        if ((openListResourceBundle = this.localeData.getCurrencyNames(this.locale)).containsKey(string)) {
            object = openListResourceBundle.getObject(string);
            this.cache.put(string2, new ResourceReference(string2, object, this.referenceQueue));
        }
        return (String)object;
    }

    public String getLocaleName(String string) {
        OpenListResourceBundle openListResourceBundle;
        Object object = null;
        String string2 = LOCALE_NAMES + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if (resourceReference != null) {
            Object t = resourceReference.get();
            object = t;
            if (t != null) {
                if (object.equals(NULLOBJECT)) {
                    object = null;
                }
                return (String)object;
            }
        }
        if ((openListResourceBundle = this.localeData.getLocaleNames(this.locale)).containsKey(string)) {
            object = openListResourceBundle.getObject(string);
            this.cache.put(string2, new ResourceReference(string2, object, this.referenceQueue));
        }
        return (String)object;
    }

    String[] getTimeZoneNames(String string) {
        TimeZoneNamesBundle timeZoneNamesBundle;
        String[] stringArray = null;
        String string2 = "TZN.." + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if ((Objects.isNull(resourceReference) || Objects.isNull(stringArray = (String[])resourceReference.get())) && (timeZoneNamesBundle = this.localeData.getTimeZoneNames(this.locale)).containsKey(string)) {
            stringArray = timeZoneNamesBundle.getStringArray(string);
            this.cache.put(string2, new ResourceReference(string2, stringArray, this.referenceQueue));
        }
        return stringArray;
    }

    Set<String> getZoneIDs() {
        Set<String> set = null;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(ZONE_IDS_CACHEKEY);
        if (resourceReference == null || (set = (Set<String>)resourceReference.get()) == null) {
            TimeZoneNamesBundle timeZoneNamesBundle = this.localeData.getTimeZoneNames(this.locale);
            set = timeZoneNamesBundle.keySet();
            this.cache.put(ZONE_IDS_CACHEKEY, new ResourceReference(ZONE_IDS_CACHEKEY, set, this.referenceQueue));
        }
        return set;
    }

    String[][] getZoneStrings() {
        TimeZoneNamesBundle timeZoneNamesBundle = this.localeData.getTimeZoneNames(this.locale);
        Set<String> set = this.getZoneIDs();
        LinkedHashSet<String[]> linkedHashSet = new LinkedHashSet<String[]>();
        for (String object : set) {
            linkedHashSet.add(timeZoneNamesBundle.getStringArray(object));
        }
        if (this.type == LocaleProviderAdapter.Type.CLDR) {
            Map<String, String> map = ZoneInfo.getAliasTable();
            for (String string : map.keySet()) {
                String string2;
                if (set.contains(string) || !set.contains(string2 = (String)map.get(string))) continue;
                String[] stringArray = timeZoneNamesBundle.getStringArray(string2);
                stringArray[0] = string;
                linkedHashSet.add(stringArray);
            }
        }
        return (String[][])linkedHashSet.toArray((T[])new String[0][]);
    }

    String[] getCalendarNames(String string) {
        ResourceBundle resourceBundle;
        String[] stringArray = null;
        String string2 = CALENDAR_NAMES + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if ((resourceReference == null || (stringArray = (String[])resourceReference.get()) == null) && (resourceBundle = this.localeData.getDateFormatData(this.locale)).containsKey(string)) {
            stringArray = resourceBundle.getStringArray(string);
            this.cache.put(string2, new ResourceReference(string2, stringArray, this.referenceQueue));
        }
        return stringArray;
    }

    String[] getJavaTimeNames(String string) {
        ResourceBundle resourceBundle;
        String[] stringArray = null;
        String string2 = CALENDAR_NAMES + string;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string2);
        if ((resourceReference == null || (stringArray = (String[])resourceReference.get()) == null) && (resourceBundle = this.getJavaTimeFormatData()).containsKey(string)) {
            stringArray = resourceBundle.getStringArray(string);
            this.cache.put(string2, new ResourceReference(string2, stringArray, this.referenceQueue));
        }
        return stringArray;
    }

    public String getDateTimePattern(int n, int n2, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance(this.locale);
        }
        return this.getDateTimePattern(null, n, n2, calendar.getCalendarType());
    }

    public String getJavaTimeDateTimePattern(int n, int n2, String string) {
        String string2 = this.getDateTimePattern("java.time.", n, n2, string = CalendarDataUtility.normalizeCalendarType(string));
        if (string2 == null) {
            string2 = this.getDateTimePattern(null, n, n2, string);
        }
        return string2;
    }

    private String getDateTimePattern(String string, int n, int n2, String string2) {
        String string3;
        String string4 = null;
        String string5 = null;
        if (n >= 0) {
            if (string != null) {
                string4 = this.getDateTimePattern(string, "TimePatterns", n, string2);
            }
            if (string4 == null) {
                string4 = this.getDateTimePattern(null, "TimePatterns", n, string2);
            }
        }
        if (n2 >= 0) {
            if (string != null) {
                string5 = this.getDateTimePattern(string, "DatePatterns", n2, string2);
            }
            if (string5 == null) {
                string5 = this.getDateTimePattern(null, "DatePatterns", n2, string2);
            }
        }
        if (n >= 0) {
            if (n2 >= 0) {
                String string6 = null;
                if (string != null) {
                    string6 = this.getDateTimePattern(string, "DateTimePatterns", 0, string2);
                }
                if (string6 == null) {
                    string6 = this.getDateTimePattern(null, "DateTimePatterns", 0, string2);
                }
                switch (string6) {
                    case "{1} {0}": {
                        string3 = string5 + " " + string4;
                        break;
                    }
                    case "{0} {1}": {
                        string3 = string4 + " " + string5;
                        break;
                    }
                    default: {
                        string3 = MessageFormat.format(string6, string4, string5);
                        break;
                    }
                }
            } else {
                string3 = string4;
            }
        } else if (n2 >= 0) {
            string3 = string5;
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        return string3;
    }

    public String[] getNumberPatterns() {
        String[] stringArray = null;
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(NUMBER_PATTERNS_CACHEKEY);
        if (resourceReference == null || (stringArray = (String[])resourceReference.get()) == null) {
            ResourceBundle resourceBundle = this.localeData.getNumberFormatData(this.locale);
            stringArray = resourceBundle.getStringArray("NumberPatterns");
            this.cache.put(NUMBER_PATTERNS_CACHEKEY, new ResourceReference(NUMBER_PATTERNS_CACHEKEY, stringArray, this.referenceQueue));
        }
        return stringArray;
    }

    public ResourceBundle getJavaTimeFormatData() {
        ResourceBundle resourceBundle = this.localeData.getDateFormatData(this.locale);
        if (resourceBundle instanceof ParallelListResourceBundle) {
            this.localeData.setSupplementary((ParallelListResourceBundle)resourceBundle);
        }
        return resourceBundle;
    }

    private String getDateTimePattern(String string, String string2, int n, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (!"gregory".equals(string3)) {
            stringBuilder.append(string3).append('.');
        }
        stringBuilder.append(string2);
        String string4 = stringBuilder.toString();
        String string5 = stringBuilder.insert(0, DATE_TIME_PATTERN).toString();
        this.removeEmptyReferences();
        ResourceReference resourceReference = (ResourceReference)this.cache.get(string5);
        String[] stringArray = NULLOBJECT;
        if (resourceReference == null || (stringArray = resourceReference.get()) == null) {
            ResourceBundle resourceBundle;
            ResourceBundle resourceBundle2 = resourceBundle = string != null ? this.getJavaTimeFormatData() : this.localeData.getDateFormatData(this.locale);
            if (resourceBundle.containsKey(string4)) {
                stringArray = resourceBundle.getStringArray(string4);
            } else {
                assert (!string4.equals(string2));
                if (resourceBundle.containsKey(string2)) {
                    stringArray = resourceBundle.getStringArray(string2);
                }
            }
            this.cache.put(string5, new ResourceReference(string5, stringArray, this.referenceQueue));
        }
        if (stringArray == NULLOBJECT) {
            assert (string != null);
            return null;
        }
        return ((String[])stringArray)[n];
    }

    private static class ResourceReference
    extends SoftReference<Object> {
        private final String cacheKey;

        ResourceReference(String string, Object object, ReferenceQueue<Object> referenceQueue) {
            super(object, referenceQueue);
            this.cacheKey = string;
        }

        String getCacheKey() {
            return this.cacheKey;
        }
    }
}

