//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckerrordomain?language=objc)
    pub static CKErrorDomain: &'static NSString;
}

extern "C" {
    /// When a CKErrorPartialFailure happens this key will be set in the error's userInfo dictionary.
    ///
    ///
    /// The value of this key will be a dictionary, and the values will be errors for individual items with the keys being the item IDs that failed.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckpartialerrorsbyitemidkey?language=objc)
    pub static CKPartialErrorsByItemIDKey: &'static NSString;
}

extern "C" {
    /// If the server rejects a record save because it has been modified since the last time it was read,
    /// a
    /// `CKErrorServerRecordChanged`will be returned.  The error's
    /// `userInfo`dictionary will contain
    /// a
    /// `CKRecord`keyed by
    /// `CKRecordChangedErrorAncestorRecordKey.`This is the original
    /// record used as a basis for making your changes.
    ///
    /// Note that if you had attempted to save a new
    /// `CKRecord`instance, this record may not have any
    /// key / value pairs set on it, as there was no
    /// `CKRecord`instance that represents an ancestor point.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckrecordchangederrorancestorrecordkey?language=objc)
    pub static CKRecordChangedErrorAncestorRecordKey: &'static NSString;
}

extern "C" {
    /// If the server rejects a record save because it has been modified since the last time it was read,
    /// a
    /// `CKErrorServerRecordChanged`will be returned.  The error's
    /// `userInfo`dictionary will contain
    /// a
    /// `CKRecord`keyed by
    /// `CKRecordChangedErrorServerRecordKey.`This is the record
    /// object that was found on the server.
    ///
    /// Use this record as the basis for merging your changes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckrecordchangederrorserverrecordkey?language=objc)
    pub static CKRecordChangedErrorServerRecordKey: &'static NSString;
}

extern "C" {
    /// If the server rejects a record save because it has been modified since the last time it was read,
    /// a
    /// `CKErrorServerRecordChanged`will be returned.  The error's
    /// `userInfo`dictionary will contain
    /// a
    /// `CKRecord`keyed by
    /// `CKRecordChangedErrorClientRecordKey.`This is the record
    /// object that you tried to save.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckrecordchangederrorclientrecordkey?language=objc)
    pub static CKRecordChangedErrorClientRecordKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckerroruserdidresetencrypteddatakey?language=objc)
    pub static CKErrorUserDidResetEncryptedDataKey: &'static NSString;
}

extern "C" {
    /// On some errors, the userInfo dictionary may contain a NSNumber instance that specifies the period of time in seconds after which the client may retry the request. For example, this key will be on
    /// `CKErrorServiceUnavailable,``CKErrorRequestRateLimited,`and other errors for which the recommended resolution is to retry after a delay.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckerrorretryafterkey?language=objc)
    pub static CKErrorRetryAfterKey: &'static NSString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckerrorcode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKErrorCode(pub NSInteger);
impl CKErrorCode {
    /// CloudKit.framework encountered an error.  This is a non-recoverable error.
    #[doc(alias = "CKErrorInternalError")]
    pub const InternalError: Self = Self(1);
    /// Some items failed, but the operation succeeded overall. Check CKPartialErrorsByItemIDKey in the userInfo dictionary for more details.
    /// This error is only returned from CKOperation completion blocks, which are deprecated in swift.
    /// It will not be returned from (swift-only) CKOperation result blocks, which are their replacements
    #[doc(alias = "CKErrorPartialFailure")]
    pub const PartialFailure: Self = Self(2);
    /// Network not available
    #[doc(alias = "CKErrorNetworkUnavailable")]
    pub const NetworkUnavailable: Self = Self(3);
    /// Network error (available but CFNetwork gave us an error)
    #[doc(alias = "CKErrorNetworkFailure")]
    pub const NetworkFailure: Self = Self(4);
    /// Un-provisioned or unauthorized container. Try provisioning the container before retrying the operation.
    #[doc(alias = "CKErrorBadContainer")]
    pub const BadContainer: Self = Self(5);
    /// Service unavailable
    #[doc(alias = "CKErrorServiceUnavailable")]
    pub const ServiceUnavailable: Self = Self(6);
    /// Client is being rate limited
    #[doc(alias = "CKErrorRequestRateLimited")]
    pub const RequestRateLimited: Self = Self(7);
    /// Missing entitlement
    #[doc(alias = "CKErrorMissingEntitlement")]
    pub const MissingEntitlement: Self = Self(8);
    /// Not authenticated (writing without being logged in, no user record)
    #[doc(alias = "CKErrorNotAuthenticated")]
    pub const NotAuthenticated: Self = Self(9);
    /// Access failure (save, fetch, or shareAccept)
    #[doc(alias = "CKErrorPermissionFailure")]
    pub const PermissionFailure: Self = Self(10);
    /// Record does not exist
    #[doc(alias = "CKErrorUnknownItem")]
    pub const UnknownItem: Self = Self(11);
    /// Bad client request (bad record graph, malformed predicate)
    #[doc(alias = "CKErrorInvalidArguments")]
    pub const InvalidArguments: Self = Self(12);
    /// Bad client request (bad record graph, malformed predicate)
    #[doc(alias = "CKErrorResultsTruncated")]
    #[deprecated = "Will not be returned"]
    pub const ResultsTruncated: Self = Self(13);
    /// The record was rejected because the version on the server was different
    #[doc(alias = "CKErrorServerRecordChanged")]
    pub const ServerRecordChanged: Self = Self(14);
    /// The server rejected this request. This is a non-recoverable error
    #[doc(alias = "CKErrorServerRejectedRequest")]
    pub const ServerRejectedRequest: Self = Self(15);
    /// Asset file was not found
    #[doc(alias = "CKErrorAssetFileNotFound")]
    pub const AssetFileNotFound: Self = Self(16);
    /// Asset file content was modified while being saved
    #[doc(alias = "CKErrorAssetFileModified")]
    pub const AssetFileModified: Self = Self(17);
    /// App version is less than the minimum allowed version
    #[doc(alias = "CKErrorIncompatibleVersion")]
    pub const IncompatibleVersion: Self = Self(18);
    /// The server rejected the request because there was a conflict with a unique field.
    #[doc(alias = "CKErrorConstraintViolation")]
    pub const ConstraintViolation: Self = Self(19);
    /// A CKOperation was explicitly cancelled
    #[doc(alias = "CKErrorOperationCancelled")]
    pub const OperationCancelled: Self = Self(20);
    /// The previousServerChangeToken value is too old and the client must re-sync from scratch
    #[doc(alias = "CKErrorChangeTokenExpired")]
    pub const ChangeTokenExpired: Self = Self(21);
    /// One of the items in this batch operation failed in a zone with atomic updates, so the entire batch was rejected.
    #[doc(alias = "CKErrorBatchRequestFailed")]
    pub const BatchRequestFailed: Self = Self(22);
    /// The server is too busy to handle this zone operation. Try the operation again in a few seconds.
    #[doc(alias = "CKErrorZoneBusy")]
    pub const ZoneBusy: Self = Self(23);
    /// Operation could not be completed on the given database. Likely caused by attempting to modify zones in the public database.
    #[doc(alias = "CKErrorBadDatabase")]
    pub const BadDatabase: Self = Self(24);
    /// Saving a record would exceed quota
    #[doc(alias = "CKErrorQuotaExceeded")]
    pub const QuotaExceeded: Self = Self(25);
    /// The specified zone does not exist on the server
    #[doc(alias = "CKErrorZoneNotFound")]
    pub const ZoneNotFound: Self = Self(26);
    /// The request to the server was too large. Retry this request as a smaller batch.
    #[doc(alias = "CKErrorLimitExceeded")]
    pub const LimitExceeded: Self = Self(27);
    /// The user deleted this zone through the settings UI. Your client should either remove its local data or prompt the user before attempting to re-upload any data to this zone.
    #[doc(alias = "CKErrorUserDeletedZone")]
    pub const UserDeletedZone: Self = Self(28);
    /// A share cannot be saved because there are too many participants attached to the share
    #[doc(alias = "CKErrorTooManyParticipants")]
    pub const TooManyParticipants: Self = Self(29);
    /// A record/share cannot be saved, doing so would cause a hierarchy of records to exist in multiple shares
    #[doc(alias = "CKErrorAlreadyShared")]
    pub const AlreadyShared: Self = Self(30);
    /// The target of a record's parent or share reference was not found
    #[doc(alias = "CKErrorReferenceViolation")]
    pub const ReferenceViolation: Self = Self(31);
    /// Request was rejected due to a managed account restriction
    #[doc(alias = "CKErrorManagedAccountRestricted")]
    pub const ManagedAccountRestricted: Self = Self(32);
    /// Share Metadata cannot be determined, because the user is not a member of the share.  There are invited participants on the share with email addresses or phone numbers not associated with any iCloud account. The user may be able to join the share if they can associate one of those email addresses or phone numbers with their iCloud account via the system Share Accept UI. Call UIApplication's openURL on this share URL to have the user attempt to verify their information.
    #[doc(alias = "CKErrorParticipantMayNeedVerification")]
    pub const ParticipantMayNeedVerification: Self = Self(33);
    /// The server received and processed this request, but the response was lost due to a network failure.  There is no guarantee that this request succeeded.  Your client should re-issue the request (if it is idempotent), or fetch data from the server to determine if the request succeeded.
    #[doc(alias = "CKErrorServerResponseLost")]
    pub const ServerResponseLost: Self = Self(34);
    /// The file for this asset could not be accessed. It is likely your application does not have permission to open the file, or the file may be temporarily unavailable due to its data protection class. This operation can be retried after it is able to be opened in your process.
    #[doc(alias = "CKErrorAssetNotAvailable")]
    pub const AssetNotAvailable: Self = Self(35);
    /// The current account is in a state that may need user intervention to recover from. The user should be directed to check the Settings app. Listen for CKAccountChangedNotifications to know when to re-check account status and retry.
    #[doc(alias = "CKErrorAccountTemporarilyUnavailable")]
    pub const AccountTemporarilyUnavailable: Self = Self(36);
    /// The user is already an invited participant on this share. They must accept the existing share invitation before continuing.
    #[doc(alias = "CKErrorParticipantAlreadyInvited")]
    pub const ParticipantAlreadyInvited: Self = Self(37);
}

unsafe impl Encode for CKErrorCode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKErrorCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
