/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.asamk.Signal;
import org.asamk.SignalControl;
import org.asamk.signal.dbus.DbusManagerImpl;
import org.asamk.signal.dbus.DbusProvisioningManagerImpl;
import org.asamk.signal.dbus.DbusRegistrationManagerImpl;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.RegistrationManager;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class DbusMultiAccountManagerImpl
implements MultiAccountManager {
    private final SignalControl signalControl;
    private final DBusConnection connection;
    private final Set<Consumer<Manager>> onManagerAddedHandlers = new HashSet<Consumer<Manager>>();
    private final Set<Consumer<Manager>> onManagerRemovedHandlers = new HashSet<Consumer<Manager>>();
    private final String busname;

    public DbusMultiAccountManagerImpl(SignalControl signalControl, DBusConnection connection, String busname) {
        this.signalControl = signalControl;
        this.connection = connection;
        this.busname = busname;
    }

    public List<String> getAccountNumbers() {
        return this.signalControl.listAccounts().stream().map(a -> this.getRemoteObject((DBusPath)a, (Class)Signal.class).getSelfNumber()).toList();
    }

    public List<Manager> getManagers() {
        return this.signalControl.listAccounts().stream().map(a -> new DbusManagerImpl(this.getRemoteObject((DBusPath)a, (Class)Signal.class), this.connection, this.busname)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnManagerAddedHandler(Consumer<Manager> handler) {
        Set<Consumer<Manager>> set = this.onManagerAddedHandlers;
        synchronized (set) {
            this.onManagerAddedHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnManagerRemovedHandler(Consumer<Manager> handler) {
        Set<Consumer<Manager>> set = this.onManagerRemovedHandlers;
        synchronized (set) {
            this.onManagerRemovedHandlers.add(handler);
        }
    }

    public Manager getManager(String phoneNumber) {
        return new DbusManagerImpl(this.getRemoteObject(this.signalControl.getAccount(phoneNumber), Signal.class), this.connection, this.busname);
    }

    public URI getNewProvisioningDeviceLinkUri() throws TimeoutException, IOException {
        try {
            return new URI(this.signalControl.startLink());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public ProvisioningManager getProvisioningManagerFor(URI deviceLinkUri) {
        return new DbusProvisioningManagerImpl(this.signalControl, this.connection, deviceLinkUri);
    }

    public RegistrationManager getNewRegistrationManager(String account) throws IOException {
        return new DbusRegistrationManagerImpl(account, this.signalControl, this.connection);
    }

    public void close() {
    }

    private <T extends DBusInterface> T getRemoteObject(DBusPath path, Class<T> type) {
        try {
            return (T)this.connection.getRemoteObject(this.busname, path.getPath(), type);
        }
        catch (DBusException e) {
            throw new AssertionError((Object)e);
        }
    }
}

