/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Arrays;
import java.util.Base64;
import org.asamk.signal.manager.api.GroupIdFormatException;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;

public abstract sealed class GroupId
permits GroupIdV1, GroupIdV2 {
    private final byte[] id;

    public static GroupIdV1 v1(byte[] id) {
        return new GroupIdV1(id);
    }

    public static GroupIdV2 v2(byte[] id) {
        return new GroupIdV2(id);
    }

    public static GroupId unknownVersion(byte[] id) {
        if (id.length == 16) {
            return new GroupIdV1(id);
        }
        if (id.length == 32) {
            return new GroupIdV2(id);
        }
        throw new AssertionError((Object)("Invalid group id of size " + id.length));
    }

    public static GroupId fromBase64(String id) throws GroupIdFormatException {
        try {
            return GroupId.unknownVersion(Base64.getDecoder().decode(id));
        }
        catch (Throwable e) {
            throw new GroupIdFormatException(id, e);
        }
    }

    protected GroupId(byte[] id) {
        this.id = id;
    }

    public byte[] serialize() {
        return this.id;
    }

    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupId groupId = (GroupId)o;
        return Arrays.equals(this.id, groupId.id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }
}

