use core::fmt::{self, Debug, Display, Formatter};
use core::str::FromStr;

use crate::timezone_impl::{TimeSpans, FixedTimespanSet, FixedTimespan};

/// TimeZones built at compile time from the tz database
///
/// This implements [`chrono::TimeZone`] so that it may be used in and to
/// construct chrono's DateTime type. See the root module documentation
/// for details.
#[derive(Clone, Copy, PartialEq, Eq, Hash)]
#[cfg_attr(feature = "arbitrary", derive(arbitrary::Arbitrary))]
pub enum Tz {
    /// Africa/Abidjan
    Africa__Abidjan,
    /// Africa/Accra
    Africa__Accra,
    /// Africa/Addis_Ababa
    Africa__Addis_Ababa,
    /// Africa/Algiers
    Africa__Algiers,
    /// Africa/Asmara
    Africa__Asmara,
    /// Africa/Asmera
    Africa__Asmera,
    /// Africa/Bamako
    Africa__Bamako,
    /// Africa/Bangui
    Africa__Bangui,
    /// Africa/Banjul
    Africa__Banjul,
    /// Africa/Bissau
    Africa__Bissau,
    /// Africa/Blantyre
    Africa__Blantyre,
    /// Africa/Brazzaville
    Africa__Brazzaville,
    /// Africa/Bujumbura
    Africa__Bujumbura,
    /// Africa/Cairo
    Africa__Cairo,
    /// Africa/Casablanca
    Africa__Casablanca,
    /// Africa/Ceuta
    Africa__Ceuta,
    /// Africa/Conakry
    Africa__Conakry,
    /// Africa/Dakar
    Africa__Dakar,
    /// Africa/Dar_es_Salaam
    Africa__Dar_es_Salaam,
    /// Africa/Djibouti
    Africa__Djibouti,
    /// Africa/Douala
    Africa__Douala,
    /// Africa/El_Aaiun
    Africa__El_Aaiun,
    /// Africa/Freetown
    Africa__Freetown,
    /// Africa/Gaborone
    Africa__Gaborone,
    /// Africa/Harare
    Africa__Harare,
    /// Africa/Johannesburg
    Africa__Johannesburg,
    /// Africa/Juba
    Africa__Juba,
    /// Africa/Kampala
    Africa__Kampala,
    /// Africa/Khartoum
    Africa__Khartoum,
    /// Africa/Kigali
    Africa__Kigali,
    /// Africa/Kinshasa
    Africa__Kinshasa,
    /// Africa/Lagos
    Africa__Lagos,
    /// Africa/Libreville
    Africa__Libreville,
    /// Africa/Lome
    Africa__Lome,
    /// Africa/Luanda
    Africa__Luanda,
    /// Africa/Lubumbashi
    Africa__Lubumbashi,
    /// Africa/Lusaka
    Africa__Lusaka,
    /// Africa/Malabo
    Africa__Malabo,
    /// Africa/Maputo
    Africa__Maputo,
    /// Africa/Maseru
    Africa__Maseru,
    /// Africa/Mbabane
    Africa__Mbabane,
    /// Africa/Mogadishu
    Africa__Mogadishu,
    /// Africa/Monrovia
    Africa__Monrovia,
    /// Africa/Nairobi
    Africa__Nairobi,
    /// Africa/Ndjamena
    Africa__Ndjamena,
    /// Africa/Niamey
    Africa__Niamey,
    /// Africa/Nouakchott
    Africa__Nouakchott,
    /// Africa/Ouagadougou
    Africa__Ouagadougou,
    /// Africa/Porto-Novo
    Africa__PortoNovo,
    /// Africa/Sao_Tome
    Africa__Sao_Tome,
    /// Africa/Timbuktu
    Africa__Timbuktu,
    /// Africa/Tripoli
    Africa__Tripoli,
    /// Africa/Tunis
    Africa__Tunis,
    /// Africa/Windhoek
    Africa__Windhoek,
    /// America/Adak
    America__Adak,
    /// America/Anchorage
    America__Anchorage,
    /// America/Anguilla
    America__Anguilla,
    /// America/Antigua
    America__Antigua,
    /// America/Araguaina
    America__Araguaina,
    /// America/Argentina/Buenos_Aires
    America__Argentina__Buenos_Aires,
    /// America/Argentina/Catamarca
    America__Argentina__Catamarca,
    /// America/Argentina/ComodRivadavia
    America__Argentina__ComodRivadavia,
    /// America/Argentina/Cordoba
    America__Argentina__Cordoba,
    /// America/Argentina/Jujuy
    America__Argentina__Jujuy,
    /// America/Argentina/La_Rioja
    America__Argentina__La_Rioja,
    /// America/Argentina/Mendoza
    America__Argentina__Mendoza,
    /// America/Argentina/Rio_Gallegos
    America__Argentina__Rio_Gallegos,
    /// America/Argentina/Salta
    America__Argentina__Salta,
    /// America/Argentina/San_Juan
    America__Argentina__San_Juan,
    /// America/Argentina/San_Luis
    America__Argentina__San_Luis,
    /// America/Argentina/Tucuman
    America__Argentina__Tucuman,
    /// America/Argentina/Ushuaia
    America__Argentina__Ushuaia,
    /// America/Aruba
    America__Aruba,
    /// America/Asuncion
    America__Asuncion,
    /// America/Atikokan
    America__Atikokan,
    /// America/Atka
    America__Atka,
    /// America/Bahia
    America__Bahia,
    /// America/Bahia_Banderas
    America__Bahia_Banderas,
    /// America/Barbados
    America__Barbados,
    /// America/Belem
    America__Belem,
    /// America/Belize
    America__Belize,
    /// America/Blanc-Sablon
    America__BlancSablon,
    /// America/Boa_Vista
    America__Boa_Vista,
    /// America/Bogota
    America__Bogota,
    /// America/Boise
    America__Boise,
    /// America/Buenos_Aires
    America__Buenos_Aires,
    /// America/Cambridge_Bay
    America__Cambridge_Bay,
    /// America/Campo_Grande
    America__Campo_Grande,
    /// America/Cancun
    America__Cancun,
    /// America/Caracas
    America__Caracas,
    /// America/Catamarca
    America__Catamarca,
    /// America/Cayenne
    America__Cayenne,
    /// America/Cayman
    America__Cayman,
    /// America/Chicago
    America__Chicago,
    /// America/Chihuahua
    America__Chihuahua,
    /// America/Ciudad_Juarez
    America__Ciudad_Juarez,
    /// America/Coral_Harbour
    America__Coral_Harbour,
    /// America/Cordoba
    America__Cordoba,
    /// America/Costa_Rica
    America__Costa_Rica,
    /// America/Coyhaique
    America__Coyhaique,
    /// America/Creston
    America__Creston,
    /// America/Cuiaba
    America__Cuiaba,
    /// America/Curacao
    America__Curacao,
    /// America/Danmarkshavn
    America__Danmarkshavn,
    /// America/Dawson
    America__Dawson,
    /// America/Dawson_Creek
    America__Dawson_Creek,
    /// America/Denver
    America__Denver,
    /// America/Detroit
    America__Detroit,
    /// America/Dominica
    America__Dominica,
    /// America/Edmonton
    America__Edmonton,
    /// America/Eirunepe
    America__Eirunepe,
    /// America/El_Salvador
    America__El_Salvador,
    /// America/Ensenada
    America__Ensenada,
    /// America/Fort_Nelson
    America__Fort_Nelson,
    /// America/Fort_Wayne
    America__Fort_Wayne,
    /// America/Fortaleza
    America__Fortaleza,
    /// America/Glace_Bay
    America__Glace_Bay,
    /// America/Godthab
    America__Godthab,
    /// America/Goose_Bay
    America__Goose_Bay,
    /// America/Grand_Turk
    America__Grand_Turk,
    /// America/Grenada
    America__Grenada,
    /// America/Guadeloupe
    America__Guadeloupe,
    /// America/Guatemala
    America__Guatemala,
    /// America/Guayaquil
    America__Guayaquil,
    /// America/Guyana
    America__Guyana,
    /// America/Halifax
    America__Halifax,
    /// America/Havana
    America__Havana,
    /// America/Hermosillo
    America__Hermosillo,
    /// America/Indiana/Indianapolis
    America__Indiana__Indianapolis,
    /// America/Indiana/Knox
    America__Indiana__Knox,
    /// America/Indiana/Marengo
    America__Indiana__Marengo,
    /// America/Indiana/Petersburg
    America__Indiana__Petersburg,
    /// America/Indiana/Tell_City
    America__Indiana__Tell_City,
    /// America/Indiana/Vevay
    America__Indiana__Vevay,
    /// America/Indiana/Vincennes
    America__Indiana__Vincennes,
    /// America/Indiana/Winamac
    America__Indiana__Winamac,
    /// America/Indianapolis
    America__Indianapolis,
    /// America/Inuvik
    America__Inuvik,
    /// America/Iqaluit
    America__Iqaluit,
    /// America/Jamaica
    America__Jamaica,
    /// America/Jujuy
    America__Jujuy,
    /// America/Juneau
    America__Juneau,
    /// America/Kentucky/Louisville
    America__Kentucky__Louisville,
    /// America/Kentucky/Monticello
    America__Kentucky__Monticello,
    /// America/Knox_IN
    America__Knox_IN,
    /// America/Kralendijk
    America__Kralendijk,
    /// America/La_Paz
    America__La_Paz,
    /// America/Lima
    America__Lima,
    /// America/Los_Angeles
    America__Los_Angeles,
    /// America/Louisville
    America__Louisville,
    /// America/Lower_Princes
    America__Lower_Princes,
    /// America/Maceio
    America__Maceio,
    /// America/Managua
    America__Managua,
    /// America/Manaus
    America__Manaus,
    /// America/Marigot
    America__Marigot,
    /// America/Martinique
    America__Martinique,
    /// America/Matamoros
    America__Matamoros,
    /// America/Mazatlan
    America__Mazatlan,
    /// America/Mendoza
    America__Mendoza,
    /// America/Menominee
    America__Menominee,
    /// America/Merida
    America__Merida,
    /// America/Metlakatla
    America__Metlakatla,
    /// America/Mexico_City
    America__Mexico_City,
    /// America/Miquelon
    America__Miquelon,
    /// America/Moncton
    America__Moncton,
    /// America/Monterrey
    America__Monterrey,
    /// America/Montevideo
    America__Montevideo,
    /// America/Montreal
    America__Montreal,
    /// America/Montserrat
    America__Montserrat,
    /// America/Nassau
    America__Nassau,
    /// America/New_York
    America__New_York,
    /// America/Nipigon
    America__Nipigon,
    /// America/Nome
    America__Nome,
    /// America/Noronha
    America__Noronha,
    /// America/North_Dakota/Beulah
    America__North_Dakota__Beulah,
    /// America/North_Dakota/Center
    America__North_Dakota__Center,
    /// America/North_Dakota/New_Salem
    America__North_Dakota__New_Salem,
    /// America/Nuuk
    America__Nuuk,
    /// America/Ojinaga
    America__Ojinaga,
    /// America/Panama
    America__Panama,
    /// America/Pangnirtung
    America__Pangnirtung,
    /// America/Paramaribo
    America__Paramaribo,
    /// America/Phoenix
    America__Phoenix,
    /// America/Port-au-Prince
    America__PortauPrince,
    /// America/Port_of_Spain
    America__Port_of_Spain,
    /// America/Porto_Acre
    America__Porto_Acre,
    /// America/Porto_Velho
    America__Porto_Velho,
    /// America/Puerto_Rico
    America__Puerto_Rico,
    /// America/Punta_Arenas
    America__Punta_Arenas,
    /// America/Rainy_River
    America__Rainy_River,
    /// America/Rankin_Inlet
    America__Rankin_Inlet,
    /// America/Recife
    America__Recife,
    /// America/Regina
    America__Regina,
    /// America/Resolute
    America__Resolute,
    /// America/Rio_Branco
    America__Rio_Branco,
    /// America/Rosario
    America__Rosario,
    /// America/Santa_Isabel
    America__Santa_Isabel,
    /// America/Santarem
    America__Santarem,
    /// America/Santiago
    America__Santiago,
    /// America/Santo_Domingo
    America__Santo_Domingo,
    /// America/Sao_Paulo
    America__Sao_Paulo,
    /// America/Scoresbysund
    America__Scoresbysund,
    /// America/Shiprock
    America__Shiprock,
    /// America/Sitka
    America__Sitka,
    /// America/St_Barthelemy
    America__St_Barthelemy,
    /// America/St_Johns
    America__St_Johns,
    /// America/St_Kitts
    America__St_Kitts,
    /// America/St_Lucia
    America__St_Lucia,
    /// America/St_Thomas
    America__St_Thomas,
    /// America/St_Vincent
    America__St_Vincent,
    /// America/Swift_Current
    America__Swift_Current,
    /// America/Tegucigalpa
    America__Tegucigalpa,
    /// America/Thule
    America__Thule,
    /// America/Thunder_Bay
    America__Thunder_Bay,
    /// America/Tijuana
    America__Tijuana,
    /// America/Toronto
    America__Toronto,
    /// America/Tortola
    America__Tortola,
    /// America/Vancouver
    America__Vancouver,
    /// America/Virgin
    America__Virgin,
    /// America/Whitehorse
    America__Whitehorse,
    /// America/Winnipeg
    America__Winnipeg,
    /// America/Yakutat
    America__Yakutat,
    /// America/Yellowknife
    America__Yellowknife,
    /// Antarctica/Casey
    Antarctica__Casey,
    /// Antarctica/Davis
    Antarctica__Davis,
    /// Antarctica/DumontDUrville
    Antarctica__DumontDUrville,
    /// Antarctica/Macquarie
    Antarctica__Macquarie,
    /// Antarctica/Mawson
    Antarctica__Mawson,
    /// Antarctica/McMurdo
    Antarctica__McMurdo,
    /// Antarctica/Palmer
    Antarctica__Palmer,
    /// Antarctica/Rothera
    Antarctica__Rothera,
    /// Antarctica/South_Pole
    Antarctica__South_Pole,
    /// Antarctica/Syowa
    Antarctica__Syowa,
    /// Antarctica/Troll
    Antarctica__Troll,
    /// Antarctica/Vostok
    Antarctica__Vostok,
    /// Arctic/Longyearbyen
    Arctic__Longyearbyen,
    /// Asia/Aden
    Asia__Aden,
    /// Asia/Almaty
    Asia__Almaty,
    /// Asia/Amman
    Asia__Amman,
    /// Asia/Anadyr
    Asia__Anadyr,
    /// Asia/Aqtau
    Asia__Aqtau,
    /// Asia/Aqtobe
    Asia__Aqtobe,
    /// Asia/Ashgabat
    Asia__Ashgabat,
    /// Asia/Ashkhabad
    Asia__Ashkhabad,
    /// Asia/Atyrau
    Asia__Atyrau,
    /// Asia/Baghdad
    Asia__Baghdad,
    /// Asia/Bahrain
    Asia__Bahrain,
    /// Asia/Baku
    Asia__Baku,
    /// Asia/Bangkok
    Asia__Bangkok,
    /// Asia/Barnaul
    Asia__Barnaul,
    /// Asia/Beirut
    Asia__Beirut,
    /// Asia/Bishkek
    Asia__Bishkek,
    /// Asia/Brunei
    Asia__Brunei,
    /// Asia/Calcutta
    Asia__Calcutta,
    /// Asia/Chita
    Asia__Chita,
    /// Asia/Choibalsan
    Asia__Choibalsan,
    /// Asia/Chongqing
    Asia__Chongqing,
    /// Asia/Chungking
    Asia__Chungking,
    /// Asia/Colombo
    Asia__Colombo,
    /// Asia/Dacca
    Asia__Dacca,
    /// Asia/Damascus
    Asia__Damascus,
    /// Asia/Dhaka
    Asia__Dhaka,
    /// Asia/Dili
    Asia__Dili,
    /// Asia/Dubai
    Asia__Dubai,
    /// Asia/Dushanbe
    Asia__Dushanbe,
    /// Asia/Famagusta
    Asia__Famagusta,
    /// Asia/Gaza
    Asia__Gaza,
    /// Asia/Harbin
    Asia__Harbin,
    /// Asia/Hebron
    Asia__Hebron,
    /// Asia/Ho_Chi_Minh
    Asia__Ho_Chi_Minh,
    /// Asia/Hong_Kong
    Asia__Hong_Kong,
    /// Asia/Hovd
    Asia__Hovd,
    /// Asia/Irkutsk
    Asia__Irkutsk,
    /// Asia/Istanbul
    Asia__Istanbul,
    /// Asia/Jakarta
    Asia__Jakarta,
    /// Asia/Jayapura
    Asia__Jayapura,
    /// Asia/Jerusalem
    Asia__Jerusalem,
    /// Asia/Kabul
    Asia__Kabul,
    /// Asia/Kamchatka
    Asia__Kamchatka,
    /// Asia/Karachi
    Asia__Karachi,
    /// Asia/Kashgar
    Asia__Kashgar,
    /// Asia/Kathmandu
    Asia__Kathmandu,
    /// Asia/Katmandu
    Asia__Katmandu,
    /// Asia/Khandyga
    Asia__Khandyga,
    /// Asia/Kolkata
    Asia__Kolkata,
    /// Asia/Krasnoyarsk
    Asia__Krasnoyarsk,
    /// Asia/Kuala_Lumpur
    Asia__Kuala_Lumpur,
    /// Asia/Kuching
    Asia__Kuching,
    /// Asia/Kuwait
    Asia__Kuwait,
    /// Asia/Macao
    Asia__Macao,
    /// Asia/Macau
    Asia__Macau,
    /// Asia/Magadan
    Asia__Magadan,
    /// Asia/Makassar
    Asia__Makassar,
    /// Asia/Manila
    Asia__Manila,
    /// Asia/Muscat
    Asia__Muscat,
    /// Asia/Nicosia
    Asia__Nicosia,
    /// Asia/Novokuznetsk
    Asia__Novokuznetsk,
    /// Asia/Novosibirsk
    Asia__Novosibirsk,
    /// Asia/Omsk
    Asia__Omsk,
    /// Asia/Oral
    Asia__Oral,
    /// Asia/Phnom_Penh
    Asia__Phnom_Penh,
    /// Asia/Pontianak
    Asia__Pontianak,
    /// Asia/Pyongyang
    Asia__Pyongyang,
    /// Asia/Qatar
    Asia__Qatar,
    /// Asia/Qostanay
    Asia__Qostanay,
    /// Asia/Qyzylorda
    Asia__Qyzylorda,
    /// Asia/Rangoon
    Asia__Rangoon,
    /// Asia/Riyadh
    Asia__Riyadh,
    /// Asia/Saigon
    Asia__Saigon,
    /// Asia/Sakhalin
    Asia__Sakhalin,
    /// Asia/Samarkand
    Asia__Samarkand,
    /// Asia/Seoul
    Asia__Seoul,
    /// Asia/Shanghai
    Asia__Shanghai,
    /// Asia/Singapore
    Asia__Singapore,
    /// Asia/Srednekolymsk
    Asia__Srednekolymsk,
    /// Asia/Taipei
    Asia__Taipei,
    /// Asia/Tashkent
    Asia__Tashkent,
    /// Asia/Tbilisi
    Asia__Tbilisi,
    /// Asia/Tehran
    Asia__Tehran,
    /// Asia/Tel_Aviv
    Asia__Tel_Aviv,
    /// Asia/Thimbu
    Asia__Thimbu,
    /// Asia/Thimphu
    Asia__Thimphu,
    /// Asia/Tokyo
    Asia__Tokyo,
    /// Asia/Tomsk
    Asia__Tomsk,
    /// Asia/Ujung_Pandang
    Asia__Ujung_Pandang,
    /// Asia/Ulaanbaatar
    Asia__Ulaanbaatar,
    /// Asia/Ulan_Bator
    Asia__Ulan_Bator,
    /// Asia/Urumqi
    Asia__Urumqi,
    /// Asia/Ust-Nera
    Asia__UstNera,
    /// Asia/Vientiane
    Asia__Vientiane,
    /// Asia/Vladivostok
    Asia__Vladivostok,
    /// Asia/Yakutsk
    Asia__Yakutsk,
    /// Asia/Yangon
    Asia__Yangon,
    /// Asia/Yekaterinburg
    Asia__Yekaterinburg,
    /// Asia/Yerevan
    Asia__Yerevan,
    /// Atlantic/Azores
    Atlantic__Azores,
    /// Atlantic/Bermuda
    Atlantic__Bermuda,
    /// Atlantic/Canary
    Atlantic__Canary,
    /// Atlantic/Cape_Verde
    Atlantic__Cape_Verde,
    /// Atlantic/Faeroe
    Atlantic__Faeroe,
    /// Atlantic/Faroe
    Atlantic__Faroe,
    /// Atlantic/Jan_Mayen
    Atlantic__Jan_Mayen,
    /// Atlantic/Madeira
    Atlantic__Madeira,
    /// Atlantic/Reykjavik
    Atlantic__Reykjavik,
    /// Atlantic/South_Georgia
    Atlantic__South_Georgia,
    /// Atlantic/St_Helena
    Atlantic__St_Helena,
    /// Atlantic/Stanley
    Atlantic__Stanley,
    /// Australia/ACT
    Australia__ACT,
    /// Australia/Adelaide
    Australia__Adelaide,
    /// Australia/Brisbane
    Australia__Brisbane,
    /// Australia/Broken_Hill
    Australia__Broken_Hill,
    /// Australia/Canberra
    Australia__Canberra,
    /// Australia/Currie
    Australia__Currie,
    /// Australia/Darwin
    Australia__Darwin,
    /// Australia/Eucla
    Australia__Eucla,
    /// Australia/Hobart
    Australia__Hobart,
    /// Australia/LHI
    Australia__LHI,
    /// Australia/Lindeman
    Australia__Lindeman,
    /// Australia/Lord_Howe
    Australia__Lord_Howe,
    /// Australia/Melbourne
    Australia__Melbourne,
    /// Australia/NSW
    Australia__NSW,
    /// Australia/North
    Australia__North,
    /// Australia/Perth
    Australia__Perth,
    /// Australia/Queensland
    Australia__Queensland,
    /// Australia/South
    Australia__South,
    /// Australia/Sydney
    Australia__Sydney,
    /// Australia/Tasmania
    Australia__Tasmania,
    /// Australia/Victoria
    Australia__Victoria,
    /// Australia/West
    Australia__West,
    /// Australia/Yancowinna
    Australia__Yancowinna,
    /// Brazil/Acre
    Brazil__Acre,
    /// Brazil/DeNoronha
    Brazil__DeNoronha,
    /// Brazil/East
    Brazil__East,
    /// Brazil/West
    Brazil__West,
    /// CET
    CET,
    /// CST6CDT
    CST6CDT,
    /// Canada/Atlantic
    Canada__Atlantic,
    /// Canada/Central
    Canada__Central,
    /// Canada/Eastern
    Canada__Eastern,
    /// Canada/Mountain
    Canada__Mountain,
    /// Canada/Newfoundland
    Canada__Newfoundland,
    /// Canada/Pacific
    Canada__Pacific,
    /// Canada/Saskatchewan
    Canada__Saskatchewan,
    /// Canada/Yukon
    Canada__Yukon,
    /// Chile/Continental
    Chile__Continental,
    /// Chile/EasterIsland
    Chile__EasterIsland,
    /// Cuba
    Cuba,
    /// EET
    EET,
    /// EST
    EST,
    /// EST5EDT
    EST5EDT,
    /// Egypt
    Egypt,
    /// Eire
    Eire,
    /// Etc/GMT
    Etc__GMT,
    /// Etc/GMT+0
    Etc__GMTPlus0,
    /// Etc/GMT+1
    Etc__GMTPlus1,
    /// Etc/GMT+10
    Etc__GMTPlus10,
    /// Etc/GMT+11
    Etc__GMTPlus11,
    /// Etc/GMT+12
    Etc__GMTPlus12,
    /// Etc/GMT+2
    Etc__GMTPlus2,
    /// Etc/GMT+3
    Etc__GMTPlus3,
    /// Etc/GMT+4
    Etc__GMTPlus4,
    /// Etc/GMT+5
    Etc__GMTPlus5,
    /// Etc/GMT+6
    Etc__GMTPlus6,
    /// Etc/GMT+7
    Etc__GMTPlus7,
    /// Etc/GMT+8
    Etc__GMTPlus8,
    /// Etc/GMT+9
    Etc__GMTPlus9,
    /// Etc/GMT-0
    Etc__GMTMinus0,
    /// Etc/GMT-1
    Etc__GMTMinus1,
    /// Etc/GMT-10
    Etc__GMTMinus10,
    /// Etc/GMT-11
    Etc__GMTMinus11,
    /// Etc/GMT-12
    Etc__GMTMinus12,
    /// Etc/GMT-13
    Etc__GMTMinus13,
    /// Etc/GMT-14
    Etc__GMTMinus14,
    /// Etc/GMT-2
    Etc__GMTMinus2,
    /// Etc/GMT-3
    Etc__GMTMinus3,
    /// Etc/GMT-4
    Etc__GMTMinus4,
    /// Etc/GMT-5
    Etc__GMTMinus5,
    /// Etc/GMT-6
    Etc__GMTMinus6,
    /// Etc/GMT-7
    Etc__GMTMinus7,
    /// Etc/GMT-8
    Etc__GMTMinus8,
    /// Etc/GMT-9
    Etc__GMTMinus9,
    /// Etc/GMT0
    Etc__GMT0,
    /// Etc/Greenwich
    Etc__Greenwich,
    /// Etc/UCT
    Etc__UCT,
    /// Etc/UTC
    Etc__UTC,
    /// Etc/Universal
    Etc__Universal,
    /// Etc/Zulu
    Etc__Zulu,
    /// Europe/Amsterdam
    Europe__Amsterdam,
    /// Europe/Andorra
    Europe__Andorra,
    /// Europe/Astrakhan
    Europe__Astrakhan,
    /// Europe/Athens
    Europe__Athens,
    /// Europe/Belfast
    Europe__Belfast,
    /// Europe/Belgrade
    Europe__Belgrade,
    /// Europe/Berlin
    Europe__Berlin,
    /// Europe/Bratislava
    Europe__Bratislava,
    /// Europe/Brussels
    Europe__Brussels,
    /// Europe/Bucharest
    Europe__Bucharest,
    /// Europe/Budapest
    Europe__Budapest,
    /// Europe/Busingen
    Europe__Busingen,
    /// Europe/Chisinau
    Europe__Chisinau,
    /// Europe/Copenhagen
    Europe__Copenhagen,
    /// Europe/Dublin
    Europe__Dublin,
    /// Europe/Gibraltar
    Europe__Gibraltar,
    /// Europe/Guernsey
    Europe__Guernsey,
    /// Europe/Helsinki
    Europe__Helsinki,
    /// Europe/Isle_of_Man
    Europe__Isle_of_Man,
    /// Europe/Istanbul
    Europe__Istanbul,
    /// Europe/Jersey
    Europe__Jersey,
    /// Europe/Kaliningrad
    Europe__Kaliningrad,
    /// Europe/Kiev
    Europe__Kiev,
    /// Europe/Kirov
    Europe__Kirov,
    /// Europe/Kyiv
    Europe__Kyiv,
    /// Europe/Lisbon
    Europe__Lisbon,
    /// Europe/Ljubljana
    Europe__Ljubljana,
    /// Europe/London
    Europe__London,
    /// Europe/Luxembourg
    Europe__Luxembourg,
    /// Europe/Madrid
    Europe__Madrid,
    /// Europe/Malta
    Europe__Malta,
    /// Europe/Mariehamn
    Europe__Mariehamn,
    /// Europe/Minsk
    Europe__Minsk,
    /// Europe/Monaco
    Europe__Monaco,
    /// Europe/Moscow
    Europe__Moscow,
    /// Europe/Nicosia
    Europe__Nicosia,
    /// Europe/Oslo
    Europe__Oslo,
    /// Europe/Paris
    Europe__Paris,
    /// Europe/Podgorica
    Europe__Podgorica,
    /// Europe/Prague
    Europe__Prague,
    /// Europe/Riga
    Europe__Riga,
    /// Europe/Rome
    Europe__Rome,
    /// Europe/Samara
    Europe__Samara,
    /// Europe/San_Marino
    Europe__San_Marino,
    /// Europe/Sarajevo
    Europe__Sarajevo,
    /// Europe/Saratov
    Europe__Saratov,
    /// Europe/Simferopol
    Europe__Simferopol,
    /// Europe/Skopje
    Europe__Skopje,
    /// Europe/Sofia
    Europe__Sofia,
    /// Europe/Stockholm
    Europe__Stockholm,
    /// Europe/Tallinn
    Europe__Tallinn,
    /// Europe/Tirane
    Europe__Tirane,
    /// Europe/Tiraspol
    Europe__Tiraspol,
    /// Europe/Ulyanovsk
    Europe__Ulyanovsk,
    /// Europe/Uzhgorod
    Europe__Uzhgorod,
    /// Europe/Vaduz
    Europe__Vaduz,
    /// Europe/Vatican
    Europe__Vatican,
    /// Europe/Vienna
    Europe__Vienna,
    /// Europe/Vilnius
    Europe__Vilnius,
    /// Europe/Volgograd
    Europe__Volgograd,
    /// Europe/Warsaw
    Europe__Warsaw,
    /// Europe/Zagreb
    Europe__Zagreb,
    /// Europe/Zaporozhye
    Europe__Zaporozhye,
    /// Europe/Zurich
    Europe__Zurich,
    /// GB
    GB,
    /// GB-Eire
    GBEire,
    /// GMT
    GMT,
    /// GMT+0
    GMTPlus0,
    /// GMT-0
    GMTMinus0,
    /// GMT0
    GMT0,
    /// Greenwich
    Greenwich,
    /// HST
    HST,
    /// Hongkong
    Hongkong,
    /// Iceland
    Iceland,
    /// Indian/Antananarivo
    Indian__Antananarivo,
    /// Indian/Chagos
    Indian__Chagos,
    /// Indian/Christmas
    Indian__Christmas,
    /// Indian/Cocos
    Indian__Cocos,
    /// Indian/Comoro
    Indian__Comoro,
    /// Indian/Kerguelen
    Indian__Kerguelen,
    /// Indian/Mahe
    Indian__Mahe,
    /// Indian/Maldives
    Indian__Maldives,
    /// Indian/Mauritius
    Indian__Mauritius,
    /// Indian/Mayotte
    Indian__Mayotte,
    /// Indian/Reunion
    Indian__Reunion,
    /// Iran
    Iran,
    /// Israel
    Israel,
    /// Jamaica
    Jamaica,
    /// Japan
    Japan,
    /// Kwajalein
    Kwajalein,
    /// Libya
    Libya,
    /// MET
    MET,
    /// MST
    MST,
    /// MST7MDT
    MST7MDT,
    /// Mexico/BajaNorte
    Mexico__BajaNorte,
    /// Mexico/BajaSur
    Mexico__BajaSur,
    /// Mexico/General
    Mexico__General,
    /// NZ
    NZ,
    /// NZ-CHAT
    NZCHAT,
    /// Navajo
    Navajo,
    /// PRC
    PRC,
    /// PST8PDT
    PST8PDT,
    /// Pacific/Apia
    Pacific__Apia,
    /// Pacific/Auckland
    Pacific__Auckland,
    /// Pacific/Bougainville
    Pacific__Bougainville,
    /// Pacific/Chatham
    Pacific__Chatham,
    /// Pacific/Chuuk
    Pacific__Chuuk,
    /// Pacific/Easter
    Pacific__Easter,
    /// Pacific/Efate
    Pacific__Efate,
    /// Pacific/Enderbury
    Pacific__Enderbury,
    /// Pacific/Fakaofo
    Pacific__Fakaofo,
    /// Pacific/Fiji
    Pacific__Fiji,
    /// Pacific/Funafuti
    Pacific__Funafuti,
    /// Pacific/Galapagos
    Pacific__Galapagos,
    /// Pacific/Gambier
    Pacific__Gambier,
    /// Pacific/Guadalcanal
    Pacific__Guadalcanal,
    /// Pacific/Guam
    Pacific__Guam,
    /// Pacific/Honolulu
    Pacific__Honolulu,
    /// Pacific/Johnston
    Pacific__Johnston,
    /// Pacific/Kanton
    Pacific__Kanton,
    /// Pacific/Kiritimati
    Pacific__Kiritimati,
    /// Pacific/Kosrae
    Pacific__Kosrae,
    /// Pacific/Kwajalein
    Pacific__Kwajalein,
    /// Pacific/Majuro
    Pacific__Majuro,
    /// Pacific/Marquesas
    Pacific__Marquesas,
    /// Pacific/Midway
    Pacific__Midway,
    /// Pacific/Nauru
    Pacific__Nauru,
    /// Pacific/Niue
    Pacific__Niue,
    /// Pacific/Norfolk
    Pacific__Norfolk,
    /// Pacific/Noumea
    Pacific__Noumea,
    /// Pacific/Pago_Pago
    Pacific__Pago_Pago,
    /// Pacific/Palau
    Pacific__Palau,
    /// Pacific/Pitcairn
    Pacific__Pitcairn,
    /// Pacific/Pohnpei
    Pacific__Pohnpei,
    /// Pacific/Ponape
    Pacific__Ponape,
    /// Pacific/Port_Moresby
    Pacific__Port_Moresby,
    /// Pacific/Rarotonga
    Pacific__Rarotonga,
    /// Pacific/Saipan
    Pacific__Saipan,
    /// Pacific/Samoa
    Pacific__Samoa,
    /// Pacific/Tahiti
    Pacific__Tahiti,
    /// Pacific/Tarawa
    Pacific__Tarawa,
    /// Pacific/Tongatapu
    Pacific__Tongatapu,
    /// Pacific/Truk
    Pacific__Truk,
    /// Pacific/Wake
    Pacific__Wake,
    /// Pacific/Wallis
    Pacific__Wallis,
    /// Pacific/Yap
    Pacific__Yap,
    /// Poland
    Poland,
    /// Portugal
    Portugal,
    /// ROC
    ROC,
    /// ROK
    ROK,
    /// Singapore
    Singapore,
    /// Turkey
    Turkey,
    /// UCT
    UCT,
    /// US/Alaska
    US__Alaska,
    /// US/Aleutian
    US__Aleutian,
    /// US/Arizona
    US__Arizona,
    /// US/Central
    US__Central,
    /// US/East-Indiana
    US__EastIndiana,
    /// US/Eastern
    US__Eastern,
    /// US/Hawaii
    US__Hawaii,
    /// US/Indiana-Starke
    US__IndianaStarke,
    /// US/Michigan
    US__Michigan,
    /// US/Mountain
    US__Mountain,
    /// US/Pacific
    US__Pacific,
    /// US/Samoa
    US__Samoa,
    /// UTC
    UTC,
    /// Universal
    Universal,
    /// W-SU
    WSU,
    /// WET
    WET,
    /// Zulu
    Zulu,
}
static TIMEZONES: ::phf::Map<&'static str, Tz> = 
::phf::Map {
    key: 16287231350648472473,
    disps: &[
        (0, 6),
        (0, 3),
        (0, 235),
        (0, 27),
        (0, 95),
        (0, 282),
        (0, 3),
        (0, 459),
        (0, 18),
        (0, 146),
        (0, 107),
        (0, 98),
        (0, 9),
        (1, 417),
        (0, 18),
        (2, 171),
        (0, 39),
        (0, 1),
        (0, 18),
        (0, 196),
        (0, 0),
        (2, 224),
        (0, 1),
        (0, 4),
        (0, 507),
        (0, 145),
        (0, 137),
        (0, 1),
        (0, 3),
        (0, 1),
        (1, 489),
        (0, 2),
        (0, 5),
        (0, 127),
        (0, 170),
        (0, 17),
        (0, 17),
        (0, 14),
        (0, 91),
        (1, 4),
        (0, 539),
        (0, 453),
        (0, 33),
        (0, 534),
        (0, 3),
        (0, 320),
        (0, 0),
        (0, 0),
        (0, 486),
        (0, 4),
        (0, 3),
        (0, 4),
        (0, 92),
        (0, 46),
        (0, 0),
        (0, 105),
        (0, 25),
        (0, 444),
        (0, 206),
        (0, 202),
        (1, 463),
        (1, 99),
        (4, 338),
        (1, 334),
        (0, 37),
        (0, 17),
        (4, 321),
        (0, 30),
        (0, 2),
        (0, 7),
        (0, 494),
        (1, 380),
        (0, 0),
        (0, 55),
        (1, 11),
        (4, 275),
        (3, 580),
        (1, 582),
        (1, 279),
        (0, 26),
        (0, 581),
        (3, 456),
        (0, 140),
        (1, 565),
        (3, 433),
        (1, 426),
        (0, 4),
        (0, 26),
        (4, 424),
        (0, 13),
        (2, 425),
        (0, 9),
        (0, 62),
        (1, 535),
        (0, 11),
        (0, 2),
        (1, 352),
        (0, 98),
        (5, 287),
        (0, 113),
        (0, 7),
        (0, 1),
        (5, 418),
        (2, 415),
        (0, 280),
        (28, 336),
        (0, 12),
        (4, 259),
        (0, 271),
        (0, 353),
        (1, 226),
        (0, 31),
        (2, 234),
        (2, 279),
        (0, 248),
        (7, 306),
        (0, 579),
        (0, 5),
        (15, 425),
        (33, 13),
    ],
    entries: &[
        ("Asia/Irkutsk", Tz::Asia__Irkutsk),
        ("Asia/Anadyr", Tz::Asia__Anadyr),
        ("PRC", Tz::PRC),
        ("Africa/Maputo", Tz::Africa__Maputo),
        ("America/Indiana/Vevay", Tz::America__Indiana__Vevay),
        ("Pacific/Saipan", Tz::Pacific__Saipan),
        ("Australia/Victoria", Tz::Australia__Victoria),
        ("Atlantic/Madeira", Tz::Atlantic__Madeira),
        ("America/Iqaluit", Tz::America__Iqaluit),
        ("Europe/Zagreb", Tz::Europe__Zagreb),
        ("Africa/Luanda", Tz::Africa__Luanda),
        ("America/Adak", Tz::America__Adak),
        ("America/Moncton", Tz::America__Moncton),
        ("Pacific/Easter", Tz::Pacific__Easter),
        ("Africa/Lome", Tz::Africa__Lome),
        ("Europe/Minsk", Tz::Europe__Minsk),
        ("Asia/Almaty", Tz::Asia__Almaty),
        ("America/Toronto", Tz::America__Toronto),
        ("Etc/Zulu", Tz::Etc__Zulu),
        ("EET", Tz::EET),
        ("Asia/Khandyga", Tz::Asia__Khandyga),
        ("MET", Tz::MET),
        ("America/Marigot", Tz::America__Marigot),
        ("America/Jamaica", Tz::America__Jamaica),
        ("Europe/Riga", Tz::Europe__Riga),
        ("Asia/Rangoon", Tz::Asia__Rangoon),
        ("Asia/Karachi", Tz::Asia__Karachi),
        ("Singapore", Tz::Singapore),
        ("Etc/GMT0", Tz::Etc__GMT0),
        ("Australia/ACT", Tz::Australia__ACT),
        ("Zulu", Tz::Zulu),
        ("Canada/Newfoundland", Tz::Canada__Newfoundland),
        ("Antarctica/South_Pole", Tz::Antarctica__South_Pole),
        ("Asia/Ashkhabad", Tz::Asia__Ashkhabad),
        ("Asia/Kolkata", Tz::Asia__Kolkata),
        ("America/Thunder_Bay", Tz::America__Thunder_Bay),
        ("Etc/GMT+2", Tz::Etc__GMTPlus2),
        ("Asia/Krasnoyarsk", Tz::Asia__Krasnoyarsk),
        ("Canada/Saskatchewan", Tz::Canada__Saskatchewan),
        ("Europe/Sofia", Tz::Europe__Sofia),
        ("Europe/Kirov", Tz::Europe__Kirov),
        ("Africa/Dar_es_Salaam", Tz::Africa__Dar_es_Salaam),
        ("America/Los_Angeles", Tz::America__Los_Angeles),
        ("America/Catamarca", Tz::America__Catamarca),
        ("Africa/Ndjamena", Tz::Africa__Ndjamena),
        ("Pacific/Noumea", Tz::Pacific__Noumea),
        ("America/Bahia_Banderas", Tz::America__Bahia_Banderas),
        ("America/Matamoros", Tz::America__Matamoros),
        ("Africa/Kampala", Tz::Africa__Kampala),
        ("Canada/Eastern", Tz::Canada__Eastern),
        ("Africa/Maseru", Tz::Africa__Maseru),
        ("America/Belize", Tz::America__Belize),
        ("Asia/Katmandu", Tz::Asia__Katmandu),
        ("Etc/UTC", Tz::Etc__UTC),
        ("Europe/Belgrade", Tz::Europe__Belgrade),
        ("America/Goose_Bay", Tz::America__Goose_Bay),
        ("Etc/GMT+0", Tz::Etc__GMTPlus0),
        ("Pacific/Pohnpei", Tz::Pacific__Pohnpei),
        ("America/Paramaribo", Tz::America__Paramaribo),
        ("Indian/Antananarivo", Tz::Indian__Antananarivo),
        ("Asia/Omsk", Tz::Asia__Omsk),
        ("Pacific/Honolulu", Tz::Pacific__Honolulu),
        ("Atlantic/Stanley", Tz::Atlantic__Stanley),
        ("Asia/Jakarta", Tz::Asia__Jakarta),
        ("America/Inuvik", Tz::America__Inuvik),
        ("Africa/Monrovia", Tz::Africa__Monrovia),
        ("Australia/Lord_Howe", Tz::Australia__Lord_Howe),
        ("America/Havana", Tz::America__Havana),
        ("America/Miquelon", Tz::America__Miquelon),
        ("Indian/Kerguelen", Tz::Indian__Kerguelen),
        ("Iran", Tz::Iran),
        ("Asia/Urumqi", Tz::Asia__Urumqi),
        ("Etc/GMT+7", Tz::Etc__GMTPlus7),
        ("Asia/Tehran", Tz::Asia__Tehran),
        ("America/Guyana", Tz::America__Guyana),
        ("Australia/Tasmania", Tz::Australia__Tasmania),
        ("Pacific/Samoa", Tz::Pacific__Samoa),
        ("Europe/Vilnius", Tz::Europe__Vilnius),
        ("America/North_Dakota/Beulah", Tz::America__North_Dakota__Beulah),
        ("Pacific/Enderbury", Tz::Pacific__Enderbury),
        ("Etc/GMT-0", Tz::Etc__GMTMinus0),
        ("Arctic/Longyearbyen", Tz::Arctic__Longyearbyen),
        ("America/Hermosillo", Tz::America__Hermosillo),
        ("Antarctica/McMurdo", Tz::Antarctica__McMurdo),
        ("Asia/Kuala_Lumpur", Tz::Asia__Kuala_Lumpur),
        ("Pacific/Wake", Tz::Pacific__Wake),
        ("America/Grand_Turk", Tz::America__Grand_Turk),
        ("America/Ojinaga", Tz::America__Ojinaga),
        ("US/Central", Tz::US__Central),
        ("America/Montreal", Tz::America__Montreal),
        ("America/St_Kitts", Tz::America__St_Kitts),
        ("Asia/Hebron", Tz::Asia__Hebron),
        ("Europe/Athens", Tz::Europe__Athens),
        ("America/Winnipeg", Tz::America__Winnipeg),
        ("America/Virgin", Tz::America__Virgin),
        ("America/Sao_Paulo", Tz::America__Sao_Paulo),
        ("Asia/Kabul", Tz::Asia__Kabul),
        ("Etc/GMT+3", Tz::Etc__GMTPlus3),
        ("America/Punta_Arenas", Tz::America__Punta_Arenas),
        ("Africa/Mogadishu", Tz::Africa__Mogadishu),
        ("America/Indiana/Petersburg", Tz::America__Indiana__Petersburg),
        ("Asia/Barnaul", Tz::Asia__Barnaul),
        ("America/Juneau", Tz::America__Juneau),
        ("Europe/Luxembourg", Tz::Europe__Luxembourg),
        ("America/Dominica", Tz::America__Dominica),
        ("Europe/Guernsey", Tz::Europe__Guernsey),
        ("America/Anchorage", Tz::America__Anchorage),
        ("America/Barbados", Tz::America__Barbados),
        ("Pacific/Midway", Tz::Pacific__Midway),
        ("Asia/Atyrau", Tz::Asia__Atyrau),
        ("Pacific/Yap", Tz::Pacific__Yap),
        ("Etc/Universal", Tz::Etc__Universal),
        ("America/Yakutat", Tz::America__Yakutat),
        ("America/Coral_Harbour", Tz::America__Coral_Harbour),
        ("Atlantic/Reykjavik", Tz::Atlantic__Reykjavik),
        ("America/Noronha", Tz::America__Noronha),
        ("Europe/Stockholm", Tz::Europe__Stockholm),
        ("Africa/Casablanca", Tz::Africa__Casablanca),
        ("Africa/Khartoum", Tz::Africa__Khartoum),
        ("Australia/Broken_Hill", Tz::Australia__Broken_Hill),
        ("America/Fort_Wayne", Tz::America__Fort_Wayne),
        ("Africa/Djibouti", Tz::Africa__Djibouti),
        ("America/Danmarkshavn", Tz::America__Danmarkshavn),
        ("Australia/Sydney", Tz::Australia__Sydney),
        ("America/Ensenada", Tz::America__Ensenada),
        ("Europe/Kaliningrad", Tz::Europe__Kaliningrad),
        ("Africa/Dakar", Tz::Africa__Dakar),
        ("Asia/Muscat", Tz::Asia__Muscat),
        ("Asia/Baku", Tz::Asia__Baku),
        ("Atlantic/St_Helena", Tz::Atlantic__St_Helena),
        ("Pacific/Tarawa", Tz::Pacific__Tarawa),
        ("Asia/Brunei", Tz::Asia__Brunei),
        ("America/Asuncion", Tz::America__Asuncion),
        ("America/Caracas", Tz::America__Caracas),
        ("America/Montevideo", Tz::America__Montevideo),
        ("Europe/Busingen", Tz::Europe__Busingen),
        ("Europe/Nicosia", Tz::Europe__Nicosia),
        ("America/Coyhaique", Tz::America__Coyhaique),
        ("Pacific/Marquesas", Tz::Pacific__Marquesas),
        ("America/Santiago", Tz::America__Santiago),
        ("America/Shiprock", Tz::America__Shiprock),
        ("Etc/GMT+11", Tz::Etc__GMTPlus11),
        ("Africa/Conakry", Tz::Africa__Conakry),
        ("Asia/Riyadh", Tz::Asia__Riyadh),
        ("Europe/Brussels", Tz::Europe__Brussels),
        ("Portugal", Tz::Portugal),
        ("America/St_Johns", Tz::America__St_Johns),
        ("America/Mexico_City", Tz::America__Mexico_City),
        ("Brazil/West", Tz::Brazil__West),
        ("Africa/Harare", Tz::Africa__Harare),
        ("Indian/Christmas", Tz::Indian__Christmas),
        ("America/Knox_IN", Tz::America__Knox_IN),
        ("America/Nuuk", Tz::America__Nuuk),
        ("Antarctica/Casey", Tz::Antarctica__Casey),
        ("Etc/GMT-6", Tz::Etc__GMTMinus6),
        ("America/Indiana/Tell_City", Tz::America__Indiana__Tell_City),
        ("ROK", Tz::ROK),
        ("Indian/Maldives", Tz::Indian__Maldives),
        ("America/Chicago", Tz::America__Chicago),
        ("Asia/Magadan", Tz::Asia__Magadan),
        ("Pacific/Palau", Tz::Pacific__Palau),
        ("Europe/Zaporozhye", Tz::Europe__Zaporozhye),
        ("Pacific/Johnston", Tz::Pacific__Johnston),
        ("Asia/Samarkand", Tz::Asia__Samarkand),
        ("Iceland", Tz::Iceland),
        ("Europe/London", Tz::Europe__London),
        ("America/Santo_Domingo", Tz::America__Santo_Domingo),
        ("Chile/EasterIsland", Tz::Chile__EasterIsland),
        ("America/Godthab", Tz::America__Godthab),
        ("America/Argentina/Buenos_Aires", Tz::America__Argentina__Buenos_Aires),
        ("Asia/Chita", Tz::Asia__Chita),
        ("Asia/Jerusalem", Tz::Asia__Jerusalem),
        ("US/Alaska", Tz::US__Alaska),
        ("Etc/GMT-8", Tz::Etc__GMTMinus8),
        ("Australia/Currie", Tz::Australia__Currie),
        ("Africa/Accra", Tz::Africa__Accra),
        ("Libya", Tz::Libya),
        ("Europe/Zurich", Tz::Europe__Zurich),
        ("Etc/GMT", Tz::Etc__GMT),
        ("Etc/GMT-12", Tz::Etc__GMTMinus12),
        ("Etc/GMT-4", Tz::Etc__GMTMinus4),
        ("Asia/Shanghai", Tz::Asia__Shanghai),
        ("Europe/Copenhagen", Tz::Europe__Copenhagen),
        ("America/Cuiaba", Tz::America__Cuiaba),
        ("Europe/Vatican", Tz::Europe__Vatican),
        ("America/Creston", Tz::America__Creston),
        ("Asia/Ashgabat", Tz::Asia__Ashgabat),
        ("Asia/Yakutsk", Tz::Asia__Yakutsk),
        ("America/Swift_Current", Tz::America__Swift_Current),
        ("America/Tijuana", Tz::America__Tijuana),
        ("America/Boise", Tz::America__Boise),
        ("Asia/Famagusta", Tz::Asia__Famagusta),
        ("Europe/Simferopol", Tz::Europe__Simferopol),
        ("America/Sitka", Tz::America__Sitka),
        ("America/Port-au-Prince", Tz::America__PortauPrince),
        ("Mexico/BajaNorte", Tz::Mexico__BajaNorte),
        ("America/Fortaleza", Tz::America__Fortaleza),
        ("Antarctica/Davis", Tz::Antarctica__Davis),
        ("America/Santa_Isabel", Tz::America__Santa_Isabel),
        ("Africa/Juba", Tz::Africa__Juba),
        ("Etc/Greenwich", Tz::Etc__Greenwich),
        ("Pacific/Wallis", Tz::Pacific__Wallis),
        ("Etc/GMT+6", Tz::Etc__GMTPlus6),
        ("Asia/Chungking", Tz::Asia__Chungking),
        ("Antarctica/DumontDUrville", Tz::Antarctica__DumontDUrville),
        ("Pacific/Fiji", Tz::Pacific__Fiji),
        ("Europe/San_Marino", Tz::Europe__San_Marino),
        ("America/Resolute", Tz::America__Resolute),
        ("Pacific/Kiritimati", Tz::Pacific__Kiritimati),
        ("Asia/Pyongyang", Tz::Asia__Pyongyang),
        ("GMT-0", Tz::GMTMinus0),
        ("NZ-CHAT", Tz::NZCHAT),
        ("America/Argentina/La_Rioja", Tz::America__Argentina__La_Rioja),
        ("America/Montserrat", Tz::America__Montserrat),
        ("Africa/Douala", Tz::Africa__Douala),
        ("Europe/Malta", Tz::Europe__Malta),
        ("America/Indiana/Marengo", Tz::America__Indiana__Marengo),
        ("America/Tortola", Tz::America__Tortola),
        ("America/Tegucigalpa", Tz::America__Tegucigalpa),
        ("America/Phoenix", Tz::America__Phoenix),
        ("America/Cambridge_Bay", Tz::America__Cambridge_Bay),
        ("America/St_Barthelemy", Tz::America__St_Barthelemy),
        ("Asia/Dhaka", Tz::Asia__Dhaka),
        ("Asia/Taipei", Tz::Asia__Taipei),
        ("UCT", Tz::UCT),
        ("Africa/Gaborone", Tz::Africa__Gaborone),
        ("Atlantic/Bermuda", Tz::Atlantic__Bermuda),
        ("America/Yellowknife", Tz::America__Yellowknife),
        ("Antarctica/Mawson", Tz::Antarctica__Mawson),
        ("Navajo", Tz::Navajo),
        ("Africa/Tripoli", Tz::Africa__Tripoli),
        ("America/Atikokan", Tz::America__Atikokan),
        ("America/Monterrey", Tz::America__Monterrey),
        ("America/Blanc-Sablon", Tz::America__BlancSablon),
        ("Etc/GMT-7", Tz::Etc__GMTMinus7),
        ("Africa/Bangui", Tz::Africa__Bangui),
        ("America/Bahia", Tz::America__Bahia),
        ("America/Denver", Tz::America__Denver),
        ("America/Maceio", Tz::America__Maceio),
        ("Pacific/Niue", Tz::Pacific__Niue),
        ("Asia/Vientiane", Tz::Asia__Vientiane),
        ("Asia/Aden", Tz::Asia__Aden),
        ("Asia/Makassar", Tz::Asia__Makassar),
        ("America/Managua", Tz::America__Managua),
        ("America/Whitehorse", Tz::America__Whitehorse),
        ("EST5EDT", Tz::EST5EDT),
        ("Indian/Mauritius", Tz::Indian__Mauritius),
        ("Europe/Tirane", Tz::Europe__Tirane),
        ("Europe/Ljubljana", Tz::Europe__Ljubljana),
        ("Europe/Mariehamn", Tz::Europe__Mariehamn),
        ("Pacific/Guam", Tz::Pacific__Guam),
        ("Australia/Canberra", Tz::Australia__Canberra),
        ("America/Porto_Velho", Tz::America__Porto_Velho),
        ("Pacific/Tongatapu", Tz::Pacific__Tongatapu),
        ("America/Rainy_River", Tz::America__Rainy_River),
        ("MST", Tz::MST),
        ("America/Kralendijk", Tz::America__Kralendijk),
        ("W-SU", Tz::WSU),
        ("Asia/Bangkok", Tz::Asia__Bangkok),
        ("Indian/Mayotte", Tz::Indian__Mayotte),
        ("Asia/Aqtau", Tz::Asia__Aqtau),
        ("America/Costa_Rica", Tz::America__Costa_Rica),
        ("GB-Eire", Tz::GBEire),
        ("Asia/Kathmandu", Tz::Asia__Kathmandu),
        ("Asia/Macao", Tz::Asia__Macao),
        ("America/Guayaquil", Tz::America__Guayaquil),
        ("America/Nome", Tz::America__Nome),
        ("Asia/Thimphu", Tz::Asia__Thimphu),
        ("Etc/GMT+8", Tz::Etc__GMTPlus8),
        ("America/Belem", Tz::America__Belem),
        ("Asia/Aqtobe", Tz::Asia__Aqtobe),
        ("Pacific/Pitcairn", Tz::Pacific__Pitcairn),
        ("Asia/Ulan_Bator", Tz::Asia__Ulan_Bator),
        ("Etc/GMT+12", Tz::Etc__GMTPlus12),
        ("Europe/Budapest", Tz::Europe__Budapest),
        ("America/Guatemala", Tz::America__Guatemala),
        ("Asia/Tokyo", Tz::Asia__Tokyo),
        ("America/Atka", Tz::America__Atka),
        ("Brazil/DeNoronha", Tz::Brazil__DeNoronha),
        ("Australia/North", Tz::Australia__North),
        ("Universal", Tz::Universal),
        ("Canada/Pacific", Tz::Canada__Pacific),
        ("Asia/Novosibirsk", Tz::Asia__Novosibirsk),
        ("ROC", Tz::ROC),
        ("America/Curacao", Tz::America__Curacao),
        ("Asia/Ujung_Pandang", Tz::Asia__Ujung_Pandang),
        ("Asia/Ust-Nera", Tz::Asia__UstNera),
        ("Pacific/Majuro", Tz::Pacific__Majuro),
        ("Pacific/Kosrae", Tz::Pacific__Kosrae),
        ("Africa/Cairo", Tz::Africa__Cairo),
        ("Asia/Istanbul", Tz::Asia__Istanbul),
        ("Asia/Yangon", Tz::Asia__Yangon),
        ("Japan", Tz::Japan),
        ("Africa/Porto-Novo", Tz::Africa__PortoNovo),
        ("Africa/Ouagadougou", Tz::Africa__Ouagadougou),
        ("Pacific/Truk", Tz::Pacific__Truk),
        ("Australia/Perth", Tz::Australia__Perth),
        ("Asia/Singapore", Tz::Asia__Singapore),
        ("US/Aleutian", Tz::US__Aleutian),
        ("Asia/Seoul", Tz::Asia__Seoul),
        ("America/Regina", Tz::America__Regina),
        ("Europe/Saratov", Tz::Europe__Saratov),
        ("Pacific/Efate", Tz::Pacific__Efate),
        ("Antarctica/Macquarie", Tz::Antarctica__Macquarie),
        ("Atlantic/Faeroe", Tz::Atlantic__Faeroe),
        ("Asia/Damascus", Tz::Asia__Damascus),
        ("Asia/Vladivostok", Tz::Asia__Vladivostok),
        ("Asia/Gaza", Tz::Asia__Gaza),
        ("Africa/El_Aaiun", Tz::Africa__El_Aaiun),
        ("America/Port_of_Spain", Tz::America__Port_of_Spain),
        ("America/Argentina/Mendoza", Tz::America__Argentina__Mendoza),
        ("America/Jujuy", Tz::America__Jujuy),
        ("Pacific/Kwajalein", Tz::Pacific__Kwajalein),
        ("Asia/Manila", Tz::Asia__Manila),
        ("Etc/GMT+9", Tz::Etc__GMTPlus9),
        ("Europe/Berlin", Tz::Europe__Berlin),
        ("America/Rio_Branco", Tz::America__Rio_Branco),
        ("America/St_Vincent", Tz::America__St_Vincent),
        ("Etc/GMT+5", Tz::Etc__GMTPlus5),
        ("Africa/Kinshasa", Tz::Africa__Kinshasa),
        ("America/Argentina/Catamarca", Tz::America__Argentina__Catamarca),
        ("Asia/Baghdad", Tz::Asia__Baghdad),
        ("Etc/GMT-1", Tz::Etc__GMTMinus1),
        ("Europe/Gibraltar", Tz::Europe__Gibraltar),
        ("Africa/Banjul", Tz::Africa__Banjul),
        ("America/Argentina/ComodRivadavia", Tz::America__Argentina__ComodRivadavia),
        ("Europe/Sarajevo", Tz::Europe__Sarajevo),
        ("America/Indiana/Indianapolis", Tz::America__Indiana__Indianapolis),
        ("Europe/Kiev", Tz::Europe__Kiev),
        ("US/Pacific", Tz::US__Pacific),
        ("America/Metlakatla", Tz::America__Metlakatla),
        ("Europe/Uzhgorod", Tz::Europe__Uzhgorod),
        ("Asia/Hovd", Tz::Asia__Hovd),
        ("Etc/UCT", Tz::Etc__UCT),
        ("Australia/Darwin", Tz::Australia__Darwin),
        ("America/North_Dakota/Center", Tz::America__North_Dakota__Center),
        ("Asia/Dacca", Tz::Asia__Dacca),
        ("Atlantic/Canary", Tz::Atlantic__Canary),
        ("Pacific/Guadalcanal", Tz::Pacific__Guadalcanal),
        ("Asia/Macau", Tz::Asia__Macau),
        ("Europe/Tallinn", Tz::Europe__Tallinn),
        ("Africa/Blantyre", Tz::Africa__Blantyre),
        ("Africa/Timbuktu", Tz::Africa__Timbuktu),
        ("Pacific/Galapagos", Tz::Pacific__Galapagos),
        ("America/Boa_Vista", Tz::America__Boa_Vista),
        ("America/El_Salvador", Tz::America__El_Salvador),
        ("Australia/Brisbane", Tz::Australia__Brisbane),
        ("America/Puerto_Rico", Tz::America__Puerto_Rico),
        ("Africa/Niamey", Tz::Africa__Niamey),
        ("Europe/Andorra", Tz::Europe__Andorra),
        ("Antarctica/Vostok", Tz::Antarctica__Vostok),
        ("Asia/Thimbu", Tz::Asia__Thimbu),
        ("Africa/Asmera", Tz::Africa__Asmera),
        ("America/Indiana/Winamac", Tz::America__Indiana__Winamac),
        ("MST7MDT", Tz::MST7MDT),
        ("America/St_Thomas", Tz::America__St_Thomas),
        ("CET", Tz::CET),
        ("Canada/Mountain", Tz::Canada__Mountain),
        ("America/Santarem", Tz::America__Santarem),
        ("Antarctica/Syowa", Tz::Antarctica__Syowa),
        ("Europe/Bucharest", Tz::Europe__Bucharest),
        ("Europe/Vaduz", Tz::Europe__Vaduz),
        ("Europe/Tiraspol", Tz::Europe__Tiraspol),
        ("Europe/Istanbul", Tz::Europe__Istanbul),
        ("Asia/Saigon", Tz::Asia__Saigon),
        ("UTC", Tz::UTC),
        ("Turkey", Tz::Turkey),
        ("America/Edmonton", Tz::America__Edmonton),
        ("Etc/GMT-9", Tz::Etc__GMTMinus9),
        ("Hongkong", Tz::Hongkong),
        ("Indian/Mahe", Tz::Indian__Mahe),
        ("Asia/Kamchatka", Tz::Asia__Kamchatka),
        ("Africa/Nairobi", Tz::Africa__Nairobi),
        ("Europe/Samara", Tz::Europe__Samara),
        ("Pacific/Chatham", Tz::Pacific__Chatham),
        ("America/Guadeloupe", Tz::America__Guadeloupe),
        ("Europe/Warsaw", Tz::Europe__Warsaw),
        ("America/New_York", Tz::America__New_York),
        ("Africa/Windhoek", Tz::Africa__Windhoek),
        ("America/Panama", Tz::America__Panama),
        ("America/Argentina/Ushuaia", Tz::America__Argentina__Ushuaia),
        ("Asia/Sakhalin", Tz::Asia__Sakhalin),
        ("America/La_Paz", Tz::America__La_Paz),
        ("US/Arizona", Tz::US__Arizona),
        ("US/Eastern", Tz::US__Eastern),
        ("Pacific/Fakaofo", Tz::Pacific__Fakaofo),
        ("Asia/Kuwait", Tz::Asia__Kuwait),
        ("America/Argentina/Salta", Tz::America__Argentina__Salta),
        ("Indian/Comoro", Tz::Indian__Comoro),
        ("Pacific/Funafuti", Tz::Pacific__Funafuti),
        ("Asia/Tel_Aviv", Tz::Asia__Tel_Aviv),
        ("Europe/Dublin", Tz::Europe__Dublin),
        ("America/Mendoza", Tz::America__Mendoza),
        ("US/Mountain", Tz::US__Mountain),
        ("Pacific/Nauru", Tz::Pacific__Nauru),
        ("America/Kentucky/Louisville", Tz::America__Kentucky__Louisville),
        ("Atlantic/Azores", Tz::Atlantic__Azores),
        ("Etc/GMT-2", Tz::Etc__GMTMinus2),
        ("Canada/Central", Tz::Canada__Central),
        ("Africa/Addis_Ababa", Tz::Africa__Addis_Ababa),
        ("Europe/Amsterdam", Tz::Europe__Amsterdam),
        ("Etc/GMT-11", Tz::Etc__GMTMinus11),
        ("US/Hawaii", Tz::US__Hawaii),
        ("Asia/Amman", Tz::Asia__Amman),
        ("America/Manaus", Tz::America__Manaus),
        ("America/Menominee", Tz::America__Menominee),
        ("Asia/Yekaterinburg", Tz::Asia__Yekaterinburg),
        ("America/Araguaina", Tz::America__Araguaina),
        ("Africa/Bujumbura", Tz::Africa__Bujumbura),
        ("Antarctica/Rothera", Tz::Antarctica__Rothera),
        ("Asia/Bishkek", Tz::Asia__Bishkek),
        ("America/Grenada", Tz::America__Grenada),
        ("Asia/Calcutta", Tz::Asia__Calcutta),
        ("America/Martinique", Tz::America__Martinique),
        ("Asia/Jayapura", Tz::Asia__Jayapura),
        ("America/Cancun", Tz::America__Cancun),
        ("America/Argentina/Tucuman", Tz::America__Argentina__Tucuman),
        ("Asia/Chongqing", Tz::Asia__Chongqing),
        ("America/Rankin_Inlet", Tz::America__Rankin_Inlet),
        ("Indian/Cocos", Tz::Indian__Cocos),
        ("US/East-Indiana", Tz::US__EastIndiana),
        ("Etc/GMT+10", Tz::Etc__GMTPlus10),
        ("EST", Tz::EST),
        ("America/Ciudad_Juarez", Tz::America__Ciudad_Juarez),
        ("Europe/Helsinki", Tz::Europe__Helsinki),
        ("Etc/GMT-13", Tz::Etc__GMTMinus13),
        ("America/Fort_Nelson", Tz::America__Fort_Nelson),
        ("US/Indiana-Starke", Tz::US__IndianaStarke),
        ("Asia/Pontianak", Tz::Asia__Pontianak),
        ("Pacific/Norfolk", Tz::Pacific__Norfolk),
        ("Africa/Bamako", Tz::Africa__Bamako),
        ("Australia/Eucla", Tz::Australia__Eucla),
        ("Australia/Queensland", Tz::Australia__Queensland),
        ("Europe/Prague", Tz::Europe__Prague),
        ("Asia/Tbilisi", Tz::Asia__Tbilisi),
        ("Africa/Malabo", Tz::Africa__Malabo),
        ("Pacific/Apia", Tz::Pacific__Apia),
        ("Asia/Phnom_Penh", Tz::Asia__Phnom_Penh),
        ("Atlantic/Cape_Verde", Tz::Atlantic__Cape_Verde),
        ("Asia/Dili", Tz::Asia__Dili),
        ("Pacific/Pago_Pago", Tz::Pacific__Pago_Pago),
        ("America/Thule", Tz::America__Thule),
        ("Pacific/Port_Moresby", Tz::Pacific__Port_Moresby),
        ("Africa/Kigali", Tz::Africa__Kigali),
        ("Canada/Yukon", Tz::Canada__Yukon),
        ("Asia/Colombo", Tz::Asia__Colombo),
        ("Jamaica", Tz::Jamaica),
        ("America/Argentina/Cordoba", Tz::America__Argentina__Cordoba),
        ("Kwajalein", Tz::Kwajalein),
        ("Pacific/Gambier", Tz::Pacific__Gambier),
        ("America/North_Dakota/New_Salem", Tz::America__North_Dakota__New_Salem),
        ("Etc/GMT-10", Tz::Etc__GMTMinus10),
        ("Europe/Jersey", Tz::Europe__Jersey),
        ("Etc/GMT-3", Tz::Etc__GMTMinus3),
        ("Etc/GMT+1", Tz::Etc__GMTPlus1),
        ("America/Rosario", Tz::America__Rosario),
        ("Asia/Nicosia", Tz::Asia__Nicosia),
        ("America/Lima", Tz::America__Lima),
        ("Pacific/Ponape", Tz::Pacific__Ponape),
        ("Africa/Libreville", Tz::Africa__Libreville),
        ("Europe/Skopje", Tz::Europe__Skopje),
        ("Europe/Paris", Tz::Europe__Paris),
        ("Africa/Brazzaville", Tz::Africa__Brazzaville),
        ("Africa/Johannesburg", Tz::Africa__Johannesburg),
        ("America/Lower_Princes", Tz::America__Lower_Princes),
        ("America/Argentina/Jujuy", Tz::America__Argentina__Jujuy),
        ("Asia/Kashgar", Tz::Asia__Kashgar),
        ("US/Michigan", Tz::US__Michigan),
        ("America/Dawson_Creek", Tz::America__Dawson_Creek),
        ("America/Indiana/Vincennes", Tz::America__Indiana__Vincennes),
        ("Asia/Tashkent", Tz::Asia__Tashkent),
        ("Africa/Freetown", Tz::Africa__Freetown),
        ("America/Anguilla", Tz::America__Anguilla),
        ("America/Argentina/Rio_Gallegos", Tz::America__Argentina__Rio_Gallegos),
        ("NZ", Tz::NZ),
        ("Atlantic/South_Georgia", Tz::Atlantic__South_Georgia),
        ("Europe/Isle_of_Man", Tz::Europe__Isle_of_Man),
        ("Africa/Ceuta", Tz::Africa__Ceuta),
        ("Asia/Kuching", Tz::Asia__Kuching),
        ("Asia/Hong_Kong", Tz::Asia__Hong_Kong),
        ("Australia/Hobart", Tz::Australia__Hobart),
        ("Africa/Asmara", Tz::Africa__Asmara),
        ("Europe/Rome", Tz::Europe__Rome),
        ("Atlantic/Faroe", Tz::Atlantic__Faroe),
        ("America/Cordoba", Tz::America__Cordoba),
        ("Pacific/Auckland", Tz::Pacific__Auckland),
        ("Europe/Oslo", Tz::Europe__Oslo),
        ("Europe/Astrakhan", Tz::Europe__Astrakhan),
        ("Brazil/East", Tz::Brazil__East),
        ("Africa/Lagos", Tz::Africa__Lagos),
        ("Africa/Mbabane", Tz::Africa__Mbabane),
        ("Brazil/Acre", Tz::Brazil__Acre),
        ("Indian/Chagos", Tz::Indian__Chagos),
        ("Europe/Podgorica", Tz::Europe__Podgorica),
        ("Antarctica/Troll", Tz::Antarctica__Troll),
        ("America/Porto_Acre", Tz::America__Porto_Acre),
        ("America/Dawson", Tz::America__Dawson),
        ("America/Cayenne", Tz::America__Cayenne),
        ("Africa/Bissau", Tz::Africa__Bissau),
        ("America/Nipigon", Tz::America__Nipigon),
        ("Asia/Choibalsan", Tz::Asia__Choibalsan),
        ("America/Argentina/San_Luis", Tz::America__Argentina__San_Luis),
        ("Asia/Dubai", Tz::Asia__Dubai),
        ("Europe/Ulyanovsk", Tz::Europe__Ulyanovsk),
        ("Australia/Melbourne", Tz::Australia__Melbourne),
        ("America/Cayman", Tz::America__Cayman),
        ("America/Mazatlan", Tz::America__Mazatlan),
        ("Cuba", Tz::Cuba),
        ("Egypt", Tz::Egypt),
        ("Africa/Tunis", Tz::Africa__Tunis),
        ("Asia/Ulaanbaatar", Tz::Asia__Ulaanbaatar),
        ("Europe/Chisinau", Tz::Europe__Chisinau),
        ("Australia/Lindeman", Tz::Australia__Lindeman),
        ("Mexico/General", Tz::Mexico__General),
        ("Australia/West", Tz::Australia__West),
        ("Asia/Tomsk", Tz::Asia__Tomsk),
        ("Europe/Kyiv", Tz::Europe__Kyiv),
        ("Europe/Volgograd", Tz::Europe__Volgograd),
        ("America/Scoresbysund", Tz::America__Scoresbysund),
        ("America/Pangnirtung", Tz::America__Pangnirtung),
        ("Chile/Continental", Tz::Chile__Continental),
        ("Asia/Qatar", Tz::Asia__Qatar),
        ("Asia/Qyzylorda", Tz::Asia__Qyzylorda),
        ("Asia/Novokuznetsk", Tz::Asia__Novokuznetsk),
        ("Australia/LHI", Tz::Australia__LHI),
        ("Europe/Belfast", Tz::Europe__Belfast),
        ("Mexico/BajaSur", Tz::Mexico__BajaSur),
        ("Poland", Tz::Poland),
        ("Asia/Dushanbe", Tz::Asia__Dushanbe),
        ("Israel", Tz::Israel),
        ("America/Argentina/San_Juan", Tz::America__Argentina__San_Juan),
        ("Eire", Tz::Eire),
        ("Etc/GMT-5", Tz::Etc__GMTMinus5),
        ("America/Eirunepe", Tz::America__Eirunepe),
        ("Greenwich", Tz::Greenwich),
        ("America/Recife", Tz::America__Recife),
        ("Antarctica/Palmer", Tz::Antarctica__Palmer),
        ("America/Bogota", Tz::America__Bogota),
        ("Australia/South", Tz::Australia__South),
        ("America/Chihuahua", Tz::America__Chihuahua),
        ("Africa/Lubumbashi", Tz::Africa__Lubumbashi),
        ("Asia/Bahrain", Tz::Asia__Bahrain),
        ("Indian/Reunion", Tz::Indian__Reunion),
        ("Atlantic/Jan_Mayen", Tz::Atlantic__Jan_Mayen),
        ("Australia/Yancowinna", Tz::Australia__Yancowinna),
        ("Europe/Bratislava", Tz::Europe__Bratislava),
        ("America/Glace_Bay", Tz::America__Glace_Bay),
        ("Asia/Ho_Chi_Minh", Tz::Asia__Ho_Chi_Minh),
        ("GB", Tz::GB),
        ("Europe/Lisbon", Tz::Europe__Lisbon),
        ("Africa/Abidjan", Tz::Africa__Abidjan),
        ("Europe/Monaco", Tz::Europe__Monaco),
        ("Africa/Algiers", Tz::Africa__Algiers),
        ("Canada/Atlantic", Tz::Canada__Atlantic),
        ("Europe/Vienna", Tz::Europe__Vienna),
        ("America/Halifax", Tz::America__Halifax),
        ("America/Indianapolis", Tz::America__Indianapolis),
        ("America/Louisville", Tz::America__Louisville),
        ("America/St_Lucia", Tz::America__St_Lucia),
        ("America/Campo_Grande", Tz::America__Campo_Grande),
        ("Australia/NSW", Tz::Australia__NSW),
        ("Europe/Madrid", Tz::Europe__Madrid),
        ("America/Merida", Tz::America__Merida),
        ("GMT0", Tz::GMT0),
        ("Pacific/Rarotonga", Tz::Pacific__Rarotonga),
        ("Australia/Adelaide", Tz::Australia__Adelaide),
        ("Africa/Nouakchott", Tz::Africa__Nouakchott),
        ("GMT", Tz::GMT),
        ("Etc/GMT-14", Tz::Etc__GMTMinus14),
        ("America/Vancouver", Tz::America__Vancouver),
        ("America/Detroit", Tz::America__Detroit),
        ("America/Indiana/Knox", Tz::America__Indiana__Knox),
        ("Asia/Yerevan", Tz::Asia__Yerevan),
        ("CST6CDT", Tz::CST6CDT),
        ("America/Antigua", Tz::America__Antigua),
        ("HST", Tz::HST),
        ("Pacific/Tahiti", Tz::Pacific__Tahiti),
        ("Pacific/Chuuk", Tz::Pacific__Chuuk),
        ("Asia/Srednekolymsk", Tz::Asia__Srednekolymsk),
        ("WET", Tz::WET),
        ("US/Samoa", Tz::US__Samoa),
        ("Pacific/Kanton", Tz::Pacific__Kanton),
        ("Africa/Sao_Tome", Tz::Africa__Sao_Tome),
        ("Asia/Oral", Tz::Asia__Oral),
        ("America/Aruba", Tz::America__Aruba),
        ("America/Buenos_Aires", Tz::America__Buenos_Aires),
        ("Africa/Lusaka", Tz::Africa__Lusaka),
        ("Asia/Qostanay", Tz::Asia__Qostanay),
        ("America/Nassau", Tz::America__Nassau),
        ("Pacific/Bougainville", Tz::Pacific__Bougainville),
        ("Asia/Beirut", Tz::Asia__Beirut),
        ("Europe/Moscow", Tz::Europe__Moscow),
        ("PST8PDT", Tz::PST8PDT),
        ("Etc/GMT+4", Tz::Etc__GMTPlus4),
        ("GMT+0", Tz::GMTPlus0),
        ("America/Kentucky/Monticello", Tz::America__Kentucky__Monticello),
        ("Asia/Harbin", Tz::Asia__Harbin),
    ],
};
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
pub struct ParseError(());

impl Display for ParseError {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        f.write_str("failed to parse timezone")
    }
}

#[cfg(feature = "std")]
impl std::error::Error for ParseError {}

impl FromStr for Tz {
    type Err = ParseError;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        TIMEZONES.get(s).cloned().ok_or(ParseError(()))
    }
}

impl Tz {
    pub fn name(self) -> &'static str {
        match self {
            Tz::Africa__Abidjan => "Africa/Abidjan",
            Tz::Africa__Accra => "Africa/Accra",
            Tz::Africa__Addis_Ababa => "Africa/Addis_Ababa",
            Tz::Africa__Algiers => "Africa/Algiers",
            Tz::Africa__Asmara => "Africa/Asmara",
            Tz::Africa__Asmera => "Africa/Asmera",
            Tz::Africa__Bamako => "Africa/Bamako",
            Tz::Africa__Bangui => "Africa/Bangui",
            Tz::Africa__Banjul => "Africa/Banjul",
            Tz::Africa__Bissau => "Africa/Bissau",
            Tz::Africa__Blantyre => "Africa/Blantyre",
            Tz::Africa__Brazzaville => "Africa/Brazzaville",
            Tz::Africa__Bujumbura => "Africa/Bujumbura",
            Tz::Africa__Cairo => "Africa/Cairo",
            Tz::Africa__Casablanca => "Africa/Casablanca",
            Tz::Africa__Ceuta => "Africa/Ceuta",
            Tz::Africa__Conakry => "Africa/Conakry",
            Tz::Africa__Dakar => "Africa/Dakar",
            Tz::Africa__Dar_es_Salaam => "Africa/Dar_es_Salaam",
            Tz::Africa__Djibouti => "Africa/Djibouti",
            Tz::Africa__Douala => "Africa/Douala",
            Tz::Africa__El_Aaiun => "Africa/El_Aaiun",
            Tz::Africa__Freetown => "Africa/Freetown",
            Tz::Africa__Gaborone => "Africa/Gaborone",
            Tz::Africa__Harare => "Africa/Harare",
            Tz::Africa__Johannesburg => "Africa/Johannesburg",
            Tz::Africa__Juba => "Africa/Juba",
            Tz::Africa__Kampala => "Africa/Kampala",
            Tz::Africa__Khartoum => "Africa/Khartoum",
            Tz::Africa__Kigali => "Africa/Kigali",
            Tz::Africa__Kinshasa => "Africa/Kinshasa",
            Tz::Africa__Lagos => "Africa/Lagos",
            Tz::Africa__Libreville => "Africa/Libreville",
            Tz::Africa__Lome => "Africa/Lome",
            Tz::Africa__Luanda => "Africa/Luanda",
            Tz::Africa__Lubumbashi => "Africa/Lubumbashi",
            Tz::Africa__Lusaka => "Africa/Lusaka",
            Tz::Africa__Malabo => "Africa/Malabo",
            Tz::Africa__Maputo => "Africa/Maputo",
            Tz::Africa__Maseru => "Africa/Maseru",
            Tz::Africa__Mbabane => "Africa/Mbabane",
            Tz::Africa__Mogadishu => "Africa/Mogadishu",
            Tz::Africa__Monrovia => "Africa/Monrovia",
            Tz::Africa__Nairobi => "Africa/Nairobi",
            Tz::Africa__Ndjamena => "Africa/Ndjamena",
            Tz::Africa__Niamey => "Africa/Niamey",
            Tz::Africa__Nouakchott => "Africa/Nouakchott",
            Tz::Africa__Ouagadougou => "Africa/Ouagadougou",
            Tz::Africa__PortoNovo => "Africa/Porto-Novo",
            Tz::Africa__Sao_Tome => "Africa/Sao_Tome",
            Tz::Africa__Timbuktu => "Africa/Timbuktu",
            Tz::Africa__Tripoli => "Africa/Tripoli",
            Tz::Africa__Tunis => "Africa/Tunis",
            Tz::Africa__Windhoek => "Africa/Windhoek",
            Tz::America__Adak => "America/Adak",
            Tz::America__Anchorage => "America/Anchorage",
            Tz::America__Anguilla => "America/Anguilla",
            Tz::America__Antigua => "America/Antigua",
            Tz::America__Araguaina => "America/Araguaina",
            Tz::America__Argentina__Buenos_Aires => "America/Argentina/Buenos_Aires",
            Tz::America__Argentina__Catamarca => "America/Argentina/Catamarca",
            Tz::America__Argentina__ComodRivadavia => "America/Argentina/ComodRivadavia",
            Tz::America__Argentina__Cordoba => "America/Argentina/Cordoba",
            Tz::America__Argentina__Jujuy => "America/Argentina/Jujuy",
            Tz::America__Argentina__La_Rioja => "America/Argentina/La_Rioja",
            Tz::America__Argentina__Mendoza => "America/Argentina/Mendoza",
            Tz::America__Argentina__Rio_Gallegos => "America/Argentina/Rio_Gallegos",
            Tz::America__Argentina__Salta => "America/Argentina/Salta",
            Tz::America__Argentina__San_Juan => "America/Argentina/San_Juan",
            Tz::America__Argentina__San_Luis => "America/Argentina/San_Luis",
            Tz::America__Argentina__Tucuman => "America/Argentina/Tucuman",
            Tz::America__Argentina__Ushuaia => "America/Argentina/Ushuaia",
            Tz::America__Aruba => "America/Aruba",
            Tz::America__Asuncion => "America/Asuncion",
            Tz::America__Atikokan => "America/Atikokan",
            Tz::America__Atka => "America/Atka",
            Tz::America__Bahia => "America/Bahia",
            Tz::America__Bahia_Banderas => "America/Bahia_Banderas",
            Tz::America__Barbados => "America/Barbados",
            Tz::America__Belem => "America/Belem",
            Tz::America__Belize => "America/Belize",
            Tz::America__BlancSablon => "America/Blanc-Sablon",
            Tz::America__Boa_Vista => "America/Boa_Vista",
            Tz::America__Bogota => "America/Bogota",
            Tz::America__Boise => "America/Boise",
            Tz::America__Buenos_Aires => "America/Buenos_Aires",
            Tz::America__Cambridge_Bay => "America/Cambridge_Bay",
            Tz::America__Campo_Grande => "America/Campo_Grande",
            Tz::America__Cancun => "America/Cancun",
            Tz::America__Caracas => "America/Caracas",
            Tz::America__Catamarca => "America/Catamarca",
            Tz::America__Cayenne => "America/Cayenne",
            Tz::America__Cayman => "America/Cayman",
            Tz::America__Chicago => "America/Chicago",
            Tz::America__Chihuahua => "America/Chihuahua",
            Tz::America__Ciudad_Juarez => "America/Ciudad_Juarez",
            Tz::America__Coral_Harbour => "America/Coral_Harbour",
            Tz::America__Cordoba => "America/Cordoba",
            Tz::America__Costa_Rica => "America/Costa_Rica",
            Tz::America__Coyhaique => "America/Coyhaique",
            Tz::America__Creston => "America/Creston",
            Tz::America__Cuiaba => "America/Cuiaba",
            Tz::America__Curacao => "America/Curacao",
            Tz::America__Danmarkshavn => "America/Danmarkshavn",
            Tz::America__Dawson => "America/Dawson",
            Tz::America__Dawson_Creek => "America/Dawson_Creek",
            Tz::America__Denver => "America/Denver",
            Tz::America__Detroit => "America/Detroit",
            Tz::America__Dominica => "America/Dominica",
            Tz::America__Edmonton => "America/Edmonton",
            Tz::America__Eirunepe => "America/Eirunepe",
            Tz::America__El_Salvador => "America/El_Salvador",
            Tz::America__Ensenada => "America/Ensenada",
            Tz::America__Fort_Nelson => "America/Fort_Nelson",
            Tz::America__Fort_Wayne => "America/Fort_Wayne",
            Tz::America__Fortaleza => "America/Fortaleza",
            Tz::America__Glace_Bay => "America/Glace_Bay",
            Tz::America__Godthab => "America/Godthab",
            Tz::America__Goose_Bay => "America/Goose_Bay",
            Tz::America__Grand_Turk => "America/Grand_Turk",
            Tz::America__Grenada => "America/Grenada",
            Tz::America__Guadeloupe => "America/Guadeloupe",
            Tz::America__Guatemala => "America/Guatemala",
            Tz::America__Guayaquil => "America/Guayaquil",
            Tz::America__Guyana => "America/Guyana",
            Tz::America__Halifax => "America/Halifax",
            Tz::America__Havana => "America/Havana",
            Tz::America__Hermosillo => "America/Hermosillo",
            Tz::America__Indiana__Indianapolis => "America/Indiana/Indianapolis",
            Tz::America__Indiana__Knox => "America/Indiana/Knox",
            Tz::America__Indiana__Marengo => "America/Indiana/Marengo",
            Tz::America__Indiana__Petersburg => "America/Indiana/Petersburg",
            Tz::America__Indiana__Tell_City => "America/Indiana/Tell_City",
            Tz::America__Indiana__Vevay => "America/Indiana/Vevay",
            Tz::America__Indiana__Vincennes => "America/Indiana/Vincennes",
            Tz::America__Indiana__Winamac => "America/Indiana/Winamac",
            Tz::America__Indianapolis => "America/Indianapolis",
            Tz::America__Inuvik => "America/Inuvik",
            Tz::America__Iqaluit => "America/Iqaluit",
            Tz::America__Jamaica => "America/Jamaica",
            Tz::America__Jujuy => "America/Jujuy",
            Tz::America__Juneau => "America/Juneau",
            Tz::America__Kentucky__Louisville => "America/Kentucky/Louisville",
            Tz::America__Kentucky__Monticello => "America/Kentucky/Monticello",
            Tz::America__Knox_IN => "America/Knox_IN",
            Tz::America__Kralendijk => "America/Kralendijk",
            Tz::America__La_Paz => "America/La_Paz",
            Tz::America__Lima => "America/Lima",
            Tz::America__Los_Angeles => "America/Los_Angeles",
            Tz::America__Louisville => "America/Louisville",
            Tz::America__Lower_Princes => "America/Lower_Princes",
            Tz::America__Maceio => "America/Maceio",
            Tz::America__Managua => "America/Managua",
            Tz::America__Manaus => "America/Manaus",
            Tz::America__Marigot => "America/Marigot",
            Tz::America__Martinique => "America/Martinique",
            Tz::America__Matamoros => "America/Matamoros",
            Tz::America__Mazatlan => "America/Mazatlan",
            Tz::America__Mendoza => "America/Mendoza",
            Tz::America__Menominee => "America/Menominee",
            Tz::America__Merida => "America/Merida",
            Tz::America__Metlakatla => "America/Metlakatla",
            Tz::America__Mexico_City => "America/Mexico_City",
            Tz::America__Miquelon => "America/Miquelon",
            Tz::America__Moncton => "America/Moncton",
            Tz::America__Monterrey => "America/Monterrey",
            Tz::America__Montevideo => "America/Montevideo",
            Tz::America__Montreal => "America/Montreal",
            Tz::America__Montserrat => "America/Montserrat",
            Tz::America__Nassau => "America/Nassau",
            Tz::America__New_York => "America/New_York",
            Tz::America__Nipigon => "America/Nipigon",
            Tz::America__Nome => "America/Nome",
            Tz::America__Noronha => "America/Noronha",
            Tz::America__North_Dakota__Beulah => "America/North_Dakota/Beulah",
            Tz::America__North_Dakota__Center => "America/North_Dakota/Center",
            Tz::America__North_Dakota__New_Salem => "America/North_Dakota/New_Salem",
            Tz::America__Nuuk => "America/Nuuk",
            Tz::America__Ojinaga => "America/Ojinaga",
            Tz::America__Panama => "America/Panama",
            Tz::America__Pangnirtung => "America/Pangnirtung",
            Tz::America__Paramaribo => "America/Paramaribo",
            Tz::America__Phoenix => "America/Phoenix",
            Tz::America__PortauPrince => "America/Port-au-Prince",
            Tz::America__Port_of_Spain => "America/Port_of_Spain",
            Tz::America__Porto_Acre => "America/Porto_Acre",
            Tz::America__Porto_Velho => "America/Porto_Velho",
            Tz::America__Puerto_Rico => "America/Puerto_Rico",
            Tz::America__Punta_Arenas => "America/Punta_Arenas",
            Tz::America__Rainy_River => "America/Rainy_River",
            Tz::America__Rankin_Inlet => "America/Rankin_Inlet",
            Tz::America__Recife => "America/Recife",
            Tz::America__Regina => "America/Regina",
            Tz::America__Resolute => "America/Resolute",
            Tz::America__Rio_Branco => "America/Rio_Branco",
            Tz::America__Rosario => "America/Rosario",
            Tz::America__Santa_Isabel => "America/Santa_Isabel",
            Tz::America__Santarem => "America/Santarem",
            Tz::America__Santiago => "America/Santiago",
            Tz::America__Santo_Domingo => "America/Santo_Domingo",
            Tz::America__Sao_Paulo => "America/Sao_Paulo",
            Tz::America__Scoresbysund => "America/Scoresbysund",
            Tz::America__Shiprock => "America/Shiprock",
            Tz::America__Sitka => "America/Sitka",
            Tz::America__St_Barthelemy => "America/St_Barthelemy",
            Tz::America__St_Johns => "America/St_Johns",
            Tz::America__St_Kitts => "America/St_Kitts",
            Tz::America__St_Lucia => "America/St_Lucia",
            Tz::America__St_Thomas => "America/St_Thomas",
            Tz::America__St_Vincent => "America/St_Vincent",
            Tz::America__Swift_Current => "America/Swift_Current",
            Tz::America__Tegucigalpa => "America/Tegucigalpa",
            Tz::America__Thule => "America/Thule",
            Tz::America__Thunder_Bay => "America/Thunder_Bay",
            Tz::America__Tijuana => "America/Tijuana",
            Tz::America__Toronto => "America/Toronto",
            Tz::America__Tortola => "America/Tortola",
            Tz::America__Vancouver => "America/Vancouver",
            Tz::America__Virgin => "America/Virgin",
            Tz::America__Whitehorse => "America/Whitehorse",
            Tz::America__Winnipeg => "America/Winnipeg",
            Tz::America__Yakutat => "America/Yakutat",
            Tz::America__Yellowknife => "America/Yellowknife",
            Tz::Antarctica__Casey => "Antarctica/Casey",
            Tz::Antarctica__Davis => "Antarctica/Davis",
            Tz::Antarctica__DumontDUrville => "Antarctica/DumontDUrville",
            Tz::Antarctica__Macquarie => "Antarctica/Macquarie",
            Tz::Antarctica__Mawson => "Antarctica/Mawson",
            Tz::Antarctica__McMurdo => "Antarctica/McMurdo",
            Tz::Antarctica__Palmer => "Antarctica/Palmer",
            Tz::Antarctica__Rothera => "Antarctica/Rothera",
            Tz::Antarctica__South_Pole => "Antarctica/South_Pole",
            Tz::Antarctica__Syowa => "Antarctica/Syowa",
            Tz::Antarctica__Troll => "Antarctica/Troll",
            Tz::Antarctica__Vostok => "Antarctica/Vostok",
            Tz::Arctic__Longyearbyen => "Arctic/Longyearbyen",
            Tz::Asia__Aden => "Asia/Aden",
            Tz::Asia__Almaty => "Asia/Almaty",
            Tz::Asia__Amman => "Asia/Amman",
            Tz::Asia__Anadyr => "Asia/Anadyr",
            Tz::Asia__Aqtau => "Asia/Aqtau",
            Tz::Asia__Aqtobe => "Asia/Aqtobe",
            Tz::Asia__Ashgabat => "Asia/Ashgabat",
            Tz::Asia__Ashkhabad => "Asia/Ashkhabad",
            Tz::Asia__Atyrau => "Asia/Atyrau",
            Tz::Asia__Baghdad => "Asia/Baghdad",
            Tz::Asia__Bahrain => "Asia/Bahrain",
            Tz::Asia__Baku => "Asia/Baku",
            Tz::Asia__Bangkok => "Asia/Bangkok",
            Tz::Asia__Barnaul => "Asia/Barnaul",
            Tz::Asia__Beirut => "Asia/Beirut",
            Tz::Asia__Bishkek => "Asia/Bishkek",
            Tz::Asia__Brunei => "Asia/Brunei",
            Tz::Asia__Calcutta => "Asia/Calcutta",
            Tz::Asia__Chita => "Asia/Chita",
            Tz::Asia__Choibalsan => "Asia/Choibalsan",
            Tz::Asia__Chongqing => "Asia/Chongqing",
            Tz::Asia__Chungking => "Asia/Chungking",
            Tz::Asia__Colombo => "Asia/Colombo",
            Tz::Asia__Dacca => "Asia/Dacca",
            Tz::Asia__Damascus => "Asia/Damascus",
            Tz::Asia__Dhaka => "Asia/Dhaka",
            Tz::Asia__Dili => "Asia/Dili",
            Tz::Asia__Dubai => "Asia/Dubai",
            Tz::Asia__Dushanbe => "Asia/Dushanbe",
            Tz::Asia__Famagusta => "Asia/Famagusta",
            Tz::Asia__Gaza => "Asia/Gaza",
            Tz::Asia__Harbin => "Asia/Harbin",
            Tz::Asia__Hebron => "Asia/Hebron",
            Tz::Asia__Ho_Chi_Minh => "Asia/Ho_Chi_Minh",
            Tz::Asia__Hong_Kong => "Asia/Hong_Kong",
            Tz::Asia__Hovd => "Asia/Hovd",
            Tz::Asia__Irkutsk => "Asia/Irkutsk",
            Tz::Asia__Istanbul => "Asia/Istanbul",
            Tz::Asia__Jakarta => "Asia/Jakarta",
            Tz::Asia__Jayapura => "Asia/Jayapura",
            Tz::Asia__Jerusalem => "Asia/Jerusalem",
            Tz::Asia__Kabul => "Asia/Kabul",
            Tz::Asia__Kamchatka => "Asia/Kamchatka",
            Tz::Asia__Karachi => "Asia/Karachi",
            Tz::Asia__Kashgar => "Asia/Kashgar",
            Tz::Asia__Kathmandu => "Asia/Kathmandu",
            Tz::Asia__Katmandu => "Asia/Katmandu",
            Tz::Asia__Khandyga => "Asia/Khandyga",
            Tz::Asia__Kolkata => "Asia/Kolkata",
            Tz::Asia__Krasnoyarsk => "Asia/Krasnoyarsk",
            Tz::Asia__Kuala_Lumpur => "Asia/Kuala_Lumpur",
            Tz::Asia__Kuching => "Asia/Kuching",
            Tz::Asia__Kuwait => "Asia/Kuwait",
            Tz::Asia__Macao => "Asia/Macao",
            Tz::Asia__Macau => "Asia/Macau",
            Tz::Asia__Magadan => "Asia/Magadan",
            Tz::Asia__Makassar => "Asia/Makassar",
            Tz::Asia__Manila => "Asia/Manila",
            Tz::Asia__Muscat => "Asia/Muscat",
            Tz::Asia__Nicosia => "Asia/Nicosia",
            Tz::Asia__Novokuznetsk => "Asia/Novokuznetsk",
            Tz::Asia__Novosibirsk => "Asia/Novosibirsk",
            Tz::Asia__Omsk => "Asia/Omsk",
            Tz::Asia__Oral => "Asia/Oral",
            Tz::Asia__Phnom_Penh => "Asia/Phnom_Penh",
            Tz::Asia__Pontianak => "Asia/Pontianak",
            Tz::Asia__Pyongyang => "Asia/Pyongyang",
            Tz::Asia__Qatar => "Asia/Qatar",
            Tz::Asia__Qostanay => "Asia/Qostanay",
            Tz::Asia__Qyzylorda => "Asia/Qyzylorda",
            Tz::Asia__Rangoon => "Asia/Rangoon",
            Tz::Asia__Riyadh => "Asia/Riyadh",
            Tz::Asia__Saigon => "Asia/Saigon",
            Tz::Asia__Sakhalin => "Asia/Sakhalin",
            Tz::Asia__Samarkand => "Asia/Samarkand",
            Tz::Asia__Seoul => "Asia/Seoul",
            Tz::Asia__Shanghai => "Asia/Shanghai",
            Tz::Asia__Singapore => "Asia/Singapore",
            Tz::Asia__Srednekolymsk => "Asia/Srednekolymsk",
            Tz::Asia__Taipei => "Asia/Taipei",
            Tz::Asia__Tashkent => "Asia/Tashkent",
            Tz::Asia__Tbilisi => "Asia/Tbilisi",
            Tz::Asia__Tehran => "Asia/Tehran",
            Tz::Asia__Tel_Aviv => "Asia/Tel_Aviv",
            Tz::Asia__Thimbu => "Asia/Thimbu",
            Tz::Asia__Thimphu => "Asia/Thimphu",
            Tz::Asia__Tokyo => "Asia/Tokyo",
            Tz::Asia__Tomsk => "Asia/Tomsk",
            Tz::Asia__Ujung_Pandang => "Asia/Ujung_Pandang",
            Tz::Asia__Ulaanbaatar => "Asia/Ulaanbaatar",
            Tz::Asia__Ulan_Bator => "Asia/Ulan_Bator",
            Tz::Asia__Urumqi => "Asia/Urumqi",
            Tz::Asia__UstNera => "Asia/Ust-Nera",
            Tz::Asia__Vientiane => "Asia/Vientiane",
            Tz::Asia__Vladivostok => "Asia/Vladivostok",
            Tz::Asia__Yakutsk => "Asia/Yakutsk",
            Tz::Asia__Yangon => "Asia/Yangon",
            Tz::Asia__Yekaterinburg => "Asia/Yekaterinburg",
            Tz::Asia__Yerevan => "Asia/Yerevan",
            Tz::Atlantic__Azores => "Atlantic/Azores",
            Tz::Atlantic__Bermuda => "Atlantic/Bermuda",
            Tz::Atlantic__Canary => "Atlantic/Canary",
            Tz::Atlantic__Cape_Verde => "Atlantic/Cape_Verde",
            Tz::Atlantic__Faeroe => "Atlantic/Faeroe",
            Tz::Atlantic__Faroe => "Atlantic/Faroe",
            Tz::Atlantic__Jan_Mayen => "Atlantic/Jan_Mayen",
            Tz::Atlantic__Madeira => "Atlantic/Madeira",
            Tz::Atlantic__Reykjavik => "Atlantic/Reykjavik",
            Tz::Atlantic__South_Georgia => "Atlantic/South_Georgia",
            Tz::Atlantic__St_Helena => "Atlantic/St_Helena",
            Tz::Atlantic__Stanley => "Atlantic/Stanley",
            Tz::Australia__ACT => "Australia/ACT",
            Tz::Australia__Adelaide => "Australia/Adelaide",
            Tz::Australia__Brisbane => "Australia/Brisbane",
            Tz::Australia__Broken_Hill => "Australia/Broken_Hill",
            Tz::Australia__Canberra => "Australia/Canberra",
            Tz::Australia__Currie => "Australia/Currie",
            Tz::Australia__Darwin => "Australia/Darwin",
            Tz::Australia__Eucla => "Australia/Eucla",
            Tz::Australia__Hobart => "Australia/Hobart",
            Tz::Australia__LHI => "Australia/LHI",
            Tz::Australia__Lindeman => "Australia/Lindeman",
            Tz::Australia__Lord_Howe => "Australia/Lord_Howe",
            Tz::Australia__Melbourne => "Australia/Melbourne",
            Tz::Australia__NSW => "Australia/NSW",
            Tz::Australia__North => "Australia/North",
            Tz::Australia__Perth => "Australia/Perth",
            Tz::Australia__Queensland => "Australia/Queensland",
            Tz::Australia__South => "Australia/South",
            Tz::Australia__Sydney => "Australia/Sydney",
            Tz::Australia__Tasmania => "Australia/Tasmania",
            Tz::Australia__Victoria => "Australia/Victoria",
            Tz::Australia__West => "Australia/West",
            Tz::Australia__Yancowinna => "Australia/Yancowinna",
            Tz::Brazil__Acre => "Brazil/Acre",
            Tz::Brazil__DeNoronha => "Brazil/DeNoronha",
            Tz::Brazil__East => "Brazil/East",
            Tz::Brazil__West => "Brazil/West",
            Tz::CET => "CET",
            Tz::CST6CDT => "CST6CDT",
            Tz::Canada__Atlantic => "Canada/Atlantic",
            Tz::Canada__Central => "Canada/Central",
            Tz::Canada__Eastern => "Canada/Eastern",
            Tz::Canada__Mountain => "Canada/Mountain",
            Tz::Canada__Newfoundland => "Canada/Newfoundland",
            Tz::Canada__Pacific => "Canada/Pacific",
            Tz::Canada__Saskatchewan => "Canada/Saskatchewan",
            Tz::Canada__Yukon => "Canada/Yukon",
            Tz::Chile__Continental => "Chile/Continental",
            Tz::Chile__EasterIsland => "Chile/EasterIsland",
            Tz::Cuba => "Cuba",
            Tz::EET => "EET",
            Tz::EST => "EST",
            Tz::EST5EDT => "EST5EDT",
            Tz::Egypt => "Egypt",
            Tz::Eire => "Eire",
            Tz::Etc__GMT => "Etc/GMT",
            Tz::Etc__GMTPlus0 => "Etc/GMT+0",
            Tz::Etc__GMTPlus1 => "Etc/GMT+1",
            Tz::Etc__GMTPlus10 => "Etc/GMT+10",
            Tz::Etc__GMTPlus11 => "Etc/GMT+11",
            Tz::Etc__GMTPlus12 => "Etc/GMT+12",
            Tz::Etc__GMTPlus2 => "Etc/GMT+2",
            Tz::Etc__GMTPlus3 => "Etc/GMT+3",
            Tz::Etc__GMTPlus4 => "Etc/GMT+4",
            Tz::Etc__GMTPlus5 => "Etc/GMT+5",
            Tz::Etc__GMTPlus6 => "Etc/GMT+6",
            Tz::Etc__GMTPlus7 => "Etc/GMT+7",
            Tz::Etc__GMTPlus8 => "Etc/GMT+8",
            Tz::Etc__GMTPlus9 => "Etc/GMT+9",
            Tz::Etc__GMTMinus0 => "Etc/GMT-0",
            Tz::Etc__GMTMinus1 => "Etc/GMT-1",
            Tz::Etc__GMTMinus10 => "Etc/GMT-10",
            Tz::Etc__GMTMinus11 => "Etc/GMT-11",
            Tz::Etc__GMTMinus12 => "Etc/GMT-12",
            Tz::Etc__GMTMinus13 => "Etc/GMT-13",
            Tz::Etc__GMTMinus14 => "Etc/GMT-14",
            Tz::Etc__GMTMinus2 => "Etc/GMT-2",
            Tz::Etc__GMTMinus3 => "Etc/GMT-3",
            Tz::Etc__GMTMinus4 => "Etc/GMT-4",
            Tz::Etc__GMTMinus5 => "Etc/GMT-5",
            Tz::Etc__GMTMinus6 => "Etc/GMT-6",
            Tz::Etc__GMTMinus7 => "Etc/GMT-7",
            Tz::Etc__GMTMinus8 => "Etc/GMT-8",
            Tz::Etc__GMTMinus9 => "Etc/GMT-9",
            Tz::Etc__GMT0 => "Etc/GMT0",
            Tz::Etc__Greenwich => "Etc/Greenwich",
            Tz::Etc__UCT => "Etc/UCT",
            Tz::Etc__UTC => "Etc/UTC",
            Tz::Etc__Universal => "Etc/Universal",
            Tz::Etc__Zulu => "Etc/Zulu",
            Tz::Europe__Amsterdam => "Europe/Amsterdam",
            Tz::Europe__Andorra => "Europe/Andorra",
            Tz::Europe__Astrakhan => "Europe/Astrakhan",
            Tz::Europe__Athens => "Europe/Athens",
            Tz::Europe__Belfast => "Europe/Belfast",
            Tz::Europe__Belgrade => "Europe/Belgrade",
            Tz::Europe__Berlin => "Europe/Berlin",
            Tz::Europe__Bratislava => "Europe/Bratislava",
            Tz::Europe__Brussels => "Europe/Brussels",
            Tz::Europe__Bucharest => "Europe/Bucharest",
            Tz::Europe__Budapest => "Europe/Budapest",
            Tz::Europe__Busingen => "Europe/Busingen",
            Tz::Europe__Chisinau => "Europe/Chisinau",
            Tz::Europe__Copenhagen => "Europe/Copenhagen",
            Tz::Europe__Dublin => "Europe/Dublin",
            Tz::Europe__Gibraltar => "Europe/Gibraltar",
            Tz::Europe__Guernsey => "Europe/Guernsey",
            Tz::Europe__Helsinki => "Europe/Helsinki",
            Tz::Europe__Isle_of_Man => "Europe/Isle_of_Man",
            Tz::Europe__Istanbul => "Europe/Istanbul",
            Tz::Europe__Jersey => "Europe/Jersey",
            Tz::Europe__Kaliningrad => "Europe/Kaliningrad",
            Tz::Europe__Kiev => "Europe/Kiev",
            Tz::Europe__Kirov => "Europe/Kirov",
            Tz::Europe__Kyiv => "Europe/Kyiv",
            Tz::Europe__Lisbon => "Europe/Lisbon",
            Tz::Europe__Ljubljana => "Europe/Ljubljana",
            Tz::Europe__London => "Europe/London",
            Tz::Europe__Luxembourg => "Europe/Luxembourg",
            Tz::Europe__Madrid => "Europe/Madrid",
            Tz::Europe__Malta => "Europe/Malta",
            Tz::Europe__Mariehamn => "Europe/Mariehamn",
            Tz::Europe__Minsk => "Europe/Minsk",
            Tz::Europe__Monaco => "Europe/Monaco",
            Tz::Europe__Moscow => "Europe/Moscow",
            Tz::Europe__Nicosia => "Europe/Nicosia",
            Tz::Europe__Oslo => "Europe/Oslo",
            Tz::Europe__Paris => "Europe/Paris",
            Tz::Europe__Podgorica => "Europe/Podgorica",
            Tz::Europe__Prague => "Europe/Prague",
            Tz::Europe__Riga => "Europe/Riga",
            Tz::Europe__Rome => "Europe/Rome",
            Tz::Europe__Samara => "Europe/Samara",
            Tz::Europe__San_Marino => "Europe/San_Marino",
            Tz::Europe__Sarajevo => "Europe/Sarajevo",
            Tz::Europe__Saratov => "Europe/Saratov",
            Tz::Europe__Simferopol => "Europe/Simferopol",
            Tz::Europe__Skopje => "Europe/Skopje",
            Tz::Europe__Sofia => "Europe/Sofia",
            Tz::Europe__Stockholm => "Europe/Stockholm",
            Tz::Europe__Tallinn => "Europe/Tallinn",
            Tz::Europe__Tirane => "Europe/Tirane",
            Tz::Europe__Tiraspol => "Europe/Tiraspol",
            Tz::Europe__Ulyanovsk => "Europe/Ulyanovsk",
            Tz::Europe__Uzhgorod => "Europe/Uzhgorod",
            Tz::Europe__Vaduz => "Europe/Vaduz",
            Tz::Europe__Vatican => "Europe/Vatican",
            Tz::Europe__Vienna => "Europe/Vienna",
            Tz::Europe__Vilnius => "Europe/Vilnius",
            Tz::Europe__Volgograd => "Europe/Volgograd",
            Tz::Europe__Warsaw => "Europe/Warsaw",
            Tz::Europe__Zagreb => "Europe/Zagreb",
            Tz::Europe__Zaporozhye => "Europe/Zaporozhye",
            Tz::Europe__Zurich => "Europe/Zurich",
            Tz::GB => "GB",
            Tz::GBEire => "GB-Eire",
            Tz::GMT => "GMT",
            Tz::GMTPlus0 => "GMT+0",
            Tz::GMTMinus0 => "GMT-0",
            Tz::GMT0 => "GMT0",
            Tz::Greenwich => "Greenwich",
            Tz::HST => "HST",
            Tz::Hongkong => "Hongkong",
            Tz::Iceland => "Iceland",
            Tz::Indian__Antananarivo => "Indian/Antananarivo",
            Tz::Indian__Chagos => "Indian/Chagos",
            Tz::Indian__Christmas => "Indian/Christmas",
            Tz::Indian__Cocos => "Indian/Cocos",
            Tz::Indian__Comoro => "Indian/Comoro",
            Tz::Indian__Kerguelen => "Indian/Kerguelen",
            Tz::Indian__Mahe => "Indian/Mahe",
            Tz::Indian__Maldives => "Indian/Maldives",
            Tz::Indian__Mauritius => "Indian/Mauritius",
            Tz::Indian__Mayotte => "Indian/Mayotte",
            Tz::Indian__Reunion => "Indian/Reunion",
            Tz::Iran => "Iran",
            Tz::Israel => "Israel",
            Tz::Jamaica => "Jamaica",
            Tz::Japan => "Japan",
            Tz::Kwajalein => "Kwajalein",
            Tz::Libya => "Libya",
            Tz::MET => "MET",
            Tz::MST => "MST",
            Tz::MST7MDT => "MST7MDT",
            Tz::Mexico__BajaNorte => "Mexico/BajaNorte",
            Tz::Mexico__BajaSur => "Mexico/BajaSur",
            Tz::Mexico__General => "Mexico/General",
            Tz::NZ => "NZ",
            Tz::NZCHAT => "NZ-CHAT",
            Tz::Navajo => "Navajo",
            Tz::PRC => "PRC",
            Tz::PST8PDT => "PST8PDT",
            Tz::Pacific__Apia => "Pacific/Apia",
            Tz::Pacific__Auckland => "Pacific/Auckland",
            Tz::Pacific__Bougainville => "Pacific/Bougainville",
            Tz::Pacific__Chatham => "Pacific/Chatham",
            Tz::Pacific__Chuuk => "Pacific/Chuuk",
            Tz::Pacific__Easter => "Pacific/Easter",
            Tz::Pacific__Efate => "Pacific/Efate",
            Tz::Pacific__Enderbury => "Pacific/Enderbury",
            Tz::Pacific__Fakaofo => "Pacific/Fakaofo",
            Tz::Pacific__Fiji => "Pacific/Fiji",
            Tz::Pacific__Funafuti => "Pacific/Funafuti",
            Tz::Pacific__Galapagos => "Pacific/Galapagos",
            Tz::Pacific__Gambier => "Pacific/Gambier",
            Tz::Pacific__Guadalcanal => "Pacific/Guadalcanal",
            Tz::Pacific__Guam => "Pacific/Guam",
            Tz::Pacific__Honolulu => "Pacific/Honolulu",
            Tz::Pacific__Johnston => "Pacific/Johnston",
            Tz::Pacific__Kanton => "Pacific/Kanton",
            Tz::Pacific__Kiritimati => "Pacific/Kiritimati",
            Tz::Pacific__Kosrae => "Pacific/Kosrae",
            Tz::Pacific__Kwajalein => "Pacific/Kwajalein",
            Tz::Pacific__Majuro => "Pacific/Majuro",
            Tz::Pacific__Marquesas => "Pacific/Marquesas",
            Tz::Pacific__Midway => "Pacific/Midway",
            Tz::Pacific__Nauru => "Pacific/Nauru",
            Tz::Pacific__Niue => "Pacific/Niue",
            Tz::Pacific__Norfolk => "Pacific/Norfolk",
            Tz::Pacific__Noumea => "Pacific/Noumea",
            Tz::Pacific__Pago_Pago => "Pacific/Pago_Pago",
            Tz::Pacific__Palau => "Pacific/Palau",
            Tz::Pacific__Pitcairn => "Pacific/Pitcairn",
            Tz::Pacific__Pohnpei => "Pacific/Pohnpei",
            Tz::Pacific__Ponape => "Pacific/Ponape",
            Tz::Pacific__Port_Moresby => "Pacific/Port_Moresby",
            Tz::Pacific__Rarotonga => "Pacific/Rarotonga",
            Tz::Pacific__Saipan => "Pacific/Saipan",
            Tz::Pacific__Samoa => "Pacific/Samoa",
            Tz::Pacific__Tahiti => "Pacific/Tahiti",
            Tz::Pacific__Tarawa => "Pacific/Tarawa",
            Tz::Pacific__Tongatapu => "Pacific/Tongatapu",
            Tz::Pacific__Truk => "Pacific/Truk",
            Tz::Pacific__Wake => "Pacific/Wake",
            Tz::Pacific__Wallis => "Pacific/Wallis",
            Tz::Pacific__Yap => "Pacific/Yap",
            Tz::Poland => "Poland",
            Tz::Portugal => "Portugal",
            Tz::ROC => "ROC",
            Tz::ROK => "ROK",
            Tz::Singapore => "Singapore",
            Tz::Turkey => "Turkey",
            Tz::UCT => "UCT",
            Tz::US__Alaska => "US/Alaska",
            Tz::US__Aleutian => "US/Aleutian",
            Tz::US__Arizona => "US/Arizona",
            Tz::US__Central => "US/Central",
            Tz::US__EastIndiana => "US/East-Indiana",
            Tz::US__Eastern => "US/Eastern",
            Tz::US__Hawaii => "US/Hawaii",
            Tz::US__IndianaStarke => "US/Indiana-Starke",
            Tz::US__Michigan => "US/Michigan",
            Tz::US__Mountain => "US/Mountain",
            Tz::US__Pacific => "US/Pacific",
            Tz::US__Samoa => "US/Samoa",
            Tz::UTC => "UTC",
            Tz::Universal => "Universal",
            Tz::WSU => "W-SU",
            Tz::WET => "WET",
            Tz::Zulu => "Zulu",
        }
    }
}
impl Debug for Tz {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        f.write_str(self.name().as_ref())
    }
}

impl Display for Tz {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        f.write_str(self.name().as_ref())
    }
}

impl TimeSpans for Tz {
    fn timespans(&self) -> FixedTimespanSet {
        match *self {
            Tz::Africa__Abidjan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Accra => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Addis_Ababa => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Algiers => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2486592732, FixedTimespan { utc_offset: 561, dst_offset: 0, name: Some("PMT") }),
                    (-1855958961, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1689814800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1680397200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1665363600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1648342800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1635123600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1616893200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1604278800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1585443600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1574038800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1552266000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1539997200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1531443600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-956365200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-950486400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-942012000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-812502000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-796262400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-781052400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-766630800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-733280400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-439430400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-212029200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (41468400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (54774000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (231724800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (246236400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (259545600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (275274000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (309740400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (325468800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (341802000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (357523200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 732,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Asmara => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Asmera => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bamako => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bangui => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Banjul => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bissau => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830380400, FixedTimespan { utc_offset: -3600, dst_offset: 0, name: None }),
                    (157770000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -3740,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Blantyre => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Brazzaville => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bujumbura => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Cairo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2185409109, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-929844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-923108400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-906170400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-892868400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-875844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-857790000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-844308000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-825822000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-812685600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-794199600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-779853600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-762663600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-399088800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-386650800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-368330400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-355114800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-336790800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-323654400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-305168400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-292032000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-273632400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-260496000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-242096400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-228960000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-210560400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-197424000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-178938000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-165801600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-147402000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-134265600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-115866000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-102643200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-84330000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-71107200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-52707600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-39484800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (-21171600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (-7948800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (10364400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (23587200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (41900400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (55123200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (73522800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (86745600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (105058800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (118281600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (136594800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (149817600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (168130800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (181353600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (199753200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (212976000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (231289200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (244512000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (262825200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (276048000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (294361200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (307584000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (325983600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (339206400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (357519600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (370742400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (396399600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (402278400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (426812400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (433814400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (452214000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (465436800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (483750000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (496972800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (515286000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (528508800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (546822000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (560044800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (578444400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (591667200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (610412400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (623203200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (641516400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (654739200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (673052400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (686275200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (704674800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (717897600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (736210800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (749433600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (767746800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (780969600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (799020000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (812322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (830469600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (843771600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (861919200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (875221200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (893368800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (906670800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (925423200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (938725200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (956872800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (970174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (988322400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1001624400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1019772000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1033074000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1051221600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1064523600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1083276000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1096578000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1114725600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1128027600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1146175200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1158872400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1177624800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1189112400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1209074400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1219957200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1240524000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1250802000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1272578400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1281474000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1284069600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1285880400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1400191200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1403816400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1406844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1411678800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1682632800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1698354000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1714082400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1730408400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1745532000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1761858000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1776981600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1793307600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1809036000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1824757200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1840485600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1856206800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1871935200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1887656400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1903384800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1919710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1934834400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1951160400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1966888800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (1982610000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1998338400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2014059600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2029788000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2045509200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2061237600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2076958800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2092687200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2109013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2124136800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2140462800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2156191200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2171912400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2187640800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2203362000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2219090400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2234811600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2250540000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2266866000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2281989600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2298315600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2313439200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2329765200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2345493600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2361214800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2376943200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2392664400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2408392800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2424114000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2439842400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2456168400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2471292000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2487618000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2503346400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2519067600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2534796000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2550517200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2566245600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2581966800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2597695200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2614021200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2629144800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2645470800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2660594400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2676920400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2692648800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2708370000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2724098400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2739819600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2755548000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2771269200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2786997600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2803323600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2818447200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2834773200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2850501600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2866222800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2881951200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2897672400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2913400800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2929122000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2944850400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2960571600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (2976300000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (2992626000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3007749600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3024075600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3039804000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3055525200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3071253600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3086974800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3102703200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3118424400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3134152800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3150478800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3165602400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3181928400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3197052000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3213378000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3229106400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3244827600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3260556000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3276277200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3292005600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3307726800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3323455200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3339781200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3354904800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3371230800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3386959200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3402680400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3418408800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3434130000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3449858400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3465579600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3481308000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3497634000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3512757600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3529083600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3544207200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3560533200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3576261600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3591982800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3607711200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3623432400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3639160800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3654882000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3670610400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3686936400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3702060000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3718386000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3734114400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3749835600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3765564000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3781285200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3797013600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3812734800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3828463200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3844184400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3859912800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3876238800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3891362400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3907688400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3923416800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3939138000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3954866400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (3970587600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (3986316000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (4002037200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (4017765600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (4034091600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (4049215200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (4065541200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (4080664800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("EEST") }),
                    (4096990800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7509,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Casablanca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1773012580, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (-956361600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (-950490000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (-942019200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (-761187600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (-617241600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (-605149200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (-81432000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (-71110800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (141264000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (147222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (448243200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (504918000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1212278400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1220223600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1243814400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1250809200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1272758400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1281222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1301788800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1312066800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1335664800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1342749600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1345428000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1348970400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1367114400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1373162400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1376100000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1382839200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1396144800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1403920800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1406944800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1414288800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1427594400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1434247200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1437271200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1445738400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1459044000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1465092000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1468116000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1477792800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1490493600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1495332000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1498960800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1509242400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1521943200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1526176800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1529200800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1540692000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1557021600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1560045600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1587261600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1590890400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1618106400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1621130400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1648346400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1651975200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1679191200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1682215200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1710036000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1713060000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1740276000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1743904800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1771120800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1774144800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1801965600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1804989600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1832205600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1835834400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1863050400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1866074400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1893290400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1896919200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1924135200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1927159200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1954980000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1958004000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1985220000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1988848800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2016064800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2019088800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2046304800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2049933600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2077149600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2080778400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2107994400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2111018400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2138234400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2141863200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2169079200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2172103200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2199924000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2202948000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2230164000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2233792800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2261008800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2264032800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2291248800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2294877600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2322093600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2325722400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2352938400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2355962400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2383178400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2386807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2414023200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2417047200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2444868000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2447892000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2475108000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2478736800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2505952800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2508976800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2536192800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2539821600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2567037600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2570666400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2597882400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2600906400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2628122400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2631751200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2658967200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2661991200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2689812000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2692836000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2720052000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2723680800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2750896800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2753920800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2781136800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2784765600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2811981600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2815610400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2842826400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2845850400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2873066400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2876695200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2903911200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2906935200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2934756000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2937780000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2964996000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2968624800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2995840800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2998864800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3026080800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3029709600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3056925600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3060554400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3087770400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3090794400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3118010400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3121639200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3148855200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3151879200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3179700000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3182724000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3209940000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3213568800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3240784800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3243808800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3271024800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3274653600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3301869600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3305498400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3332714400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3335738400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3362954400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3366583200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3393799200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3396823200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3424644000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3427668000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3454884000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3458512800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3485728800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3488752800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3515968800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3519597600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3546813600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3549837600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3577658400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3580682400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3607898400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3611527200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3638743200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3641767200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3669588000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3672612000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3699828000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3703456800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -1820,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ceuta => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2177452800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1630112400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1616810400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1442451600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1427673600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1379293200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1364774400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1348448400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1333324800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-1316390400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-1301270400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (-81432000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (-71110800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (141264000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (147222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: Some("WEST") }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("WET") }),
                    (448243200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (512528400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (528253200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (543978000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (559702800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (575427600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (591152400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (606877200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (622602000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (638326800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (654656400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (670381200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (686106000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (701830800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (717555600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (733280400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (749005200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (764730000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (780454800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (796179600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (811904400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (828234000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (846378000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (859683600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (877827600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (891133200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (909277200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (922582800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (941331600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (954032400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (972781200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (985482000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1004230800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1017536400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1035680400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1048986000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1067130000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1080435600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1099184400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1111885200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1130634000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1143334800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1162083600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1174784400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1193533200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1206838800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1224982800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1238288400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1256432400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1269738000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1288486800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1301187600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1319936400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1332637200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1351386000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1364691600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1382835600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1396141200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1414285200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1427590800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1445734800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1459040400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1477789200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1490490000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1509238800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1521939600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1540688400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1553994000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1572138000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1585443600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1603587600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1616893200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1635642000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1648342800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1667091600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1679792400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1698541200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1711846800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1729990800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1743296400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1761440400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1774746000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1792890000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1806195600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1824944400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1837645200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1856394000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1869094800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1887843600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1901149200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1919293200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1932598800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1950742800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1964048400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1982797200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1995498000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2014246800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2026947600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2045696400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2058397200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2077146000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2090451600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2108595600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2121901200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2140045200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2153350800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2172099600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2184800400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2203549200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2216250000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2234998800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2248304400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2266448400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2279754000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2297898000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2311203600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2329347600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2342653200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2361402000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2374102800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2392851600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2405552400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2424301200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2437606800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2455750800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2469056400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2487200400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2500506000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2519254800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2531955600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2550704400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2563405200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2582154000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2595459600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2613603600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2626909200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2645053200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2658358800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2676502800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2689808400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2708557200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2721258000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2740006800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2752707600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2771456400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2784762000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2802906000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2816211600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2834355600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2847661200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2866410000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2879110800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2897859600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2910560400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2929309200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2942010000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2960758800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (2974064400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (2992208400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3005514000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3023658000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3036963600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3055712400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3068413200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3087162000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3099862800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3118611600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3131917200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3150061200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3163366800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3181510800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3194816400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3212960400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3226266000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3245014800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3257715600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3276464400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3289165200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3307914000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3321219600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3339363600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3352669200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3370813200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3384118800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3402867600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3415568400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3434317200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3447018000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3465766800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3479072400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3497216400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3510522000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3528666000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3541971600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3560115600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3573421200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3592170000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3604870800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3623619600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3636320400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3655069200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3668374800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3686518800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3699824400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3717968400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3731274000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3750022800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3762723600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3781472400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3794173200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3812922000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3825622800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3844371600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3857677200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3875821200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3889126800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3907270800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3920576400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3939325200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3952026000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (3970774800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (3983475600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (4002224400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (4015530000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (4033674000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (4046979600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (4065123600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (4078429200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (4096573200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -1276,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Conakry => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Dakar => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Dar_es_Salaam => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Djibouti => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Douala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__El_Aaiun => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1136070432, FixedTimespan { utc_offset: -3600, dst_offset: 0, name: None }),
                    (198291600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1212278400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1220223600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1243814400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1250809200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1272758400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1281222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1301788800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1312066800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1335664800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1342749600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1345428000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1348970400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1367114400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1373162400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1376100000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1382839200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1396144800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1403920800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1406944800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1414288800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1427594400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1434247200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1437271200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1445738400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1459044000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1465092000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1468116000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1477792800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1490493600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1495332000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1498960800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1509242400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1521943200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1526176800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: None }),
                    (1529200800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: None }),
                    (1540692000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1557021600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1560045600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1587261600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1590890400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1618106400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1621130400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1648346400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1651975200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1679191200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1682215200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1710036000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1713060000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1740276000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1743904800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1771120800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1774144800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1801965600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1804989600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1832205600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1835834400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1863050400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1866074400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1893290400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1896919200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1924135200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1927159200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1954980000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1958004000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (1985220000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (1988848800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2016064800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2019088800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2046304800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2049933600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2077149600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2080778400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2107994400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2111018400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2138234400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2141863200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2169079200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2172103200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2199924000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2202948000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2230164000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2233792800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2261008800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2264032800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2291248800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2294877600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2322093600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2325722400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2352938400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2355962400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2383178400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2386807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2414023200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2417047200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2444868000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2447892000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2475108000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2478736800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2505952800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2508976800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2536192800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2539821600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2567037600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2570666400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2597882400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2600906400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2628122400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2631751200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2658967200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2661991200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2689812000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2692836000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2720052000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2723680800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2750896800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2753920800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2781136800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2784765600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2811981600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2815610400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2842826400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2845850400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2873066400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2876695200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2903911200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2906935200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2934756000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2937780000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2964996000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2968624800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (2995840800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (2998864800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3026080800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3029709600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3056925600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3060554400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3087770400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3090794400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3118010400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3121639200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3148855200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3151879200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3179700000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3182724000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3209940000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3213568800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3240784800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3243808800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3271024800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3274653600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3301869600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3305498400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3332714400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3335738400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3362954400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3366583200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3393799200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3396823200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3424644000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3427668000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3454884000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3458512800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3485728800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3488752800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3515968800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3519597600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3546813600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3549837600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3577658400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3580682400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3607898400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3611527200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3638743200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3641767200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3669588000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3672612000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                    (3699828000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: None }),
                    (3703456800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -3168,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Freetown => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Gaborone => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Harare => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Johannesburg => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: Some("SAST") }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Juba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1230775588, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (10360800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (24786000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (41810400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (56322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (73432800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (87944400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (104882400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (119480400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (136332000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (151016400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (167781600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (182552400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (199231200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (214174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (230680800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (245710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (262735200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (277246800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (294184800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (308782800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (325634400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (340405200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (357084000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (371941200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (388533600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (403477200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (419983200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (435013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (452037600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (466635600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (483487200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (498171600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (947930400, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (1612126800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7588,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kampala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Khartoum => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1230775808, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (10360800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (24786000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (41810400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (56322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (73432800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (87944400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (104882400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (119480400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (136332000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (151016400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (167781600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (182552400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (199231200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (214174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (230680800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (245710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (262735200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (277246800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (294184800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (308782800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (325634400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (340405200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (357084000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (371941200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (388533600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (403477200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (419983200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (435013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (452037600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (466635600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (483487200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("CAST") }),
                    (498171600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (947930400, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (1509483600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7808,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kigali => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kinshasa => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lagos => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Libreville => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lome => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Luanda => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lubumbashi => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lusaka => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Malabo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Maputo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1924999818, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7818,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Maseru => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: Some("SAST") }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Mbabane => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: Some("SAST") }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Mogadishu => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Monrovia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2776979812, FixedTimespan { utc_offset: -2588, dst_offset: 0, name: Some("MMT") }),
                    (-1604359012, FixedTimespan { utc_offset: -2670, dst_offset: 0, name: Some("MMT") }),
                    (63593070, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -2588,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Nairobi => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: None }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: None }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: Some("EAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ndjamena => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830387612, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                    (308703600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("WAST") }),
                    (321314400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 3612,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Niamey => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Nouakchott => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ouagadougou => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__PortoNovo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: Some("LMT") }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: None }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Sao_Tome => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713912016, FixedTimespan { utc_offset: -2205, dst_offset: 0, name: Some("LMT") }),
                    (-1830384000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                    (1514768400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("WAT") }),
                    (1546304400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 1616,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Timbuktu => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Tripoli => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1577926364, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-574902000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-568087200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-512175600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-504928800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-449888400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-441856800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-347158800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (378684000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (386463600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (402271200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (417999600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (433807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (449622000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (465429600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (481590000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (496965600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (512953200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (528674400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (544230000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (560037600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (575852400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (591660000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (607388400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (623196000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (641775600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (844034400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (860108400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (875916000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                    (1352505600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1364515200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1382659200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("EET") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 3164,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Tunis => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2797202444, FixedTimespan { utc_offset: 561, dst_offset: 0, name: Some("PMT") }),
                    (-1855958961, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-969242400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-950493600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-941940000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-891136800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-877827600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-857257200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-844556400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-842918400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-842223600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-828230400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-812502000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-796269600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (-781052400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (-766634400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (231202800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (243903600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (262825200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (276044400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (581122800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (591145200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (606870000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (622594800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (641516400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (654649200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1114902000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1128038400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1143334800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1162083600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1174784400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1193533200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                    (1206838800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: Some("CEST") }),
                    (1224982800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: Some("CET") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 2444,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::Africa__Windhoek => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458170504, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: None }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: Some("SAST") }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("SAST") }),
                    (637970400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (764200800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (778640400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (796780800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (810090000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (828835200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (841539600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (860284800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (873594000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (891734400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (905043600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (923184000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (936493200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (954633600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (967942800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (986083200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (999392400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1018137600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1030842000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1049587200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1062896400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1081036800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1094346000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1112486400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1125795600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1143936000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1157245200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1175385600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1188694800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1207440000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1220749200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1238889600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1252198800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1270339200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1283648400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1301788800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1315098000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1333238400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1346547600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1365292800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1377997200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1396742400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1410051600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1428192000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1441501200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1459641600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1472950800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                    (1491091200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: Some("WAT") }),
                    (1504400400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: Some("CAT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 4104,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Adak => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -42398, dst_offset: 0, name: Some("LMT") }),
                    (-2188944802, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("NST") }),
                    (-880196400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("NWT") }),
                    (-769395600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("NPT") }),
                    (-765374400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("NST") }),
                    (-86878800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (-21466800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (-5745600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (9982800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (25704000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (41432400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (57758400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (73486800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (89208000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (104936400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (120657600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (126709200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (152107200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (162392400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (183556800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (199285200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (215611200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (230734800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (247060800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (262789200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (278510400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (294238800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (309960000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (325688400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (341409600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (357138000, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (372859200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (388587600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (404913600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (420037200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (436363200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (439034400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (452088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (467809200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (483537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (499258800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (514987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (530708400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (544622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (562158000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (576072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (594212400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (607521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (625662000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (638971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (657111600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (671025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (688561200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (702475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (720010800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (733924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (752065200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (765374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (783514800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (796824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (814964400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (828878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (846414000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (860328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (877863600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (891777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (909313200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (923227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (941367600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (954676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (972817200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (986126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1004266800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1018180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1035716400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1049630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1067166000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1081080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1099220400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1112529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1130670000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1143979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1162119600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1173614400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1194174000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1205064000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1225623600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1236513600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1257073200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1268568000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1289127600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1300017600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1320577200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1331467200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1352026800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1362916800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1383476400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1394366400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1414926000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1425816000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1446375600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1457870400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1478430000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1489320000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1509879600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1520769600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1541329200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1552219200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1572778800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1583668800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1604228400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1615723200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1636282800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1647172800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1667732400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1678622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1699182000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1710072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1730631600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1741521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1762081200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1772971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1793530800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1805025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1825585200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1836475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1857034800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1867924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1888484400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1899374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1919934000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1930824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1951383600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1962878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1983438000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1994328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2014887600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2025777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2046337200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2057227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2077786800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2088676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2109236400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2120126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2140686000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2152180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2172740400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2183630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2204190000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2215080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2235639600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2246529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2267089200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2277979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2298538800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2309428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2329988400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2341483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2362042800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2372932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2393492400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2404382400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2424942000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2435832000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2456391600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2467281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2487841200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2499336000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2519895600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2530785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2551345200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2562235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2582794800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2593684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2614244400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2625134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2645694000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2656584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2677143600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2688638400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2709198000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2720088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2740647600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2751537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2772097200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2782987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2803546800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2814436800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2834996400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2846491200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2867050800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2877940800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2898500400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2909390400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2929950000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2940840000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2961399600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2972289600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2992849200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3003739200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3024298800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3035793600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3056353200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3067243200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3087802800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3098692800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3119252400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3130142400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3150702000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3161592000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3182151600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3193041600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3213601200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3225096000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3245655600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3256545600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3277105200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3287995200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3308554800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3319444800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3340004400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3350894400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3371454000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3382948800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3403508400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3414398400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3434958000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3445848000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3466407600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3477297600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3497857200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3508747200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3529306800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3540196800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3560756400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3572251200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3592810800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3603700800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3624260400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3635150400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3655710000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3666600000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3687159600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3698049600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3718609200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3730104000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3750663600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3761553600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3782113200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3793003200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3813562800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3824452800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3845012400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3855902400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3876462000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3887352000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3907911600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3919406400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3939966000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3950856000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3971415600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3982305600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4002865200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4013755200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4034314800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4045204800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4065764400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4076654400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4097214000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 44002,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Anchorage => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -35976, dst_offset: 0, name: Some("LMT") }),
                    (-2188951224, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AST") }),
                    (-880200000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("APT") }),
                    (-765378000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AST") }),
                    (-86882400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (-21470400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (-5749200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (9979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (25700400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (41428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (57754800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (73483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (89204400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (104932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (120654000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (126705600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (152103600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (162388800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (183553200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (199281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (215607600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (230731200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (247057200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (262785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (278506800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (294235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (309956400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (325684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (341406000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (357134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (372855600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (388584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (404910000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (420033600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("AHDT") }),
                    (436359600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (439030800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (452084400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (467805600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (483534000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (499255200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (514983600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (530704800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (544618800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (562154400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (576068400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (594208800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (607518000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (625658400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (638967600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (657108000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (671022000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (688557600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (702471600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (720007200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (733921200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (752061600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (765370800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (783511200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (796820400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (814960800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (828874800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (846410400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (860324400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (877860000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (891774000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (909309600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (923223600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (941364000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (954673200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (972813600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (986122800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1004263200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1018177200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1035712800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1049626800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1067162400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1081076400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1099216800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1112526000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1130666400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1143975600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1162116000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1173610800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1194170400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1205060400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1225620000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1236510000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1257069600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1268564400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1289124000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1300014000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1320573600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1331463600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1352023200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1362913200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1383472800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1394362800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1414922400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1425812400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1446372000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1457866800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1478426400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1489316400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1509876000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1520766000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1541325600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1552215600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1572775200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1583665200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1604224800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1615719600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1636279200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1647169200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1667728800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1678618800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1699178400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1710068400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1730628000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1741518000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1762077600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1772967600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1793527200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1805022000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1825581600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1836471600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1857031200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1867921200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1888480800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1899370800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1919930400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1930820400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1951380000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1962874800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (1983434400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (1994324400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2014884000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2025774000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2046333600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2057223600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2077783200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2088673200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2109232800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2120122800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2140682400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2152177200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2172736800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2183626800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2204186400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2215076400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2235636000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2246526000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2267085600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2277975600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2298535200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2309425200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2329984800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2341479600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2362039200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2372929200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2393488800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2404378800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2424938400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2435828400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2456388000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2467278000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2487837600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2499332400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2519892000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2530782000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2551341600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2562231600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2582791200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2593681200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2614240800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2625130800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2645690400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2656580400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2677140000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2688634800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2709194400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2720084400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2740644000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2751534000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2772093600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2782983600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2803543200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2814433200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2834992800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2846487600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2867047200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2877937200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2898496800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2909386800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2929946400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2940836400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2961396000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (2972286000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (2992845600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3003735600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3024295200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3035790000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3056349600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3067239600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3087799200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3098689200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3119248800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3130138800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3150698400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3161588400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3182148000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3193038000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3213597600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3225092400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3245652000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3256542000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3277101600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3287991600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3308551200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3319441200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3340000800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3350890800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3371450400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3382945200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3403504800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3414394800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3434954400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3445844400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3466404000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3477294000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3497853600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3508743600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3529303200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3540193200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3560752800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3572247600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3592807200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3603697200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3624256800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3635146800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3655706400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3666596400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3687156000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3698046000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3718605600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3730100400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3750660000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3761550000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3782109600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3792999600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3813559200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3824449200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3845008800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3855898800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3876458400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3887348400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3907908000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3919402800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3939962400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3950852400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (3971412000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (3982302000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (4002861600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (4013751600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (4034311200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (4045201200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (4065760800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                    (4076650800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("AKDT") }),
                    (4097210400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("AKST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 50424,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Anguilla => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Antigua => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Araguaina => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767214032, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (813726000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (824004000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (844570800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (856058400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (876106800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (888717600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (908074800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (919562400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (982461600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1036292400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1045360800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1350788400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1361066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -11568,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Buenos_Aires => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372097972, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14028,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Catamarca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__ComodRivadavia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Cordoba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096592, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15408,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Jujuy => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096328, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (657086400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (669178800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (686721600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15672,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__La_Rioja => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095956, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667792800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (673588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16044,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Mendoza => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095484, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (655963200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (667796400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687499200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (699418800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (719380800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1085281200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1096171200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16516,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Rio_Gallegos => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095388, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16612,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Salta => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096300, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15700,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__San_Juan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095556, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667792800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (673588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1085972400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1090728000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16444,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__San_Luis => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096076, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (637380000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (655963200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (667796400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (675748800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1085972400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1090728000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1200880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1205031600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1223784000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1236481200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1255233600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15924,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Tucuman => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096348, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087099200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15652,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Ushuaia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095608, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1085886000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16392,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Aruba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Asuncion => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524507760, FixedTimespan { utc_offset: -13840, dst_offset: 0, name: Some("AMT") }),
                    (-1206389360, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (86760000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (134017200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (181368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (194497200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (212990400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (226033200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (244526400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (257569200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (276062400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (291783600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (307598400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (323406000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (339220800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (354942000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (370756800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (386478000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (402292800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (418014000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (433828800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (449636400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (465451200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (481172400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (496987200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (512708400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (528523200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (544244400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (560059200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (575866800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (591681600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (607402800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (625032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (638938800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (654753600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (670474800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (686721600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (699418800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (718257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (733546800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (749448000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (762318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (780984000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (793767600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (812520000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (825649200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (856666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (876024000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (907473600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (920775600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (970372800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (983674800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1002427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1018148400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1030852800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1049598000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1062907200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1081047600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1097985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1110682800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1142132400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1160884800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1173582000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1192939200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1205031600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1236481200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1270954800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1286078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1302404400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1317528000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1333854000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1349582400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1364094000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1381032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1395543600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1412481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1426993200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1443931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1459047600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1475380800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1490497200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1506830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1521946800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1538884800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1553396400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1570334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1584846000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1601784000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1616900400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1633233600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1648350000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1664683200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1679799600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1696132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1711249200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1728187200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1728961200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13840,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Atikokan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: Some("CMT") }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Atka => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -42398, dst_offset: 0, name: Some("LMT") }),
                    (-2188944802, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("NST") }),
                    (-880196400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("NWT") }),
                    (-769395600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("NPT") }),
                    (-765374400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("NST") }),
                    (-86878800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (-21466800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (-5745600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (9982800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (25704000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (41432400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (57758400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (73486800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (89208000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (104936400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (120657600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (126709200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (152107200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (162392400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (183556800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (199285200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (215611200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (230734800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (247060800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (262789200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (278510400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (294238800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (309960000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (325688400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (341409600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (357138000, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (372859200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (388587600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (404913600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: Some("BST") }),
                    (420037200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: Some("BDT") }),
                    (436363200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("AHST") }),
                    (439034400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (452088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (467809200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (483537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (499258800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (514987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (530708400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (544622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (562158000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (576072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (594212400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (607521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (625662000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (638971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (657111600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (671025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (688561200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (702475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (720010800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (733924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (752065200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (765374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (783514800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (796824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (814964400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (828878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (846414000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (860328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (877863600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (891777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (909313200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (923227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (941367600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (954676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (972817200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (986126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1004266800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1018180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1035716400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1049630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1067166000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1081080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1099220400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1112529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1130670000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1143979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1162119600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1173614400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1194174000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1205064000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1225623600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1236513600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1257073200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1268568000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1289127600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1300017600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1320577200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1331467200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1352026800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1362916800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1383476400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1394366400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1414926000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1425816000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1446375600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1457870400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1478430000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1489320000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1509879600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1520769600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1541329200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1552219200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1572778800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1583668800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1604228400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1615723200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1636282800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1647172800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1667732400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1678622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1699182000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1710072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1730631600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1741521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1762081200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1772971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1793530800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1805025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1825585200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1836475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1857034800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1867924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1888484400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1899374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1919934000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1930824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1951383600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1962878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (1983438000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (1994328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2014887600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2025777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2046337200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2057227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2077786800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2088676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2109236400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2120126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2140686000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2152180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2172740400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2183630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2204190000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2215080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2235639600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2246529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2267089200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2277979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2298538800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2309428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2329988400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2341483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2362042800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2372932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2393492400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2404382400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2424942000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2435832000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2456391600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2467281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2487841200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2499336000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2519895600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2530785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2551345200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2562235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2582794800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2593684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2614244400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2625134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2645694000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2656584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2677143600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2688638400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2709198000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2720088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2740647600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2751537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2772097200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2782987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2803546800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2814436800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2834996400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2846491200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2867050800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2877940800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2898500400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2909390400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2929950000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2940840000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2961399600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (2972289600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (2992849200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3003739200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3024298800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3035793600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3056353200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3067243200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3087802800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3098692800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3119252400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3130142400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3150702000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3161592000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3182151600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3193041600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3213601200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3225096000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3245655600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3256545600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3277105200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3287995200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3308554800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3319444800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3340004400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3350894400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3371454000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3382948800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3403508400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3414398400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3434958000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3445848000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3466407600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3477297600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3497857200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3508747200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3529306800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3540196800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3560756400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3572251200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3592810800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3603700800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3624260400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3635150400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3655710000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3666600000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3687159600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3698049600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3718609200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3730104000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3750663600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3761553600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3782113200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3793003200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3813562800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3824452800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3845012400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3855902400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3876462000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3887352000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3907911600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3919406400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3939966000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3950856000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (3971415600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (3982305600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4002865200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4013755200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4034314800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4045204800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4065764400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                    (4076654400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: Some("HDT") }),
                    (4097214000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: Some("HST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 44002,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Bahia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767216356, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (666756000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (697600800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719982000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (728445600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (750826800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (761709600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (782276400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (793159200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (813726000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (824004000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (844570800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (856058400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (876106800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (888717600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (908074800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (919562400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (982461600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1036292400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1045360800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1318734000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1330221600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -9244,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Bahia_Banderas => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514739600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1343149200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1220461200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-873828000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1270371600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1288508400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1301817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1319958000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1333267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1351407600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1365321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1382857200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1396771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1414306800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1428220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1445756400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1459670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1477810800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1491120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1509260400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1522569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1540710000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1554624000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1572159600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1586073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1603609200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1617523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1635663600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1648972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1667113200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25260,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Barbados => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1841256091, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-874263600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-862682400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-841604400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-830714400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-811882800, FixedTimespan { utc_offset: -14400, dst_offset: 1800, name: Some("-0330") }),
                    (-798660000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (234943200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (244616400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (261554400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (276066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (293004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (307515600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (325058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (338706000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14309,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Belem => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767213964, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -11636,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Belize => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1822500432, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1616954400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1606069800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1585504800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1574015400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1554055200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1542565800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1522605600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1511116200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1490551200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1479666600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1459101600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1448217000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1427652000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1416162600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1396202400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1384713000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1364752800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1353263400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1333303200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1321813800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1301248800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1290364200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1269799200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1258914600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1238349600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1226860200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1206900000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1195410600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1175450400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1163961000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1143396000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1132511400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1111946400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1101061800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1080496800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1069612200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1049047200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1037557800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1017597600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-1006108200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-986148000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-974658600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-954093600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-943209000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-922644000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-911759400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-891194400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-879705000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-868212000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CWT") }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CPT") }),
                    (-758746800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-701892000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-690402600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-670442400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-658953000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-638992800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-627503400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-606938400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-596053800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-575488800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-564604200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-544039200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-532549800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-512589600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-501100200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-481140000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-469650600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-449690400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-438201000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-417636000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-406751400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-386186400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-375301800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-354736800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-343247400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-323287200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-311797800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-291837600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-280348200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-259783200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-248898600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-228333600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-217449000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-196884000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-185999400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-165434400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-153945000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-133984800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-122495400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-102535200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-91045800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-70480800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: Some("-0530") }),
                    (-59596200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (123919200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (129618000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (409039200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (413874000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21168,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__BlancSablon => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Boa_Vista => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767211040, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (971578800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14560,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Bogota => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2707671824, FixedTimespan { utc_offset: -17776, dst_offset: 0, name: Some("BMT") }),
                    (-1739041424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (704869200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (729057600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -17776,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Boise => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717640000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1633269600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1601820000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-1583679600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1471788000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MPT") }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-52930800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-37209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-21481200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-5760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (9968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (25689600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (41418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (57744000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (129114000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (162378000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -27889,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Buenos_Aires => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372097972, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14028,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cambridge_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1577923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MPT") }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (136371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (167821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (972802800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (973400400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 0,
                        dst_offset: 0,
                        name: Some("-00"),
                    },
                    rest: REST
                }
            },

            Tz::America__Campo_Grande => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767212492, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (592977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (602046000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (624427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (634705200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (656481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (666759600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (697604400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (719985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (728449200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (750830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (761713200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (782280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (793162800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (813729600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (824007600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (856062000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (876110400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (908078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (919566000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (982465200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1003032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1013914800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1036296000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1045364400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1066536000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1076814000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1099368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1108868400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1140318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1162699200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1172372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1192334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1203217200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1234666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1266721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1287288000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1298170800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1318737600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1330225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1350792000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1361070000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1382241600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1392519600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1413691200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1424574000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1445140800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1456023600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1476590400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1487473200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1508040000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1518922800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1541304000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1550372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13108,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cancun => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514743200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (378201600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (410504400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (877849200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (902037600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (909298800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (923212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (941353200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (972802800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (989136000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1001833200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1018166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1035702000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1049616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1067151600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1081065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1099206000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1112515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1130655600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1143964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1162105200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1175414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1193554800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1207468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1225004400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1238918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1256454000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1270368000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1288508400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1301817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1319958000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1333267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1351407600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1365321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1382857200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1396771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1414306800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1422777600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20824,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Caracas => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524505536, FixedTimespan { utc_offset: -16060, dst_offset: 0, name: Some("CMT") }),
                    (-1826739140, FixedTimespan { utc_offset: -16200, dst_offset: 0, name: None }),
                    (-157750200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1197183600, FixedTimespan { utc_offset: -16200, dst_offset: 0, name: None }),
                    (1462086000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16064,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Catamarca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cayenne => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1846269040, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -12560,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cayman => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: Some("CMT") }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Chicago => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717647200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1633276800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1615136400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1601827200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1583686800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1563724800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1551632400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1538928000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1520182800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1504454400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1491757200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1473004800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1459702800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1441555200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1428253200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1410105600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1396803600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1378656000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1365354000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1347206400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1333904400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1315152000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1301850000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1283702400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1270400400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1252252800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1238950800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1220803200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1207501200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1189353600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1176051600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1157299200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1144602000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1125849600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1112547600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1094400000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1081098000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1067788800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-1045414800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1031500800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1018198800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1000051200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-986749200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-967996800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-955299600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-936547200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-923245200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-905097600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-891795600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-880214400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CWT") }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CPT") }),
                    (-765392400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-747244800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-733942800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-715795200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-702493200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-684345600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-671043600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-652896000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-639594000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-620841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-608144400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-589392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-576090000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-557942400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-544640400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-526492800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-513190800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-495043200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-481741200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-463593600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-447267600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-431539200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-415818000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-400089600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-384368400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-368640000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-352918800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-337190400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-321469200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-305740800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-289414800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-273686400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-257965200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-242236800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-226515600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-210787200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-195066000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-179337600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-163616400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-147888000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-131562000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-116438400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-100112400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-84384000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-68662800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-52934400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-37213200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-21484800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-5763600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (9964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (25686000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (41414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (57740400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (73468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (89190000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (104918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (120639600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (126691200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (152089200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (162374400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (183538800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (199267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (215593200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (230716800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (247042800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (262771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (278492400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (294220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (309942000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (325670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (341391600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (357120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (372841200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (388569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (404895600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (420019200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (436345200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (452073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (467794800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (483523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (499244400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (514972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (530694000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (544608000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (562143600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (576057600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (594198000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (607507200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (625647600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (638956800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (657097200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (671011200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (688546800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (702460800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (719996400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (733910400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (752050800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (765360000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (783500400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (796809600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (814950000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (891763200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (909298800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (923212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (941353200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (972802800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (986112000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1004252400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1018166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1035702000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1049616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1067151600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1081065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1099206000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1112515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1130655600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1143964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1162105200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1173600000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1194159600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1205049600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1225609200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1236499200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1257058800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1268553600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1289113200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1300003200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1320562800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1331452800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1352012400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1362902400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1383462000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1394352000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1414911600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1425801600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1446361200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1457856000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1478415600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1489305600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1509865200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1520755200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1541314800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1552204800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1572764400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1583654400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1604214000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1615708800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1636268400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1647158400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1667718000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1678608000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1699167600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1710057600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1730617200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1741507200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1762066800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1772956800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1793516400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1805011200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1825570800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1836460800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1857020400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1867910400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1888470000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1899360000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1919919600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1930809600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1951369200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1962864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1983423600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1994313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2014873200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2025763200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2046322800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2057212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2077772400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2088662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2109222000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2120112000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2140671600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2152166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2172726000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2183616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2204175600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2215065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2235625200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2246515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2267074800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2277964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2298524400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2309414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2329974000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2341468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2362028400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2372918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2393478000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2404368000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2424927600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2435817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2456377200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2467267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2487826800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2499321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2519881200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2530771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2551330800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2562220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2582780400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2593670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2614230000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2625120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2645679600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2656569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2677129200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2688624000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2709183600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2720073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2740633200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2751523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2772082800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2782972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2803532400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2814422400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2834982000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2846476800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2867036400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2877926400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2898486000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2909376000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2929935600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2940825600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2961385200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (2972275200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (2992834800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3003724800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3024284400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3035779200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3056338800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3067228800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3087788400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3098678400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3119238000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3130128000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3150687600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3161577600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3182137200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3193027200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3213586800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3225081600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3245641200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3256531200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3277090800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3287980800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3308540400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3319430400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3339990000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3350880000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3371439600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3382934400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3403494000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3414384000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3434943600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3445833600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3466393200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3477283200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3497842800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3508732800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3529292400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3540182400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3560742000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3572236800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3592796400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3603686400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3624246000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3635136000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3655695600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3666585600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3687145200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3698035200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3718594800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3730089600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3750649200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3761539200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3782098800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3792988800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3813548400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3824438400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3844998000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3855888000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3876447600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3887337600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3907897200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3919392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3939951600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3950841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (3971401200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (3982291200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (4002850800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (4013740800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (4034300400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (4045190400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (4065750000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (4076640000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (4097199600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21036,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Chihuahua => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514739600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1343149200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1220461200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1270371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1288512000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1301821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1319961600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1333270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1351411200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1365325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1382860800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1396774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414310400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1428224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1445760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1459674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1477814400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1491123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509264000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1522573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1540713600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1554627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1586077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1603612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1617526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1635667200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1648976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667116800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25460,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Ciudad_Juarez => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514739600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1343149200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1220461200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667116800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1669788000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25556,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Coral_Harbour => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: Some("CMT") }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cordoba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096592, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: Some("CMT") }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15408,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Costa_Rica => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524501427, FixedTimespan { utc_offset: -20173, dst_offset: 0, name: Some("SJMT") }),
                    (-1545071027, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (288770400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (297234000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (320220000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (328683600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (664264800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (678344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (695714400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (700635600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20173,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Coyhaique => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524504304, FixedTimespan { utc_offset: -16965, dst_offset: 0, name: Some("SMT") }),
                    (-1892661435, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1688410800, FixedTimespan { utc_offset: -16965, dst_offset: 0, name: Some("SMT") }),
                    (-1619205435, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1593806400, FixedTimespan { utc_offset: -16965, dst_offset: 0, name: Some("SMT") }),
                    (-1335986235, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1317585600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1304362800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1286049600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1272826800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1254513600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1241290800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1222977600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1209754800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1191355200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1178132400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-870552000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-865278000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-736632000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-718056000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-713649600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-36619200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-23922000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-3355200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (7527600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (24465600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (37767600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (55915200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (69217200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (87969600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (100666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (118209600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (132116400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (150868800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (163566000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (182318400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (195620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (213768000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (227070000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (245217600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (258519600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (277272000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (289969200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (308721600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (321418800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (340171200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (353473200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (371620800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (384922800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (403070400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (416372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (434520000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (447822000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (466574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (479271600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (498024000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (510721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (529473600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (545194800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (560923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (574225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (592372800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (605674800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (624427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (637124400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (653457600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (668574000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687326400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (700628400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (718776000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (732078000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (750225600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (763527600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (781675200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (794977200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (813729600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (826426800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (845179200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (859690800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (876628800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (889930800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (906868800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (923194800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (939528000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (952830000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (971582400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (984279600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1003032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1015729200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1034481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1047178800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1065931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1079233200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1097380800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1110682800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1128830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1142132400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1160884800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1173582000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1192334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1206846000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1223784000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1237086000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1255233600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1270350000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1286683200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1304823600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1313899200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1335668400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1346558400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1367118000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1378612800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1398567600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1410062400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1463281200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1471147200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1494730800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1502596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1526180400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1534046400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1554606000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1567915200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1586055600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1599364800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1617505200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1630814400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1648954800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1662868800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1680404400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1693713600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1712458800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1725768000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1742439600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -17296,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Creston => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717643600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1633273200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1601823600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1583683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-820519140, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-812653140, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-796845540, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -26898,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Cuiaba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767212140, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (592977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (602046000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (624427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (634705200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (656481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (666759600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (687931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (697604400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (719985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (728449200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (750830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (761713200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (782280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (793162800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (813729600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (824007600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (856062000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (876110400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (908078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (919566000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (982465200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1003032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1013914800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1036296000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1045364400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1099368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1108868400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1140318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1162699200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1172372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1192334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1203217200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1234666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1266721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1287288000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1298170800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1318737600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1330225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1350792000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1361070000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1382241600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1392519600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1413691200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1424574000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1445140800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1456023600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1476590400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1487473200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1508040000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1518922800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1541304000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: None }),
                    (1550372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13460,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Curacao => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Danmarkshavn => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1686091520, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (323845200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (338950800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (354675600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (370400400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (386125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (401850000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (417574800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (433299600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (449024400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (465354000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (481078800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (496803600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (512528400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (528253200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (543978000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (559702800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (575427600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (591152400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (606877200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (622602000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (638326800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (654656400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (670381200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (686106000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (701830800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (717555600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (733280400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (749005200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (764730000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (780454800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (796179600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (811904400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (820465200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: Some("GMT") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -4480,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Dawson => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2188996940, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (-1632056400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("YDT") }),
                    (-1615125600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (-1596978000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("YDT") }),
                    (-1583164800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (-880203600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("YWT") }),
                    (-769395600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: Some("YPT") }),
                    (-765381600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (-147884400, FixedTimespan { utc_offset: -32400, dst_offset: 7200, name: Some("YDDT") }),
                    (-131554800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: Some("YST") }),
                    (120646800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1173607200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1194166800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1205056800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1225616400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1236506400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1257066000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1425808800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1446368400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1457863200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1478422800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1489312800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1509872400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1520762400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1541322000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1552212000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1572771600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1583661600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1604214000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -33460,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Dawson_Creek => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713881544, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1632060000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-880207200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PWT") }),
                    (-769395600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PPT") }),
                    (-765385200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-715788000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-702486000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-684338400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-671036400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-652888800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-639586800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-620834400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-608137200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-589384800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-576082800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-557935200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-544633200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-526485600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-513183600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-495036000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-463586400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-431532000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-400082400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-368632800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-337183200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-305733600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-273679200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-260982000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-242229600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-226508400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-210780000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-195058800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-179330400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-163609200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-147880800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-131554800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-116431200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-100105200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-84376800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-68655600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-52927200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-37206000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-21477600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-5756400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (9972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (25693200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (41421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (57747600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (73476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (84013200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -28856,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Denver => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717643600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1633273200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1601823600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1583683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1570374000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1551628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1538924400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1534089600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MPT") }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-147884400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-131558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-116434800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-100108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-52930800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-37209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-21481200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-5760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (9968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (25689600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (41418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (57744000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (126694800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (162378000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25196,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Detroit => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2051202469, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1724083200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-880218000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EWT") }),
                    (-769395600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EPT") }),
                    (-765396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-684349200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (-671047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-80506740, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (-68666400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-52938000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (-37216800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (104914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (120636000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (126687600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (152085600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (167814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (183535200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (199263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (215589600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (230713200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (247039200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (262767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (278488800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (294217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (309938400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (325666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (341388000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (357116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (372837600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (388566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (404892000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (420015600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (436341600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (452070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (467791200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (483519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (499240800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (514969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (530690400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (544604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (562140000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (576054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (594194400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (607503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (625644000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (638953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (657093600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (671007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (688543200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (702457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (719992800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (733906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (752047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (765356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (783496800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (796806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (814946400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (828860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (846396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (860310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (877845600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (909295200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (923209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (941349600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (954658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (972799200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (986108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1004248800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1018162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1035698400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1049612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1067148000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1081062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1099202400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1112511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1130652000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1425798000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1446357600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1457852400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1478412000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1489302000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1509861600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19931,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Dominica => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Edmonton => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1998663968, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1632063600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1600614000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1596816000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1567954800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1551628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1536505200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1523203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1504450800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1491753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1473001200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-1459699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MWT") }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MPT") }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-715791600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (-702489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (136371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (167821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: Some("MDT") }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -27232,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Eirunepe => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767208832, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1206950400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1191355200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-1175367600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-1159819200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-633812400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-622062000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-602276400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-591825600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-570740400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-560203200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-539118000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-531345600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-191358000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-184190400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-155156400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-150062400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-128890800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-121118400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-99946800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-89582400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (-68410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (-57960000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (499755600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (511243200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (530600400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (540273600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (562136400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (571204800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (750834000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (761716800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (1214283600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (1384056000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16768,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__El_Salvador => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1546279392, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (547020000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (559717200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (578469600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (591166800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21408,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Ensenada => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514739600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1451667600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1343145600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                    (-1234803600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1222963200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-1207242000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-873820800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PWT") }),
                    (-769395600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PPT") }),
                    (-761418000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-686073600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-661539600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-620755200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-608144400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-589384800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-576082800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-557935200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-544633200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-495039600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-463590000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-431535600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-400086000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-368636400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-337186800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-305737200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (199274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (215600400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (230724000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (247050000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (262778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (278499600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (294228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (309949200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1175421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1193562000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1207476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1225011600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1238925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1256461200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1425808800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1446368400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1457863200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1478422800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1489312800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1509872400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1520762400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1541322000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1552212000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1572771600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1583661600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1604221200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1615716000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1636275600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1647165600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1667725200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1678615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1699174800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1710064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1730624400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1741514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1762074000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1772964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1793523600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1805018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1825578000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1836468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1857027600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1867917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1888477200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1899367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1919926800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1930816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1951376400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1962871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1983430800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1994320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2014880400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2025770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2046330000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2057220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2077779600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2088669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2109229200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2120119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2140678800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2152173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2172733200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2183623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2204182800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2215072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2235632400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2246522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2267082000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2277972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2298531600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2309421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2329981200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2341476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2362035600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2372925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2393485200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2404375200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2424934800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2435824800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2456384400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2467274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2487834000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2499328800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2519888400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2530778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2551338000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2562228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2582787600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2593677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2614237200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2625127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2645686800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2656576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2677136400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2688631200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2709190800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2720080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2740640400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2751530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2772090000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2782980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2803539600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2814429600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2834989200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2846484000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2867043600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2877933600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2898493200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2909383200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2929942800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2940832800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2961392400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (2972282400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (2992842000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3003732000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3024291600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3035786400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3056346000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3067236000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3087795600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3098685600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3119245200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3130135200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3150694800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3161584800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3182144400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3193034400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3213594000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3225088800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3245648400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3256538400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3277098000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3287988000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3308547600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3319437600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3339997200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3350887200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3371446800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3382941600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3403501200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3414391200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3434950800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3445840800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3466400400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3477290400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3497850000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3508740000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3529299600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3540189600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3560749200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3572244000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3592803600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3603693600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3624253200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3635143200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3655702800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3666592800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3687152400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3698042400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3718602000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3730096800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3750656400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3761546400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3782106000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3792996000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3813555600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3824445600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3845005200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3855895200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3876454800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3887344800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3907904400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3919399200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3939958800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3950848800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (3971408400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (3982298400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (4002858000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (4013748000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (4034307600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (4045197600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (4065757200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (4076647200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (4097206800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -28084,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Fort_Nelson => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713880953, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-1632060000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-880207200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PWT") }),
                    (-769395600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PPT") }),
                    (-765385200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-715788000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-702486000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-684338400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-671036400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-652888800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-639586800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-620834400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-608137200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-589384800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-576082800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-557935200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-544633200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-526485600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-513183600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-495036000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-463586400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-431532000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-400082400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-368632800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-337183200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-305733600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-273679200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-260982000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-242229600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-226508400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-210780000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-195058800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-179330400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-163609200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-147880800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-131554800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-116431200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-100105200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-84376800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-68655600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-52927200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-37206000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (-21477600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (-5756400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (9972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (25693200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (41421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (57747600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (73476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (89197200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (104925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (120646800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (136375200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (152096400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (167824800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (183546000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (199274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (215600400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (230724000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (247050000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (262778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (278499600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (294228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (309949200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1173607200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1194166800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1205056800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1225616400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1236506400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1257066000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: Some("PDT") }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: Some("PST") }),
                    (1425808800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: Some("MST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -29447,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Fort_Wayne => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717647200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1633276800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1615136400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-1601827200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-1583686800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-900259200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-891795600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-880214400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CWT") }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CPT") }),
                    (-765392400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-747244800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-733942800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-715795200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-702493200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-684345600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-671043600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-652896000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-639594000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-620841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-608144400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-589392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-576090000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-557942400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-544640400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-526492800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-513190800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-495043200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (-481741200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-463593600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-386787600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (-368640000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (-21488400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (-5767200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (9961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (25682400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1425798000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1446357600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1457852400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1478412000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1489302000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1509861600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20678,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Fortaleza => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767216360, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (972180000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -9240,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Glace_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2131646412, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1632074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1615143600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-880221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-526500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-513198000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (544600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (562136400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (576050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (594190800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (607500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (625640400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (638949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (657090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (671004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (688539600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (702453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (719989200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (733903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (752043600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (765352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (783493200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (796802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (814942800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (828856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (846392400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (860306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (877842000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (891756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (909291600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (923205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (941346000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (954655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (972795600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (986104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1004245200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1018159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1035694800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1049608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1067144400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1081058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1099198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1112508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1130648400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1143957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1162098000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1173592800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1194152400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1205042400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1225602000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1236492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1257051600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1268546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1289106000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1299996000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2499314400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2519874000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2530764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2551323600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2562213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2582773200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2593663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2614222800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2625112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2645672400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2656562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2677122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2688616800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2709176400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2720066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2740626000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2751516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2772075600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2782965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2803525200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2814415200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2834974800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2846469600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2867029200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2877919200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2898478800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2909368800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2929928400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2940818400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2961378000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2972268000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2992827600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3003717600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3024277200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3035772000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3056331600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3067221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3087781200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3098671200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3119230800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3130120800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3150680400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3161570400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3182130000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3193020000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3213579600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3225074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3245634000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3256524000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3277083600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3287973600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3308533200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3319423200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3339982800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3350872800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3371432400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3382927200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3403486800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3414376800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3434936400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3445826400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3466386000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3477276000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3497835600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3508725600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3529285200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3540175200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3560734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3572229600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3592789200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3603679200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3624238800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3635128800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3655688400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3666578400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3687138000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3698028000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3718587600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3730082400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3750642000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3761532000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3782091600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3792981600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3813541200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3824431200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3844990800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3855880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3876440400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3887330400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3907890000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3919384800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3939944400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3950834400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3971394000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3982284000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4002843600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4013733600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4034293200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4045183200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4065742800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4076632800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4097192400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14388,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Godthab => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1686083584, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (323845200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (338950800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (354675600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (370400400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (386125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (401850000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (417574800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (433299600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (449024400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (465354000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (481078800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (496803600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (512528400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (528253200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (543978000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (559702800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (575427600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (591152400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (606877200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (622602000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (638326800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (654656400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (670381200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (686106000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (701830800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (717555600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (733280400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (749005200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (764730000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (780454800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (796179600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (811904400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (828234000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (846378000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (859683600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (877827600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (891133200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (909277200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (922582800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (941331600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (954032400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (972781200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (985482000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1004230800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1017536400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1035680400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1048986000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1067130000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1080435600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1099184400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1111885200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1130634000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1143334800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1162083600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1174784400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1193533200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1206838800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1224982800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1238288400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1256432400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1269738000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1288486800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1301187600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1319936400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1332637200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1351386000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1364691600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1382835600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1396141200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1414285200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1427590800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1445734800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1459040400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1477789200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1490490000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1509238800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1521939600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1540688400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1553994000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1572138000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1585443600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1603587600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1616893200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1635642000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1648342800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: None }),
                    (1667091600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (1679792400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1711846800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1729990800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1743296400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1761440400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1774746000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1792890000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1806195600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1824944400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1837645200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1856394000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1869094800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1887843600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1901149200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1919293200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1932598800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1950742800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1964048400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (1982797200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (1995498000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2014246800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2026947600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2045696400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2058397200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2077146000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2090451600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2108595600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2121901200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2140045200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2153350800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2172099600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2184800400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2203549200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2216250000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2234998800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2248304400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2266448400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2279754000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2297898000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2311203600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2329347600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2342653200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2361402000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2374102800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2392851600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2405552400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2424301200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2437606800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2455750800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2469056400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2487200400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2500506000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2519254800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2531955600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2550704400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2563405200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2582154000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2595459600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2613603600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2626909200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2645053200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2658358800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2676502800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2689808400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2708557200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2721258000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2740006800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2752707600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2771456400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2784762000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2802906000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2816211600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2834355600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2847661200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2866410000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2879110800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2897859600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2910560400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2929309200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2942010000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2960758800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (2974064400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (2992208400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3005514000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3023658000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3036963600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3055712400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3068413200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3087162000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3099862800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3118611600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3131917200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3150061200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3163366800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3181510800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3194816400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3212960400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3226266000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3245014800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3257715600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3276464400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3289165200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3307914000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3321219600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3339363600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3352669200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3370813200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3384118800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3402867600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3415568400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3434317200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3447018000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3465766800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3479072400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3497216400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3510522000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3528666000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3541971600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3560115600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3573421200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3592170000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3604870800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3623619600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3636320400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3655069200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3668374800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3686518800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3699824400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3717968400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3731274000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3750022800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3762723600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3781472400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3794173200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3812922000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3825622800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3844371600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3857677200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3875821200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3889126800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3907270800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3920576400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3939325200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3952026000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (3970774800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (3983475600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (4002224400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (4015530000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (4033674000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (4046979600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (4065123600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                    (4078429200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: None }),
                    (4096573200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -12416,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Goose_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713895900, FixedTimespan { utc_offset: -12652, dst_offset: 0, name: Some("NST") }),
                    (-1632076148, FixedTimespan { utc_offset: -12652, dst_offset: 3600, name: Some("NDT") }),
                    (-1615145348, FixedTimespan { utc_offset: -12652, dst_offset: 0, name: Some("NST") }),
                    (-1096921748, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-1061670600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-1048973400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-1030221000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-1017523800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-998771400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-986074200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-966717000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-954624600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-935267400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-922570200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-903817800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-891120600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-872368200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NWT") }),
                    (-769395600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NPT") }),
                    (-765401400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-746044200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-733347000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-714594600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-701897400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-683145000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-670447800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-651695400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-638998200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-619641000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-606943800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-589401000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-576099000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-557951400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-544649400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-526501800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-513199800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-495052200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-481750200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-463602600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-450300600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-431548200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-418246200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-400098600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-386796600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-368649000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-355347000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-337199400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-323897400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-305749800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-289423800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-273695400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-257974200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-242245800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-226524600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-210796200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-195075000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-179346600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-163625400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-147897000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: Some("NDT") }),
                    (-131571000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: Some("NST") }),
                    (-119903400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-116445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-100119600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-84391200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-68670000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-52941600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-37220400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-21492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-5770800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (9957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (25678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (41407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (57733200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (544593660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (562129260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (576043260, FixedTimespan { utc_offset: -14400, dst_offset: 7200, name: Some("ADDT") }),
                    (594180060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (607492860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (625633260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (638942460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (657082860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (670996860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (688532460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (702446460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (719982060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (733896060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (752036460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (765345660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (783486060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (796795260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (814935660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (828849660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (846385260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (860299260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (877834860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (891748860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (909284460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (923198460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (941338860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (954648060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (972788460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (986097660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1004238060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1018152060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1035687660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1049601660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1067137260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1081051260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1099191660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1112500860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1130641260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1143950460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1162090860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1173585660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1194145260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1205035260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1225594860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1236484860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1257044460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1268539260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1289098860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1299988860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2499314400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2519874000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2530764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2551323600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2562213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2582773200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2593663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2614222800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2625112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2645672400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2656562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2677122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2688616800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2709176400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2720066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2740626000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2751516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2772075600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2782965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2803525200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2814415200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2834974800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2846469600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2867029200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2877919200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2898478800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2909368800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2929928400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2940818400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2961378000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2972268000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2992827600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3003717600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3024277200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3035772000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3056331600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3067221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3087781200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3098671200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3119230800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3130120800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3150680400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3161570400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3182130000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3193020000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3213579600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3225074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3245634000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3256524000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3277083600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3287973600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3308533200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3319423200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3339982800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3350872800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3371432400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3382927200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3403486800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3414376800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3434936400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3445826400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3466386000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3477276000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3497835600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3508725600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3529285200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3540175200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3560734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3572229600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3592789200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3603679200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3624238800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3635128800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3655688400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3666578400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3687138000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3698028000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3718587600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3730082400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3750642000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3761532000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3782091600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3792981600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3813541200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3824431200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3844990800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3855880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3876440400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3887330400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3907890000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3919384800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3939944400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3950834400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (3971394000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (3982284000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4002843600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4013733600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4034293200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4045183200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4065742800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (4076632800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (4097192400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14500,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Grand_Turk => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524504528, FixedTimespan { utc_offset: -18430, dst_offset: 0, name: Some("KMT") }),
                    (-1827687170, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (294217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (309938400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (325666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (341388000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (357116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (372837600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (388566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (404892000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (420015600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (436341600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (452070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (467791200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (483519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (499240800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (514969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (530690400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (544604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (562140000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (576054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (594194400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (607503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (625644000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (638953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (657093600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (671007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (688543200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (702457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (719992800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (733906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (752047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (765356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (783496800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (796806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (814946400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (828860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (846396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (860310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (877845600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (909295200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (923209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (941349600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (954658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (972799200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (986108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1004248800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1018162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1035698400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1049612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1067148000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1081062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1099202400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1112511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1130652000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1425798000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: Some("EDT") }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: Some("EST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -17072,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Grenada => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Guadeloupe => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Guatemala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1617040676, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (123055200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (130914000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (422344800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (433054800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (669708000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (684219600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                    (1146376800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: Some("CDT") }),
                    (1159678800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: Some("CST") }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21724,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Guayaquil => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502440, FixedTimespan { utc_offset: -18840, dst_offset: 0, name: Some("QMT") }),
                    (-1230749160, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                    (722926800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: None }),
                    (728884800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19160,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Guyana => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1843589241, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                    (-1730577600, FixedTimespan { utc_offset: -13500, dst_offset: 0, name: None }),
                    (176096700, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: None }),
                    (701841600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: None }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13959,
                        dst_offset: 0,
                        name: Some("LMT"),
                    },
                    rest: REST
                }
            },

            Tz::America__Halifax => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2131645536, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1696276800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1680469200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1632074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1615143600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1566763200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1557090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1535486400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1524949200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1504468800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1493413200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1472414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1461963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1440964800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1429390800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1409515200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1396731600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1376856000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1366491600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1346616000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1333832400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1313956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1303678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1282507200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1272661200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1251057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1240088400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1219608000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1207429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1188763200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1175979600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1157313600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1143925200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1124049600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1113771600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1091390400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1081026000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1059854400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1050786000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-1030910400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-1018126800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-999460800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-986677200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-965592000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-955227600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-935956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-923173200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-904507200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-891723600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-880221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("AWT") }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("APT") }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-747252000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-733950000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-715802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-702500400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-684352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-671050800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-652903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-639601200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-589399200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-576097200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-557949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-544647600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-526500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-513198000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-495050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-481748400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-431546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-418244400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-400096800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-386794800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-368647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-355345200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-337197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-323895600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-242244000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-226522800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-210794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-195073200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-179344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-163623600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-147895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-131569200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-116445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-100119600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-84391200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-68670000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-52941600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-37220400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (-21492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (-5770800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (9957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (25678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (41407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (57733200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (544600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (562136400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (576050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (594190800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (607500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (625640400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (638949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (657090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (671004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (688539600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (702453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (719989200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (733903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (752043600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (765352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (783493200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (796802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (814942800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (828856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (846392400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (860306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (877842000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (891756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (909291600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (923205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (941346000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (954655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (972795600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (986104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1004245200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1018159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1035694800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1049608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1067144400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1081058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1099198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1112508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1130648400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1143957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1162098000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1173592800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1194152400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1205042400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1225602000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1236492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1257051600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1268546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1289106000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1299996000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: Some("ADT") }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: Some("AST") }),
                    (2499314400, Fix