//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t fx2_paramFeatureBias[16] = {
    -146, 462, 150, 257, -10, -1195, 62, -1862, 56, -163, -83, 41, 162, 251, -225, 170, 
};

static const int16_t fx2_paramFeatureWeights[400] = {
    52, -53, 29, -57, -101, 80, 43, 12, 112, 196, 58, -27, 4, -27, 95, 85, 
    -329, 662, -409, -2090, 375, -209, 1050, 94, -439, -328, -247, 523, 24, 110, -187, -10, 
    592, 180, 455, 1225, -179, 359, 978, -11, 524, 343, -351, 391, -248, 1005, 79, -532, 
    678, -562, 205, 583, 65, 173, -127, -90, -630, 732, 467, 32, -92, 88, -75, 468, 
    -68, 215, 82, 75, -141, -138, 430, 109, -5, 91, 48, -243, 76, -65, -6, 43, 
    -10, -274, -107, 1194, -110, -268, -856, 148, 509, 1189, -940, -265, 185, 39, -323, 142, 
    562, -243, 1229, 377, 352, 125, 1060, 176, -1483, -589, 1013, -3223, 394, -1113, -1363, 493, 
    2905, -121, -2673, -2386, -1749, -946, -4801, 1146, -900, 1193, 2207, 3031, 4813, -3667, 1235, 404, 
    -2359, -1198, -276, -614, 362, -232, 1869, 33, 1807, -991, -1826, 142, -47, -809, -621, -1661, 
    126, -361, -37, 746, -320, -133, 92, 58, 292, 814, -19, 334, 42, 164, 54, -253, 
    -672, -1457, -923, -116, 257, 885, 1509, -249, -2172, 7, 374, 997, -543, 146, 161, -371, 
    1351, -739, 3126, -232, 3227, -2152, 2215, 1904, 3592, -4673, 2636, 4696, 2702, 57, -1028, 1079, 
    -6124, 3274, 2606, -78, 480, 9101, 77, 5292, 1087, 3398, -4238, -2216, -3645, 2581, 7044, -1326, 
    1595, 1000, -4888, 1752, -2491, -648, -670, 694, -1466, -167, 1073, -2534, -1342, -1836, -734, 3092, 
    -140, 2270, 1157, -713, 221, 90, -342, 189, -633, -1234, -685, 58, 48, -98, -184, -900, 
    381, 220, -122, -579, 43, -94, -1263, 117, 1185, 1590, 107, -554, 360, 8, -259, 126, 
    -577, 2013, -674, 1892, 610, -45, -2376, 307, -1628, 55, -1777, -2767, 155, 313, -1798, -1725, 
    3658, -4830, 1231, -734, 196, -2645, 97, 1547, -117, -2507, -355, -47, -2989, 2818, -588, 370, 
    -188, 464, -647, -173, -870, -661, 1389, 634, 410, 1902, 2170, 1815, 379, 1351, -1420, -590, 
    -336, -482, 129, -314, -108, 114, -556, -166, 632, -1007, 75, -805, 127, 190, 399, 41, 
    -76, -583, 159, -486, -50, -53, 277, 67, -195, -426, 277, 31, 2, 151, 4, 148, 
    -101, -120, 55, -692, -103, -29, -1145, -109, 878, 298, -274, 747, -246, -540, 133, 742, 
    -893, 463, 72, 989, 245, 451, 946, -18, -1058, -52, 917, 105, 43, -653, 324, 92, 
    10, -754, 101, -8, -184, -154, -708, -57, 188, 873, -324, -121, -255, -556, -4, -323, 
    55, -52, 0, 14, -11, -92, 414, 103, -567, -141, -218, 85, -46, 107, -64, 37, 
};

static const int16_t fx2_paramModel1Bias[16] = {
    1878, -1556, -1495, -527, -1036, -17, 796, -496, -1765, -8226, -390, -1230, 705, -8018, -249, 1237, 
};

static const int16_t fx2_paramModel1Weights[2304] = {
    -2013, -796, 1703, 1203, 582, -1899, -1216, -2372, -604, 2350, -1379, 337, -217, -1803, -283, 1079, 
    -1445, 143, -1292, 454, -2109, -352, -116, -125, 1925, 959, -1260, 1953, -1155, -1165, 573, 189, 
    5245, -4300, 1804, -1277, -260, -235, -1236, -1391, -1541, -192, 251, 130, 1933, 1592, -1520, 1942, 
    2154, -441, -480, 1537, -3191, 3678, 3062, -2181, 3420, 727, 90, -3563, -1615, 275, -4328, 3799, 
    949, -2528, 1382, -338, -1450, -1004, -39, -1154, -1105, -774, 39, -702, 556, 1630, -886, 792, 
    -1262, -186, -2475, -833, 994, -236, -2050, -335, -1023, -1295, 473, -1119, -865, -465, 501, 227, 
    -1376, 427, 228, -1447, 79, -96, 1642, 2523, 2060, -934, -1982, 197, 400, -835, -965, 1227, 
    -675, -397, 2361, 3592, -411, 301, 2116, 2511, -283, 43, -814, -1442, 113, -695, 84, -1060, 
    -969, -3248, 3094, -695, 1007, 2106, 1044, -3020, 2132, -1270, 1571, -2795, 1007, 696, -1940, -1266, 
    -32, 316, -1270, 1032, -1136, -361, 759, 1512, -634, 2108, 896, 485, 783, -517, -491, -1129, 
    586, 1963, -977, 2884, -1131, -1909, 839, 572, -2066, 2808, 1645, -1712, 512, 857, 652, 1687, 
    -622, -104, 308, 5139, -1860, 488, 2071, -2115, -2740, 929, 2307, -2533, -1680, 1870, 1402, -5041, 
    815, -3274, 405, -911, -425, 1876, 2767, -2350, 692, 1935, 531, 1187, 154, 5211, 4983, 1680, 
    560, -362, 1481, 1494, 100, 338, 1465, 1173, 1690, -2107, -223, -3186, -629, -962, 86, -880, 
    1840, 3441, 1070, -1845, 1517, -1302, 831, -5565, -2554, -2693, -960, 1006, -621, -3327, -3735, 1505, 
    1283, 1035, -1979, 1202, 716, 772, -864, -3384, 1563, -2254, -229, 2292, 69, -1730, 2504, 5449, 
    2600, -1785, -1372, -2935, -579, 996, 697, -109, -111, -1125, -733, 2999, 7, 780, -983, -2532, 
    2681, 2314, 3533, 2815, 1514, 2700, -1496, 1037, 1484, -559, -3520, 1472, -272, 1566, -549, -778, 
    4860, -836, 1973, 871, -2149, -1610, 1844, -4541, 6179, -1948, 1506, -3861, 2271, 1707, -2604, 612, 
    -1082, 476, -5983, -5530, 24, -3090, 2414, 719, 1490, 976, -5240, 4493, -183, -866, -1916, -8644, 
    553, 1935, 1375, -1991, -742, -2008, 1954, -1555, 285, -735, -2142, 1628, -141, -301, -991, -1425, 
    -904, 660, 2654, -3138, -1536, 1492, 518, -837, 292, 4068, 304, -320, 750, 420, -156, -1288, 
    4746, 2993, -2757, -5655, -337, -1469, 1565, -1419, 631, -4029, 2063, 4169, -698, 1354, -1919, -2358, 
    -455, -1863, 1604, 7067, -222, 3216, -612, 5346, 2194, 1501, -3855, -2764, -53, 1389, 687, -2283, 
    2015, -2721, 3984, 2630, -2063, -788, -411, -2938, -1118, 2001, -3365, 2458, -488, -245, -2410, 3807, 
    1637, 1664, 1295, 1191, 82, -988, -1149, -3628, -1579, -1242, -1202, -4195, 587, 1362, 604, -1392, 
    -72, 2925, 1098, 1170, -3190, -1391, -1087, 1300, -5255, -2116, -4825, 3984, -3037, 126, 5262, -3467, 
    2069, 3591, -1987, -1928, -719, 2181, 449, 2963, 2827, -298, 305, -1215, 177, -4301, -1585, 712, 
    82, -603, 4217, 1386, 437, -2609, 2218, -3449, 1195, -1966, 439, 3604, -1116, -488, 1502, -1230, 
    -1917, 3289, -294, -1196, -1241, -3015, 1937, -4158, 1141, 5186, -1435, -2282, -4824, 1960, -533, -840, 
    2115, -4289, 1993, 1203, -4298, 1466, 1336, -3601, 3666, -2393, -1186, 3891, 7431, 1787, -4801, -213, 
    -1964, 43, -2274, -3524, -4729, 3707, -4792, -145, 3623, 1608, -3820, 5785, 3107, -189, -1134, -1364, 
    -1767, 1200, 563, -2067, 273, 988, 420, 1100, -458, 3883, 371, -1038, -20, -213, 1011, 3508, 
    -588, -2164, -1867, 742, 5176, -432, -871, 1565, -562, -2841, -8, 2400, 1342, -655, 686, -493, 
    8135, -2145, -5696, 4031, 102, 169, -2793, 2503, 2869, -295, -2074, -951, -1634, 277, -1959, 4089, 
    -147, -2179, 6133, 263, 624, -264, 2709, -604, -1450, -3898, 3636, 189, 174, -360, 1476, 6419, 
    418, -1319, -685, 1000, 1059, -1697, 151, -734, 164, 702, -623, 756, -338, 1324, -1398, 306, 
    3410, 971, 110, 1516, 1019, -725, 68, -446, 936, -1537, -856, 2929, 615, -413, 218, 237, 
    -4603, 334, 2340, -2175, 8944, -2439, 2302, 323, 6863, 1490, -624, 188, -7904, 28, -508, -1984, 
    1110, 294, -4454, -4511, -851, 1253, -1281, 2043, -328, 1393, 2093, -503, 53, -1369, -419, -1550, 
    20, 1261, 1114, 2905, 189, -1425, -837, 3389, 2052, -915, -2107, 279, -626, 2231, -859, -1069, 
    557, -1412, -1573, -853, 5888, 1101, 234, 2750, 2172, -889, 2259, -2421, 299, -568, -1243, 400, 
    -1611, -430, 822, 1477, -3495, 2474, 1771, -4712, -1587, -1403, 80, -951, -2988, -3766, -3644, -1243, 
    -226, -4946, 3268, -16, 508, 2511, -707, -2630, -1122, -1741, -1532, -944, 717, 1929, 593, 837, 
    -401, -1932, -745, -792, -1050, -2633, 3303, -1569, -258, -717, 3645, 4318, -419, -1526, 336, -170, 
    -2546, 1695, 488, 166, -2192, 4034, -85, -1506, -633, 1205, -3094, 1600, 2955, -1956, 19, 2313, 
    -2093, -228, 980, -282, -10510, -915, 1656, 684, 3356, -293, -2427, -1548, -4557, 2273, -48, -336, 
    -90, -1384, 1640, 1760, 980, 124, 1927, -550, -1432, -1836, 1122, 2538, -630, 2116, -3282, -6821, 
    -2207, 1806, 119, 3091, 839, -1466, -170, 488, 468, 274, 1292, 2473, 17, -291, 4415, -821, 
    -5720, -3150, 4840, -1699, -1145, -1767, -1802, -5839, 7486, -3376, 124, -1078, -3080, 1208, -1763, 1155, 
    -3790, -509, -1231, 5101, -6709, -4254, -3083, 4681, -9028, -608, -490, 6795, 1407, -1233, -79, -739, 
    -2216, 294, -2656, -1355, 652, 703, -217, 3151, -4368, -2497, -236, 768, 2744, 894, -2109, 4206, 
    1640, 126, 6139, -2286, 1475, -2563, 334, 482, -3578, 3160, 2709, 1661, -1687, 990, 949, 68, 
    150, -1130, 4681, 3083, -1047, -570, 1747, -1590, 276, 1985, -1831, 144, -49, 196, -354, -753, 
    7, -4570, -1808, -1963, -5186, 2204, -3520, -2634, -800, 1061, -161, 1073, 1966, 1710, 168, -2017, 
    -6703, -206, -536, 942, 698, 2457, -1320, 1419, 1380, -957, 1937, 957, -30, 600, 443, -546, 
    -3627, 1611, -1570, 4858, -2280, -261, 3831, 2961, -2896, 2946, -4232, 1342, 1106, -1693, -413, -343, 
    -1404, 2799, -2771, -6267, 833, -604, -2619, -2012, -4807, -484, -5820, -895, -460, 518, -2818, 1207, 
    3519, -1296, -635, 681, -2486, 2363, -198, -1662, 2121, -508, -1917, -2878, 219, -2709, -1292, 992, 
    5010, 3403, -2124, -5123, -1457, -4773, 287, 2221, 745, -3114, 3593, -1735, 2400, -833, -2836, 653, 
    921, -1502, 4126, -4369, -3295, 2163, -835, 705, 648, -1129, 288, -2555, 878, 716, 3424, -3073, 
    -293, 1723, 1151, 3397, -5530, 1351, -3684, -1898, -171, 2061, 3823, -487, -1129, 383, 3522, -2686, 
    -1082, -3917, -293, -2675, -1822, 525, -1807, 4206, -2073, 3042, 4139, -4240, 4553, 2449, -327, -638, 
    -1861, -892, -316, 3284, -2620, -3538, 3946, 3835, -5024, 2139, 2902, -984, -2826, 2925, 3279, -197, 
    -730, -126, 1663, -2432, 5468, -2992, 1060, 5454, 3761, -9351, -990, 1555, 1222, 3516, 581, 3752, 
    -3447, 3960, -9436, -5571, 7894, -3852, 8773, 6903, -9455, -1745, -3323, 12503, 2963, 326, 2060, -545, 
    -10933, 847, -669, 1228, 629, 2897, 1422, 365, 12087, 9913, -7521, -5115, -340, -840, 4606, -1824, 
    -1015, -950, 4491, 5031, 181, 3818, -6209, -425, -5918, -4459, 12412, -548, -266, -497, 10723, -4619, 
    -963, -2649, 4188, -2752, 8659, -8846, -5786, 6723, 6000, -1968, 2635, -3286, -730, -4559, -5769, 66, 
    -11856, -5428, 1575, 3596, -6521, -2231, 7318, 1797, 3240, -4706, 1218, -4538, 3164, -266, -1647, 1890, 
    5205, 7815, -7557, -8564, -4619, 5966, -10429, -1250, -1704, 3628, -5662, 3984, 549, 4169, 4692, -3582, 
    -12249, -387, 5177, 3235, 2954, 7335, -629, 3405, -426, -857, 3674, 9978, -1352, 4172, -648, 544, 
    2388, -1214, -918, -10679, 5426, -2395, -247, 5312, 1577, -336, 4092, -3747, 198, -2410, 2928, -5018, 
    -709, -5099, 1511, 640, 2956, 1227, 1152, -5806, 13581, 390, -348, 4226, 3664, 2566, 2802, 5801, 
    2519, -1781, -3704, -3390, 6449, -3777, -1571, 3332, 1737, -3877, -1319, -8973, 4927, 1188, -1467, -6054, 
    -4990, 2699, -1008, 3608, 6579, 1248, -3723, -8810, -4543, -345, -5276, -2966, -4759, 1367, 3477, -12325, 
    -682, -623, 11410, -9782, -5837, 1179, -4529, 7919, 12757, -10253, -9604, 11337, 3965, 822, -3486, 3528, 
    -4105, 13985, 6265, 3722, 7970, -7714, -7976, -3529, -7604, -929, 4136, 6914, 949, -1525, 5188, -6950, 
    5138, -6457, 8625, -3051, 7909, 3527, -9658, -1837, 7004, 7872, -10887, 2759, -9744, -6, 6511, 6398, 
    -7957, 3859, -3888, -11190, 3862, -4274, 2276, 3207, 11360, 6948, -4205, -2774, -1688, 2450, -4834, 5639, 
    796, -696, -447, -486, 71, 2359, -211, -691, 676, -444, -1283, -501, -48, -2926, 1836, -4579, 
    10339, 2322, 1581, -5951, -9984, 1146, -884, -4880, 890, 514, 3533, -446, -3969, -983, 1497, 3461, 
    -1284, 504, -700, 1420, -7612, -24, 3293, 2846, -1331, 1233, 4452, 309, -1132, 1710, 587, -2500, 
    2245, -346, 7, -4689, 716, 119, -2429, 3115, -250, 454, -4888, -4252, -513, 3421, 508, 413, 
    -3152, -1578, -2118, 2536, 68, -1599, -1716, 1604, 168, -750, 4119, 579, -474, -1072, -1343, -345, 
    2128, 532, -3979, 162, -5218, 332, 1488, 4765, -3836, 1355, 2792, -136, 44, 266, -761, -625, 
    -5245, 1613, -674, -874, 1130, 897, -529, -1149, -3645, -1471, 3128, 724, -11761, 1506, 259, 1854, 
    109, 3106, -533, -1680, 73, -294, 599, 612, 435, -413, -1229, -2188, -84, 730, 411, 1011, 
    -1112, -407, 345, -2941, -1358, -516, 2086, -536, 1699, -2362, -1436, 2041, 170, 887, -587, 115, 
    -1800, 1638, 400, 4801, -5269, -608, 615, 2565, -5758, -317, 2321, 5427, -4745, -2483, -517, 210, 
    -4701, -172, -1111, -1474, 6858, -1357, -3072, 541, -2176, -1629, 1778, 2023, -6748, 2097, -2025, 4417, 
    -339, -2171, 575, -700, -2043, -93, 4107, 1816, 517, 3452, -1658, -1389, 906, -610, 566, 5593, 
    -327, -472, 1280, -3990, -779, -895, 3144, -315, 1118, -3553, 1616, -433, -2012, -1306, -2094, 1500, 
    -5521, -1500, 1669, -881, 2886, -1374, -1431, 2969, -3068, -1599, 2333, 842, 2191, 1430, -5107, 1326, 
    -2268, 690, -2767, 3623, -6831, 1014, -3025, 59, -3149, -372, 1321, -58, 886, -2210, -3171, -2496, 
    716, 1559, 4393, 5768, -1334, -675, 590, 397, -1829, -771, 2222, 334, 473, -1021, -177, -1196, 
    28, 995, -4936, 204, 1010, -1557, -1489, -1590, 1408, 1157, -1746, -1983, 63, -1429, 882, 945, 
    -62, -542, -888, 61, 657, 1259, 452, 1757, -1591, 1573, -871, -811, -439, -526, 2026, 1023, 
    934, 1712, -2921, -1294, 985, 139, -3468, 3000, -2435, 290, -3281, 2063, -871, 1533, 2187, -965, 
    1820, 338, 1636, -3673, 578, -140, -3584, 53, 3217, 1768, -1939, 4511, -1216, -670, 2293, -1795, 
    18, 3553, -647, -1249, 1841, -1489, 791, -3595, -255, -1455, -2910, -1501, 109, -210, -147, 14, 
    -3289, 155, -574, 1195, 1850, 910, 878, 2021, 2915, -218, -723, -764, 573, 121, -144, -104, 
    616, 402, 122, 577, -1223, -3161, -1215, 955, 765, 106, -59, -2025, -381, -528, -40, 1100, 
    391, 699, -979, 2999, 677, 1851, -2024, 866, -1327, 1153, 2110, -3979, 141, -151, -525, -300, 
    392, 1001, -40, -1420, 1314, 380, -1214, -1990, 4099, -1968, 3533, 1888, -1501, 1876, -2148, 1416, 
    3676, 937, -699, 1734, 2491, -106, 1004, -1876, -2340, 912, 5482, 779, -1538, 1764, -2771, -1497, 
    -188, 454, -49, -1543, -1808, 515, -2529, 3575, 1915, -95, 625, 3948, 740, 116, -47, -1846, 
    -2562, -1021, 1084, -2127, 1007, 1634, -1699, 1459, 141, 905, -3723, 1538, 386, -1748, 148, -1339, 
    100, 277, 1637, 169, 1798, -3841, 1819, -273, 2467, 1024, 1543, -331, 878, -10, 1463, -991, 
    3189, -1884, -190, 1462, 6357, 246, 4022, 2028, 1382, -1107, 317, -1632, -501, -1503, 4324, 2128, 
    1458, 359, 2528, 527, 515, 1476, 1322, -5659, 1862, -1688, 846, 734, -156, -1626, -2035, 487, 
    1143, -13, 2516, -1800, 1000, 2882, -495, -3058, -109, -3125, -603, -2360, 1158, -1175, -4243, -4795, 
    -1781, -1101, -1031, 2678, -4428, 1608, -142, 1058, -3168, 4399, 7932, 733, -570, 3774, -3290, 667, 
    2062, 513, 1916, 4493, -4020, 1269, -2960, 5138, -3750, 2861, 3822, 558, 1572, 285, -5329, -3011, 
    4037, -1716, 314, -3391, 6108, 413, 4924, 1269, 4086, 1642, 858, 2452, -2645, 763, -2617, 3170, 
    -1009, 2257, 673, -4774, 1103, -2331, 4278, -145, -1460, -327, -55, -4479, 732, -1639, -344, 3840, 
    -884, -631, 4528, -829, -713, 38, -4780, -1443, -2699, 747, -1873, -81, -1409, 206, -94, 1082, 
    -5993, -2284, -1315, -1024, -1794, 1627, -3, 1486, -2905, 1898, 152, 845, -861, -449, -1179, -13, 
    6616, 4852, -2920, 760, -1618, 723, 1897, -2393, -2944, -123, 2397, -5374, -224, 1607, 583, -1929, 
    166, 59, 942, 549, 330, 2606, -119, -488, -1369, 1005, 258, 1965, -800, -370, 1030, -193, 
    139, 2409, -2312, 4315, 130, 1568, -748, -2890, -1734, -3440, 556, -995, -1225, -611, -1943, 3953, 
    898, 214, 981, -1053, -2447, 1422, 2384, 973, -911, -1433, -2954, -3363, 344, -1884, -972, -4794, 
    -7239, 1299, 1637, 776, 3730, 51, -1018, -269, -508, 4748, -2913, -2462, 2961, 617, -59, 5019, 
    1336, -409, -297, -742, -1626, -2944, 1240, -3669, 749, -1080, 4875, 739, 2011, -702, -230, 2237, 
    4162, -8840, -4402, 3028, -541, 2193, 3958, 2027, -291, -3176, -4788, 1434, -3386, 4714, -1059, -2080, 
    2986, -250, 2892, -1039, -8555, 552, 945, 2719, -5804, -975, -1856, 509, -2956, 1814, -7478, 5347, 
    716, -574, -1889, -2215, 5070, -386, -3227, 2503, 3377, -604, 3265, 1745, 3737, 936, 2702, -5259, 
    -206, 3039, -1484, -4596, 2169, 223, -2063, -3361, 2388, 3157, 1923, -272, -338, -3, 5624, -174, 
    -170, 2116, -679, 2679, -513, -502, -1141, -580, -1077, 2042, 171, -862, 1690, -1998, 62, 683, 
    3224, -726, -2484, 1306, -1245, 128, -415, -660, -2962, -201, -1491, 822, 3404, -33, 1084, -227, 
    -2611, -1455, 305, -3728, 5411, -2559, -394, -1046, -1627, 85, 1979, 2166, -3164, -4499, -1841, -2830, 
    -912, -837, -3140, 346, -444, -1535, -591, 749, 236, -708, -1830, 4567, 238, -485, -6240, -3622, 
    -223, -2804, 3097, 1893, 775, 3246, 3418, -546, 1000, 243, -2094, -2258, 263, -328, 1382, 434, 
    4089, 931, -1121, 477, 719, -235, 1821, -1080, 2320, -962, -1334, -334, -2490, 183, 494, 599, 
    562, -2000, 2686, -2132, 9567, -809, -864, -448, -878, 1135, -1777, -1281, -3947, -1091, -88, 173, 
    544, 649, 910, -1392, 527, -625, 636, 536, -387, 809, -3519, -267, 327, 235, -360, 101, 
    351, 1495, 2823, 2390, -746, -1338, -3057, 1441, -3456, 2776, 1797, -949, 1101, 1178, 5550, -622, 
    -1240, -666, 818, -2928, -1405, -221, -655, -835, 5106, 2550, -3336, -902, 1605, 138, 4506, 2911, 
    663, -458, -861, 1564, -1947, 1627, 2687, 1491, 7076, -1987, 4, -727, 2944, -5324, -1862, -1114, 
    -202, -1353, -437, -71, 566, -373, -1817, 3552, 458, -851, 789, -4680, -544, 748, -912, 858, 
    -650, -3786, -1315, 1591, 2118, -3809, 787, 958, 2021, -22, 5491, 1517, 2369, -1992, -765, 213, 
    1732, -170, -1348, 3109, -3979, -470, 3651, 83, -1652, 80, -437, 1625, -208, 326, 1027, -3498, 
    -9877, 53, 1102, -3111, -3713, 1682, 1147, 249, 664, -2057, -152, -279, -6523, -12, 145, -1137, 
    -199, -2667, -540, -4654, -941, -1375, 243, -162, -584, -1356, -1253, -1241, 740, -389, 1797, 2246, 
};

static const int16_t fx2_paramModel1Alpha[16] = {
    3810, 258, 517, 7343, -356, -7895, -2773, 7208, 112, 369, 6918, 378, -6513, 538, -6608, 5529, 
};

static const int16_t fx2_paramModel2Bias[16] = {
    1479, 2290, 18, -1212, -1075, -2508, 1757, 1900, -146, 1078, 2458, 2029, 2054, -505, 1795, 1429, 
};

static const int16_t fx2_paramModel2Weights[2304] = {
    1361, 2080, 2885, -982, -1598, -472, -1894, -802, 5651, -25, -1253, 499, 1097, 243, -465, 760, 
    -84, -2838, 583, 1319, -6521, -401, -84, -697, 852, -1476, 562, 52, -584, 990, 1760, -1078, 
    241, -262, -1305, 591, 663, 398, 1084, -1484, -710, -1220, -1275, -583, -490, 166, -503, -466, 
    2632, -1692, -2162, -1728, -1546, -158, 490, 1585, 1608, -1512, -781, -1720, -1025, -822, -521, -264, 
    -10930, 3207, 796, 1383, 275, 2, 113, -353, 435, 277, -1986, 1586, -2429, 647, -1153, -780, 
    3458, 4621, -7143, 1072, 750, 633, 231, 1561, -1496, -680, -1642, -2879, -1565, 351, -597, -382, 
    -1572, -386, -3049, 3130, 889, 134, 2000, -6620, -101, -294, 1551, 1958, 1955, -1731, -764, 726, 
    685, -1290, 4431, -1628, -1129, 161, 1817, 494, -25, 5234, 1625, 1971, -3478, 674, 1092, 1837, 
    1893, -836, 1839, 3688, -140, 72, -90, 163, 3483, 732, -958, 1516, -1397, 758, 601, -1275, 
    -1285, -3002, 1418, 3452, 1207, -1302, 432, 6, -149, 380, -1262, -2678, -1113, 147, -1501, 522, 
    -528, -1763, -1044, 15, -806, -366, -617, 547, -718, -35, 635, -154, -90, -451, 8, -1898, 
    2627, 7104, 3767, -7087, -909, 2448, -189, -66, -1206, -47, -2012, -1172, 1384, -296, -802, 325, 
    -6287, -556, 886, -410, -944, -634, 133, 825, 1357, -847, -1442, 742, -3130, 51, 10, 258, 
    332, 433, 774, 1860, 2189, 1656, 763, 867, 621, 410, 1518, -4030, -1132, 2199, 1912, -202, 
    266, -366, 1425, 855, 494, -664, 3807, 343, -94, 283, 1393, -1442, -108, 344, 2996, -201, 
    -289, 1227, 725, 73, -280, -1831, 2432, 2295, 730, -413, 350, 486, 163, -1835, 2184, -2710, 
    725, -1724, -1516, 588, 762, -1869, 362, -3482, 775, 2029, 1013, 3727, 6907, 2958, -3934, -506, 
    3077, 1557, -187, -2175, -13970, -3435, 383, 417, 1326, 52, -1408, -300, -1576, -2374, -2159, 43, 
    4403, -1362, -1850, -2142, 1315, -3587, -2530, -3660, 1073, 2341, 2039, 1878, 1844, 286, -1553, 421, 
    -10897, -1250, 3389, -4270, 25, -1, -623, 561, 3313, -1956, -1578, -863, -322, 3672, -421, 3077, 
    -2316, 257, -2056, -1142, 1693, -165, -115, -451, 3586, -1431, 1120, 117, -3006, 198, 6892, -2483, 
    1381, 3960, -3349, 1734, 607, 216, 180, 281, -3220, -443, 378, 1957, 432, -2600, -610, 94, 
    -4432, -2599, -8378, 1477, -1088, -504, 1728, -11287, 115, -1335, -485, -2298, -1189, -1238, 2780, -1361, 
    1600, -10381, 166, -4391, -5550, 14, 673, -103, -8833, 8029, 2352, 4030, 849, -908, 971, -1934, 
    -380, -929, 2398, -3014, -2420, -894, 78, 532, 1436, -2002, 2485, -947, 1775, -419, 473, 28, 
    330, 3821, 1948, -2674, -1148, -1765, 1622, -55, 1263, -1386, 203, 1235, 1927, 1162, 1986, -452, 
    2140, 2303, -6241, -2597, -622, 265, 572, -1924, -717, -2181, -1857, 1245, 537, -1060, 312, 1284, 
    -235, -3868, 1936, -1710, 2817, -1523, -2143, 301, 790, 2578, 32, 2841, 404, 406, 910, 1896, 
    -11427, -707, 252, -186, 498, 408, 1389, 301, 4772, -903, -1778, 898, -1840, 934, 1159, 423, 
    1266, 823, 1823, 1683, 892, 1504, 1443, -735, 1275, -675, -113, -7699, 79, 1067, 221, -1264, 
    896, 292, -11647, -3329, -442, 74, -1254, -8062, -722, 1200, 700, -280, -367, 2033, -1201, 1186, 
    -1503, 562, 2430, 1059, -6984, -3831, 741, -3246, -970, -2274, 1824, 1110, -182, 1706, 52, 661, 
    -2736, 2181, -2209, 689, -1459, 120, 1371, -1581, -933, -254, 131, -217, -1735, 702, 1872, 687, 
    264, 88, -1306, 3418, -3864, -2596, 34, -350, -1111, 1437, 1391, -395, -37, 1421, -336, 128, 
    -3631, -2646, 450, -2378, 616, -233, -834, 1853, -549, 375, -554, -178, -1227, 18, 1236, 247, 
    -1334, -4687, -3285, -5555, -874, 324, -1970, -1742, 4, 2350, 1196, 2434, 52, 597, 1229, -281, 
    -160, -317, 1379, 940, -371, -804, -365, 213, 665, -204, 2058, -800, -1145, -607, -3955, 875, 
    1860, 1706, -2388, 1722, 545, 591, 890, -400, -1109, 889, -280, -2677, -457, -371, 1744, 1338, 
    -946, -2199, -1465, 2407, 924, -812, -983, -1632, 1928, 1803, 1841, 4620, -505, 135, -3013, -403, 
    2738, -4090, 3010, 1058, -2685, -1145, 2237, -284, -949, 1971, 4608, 2475, 39, 366, -2545, 2387, 
    -118, -889, -1828, 63, 1061, -273, 149, -1298, 454, 656, -645, -417, -1299, 141, 938, 977, 
    -0, -510, 325, 883, -538, -606, 270, -336, 125, -1107, 36, 2868, 2573, 2414, 1872, 1647, 
    268, -43, -1128, 2207, 672, 444, -556, 636, 1095, -121, 379, -609, -1908, 632, -533, -1903, 
    1345, 583, -389, 386, 974, 272, -16, 484, 1344, -1709, -396, -644, 1157, -1429, -1375, 2889, 
    -43, -742, 165, -412, 900, -206, -582, -37, 2969, -1463, -844, 240, 2087, -400, -2322, -1006, 
    -299, -475, -305, 327, 2564, -994, -803, -536, 1860, 175, 287, -5671, -804, 21, -446, 965, 
    864, 2586, -10385, -423, 454, 1598, -1152, 110, -610, 223, 3620, -726, 84, 593, -722, -1783, 
    -550, 517, 2754, -178, -827, 457, 257, -231, 1474, -1688, 2229, 2190, -479, -938, -632, -805, 
    -741, 154, 1047, 124, -1528, -2741, 457, 838, -2764, 469, 1529, -998, 455, 1515, -889, -980, 
    2088, 927, -2431, 1258, -700, -3752, 993, 246, 4109, 1847, 1856, 1115, -150, 224, -2481, 2996, 
    789, -566, 1063, 330, -1460, -1425, 221, -443, 579, -1216, -3646, -1391, 304, -295, -391, -2929, 
    -1432, -1515, 1691, 802, 1758, 20, 2231, 3149, -1928, -1634, -1084, -141, -5, -2333, 1425, 390, 
    -3245, 3278, 737, -499, -907, 531, 58, -645, 40, -902, -309, -413, -821, -2679, 4535, 500, 
    -2116, -7933, 947, 830, 1693, 1142, -32, 3480, -2321, -1493, 268, -3608, 3370, -1660, -2126, 1908, 
    -2635, -594, -403, 1159, 403, 80, 3586, -9276, -1454, -2501, 1977, 3331, -3809, -1298, 2105, 801, 
    313, 1406, -5620, -4166, 84, -1873, 1461, 1296, -899, -1275, -4848, -1799, 2001, -1527, -675, 411, 
    1701, -2711, 3719, 7884, -1447, -280, 581, 872, -265, -5470, 1701, -2014, -3945, 609, -2055, -2318, 
    23134, -3349, 2864, -3806, -1428, -342, -2511, -765, -291, -423, 1089, 2797, -2717, -19, 1285, -234, 
    -1248, 4749, 4385, 3073, -802, 131, 649, 2054, 507, 2135, -3310, -635, 938, -995, -3183, 4655, 
    695, 3775, 2199, 9146, -230, 706, 695, -4078, 206, 1736, 378, 2050, -752, -24, 182, 1005, 
    -10131, -1018, -523, -689, -5584, 174, 2747, -1547, 2342, -1131, -1367, 2934, 4585, 240, -8327, 621, 
    -1842, -1523, 1582, 897, 372, -976, -2787, 881, 1041, 399, -1071, -7659, -1401, 6671, -144, 849, 
    83, -1995, 144, 2062, 1447, -547, 4156, -2917, -360, -616, 4243, 2221, 811, 1572, -4717, -4857, 
    175, 691, 1128, 398, 484, -3518, 1819, 2701, 536, 1428, -483, 225, -3886, 509, -1341, 2961, 
    1878, -9946, -6487, 947, -300, 1433, 866, -871, 3608, 950, -1085, -1205, 4304, -10397, 3122, 323, 
    -81, 4297, 2319, 395, 7140, -4536, 815, -2048, 8788, -2651, -3429, 106, -1958, -2987, 8261, -5812, 
    -1659, 1828, -3552, 2895, -1925, 2856, 2963, 1615, -448, 4005, 3191, -183, 3979, 7286, -3843, 2232, 
    3597, 7081, 1543, 1002, 2145, -692, -2274, -11537, -3544, 6201, 2204, -7285, 1191, 4144, -1921, 6602, 
    294, 1753, 1731, 3366, -1938, 268, 1119, -2079, 1652, -2112, 2623, 182, 637, -171, -8889, -5733, 
    1393, 1882, -3960, 816, -1548, 1443, 1198, 2395, -2752, 3068, -1679, -1601, -1683, 3040, 874, 1279, 
    1079, -2267, -1038, 4664, -376, -1826, -3037, -18545, 287, -2890, 4409, -2376, 9135, 4356, 3058, -3693, 
    1324, -4208, -3322, -6779, -6166, -12495, -6435, -5587, -1731, -7025, -16612, -13122, -1999, 476, -257, -5048, 
    814, -3696, -3366, -2180, -2138, 536, 53, -2398, -3864, 8627, 2227, 3394, -10644, -1486, -189, 3319, 
    -3265, 1664, -6150, 1741, -4945, -2829, 2773, -785, 5063, 3766, 2261, -9330, 3216, 1097, -1572, -1635, 
    5671, -2165, -3810, 1622, -2702, 5566, -831, 2016, -3617, -3759, 2093, -2385, -1052, -2338, -2796, 1853, 
    1118, -10799, 2178, -6084, -322, 4048, 362, 1721, -6370, -2128, 2945, -2201, -2610, 6, -1307, -5115, 
    -14767, -2105, 1588, 6724, 4711, -1973, -2258, -3583, 2126, -2178, -1631, 2395, -1944, -508, 3900, -1040, 
    -10365, 452, -7597, 3041, -5288, -8956, 79, -89, 2262, -294, -1666, -14232, -2369, -8058, -3503, 3526, 
    6379, -3543, -16431, -4058, -3546, -1696, -3573, 1282, -1916, -685, -1115, 324, -1289, -8261, 2371, 3611, 
    1056, -23, 1141, -4797, 2475, 7213, 5482, 3462, 1839, -1085, -1633, -941, 3248, 3075, -693, 2857, 
    -2019, -1610, 3564, 680, 1331, -96, 1309, 3638, -2086, -1497, -1272, -1336, -3105, 3566, 881, 211, 
    1802, 2246, 885, -1376, -1304, -3761, -1729, -292, -5956, 1272, 71, 501, 1363, -1502, 244, 1595, 
    -2135, -1732, -1468, -1428, 1119, 336, -1393, -1310, 2811, -1749, -1950, -2105, -2946, -2798, 2404, -1512, 
    -644, 6067, -3153, 922, -162, 3945, 2348, 8154, -686, 733, -531, -4941, 686, -462, -1243, -5625, 
    493, -215, 153, 702, 1877, 1246, -505, -427, 939, 1168, -63, -110, 3949, 341, -1191, 2053, 
    928, 2198, -1428, -613, 1375, 244, 1389, 1772, -284, -1090, 184, -1735, -807, -364, -3859, -2, 
    -3027, -1506, 2864, 1694, -636, -151, -2727, -3877, 2225, 1753, 4188, 2006, -3065, -1658, -2893, 630, 
    453, 92, -695, 909, -500, -4913, -1855, -1155, -1626, -1820, -8723, -3411, -862, 33, 862, 3304, 
    2278, 457, 1605, 587, 3221, -925, -483, -456, 2445, -549, -2295, 1308, -1155, 2236, -984, 3710, 
    -1274, -679, -1567, 1328, -2955, -286, -1675, 274, 1413, 733, 1706, -302, 3409, -571, -3679, 813, 
    -959, 9, -1361, -428, 2795, 1048, 233, 1391, 2751, 6012, -2841, 669, -5403, 6579, 5790, -153, 
    -450, 2165, 829, 4604, 222, 6216, 2333, 611, -2079, 604, 1630, -1519, 742, -29, 1679, 916, 
    -5136, -1599, -1014, -2629, -2068, 455, 257, 3286, 3761, -1779, -752, 1240, 1004, -1130, 4556, -477, 
    -3479, 329, -7318, 1072, 955, -1658, -2299, -879, 2263, 277, -272, -7434, 995, 1802, 663, -2793, 
    -304, -341, -12398, 3255, 1389, -2088, -3272, 129, -789, 820, 1083, -1834, 1003, 423, 323, -1565, 
    509, -8638, -1462, -10754, -2477, 1314, 387, 2569, 909, 969, 2015, 2179, -755, -2374, 3888, 1805, 
    -85, 872, 36, -409, -843, -922, 2462, 782, 153, -293, -485, 649, -2120, 412, -933, 558, 
    1299, -13, 690, -1727, 1521, -526, 2382, -2484, 752, 415, 845, 463, 817, 473, -612, -532, 
    292, 653, -1359, -426, -405, -425, 1402, 791, -4, 856, -299, -1303, -704, -1108, 643, 1395, 
    698, -719, -697, -410, 867, 259, 1813, -663, -368, -811, 1314, 181, 780, 528, -1263, -1331, 
    -124, -156, -305, -1900, -1052, 1245, 319, -875, 1822, -430, -1602, 255, 383, -577, 1586, 2133, 
    2151, 981, -1101, -962, 181, -1228, 2508, 2964, -189, -1383, 892, 1165, -142, -2670, 1177, -5131, 
    -1363, -1153, 694, 1261, 405, 827, -790, -149, 100, 285, 1687, 2281, -659, 4, -268, 1518, 
    627, -427, 996, -993, 350, 1631, -1479, -1612, 128, 1281, -2525, 213, 1254, 1263, -1815, -1518, 
    104, -711, -3888, -1668, -1393, -778, 99, 1046, -1703, 919, -382, 847, -1922, -655, -582, -998, 
    7346, 5073, 3121, -2345, 2540, 1084, -1708, -1225, -8, -856, 885, -2209, -5366, -1629, 718, -1414, 
    -609, -2138, 4388, -3250, -102, -1204, 2373, -300, -1719, -1068, 99, -31, -210, -664, -1976, -2083, 
    -3353, -1463, -8518, -449, 110, -397, 109, -274, 392, -770, -855, 891, -1198, -3, 442, 2178, 
    -1929, -915, 41, -1388, -415, 1453, -395, -957, 195, -947, -950, 3158, -3229, 1962, 2653, 12, 
    248, 472, -169, 587, -317, 1197, 1043, 1874, 1937, 318, 132, -6958, 1619, -381, 560, 346, 
    159, -268, 3268, -163, 890, 277, -795, 41, -1123, -634, 1336, 1002, -529, -708, 3226, 1210, 
    349, 393, 142, 203, 2136, -1255, 337, 1081, -256, 1382, 2287, 1601, 1468, -91, -214, -820, 
    -2019, 987, 1040, -1045, -2705, 1389, 1114, -2579, 3667, -1113, -690, -164, 168, 18, 3993, -497, 
    -43, -3835, -2022, -1817, 3696, 1797, -3066, -631, 767, 2672, -859, -863, 1708, -5040, -213, 3441, 
    -697, 1549, 85, -52, -2214, -1662, 221, 95, 943, 1406, 1333, 552, 1001, -27, 1019, 1659, 
    -433, -956, 4548, 2208, 334, -2408, -276, -8980, -262, -3067, -427, 426, 1445, -1910, -1198, 1173, 
    1522, 68, 1085, 305, -64, 1360, -522, 1650, 3523, 1321, 422, 632, -2110, 2900, -2750, -327, 
    588, -626, 406, 2291, -9257, -3586, 530, 2392, -2795, -4157, 1545, 2716, -2629, -445, -2627, 172, 
    2017, -891, 1995, 828, 1212, -2494, -1889, 2447, 118, -327, 1346, 199, -2204, -987, 1286, 3079, 
    98, -1056, 392, 2104, 965, -1367, -8059, -11995, 339, 2613, -12947, -927, -76, -1219, 306, -2531, 
    -66, 181, 2265, -2126, -326, -996, -470, 1944, -1173, -4435, -555, -2379, 2009, -2584, 1355, -1330, 
    -1622, -518, -3978, 1373, -4588, -985, -365, 395, -1328, -670, -1623, 1160, -620, 478, 1617, -1125, 
    968, 1649, -3117, -162, 1359, -2693, 1334, -1408, 976, 287, 887, -1108, -823, -994, 3859, -3146, 
    -620, -2022, -5696, -1920, -483, -3402, -3151, -1224, 1049, 2217, -269, 1356, -2535, 3325, -2954, -8350, 
    -5840, -788, -47, -436, 430, -1039, -2290, -4690, 5, -2046, -1584, 3806, 2845, 1609, 1895, 2324, 
    -4391, -877, -5981, 1444, -5379, 2449, 1809, -369, 803, 1476, -3340, -10300, 1035, 912, 3538, 1051, 
    1227, -604, -787, 3001, -310, 5666, -2705, -611, -2941, -485, 2738, 4527, 1161, 2999, -611, 2243, 
    -81, 934, -1509, -2060, 324, 1141, -305, 1277, 1283, 778, 431, 467, 3163, -1893, -4785, 982, 
    -1373, -284, 1326, -215, -1063, 897, -1555, -970, 407, 293, 1756, 1047, -586, 1205, -3163, 662, 
    1120, -704, 1398, -1121, 1760, -816, -1188, 887, -774, -1859, 777, -410, 651, 1751, 1015, -1520, 
    -101, 3, 1388, -1095, 911, 159, -592, -1956, -323, 1188, -540, 633, -626, 532, 998, -891, 
    -256, 1000, 402, 1071, 22, 428, -2011, 2824, 922, 1462, -1195, 1071, -704, -870, 625, -4759, 
    97, -20, 1224, -42, 2197, 322, 97, -837, -1023, -343, 836, 304, -117, -1425, 5010, -980, 
    1203, 1805, 73, 1370, 1747, 565, 463, 2918, 1015, 162, -1087, 2468, 815, -1039, 66, 544, 
    -1638, 267, 1724, -483, -1601, 369, -651, 1610, 946, -185, 2134, 1916, 1103, 695, 1232, -1757, 
    642, 937, 457, 1151, 979, -3782, -4721, -2972, 349, -282, -3542, -2565, 1053, 723, 2198, 4937, 
    639, -631, 158, -458, -1282, 583, 314, -876, 862, 616, -1022, -444, 1710, 458, -1219, -1532, 
    -1572, -1481, -664, -513, 967, 2620, -1669, 1683, 1233, -937, -264, 183, -94, 171, 3094, -1841, 
    526, 12, 335, 973, 538, 331, -925, 365, 1037, 0, 142, -1067, -1771, 624, 1012, -1777, 
    -165, -1326, 354, -760, 202, -2155, -1010, -79, -570, 156, -2282, 98, -1778, -494, 3370, -1353, 
    1352, -984, -382, -431, 2802, -215, 589, 1012, 928, -1364, -532, 1400, 986, -1170, -3304, 434, 
    -576, -216, -5325, 520, -1884, -2207, -201, -1617, 98, -695, -1263, -6630, 3012, 1648, -1183, 1461, 
    -887, -870, -1176, 237, -2471, -879, -1465, 1786, -1609, 4, 1369, -751, 365, 78, 171, 2400, 
    -711, 927, 391, -4747, -19, 3471, 9, -946, 356, 966, 1128, 1159, 2155, -1437, 434, -3392, 
};

static const int16_t fx2_paramModel2Alpha[16] = {
    -17, 5414, -3116, 233, -788, 2853, 1291, 1436, 20, 6387, -11, 661, -588, 1874, 471, -630, 
};

static const int16_t fx2_paramModel3Bias[16] = {
    -541, 275, -3549, -1878, 1812, -1041, 3991, 49, -321, -1199, -2854, 2824, 1223, -2796, -510, -2796, 
};

static const int16_t fx2_paramModel3Weights[2304] = {
    1269, -970, 1047, 1459, 124, 129, 439, -337, 212, 497, -28, 1136, -1266, 1041, -565, 756, 
    -1501, 770, -349, 1105, 2342, -486, 1502, 113, -3308, -290, -7407, 1277, 723, 1456, 230, 1078, 
    1147, -5960, 1060, -1035, -416, 1775, -429, 141, -340, -597, -693, -256, -714, -3472, -87, -459, 
    -1262, -44, 51, 2823, 1647, 1575, -71, 656, -68, 1015, 1054, 22, -1044, -813, 663, -258, 
    -222, -1125, 555, -1539, 1583, 225, 642, -2801, -1038, 1379, 1201, 1437, -958, 40, -289, 34, 
    -50, 1179, -1277, -1078, -1809, 1525, -92, -1097, 594, 1913, 798, -964, -4773, 3160, -4095, 778, 
    -305, -5541, 1488, -688, 999, 551, 958, -161, -742, 3458, -718, 636, 501, -3593, -132, -201, 
    -88, 413, -1202, 169, 2483, 3638, -62, 918, 1035, 6, 106, -464, 2923, 268, 349, 708, 
    569, 864, 1548, 96, -449, -30, -1087, -571, -910, 156, -162, -510, 1329, 472, 913, -2, 
    -370, -1637, 953, 214, -215, -730, -754, 1646, 210, 767, 631, 1082, -1110, 1507, -390, 788, 
    -1153, -2639, 327, 312, 563, -129, -642, 1521, 564, 1823, -931, 1391, 1050, -1332, 638, 1158, 
    2939, 1574, -650, -159, -105, -1907, -486, -156, -673, -551, -163, 523, -1152, -2511, -214, 1032, 
    1976, -1494, 1, -432, 1597, -954, 1453, 294, -1412, -1449, -1152, -564, 105, -197, -1625, 236, 
    4644, -1974, -497, -635, 1747, -916, -1978, -347, 960, 1095, 244, -1550, -3772, -313, 497, -1112, 
    -245, -6031, 784, -995, 573, -165, -244, 336, -1047, -2801, -619, -604, 2988, -4400, 1579, 1143, 
    -135, -2007, -567, 357, 1866, -1135, 1102, 18, -2549, -218, -393, -309, 1537, -2536, -395, -79, 
    1406, -726, 163, 2122, -3236, 1652, -1233, -1169, -163, 22, -760, 608, -2343, -135, -1635, 172, 
    -915, 173, -1737, 542, -3772, 3598, 416, -269, 972, 473, -8513, 2675, -196, 1906, 1337, -2124, 
    -197, -2158, 2796, 598, -383, 3011, -291, -4635, -270, -588, 456, 623, -684, -1453, 749, -2239, 
    -476, -1792, 351, -512, -1393, 3419, 1559, 343, 1038, -1724, 578, 223, 529, -1274, -1929, -259, 
    2335, 421, 2121, -2012, 1799, 2208, 1175, -2769, 952, -1239, 517, 1813, 827, -652, 371, 281, 
    -1551, -1029, -1218, -2815, -1412, -486, -955, -747, -220, 1347, -1144, -60, -4232, 2296, 1646, -1319, 
    1219, -3638, -3808, -1543, -101, -411, -1724, -2531, -353, -763, -867, 290, -6, -965, -541, -2470, 
    -1414, 1328, 2150, 927, 422, 4037, 5793, -2090, -660, -2054, -1082, 483, -1609, -7870, -267, -568, 
    -355, 1081, 912, 545, -1735, 1522, -1105, -304, 294, 889, -459, -427, 1610, 1330, 1726, 114, 
    744, -707, -648, -546, -1021, -52, 302, 313, 107, -20, 1407, -475, -1120, 316, -877, -640, 
    -1026, 3399, 959, -1764, 315, 33, 1967, 103, -151, 220, 252, 127, -455, -3100, 608, 201, 
    -569, 1742, -440, 1643, 1418, -1444, -1340, -394, -675, -429, 1293, 888, 171, -4751, 765, 29, 
    2676, -2790, 685, 163, 1388, -149, 2034, 1138, -683, 115, -1081, -608, -338, 1947, -3073, -1584, 
    -1051, -2193, 90, 533, -678, -474, -671, 1348, 909, -1135, -289, 2760, -458, -1094, 140, -3668, 
    -49, -99, -1515, 3185, -891, -418, -2991, 2705, -65, 3767, -722, -2203, -2115, -3933, 1447, -1357, 
    -2391, -5613, -1310, 630, 460, -6263, 3975, -215, 3225, -1120, -617, 1001, 850, -5183, -1577, -4438, 
    -2119, 362, -193, 778, -579, -855, 51, 150, -647, -37, -870, 19, 941, -704, 402, -69, 
    -247, 636, -158, -962, 798, -343, -638, 1339, -1622, 2952, -3785, 1886, -1070, -13, -997, -557, 
    309, 3275, -972, 590, 590, -422, 1654, -1732, 292, -1495, 1553, 100, 235, -16, -2099, -903, 
    982, -288, 260, -1251, -296, 1154, -774, 482, 45, 403, 259, -44, -569, -3197, -592, 617, 
    196, 204, 659, -1914, -685, 157, 236, -523, 3089, 750, 1541, 2931, 66, 1254, 236, -824, 
    -605, -92, 173, -608, -297, 964, -2172, 311, 1895, -2849, 1275, -2739, -1905, -461, -4806, -174, 
    -656, -347, -885, -1369, 667, -538, 2101, 1638, -1641, 863, -2001, -76, -2004, -2976, -1813, 1578, 
    435, -1073, 1390, -1538, 330, 595, -15, 1878, 2279, 4351, 4033, -445, 4480, -2340, 1301, -1436, 
    452, -169, 2439, 423, -705, 195, -1036, 456, 95, 1312, 285, -139, 1749, 1545, 1694, -208, 
    141, -778, 1831, 2, -1186, 642, -848, 489, 130, -158, 53, 858, 733, 366, -1192, -15, 
    1152, -2219, -1962, -1305, 552, -1118, 1154, -116, -534, 733, -43, 1798, -155, 1650, -265, 856, 
    973, -416, 31, 1028, -599, 695, -555, 397, -1555, -155, 847, 89, 959, -282, 397, 547, 
    600, -664, 248, 39, -2, 72, 97, -358, 1167, -1106, 452, 211, -54, 424, 659, -626, 
    299, -1108, 1654, 417, -577, 814, 476, 168, -8, -627, -459, -269, 714, 1680, -35, -1381, 
    149, 335, 1700, 789, -455, 197, 1481, 706, -81, -3805, 1086, -1151, 811, 1092, -2979, 561, 
    -873, 1190, -761, -1428, 1576, 645, 1226, 792, -29, -535, -1071, 74, -231, 955, 525, 1287, 
    -1348, 120, -1744, 2370, 636, -1101, 1620, -2561, -702, 647, 1099, 791, 1160, 456, 1756, 199, 
    -5407, -1431, 1022, -13, 1422, 2529, 528, -1712, -1973, 1892, -10340, 1249, -1945, -2078, -310, 1563, 
    3145, 4047, 2363, 290, -2084, 1342, 1473, 528, -374, -230, -832, 335, 1342, 522, -907, 426, 
    1309, 733, -247, 519, -1249, -1357, -695, 770, -114, 984, 1132, 435, 1004, 270, -1039, -392, 
    -35, -3020, -1235, -4424, -1900, 1304, -1470, 2261, 2279, 288, 335, 1932, -879, -738, -297, 413, 
    -2107, -792, 292, -395, -4523, -1143, -2115, 279, -3265, -371, 3530, 193, 2479, -3895, -3898, 1663, 
    -458, 394, 719, 326, -2089, 283, 819, -546, -182, -1285, -1617, 229, 3066, -5343, 870, -179, 
    -410, -591, -2044, -239, -1665, 1232, 1087, 5, -628, 915, -69, 95, 4028, 991, 353, 460, 
    3082, -454, -843, -1730, -214, -1631, -1268, -4324, 1294, -527, -237, -1086, 1145, -708, 118, 203, 
    683, 1193, -1055, -867, -3211, 312, -2402, 2489, -1673, -1783, -1257, -1803, -1461, 2113, -1232, 1865, 
    -5245, -860, -641, -1063, 4521, -2225, -1588, -354, 825, -51, -1206, -256, 1851, -2745, 1252, 873, 
    -1325, -1404, -933, -791, 267, -950, -2083, 345, -51, 2613, 301, 1228, 988, -3680, -987, 725, 
    -2258, 908, -2815, -1865, -2520, 592, -4815, 2318, -112, 552, -2048, 1270, -679, -1328, -2507, 370, 
    3438, -2301, 1108, 917, 2390, 3420, 18, 1165, -3147, -2530, -648, 748, -1594, 535, -1050, -454, 
    -130, -5037, -147, -1784, -1606, 2888, 2877, -620, 2293, -805, 402, -2341, 1326, -4582, 2801, -708, 
    -113, 3929, 165, -744, -566, 4561, 1329, 2238, -2513, 1443, 703, -16, 1248, 2911, -761, -1325, 
    -1981, 908, -62, 1685, 4237, -9443, 5948, -1521, -1616, 1108, -55, -1052, 3500, -1261, 4509, -7776, 
    -4620, 700, -815, -3499, 2898, -5530, -6824, 1253, 53, 3655, -8865, 123, 4561, 1294, 2647, -3283, 
    -1635, 3437, -944, -2647, 3128, 3755, -7248, -6002, 602, 261, 995, 1610, -1504, 4590, 2326, 2153, 
    -37, 1530, 1223, -5815, 3016, -3642, 3229, 2572, 705, 862, 149, -269, -2704, 3738, 1778, 2, 
    718, 2232, -4068, 3841, -1339, -27, -5364, -1585, 1305, -1286, 318, 2521, 651, -723, -1259, -921, 
    -693, -5794, -2398, -4923, 4189, -2873, -1739, 2936, -195, 317, 3233, -3314, 2402, -1837, 2891, -1415, 
    2714, -1286, -5561, -1794, 1574, -607, -1750, 5695, 780, -3017, -2771, -1085, 58, 1453, 2322, 2199, 
    -326, -4265, 4019, 1664, 114, 1914, -3477, 1134, -5660, 3639, 7, -431, -540, 3235, 1284, -3319, 
    1924, 1936, -1330, -3216, 4765, 313, -267, 6622, 1118, 1548, -1136, -640, 4314, -879, -8, 3283, 
    -1364, -2494, -1998, 5574, -840, -5060, 27, -1463, -3150, -1113, -680, -1473, -3672, -607, -1529, -3330, 
    2038, 1638, 1712, -1077, -3184, -6450, 4129, -834, -64, -476, -2654, 1523, 761, -3110, 1823, -5858, 
    -587, -958, -2048, 558, 2001, 3753, -277, -5093, -494, 1024, 1933, 232, 703, -1019, -117, 162, 
    -8050, -1333, 540, -2637, -4582, 4711, -8529, 3594, -787, 76, -1884, 3650, 1599, -838, -3100, -697, 
    168, 2014, 3226, -3922, -148, -1992, -774, -4704, 1299, -3449, -104, -3623, -3942, 161, -2092, -4525, 
    -954, -744, -2891, -2961, -1345, 592, -8960, -4813, -1683, 252, -283, -4682, 853, -1853, -1100, -2132, 
    -4060, 2522, -2892, 573, 716, 1086, 1821, -3087, 1346, -2702, 605, 1355, -3101, 5834, -753, -3648, 
    1152, 16, 372, 315, -1704, 73, 1388, -882, -1585, 141, -36, -106, -2339, -816, -616, -979, 
    719, -786, 1399, -5262, -32, 2244, 391, 1033, -1179, 2583, -6541, 1439, 690, 13, 1272, 760, 
    992, 974, -1999, 200, -2022, 2426, 4515, -1352, 6, -2604, 903, -900, 1227, -970, 2744, -1948, 
    367, 1638, -504, -1622, -18, -1259, -272, -2505, 496, 962, 1010, 269, -2101, -1312, -925, 2848, 
    803, -611, -1359, -3757, -333, 71, 176, -49, -4306, 2252, -1953, -1257, -1721, 1306, -1613, 64, 
    -1081, -3477, -605, 595, 1044, 1920, 1416, -1001, 991, 5585, 197, -3387, -3368, 2650, -898, 591, 
    -1817, 1833, -3602, -1515, 1345, -512, -54, 2618, -3324, -2224, -5974, -362, -2191, -2450, -2456, -1768, 
    -1016, -753, 3458, -5075, 1788, -216, -325, -2274, -751, -4718, 4654, -1289, 1307, -1165, 771, 2981, 
    2355, -1047, -302, -858, 169, -1115, 1955, 1600, 214, 3019, 2213, -267, 2685, 1195, -241, 1634, 
    2226, 1995, -613, -7117, 1684, 618, -880, -2980, -2648, -1171, -1105, -975, 1503, -3793, -2291, -1160, 
    2633, 3605, -1284, 1255, -432, -2174, -256, 800, -3564, 1212, -2426, -2848, -2252, -1518, -2179, -1558, 
    2149, -370, -1046, 1382, 330, 65, -281, 863, -567, -811, 3, -2751, 1336, -3467, 862, -2250, 
    -2203, -792, -2324, -1024, 976, -760, 1371, -2143, -666, 983, 244, 848, 1762, -468, -1122, 594, 
    1521, 1827, 3035, 2654, 1174, 2525, -2177, -519, -2313, -504, 302, 2567, 1246, -296, -125, -1573, 
    76, -2529, 3356, 208, 995, 790, 863, 2546, -1623, 2180, 477, -3441, -610, -285, -3622, -191, 
    -1727, 244, -2294, -628, 1084, -219, 598, 1747, -204, 2999, 1271, -1290, 1254, 1072, 1468, 859, 
    -649, -3132, -1004, 905, -1394, -657, -1713, -1529, 1203, 342, 634, 174, 1632, -1701, 2522, -300, 
    2499, -106, 994, 1587, 460, -707, -786, -183, -2733, 1897, -4775, 687, 1670, 935, 2085, 1598, 
    2774, -2110, 2059, 1131, -210, 793, 359, -69, -16, -2838, -192, 195, 1109, 1323, -350, -1667, 
    -227, 737, -1607, 847, -424, 694, -503, 689, 1347, 712, 721, -41, 182, -1604, 407, 863, 
    -158, -690, -1720, -1282, 432, 249, 2022, 442, 934, 568, 818, 132, -2370, -1574, -507, -961, 
    392, 61, 301, 372, 1743, 820, 454, 1115, 1918, 168, -1079, 891, -2358, 3246, 234, 1893, 
    -862, -879, 115, 241, -512, -204, 209, -975, 702, 3158, 1389, 307, 1157, 260, -2595, -598, 
    -169, 924, -563, 67, -148, -1300, 58, 724, -108, -1067, 616, 409, 994, -390, -206, 388, 
    -2398, -311, 1106, -353, 1685, -2030, 1827, 462, -225, -422, 730, 340, 476, -436, -2301, 1291, 
    -466, -978, -1046, -648, 296, 1624, 1827, 1956, -1558, 630, -413, -1230, 2551, 1388, 1197, 926, 
    -1718, 462, 314, 73, 2127, -364, 197, -647, 1435, 450, -146, -10, 138, -1390, -502, -349, 
    -693, 877, -326, -1682, 1221, 616, -395, 886, 835, -1598, 601, 375, 1032, 808, -366, 570, 
    1469, 1426, 1424, -2892, -1740, 1063, 237, 2029, -3951, -1662, -3134, -507, -1590, -1768, 1908, 2816, 
    1435, -2702, 739, -265, 956, -86, -1164, -95, 281, -947, -794, -404, 3333, 1773, 438, 918, 
    -487, -668, -777, -1597, -557, 2596, 772, 645, 2337, 305, 1195, 1760, 2419, 612, 1772, 64, 
    -161, -623, 1299, -911, 539, 889, 342, 1791, -627, 2825, -1226, -333, 1161, -2794, 804, -120, 
    505, -1579, -603, 164, -2978, 1169, -1883, 607, 828, 110, 524, -475, -3244, -702, -865, 504, 
    -34, -1814, -34, -28, -52, 670, 234, 1146, -1899, 1935, -5797, 40, 514, -649, -119, -2533, 
    -1937, -2472, 547, 2067, -533, 42, -441, 398, 835, -355, -291, 109, -1021, 2261, 1024, -2001, 
    -438, 3103, -1293, -3292, 960, 606, 2160, 2045, 904, 19, 476, -729, -1571, -852, 461, -1356, 
    -7592, -823, -4107, -2065, -2193, 2514, 2496, 2447, -665, 223, 1300, 2429, -1324, 1793, -803, 9, 
    2257, -2038, 887, 1176, 638, 2936, -2163, -331, -2352, -420, -405, -1631, -846, 2930, -2112, -2207, 
    34, -1755, -420, 702, 69, -86, 2489, -1436, 1437, -380, 968, 1974, 999, 2450, 1056, -2337, 
    -1023, 1656, -701, 657, 2053, -2798, 1419, 459, 2234, -1085, -597, -9, 3682, -1177, 256, -1374, 
    -1043, 686, 1456, 594, -3483, -6, 3113, -474, -1471, 7, -176, -968, -1854, -799, -4350, 1939, 
    -343, 1960, -1481, 1293, 1050, 3641, 57, -3005, -3251, 8, 191, -805, 11, -1442, -928, 2440, 
    -2404, 1341, 921, 767, 180, 791, -535, -3783, 400, 985, -1584, -474, -364, -1088, 2272, -2057, 
    -39, -284, 459, 332, 319, -70, 206, -5102, -141, 797, 1611, -1918, 239, 254, 385, -441, 
    2102, 1762, 742, -1179, -2317, 1958, 326, -257, -6559, -927, -6020, 1017, -3023, 1023, 2726, 1229, 
    -1590, 2237, 1978, -678, -1278, 2476, 1306, 1825, 1316, -3150, -35, -1752, -1426, 1471, -1285, -3311, 
    -64, 2124, 1237, 1504, -688, 2992, -1541, 2197, -851, 1337, -1076, -1478, 201, 2755, 641, 549, 
    -3489, -609, 1980, -1381, 2084, 910, 598, -1729, -945, 5390, 1055, 421, -401, -5117, 1605, -3148, 
    631, 589, 653, -613, 2416, 1048, 768, 133, 288, -109, -273, 1517, -335, 207, 356, 706, 
    -520, 129, -915, -4501, 173, 830, -783, 332, -1815, 2002, -6801, 282, 1476, -1179, 1281, 1156, 
    -219, -612, -690, 96, -416, -1261, 3050, -18, -7, -1760, 540, -693, -768, 1120, 783, -430, 
    1713, -1743, -686, -555, -244, -1456, 872, -923, 496, 836, 878, 240, 637, -435, -291, -1174, 
    -973, -344, -664, -1645, -280, 991, -497, 980, 684, 526, 1351, -887, -2236, 528, -1242, 89, 
    -23, -189, -305, 419, -283, 703, -3136, 192, 1115, -1269, 1612, 3227, -1167, 904, -3759, 241, 
    -483, -1060, -387, 1951, -434, 1976, 1740, -699, -2662, 2970, -2547, 2374, -558, -2509, -995, -1862, 
    -975, 345, -763, -2651, 883, -770, 1149, 641, -180, -73, 1078, 1069, 957, 2839, 468, -2709, 
    -2800, -1072, -1703, -441, 624, 315, 920, 1242, 2400, 906, -2476, 1899, -151, -646, -404, 1155, 
    -414, -3007, -2133, -643, 1066, 577, -2545, 271, -1444, -3088, -570, -1189, 822, -687, -1599, 435, 
    -29, 1944, -76, -75, -564, -995, 2707, -2689, -2050, -611, 332, -698, 308, 167, 1388, -793, 
    586, -735, 122, 2660, -1410, -1502, 533, 1695, -1021, 2186, 59, -4108, 1748, 1470, 641, 1737, 
    144, 1208, 881, -1287, -547, 381, -672, -387, -980, 1256, 39, -1159, -2434, -1390, 1300, 1979, 
    2626, -1258, 4617, -1364, 88, -357, -1770, -407, -1349, 2776, -28, 130, 1892, -368, -1451, 1992, 
    167, 28, -3911, -1511, -157, -1071, 54, -932, -1328, -55, 17, 1053, -1310, 3646, -1054, 59, 
    -3119, 311, 80, -397, 1451, -1583, 639, 1509, -1634, 2978, 156, -1508, 180, -1345, 1097, 3377, 
};

static const int16_t fx2_paramModel3Alpha[16] = {
    258, 5105, -380, -2926, 790, -496, -237, 1508, 1452, 429, 97, 1818, -1436, 979, 2200, -326, 
};

static const int16_t fx2_paramModel4Bias[16] = {
    -3590, -2283, -1023, -820, -11300, -10303, -188, -1590, -1102, -5090, -1836, -5960, -4776, -1970, -946, -558, 
};

static const int16_t fx2_paramModel4Weights[2304] = {
    2118, 189, 380, -1102, 239, -727, -857, -167, -170, -190, -232, -1410, -249, -244, 62, 445, 
    -399, 1512, -2928, -362, -421, 2003, -1332, 1132, -1811, 76, -14558, 765, -1084, -941, -14384, -335, 
    247, 566, -744, -845, 148, -802, 763, 653, 199, -1254, -156, 141, -20, -622, -223, -48, 
    1022, 900, 253, -436, -1754, -610, 483, 215, -918, -1272, 685, -356, -1288, 1235, 168, -611, 
    975, 69, 36, 1172, -703, 287, -65, -1266, -938, -693, -100, 1536, -287, 107, 552, -337, 
    -454, -383, 2065, -796, -2724, -1833, -11455, -396, 875, -3616, -4745, 712, 1452, -1423, 1620, 340, 
    885, 487, 148, -344, 119, -1980, -82, 496, 74, 963, 1566, -830, -305, 676, -1040, -1212, 
    -607, 159, -747, -79, -992, -243, 148, -258, -2273, -1761, -2524, -2038, 1102, -706, -312, 91, 
    -680, 297, -1349, -666, 780, -155, 71, -450, -182, 438, 417, 1046, 146, 29, -446, -433, 
    -117, 2017, -2001, -20, -271, -727, -567, 113, -936, 1117, 135, 328, -920, 341, -4479, -798, 
    195, 37, -635, -559, -175, -75, 466, 588, 308, 168, -324, -756, -37, 632, -36, -1612, 
    -2339, -2047, 818, 117, -1332, -77, 35, -304, 74, 1221, 717, -298, 194, -972, 137, -428, 
    -1079, 278, -66, -2568, 1883, 370, 144, 144, -1690, 278, 249, -806, 1008, -278, 1703, 789, 
    200, -801, -28116, -303, -546, -1432, 44, -1101, -328, -1061, 271, 343, 4591, -7098, -13236, 1376, 
    -201, -832, -161, -704, -186, 107, -635, -467, -192, 802, -916, -361, -871, 540, 735, -1399, 
    444, -124, -444, 188, -680, 670, -347, 14, 711, -1948, 307, 391, 2613, 5003, 280, 942, 
    -18, 788, -106, 1017, 1088, -1194, 174, -812, 1287, -100, 234, -1081, -1345, -54, -60, -24, 
    -3616, 8452, -864, -895, -2900, 1624, 1272, 1402, 4371, -5308, 809, 2965, -656, -4387, -473, 565, 
    887, -2196, 913, 1893, -460, -2784, -413, 214, -905, -1258, 830, -7368, -427, 1129, 87, -4847, 
    -199, -1172, -307, 683, 563, 747, -192, 560, -2880, 2997, -2405, 393, -3454, -1810, 122, -22, 
    -2615, 198, -315, -452, -543, -894, -1165, -1816, -2913, 693, -98, -1967, 3424, 676, 1237, -1083, 
    2714, 612, 69, -653, -343, -4722, 685, -642, -3473, -5431, -201, -1428, -445, -297, -82, -1596, 
    910, 1815, 406, 1901, -164, -5748, 596, -2637, 391, 542, -1045, -1426, 236, 535, 123, 532, 
    1000, -1577, 1569, -1136, -95, -989, 181, 93, -2695, 131, 392, -391, 880, 1558, -650, 835, 
    -1156, 649, -725, -945, 3692, -272, 1003, 852, 620, -326, 0, 162, -649, 219, -266, -194, 
    -446, -2160, -974, 1426, -1123, -1329, 906, 330, -920, -2371, 281, 262, -2473, 2684, 233, -502, 
    -890, -2167, 383, -741, 304, -1132, -430, -1200, -120, -475, -690, -2420, -217, -114, -170, 1425, 
    -2602, 1043, -88, -372, -1256, 1185, 198, 849, -811, -406, 734, 86, -3224, 1061, -1147, -475, 
    295, -29, -147, 132, -1650, 337, -11, -155, 1276, 1153, 427, -645, 137, -591, -186, 2980, 
    88, -267, -808, -1462, 1384, 2028, -528, 277, -2940, -3364, -585, -1289, -4968, 1220, 682, -2036, 
    -264, 1703, -794, -924, -124, 814, 170, 1049, -137, 369, -34, 2136, -862, -814, -322, 239, 
    -1479, -31, 350, -105, -539, -131, 119, -212, -390, -592, -171, -109, 1985, 553, 257, -203, 
    111, 206, -116, -199, -536, -873, 2092, 642, -2325, -613, -148, -297, -2566, 57, 74, -265, 
    -1917, 140, -289, -713, 673, 1783, 13, 480, 1677, -3253, 129, 1762, -328, -1823, -242, -34, 
    -838, -1126, 449, -2395, 441, 201, -538, 1993, -39, -3227, -676, 1311, 388, 260, -550, -466, 
    -1519, 551, 172, -482, 3155, -418, 1034, 350, -3095, -1085, 1253, -116, -427, -745, 64, -190, 
    1366, 61, -312, 586, 1341, -526, -259, -712, -415, 723, -82, 623, 536, 295, 1089, -311, 
    -1137, -341, 855, 627, -260, -221, 198, 521, -990, -753, 10, -161, -1482, -330, -43, -437, 
    249, -1207, -84, -865, -323, -1558, -272, -1114, 255, 1005, 1054, -1304, -494, 258, -560, -888, 
    -1189, 157, -263, 276, 1153, 537, -656, 20, -1360, -1357, -48, 253, 1208, -307, 588, 122, 
    378, 255, 51, 657, -1428, -1333, -824, -589, 511, 220, -466, -764, 377, -88, -354, -809, 
    -131, 232, -427, 546, 133, 339, -282, 9, -337, 107, 229, 707, -972, -1249, -313, -962, 
    -550, -950, 394, 445, 420, 1198, 277, 1093, -148, -31, 96, -67, -94, -232, -327, -1719, 
    -543, -358, -688, 220, 1647, -863, 629, -479, -1376, 1044, -476, -26, -1175, 193, 450, -184, 
    -1528, 486, -464, -1149, 2221, 396, -473, -345, 1029, 731, -498, -577, -2141, -146, 104, -438, 
    -1969, -1884, -254, -2812, -199, 183, 10, -845, -936, 546, 131, 721, 309, 2096, 566, 268, 
    -305, -285, -359, -1280, -311, 505, 166, 505, 661, -1593, 624, -2166, -143, 1026, 87, -60, 
    -1268, -643, -399, 268, -650, 39, -315, -145, -1128, 1502, -302, 281, 787, 515, 1665, -400, 
    1445, 524, 483, -84, -356, 1425, -55, 80, -927, 421, 197, -171, -1114, -484, 457, 634, 
    -748, 905, 976, 1323, -289, -326, -205, -172, 228, 1230, 102, 88, -1118, -2125, -205, -686, 
    602, 1709, -59, 279, 428, 630, -1712, -1985, 598, -711, -58, -962, 11, 496, 239, -1420, 
    2580, 1516, 715, -688, -498, -323, 523, -725, 168, 396, -358, 47, -3755, 1749, -2065, 415, 
    242, -76, 1200, 1424, -253, -566, 809, 1924, -1680, 476, -528, -490, 850, -346, 197, 290, 
    989, -1348, 485, -145, -347, -2984, 716, -1688, 250, -82, 268, -1267, -3239, 2479, 89, 453, 
    940, -64, 546, 58, 900, -4476, -584, -4441, -10, 1413, -1386, 1952, 708, -2172, 607, -1472, 
    369, 1389, -1119, -684, 2566, 568, -772, -274, -2064, -759, 269, 164, -869, -315, 1070, 338, 
    -543, 1300, -2772, -115, 1469, -388, 322, -742, -1381, -775, 550, -931, -1475, -172, 834, -597, 
    -2866, 915, -525, 1790, -544, -109, 417, -1916, -13449, -587, 701, 426, 1442, -408, -115, 896, 
    883, -1928, 1106, -2240, -166, 226, 46, -507, 1872, -2487, 854, -2580, 144, 113, 657, 199, 
    -3113, -2313, 3073, -408, -834, 515, 78, 405, -1899, 815, 3673, -346, 5179, 429, -1190, -878, 
    1783, 221, 291, -170, 2358, -679, 582, 779, -1550, -633, -1644, -896, 1035, -805, 1447, 1203, 
    -2268, -3298, -1291, -232, 1106, 136, 93, 792, 1131, -68, -1325, -933, 3378, -1355, 765, -3343, 
    177, -903, -653, -2159, -60, 521, 569, 966, -1160, -1659, 452, 1780, 189, -2756, 137, 2186, 
    -2565, -1525, -112, -227, -1374, 1526, -313, -98, 1392, -4069, 258, -236, 114, 1897, 1188, 2006, 
    523, 2073, -109, -344, -797, 3317, -1005, -648, -86, 2171, -74, -85, -1166, -636, -270, -822, 
    -781, -2761, 933, 851, 2915, -424, 1218, -733, -16116, -7532, -275, 4737, -15092, -15199, -211, -2559, 
    -1924, 2808, -308, 364, 799, 3672, 435, 124, -82, -2270, 1164, -4418, 349, -4568, -2203, -1174, 
    -3705, 137, 160, 442, -3748, 117, -2362, 2439, 1389, -1342, 595, -414, -10594, -1569, -305, -842, 
    -690, -683, -264, -1228, -2506, -172, 126, -878, 2406, -1243, -860, 524, 4274, -522, 154, -885, 
    -4520, -1742, -1572, -1073, -2438, 3334, -1075, -625, 2511, -5142, 590, -1368, 2461, -2985, 544, 1699, 
    991, -846, -526, -769, -986, -8328, 559, -6574, -388, 948, 740, 738, -1715, 1082, 1206, 3487, 
    -4917, 227, 2409, -123, 1467, 289, 2296, -366, -7497, -5357, -1245, 187, 2937, 2517, -305, 2125, 
    -1350, -2200, -1213, 2286, 2364, 246, 2081, -172, -148, 1008, 732, 278, -1430, 1863, -547, -689, 
    3946, 3638, -375, -503, -4492, 2783, 1275, -296, 1944, -1695, -229, 258, -2806, -8351, 1402, 4721, 
    379, -643, -1971, -1185, 1084, -2015, -1395, 266, -1628, -4239, 157, -5927, -134, -2031, 1406, -8126, 
    4714, 323, -4537, 2601, -1288, 2396, 1210, 509, -8876, 102, 4686, -489, -8018, -352, 1071, -715, 
    -931, 791, 334, -768, -52, -793, -284, -922, -2028, -2303, 1184, 608, -3446, 833, -1713, 2556, 
    -4243, -2418, 785, 1473, -4048, -3971, 919, 2262, 6426, -3948, -706, 425, -11525, -3772, 361, 1723, 
    -185, -777, 383, -4549, -675, -1208, -56, -2094, -711, -2561, -1257, -6876, 208, -2149, -405, -3095, 
    -2149, 1805, -747, 641, 585, -457, 611, -70, -4198, -3934, 814, -782, 375, 513, 1570, 1868, 
    2656, 283, 93, 75, -557, 2137, 2018, 608, -492, 1673, -52, 185, -1298, -985, -184, -868, 
    -1305, -1060, -19, 1145, -142, 2636, -516, 478, -3558, 1558, -11, 1200, -1461, -7723, -178, -1433, 
    1104, 2913, 631, -777, -405, -219, 700, -2195, -648, 2089, -63, -2785, 38, -751, 89, -778, 
    -1526, 816, -11, 42, -604, -431, 2182, -437, 1763, 816, -806, -303, -7116, -2766, 532, 194, 
    2385, 214, -787, 855, -2064, 292, -1242, 415, 2324, -122, 697, -186, 1818, 724, 220, 1166, 
    -1309, 2808, 679, -1886, -4038, 775, 208, -827, -3309, -6348, -56, 465, -1908, -719, -516, -599, 
    1949, 434, 659, -3665, -1154, -1016, 17, -3109, 138, -197, -165, 3364, -795, -1985, 16, -3278, 
    -99, 1393, -517, 770, 1927, 390, -1310, -241, -8344, -913, -658, -294, -2355, -978, 629, -362, 
    793, -104, -44, 292, 1422, 1448, -2015, 542, 2156, 35, -1219, -138, -1230, -111, -1045, -779, 
    -3065, -2794, -485, 156, -4418, 1078, -963, -955, -1703, -2023, 309, -467, -1291, 945, 35, 551, 
    -359, -2566, -220, -2262, -683, -3025, 1152, -6140, 694, 431, 212, 586, -445, -47, -730, 219, 
    -2933, -98, -1024, -250, -4366, 237, 670, -368, 309, 862, -466, 440, 1018, 741, -656, -80, 
    -3008, -899, 534, 897, -1568, -442, 329, 46, -2037, -1361, -676, -47, -2772, 397, 505, -255, 
    1244, -2642, -236, 1787, 2265, 1698, 360, 631, -4464, 218, 319, 104, -937, 1505, 168, 517, 
    268, 1171, -1666, -354, -24, 1880, -340, 1892, 898, -1904, 417, 98, -1340, -341, -24, -1750, 
    -1222, -1251, 1016, -61, 1880, 804, -118, -271, 3082, 2033, -2351, 600, 120, 455, 1177, -371, 
    311, -453, 62, 162, -1146, -349, -196, 160, 2414, 550, 141, -61, 103, -117, -352, -536, 
    37, -570, -177, -574, 533, -280, 74, -674, -367, -308, 230, -93, -554, -1777, -79, 154, 
    -122, 498, 72, 985, 499, 157, 417, -376, 463, -313, -137, -389, -694, 1144, -1417, 223, 
    -478, -971, -256, 144, -231, -1303, -243, 103, -362, 1004, 422, -65, -2580, -41, -524, -566, 
    -147, -679, 58, -17, 397, -298, 398, 330, -1009, -722, -1048, -538, 249, 317, -24, -1216, 
    -438, -1819, -30, -636, -1199, -1266, -31, 172, -3469, -3102, -291, 298, -660, -735, -544, -730, 
    -145, -19, 260, 1168, 680, -1900, -437, -2545, 21, 157, 1209, -1477, -248, -72, 175, -1417, 
    -1102, -624, 174, -197, 1145, 265, -443, 546, -7082, -396, 221, -472, 607, -46, 197, 774, 
    -2341, -470, -655, 426, -11, 902, -451, 514, -1051, 1170, -76, -246, -666, -160, -224, 81, 
    508, 2062, -245, -98, -202, 796, -348, 2328, 1391, 3935, -91, 1125, -1049, -1388, -322, -279, 
    855, -1098, 10, -2704, -462, 979, -1118, -495, 1095, 1884, 19, 790, -256, -684, -485, 1803, 
    2289, -1263, 37, -535, -704, -1673, -116, 79, 3687, 544, 1478, 316, -1289, -162, -258, -168, 
    -4896, -760, -609, -876, 2873, -262, 168, 72, -787, 779, -358, -636, 62, 371, 231, -31, 
    -2134, -2030, -497, -770, -1328, 207, -130, 724, 127, 776, -366, 181, -2829, -790, -246, 1156, 
    430, -510, -828, -1007, -448, -1423, -360, 3111, 242, 701, 372, -533, -691, -671, -491, -764, 
    -170, -805, 2339, -1241, -1537, 947, -496, 866, 1450, 1095, 1296, -166, -379, 1076, 637, 1048, 
    615, -575, -64, 76, 1478, -2331, -109, -393, -3416, -186, 82, 216, -3268, -1900, 157, 26, 
    -64, 1172, -113, -535, -1087, -2918, 489, -1109, 1030, 2960, -124, -803, 678, -2341, -250, -1854, 
    -215, -482, -832, 1249, 985, -479, -929, -418, 31, -2, 213, -189, -719, -1237, -580, -579, 
    689, -517, -461, -7, -1026, 113, -455, -233, -676, -386, 94, -353, -5401, -653, -955, 68, 
    -2889, -732, -447, 343, -1473, 1427, -299, -355, 787, -598, 66, 1503, 4156, -1184, 717, 141, 
    81, 1141, -77, -651, -6882, -6715, 464, 769, -2799, -761, -106, 64, 1494, -938, -448, -2269, 
    1189, -736, 891, -2449, -1600, -47, 772, -1695, 273, 46, -1713, 1224, -1202, 176, -1175, 838, 
    1203, -520, 1181, -169, -46, -100, 133, 329, -6298, -139, -2184, -418, 1362, 884, -930, 149, 
    -1467, 707, -1040, -969, 3033, 1579, 1015, -1062, 57, 41, 149, 694, -799, 708, 3, 112, 
    -2514, -3390, 248, 84, -635, 748, 69, 1317, -731, -67, 68, 434, -280, 644, 230, -559, 
    -1134, 58, 110, -1902, 727, 1031, 931, -3531, 1511, 790, 420, -883, -222, -2400, 489, -322, 
    -5079, 34, -1181, -976, 2527, 672, 334, 513, 1848, 292, 313, -319, 738, -299, 110, -379, 
    1348, -226, -551, -555, -3086, -1449, -89, 8, 688, -298, 247, 688, -4456, 121, -65, 757, 
    -2822, -5351, 81, -930, 896, 3523, -500, -1399, -2473, -911, 98, 398, -2634, -1615, 296, -819, 
    -2506, -1306, -582, -1130, 465, -1845, -1020, 930, -1400, -1099, 777, 2263, -371, -145, 175, -1996, 
    -6660, 2108, -2411, 1472, -3021, -261, 409, -236, -189, -68, -1120, -703, -2475, 611, 330, -228, 
    977, -551, -112, -250, -1705, -1302, 415, -718, 229, 307, -193, -398, -1642, -939, 191, -364, 
    -1105, -873, -106, -963, 1024, -1334, -321, -505, -2074, -695, -110, -355, 251, -124, 175, -362, 
    164, -86, -162, 1115, -485, -729, 611, 1421, -248, -1309, 146, -2180, 124, 681, 105, -132, 
    -597, 191, 340, -116, 38, 380, 937, 561, -510, 518, -15, 255, -1009, -217, 103, 53, 
    2023, 62, -902, 1324, -1675, 269, -160, 784, -6951, -2473, 437, -1467, 3112, -927, -98, -346, 
    -3861, -5280, 787, 267, -3078, -1450, 227, 387, 1577, 270, -294, -3283, -813, -3048, -229, -358, 
    1462, -1016, 866, -2783, 242, -837, -1224, -2758, -819, 409, 1185, 4, -1110, 556, 154, 2131, 
    -3558, 910, -1033, -616, -1018, -1116, 62, -436, -3989, -1169, 1323, -268, 249, -679, -38, 34, 
    -554, -457, -275, -808, 80, 2585, -381, -5, 1088, 139, -242, -218, 958, 396, -114, -428, 
    805, -295, -219, 289, -2629, 1965, 775, 4695, 1097, 583, 204, 290, 282, 18, -102, -405, 
    185, -70, 398, 388, 186, 1166, -1985, -2210, 447, -184, -258, 442, -180, 1319, -52, 763, 
    -303, -805, -400, 425, 101, -1733, -1685, 271, -1133, 76, -467, -566, -403, 866, -314, -134, 
    -1283, -99, 821, -1018, 824, 8, -467, -9, 903, 883, -1, 340, -262, 679, -474, 524, 
    -133, -934, -191, -699, 1128, 2987, -65, 209, 834, 1441, 11, 528, -993, -728, -234, -214, 
    152, -1718, 361, 958, -1036, -1965, 92, -216, 1088, 408, -143, -1577, -390, -562, -287, -542, 
    -480, -1853, 1166, -806, 1374, 181, -565, 83, -578, 710, -414, 180, 733, -230, 331, -72, 
};

static const int16_t fx2_paramModel4Alpha[16] = {
    -546, -548, 1183, 667, 464, 438, 67, 1450, 917, 909, -119, 356, -513, 419, 1048, 1258, 
};

static const int16_t fx2_paramResidualBias[16] = {
    -360, -22, -223, -490, -51, 558, -42, -457, -397, -89, -376, -482, -203, -290, 62, -590, 
};

static const int16_t fx2_paramResidualWeights[256] = {
    123, -1743, 582, -8578, 777, -6517, -257, -65, -500, -607, -804, 387, 45, 689, 744, -990, 
    261, 392, -3298, -291, -167, -499, -2687, 651, -249, 57, 1005, -277, 38, 87, -1527, -115, 
    -132, -2330, -1247, 205, 188, 622, 282, -277, -151, 401, 853, -492, 539, -69, -428, 109, 
    -86, -156, 79, -178, -175, 405, -1132, -369, -456, 273, 1119, -1126, 27, 9, 192, -276, 
    398, 197, 270, -873, 3563, 2499, 495, 2934, 315, -2554, 864, 1391, 140, 99, 26, 445, 
    -176, -1254, 6681, 2345, -748, 1347, 5522, -1978, -168, -117, -986, 462, 4, -41, 253, 1, 
    -733, -1050, -264, 429, 3217, 1098, -2490, -715, 306, 553, 1039, 1233, 81, -1, -342, 924, 
    986, -1137, -3926, -951, -689, 5025, 4066, -58, 81, -1411, -1419, 513, -11, -1550, 45, -170, 
    -263, 1439, -293, -1027, -6565, 3507, 579, 1410, -118, -2421, 416, 1711, 3188, 1760, 819, -142, 
    327, -178, -1574, 240, 19, 969, 1068, -941, -624, -356, 733, 352, -1402, -4012, -1214, 2102, 
    1193, -2283, -361, -220, -17, 1334, -1590, -2848, 1462, -163, 608, 266, -237, 4293, -3300, -3278, 
    159, -322, -671, -2256, 174, 285, 1263, -221, 283, -8, -330, 440, 427, -1044, -1376, -4062, 
    -670, -3610, -262, 4516, 451, -1067, 696, 57, -175, -857, -359, -158, -800, 456, -196, -2750, 
    -240, -16, 1697, -7, -94, 114, -810, -33, -284, -64, 1158, -22, 878, -93, -2084, 297, 
    1125, -3539, -4571, -7338, 99, -141, 65, 309, -769, 2090, 187, 11, 481, -453, -310, -1069, 
    -542, 902, 569, -3974, 96, -31, -99, 107, -174, -59, 162, -376, 514, 210, -850, 1188, 
};

static const int16_t fx2_paramResidualAlpha[16] = {
    -520, 376, 4350, -104, 9051, 6980, 506, 8316, 577, -450, 1701, -806, 7132, 2942, 8107, 1085, 
};

static const int16_t fx2_paramSubConvolutionBias[4] = {
    1628, 1581, 1636, 1593, 
};

static const int16_t fx2_paramSubConvolutionWeights[576] = {
    -85, 4, -16, -30, -708, 609, 492, -227, -16, 119, 89, 34, -153, 69, 23, -59, 
    -153, 79, 56, 91, 253, -131, -239, -192, 555, -1161, 439, -212, -69, 48, 57, 9, 
    -46, -11, -22, -51, -81, -36, 9, -58, 10, -20, 7, -42, 105, -34, -45, 74, 
    1, -23, -75, 65, 177, -15, -285, -88, 78, -2, 106, 78, 664, -295, -117, -131, 
    234, 45, -208, -143, 2957, 1223, -309, 1231, 72, -1, 180, 5, 109, -446, 194, 243, 
    347, -385, -134, 242, 333, 473, -148, -359, -1170, 1801, -1021, -306, -51, -85, 24, 78, 
    -120, 238, -182, 113, -347, 299, -187, 159, -350, 279, 206, 179, 50, 316, 128, -78, 
    -62, -173, -180, -145, -71, 185, -381, -435, -109, -35, 99, 115, -470, 164, 8, 84, 
    9, 58, 2, -75, -461, 169, 155, -962, -7, -197, 22, 160, -3, 324, -76, -102, 
    -39, 230, -49, 9, -203, -4, -150, -239, 343, -280, 78, 148, 41, -20, 15, 59, 
    146, -314, 37, 171, 96, 109, 132, -29, 222, -304, 6, -28, -33, -147, 72, 134, 
    -4, 100, 18, -28, -30, -104, -96, -145, 137, 66, 54, 167, -74, 195, 5, 122, 
    -109, 13, 383, -48, -629, 2411, -2826, 2063, 63, 266, -39, 225, -135, -81, 284, 100, 
    305, -245, -46, -172, 367, -229, 449, -240, 828, -1611, 502, -2399, -107, 56, -91, 83, 
    190, -22, -45, -29, -104, -46, -126, -29, -77, 49, -69, 82, -89, 45, -50, -108, 
    -120, -23, -123, 142, -569, -66, 524, -63, 126, -37, 2, -14, -503, 459, 495, 18, 
    -657, -839, 123, 779, 859, 451, 2813, 720, 1974, -2354, 1485, -812, 515, 131, -581, 47, 
    413, -877, 1787, -1341, 2586, 3445, 1607, 3002, -1267, 1240, -1463, 1695, 4891, 4650, 5161, 4852, 
    -152, -372, 699, -185, -446, 489, -504, 520, 228, -450, -718, -89, 851, 180, -727, -469, 
    1219, 49, -1172, -2495, -1647, -2128, 2152, 2084, 1373, 1437, 1030, 698, 441, -192, -21, -338, 
    -57, 67, 7, -100, -1497, 1738, -1372, 1053, -295, 378, -216, -342, -83, 43, 96, -206, 
    436, -272, 199, 174, -741, 219, -408, 247, 751, -73, 529, -967, 136, -16, 63, -41, 
    -69, 382, -83, -367, 20, 88, -6, 213, 3, 445, 364, -169, -56, 411, 64, -110, 
    -68, -173, -40, -60, -120, -322, 28, 594, 678, -133, 438, -241, 52, -269, -155, -31, 
    111, 43, -259, 65, 113, -57, 172, 163, 51, 138, 24, 97, 62, 29, 13, 0, 
    -141, -22, -34, -196, -157, -84, 178, -53, -627, -550, -124, -817, 47, 2, -69, 15, 
    -78, -113, 133, -53, 48, -106, -27, -76, 64, 94, -16, -79, -68, 8, 64, -36, 
    166, 80, 47, 133, 189, 49, 176, 22, 65, 20, 60, 50, 29, -85, -296, 125, 
    38, 328, 481, -214, -246, -129, 911, -267, -219, -204, 865, -927, -108, 91, -33, -194, 
    -122, -69, -197, 406, -207, -421, 714, 507, -1179, -656, 64, 2361, 47, 102, -102, -103, 
    -12, 148, -412, 285, -180, 133, -216, 216, -97, -114, 243, -94, -148, -197, -62, 193, 
    328, 261, -277, -336, 372, 323, -331, -0, 234, 280, -503, -189, -139, 119, -4, 243, 
    20, -101, -31, 275, -82, -522, -604, 439, -170, -42, -293, 440, -149, -194, 152, 134, 
    39, 34, 185, -144, -123, -164, -367, -8, -130, -633, 128, -103, -6, 20, 66, -9, 
    48, -138, -3, 59, 109, -49, 131, 16, -23, -37, -100, 205, 54, 15, -117, -277, 
    19, 220, 190, -15, 69, 191, 34, -208, 34, 163, 304, 8, 50, -31, 59, -163, 
};

