// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// Use ../scripts/gen_autohint_scripts.py to regenerate.

#[rustfmt::skip]
pub(super) const SCRIPT_CLASSES: &[ScriptClass] = &[
    ScriptClass {
        name: "Adlam",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Adlm"),
        hint_top_to_bottom: false,
        std_chars: "𞤌 𞤮",
        blues: &[
            ("𞤌 𞤅 𞤈 𞤏 𞤔 𞤚", BlueZones::TOP),
            ("𞤂 𞤖", BlueZones::NONE),
            ("𞤬 𞤮 𞤻 𞤼 𞤾", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("𞤤 𞤨 𞤩 𞤭 𞤴 𞤸 𞤺 𞥀", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Arabic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Arab"),
        hint_top_to_bottom: false,
        std_chars: "ل ح ـ",
        blues: &[
            ("ا إ ل ك ط ظ", BlueZones::TOP),
            ("ت ث ط ظ ك", BlueZones::NONE),
            ("ـ", BlueZones::NEUTRAL),
        ],
    },
    ScriptClass {
        name: "Armenian",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Armn"),
        hint_top_to_bottom: false,
        std_chars: "ս Ս",
        blues: &[
            ("Ա Մ Ւ Ս Բ Գ Դ Օ", BlueZones::TOP),
            ("Ւ Ո Դ Ճ Շ Ս Տ Օ", BlueZones::NONE),
            ("ե է ի մ վ ֆ ճ", BlueZones::TOP),
            ("ա յ ւ ս գ շ ր օ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("հ ո ճ ա ե ծ ս օ", BlueZones::NONE),
            ("բ ը ի լ ղ պ փ ց", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Avestan",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Avst"),
        hint_top_to_bottom: false,
        std_chars: "𐬚",
        blues: &[
            ("𐬀 𐬁 𐬐 𐬛", BlueZones::TOP),
            ("𐬀 𐬁", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Bamum",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Bamu"),
        hint_top_to_bottom: false,
        std_chars: "ꛁ ꛯ",
        blues: &[
            ("ꚧ ꚨ ꛛ ꛉ ꛁ ꛈ ꛫ ꛯ", BlueZones::TOP),
            ("ꚭ ꚳ ꚶ ꛬ ꚢ ꚽ ꛯ ꛲", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Bengali",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Beng"),
        hint_top_to_bottom: true,
        std_chars: "০ ৪",
        blues: &[
            ("ই ট ঠ ি ী ৈ ৗ", BlueZones::TOP),
            ("ও এ ড ত ন ব ল ক", BlueZones::TOP),
            ("অ ড ত ন ব ভ ল ক", BlueZones::TOP.union(BlueZones::NEUTRAL).union(BlueZones::X_HEIGHT)),
            ("অ ড ত ন ব ভ ল ক", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Buhid",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Buhd"),
        hint_top_to_bottom: false,
        std_chars: "ᝋ ᝏ",
        blues: &[
            ("ᝐ ᝈ", BlueZones::TOP),
            ("ᝅ ᝊ ᝎ", BlueZones::TOP),
            ("ᝂ ᝃ ᝉ ᝌ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ᝀ ᝃ ᝆ ᝉ ᝋ ᝏ ᝑ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Chakma",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cakm"),
        hint_top_to_bottom: false,
        std_chars: "𑄤 𑄉 𑄛",
        blues: &[
            ("𑄃 𑄅 𑄉 𑄙 𑄗", BlueZones::TOP),
            ("𑄅 𑄛 𑄝 𑄗 𑄓", BlueZones::NONE),
            ("𑄖𑄳𑄢 𑄘𑄳𑄢 𑄙𑄳𑄢 𑄤𑄳𑄢 𑄥𑄳𑄢", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Canadian Syllabics",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cans"),
        hint_top_to_bottom: false,
        std_chars: "ᑌ ᓚ",
        blues: &[
            ("ᗜ ᖴ ᐁ ᒣ ᑫ ᑎ ᔑ ᗰ", BlueZones::TOP),
            ("ᗶ ᖵ ᒧ ᐃ ᑌ ᒍ ᔑ ᗢ", BlueZones::NONE),
            ("ᓓ ᓕ ᓀ ᓂ ᓄ ᕄ ᕆ ᘣ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ᕃ ᓂ ᓀ ᕂ ᓗ ᓚ ᕆ ᘣ", BlueZones::NONE),
            ("ᐪ ᙆ ᣘ ᐢ ᒾ ᣗ ᔆ", BlueZones::TOP),
            ("ᙆ ᗮ ᒻ ᐞ ᔆ ᒡ ᒢ ᓑ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Carian",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cari"),
        hint_top_to_bottom: false,
        std_chars: "𐊫 𐋉",
        blues: &[
            ("𐊧 𐊫 𐊬 𐊭 𐊱 𐊺 𐊼 𐊿", BlueZones::TOP),
            ("𐊣 𐊧 𐊷 𐋀 𐊫 𐊸 𐋉", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Cherokee",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cher"),
        hint_top_to_bottom: false,
        std_chars: "Ꭴ Ꮕ ꮕ",
        blues: &[
            ("Ꮖ Ꮋ Ꭼ Ꮓ Ꭴ Ꮳ Ꭶ Ꮥ", BlueZones::TOP),
            ("Ꮖ Ꮋ Ꭼ Ꮓ Ꭴ Ꮳ Ꭶ Ꮥ", BlueZones::NONE),
            ("ꮒ ꮤ ꮶ ꭴ ꭾ ꮗ ꮝ ꮿ", BlueZones::TOP),
            ("ꮖ ꭼ ꮓ ꮠ ꮳ ꭶ ꮥ ꮻ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ꮖ ꭼ ꮓ ꮠ ꮳ ꭶ ꮥ ꮻ", BlueZones::NONE),
            ("ᏸ ꮐ ꭹ ꭻ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Coptic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Copt"),
        hint_top_to_bottom: false,
        std_chars: "Ⲟ ⲟ",
        blues: &[
            ("Ⲍ Ⲏ Ⲡ Ⳟ Ⲟ Ⲑ Ⲥ Ⳋ", BlueZones::TOP),
            ("Ⳑ Ⳙ Ⳟ Ⲏ Ⲟ Ⲑ Ⳝ Ⲱ", BlueZones::NONE),
            ("ⲍ ⲏ ⲡ ⳟ ⲟ ⲑ ⲥ ⳋ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ⳑ ⳙ ⳟ ⲏ ⲟ ⲑ ⳝ Ⳓ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Cypriot",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cprt"),
        hint_top_to_bottom: false,
        std_chars: "𐠅 𐠣",
        blues: &[
            ("𐠍 𐠙 𐠳 𐠱 𐠅 𐠓 𐠣 𐠦", BlueZones::TOP),
            ("𐠃 𐠊 𐠛 𐠣 𐠳 𐠵 𐠐", BlueZones::NONE),
            ("𐠈 𐠏 𐠖", BlueZones::TOP),
            ("𐠈 𐠏 𐠖", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Cyrillic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Cyrl"),
        hint_top_to_bottom: false,
        std_chars: "о О",
        blues: &[
            ("Б В Е П З О С Э", BlueZones::TOP),
            ("Б В Е Ш З О С Э", BlueZones::NONE),
            ("х п н ш е з о с", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("х п н ш е з о с", BlueZones::NONE),
            ("р у ф", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Devanagari",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Deva"),
        hint_top_to_bottom: true,
        std_chars: "ठ व ट",
        blues: &[
            ("ई ऐ ओ औ ि ी ो ौ", BlueZones::TOP),
            ("क म अ आ थ ध भ श", BlueZones::TOP),
            ("क न म उ छ ट ठ ड", BlueZones::TOP.union(BlueZones::NEUTRAL).union(BlueZones::X_HEIGHT)),
            ("क न म उ छ ट ठ ड", BlueZones::NONE),
            ("ु ृ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Deseret",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Dsrt"),
        hint_top_to_bottom: false,
        std_chars: "𐐄 𐐬",
        blues: &[
            ("𐐂 𐐄 𐐋 𐐗 𐐑", BlueZones::TOP),
            ("𐐀 𐐂 𐐄 𐐗 𐐛", BlueZones::NONE),
            ("𐐪 𐐬 𐐳 𐐿 𐐹", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("𐐨 𐐪 𐐬 𐐿 𐑃", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Ethiopic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Ethi"),
        hint_top_to_bottom: false,
        std_chars: "ዐ",
        blues: &[
            ("ሀ ሃ ዘ ፐ ማ በ ዋ ዐ", BlueZones::TOP),
            ("ለ ሐ በ ዘ ሀ ሪ ዐ ጨ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Georgian (Mkhedruli)",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Geor"),
        hint_top_to_bottom: false,
        std_chars: "ი ე ა Ჿ",
        blues: &[
            ("გ დ ე ვ თ ი ო ღ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ა ზ მ ს შ ძ ხ პ", BlueZones::NONE),
            ("ს ხ ქ ზ მ შ ჩ წ", BlueZones::TOP),
            ("ე ვ ჟ ტ უ ფ ქ ყ", BlueZones::NONE),
            ("Ნ Ჟ Ჳ Ჸ Გ Ე Ო Ჴ", BlueZones::TOP),
            ("Ი Ჲ Ო Ჩ Მ Შ Ჯ Ჽ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Georgian (Khutsuri)",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Geok"),
        hint_top_to_bottom: false,
        std_chars: "Ⴖ Ⴑ ⴙ",
        blues: &[
            ("Ⴑ Ⴇ Ⴙ Ⴜ Ⴄ Ⴅ Ⴓ Ⴚ", BlueZones::TOP),
            ("Ⴄ Ⴅ Ⴇ Ⴈ Ⴆ Ⴑ Ⴊ Ⴋ", BlueZones::NONE),
            ("ⴁ ⴗ ⴂ ⴄ ⴅ ⴇ ⴔ ⴖ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ⴈ ⴌ ⴖ ⴎ ⴃ ⴆ ⴋ ⴢ", BlueZones::NONE),
            ("ⴐ ⴑ ⴓ ⴕ ⴙ ⴛ ⴡ ⴣ", BlueZones::TOP),
            ("ⴄ ⴅ ⴔ ⴕ ⴁ ⴂ ⴘ ⴝ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Glagolitic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Glag"),
        hint_top_to_bottom: false,
        std_chars: "Ⱅ ⱅ",
        blues: &[
            ("Ⰵ Ⱄ Ⱚ Ⰴ Ⰲ Ⰺ Ⱛ Ⰻ", BlueZones::TOP),
            ("Ⰵ Ⰴ Ⰲ Ⱚ Ⱎ Ⱑ Ⰺ Ⱄ", BlueZones::NONE),
            ("ⰵ ⱄ ⱚ ⰴ ⰲ ⰺ ⱛ ⰻ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ⰵ ⰴ ⰲ ⱚ ⱎ ⱑ ⰺ ⱄ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Gothic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Goth"),
        hint_top_to_bottom: true,
        std_chars: "𐌴 𐌾 𐍃",
        blues: &[
            ("𐌲 𐌶 𐍀 𐍄 𐌴 𐍃 𐍈 𐌾", BlueZones::TOP),
            ("𐌶 𐌴 𐍃 𐍈", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Greek",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Grek"),
        hint_top_to_bottom: false,
        std_chars: "ο Ο",
        blues: &[
            ("Γ Β Ε Ζ Θ Ο Ω", BlueZones::TOP),
            ("Β Δ Ζ Ξ Θ Ο", BlueZones::NONE),
            ("β θ δ ζ λ ξ", BlueZones::TOP),
            ("α ε ι ο π σ τ ω", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("α ε ι ο π σ τ ω", BlueZones::NONE),
            ("β γ η μ ρ φ χ ψ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Gujarati",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Gujr"),
        hint_top_to_bottom: false,
        std_chars: "ટ ૦",
        blues: &[
            ("ત ન ઋ ઌ છ ટ ર ૦", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ખ ગ ઘ ઞ ઇ ઈ ઠ જ", BlueZones::NONE),
            ("ઈ ઊ િ ી લી શ્ચિ જિ સી", BlueZones::TOP),
            ("ુ ૃ ૄ ખુ છૃ છૄ", BlueZones::NONE),
            ("૦ ૧ ૨ ૩ ૭", BlueZones::TOP),
        ],
    },
    ScriptClass {
        name: "Gurmukhi",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Guru"),
        hint_top_to_bottom: true,
        std_chars: "ਠ ਰ ੦",
        blues: &[
            ("ਇ ਈ ਉ ਏ ਓ ੳ ਿ ੀ", BlueZones::TOP),
            ("ਕ ਗ ਙ ਚ ਜ ਤ ਧ ਸ", BlueZones::TOP),
            ("ਕ ਗ ਙ ਚ ਜ ਤ ਧ ਸ", BlueZones::TOP.union(BlueZones::NEUTRAL).union(BlueZones::X_HEIGHT)),
            ("ਅ ਏ ਓ ਗ ਜ ਠ ਰ ਸ", BlueZones::NONE),
            ("੦ ੧ ੨ ੩ ੭", BlueZones::TOP),
        ],
    },
    ScriptClass {
        name: "Hebrew",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Hebr"),
        hint_top_to_bottom: false,
        std_chars: "ם",
        blues: &[
            ("ב ד ה ח ך כ ם ס", BlueZones::TOP.union(BlueZones::LONG)),
            ("ב ט כ ם ס צ", BlueZones::NONE),
            ("ק ך ן ף ץ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Kayah Li",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Kali"),
        hint_top_to_bottom: false,
        std_chars: "ꤍ ꤀",
        blues: &[
            ("꤅ ꤏ ꤁ ꤋ ꤀ ꤍ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("꤈ ꤘ ꤀ ꤍ ꤢ", BlueZones::NONE),
            ("ꤖ ꤡ", BlueZones::TOP),
            ("ꤑ ꤜ ꤞ", BlueZones::NONE),
            ("ꤑ꤬ ꤜ꤭ ꤔ꤬", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Khmer",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Khmr"),
        hint_top_to_bottom: false,
        std_chars: "០",
        blues: &[
            ("ខ ទ ន ឧ ឩ ា", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ក្ក ក្ខ ក្គ ក្ថ", BlueZones::SUB_TOP),
            ("ខ ឃ ច ឋ ប ម យ ឲ", BlueZones::NONE),
            ("ត្រ រៀ ឲ្យ អឿ", BlueZones::NONE),
            ("ន្ត្រៃ ង្ខ្យ ក្បៀ ច្រៀ ន្តឿ ល្បឿ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Khmer Symbols",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Khms"),
        hint_top_to_bottom: false,
        std_chars: "᧡ ᧪",
        blues: &[
            ("᧠ ᧡", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("᧶ ᧹", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Kannada",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Knda"),
        hint_top_to_bottom: false,
        std_chars: "೦ ಬ",
        blues: &[
            ("ಇ ಊ ಐ ಣ ಸಾ ನಾ ದಾ ರಾ", BlueZones::TOP),
            ("ಅ ಉ ಎ ಲ ೦ ೨ ೬ ೭", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Lao",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Laoo"),
        hint_top_to_bottom: false,
        std_chars: "໐",
        blues: &[
            ("າ ດ ອ ມ ລ ວ ຣ ງ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("າ ອ ບ ຍ ຣ ຮ ວ ຢ", BlueZones::NONE),
            ("ປ ຢ ຟ ຝ", BlueZones::TOP),
            ("ໂ ໄ ໃ", BlueZones::TOP),
            ("ງ ຊ ຖ ຽ ໆ ຯ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Latin",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Latn"),
        hint_top_to_bottom: false,
        std_chars: "o O 0",
        blues: &[
            ("T H E Z O C Q S", BlueZones::TOP),
            ("H E Z L O C U S", BlueZones::NONE),
            ("f i j k d b h", BlueZones::TOP),
            ("u v x z o e s c", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("n r x z o e s c", BlueZones::NONE),
            ("p q g j y", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Latin Subscript Fallback",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Latb"),
        hint_top_to_bottom: false,
        std_chars: "ₒ ₀",
        blues: &[
            ("₀ ₃ ₅ ₇ ₈", BlueZones::TOP),
            ("₀ ₁ ₂ ₃ ₈", BlueZones::NONE),
            ("ᵢ ⱼ ₕ ₖ ₗ", BlueZones::TOP),
            ("ₐ ₑ ₒ ₓ ₙ ₛ ᵥ ᵤ ᵣ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ₐ ₑ ₒ ₓ ₙ ₛ ᵥ ᵤ ᵣ", BlueZones::NONE),
            ("ᵦ ᵧ ᵨ ᵩ ₚ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Latin Superscript Fallback",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Latp"),
        hint_top_to_bottom: false,
        std_chars: "ᵒ ᴼ ⁰",
        blues: &[
            ("⁰ ³ ⁵ ⁷ ᵀ ᴴ ᴱ ᴼ", BlueZones::TOP),
            ("⁰ ¹ ² ³ ᴱ ᴸ ᴼ ᵁ", BlueZones::NONE),
            ("ᵇ ᵈ ᵏ ʰ ʲ ᶠ ⁱ", BlueZones::TOP),
            ("ᵉ ᵒ ʳ ˢ ˣ ᶜ ᶻ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ᵉ ᵒ ʳ ˢ ˣ ᶜ ᶻ", BlueZones::NONE),
            ("ᵖ ʸ ᵍ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Lisu",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Lisu"),
        hint_top_to_bottom: false,
        std_chars: "ꓳ",
        blues: &[
            ("ꓡ ꓧ ꓱ ꓶ ꓩ ꓚ ꓵ ꓳ", BlueZones::TOP),
            ("ꓕ ꓜ ꓞ ꓡ ꓛ ꓢ ꓳ ꓴ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Malayalam",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Mlym"),
        hint_top_to_bottom: false,
        std_chars: "ഠ റ",
        blues: &[
            ("ഒ ട ഠ റ ച പ ച്ച പ്പ", BlueZones::TOP),
            ("ട ഠ ധ ശ ഘ ച ഥ ല", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Medefaidrin",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Medf"),
        hint_top_to_bottom: false,
        std_chars: "𖹡 𖹛 𖹯",
        blues: &[
            ("𖹀 𖹁 𖹂 𖹃 𖹏 𖹚 𖹟", BlueZones::TOP),
            ("𖹀 𖹁 𖹂 𖹃 𖹏 𖹚 𖹒 𖹓", BlueZones::NONE),
            ("𖹤 𖹬 𖹧 𖹴 𖹶 𖹾", BlueZones::TOP),
            ("𖹠 𖹡 𖹢 𖹹 𖹳 𖹮", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("𖹠 𖹡 𖹢 𖹳 𖹭 𖹽", BlueZones::NONE),
            ("𖹥 𖹨 𖹩", BlueZones::NONE),
            ("𖺀 𖺅 𖺈 𖺄 𖺍", BlueZones::TOP),
        ],
    },
    ScriptClass {
        name: "Mongolian",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Mong"),
        hint_top_to_bottom: true,
        std_chars: "ᡂ ᠪ",
        blues: &[
            ("ᠳ ᠴ ᠶ ᠽ ᡂ ᡊ ‍ᡡ‍ ‍ᡳ‍", BlueZones::TOP),
            ("ᡃ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Myanmar",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Mymr"),
        hint_top_to_bottom: false,
        std_chars: "ဝ င ဂ",
        blues: &[
            ("ခ ဂ င ဒ ဝ ၥ ၊ ။", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("င ဎ ဒ ပ ဗ ဝ ၊ ။", BlueZones::NONE),
            ("ဩ ြ ၍ ၏ ၆ ါ ိ", BlueZones::TOP),
            ("ဉ ည ဥ ဩ ဨ ၂ ၅ ၉", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "N'Ko",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Nkoo"),
        hint_top_to_bottom: false,
        std_chars: "ߋ ߀",
        blues: &[
            ("ߐ ߉ ߒ ߟ ߖ ߜ ߠ ߥ", BlueZones::TOP),
            ("߀ ߘ ߡ ߠ ߥ", BlueZones::NONE),
            ("ߏ ߛ ߋ", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("ߎ ߏ ߛ ߋ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "no script",
        group: ScriptGroup::Default,
        tag: Tag::new(b"None"),
        hint_top_to_bottom: false,
        std_chars: "",
        blues: &[],
    },
    ScriptClass {
        name: "Ol Chiki",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Olck"),
        hint_top_to_bottom: false,
        std_chars: "ᱛ",
        blues: &[
            ("ᱛ ᱜ ᱝ ᱡ ᱢ ᱥ", BlueZones::TOP),
            ("ᱛ ᱜ ᱝ ᱡ ᱢ ᱥ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Old Turkic",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Orkh"),
        hint_top_to_bottom: false,
        std_chars: "𐰗",
        blues: &[
            ("𐰗 𐰘 𐰧", BlueZones::TOP),
            ("𐰉 𐰗 𐰦 𐰧", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Osage",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Osge"),
        hint_top_to_bottom: false,
        std_chars: "𐓂 𐓪",
        blues: &[
            ("𐒾 𐓍 𐓒 𐓓 𐒻 𐓂 𐒵 𐓆", BlueZones::TOP),
            ("𐒰 𐓍 𐓂 𐒿 𐓎 𐒹", BlueZones::NONE),
            ("𐒼 𐒽 𐒾", BlueZones::NONE),
            ("𐓵 𐓶 𐓺 𐓻 𐓝 𐓣 𐓪 𐓮", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("𐓘 𐓚 𐓣 𐓵 𐓡 𐓧 𐓪 𐓶", BlueZones::NONE),
            ("𐓤 𐓦 𐓸 𐓹 𐓛", BlueZones::TOP),
            ("𐓤 𐓥 𐓦", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Osmanya",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Osma"),
        hint_top_to_bottom: false,
        std_chars: "𐒆 𐒠",
        blues: &[
            ("𐒆 𐒉 𐒐 𐒒 𐒘 𐒛 𐒠 𐒣", BlueZones::TOP),
            ("𐒀 𐒂 𐒆 𐒈 𐒊 𐒒 𐒠 𐒩", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Hanifi Rohingya",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Rohg"),
        hint_top_to_bottom: false,
        std_chars: "𐴰",
        blues: &[
            ("𐴃 𐴀 𐴆 𐴖 𐴕", BlueZones::TOP),
            ("𐴔 𐴖 𐴕 𐴑 𐴐", BlueZones::NONE),
            ("ـ", BlueZones::NEUTRAL),
        ],
    },
    ScriptClass {
        name: "Saurashtra",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Saur"),
        hint_top_to_bottom: false,
        std_chars: "ꢝ ꣐",
        blues: &[
            ("ꢜ ꢞ ꢳ ꢂ ꢖ ꢒ ꢝ ꢛ", BlueZones::TOP),
            ("ꢂ ꢨ ꢺ ꢤ ꢎ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Shavian",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Shaw"),
        hint_top_to_bottom: false,
        std_chars: "𐑴",
        blues: &[
            ("𐑕 𐑙", BlueZones::TOP),
            ("𐑔 𐑖 𐑗 𐑹 𐑻", BlueZones::NONE),
            ("𐑟 𐑣", BlueZones::NONE),
            ("𐑱 𐑲 𐑳 𐑴 𐑸 𐑺 𐑼", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("𐑴 𐑻 𐑹", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Sinhala",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Sinh"),
        hint_top_to_bottom: false,
        std_chars: "ට",
        blues: &[
            ("ඉ ක ඝ ඳ ප ය ල ෆ", BlueZones::TOP),
            ("එ ඔ ඝ ජ ට ථ ධ ර", BlueZones::NONE),
            ("ද ඳ උ ල තූ තු බු දු", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Sundanese",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Sund"),
        hint_top_to_bottom: false,
        std_chars: "᮰",
        blues: &[
            ("ᮋ ᮞ ᮮ ᮽ ᮰ ᮈ", BlueZones::TOP),
            ("ᮄ ᮔ ᮕ ᮗ ᮰ ᮆ ᮈ ᮉ", BlueZones::NONE),
            ("ᮼ ᳄", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Tamil",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Taml"),
        hint_top_to_bottom: false,
        std_chars: "௦",
        blues: &[
            ("உ ஒ ஓ ற ஈ க ங ச", BlueZones::TOP),
            ("க ச ல ஶ உ ங ட ப", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Tai Viet",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Tavt"),
        hint_top_to_bottom: false,
        std_chars: "ꪒ ꪫ",
        blues: &[
            ("ꪆ ꪔ ꪒ ꪖ ꪫ", BlueZones::TOP),
            ("ꪉ ꪫ ꪮ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Telugu",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Telu"),
        hint_top_to_bottom: false,
        std_chars: "౦ ౧",
        blues: &[
            ("ఇ ఌ ఙ ఞ ణ ఱ ౯", BlueZones::TOP),
            ("అ క చ ర ఽ ౨ ౬", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Tifinagh",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Tfng"),
        hint_top_to_bottom: false,
        std_chars: "ⵔ",
        blues: &[
            ("ⵔ ⵙ ⵛ ⵞ ⴵ ⴼ ⴹ ⵎ", BlueZones::TOP),
            ("ⵔ ⵙ ⵛ ⵞ ⴵ ⴼ ⴹ ⵎ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Thai",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Thai"),
        hint_top_to_bottom: false,
        std_chars: "า ๅ ๐",
        blues: &[
            ("บ เ แ อ ก า", BlueZones::TOP.union(BlueZones::X_HEIGHT)),
            ("บ ป ษ ฯ อ ย ฮ", BlueZones::NONE),
            ("ป ฝ ฟ", BlueZones::TOP),
            ("โ ใ ไ", BlueZones::TOP),
            ("ฎ ฏ ฤ ฦ", BlueZones::NONE),
            ("ญ ฐ", BlueZones::NONE),
            ("๐ ๑ ๓", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Vai",
        group: ScriptGroup::Default,
        tag: Tag::new(b"Vaii"),
        hint_top_to_bottom: false,
        std_chars: "ꘓ ꖜ ꖴ",
        blues: &[
            ("ꗍ ꘖ ꘙ ꘜ ꖜ ꖝ ꔅ ꕢ", BlueZones::TOP),
            ("ꗍ ꘖ ꘙ ꗞ ꔅ ꕢ ꖜ ꔆ", BlueZones::NONE),
        ],
    },
    ScriptClass {
        name: "Limbu",
        group: ScriptGroup::Indic,
        tag: Tag::new(b"Limb"),
        hint_top_to_bottom: false,
        std_chars: "o",
        blues: &[],
    },
    ScriptClass {
        name: "Oriya",
        group: ScriptGroup::Indic,
        tag: Tag::new(b"Orya"),
        hint_top_to_bottom: false,
        std_chars: "o",
        blues: &[],
    },
    ScriptClass {
        name: "Syloti Nagri",
        group: ScriptGroup::Indic,
        tag: Tag::new(b"Sylo"),
        hint_top_to_bottom: false,
        std_chars: "o",
        blues: &[],
    },
    ScriptClass {
        name: "Tibetan",
        group: ScriptGroup::Indic,
        tag: Tag::new(b"Tibt"),
        hint_top_to_bottom: false,
        std_chars: "o",
        blues: &[],
    },
    ScriptClass {
        name: "CJKV ideographs",
        group: ScriptGroup::Cjk,
        tag: Tag::new(b"Hani"),
        hint_top_to_bottom: false,
        std_chars: "田 囗",
        blues: &[
            ("他 们 你 來 們 到 和 地 对 對 就 席 我 时 時 會 来 為 能 舰 說 说 这 這 齊 | 军 同 已 愿 既 星 是 景 民 照 现 現 理 用 置 要 軍 那 配 里 開 雷 露 面 顾", BlueZones::TOP),
            ("个 为 人 他 以 们 你 來 個 們 到 和 大 对 對 就 我 时 時 有 来 為 要 說 说 | 主 些 因 它 想 意 理 生 當 看 着 置 者 自 著 裡 过 还 进 進 過 道 還 里 面", BlueZones::NONE),
            (" 些 们 你 來 們 到 和 地 她 将 將 就 年 得 情 最 样 樣 理 能 說 说 这 這 通 | 即 吗 吧 听 呢 品 响 嗎 师 師 收 断 斷 明 眼 間 间 际 陈 限 除 陳 随 際 隨", BlueZones::HORIZONTAL),
            ("事 前 學 将 將 情 想 或 政 斯 新 样 樣 民 沒 没 然 特 现 現 球 第 經 谁 起 | 例 別 别 制 动 動 吗 嗎 增 指 明 朝 期 构 物 确 种 調 调 費 费 那 都 間 间", BlueZones::HORIZONTAL.union(BlueZones::RIGHT)),
        ],
    },
];

#[allow(unused)]impl ScriptClass {
    pub const ADLM: usize = 0;
    pub const ARAB: usize = 1;
    pub const ARMN: usize = 2;
    pub const AVST: usize = 3;
    pub const BAMU: usize = 4;
    pub const BENG: usize = 5;
    pub const BUHD: usize = 6;
    pub const CAKM: usize = 7;
    pub const CANS: usize = 8;
    pub const CARI: usize = 9;
    pub const CHER: usize = 10;
    pub const COPT: usize = 11;
    pub const CPRT: usize = 12;
    pub const CYRL: usize = 13;
    pub const DEVA: usize = 14;
    pub const DSRT: usize = 15;
    pub const ETHI: usize = 16;
    pub const GEOR: usize = 17;
    pub const GEOK: usize = 18;
    pub const GLAG: usize = 19;
    pub const GOTH: usize = 20;
    pub const GREK: usize = 21;
    pub const GUJR: usize = 22;
    pub const GURU: usize = 23;
    pub const HEBR: usize = 24;
    pub const KALI: usize = 25;
    pub const KHMR: usize = 26;
    pub const KHMS: usize = 27;
    pub const KNDA: usize = 28;
    pub const LAOO: usize = 29;
    pub const LATN: usize = 30;
    pub const LATB: usize = 31;
    pub const LATP: usize = 32;
    pub const LISU: usize = 33;
    pub const MLYM: usize = 34;
    pub const MEDF: usize = 35;
    pub const MONG: usize = 36;
    pub const MYMR: usize = 37;
    pub const NKOO: usize = 38;
    pub const NONE: usize = 39;
    pub const OLCK: usize = 40;
    pub const ORKH: usize = 41;
    pub const OSGE: usize = 42;
    pub const OSMA: usize = 43;
    pub const ROHG: usize = 44;
    pub const SAUR: usize = 45;
    pub const SHAW: usize = 46;
    pub const SINH: usize = 47;
    pub const SUND: usize = 48;
    pub const TAML: usize = 49;
    pub const TAVT: usize = 50;
    pub const TELU: usize = 51;
    pub const TFNG: usize = 52;
    pub const THAI: usize = 53;
    pub const VAII: usize = 54;
    pub const LIMB: usize = 55;
    pub const ORYA: usize = 56;
    pub const SYLO: usize = 57;
    pub const TIBT: usize = 58;
    pub const HANI: usize = 59;
}

#[rustfmt::skip]
pub(super) const STYLE_CLASSES: &[StyleClass] = &[
    StyleClass { name: "Adlam", index: 0, script: &SCRIPT_CLASSES[0], feature: None },
    StyleClass { name: "Arabic", index: 1, script: &SCRIPT_CLASSES[1], feature: None },
    StyleClass { name: "Armenian", index: 2, script: &SCRIPT_CLASSES[2], feature: None },
    StyleClass { name: "Avestan", index: 3, script: &SCRIPT_CLASSES[3], feature: None },
    StyleClass { name: "Bamum", index: 4, script: &SCRIPT_CLASSES[4], feature: None },
    StyleClass { name: "Bengali", index: 5, script: &SCRIPT_CLASSES[5], feature: None },
    StyleClass { name: "Buhid", index: 6, script: &SCRIPT_CLASSES[6], feature: None },
    StyleClass { name: "Chakma", index: 7, script: &SCRIPT_CLASSES[7], feature: None },
    StyleClass { name: "Canadian Syllabics", index: 8, script: &SCRIPT_CLASSES[8], feature: None },
    StyleClass { name: "Carian", index: 9, script: &SCRIPT_CLASSES[9], feature: None },
    StyleClass { name: "Cherokee", index: 10, script: &SCRIPT_CLASSES[10], feature: None },
    StyleClass { name: "Coptic", index: 11, script: &SCRIPT_CLASSES[11], feature: None },
    StyleClass { name: "Cypriot", index: 12, script: &SCRIPT_CLASSES[12], feature: None },
    StyleClass { name: "Cyrillic petite capitals from capitals", index: 13, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"c2cp")) },
    StyleClass { name: "Cyrillic small capitals from capitals", index: 14, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"c2sc")) },
    StyleClass { name: "Cyrillic ordinals", index: 15, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"ordn")) },
    StyleClass { name: "Cyrillic petite capitals", index: 16, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"pcap")) },
    StyleClass { name: "Cyrillic ruby", index: 17, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"ruby")) },
    StyleClass { name: "Cyrillic scientific inferiors", index: 18, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"sinf")) },
    StyleClass { name: "Cyrillic small capitals", index: 19, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"smcp")) },
    StyleClass { name: "Cyrillic subscript", index: 20, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"subs")) },
    StyleClass { name: "Cyrillic superscript", index: 21, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"sups")) },
    StyleClass { name: "Cyrillic titling", index: 22, script: &SCRIPT_CLASSES[13], feature: Some(Tag::new(b"titl")) },
    StyleClass { name: "Cyrillic", index: 23, script: &SCRIPT_CLASSES[13], feature: None },
    StyleClass { name: "Devanagari", index: 24, script: &SCRIPT_CLASSES[14], feature: None },
    StyleClass { name: "Deseret", index: 25, script: &SCRIPT_CLASSES[15], feature: None },
    StyleClass { name: "Ethiopic", index: 26, script: &SCRIPT_CLASSES[16], feature: None },
    StyleClass { name: "Georgian (Mkhedruli)", index: 27, script: &SCRIPT_CLASSES[17], feature: None },
    StyleClass { name: "Georgian (Khutsuri)", index: 28, script: &SCRIPT_CLASSES[18], feature: None },
    StyleClass { name: "Glagolitic", index: 29, script: &SCRIPT_CLASSES[19], feature: None },
    StyleClass { name: "Gothic", index: 30, script: &SCRIPT_CLASSES[20], feature: None },
    StyleClass { name: "Greek petite capitals from capitals", index: 31, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"c2cp")) },
    StyleClass { name: "Greek small capitals from capitals", index: 32, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"c2sc")) },
    StyleClass { name: "Greek ordinals", index: 33, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"ordn")) },
    StyleClass { name: "Greek petite capitals", index: 34, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"pcap")) },
    StyleClass { name: "Greek ruby", index: 35, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"ruby")) },
    StyleClass { name: "Greek scientific inferiors", index: 36, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"sinf")) },
    StyleClass { name: "Greek small capitals", index: 37, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"smcp")) },
    StyleClass { name: "Greek subscript", index: 38, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"subs")) },
    StyleClass { name: "Greek superscript", index: 39, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"sups")) },
    StyleClass { name: "Greek titling", index: 40, script: &SCRIPT_CLASSES[21], feature: Some(Tag::new(b"titl")) },
    StyleClass { name: "Greek", index: 41, script: &SCRIPT_CLASSES[21], feature: None },
    StyleClass { name: "Gujarati", index: 42, script: &SCRIPT_CLASSES[22], feature: None },
    StyleClass { name: "Gurmukhi", index: 43, script: &SCRIPT_CLASSES[23], feature: None },
    StyleClass { name: "Hebrew", index: 44, script: &SCRIPT_CLASSES[24], feature: None },
    StyleClass { name: "Kayah Li", index: 45, script: &SCRIPT_CLASSES[25], feature: None },
    StyleClass { name: "Khmer", index: 46, script: &SCRIPT_CLASSES[26], feature: None },
    StyleClass { name: "Khmer Symbols", index: 47, script: &SCRIPT_CLASSES[27], feature: None },
    StyleClass { name: "Kannada", index: 48, script: &SCRIPT_CLASSES[28], feature: None },
    StyleClass { name: "Lao", index: 49, script: &SCRIPT_CLASSES[29], feature: None },
    StyleClass { name: "Latin petite capitals from capitals", index: 50, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"c2cp")) },
    StyleClass { name: "Latin small capitals from capitals", index: 51, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"c2sc")) },
    StyleClass { name: "Latin ordinals", index: 52, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"ordn")) },
    StyleClass { name: "Latin petite capitals", index: 53, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"pcap")) },
    StyleClass { name: "Latin ruby", index: 54, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"ruby")) },
    StyleClass { name: "Latin scientific inferiors", index: 55, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"sinf")) },
    StyleClass { name: "Latin small capitals", index: 56, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"smcp")) },
    StyleClass { name: "Latin subscript", index: 57, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"subs")) },
    StyleClass { name: "Latin superscript", index: 58, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"sups")) },
    StyleClass { name: "Latin titling", index: 59, script: &SCRIPT_CLASSES[30], feature: Some(Tag::new(b"titl")) },
    StyleClass { name: "Latin", index: 60, script: &SCRIPT_CLASSES[30], feature: None },
    StyleClass { name: "Latin Subscript Fallback", index: 61, script: &SCRIPT_CLASSES[31], feature: None },
    StyleClass { name: "Latin Superscript Fallback", index: 62, script: &SCRIPT_CLASSES[32], feature: None },
    StyleClass { name: "Lisu", index: 63, script: &SCRIPT_CLASSES[33], feature: None },
    StyleClass { name: "Malayalam", index: 64, script: &SCRIPT_CLASSES[34], feature: None },
    StyleClass { name: "Medefaidrin", index: 65, script: &SCRIPT_CLASSES[35], feature: None },
    StyleClass { name: "Mongolian", index: 66, script: &SCRIPT_CLASSES[36], feature: None },
    StyleClass { name: "Myanmar", index: 67, script: &SCRIPT_CLASSES[37], feature: None },
    StyleClass { name: "N'Ko", index: 68, script: &SCRIPT_CLASSES[38], feature: None },
    StyleClass { name: "no script", index: 69, script: &SCRIPT_CLASSES[39], feature: None },
    StyleClass { name: "Ol Chiki", index: 70, script: &SCRIPT_CLASSES[40], feature: None },
    StyleClass { name: "Old Turkic", index: 71, script: &SCRIPT_CLASSES[41], feature: None },
    StyleClass { name: "Osage", index: 72, script: &SCRIPT_CLASSES[42], feature: None },
    StyleClass { name: "Osmanya", index: 73, script: &SCRIPT_CLASSES[43], feature: None },
    StyleClass { name: "Hanifi Rohingya", index: 74, script: &SCRIPT_CLASSES[44], feature: None },
    StyleClass { name: "Saurashtra", index: 75, script: &SCRIPT_CLASSES[45], feature: None },
    StyleClass { name: "Shavian", index: 76, script: &SCRIPT_CLASSES[46], feature: None },
    StyleClass { name: "Sinhala", index: 77, script: &SCRIPT_CLASSES[47], feature: None },
    StyleClass { name: "Sundanese", index: 78, script: &SCRIPT_CLASSES[48], feature: None },
    StyleClass { name: "Tamil", index: 79, script: &SCRIPT_CLASSES[49], feature: None },
    StyleClass { name: "Tai Viet", index: 80, script: &SCRIPT_CLASSES[50], feature: None },
    StyleClass { name: "Telugu", index: 81, script: &SCRIPT_CLASSES[51], feature: None },
    StyleClass { name: "Tifinagh", index: 82, script: &SCRIPT_CLASSES[52], feature: None },
    StyleClass { name: "Thai", index: 83, script: &SCRIPT_CLASSES[53], feature: None },
    StyleClass { name: "Vai", index: 84, script: &SCRIPT_CLASSES[54], feature: None },
    StyleClass { name: "Limbu", index: 85, script: &SCRIPT_CLASSES[55], feature: None },
    StyleClass { name: "Oriya", index: 86, script: &SCRIPT_CLASSES[56], feature: None },
    StyleClass { name: "Syloti Nagri", index: 87, script: &SCRIPT_CLASSES[57], feature: None },
    StyleClass { name: "Tibetan", index: 88, script: &SCRIPT_CLASSES[58], feature: None },
    StyleClass { name: "CJKV ideographs", index: 89, script: &SCRIPT_CLASSES[59], feature: None },
];

#[allow(unused)]impl StyleClass {
    pub const ADLM: usize = 0;
    pub const ARAB: usize = 1;
    pub const ARMN: usize = 2;
    pub const AVST: usize = 3;
    pub const BAMU: usize = 4;
    pub const BENG: usize = 5;
    pub const BUHD: usize = 6;
    pub const CAKM: usize = 7;
    pub const CANS: usize = 8;
    pub const CARI: usize = 9;
    pub const CHER: usize = 10;
    pub const COPT: usize = 11;
    pub const CPRT: usize = 12;
    pub const CYRL_C2CP: usize = 13;
    pub const CYRL_C2SC: usize = 14;
    pub const CYRL_ORDN: usize = 15;
    pub const CYRL_PCAP: usize = 16;
    pub const CYRL_RUBY: usize = 17;
    pub const CYRL_SINF: usize = 18;
    pub const CYRL_SMCP: usize = 19;
    pub const CYRL_SUBS: usize = 20;
    pub const CYRL_SUPS: usize = 21;
    pub const CYRL_TITL: usize = 22;
    pub const CYRL: usize = 23;
    pub const DEVA: usize = 24;
    pub const DSRT: usize = 25;
    pub const ETHI: usize = 26;
    pub const GEOR: usize = 27;
    pub const GEOK: usize = 28;
    pub const GLAG: usize = 29;
    pub const GOTH: usize = 30;
    pub const GREK_C2CP: usize = 31;
    pub const GREK_C2SC: usize = 32;
    pub const GREK_ORDN: usize = 33;
    pub const GREK_PCAP: usize = 34;
    pub const GREK_RUBY: usize = 35;
    pub const GREK_SINF: usize = 36;
    pub const GREK_SMCP: usize = 37;
    pub const GREK_SUBS: usize = 38;
    pub const GREK_SUPS: usize = 39;
    pub const GREK_TITL: usize = 40;
    pub const GREK: usize = 41;
    pub const GUJR: usize = 42;
    pub const GURU: usize = 43;
    pub const HEBR: usize = 44;
    pub const KALI: usize = 45;
    pub const KHMR: usize = 46;
    pub const KHMS: usize = 47;
    pub const KNDA: usize = 48;
    pub const LAOO: usize = 49;
    pub const LATN_C2CP: usize = 50;
    pub const LATN_C2SC: usize = 51;
    pub const LATN_ORDN: usize = 52;
    pub const LATN_PCAP: usize = 53;
    pub const LATN_RUBY: usize = 54;
    pub const LATN_SINF: usize = 55;
    pub const LATN_SMCP: usize = 56;
    pub const LATN_SUBS: usize = 57;
    pub const LATN_SUPS: usize = 58;
    pub const LATN_TITL: usize = 59;
    pub const LATN: usize = 60;
    pub const LATB: usize = 61;
    pub const LATP: usize = 62;
    pub const LISU: usize = 63;
    pub const MLYM: usize = 64;
    pub const MEDF: usize = 65;
    pub const MONG: usize = 66;
    pub const MYMR: usize = 67;
    pub const NKOO: usize = 68;
    pub const NONE: usize = 69;
    pub const OLCK: usize = 70;
    pub const ORKH: usize = 71;
    pub const OSGE: usize = 72;
    pub const OSMA: usize = 73;
    pub const ROHG: usize = 74;
    pub const SAUR: usize = 75;
    pub const SHAW: usize = 76;
    pub const SINH: usize = 77;
    pub const SUND: usize = 78;
    pub const TAML: usize = 79;
    pub const TAVT: usize = 80;
    pub const TELU: usize = 81;
    pub const TFNG: usize = 82;
    pub const THAI: usize = 83;
    pub const VAII: usize = 84;
    pub const LIMB: usize = 85;
    pub const ORYA: usize = 86;
    pub const SYLO: usize = 87;
    pub const TIBT: usize = 88;
    pub const HANI: usize = 89;
}

#[rustfmt::skip]
pub(super) const STYLE_RANGES: &[StyleRange] = &[
    base_range(32, 93, 60),
    non_base_range(94, 96, 60),
    base_range(97, 125, 60),
    non_base_range(126, 126, 60),
    base_range(127, 127, 60),
    base_range(160, 167, 60),
    non_base_range(168, 169, 60),
    base_range(170, 170, 62),
    base_range(171, 173, 60),
    non_base_range(174, 176, 60),
    base_range(177, 177, 60),
    base_range(178, 179, 62),
    non_base_range(180, 180, 60),
    base_range(181, 183, 60),
    non_base_range(184, 184, 60),
    base_range(185, 186, 62),
    base_range(187, 187, 60),
    non_base_range(188, 190, 60),
    base_range(191, 687, 60),
    base_range(688, 696, 62),
    non_base_range(697, 735, 60),
    base_range(736, 740, 62),
    non_base_range(741, 879, 60),
    base_range(880, 889, 41),
    non_base_range(890, 890, 41),
    base_range(891, 899, 41),
    non_base_range(900, 901, 41),
    base_range(902, 1023, 41),
    base_range(1024, 1154, 23),
    non_base_range(1155, 1161, 23),
    base_range(1162, 1327, 23),
    base_range(1328, 1368, 2),
    non_base_range(1369, 1375, 2),
    base_range(1376, 1423, 2),
    base_range(1424, 1424, 44),
    non_base_range(1425, 1471, 44),
    base_range(1472, 1472, 44),
    non_base_range(1473, 1474, 44),
    base_range(1475, 1475, 44),
    non_base_range(1476, 1477, 44),
    base_range(1478, 1478, 44),
    non_base_range(1479, 1479, 44),
    base_range(1480, 1535, 44),
    non_base_range(1536, 1541, 1),
    base_range(1542, 1551, 1),
    non_base_range(1552, 1562, 1),
    base_range(1563, 1610, 1),
    non_base_range(1611, 1631, 1),
    base_range(1632, 1647, 1),
    non_base_range(1648, 1648, 1),
    base_range(1649, 1749, 1),
    non_base_range(1750, 1756, 1),
    base_range(1757, 1758, 1),
    non_base_range(1759, 1764, 1),
    base_range(1765, 1766, 1),
    non_base_range(1767, 1768, 1),
    base_range(1769, 1769, 1),
    non_base_range(1770, 1773, 1),
    base_range(1774, 1791, 1),
    base_range(1872, 2047, 1),
    base_range(2208, 2258, 1),
    non_base_range(2259, 2303, 1),
    non_base_range(2304, 2306, 24),
    base_range(2307, 2361, 24),
    non_base_range(2362, 2362, 24),
    base_range(2363, 2363, 24),
    base_range(2365, 2368, 24),
    non_base_range(2369, 2376, 24),
    base_range(2377, 2380, 24),
    non_base_range(2381, 2381, 24),
    base_range(2382, 2384, 24),
    non_base_range(2387, 2391, 24),
    base_range(2392, 2401, 24),
    non_base_range(2402, 2403, 24),
    base_range(2406, 2431, 24),
    base_range(2432, 2432, 5),
    non_base_range(2433, 2433, 5),
    base_range(2434, 2491, 5),
    non_base_range(2492, 2492, 5),
    base_range(2493, 2496, 5),
    non_base_range(2497, 2500, 5),
    base_range(2501, 2508, 5),
    non_base_range(2509, 2509, 5),
    base_range(2510, 2529, 5),
    non_base_range(2530, 2531, 5),
    base_range(2532, 2557, 5),
    non_base_range(2558, 2558, 5),
    base_range(2559, 2559, 5),
    base_range(2560, 2560, 43),
    non_base_range(2561, 2562, 43),
    base_range(2563, 2619, 43),
    non_base_range(2620, 2620, 43),
    base_range(2621, 2624, 43),
    non_base_range(2625, 2641, 43),
    base_range(2642, 2671, 43),
    non_base_range(2672, 2673, 43),
    base_range(2674, 2676, 43),
    non_base_range(2677, 2677, 43),
    base_range(2678, 2687, 43),
    base_range(2688, 2688, 42),
    non_base_range(2689, 2690, 42),
    base_range(2691, 2747, 42),
    non_base_range(2748, 2748, 42),
    base_range(2749, 2752, 42),
    non_base_range(2753, 2760, 42),
    base_range(2761, 2764, 42),
    non_base_range(2765, 2765, 42),
    base_range(2766, 2785, 42),
    non_base_range(2786, 2787, 42),
    base_range(2788, 2809, 42),
    non_base_range(2810, 2815, 42),
    base_range(2816, 2816, 86),
    non_base_range(2817, 2818, 86),
    base_range(2819, 2875, 86),
    non_base_range(2876, 2876, 86),
    base_range(2877, 2878, 86),
    non_base_range(2879, 2879, 86),
    base_range(2880, 2880, 86),
    non_base_range(2881, 2884, 86),
    base_range(2885, 2892, 86),
    non_base_range(2893, 2902, 86),
    base_range(2903, 2913, 86),
    non_base_range(2914, 2915, 86),
    base_range(2916, 2943, 86),
    base_range(2944, 2945, 79),
    non_base_range(2946, 2946, 79),
    base_range(2947, 3007, 79),
    non_base_range(3008, 3010, 79),
    base_range(3011, 3020, 79),
    non_base_range(3021, 3021, 79),
    base_range(3022, 3071, 79),
    non_base_range(3072, 3072, 81),
    base_range(3073, 3075, 81),
    non_base_range(3076, 3076, 81),
    base_range(3077, 3133, 81),
    non_base_range(3134, 3136, 81),
    base_range(3137, 3141, 81),
    non_base_range(3142, 3158, 81),
    base_range(3159, 3169, 81),
    non_base_range(3170, 3171, 81),
    base_range(3172, 3199, 81),
    base_range(3200, 3200, 48),
    non_base_range(3201, 3201, 48),
    base_range(3202, 3259, 48),
    non_base_range(3260, 3260, 48),
    base_range(3261, 3262, 48),
    non_base_range(3263, 3263, 48),
    base_range(3264, 3269, 48),
    non_base_range(3270, 3270, 48),
    base_range(3271, 3275, 48),
    non_base_range(3276, 3277, 48),
    base_range(3278, 3297, 48),
    non_base_range(3298, 3299, 48),
    base_range(3300, 3327, 48),
    non_base_range(3328, 3329, 64),
    base_range(3330, 3386, 64),
    non_base_range(3387, 3388, 64),
    base_range(3389, 3404, 64),
    non_base_range(3405, 3406, 64),
    base_range(3407, 3425, 64),
    non_base_range(3426, 3427, 64),
    base_range(3428, 3455, 64),
    base_range(3456, 3529, 77),
    non_base_range(3530, 3530, 77),
    base_range(3531, 3537, 77),
    non_base_range(3538, 3542, 77),
    base_range(3543, 3583, 77),
    base_range(3584, 3632, 83),
    non_base_range(3633, 3633, 83),
    base_range(3634, 3635, 83),
    non_base_range(3636, 3642, 83),
    base_range(3643, 3654, 83),
    non_base_range(3655, 3662, 83),
    base_range(3663, 3711, 83),
    base_range(3712, 3760, 49),
    non_base_range(3761, 3761, 49),
    base_range(3762, 3763, 49),
    non_base_range(3764, 3772, 49),
    base_range(3773, 3783, 49),
    non_base_range(3784, 3789, 49),
    base_range(3790, 3839, 49),
    base_range(3840, 3863, 88),
    non_base_range(3864, 3865, 88),
    base_range(3866, 3892, 88),
    non_base_range(3893, 3893, 88),
    base_range(3894, 3894, 88),
    non_base_range(3895, 3895, 88),
    base_range(3896, 3896, 88),
    non_base_range(3897, 3897, 88),
    base_range(3898, 3901, 88),
    non_base_range(3902, 3903, 88),
    base_range(3904, 3952, 88),
    non_base_range(3953, 3966, 88),
    base_range(3967, 3967, 88),
    non_base_range(3968, 3972, 88),
    base_range(3973, 3973, 88),
    non_base_range(3974, 3975, 88),
    base_range(3976, 3980, 88),
    non_base_range(3981, 4028, 88),
    base_range(4029, 4095, 88),
    base_range(4096, 4140, 67),
    non_base_range(4141, 4144, 67),
    base_range(4145, 4145, 67),
    non_base_range(4146, 4151, 67),
    base_range(4152, 4153, 67),
    non_base_range(4154, 4154, 67),
    base_range(4155, 4156, 67),
    non_base_range(4157, 4158, 67),
    base_range(4159, 4183, 67),
    non_base_range(4184, 4185, 67),
    base_range(4186, 4189, 67),
    non_base_range(4190, 4192, 67),
    base_range(4193, 4208, 67),
    non_base_range(4209, 4212, 67),
    base_range(4213, 4225, 67),
    non_base_range(4226, 4226, 67),
    base_range(4227, 4228, 67),
    non_base_range(4229, 4230, 67),
    base_range(4231, 4236, 67),
    non_base_range(4237, 4237, 67),
    base_range(4238, 4255, 67),
    base_range(4256, 4301, 28),
    base_range(4304, 4351, 27),
    base_range(4352, 4607, 89),
    base_range(4608, 4956, 26),
    non_base_range(4957, 4959, 26),
    base_range(4960, 5023, 26),
    base_range(5024, 5119, 10),
    base_range(5120, 5759, 8),
    base_range(5952, 5969, 6),
    non_base_range(5970, 5971, 6),
    base_range(5972, 5983, 6),
    base_range(6016, 6070, 46),
    non_base_range(6071, 6077, 46),
    base_range(6078, 6085, 46),
    non_base_range(6086, 6086, 46),
    base_range(6087, 6088, 46),
    non_base_range(6089, 6099, 46),
    base_range(6100, 6108, 46),
    non_base_range(6109, 6109, 46),
    base_range(6110, 6143, 46),
    base_range(6144, 6276, 66),
    non_base_range(6277, 6278, 66),
    base_range(6279, 6312, 66),
    non_base_range(6313, 6313, 66),
    base_range(6314, 6319, 66),
    base_range(6320, 6399, 8),
    base_range(6400, 6431, 85),
    non_base_range(6432, 6434, 85),
    base_range(6435, 6438, 85),
    non_base_range(6439, 6452, 85),
    base_range(6453, 6454, 85),
    non_base_range(6455, 6459, 85),
    base_range(6460, 6479, 85),
    base_range(6624, 6655, 47),
    non_base_range(6832, 6846, 60),
    non_base_range(7040, 7042, 78),
    base_range(7043, 7072, 78),
    non_base_range(7073, 7085, 78),
    base_range(7086, 7103, 78),
    base_range(7248, 7295, 70),
    base_range(7296, 7311, 23),
    base_range(7312, 7359, 27),
    base_range(7360, 7375, 78),
    base_range(7424, 7467, 60),
    base_range(7468, 7521, 62),
    base_range(7522, 7530, 61),
    base_range(7531, 7543, 60),
    base_range(7544, 7544, 62),
    base_range(7545, 7578, 60),
    base_range(7579, 7615, 62),
    non_base_range(7616, 7679, 60),
    base_range(7680, 7935, 60),
    base_range(7936, 8124, 41),
    non_base_range(8125, 8129, 41),
    base_range(8130, 8140, 41),
    non_base_range(8141, 8143, 41),
    base_range(8144, 8156, 41),
    non_base_range(8157, 8159, 41),
    base_range(8160, 8172, 41),
    non_base_range(8173, 8175, 41),
    base_range(8176, 8188, 41),
    non_base_range(8189, 8190, 41),
    base_range(8191, 8191, 41),
    base_range(8192, 8214, 60),
    non_base_range(8215, 8215, 60),
    base_range(8216, 8253, 60),
    non_base_range(8254, 8254, 60),
    base_range(8255, 8303, 60),
    base_range(8304, 8319, 62),
    base_range(8320, 8348, 61),
    base_range(8352, 8376, 60),
    base_range(8377, 8377, 24),
    base_range(8378, 8399, 60),
    base_range(8528, 8591, 60),
    base_range(11264, 11359, 29),
    base_range(11360, 11387, 60),
    base_range(11388, 11388, 61),
    base_range(11389, 11389, 62),
    base_range(11390, 11391, 60),
    base_range(11392, 11502, 11),
    non_base_range(11503, 11505, 11),
    base_range(11506, 11519, 11),
    base_range(11520, 11565, 28),
    base_range(11568, 11647, 82),
    base_range(11648, 11743, 26),
    non_base_range(11744, 11775, 23),
    base_range(11776, 11903, 60),
    base_range(11904, 12255, 89),
    base_range(12272, 12329, 89),
    non_base_range(12330, 12335, 89),
    base_range(12336, 12687, 89),
    non_base_range(12688, 12703, 89),
    base_range(12704, 12799, 89),
    base_range(13056, 40959, 89),
    base_range(42192, 42239, 63),
    base_range(42240, 42559, 84),
    base_range(42560, 42606, 23),
    non_base_range(42607, 42623, 23),
    base_range(42624, 42653, 23),
    non_base_range(42654, 42655, 23),
    base_range(42656, 42735, 4),
    non_base_range(42736, 42737, 4),
    base_range(42738, 42751, 4),
    base_range(42784, 42863, 60),
    base_range(42864, 42864, 62),
    base_range(42865, 42887, 60),
    non_base_range(42888, 42888, 60),
    base_range(42889, 42999, 60),
    base_range(43000, 43001, 62),
    non_base_range(43002, 43002, 60),
    base_range(43003, 43007, 60),
    base_range(43008, 43009, 87),
    non_base_range(43010, 43010, 87),
    base_range(43011, 43013, 87),
    non_base_range(43014, 43014, 87),
    base_range(43015, 43018, 87),
    non_base_range(43019, 43019, 87),
    base_range(43020, 43044, 87),
    non_base_range(43045, 43046, 87),
    base_range(43047, 43055, 87),
    non_base_range(43136, 43137, 75),
    base_range(43138, 43187, 75),
    non_base_range(43188, 43205, 75),
    base_range(43206, 43231, 75),
    non_base_range(43232, 43249, 24),
    base_range(43250, 43262, 24),
    non_base_range(43263, 43263, 24),
    base_range(43264, 43301, 45),
    non_base_range(43302, 43309, 45),
    base_range(43310, 43311, 45),
    base_range(43360, 43391, 89),
    base_range(43488, 43492, 67),
    non_base_range(43493, 43493, 67),
    base_range(43494, 43519, 67),
    base_range(43616, 43643, 67),
    non_base_range(43644, 43644, 67),
    base_range(43645, 43647, 67),
    base_range(43648, 43695, 80),
    non_base_range(43696, 43696, 80),
    base_range(43697, 43697, 80),
    non_base_range(43698, 43700, 80),
    base_range(43701, 43702, 80),
    non_base_range(43703, 43704, 80),
    base_range(43705, 43709, 80),
    non_base_range(43710, 43711, 80),
    base_range(43712, 43712, 80),
    non_base_range(43713, 43713, 80),
    base_range(43714, 43743, 80),
    base_range(43776, 43823, 26),
    base_range(43824, 43867, 60),
    base_range(43868, 43871, 62),
    base_range(43872, 43887, 60),
    base_range(43888, 43967, 10),
    base_range(44032, 55295, 89),
    base_range(63744, 64255, 89),
    base_range(64256, 64262, 60),
    base_range(64275, 64279, 2),
    base_range(64285, 64285, 44),
    non_base_range(64286, 64286, 44),
    base_range(64287, 64335, 44),
    base_range(64336, 64433, 1),
    non_base_range(64434, 64449, 1),
    base_range(64450, 65023, 1),
    base_range(65040, 65055, 89),
    base_range(65072, 65103, 89),
    non_base_range(65136, 65136, 1),
    base_range(65137, 65137, 1),
    non_base_range(65138, 65138, 1),
    base_range(65139, 65139, 1),
    non_base_range(65140, 65140, 1),
    base_range(65141, 65141, 1),
    non_base_range(65142, 65142, 1),
    base_range(65143, 65143, 1),
    non_base_range(65144, 65144, 1),
    base_range(65145, 65145, 1),
    non_base_range(65146, 65146, 1),
    base_range(65147, 65147, 1),
    non_base_range(65148, 65148, 1),
    base_range(65149, 65149, 1),
    non_base_range(65150, 65150, 1),
    base_range(65151, 65279, 1),
    base_range(65280, 65519, 89),
    base_range(66208, 66271, 9),
    base_range(66352, 66383, 30),
    base_range(66560, 66639, 25),
    base_range(66640, 66687, 76),
    base_range(66688, 66735, 73),
    base_range(66736, 66815, 72),
    base_range(67584, 67647, 12),
    base_range(68352, 68408, 3),
    non_base_range(68409, 68415, 3),
    base_range(68608, 68687, 71),
    base_range(68864, 68927, 74),
    non_base_range(69888, 69890, 7),
    base_range(69891, 69926, 7),
    non_base_range(69927, 69940, 7),
    base_range(69941, 69957, 7),
    non_base_range(69958, 69958, 7),
    base_range(69959, 69967, 7),
    base_range(71264, 71295, 66),
    base_range(93760, 93855, 65),
    base_range(110592, 110895, 89),
    base_range(119552, 119647, 89),
    base_range(119808, 120831, 60),
    non_base_range(122880, 122927, 29),
    non_base_range(125184, 125258, 0),
    base_range(125259, 125279, 0),
    base_range(126464, 126719, 1),
    base_range(131072, 173791, 89),
    base_range(173824, 191471, 89),
    base_range(194560, 195103, 89),
];

