// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `StopReason`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let stopreason = unimplemented!();
/// match stopreason {
///     StopReason::ContentFiltered => { /* ... */ },
///     StopReason::EndTurn => { /* ... */ },
///     StopReason::GuardrailIntervened => { /* ... */ },
///     StopReason::MaxTokens => { /* ... */ },
///     StopReason::StopSequence => { /* ... */ },
///     StopReason::ToolUse => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `stopreason` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `StopReason::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `StopReason::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `StopReason::NewFeature` is defined.
/// Specifically, when `stopreason` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `StopReason::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum StopReason {
    #[allow(missing_docs)] // documentation missing in model
    ContentFiltered,
    #[allow(missing_docs)] // documentation missing in model
    EndTurn,
    #[allow(missing_docs)] // documentation missing in model
    GuardrailIntervened,
    #[allow(missing_docs)] // documentation missing in model
    MaxTokens,
    #[allow(missing_docs)] // documentation missing in model
    StopSequence,
    #[allow(missing_docs)] // documentation missing in model
    ToolUse,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for StopReason {
    fn from(s: &str) -> Self {
        match s {
            "content_filtered" => StopReason::ContentFiltered,
            "end_turn" => StopReason::EndTurn,
            "guardrail_intervened" => StopReason::GuardrailIntervened,
            "max_tokens" => StopReason::MaxTokens,
            "stop_sequence" => StopReason::StopSequence,
            "tool_use" => StopReason::ToolUse,
            other => StopReason::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for StopReason {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(StopReason::from(s))
    }
}
impl StopReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StopReason::ContentFiltered => "content_filtered",
            StopReason::EndTurn => "end_turn",
            StopReason::GuardrailIntervened => "guardrail_intervened",
            StopReason::MaxTokens => "max_tokens",
            StopReason::StopSequence => "stop_sequence",
            StopReason::ToolUse => "tool_use",
            StopReason::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "content_filtered",
            "end_turn",
            "guardrail_intervened",
            "max_tokens",
            "stop_sequence",
            "tool_use",
        ]
    }
}
impl ::std::convert::AsRef<str> for StopReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl StopReason {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for StopReason {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            StopReason::ContentFiltered => write!(f, "content_filtered"),
            StopReason::EndTurn => write!(f, "end_turn"),
            StopReason::GuardrailIntervened => write!(f, "guardrail_intervened"),
            StopReason::MaxTokens => write!(f, "max_tokens"),
            StopReason::StopSequence => write!(f, "stop_sequence"),
            StopReason::ToolUse => write!(f, "tool_use"),
            StopReason::Unknown(value) => write!(f, "{}", value),
        }
    }
}
