// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0 OR ISC OR MIT-0

// ----------------------------------------------------------------------------
// Count number of set bits in a single 64-bit word (population count)
// Input a; output function return
//
//    extern uint64_t word_popcount (uint64_t a);
//
// Standard x86-64 ABI: RDI = a, returns RAX
// Microsoft x64 ABI:   RCX = a, returns RAX
// ----------------------------------------------------------------------------

#include "_internal_s2n_bignum.h"


        S2N_BN_SYM_VISIBILITY_DIRECTIVE(word_popcount)
        S2N_BN_SYM_PRIVACY_DIRECTIVE(word_popcount)
        .text

S2N_BN_SYMBOL(word_popcount):
        _CET_ENDBR

#if WINDOWS_ABI
        pushq   %rdi
        pushq   %rsi
        movq    %rcx, %rdi
#endif

// The code is generated by gcc -O3 (version 11.4.0) from
//
// uint64_t word_popcount(uint64_t x)
// { uint64_t x2  = x - ((x & UINT64_C(0xAAAAAAAAAAAAAAAA))>>1);
//   uint64_t x4  = (x2 & UINT64_C(0x3333333333333333)) +
//                  ((x2 & UINT64_C(0xCCCCCCCCCCCCCCCC))>>2);
//   uint64_t x8  = (x4 + (x4>>4)) & UINT64_C(0x0F0F0F0F0F0F0F0F);
//   uint64_t x64 = x8 * UINT64_C(0x101010101010101);
//   uint64_t y = x64>>56;
//  return y;
// }

        movabsq $0x5555555555555555, %rdx
        movq    %rdi, %rax
        shrq    $1, %rax
        andq    %rdx, %rax
        subq    %rax, %rdi
        movabsq $0x3333333333333333, %rax
        movq    %rdi, %rdx
        andq    %rax, %rdi
        shrq    $0x2, %rdx
        andq    %rax, %rdx
        addq    %rdi, %rdx
        movq    %rdx, %rax
        shrq    $0x4, %rax
        addq    %rdx, %rax
        movabsq $0xf0f0f0f0f0f0f0f, %rdx
        andq    %rdx, %rax
        movabsq $0x101010101010101, %rdx
        imulq   %rdx, %rax
        shrq    $0x38, %rax

#if WINDOWS_ABI
        popq   %rsi
        popq   %rdi
#endif
        ret

#if defined(__linux__) && defined(__ELF__)
.section .note.GNU-stack, "", %progbits
#endif
