## V1.2026.0 (Jan 9, 2026)
 - [🐛 fix issue during negative comparison](https://github.com/plantuml/plantuml/commit/bac6697add77d514afcefe8c6992932fbd29151c)
 - [🐛 fix dot issue](https://github.com/plantuml/plantuml/commit/b8809ac19ed48f9443d2d75c6f43940aa55de894)
 - [🐛 fix nested state attributes render outside parent composite](https://github.com/plantuml/plantuml/commit/cb771de4ccd0dba8f1e2620eb6847e30322b50b5)
 - [🐛 Added repeat while labels to diamond Inside figure (#2422)](https://github.com/plantuml/plantuml/commit/946236def5181ab15fbeaeaf709f2b434bbb96c6)
 - [✨ clarify include path resolution rules](https://github.com/plantuml/plantuml/commit/35bc477190817b7e4dacf63e6469945477a364ea)
 - [🐛 Connectors from switch tile creates arrow to a different tile in a different swimlane (#2423)](https://github.com/plantuml/plantuml/commit/5782ab71fe12ea9baab632bc0add8d412dba7c0f)
 - [🐛 tikz: vertically center single AtomText and fix cuca height (#2055) (#2424)](https://github.com/plantuml/plantuml/commit/3c50148ba92ead7507ea43bb763c3827740ed87b)
 - [🐛 tikz: vertically center single AtomText and fix cuca height (#2055) (#2424)](https://github.com/plantuml/plantuml/commit/2dd7579a2e324d212b34760182c39a50afdd31a6)
 - [🐛 Connectors from switch tiles connect correctly (#2426)](https://github.com/plantuml/plantuml/commit/f1f64f8d0950df7361a3774e67ea050ddc2c0b4e)
 - [🐛 minor regression](https://github.com/plantuml/plantuml/commit/6f246e8e38a12d2513f473bb3f9d30b44d680204)
 - [✨ Text align for StripeSimple (#2408)](https://github.com/plantuml/plantuml/commit/f3289ddcd1d9af8cf89dafa32a0455fe20414b0d)
 - [⚗️ Add chart diagram support with comprehensive features (#2440)](https://github.com/plantuml/plantuml/commit/5372e2cb266e80fa2a3a4df12f21f3524b851265)
 - [📦️ adding awslab v20.0 and upgrade archimate to 3.2.2](https://github.com/plantuml/plantuml/commit/f486ae2386adbeac9446b667ab6abf65ebf31059)
 - [✨ Add attributes to visibility modifiers in SVG (#2441)](https://github.com/plantuml/plantuml/commit/5a43f90d1a79986d705302057a5defe7a66319d5)
 - [🐛 better handle CLI errors](https://github.com/plantuml/plantuml/commit/bd6822b868205ce0176dd0fc6a4cbd98708fdf2e)
 - [⚗️ 2436 style allow actor shape on activity diagram (#2444)](https://github.com/plantuml/plantuml/commit/bf5b8ddbcbebff937050d620348e6a40f9ef2493)
 - [✨ add default value for `!option`](https://github.com/plantuml/plantuml/commit/394245cd34a717bf6429271b1aa5c6eb80e136ae)
 - [✨ add `partition` keyword for sequence diagram](https://github.com/plantuml/plantuml/commit/5a00f2f049daf25cfa080518c0c0212decf2723f)
 - [✨ add default value for `!pragma`](https://github.com/plantuml/plantuml/commit/2afabbd431fddb0e0cf6412a070e10ef393e6715)
 - [✨ Add month (30 days) support in gantt diagram](https://github.com/plantuml/plantuml/commit/1022d59a237870fc9f6bf8d3b18aad4fb4f0b3bf)
 - [🐛 protection against memory error](https://github.com/plantuml/plantuml/commit/796a85866e44d0747fa9e654434c85685a045fef)
 - [✨ add `stereotype` and `URL` for `CommandActivityLegacy1` on activity diagram (#2451)](https://github.com/plantuml/plantuml/commit/842c4a519463b828d2c7efb850c2b42e047625bb)
 - [✨ allow empty branch in mindmap (#2452)](https://github.com/plantuml/plantuml/commit/ee98587fd8f4f2c33614755f22be2000b0edbdc3)
 - [✨ style allow actor shape on activity diagram](https://github.com/plantuml/plantuml/commit/6eb58928bbdce2572cbc660fbdbb500c261cd7d7)
 - [🔒 remove SVG export for PSystemDot](https://github.com/plantuml/plantuml/commit/6826315db092d2e432aeab1a0894e08017c6e4bd)
 - [✨ add link type attributes to SVG (#2453)](https://github.com/plantuml/plantuml/commit/b19d6368ddd96b02c2da36132c930cc3a7fd3811)
 - [✨ allow minimal mindmap (#2454)](https://github.com/plantuml/plantuml/commit/671764a2c2460d2acdd894455e85268c912dcc6a)
 - [🩹 fix lazy Regex on `CommandActivityLegacy1` (#2456)](https://github.com/plantuml/plantuml/commit/a2563576cefe96b8073483a9b8ac87b31045e250)
 - [✨ add link type attributes to SVG (#2453)](https://github.com/plantuml/plantuml/commit/5f5f163b97ea9ec8c50e7bc18cd66426b55a53ba)
 - [🐛 minor regression on mindmap diagram](https://github.com/plantuml/plantuml/commit/9db4f0da3a1b54ef745872e1364c2a01b1602908)
 - [🐛 fix crash when using a bad reference in a state machine](https://github.com/plantuml/plantuml/commit/59b508f332ebf30aa4a94b93464cb270d527bb6c)
 - [🐛 remove legacy `!pragma SVGNEWDATA true`](https://github.com/plantuml/plantuml/commit/5c0ef334ef3cea1711618e0785bdc5d646ce7a12)
 - [🐾 display warning when using legacy group syntax](https://github.com/plantuml/plantuml/commit/49b6da395e7c1a369fbf3a11c67e8026882683d5)
 - [🐛 fix automatic font colors with table](https://github.com/plantuml/plantuml/commit/c59fe08b60ee65c95650feeca750d0ea07b70034)
 - [🐛 use "processing instruction" in SVG export](https://github.com/plantuml/plantuml/commit/0913f51b416542f790b7c1c87c610e3db97ca793)
 - [🐛 improve `!if` management](https://github.com/plantuml/plantuml/commit/a581b2a3ab53341557e450a36aedaf4e815f1110)

## V1.2025.10 (Nov 4, 2025)
- [✨ Add support for rounded corners on orthogonal edges (#2389)](https://github.com/plantuml/plantuml/commit/e402d6fc7b510ba510a5b68f0bc022fc7262fd2a)
- [⚗️ Add automatic vertical alignment for orthogonal edges at label nodes (#2395)](https://github.com/plantuml/plantuml/commit/49869db39e170223a16c8f241053df6b68846a02)
- [🐛 fix substracting in preprocessor](https://github.com/plantuml/plantuml/commit/38064da374cd3472e25dfe098b54fa6dc738795e)
- [✨ Allow access to internal SVG sprite (SVG by default with a PNG fallback) (#2397)](https://github.com/plantuml/plantuml/commit/91e3c5bb0961b9296375784f9c2c85258858eaea)
- [✨ allow unit (s, m, h, d, y, Y) on timing scale as pixel (#2398)](https://github.com/plantuml/plantuml/commit/c706bec9c72200f4608162ed4b524f0f7df8c689)
- [📝 improve help message](https://github.com/plantuml/plantuml/commit/38a4b86e9fe28b2ab486ea9492d05abcad8ca152)
- [🐛 Remove extra empty line after sub-diagram (#2404)](https://github.com/plantuml/plantuml/commit/30f8c55da60d1b53e76ae05b66c4015068acc54a)
- [🐛 restore 8080 as default port for picoweb](https://github.com/plantuml/plantuml/commit/c5367aaf31217ab577c721b3f4bb59b6ad6e4432)
- [🐛 fix dot issue](https://github.com/plantuml/plantuml/commit/831f1d2ffea7dc44ff5d01d02358997b4c255970)
- [⚡️ speeding up generation sub-diagrams in SVG](https://github.com/plantuml/plantuml/commit/7cbd39cd7053b6223b99df4839666ba862ae14fd)
- [✨ new `rectangle` shape in timing diagram](https://github.com/plantuml/plantuml/commit/47b8b308c7cf47359fba4b065e21fe7978b627e8)

## V1.2025.9 (Oct 18, 2025)
- [✨ Add node-based transition labels for state diagrams](https://github.com/plantuml/plantuml/pull/2368)
- [✨ Further improve edge routing for node-style transition labels in state diagrams](https://github.com/plantuml/plantuml/pull/2369)
- [✨ allow `*` on `ActivityLegacy1` (and adjust with `spaceZeroOrOne`)](https://github.com/plantuml/plantuml/pull/2376)
- [✨ Center node-style transition labels on edge path in state diagrams](https://github.com/plantuml/plantuml/pull/2379)
- [✨ Preserve original number format in timing diagram analog scale labels](https://github.com/plantuml/plantuml/pull/2382)
- [♻️ refactor Regex on ActivityLegacy1, and `spaceZeroOrOne`](https://github.com/plantuml/plantuml/pull/2385)
- [🐛 Improve number format support in timing diagram analog scale](https://github.com/plantuml/plantuml/pull/2382)
- [⚗️ experimental support for `!pragma sequenceMessageSpan true`](https://github.com/plantuml/plantuml/issues/2386)
- [⚗️ Introduce new command-line interface (beta)](https://github.com/plantuml/plantuml/issues/2377)
- [📦️ update standard library (archimate)](https://github.com/plantuml/plantuml/commit/0b839d95d20dd3fce8c6990b85e681883947ac17)

## V1.2025.8 (Oct 4, 2025)
- [🍱 [Archimate] Remove duplicate sprites and replace PNG sprites with SVG counterparts](https://github.com/plantuml/plantuml/pull/2327)
- [🔊 Improve error message for WBS diagram root validation (replace error 44)](https://github.com/plantuml/plantuml/pull/2330)
- [🐛 Language Descriptor Improvement [fix, update, add, suppress some keywords]](https://github.com/plantuml/plantuml/pull/2336)
- [🐛 Improve WBS declaration (with `Direction`, `Code`)](https://github.com/plantuml/plantuml/pull/2346)
- [✨ WBS improve declaration (force order of parameters)](https://github.com/plantuml/plantuml/pull/2362)

## V1.2025.7 (Sep 10, 2025)
- [♻️ improve font management](https://github.com/plantuml/plantuml/issues/2158)
- [🐛 fix regression with some `o--`link](https://github.com/plantuml/plantuml/commit/84cf1fa8b37bfb3269509eb53123291801106634)
- [💄 Add inheritance to `lifeline` for `delay` (#2266)](https://github.com/plantuml/plantuml/commit/b30bea7328a28abfcdf0ee180884103968157bd6)
- [🐛 fix WBS direction](https://github.com/plantuml/plantuml/commit/f428e614293050767e48d9331e3af649f9f7c951)
- [🐛 fix scale regression in class diagrams](https://github.com/plantuml/plantuml/commit/e3fc5d045394d5fd5bd9fcb8a3ae32a94233ae9d)
- [📦️ update standard library (`material7` and `C4`)](https://github.com/plantuml/plantuml-stdlib/pull/152)
- [🔥 remove obsolete `skinparam` setting](https://github.com/plantuml/plantuml/commit/7e874983da4b2053577278f83ec4a9306884e31b)
- [✨ add new `activationBox` style which works locally](https://github.com/plantuml/plantuml/issues/1109)
- [🐾 adding trace for debug](https://github.com/plantuml/plantuml/commit/275fd1be41ea383ba0111562ed8c3f7d2539e061)
- [🐛 fix `GraphvizDotHeader` test to be more conform to the official `DOT` grammar (#2294)](https://github.com/plantuml/plantuml/commit/0053fa9e4d11c9e7fe573fe11143d3dc3967cd69)
- [✨ add svgTitle and svgDesc options for accessibility](https://github.com/plantuml/plantuml/issues/2292)
- [📝 add documentation about CI](https://github.com/plantuml/plantuml/commit/833ed5e6f9fdb3bacc1c484940bf17879ca466c0)
- [👷 add compilation with ant on JDK8](https://github.com/plantuml/plantuml/commit/b3140c8d6ca7d7b0c780051e4cc95d0fb5e4affa)
- [📝 add documentation about CI and JDK8/ant](https://github.com/plantuml/plantuml/commit/0c142036a2183b9fcd20c8743939225f572f56b6)
- [⚡️ improve perf by removing regex](https://github.com/plantuml/plantuml/commit/5eb364916405021c2190ba6e009119e09a823355)
- [🔥 remove dead code](https://github.com/plantuml/plantuml/commit/e027ed43387d8175c51885ff4f405f7ae4cab05e)
- [🐛 Support local style on Activity diagram elements](https://github.com/plantuml/plantuml/issues/2285)
- [🐛 include title with line breaks in SVG <title> element](https://forum.plantuml.net/20011/svg-title-does-not-include-whole-puml-title)
- [⚡️ optimize diagram type detection and start/end parsing](https://github.com/plantuml/plantuml/commit/9edb1a9c9979dff5802c91d175b1c59c4638ab84)
- [⚡️ refactor activity ftile snakes and worms](https://github.com/plantuml/plantuml/commit/72a4848db262e9c220d0ecb1f887be50189b0f86)
- [🐛 fix regression](https://github.com/plantuml/plantuml/commit/e6eff5582def0db104652e915cc527aef966cb9d)
- [⚡️ optimized translation for Worm](https://github.com/plantuml/plantuml/commit/f03b2c8d62f3809ee32c464e21a2541a461bc465)
- [⚡️ optimize color parsing](https://github.com/plantuml/plantuml/commit/4c642b12027b64da100b5a68bb3222e49cf968e9)
- [⚡️ optimize token parsing](https://github.com/plantuml/plantuml/commit/889163e20f1f7b82405515970f35879a2c4c6d1d)
- [⚗️ optimize images by applying PNG quantization when feasible](https://github.com/plantuml/plantuml/commit/6663d677320224d4d5d76478bdfd2566c7a11270)
- [⚗️ slightly reduce PNG](https://github.com/plantuml/plantuml/commit/b6c27311caa72494c9aa2dbe761702a2f418ba06)
- [⚗️ using deflate level 7 for PNG](https://github.com/plantuml/plantuml/commit/24c0afb9de73c14a9b54955df4baa6d0a672a8c9)
- [🚧 add OKLab PNG quantization (currently unused, may be used later)](https://github.com/plantuml/plantuml/commit/a763a4a7e3089a71891a0eaa746d30a9b16002b9)
- [📝 Update Archimate sprites to assign correct colors; use new workpackage symbol (#2308)](https://github.com/plantuml/plantuml/commit/7e79c91cb14f0acf3221c0bda900294e813d4688)
- [👷 fix missing archimate sprites](https://github.com/plantuml/plantuml/discussions/2309)
- [♻️ better handle alpha channel](https://github.com/plantuml/plantuml/commit/01201471aec80ac3c0dcc1470534e69d3e39fb36)
- [⚗️ improve transparency handling in image quantization](https://github.com/plantuml/plantuml/commit/43901709916a9e5ae589d05db24db96090af1ff0)
- [💄 [Style][Theme] Improve task margin management on all themes (for Gantt diagram) (#2312)](https://github.com/plantuml/plantuml/commit/590b3f164b55489e214214d9043fcd19fea79581)
- [🚧 prepare SVG sprites for Archimate](https://github.com/plantuml/plantuml/commit/23aed4376a2f644f29243a67e593fca311ab4dbd)
- [🐛 Fix missing double dash un-escaping in SVG metadata (#2313)](https://github.com/plantuml/plantuml/commit/9a3e5ebc62f8e3aa874f3a5c4c7855eb1694110a)
- [🐛 fix horizontal line in tips](https://github.com/plantuml/plantuml-server/issues/386)
- [🚧 Archimate updates, including svg versions of the sprites (#2316)](https://github.com/plantuml/plantuml/commit/7250c60b33593d8f6d5c75f332b41bce5a860904)
- [🚧 prioritize SVG sprites over PNG for Archimate diagrams](https://github.com/plantuml/plantuml/commit/70e30ae81a02aa616c67c64a0e459d9cba1d82ad)
- [🐛 fix include from !theme](https://github.com/plantuml/plantuml/issues/2317)
- [🐛 display SVG sprites in `listsprites`](https://github.com/plantuml/plantuml/issues/2321)
- [📦️ update Archimte standard library](https://github.com/plantuml/plantuml/commit/703b92c6dc0771c192b77555eca1a664121251bf)
- [🔊 Improve error reported when entity already exists (#2324)](https://github.com/plantuml/plantuml/commit/3004a77693d1de67f4cc2df5b43941f829127c33)

## V1.2025.4 (Jun 28, 2025)
- See directly on GitHub: [All GitHub Issues fixed or GitHub Pull Request accepted of the version](https://github.com/plantuml/plantuml/issues?q=milestone%3A1.2025.4)
- [Sequence - Lifeline border thickness is ignored when a delay is added in sequence diagram](https://forum.plantuml.net/7030/lifeline-border-thickness-ignored-delay-sequence-diagram)
- [Sequence - CSS styling Beta - Sequence diagram - dots not colored with LineColor](https://forum.plantuml.net/10991/styling-beta-sequence-diagram-dots-colored-with-linecolor)
- [Sequence - Text of delay message in cerulean theme is invisible](https://forum.plantuml.net/20091/text-of-delay-message-in-cerulean-theme-is-invisible)


## V1.2025.3 (Jun 1, 2025)
- See directly on GitHub: [All GitHub Issues fixed or GitHub Pull Request accepted of the version](https://github.com/plantuml/plantuml/issues?q=milestone%3A1.2025.3)
- [Javadoc improvement](https://plantuml.github.io/plantuml/javadoc)
- [Jacoco improvement (Add Java Code Coverage Report)](https://plantuml.github.io/plantuml/jacoco)
- [Activity - How to change colour on new Activity Diagram goto](https://forum.plantuml.net/17445/how-to-change-colour-on-new-activity-diagram-goto)
- [Activity - How to draw send signal action and accept event action in activity diagram?](https://forum.plantuml.net/16558/draw-send-signal-action-accept-event-action-activity-diagram)
- [DITAA has crashed](https://forum.plantuml.net/19704/ditaa-has-crashed)
- [DITAA - empty lines seem to be ignored; this may result in additionally rendered boxes](https://forum.plantuml.net/19777/ditaa-empty-lines-ignored-result-additionally-rendered-boxes)
- [Gantt - Adding a Note below a milestone in Gantt](https://forum.plantuml.net/13164/adding-a-note-below-a-milestone-in-gantt)
- [Gantt - Custom / financial weeks in Gantt chart](https://forum.plantuml.net/17852/custom-financial-weeks-in-gantt-chart)
- [Invalid message of obsolete version](https://forum.plantuml.net/20043/invalid-message-of-obsolete-version)
- [SVG sprites work in a node text, but not in an edge text](https://forum.plantuml.net/20006/svg-sprites-work-in-a-node-text-but-not-in-an-edge-text)
- [SVG - Broken inline SVG support for Quadratic Curves](https://forum.plantuml.net/16883/broken-inline-svg-support-for-quadratic-curves)
- [State machine invalid generation for SVG](https://forum.plantuml.net/19290/state-machine-invalid-generation-for-svg)

## V1.2025.2 (Mar 5, 2025)

- [EBNF - Improve the curved line on the EBNF diagram](https://github.com/plantuml/plantuml/issues/2075)
- [SVG - Lost id-attribute (or group)](https://github.com/plantuml/plantuml/issues/2069)
- [SVG - Revert SVG fill to "none"; use UParam to indicate hit targets](https://github.com/plantuml/plantuml/pull/2072)
- [SVG - Interactive SVG with namespaced::nodes does not work properly](https://github.com/plantuml/plantuml/issues/2041)
- [SVG - Unable to Click Links in SVGs Due to Overlapping Transparent path Elements](https://github.com/plantuml/plantuml/issues/2071)
- [SVG - Interactive SVG with component ports is not working](https://github.com/plantuml/plantuml/issues/1235)
- [SVG - Add filtering to interactive sequence diagrams](https://github.com/plantuml/plantuml/pull/2091)
- [SURL - Follow HTTP redirection in `!include` directive](https://github.com/plantuml/plantuml/issues/1112)
- [Style - Allow old skinparam (stereotypeXBackgroundColor/BorderColor) for new spot style](https://github.com/plantuml/plantuml/pull/2101)
- [Style - Update handwritten themes in order to avoid warning](https://github.com/plantuml/plantuml/pull/2088)
- [Native - Naming of the snapshot native images](https://github.com/plantuml/plantuml/issues/2105)
- [Native - Support C4 on native image](https://github.com/plantuml/plantuml/pull/2097)
- [Native - Add Linux ARM64 native image on Native Image - Snapshot](https://github.com/plantuml/plantuml/pull/2078)
- [Newline - Possible regression bug (due to new newline management)](https://github.com/plantuml/plantuml/issues/2094)
- [Newline - Improve preproc output](https://github.com/plantuml/plantuml/issues/2095)
- [Gantt - Hide monthheader if the whole month is closed in gantt](https://github.com/plantuml/plantuml/pull/2068)

## V1.2025.1 (Feb 16, 2025)

- [Backslash future deprecation and introduction of new functions](https://plantuml.com/newline)
- [`%newline()` fix](https://forum.plantuml.net/19607/1-2025-0-has-%25newline-bug-older-version-1-2024-7-was-working)
- [REGEX - Add method to map regex patterns to descriptive names](https://github.com/plantuml/plantuml/pull/2036)
- [SVG - Allow interactive SVG sequence diagram's header to float](https://github.com/plantuml/plantuml/pull/2058)
- [XMI - Add support for custom XMI generation](https://github.com/plantuml/plantuml/pull/2049)
- [SVG results with black box in Visio](https://github.com/plantuml/plantuml/issues/2040)
- [PDF export fails](https://forum.plantuml.net/19700/pdf-export-fails)
- [Problem with `<style>` and parameter Shadowing for rectangle](https://github.com/plantuml/plantuml/issues/2053)
- [YAML string quotes do not escape comment character](https://github.com/plantuml/plantuml/issues/2054)
- [Style boxless root on mindmap](https://github.com/plantuml/plantuml/issues/2061)
- [Allow colon character (`:`) on the value of a YAML field](https://github.com/plantuml/plantuml/issues/2063)
- [Unable to define variables on plantuml command line with `-D`](https://github.com/plantuml/plantuml/issues/2065)
- [Diagram sequence regression](https://forum.plantuml.net/19698/seems-to-break-diagrams)
- [Improve internal YAML parser with a new parser](https://github.com/plantuml/plantuml/commit/99508d4eaff4b02c2cf1396f4c437cfe8bee3592)
- [YAML - Display key without label](https://github.com/plantuml/plantuml/issues/2050)
- [YAML - Fix Object attribute hierarchy in the yaml array](https://github.com/plantuml/plantuml/issues/1409)
- [YAML - Cannot render a list contain a key value pair](https://github.com/plantuml/plantuml/issues/708)
- [YAML - Fix YAML processing if no spaces at start of list](https://github.com/plantuml/plantuml/issues/1876)
- [YAML - Last list entry used instead of showing top level YAML items](https://forum.plantuml.net/15957/yaml-last-list-entry-used-instead-showing-top-level-yaml-items)
- [EBNF - None-first style](https://github.com/plantuml/plantuml/issues/1585)
- [Entity names cannot start or end with separator character: fix error message](https://github.com/plantuml/plantuml/issues/2014)

## V1.2025.0 (Jan 15, 2025)

- [Gantt Chart with closed weekends does not render correctly depending on the theme](https://github.com/plantuml/plantuml/issues/2022)
- [Allow hide closed in the Gantt chart](https://github.com/plantuml/plantuml/issues/1807)
- [Ressources footer is messed when in monthly mode](https://github.com/plantuml/plantuml/issues/1973)
- [Gantt with weekly scale doesn't show named regions](https://github.com/plantuml/plantuml/issues/1999)
- [guillemotleft guillemotright](https://github.com/plantuml/plantuml/issues/2029)
- [Improve head of arrow position](https://github.com/plantuml/plantuml/issues/1627)
- [Smetana throws an ArrayIndexOutOfBoundsException](https://github.com/plantuml/plantuml/issues/2006)
- [Test ExportOnUText](https://github.com/plantuml/plantuml/pull/1936)
- [Extend error message with diagram type](https://github.com/plantuml/plantuml/pull/1997)
- [Allow RoundCorner for object, map and json element](https://github.com/plantuml/plantuml/issues/1991)
- [Update DomainStory to version Delta 0.4.0](https://github.com/plantuml/plantuml-stdlib/pull/125)
- [Hiding/showing a specific stereotype hides/shows all of them](https://github.com/plantuml/plantuml/issues/1984)
- [Allow YAML frontmatter on beginning of theme files](https://github.com/plantuml/plantuml/issues/1980)
- [REGEX - Allow to expand a element with the corresponding alternative element](https://github.com/plantuml/plantuml/issues/1929)

## V1.2024.8 (Nov 15, 2024)

- [Nwdiag: Allow line border for group](https://github.com/plantuml/plantuml/issues/1226)
- [Style: Allow all style for regex diagram](https://github.com/plantuml/plantuml/issues/1445)
- [Compact clocks in timing diagrams not rendered correctly](https://github.com/plantuml/plantuml/issues/1578)
- [Mindmap: node MaximumWidth: weird latex result](https://github.com/plantuml/plantuml/issues/1606)
- [Style: Improve HorizontalAlignment management](https://github.com/plantuml/plantuml/issues/1640)
- [Can I center the description text at the bottom the state box?](https://forum.plantuml.net/16978)
- [Style: HorizontalAlignment management for diamond [Activity diagram]](https://forum.plantuml.net/14271)
- [Text alignment for components in component diagram](https://forum.plantuml.net/11429)
- [How to align text to the left in a container (for example a rectangle)?](https://forum.plantuml.net/10658)
- [LaTeX labels not centered](https://github.com/plantuml/plantuml/issues/1734)
- [State: Exception on two transitions to the same deep history node](https://github.com/plantuml/plantuml/issues/1788)
- [Stereotype with plain circle: text should be elided](https://github.com/plantuml/plantuml/issues/1854)
- [Can't get bottom half arrow style to work when a macro is used](https://github.com/plantuml/plantuml/issues/1867)
- [Sometimes difficult to detect to which arrow a text in a Chen diagram belongs](https://github.com/plantuml/plantuml/issues/1890)
- [Allow MinimumWidth on all nested elements](https://github.com/plantuml/plantuml/issues/1893)
- [MinimumWidth doesnt work when there's a nested object](https://forum.plantuml.net/18302)
- [Style: Improve map and json style in order to manage header style](https://github.com/plantuml/plantuml/issues/1896)
- [Improve edge cases for JSON diagram (manage null and empty Array/Object)](https://github.com/plantuml/plantuml/pull/1900)
- [JSON object: changing background color of Header line](https://forum.plantuml.net/19233)
- [Gantt with monthly scale doesn't show named regions](https://github.com/plantuml/plantuml/issues/1902)
- [Add support for colors in Chen EER diagrams](https://github.com/plantuml/plantuml/pull/1909)
- [Dirpath built in preprocessor function returns empty in pipe mode](https://github.com/plantuml/plantuml/issues/1910)
- [Add `overrideDirPath` method](https://github.com/plantuml/plantuml/pull/1916)
- [Uniformisation of dirpath](https://github.com/plantuml/plantuml/commit/4318369c7236e556ee4418971a1963bb697d3b55)
- [Regex: Allow to expand a `[]` element with the corresponding alternative `|` element](https://github.com/plantuml/plantuml/issues/1929)
- [Reintroduction of `filedate` and `filename_no_extension` builtin function](https://github.com/plantuml/plantuml/pull/1933)
- [Crash with IllegalStateException](https://github.com/plantuml/plantuml/issues/1934)
- [Allow Unicode ASCII Art for class, component, ...](https://github.com/plantuml/plantuml/pull/1938)
- [`-tutxt` switch does not produce unicode but simple ascii](https://forum.plantuml.net/3356)
- [Request for adding a copy of the LGPLv3 as a COPYING.LESSER file along side the GPLv3 COPYING file?](https://github.com/plantuml/plantuml/issues/1944)
- [Style: Allow all style for Cardinality, Generic, Qualified associations on Class diagram](https://github.com/plantuml/plantuml/issues/1945)
- [Styling of qualified associations](https://forum.plantuml.net/19300)
- [Style: Allow theme and style for files list diagram](https://github.com/plantuml/plantuml/issues/1946)
- [Fixing proprietary licenses in PlantUML software package of Replicant project](https://github.com/plantuml/plantuml/issues/1949)
- [Style: Allow stereotype on note for **all** diagram type](https://github.com/plantuml/plantuml/issues/1950)
- [State machine invalid generation for SVG](https://github.com/plantuml/plantuml/issues/1951) _[partial]_
- [State: Composite state error with namespace](https://github.com/plantuml/plantuml/issues/1952)
- [Allow stereotype for Clock on Timing diagram](https://github.com/plantuml/plantuml/pull/1960)
- [Allow stereotype on Timing diagram](https://forum.plantuml.net/15873/style-timing-allow-stereotype-on-timing-diagram)
- [Can we have 2 or more colors for clocks in timing diagrams?](https://forum.plantuml.net/18864)
- [Allow all JSON Values on JSON ](https://github.com/plantuml/plantuml/pull/1970)
- [JSON-type component breaks](https://forum.plantuml.net/16563)
- [Use latest graphviz version in docker image](https://github.com/plantuml/plantuml/pull/1976)
- [Allow (or skip) skin command on YAML diagram](https://github.com/plantuml/plantuml/issues/1978)
- [Fix: error in namespace management](https://github.com/plantuml/plantuml/commit/15d63c28e601fdfa9e985d6d2057db31b95a7079)
- [Allow stereotype for arrow, on sequence diagram](https://forum.plantuml.net/15614/style-sequence-allow-stereotype-for-arrow-sequence-diagram)
- [Allow LineStyle for arrow, on sequence diagram](https://forum.plantuml.net/15612/style-sequence-allow-linestyle-for-arrow-sequence-diagram)
- [Use latex to get string bounder](https://github.com/plantuml/plantuml/pull/1914)
- [tikz: make all fonts with the same baseline](https://github.com/plantuml/plantuml/pull/1919)
- [tikz: avoid latex manager crash for special characters](https://github.com/plantuml/plantuml/pull/1921)
- [tikz: use the same protectText when calc dimension and render](https://github.com/plantuml/plantuml/pull/1922)
- [tikz: optimize latex render](https://github.com/plantuml/plantuml/pull/1923)
- [Optimize tikz render](https://github.com/plantuml/plantuml/pull/1928)
- [Stdlib: Update Cloudogu to v1.0.2](https://github.com/plantuml/plantuml-stdlib/pull/109)
- [Stdlib: Update C4-PlantUML to v2.11.0](https://github.com/plantuml/plantuml-stdlib/pull/110)
- [Stdlib: Update DomainStory-PlantUML to v0.3.1](https://github.com/plantuml/plantuml-stdlib/pull/111)

## V1.2024.7 (Sep 9, 2024)

- [[Class][Deployment] Some issues about arrow between nested elements](https://github.com/plantuml/plantuml/issues/1815)
- [Crash happened on plantuml 1.2024.7beta5, related to "headless"](https://github.com/plantuml/plantuml/issues/1879)
- [hide does not work inside package](https://github.com/plantuml/plantuml/issues/1870)
- [After v1.2023.10, Remove command does not remove nested shapes](https://github.com/plantuml/plantuml/issues/1769)
- [When adding specific note at specific position, activity diagram not work](https://github.com/plantuml/plantuml/issues/1871)
- [Custom Theme loading](https://github.com/plantuml/plantuml/issues/1878)
- [[Creole] Fix <back> color](https://github.com/plantuml/plantuml/issues/1856)
- [repeat starting point is in wrong swimlane](https://github.com/plantuml/plantuml/issues/1874)
- [Generate a svg:title tag when generating Svg](https://github.com/plantuml/plantuml/issues/1877)
- [fix: make native release as snapshot release](https://github.com/plantuml/plantuml/pull/1882)
- [feat: add builtin function %boolval](https://github.com/plantuml/plantuml/pull/1873)
- [feat: add builtin function %mod (modulo operator)](https://github.com/plantuml/plantuml/pull/1865)
- [Added background color to arrows and draw background for circles](https://github.com/plantuml/plantuml/pull/1863)
- [remove duplicate items in help message](https://github.com/plantuml/plantuml/pull/1861)
- [[Sprite][SVG] Manage more SVG functionalities for text](https://github.com/plantuml/plantuml/issues/1855)
- [pdf support broken with other gradle build file changes](https://github.com/plantuml/plantuml/issues/1850)
- [Allow style for backward element on repeat loop, on Activity diagram](https://github.com/plantuml/plantuml/issues/1531)
- [Allow >> and > on the same arrow](https://github.com/plantuml/plantuml/issues/1804)
- [Pause a task up to end of another task](https://github.com/plantuml/plantuml/issues/1838)
- [Rendering issue when nesting different elements](https://github.com/plantuml/plantuml/issues/1550)
- [Allow multiple style stereotypes for Mindmap, WBS](https://github.com/plantuml/plantuml/issues/1527)
- [Gantt: Weekscale with weeknumbers](https://github.com/plantuml/plantuml/issues/525)
- [The utilization of resources does not color red correctly when week partly closed](https://github.com/plantuml/plantuml/issues/1654)
- [Remove and restore not working as expected](https://github.com/plantuml/plantuml/issues/1428)

## V1.2024.6 (Jul 6, 2024)

- [Improve Eclipse Layout Kernel support](https://plantuml.com/elk)
- [groups (e.g. alt) with else cannot be rendered in parallel](https://github.com/plantuml/plantuml/issues/269)
- [alt/else block shown in parallel using teoz leads to wrong formatting](https://github.com/plantuml/plantuml/issues/591)
- [Teoz: Shape of note changes only when "over" is used](https://github.com/plantuml/plantuml/issues/1451)
- [multiple activation of lifelines does not render properly in sequence diagrams](https://github.com/plantuml/plantuml/issues/344)
- [2024.5 breaks https includeurl](https://github.com/plantuml/plantuml/issues/1820)
- [Incorrect object reference in Gantt Chart](https://github.com/plantuml/plantuml/issues/1809)
- [Activity: Allow to style SDL on Repeat While loop](https://github.com/plantuml/plantuml/issues/1707)
- [inconsistent computation of group/alt/opt box size given left or right arrows](https://github.com/plantuml/plantuml/issues/1097)
- [!foreach $key from %get_json_keys() is not found by %json_key_exists(), but works for element access](https://github.com/plantuml/plantuml/issues/1846)
- [Allow scale max on JSON and YAML diagram](https://github.com/plantuml/plantuml/issues/1801)
- [[ELK][Smetana] Allow Fontcolor style on arrows](https://github.com/plantuml/plantuml/issues/1834)
- [[Style][WBS] Change (arrow) line color of a specific branch](https://github.com/plantuml/plantuml/issues/1812)
- [Elk: Allow full style on arrows (except fontcolor)](https://github.com/plantuml/plantuml/pull/1833)
- [feat: math: add newline command for formatting](https://github.com/plantuml/plantuml/pull/1827)
- [feat: add support for [one-line] title to JSON diagram](https://github.com/plantuml/plantuml/pull/1823)
- [Performance issue with JRE21](https://github.com/plantuml/plantuml/issues/1819)
- [Fix parallel group active levels](https://github.com/plantuml/plantuml/pull/1816)
- [Extend @@@format to support more formats](https://github.com/plantuml/plantuml/issues/1810)
- [[teoz] [bug] [sequence] Group becomes too wide when containing activations](https://github.com/plantuml/plantuml/issues/1789)
- [[Theme] sunlust theme does not work for JSON or YAML diagram/data](https://github.com/plantuml/plantuml/issues/1726)

## V1.2024.5 (May 26, 2024)

- [BUG: Activation is offset (Sequence diagram, Teoz)](https://github.com/plantuml/plantuml/issues/656)
- [teoz: activation breaks parallell lines](https://github.com/plantuml/plantuml/issues/739)
- [sequence lifeline height badly depends on message height](https://github.com/plantuml/plantuml/issues/1099)
- [Sequence diagram: Wrong start/end of activation boxes in activation boxes while using teoz](https://github.com/plantuml/plantuml/issues/1494)
- [The display of text, line, and arrow on the left side of the Lifeline is incorrect](https://github.com/plantuml/plantuml/issues/1683)
- [the location of the Comment is INCORRECT](https://github.com/plantuml/plantuml/issues/1679)
- [teoz arrow alignment](https://forum.plantuml.net/13409)
- [activate/deactivate issues](https://forum.plantuml.net/15191)
- [Inline multicast activate only activates the first target](https://forum.plantuml.net/14803)
- [Activation is offset (Using Teoz)](https://forum.plantuml.net/13569)
- [Small rendering difference between default and Teoz](https://forum.plantuml.net/16663)
- [Side effect of variable management when using %json_add](https://github.com/plantuml/plantuml/issues/1783)
- [timing diagram initial concise state](https://github.com/plantuml/plantuml/issues/1708)
- [Java OutOfMemoryError with some Sequence diagrams](https://github.com/plantuml-stdlib/C4-PlantUML/issues/348#issuecomment-2080682947)
- [Smetana is not supporting colors in UML](https://github.com/plantuml/plantuml/issues/1702)
- [Timing: Set background color of concise](https://forum.plantuml.net/18682/timing-set-background-color-of-concise)
- [(timing diagram) message labels ignore default style](https://github.com/plantuml/plantuml/issues/1746)
- ["off by one errors" in text output](https://github.com/plantuml/plantuml/issues/728)
- [hyperlinkUnderline causes NumberFormatException](https://github.com/plantuml/plantuml/issues/1411)
- [Wrong component is highlighted on hover for svginteractive](https://github.com/plantuml/plantuml/issues/1713)
- [[Theme] sunlust theme does not work for JSON or YAML diagram/data](https://github.com/plantuml/plantuml/issues/1726)
- [Stereotype won't be hidden with "hide stereotype"](https://github.com/plantuml/plantuml/issues/1768)
- [[Chen ERD] Allow horizontal layout or left to right direction](https://github.com/plantuml/plantuml/issues/1729)
- [add %splitstrregex builtin function](https://github.com/plantuml/plantuml/pull/1731)
- [ASCIIMathTeXImg.java with a lot of corrections/enhancements](https://github.com/plantuml/plantuml/pull/1767)
- [add new JSON builtin functions (%str2json, %json_add and %json_remove)](https://github.com/plantuml/plantuml/pull/1742)
- [add new JSON builtin function (%json_set)](https://github.com/plantuml/plantuml/pull/1761)
- [add new JSON builtin function (%json_merge)](https://github.com/plantuml/plantuml/pull/1763)
- [Fix on osa2 and Classy](stdlib)

## V1.2024.4 (April 6, 2024)

- [Implement Chen Notation for ER-diagrams](https://github.com/plantuml/plantuml/pull/1718)
- [Add a tool-independent XMI format](https://github.com/plantuml/plantuml/pull/1701)
- [feat: add %get_all_stdlib builtin function](https://github.com/plantuml/plantuml/pull/1696)
- [fix: suppress @[start|end]uml on sunlust theme](https://github.com/plantuml/plantuml/pull/1691)
- [How to extends a generic class](https://github.com/plantuml/plantuml/issues/1672)
- [Negative values causing syntax error in robust "has" list](https://forum.plantuml.net/18701/negative-values-causing-syntax-error-in-robust-has-list)
- [Activity Diagram: Style of multiline Box](https://github.com/plantuml/plantuml/issues/1697)
- [Allow style for multi-line elements on Activity diagram](https://github.com/plantuml/plantuml/issues/1534)
- [EIP standard library](https://github.com/plantuml/plantuml-stdlib/issues/88#issuecomment-1930744100)

## V1.2024.2 (February 14, 2024)

- [Update standard library](stdlib)
- [feat: add %get_all_theme builtin function](https://github.com/plantuml/plantuml/pull/1689)
- [fix: update graphviz version check pattern](https://github.com/plantuml/plantuml/pull/1684)
- [Add theme Sunlust](https://github.com/plantuml/plantuml/pull/1677)
- [feat: Improve new Random function](https://github.com/plantuml/plantuml/pull/1673)
- [Improve Chronology diagram management](https://github.com/plantuml/plantuml/pull/1669)
- [add: Language Descriptor Improvement (adding action and process)](https://github.com/plantuml/plantuml/pull/1643)

## V1.2024.0 (February 1, 2024)

- [EDGY: An Open Source tool for collaborative Enterprise Design](stdlib#6c5e19f750e8f085)
- [Gantt Layout issue when Print between is used with Printscale weekly](https://github.com/plantuml/plantuml/issues/1664)
- [teoz produces odd legend for sequence diagrams](https://forum.plantuml.net/18480/teoz-produces-odd-legend-for-sequence-diagrams)
- [Note invalid position in Directory tree listing](https://forum.plantuml.net/18534/note-invalid-position-in-directory-tree-listing)
- [shape "activity" ist hardly missing](https://github.com/plantuml/plantuml/issues/1631)
- [Allow full local style (for while, repeat) on Activity diagram](https://github.com/plantuml/plantuml/issues/1629)
- [Allow full local style (for if diamonds) on Activity diagram](https://github.com/plantuml/plantuml/issues/1623)
- [Color individual conditional in activity diagram](https://forum.plantuml.net/18457/color-individual-conditional-in-activity-diagram)
- [Bug with activity diagram arrows fork](https://github.com/plantuml/plantuml/issues/1622#issuecomment-1847091587)
- [change the milestone icon from a diamond](https://forum.plantuml.net/18011/is-is-possible-to-change-the-milestone-icon-from-a-diamond)

## V1.2023.13 (December 11, 2023)

- [Javadoc improvement](https://plantuml.github.io/plantuml/javadoc)
- [Bug with activity diagram arrows fork](https://github.com/plantuml/plantuml/issues/1622#issuecomment-1847091587)
- [Is is possible to change the milestone icon from a diamond?](https://forum.plantuml.net/18011/is-is-possible-to-change-the-milestone-icon-from-a-diamond)
- [Gantt crashes with specific Project start dates](https://forum.plantuml.net/18262/gantt-crashes-with-specific-project-start-dates)
- [Add support to style timeline fonts for gantt charts](https://github.com/plantuml/plantuml/issues/1421#issuecomment-1788455745)
- [Directory tree listing](https://github.com/plantuml/plantuml/issues/1448#issuecomment-1820720969)
- [Unable to set MaximumWidth style for legend](https://github.com/plantuml/plantuml/issues/1608)
- [Wrong note shape in sequence diagram when arrow has only one participant](https://github.com/plantuml/plantuml/issues/1609)
- [GANTT: How to handle if a resource starts or terminates at a specific date](https://forum.plantuml.net/18397/gantt-how-handle-resource-starts-terminates-specific-date)
- [Is it possible to set gantt tasks to be incomplete by default](https://forum.plantuml.net/17571/is-it-possible-to-set-gantt-tasks-to-be-incomplete-by-default?show=17571#q17571)
- [[Style] Allow LineThickness style for awesome Actor on Component/UC/Deployment diagram](https://github.com/plantuml/plantuml/issues/1596)
- [[Style] Allow multiple style stereotypes for backward element on Activity diagram](https://github.com/plantuml/plantuml/issues/1538)
- [Syntax error on two and more array items in macros](https://github.com/plantuml/plantuml/issues/1477)

## V1.2023.12 (October 20, 2023)

- [Crash on sample DITAA diagram](https://github.com/plantuml/plantuml/issues/1582)
- [Only one transition permitted to State[H] in state diagram](https://forum.plantuml.net/18282/bug-only-one-transition-permitted-to-state-in-state-diagram)
- [Rendering issue when nesting different elements](https://github.com/plantuml/plantuml/issues/1550)
- [force notes to use inner namespaces not global namespace only](https://github.com/plantuml/plantuml/issues/1405)
- [ASL distribution no longer includes graphiz.dat](https://github.com/plantuml/plantuml/issues/1556)
- [ASL distribution no longer includes OpenIconic SVGs](https://github.com/plantuml/plantuml/issues/1554)

## V1.2023.11 (September 13, 2023)

- [[Style] Allow style for backward element on Activity diagram](https://github.com/plantuml/plantuml/issues/1531)
- [Sequence diagram: Multi-level nested boxes overlaying each other](https://github.com/plantuml/plantuml/issues/1535)
- [Using -cypher does not always recognize restricted words](https://forum.plantuml.net/18151/using-cypher-does-not-always-recognize-restricted-words)
- [Verticals separators in gantt chart don't appear under certain conditions](https://forum.plantuml.net/17187/verticals-separators-gantt-chart-appear-certain-conditions?show=18171#c18171)
- [namespace/package consolidation broke existing remove/restore behaviour when using namespace separators](https://github.com/plantuml/plantuml/issues/1515)
- [Last label on last elseif branch does not get rendered](https://forum.plantuml.net/18157/last-label-on-last-elseif-branch-does-not-get-rendered)
- [no colored border on state start/end](https://forum.plantuml.net/18163/no-colored-border-on-state-start-end)
- [Qualifier labels and associations' lines not correctly drawn for qualified associations](https://github.com/plantuml/plantuml/issues/1467)
- [Notes on conditionnal elements](https://forum.plantuml.net/4696/notes-on-conditionnal-elements?show=18077#c18077)
- [Update C4-PlantUML to v2.8.0](https://github.com/plantuml/plantuml-stdlib/commit/8d03254cf64d85ea0cfa829479e7aab1bf57464a)
- [Handle @start/@end syntax error better](https://github.com/plantuml/plantuml/pull/1522)
- [Adds copy task for graphviz.dat to epl build](https://github.com/plantuml/plantuml/pull/1530)

## V1.2023.10 (July 12, 2023)

- [Exception error when adding note to timing diagram](https://github.com/plantuml/plantuml/issues/1465#issuecomment-1597648143)
- [Skinparam inconsistencies on class diagram grouping elements](https://github.com/plantuml/plantuml/issues/1464#issuecomment-1596916553)
- [Batik SVG rendering: The attribute "width" of the element 'rect' is required](https://github.com/plantuml/plantuml/issues/1459)
- [skinParam fixCircleLabelOverlapping doesn't work anymore](https://github.com/plantuml/plantuml/issues/1460)
- [Using an external style file by pointing to a URL or by using a relative file path doesn't work](https://github.com/plantuml/plantuml/issues/1470)
- [Add regex, files on Embedded Diagram](https://github.com/plantuml/plantuml/commit/357498726736615ba8cd7af9a40ca0bb3e686e8a)

## V1.2023.9 (June 13, 2023)

- [nwdiag possible misbehavior](https://forum.plantuml.net/17932/nwdiag-possible-misbehavior?show=17943#c17943)
- [Replace old ALLOW_PLANTUML_INCLUDE flag](https://github.com/plantuml/plantuml-server/issues/232)
- [sprite transparent issue](https://forum.plantuml.net/17926/sprite-transparent-only-jar-defined-sprites-are-working)
- [Alpha feature: Directory tree listing](https://github.com/plantuml/plantuml/issues/1448)
- [Smetana and ELK: Improve nested elements with last {} declaration](https://github.com/plantuml/plantuml/issues/1442)
- [[Font][Skinparam or Style] Issues on fall back font](https://github.com/plantuml/plantuml/issues/1436)
- [Decimal time values not accepted in parameters or procedures](https://forum.plantuml.net/17885/decimal-time-values-not-accepted-in-parameters-procedures)

## V1.2023.8 (May 21, 2023)

- [First support for regular expression](regex)
- [!theme supports no calculated from path and no stdlib from path](https://forum.plantuml.net/17811/theme-supports-no-calculated-from-path-and-stdlib-from-path)
- [Grammar error occurs when specifying full-width digits with the "as" keyword in timing diagrams](https://forum.plantuml.net/17798/grammar-occurs-specifying-digits-keyword-timing-diagrams)

## V1.2023.7 (May 12, 2023)

- [Activity: Allow to style SDL stereotype](https://github.com/plantuml/plantuml/issues/1423)
- [Activity: Allow post-positioned stereotype style](https://github.com/plantuml/plantuml/issues/1422)
- [specifying full-width digits with the "as" keyword in timing diagrams](https://forum.plantuml.net/17798/grammar-occurs-specifying-digits-keyword-timing-diagrams)
- [force notes to use inner namespaces not global namespace only](https://github.com/plantuml/plantuml/issues/1405)
- [teoz: Support notes on references](https://github.com/plantuml/plantuml/issues/1399)
- [Activity diagram, Case statement, arrow label missing](https://github.com/plantuml/plantuml/issues/1401#issuecomment-1523451970)
- [When connecting attributes between object graphs, the connection error](https://github.com/plantuml/plantuml/issues/1397#issuecomment-1519847197)

## V1.2023.6 (April 18, 2023)

- [Gantt Milestone with Multiline Text Placement](https://forum.plantuml.net/17732/gantt-milestone-with-multiline-text-placement)
- [Start and end nodes can only be styled globally in CSS style](https://github.com/plantuml/plantuml/issues/1394)
- [Gantt diagram - Can't close day in the period of opened days](https://github.com/plantuml/plantuml/issues/1278)
- [Support notes on references](https://github.com/plantuml/plantuml/issues/1382)
- [[gantt] make it possible to color last day](https://github.com/plantuml/plantuml/issues/1367)
- [Is it possible to color the days in the default Gantt Diagram?](https://forum.plantuml.net/14494/is-it-possible-to-color-the-days-in-the-default-gantt-diagram?show=14569#c14569)
- [Automatic font color with gradient participant background creates UnsupportedOperationException](https://github.com/plantuml/plantuml/issues/1389)
- [ConditionStyle InsideDiamond not working for elseif](https://github.com/plantuml/plantuml/issues/657#issuecomment-1505398332)
- [StateBackgroundColor transparent is not effective](https://github.com/plantuml/plantuml/issues/1269)
- [Multible breaks in one repeat](https://github.com/plantuml/plantuml/issues/1369)

## V1.2023.5 (March 24, 2023)

- [Error in generating State Diagram](https://github.com/plantuml/plantuml/issues/1357)
- [Bug - Crowfoot notation on ERD rendering buggy](https://github.com/plantuml/plantuml/issues/1353)
- [Regarding the February update with intermediate namespaces](https://github.com/plantuml/plantuml/issues/1352)
- [Malformed layout and missing arrows on large amount of edges](https://forum.plantuml.net/17654/malformed-layout-and-missing-arrows-on-large-amount-of-edges)
- [Smetana and ELK: Improve arrow position and suppress empty space](https://github.com/plantuml/plantuml/issues/1349)
- [[Class] Note on field is considered unlinked](https://github.com/plantuml/plantuml/issues/1348)
- [How to change direction of arrow in beta syntax in "Activity Diagram"?](https://github.com/plantuml/plantuml/issues/166)
- [Rollback new style](https://github.com/plantuml/plantuml/issues/1286)
- ['help preprocessors' command is not working](https://github.com/plantuml/plantuml/issues/1232)
- [JSON diagram SVG has misplaced arrows when containing newlines](https://github.com/plantuml/plantuml/issues/1334)
- [[Smetana] Allow notes (or comments) on lines or links](https://github.com/plantuml/plantuml/issues/1332)
- [ClassAttributeFont(Style|Size|...) overrides ClassFontStyle(Style|Size|...)](https://github.com/plantuml/plantuml/issues/1335)
- [The command help themes to list all the themes of PlantUML seems broken](https://github.com/plantuml/plantuml/issues/1331)
- [Note and position not rendering correctly on CheerpJ](https://forum.plantuml.net/17600/note-and-position-not-rendering-correctly-on-cheerpj)
- [Ports with similar names](https://github.com/plantuml/plantuml/discussions/1325)
- [Notes linked to messages in Sequence Diagrams](https://forum.plantuml.net/17587/notes-linked-to-messages-in-sequence-diagrams)
- [!global $variable ?= "default variable" produces error "a001"](https://forum.plantuml.net/17566/global-%24variable-default-variable-produces-error-a001)
- [Allow only one underscore when escaping](https://github.com/plantuml/plantuml/pull/1307#issuecomment-1455198456)
- [Using end if as an alias for endif in Activity diagrams](https://github.com/plantuml/plantuml/discussions/1311)
- [Drastic Behavior Change of "as" Parsing with "." (period)](https://github.com/plantuml/plantuml/issues/1309#issuecomment-1459021728)
- [nwdiag bug: group causes element to incorrectly connect to network](https://github.com/plantuml/plantuml/issues/1301)

## V1.2023.4 (March 9, 2023)

- [Allow only one underscore when escaping](https://github.com/plantuml/plantuml/pull/1307#issuecomment-1455198456)
- [Allow only one underscore when escaping](https://github.com/plantuml/plantuml/pull/1307#issuecomment-1455198456)
- [Using end if as an alias for endif in Activity diagrams](https://github.com/plantuml/plantuml/discussions/1311)
- [Ability to hide empty fields for object diagrams](https://github.com/plantuml/plantuml/issues/1304)
- [Namespace association class connection point outside namespace](https://github.com/plantuml/plantuml/issues/1302)
- [Dotted arrow --> is also the close of comment blocks](https://forum.plantuml.net/17507/dotted-arrow-also-the-close-comment-blocks-html-xml-markdown)

## V1.2023.2 (February 26, 2023)

- [.repx file generation](https://github.com/plantuml/plantuml/issues/1296)
- [.repx file generation](https://github.com/plantuml/plantuml/issues/1296)
- [Cannot set long name arrow label in repeat statement with break](https://forum.plantuml.net/17456/can-not-set-long-name-arrow-label-repeat-statement-with-break)
- [together behaves different starting from 1.2023.0](https://github.com/plantuml/plantuml/issues/1282)
- [Possible regression with class alias declaration](https://github.com/plantuml/plantuml/issues/1284#issuecomment-1416427289)
- [The footer is not displayed at the footer](https://github.com/plantuml/plantuml/issues/1085#issuecomment-1383135590)
- [latex and package: no perpendicular corners](https://github.com/plantuml/plantuml/issues/1266)
- [Allow full style on label of Port, Point, Pin](https://github.com/plantuml/plantuml/issues/1265)
- [Structs do not function properly within a namespace](https://forum.plantuml.net/16398/structs-do-not-function-properly-within-a-namespace?show=17286#c17286)
- [Nwdiag problem with address label position on peer network](https://forum.plantuml.net/17283/nwdiag-problem-with-address-label-position-on-peer-network)
- [Update tupadr3 in the stdlib](https://github.com/plantuml/plantuml/issues/1299)

## V1.2023.1 (January 29, 2023)

- [The footer is not displayed at the footer](https://github.com/plantuml/plantuml/issues/1085#issuecomment-1383135590)
- [latex and package: no perpendicular corners](https://github.com/plantuml/plantuml/issues/1266)
- [Allow full style on label of Port, Point, Pin](https://github.com/plantuml/plantuml/issues/1265)
- [What is the best practice for font name definition on skinparam or style](https://github.com/plantuml/plantuml/discussions/1264)
- [Nwdiag problem with address label position on peer network](https://forum.plantuml.net/17283/nwdiag-problem-with-address-label-position-on-peer-network)
- [Support for JSONC (JSON with Comments)](https://forum.plantuml.net/17255/support-for-jsonc-json-with-comments)
- [added sprites keycloak and apache superset](https://github.com/plantuml/plantuml-stdlib/pull/72)
- [Poll/Discussion to confirm current SDL stereotype naming](https://forum.plantuml.net/11518/issues-with-final-separator-latex-math-expression-activity?show=17270#c17270)
- [Composite state functionality with allow_mixing](https://forum.plantuml.net/17275/composite-state-functionality-with-allow_mixing)
- [Style management (error on carbon-gray theme)](https://github.com/plantuml/plantuml/issues/1250)
- [Elements inside together block in namespace belong to root namespace](https://github.com/plantuml/plantuml/issues/1255)
- [User defined style only works for empty elements](https://github.com/plantuml/plantuml/issues/1253)
- [smetana breaks entity arrows](https://forum.plantuml.net/17241/smetana-breaks-entity-arrows)

## V1.2023.0 (January 9, 2023)

- [namespace with slashes in the name](https://forum.plantuml.net/17150/namespace-with-slashes-in-the-name)
- ['skinparam lifelineStrategy solid' is not working as expected](https://github.com/plantuml/plantuml/issues/1212)
- [Box title is not displayed within some themes](https://github.com/plantuml/plantuml/issues/1214)
- [!Include wbs fails generating Syntax Error on line continuations](https://github.com/plantuml/plantuml/issues/1210)
- [Appling different Style to component ignores skinparams for component](https://github.com/plantuml/plantuml/issues/1216#issuecomment-1355336618)
- [Cannot open URL](https://forum.plantuml.net/17086/cannot-open-url)
- [Verticals separators in gantt chart don't appear under certain conditions](https://forum.plantuml.net/17187/verticals-separators-gantt-chart-appear-certain-conditions)
- [Max size for notes](https://github.com/plantuml/plantuml/issues/104#issuecomment-1363753519)
- [Smetana: Allow full style on label of arrows](https://github.com/plantuml/plantuml/issues/1230)
- [Activity diagram: Using if(...) is (...) syntax in ELSEIF](https://forum.plantuml.net/17196/activity-diagram-using-if-is-syntax-in-elseif)
- [Allow 'MaximumWidth' and 'MinimumWidth' on all styles for all diagrams](https://forum.plantuml.net/17215/allow-maximumwidth-and-minimumwidth-all-styles-for-diagrams)
- [package and together closes the parent namespace in class diagram](https://github.com/plantuml/plantuml/issues/1242)
- [smetana breaks hover tooltip](https://forum.plantuml.net/17221/smetana-breaks-hover-tooltip)
- [YAML Multiple highlight defs](https://forum.plantuml.net/15756/yaml-multiple-highlight-defs?show=15757#c15757)
- [Can we use different backgroundcolor for highlight is jsonDiagram ?](https://forum.plantuml.net/17217/can-use-different-backgroundcolor-highlight-jsondiagram)
- [Decreasing visibility of links](https://forum.plantuml.net/2866/decreasing-visibility-of-links?show=15826#c15826)
- [HyperlinkUnderline skinparam is broken](https://github.com/plantuml/plantuml/issues/1241)
- [Yaml diagram highlight wildcard](https://github.com/plantuml/plantuml/issues/1205#issuecomment-1372026537)
- [Ability to add a background color to a component of a network in nwdiag](https://forum.plantuml.net/12733/ability-to-add-background-color-to-component-network-nwdiag)
- [nwdiag: can't change nodes background color](https://github.com/plantuml/plantuml/issues/1224#issuecomment-1362055648)
- [Parsing issue with new style syntax on stereotype class](https://github.com/plantuml/plantuml/issues/1217)
- [Problem with parallel execution of plantuml in Windows](https://forum.plantuml.net/17226/problem-with-parallel-execution-of-plantuml-in-windows)

## V1.2022.14 (December 6, 2022)

- [Link between objet in WBS](https://forum.plantuml.net/16251/link-between-objet-in-wbs)
- [hnote fails to render in txt (ASCII Art)](https://github.com/plantuml/plantuml/issues/1201)
- [Checkmetadata combined with newpage not skipping file creation](https://github.com/plantuml/plantuml/issues/1203)
- [EBNF Special border enhancement](https://forum.plantuml.net/17070/ebnf-special-border-enhancement)
- [StrictUML arrowheads in Activity diagrams](https://forum.plantuml.net/17033/strictuml-arrowheads-in-activity-diagrams?show=17039#c17039)
- [Inline SVG for sprites](https://github.com/plantuml/plantuml/discussions/1066#discussioncomment-4237702)
- [SVG Sprite shows up in PNG output, but SVG Image doesn't](https://github.com/plantuml/plantuml/issues/1199)
- [Transparent background colours on Alt/Else elements](https://forum.plantuml.net/17043/transparent-background-colours-on-alt-else-elements)
- [[Sequence] Improve background color of group with RoundCorner](https://forum.plantuml.net/14423/sequence-improve-background-color-group-with-roundcorner?show=14459#c14459)
- [Boolean builtin functions](https://forum.plantuml.net/17031/boolean-builtin-functions?show=17045#c17045)
- [prevent wrap for comma, dot, etc...](https://forum.plantuml.net/17019/prevent-wrap-for-comma-dot-etc?show=17025#c17025)

## V1.2022.13 (November 19, 2022)

- [substr does not work if strings are added in the same line](https://forum.plantuml.net/16980/%25substr-%24variable-does-not-work-strings-are-added-same-line)
- [Center-aligned text not in the middle of a node](https://forum.plantuml.net/16985/center-aligned-text-not-in-the-middle-of-a-node)
- [skinparam ArrowHeadColor none doesn't work as expected on note node](https://github.com/plantuml/plantuml/issues/1190)
- [awslib/Mobile/Mobile.puml is black](https://github.com/plantuml/plantuml-stdlib/issues/63#issuecomment-1314774419)
- [Arrow position and size in timing diagram](https://forum.plantuml.net/16984/arrow-position-and-size-in-timing-diagram)
- [Internal Server Error: !if -1 == -1yyyyyy](https://forum.plantuml.net/16937/internal-server-error-if-1-1)
- [Timing diagram: invalid display with only on state in concise](https://forum.plantuml.net/16930/timing-diagram-invalid-display-with-only-on-state-in-concise)
- [Unicode inside sub diagram is not shown ok](https://forum.plantuml.net/16928/unicode-inside-sub-diagram-is-not-show-ok)
- [EBNF - Allow special sequence management with special-sequence-symbol "?"](https://forum.plantuml.net/16781/allow-special-sequence-management-special-sequence-symbol)
- [Adding support nested sub-diagrams](https://github.com/plantuml/plantuml/pull/1176)
- [Why can't is set "open" and "colored" on the same line ?](https://forum.plantuml.net/17009/why-cant-is-set-open-and-colored-on-the-same-line)
- [How can I define note with stereotype?](https://forum.plantuml.net/13616/how-can-i-define-note-with-stereotype)
- [Style for note on Component and Deployement diagram, Class,...](https://forum.plantuml.net/11645/style-for-note-on-component-and-deployement-diagram-class)
- [how to hide the vertical grid-lines in timming diagram?](https://forum.plantuml.net/16996/how-to-hide-the-vertical-grid-lines-in-timming-diagram)
- [How can I apply a style or background color to a note on a class method?](https://forum.plantuml.net/16971/how-can-apply-style-or-background-color-to-note-class-method)

## V1.2022.12 (October 23, 2022)

- [Important change on Gantt Diagram](gantt-diagram)
- [EBNF - Allow empty definition](https://forum.plantuml.net/16779/ebnf-allow-empty-definition)
- [EBNF add notes](https://forum.plantuml.net/16694/ebnf-add-notes)
- [EBNF - Allow full repetition management with repetition-symbol "*"](https://forum.plantuml.net/16750/ebnf-allow-full-repetition-management-with-repetition-symbol)
- [colors on concise timeline in timing diagram don't respect line color](https://forum.plantuml.net/16809/colors-concise-timeline-timing-diagram-dont-respect-color)
- [Need to allow dashes in entity names](https://forum.plantuml.net/1021/need-to-allow-dashes-in-entity-names?show=16794#c16794)
- [[Style] Allow [all] style for mainframe](https://forum.plantuml.net/16588/style-allow-all-style-for-mainframe)
- [[Style] Allow [all] style for JSON object](https://forum.plantuml.net/16644/style-allow-all-style-for-json-object?show=16712#c16712)
- [[Style] Allow [all] style for stereotype on Activity diagram](https://forum.plantuml.net/16711/style-allow-all-style-for-stereotype-on-activity-diagram)
- [hide @unlinked fails in case of component {} notation](https://forum.plantuml.net/16657/hide-%40unlinked-fails-in-case-of-component-notation)
- [Spaces in Markdown syntax in MindMap](https://forum.plantuml.net/13669/spaces-in-markdown-syntax-in-mindmap?show=16667#c16667)
- [WBS Diagram: HyperlinkUnderline false](https://forum.plantuml.net/16630/wbs-diagram-hyperlinkunderline-false)
- [Gantt: diff between days and working days](https://forum.plantuml.net/13434/gantt-milestone-bug?show=16587#c16587)
- [cannot follow extends by string in class diagram](https://github.com/plantuml/plantuml/issues/1142)
- [multiline in mindmap: latex/math formula can only stay in oneline](https://github.com/plantuml/plantuml/issues/1123)
- [Add support for MetaClass and Stereotype in class diagram](https://github.com/plantuml/plantuml/pull/1159)
- [bullet list bug](https://github.com/plantuml/plantuml/issues/1158)
- [C4-PlantUML: AddComponentTag uses default component font color](https://github.com/plantuml/plantuml-stdlib/pull/60)

## V1.2022.8 (September 25, 2022)

- [Alpha support for EBNF](https://forum.plantuml.net/16529/could-we-add-syntax-diagrams)
- [multiline in mindmap: latex/math formula can only stay in oneline](https://github.com/plantuml/plantuml/issues/1123)
- [usecase: business usecase with multiline description](https://forum.plantuml.net/16516/usecase-business-usecase-with-multiline-description)
- [How to style partition (group, package or card) like rectangle on Activity diagram?](https://forum.plantuml.net/16505/style-partition-group-package-rectangle-activity-diagram)
- [Packages loose skinparameters with nested elements](https://github.com/plantuml/plantuml/issues/1000)
- [Frame header font style](https://forum.plantuml.net/16497/frame-header-font-style)
- ["remove @unlinked" doesn't remove nodes if links were removed by "remove $tag"](https://forum.plantuml.net/16485/remove-%40unlinked-doesnt-remove-nodes-links-removed-remove)
- [Hide empty descriptions removes inline style in State Diagram](https://forum.plantuml.net/13655/hide-empty-descriptions-removes-inline-style-state-diagram?show=16487#c16487)
- [State diagram causes UnsupportedOperationException with smetana](https://forum.plantuml.net/15660/composete-diagram-unsupportedoperationexception-smetana)
- [[Smetana] Frame title missing and links to the frame missing](https://github.com/plantuml/plantuml/issues/863)
- [SCXML files generated from state diagrams don't preserve state hierarchies](https://github.com/plantuml/plantuml/issues/1101)
- [How to color note on link](https://github.com/plantuml/plantuml/issues/1105)
- [Static classes](https://forum.plantuml.net/12645/static-classes?show=16413#c16413)
- [& a -> b crashes teoz](https://github.com/plantuml/plantuml/issues/1096)
- [Add qualified associations to class diagrams](https://forum.plantuml.net/16397/add-qualified-associations-to-class-diagrams)
- [Attribute visibility on association names do not show with classAttributeIconSize 0](https://forum.plantuml.net/16412/attribute-visibility-association-classattributeiconsize)
- ["on the same row" breaks when used on self](https://forum.plantuml.net/16415/on-the-same-row-breaks-when-used-on-self)
- [Max size for notes](https://github.com/plantuml/plantuml/issues/104#issuecomment-1223801774)
- [How to use textcolor for rectangle?](https://forum.plantuml.net/16373/how-to-use-textcolor-for-rectangle)
- [BUG: rendering state with local transition and using StateBackgroundColor style](https://github.com/plantuml/plantuml/issues/1090)
- [Gantt Chart Vertical Separators](https://forum.plantuml.net/16247/gantt-chart-vertical-separators)

## V1.2022.7 (August 22, 2022)

- [Could you improve port management?](https://forum.plantuml.net/16071/deployment-could-you-improve-port-management)
- [Error when mixed use of class,card and portin portout](https://forum.plantuml.net/16320/error-when-mixed-use-of-class-card-and-portin-portout)
- [Coloring single ports](https://forum.plantuml.net/16306/coloring-single-ports)
- [Error when using map and portin/portout in a component](https://forum.plantuml.net/16261/error-when-using-map-and-portin-portout-in-a-component)
- [Inline SVG for sprites](https://github.com/plantuml/plantuml/discussions/1066)
- [Why does plus change from name of Map key to comment?](https://forum.plantuml.net/16303/why-does-plus-change-from-name-of-map-key-to-comment)
- [improve descendant pseudo selector on Mindmap](https://forum.plantuml.net/12422/beta-style-improve-descendant-pseudo-selector-on-mindmap?show=16276#c16276)
- [Declare Participants similar to Components](https://forum.plantuml.net/15232/declare-participants-similar-to-components?show=16269#c16269)
- [How to left align when the AWS lib is also used?](https://forum.plantuml.net/16284/how-to-left-align-when-the-aws-lib-is-also-used)
- [Gantt diagram - how to start a project a number of days before today?](https://forum.plantuml.net/16285/gantt-diagram-how-to-start-project-number-days-before-today)
- [SVG generate embedded image](https://github.com/plantuml/plantuml/issues/1053)
- [Is it possible to add line color and thickness to analog variables?](https://forum.plantuml.net/16198/is-it-possible-add-line-color-and-thickness-analog-variables)
- [Timing Diagram: Adding double arrows to analog signal type](https://forum.plantuml.net/16197/timing-diagram-adding-double-arrows-to-analog-signal-type)
- [Bug in class diagram member to member connection if naming is similar and contains underscores](https://forum.plantuml.net/16185/diagram-connection-similar-contains-underscores-version)
- [NPE observed during local theme testing](https://github.com/plantuml/plantuml/issues/1035)
- [Characters « and » not allowed in participant titles (sequence diagrams)](https://github.com/plantuml/plantuml/issues/1045)
- [Map can not set color of line](https://github.com/plantuml/plantuml/issues/1047#issuecomment-1160565309)
- [The horizontal alignment style does not work correctly.](https://forum.plantuml.net/16147/the-horizontal-alignment-style-does-not-work-correctly)
- [Scenario in Ditaa that "hangs" PlantUML](https://github.com/plantuml/plantuml/issues/1036)
- [YAML Diagram - Unable to render elements where key has a space](https://github.com/plantuml/plantuml/issues/1039)
- [Plantuml draw odd line](https://forum.plantuml.net/14145/plantuml-draw-odd-line?show=16139#c16139)
- [rocket emoji causes UnsupportedOperationException](https://github.com/plantuml/plantuml-server/issues/231)
- [The mindmap's root node could never be centered now](https://forum.plantuml.net/16056/the-mindmaps-root-node-could-never-be-centered-now?show=16070#c16070)
- [replace printStackTrace by java.util.logging.Logger](https://github.com/plantuml/plantuml/pull/1088)

## V1.2022.6 (June 21, 2022)

- [SVG images using creole img don't support scaling](https://github.com/plantuml/plantuml/issues/1022)
- [Regression in skinparam participant stereo behavior losing styling](https://github.com/plantuml/plantuml/issues/1023)
- [Is it possible to link elements from two jsons, with both jsons embeded ?](https://forum.plantuml.net/15481/possible-link-elements-from-two-jsons-with-both-jsons-embeded?show=16047#c16047)
- [Element line style not applied in usecase diagram](https://forum.plantuml.net/15983/element-line-style-not-applied-in-usecase-diagram?show=16048#c16048)
- [Creole trees do not respect indent levels in a Class diagram](https://forum.plantuml.net/16042/creole-trees-do-not-respect-indent-levels-in-a-class-diagram)
- [error when using indented elements as ports](https://forum.plantuml.net/16039/error-when-using-indented-elements-as-ports)
- [Business usecase or "usecase/" does not work when "allow_mixing"](https://forum.plantuml.net/16046/business-usecase-or-usecase-does-not-work-when-allow_mixing)
- [Display year in timing diagrams using time and date](https://github.com/plantuml/plantuml/issues/1020)
- [Element line style not applied in usecase diagram](https://forum.plantuml.net/15983/element-line-style-not-applied-in-usecase-diagram)
- [Plantuml draw odd line](https://forum.plantuml.net/14145/plantuml-draw-odd-line?show=15972#c15972)
- [How do I mark a binary as indeterminate in a timing diagram?](https://forum.plantuml.net/15933/how-do-i-mark-a-binary-as-indeterminate-in-a-timing-diagram)
- [For timing diagram binary data, allow data to be indetermine](https://forum.plantuml.net/11936/for-timing-diagram-binary-data-allow-data-to-be-indetermine)
- [Latex generation fails with \t in front of html tag](https://github.com/plantuml/plantuml/issues/1016)
- [[Timing][Style] Allow all Style for timeline, on timing diagram](https://forum.plantuml.net/15936/timing-style-allow-all-style-for-timeline-on-timing-diagram)
- [overlapped groups in nwdiag throws exception](https://forum.plantuml.net/15919/overlapped-groups-in-nwdiag-throws-exception)
- [Missing state fork/join in plain theme](https://github.com/plantuml/plantuml/issues/1008)
- [No way to add a note text next to a switch case branch in activity diagrams beta](https://github.com/plantuml/plantuml/issues/577#issuecomment-1116117741)
- [Is the skinparam ArrowHeadColor no longer available?](https://forum.plantuml.net/16080/is-the-skinparam-arrowheadcolor-no-longer-available)

## V1.2022.5 (April 30, 2022)

- [White-space management on stereotype](https://github.com/plantuml/plantuml/issues/975)
- [Stereotype/skinparam with spaces in the name are not working anymore](https://forum.plantuml.net/15839/stereotype-skinparam-with-spaces-the-name-working-anymore)
- [BetaStyle for timingDiagram](https://forum.plantuml.net/15475/betastyle-for-timingdiagram)
- [Allow stereotype on Timing diagram](https://forum.plantuml.net/15873/style-timing-allow-stereotype-on-timing-diagram)
- [Allow handwritten on file, stack and note](https://forum.plantuml.net/15878/component-deployment-allow-handwritten-file-stack-and-note)
- [Fix several visual regression](https://forum.plantuml.net/15888/what-are-plans-visual-long-term-stability-plantuml-diagrams)
- [Skinparam Shadowing true not working anymore](https://forum.plantuml.net/15879/skinparam-shadowing-true-not-working-anymore)
- [Standard Library update](stdlib)

## V1.2022.4 (April 9, 2022)

- [V1.2022.1: legitimate error message lost in a lot of logs](https://github.com/plantuml/plantuml/issues/985)
- [map do not show members and fluffy arrows](https://forum.plantuml.net/15837/map-do-not-show-members-and-fluffy-arrows)
- [Bug with ArchiMate shapes](https://forum.plantuml.net/15817/bug-with-archimate-shapes?show=15830#c15830)
- [Restore ability to change background color of class/entity header](https://github.com/plantuml/plantuml/pull/980)
- [Have more than one Hyperlink text color](https://forum.plantuml.net/8071/have-more-than-one-hyperlink-text-color?show=15818#c15818)
- [1.2022.2 regression: SVG does not include connections if notes are used](https://github.com/plantuml/plantuml/issues/983)
- [1.2022.3 regression: NPE @ TikzGraphics.getColorName](https://github.com/plantuml/plantuml/issues/974)
- [Annotate binary waveforms](https://forum.plantuml.net/15762/annotate-binary-waveforms)
- [[Activity][Style] Allow full style on diamond (e.g. internal label and external label)](https://forum.plantuml.net/14529/activity-style-allow-style-diamond-internal-label-external?show=15726#c15726)

## V1.2022.3 (March 29, 2022)

- [Annotate binary waveforms](https://forum.plantuml.net/15762/annotate-binary-waveforms)
- [Bold arrows via skinparam are not working anymore](https://forum.plantuml.net/15747/bold-arrows-via-skinparam-are-not-working-anymore)
- [Composite state diagram causes UnsupportedOperationException with smetana](https://forum.plantuml.net/15660/composete-diagram-unsupportedoperationexception-smetana)
- [Wrong colors in generated EPS file](https://forum.plantuml.net/15621/wrong-colors-in-generated-eps-file)
- [AmazonS3_LARGE seems to be an error in 1.2022.2](https://github.com/plantuml/plantuml/issues/960)
- [[Style][Sequence] Allow stereotype for arrow, on sequence diagram](https://forum.plantuml.net/15614/style-sequence-allow-stereotype-for-arrow-sequence-diagram)
- [1.2022.2 regression - black backgrounds](https://github.com/plantuml/plantuml/issues/947)
- [Crash when note on object member](https://forum.plantuml.net/15609/crash-when-note-on-object-member)

## V1.2022.2 (March 5, 2022)

- [New default style](https://twitter.com/PlantUML/status/1491847768436060168)
- [Use of CSS styles](style-evolution)
- [Stereotypes cannot be overwritten anymore](https://forum.plantuml.net/15584/stereotypes-cannot-be-overwritten-anymore)
- [BorderStyle dashed not working anymore](https://forum.plantuml.net/15583/borderstyle-dashed-not-working-anymore)
- [Mostly Getting Cannot decode Image Error](https://forum.plantuml.net/15343/mostly-getting-cannot-decode-image-error)
- [Gantt with Weekly Scale bugs](https://forum.plantuml.net/15577/gantt-with-weekly-scale-bugs)
- [New json entity](https://forum.plantuml.net/15481/possible-link-elements-from-two-jsons-with-both-jsons-embeded?show=15550#c15550)
- [Skinparam ArrowColor cannot be combined via multiple stereotypes](https://forum.plantuml.net/13245/skinparam-arrowcolor-cannot-combined-multiple-stereotypes)
- [stereotype priorities changed compared to older implementations](https://forum.plantuml.net/15544/stereotype-priorities-changed-compared-implementations)
- [skinparam DefaultFontColor overwrittes all existing font color definitions](https://forum.plantuml.net/15539/skinparam-defaultfontcolor-overwrittes-existing-definitions)
- [How to generate a legend with colors in PlantUML](https://forum.plantuml.net/3596/how-to-generate-a-legend-with-colors-in-plantuml)
- [Error when using "-" as double arrow for styles](https://forum.plantuml.net/15497/error-when-using-as-double-arrow-for-styles)
- [BorderColor and BackgroundColor set to "None" returns a java.lang.NullPointerException from Graphviz](https://forum.plantuml.net/15471/bordercolor-backgroundcolor-nullpointerexception-graphviz?show=15496#c15496)
- ["Normal" rectangles corners, "package" rectangles text colors are not supported anymore](https://forum.plantuml.net/15473/rectangles-corners-package-rectangles-supported-anymore)
- [Line styles are not supported anymore](https://forum.plantuml.net/15448/line-styles-are-not-supported-anymore)
- ["Default" line colors are not supported anymore](https://forum.plantuml.net/15458/default-line-colors-are-not-supported-anymore)
- ["Fork" line not appearing in many built-in themes for Activity Diagrams](https://forum.plantuml.net/15451/fork-line-not-appearing-many-built-themes-activity-diagrams)
- [New %json_key_exists() function](https://forum.plantuml.net/15423/functions-check-exists-default-value-get_variable_value)
- [New %splitstr() function](https://forum.plantuml.net/15374/delimited-string-split-into-an-array?show=15387#c15387)
- [Allow new styling for nested package](https://forum.plantuml.net/15386/allow-new-styling-for-nested-package)

## V1.2022.1 (February 1, 2022)

- [Added start Stereotype](https://github.com/plantuml/plantuml/pull/887)
- [fix: nwdiag server or element name with special char](https://github.com/plantuml/plantuml/pull/864)
- [Xmi export for Sequence Diagrams](https://github.com/plantuml/plantuml/pull/845)
- [New styling not working for nesting elements](https://forum.plantuml.net/15372/new-styling-not-working-for-nesting-elements)
- [ideas for 2 new json builtins](https://forum.plantuml.net/15360/ideas-for-2-new-json-builtins)
- [Activity: Strange glitch repeat loop](https://forum.plantuml.net/15354/activity-strange-glitch-repeat-loop)
- [private/public indicators are not always present in state diagramm](https://forum.plantuml.net/15352/private-public-indicators-are-always-present-state-diagramm)
- [Add capability to nest state diagrams in package or frame](https://forum.plantuml.net/15340/add-capability-to-nest-state-diagrams-in-package-or-frame)
- [skinparam Dpi causes exception](https://github.com/plantuml/plantuml/issues/867)
- [groupInheritance cause NullPointerException](https://github.com/plantuml/plantuml/issues/866)
- [backward in repeat loop in the wrong swimlane](https://forum.plantuml.net/15304/backward-in-repeat-loop-in-the-wrong-swimlane)
- [Some diagram description contains errors](https://forum.plantuml.net/15296/some-diagram-description-contains-errors)
- [How to set color of the Gantt unstarted task](https://forum.plantuml.net/15299/how-to-set-color-of-the-gantt-unstarted-task)
- [Multiline backward statements in Activity Diagram](https://github.com/plantuml/plantuml/issues/855)
- [Dark mode](https://github.com/plantuml/plantuml/discussions/882)

## V1.2022.0 (January 11, 2022)

- [Use of Emoji](https://github.com/plantuml/plantuml/discussions/820)
- [Declare Participants similar to Components](https://forum.plantuml.net/15232/declare-participants-similar-to-components)
- [Xmi export for Sequence Diagrams](https://github.com/plantuml/plantuml/pull/845)
- [Why not to support nested boxes in sequence diagrams?](https://forum.plantuml.net/4957/why-not-to-support-nested-boxes-in-sequence-diagrams?show=4957#q4957)
- [Class Diagram can't extends inner class](https://forum.plantuml.net/15194/class-diagram-cant-extends-inner-class?show=15194#q15194)
- [Preprocessor function %lighten](https://forum.plantuml.net/15195/preprocessor-function-%25lighten)
- [Question related to 'Working with Resources' feature in Gantt charts](https://forum.plantuml.net/15211/question-related-working-with-resources-feature-gantt-charts)
- [Potential infinite loop on timing diagram](https://github.com/plantuml/plantuml/issues/836)
- [Crash when try to use named as reference](https://github.com/plantuml/plantuml/issues/835#issuecomment-998623186)
- [WBS: missing link and missing box](https://forum.plantuml.net/15159/wbs-missing-link-and-missing-box)

## V1.2021.16 (December 8, 2021)

- [Broadcast, multicast in sequence diagrams crashes with theme](https://forum.plantuml.net/15121/broadcast-multicast-sequence-diagrams-crashes-with-theme)
- [Beta support for Emoji](https://github.com/plantuml/plantuml/discussions/820)

## V1.2021.15 (November 30, 2021)

- [change default JSON/YAML theme](json)
- [Support for URL authentication](url-authentication)
- [Hide footbox breaks network diagram](https://github.com/plantuml/plantuml/issues/800)
- [add: hide as NOP on style for JSON or YAML diagram](https://github.com/plantuml/plantuml/pull/802)
- [Changing the color of both fork and join states](https://github.com/plantuml/plantuml/issues/794)
- [Multiroot Mindmap](https://github.com/plantuml/plantuml/issues/773)
- [Style tag breaks rendering in deployment diagram](https://forum.plantuml.net/14996/style-tag-breaks-rendering-in-deployment-diagram)
- [Sequence: Lifeline color missing on in/out messages with teoz](https://forum.plantuml.net/14973/sequence-lifeline-color-missing-on-in-out-messages-with-teoz)
- [theme in search path](https://forum.plantuml.net/14938/custom-themes-dont-require-from-folder-if-theme-search-path)
- [Improve hyperlink support for dark theme](https://forum.plantuml.net/14940/granular-hyperlinkcolor)
- [New %size() function](https://forum.plantuml.net/14901/number-of-elements-in-list-during-json-preprocessing)
- [New %chr() function](https://forum.plantuml.net/14925/why-cant-i-compare-character-json-u0022-with-u-0022)
- [Suppress delay for more than a minute before exiting](https://forum.plantuml.net/15083/does-puml-file-cause-java-delay-more-than-minute-before-exiting)

## V1.2021.14 (November 12, 2021)

- [Typo in error message](https://forum.plantuml.net/14905/typo-in-error-message)
- [Sequence: Lifeline color missing on in/out messages with teoz](https://forum.plantuml.net/14973/sequence-lifeline-color-missing-on-in-out-messages-with-teoz)
- [Custom Themes: Don't require "from folder" if theme is in search path](https://forum.plantuml.net/14938/custom-themes-dont-require-from-folder-if-theme-search-path)
- [Improve theme support](https://github.com/plantuml/plantuml/issues/700#issuecomment-963837840)
- [Improve chinese text supports word wraps](https://forum.plantuml.net/14830/something-planed-that-chinese-text-supports-word-wraps-too)
- [Description on an returning arrow of repeat is not rendered](https://github.com/plantuml/plantuml/issues/727)
- [The combination of while, if, note, and break statements does not draw the figure.](https://forum.plantuml.net/14819/the-combination-while-note-break-statements-does-draw-figure)
- [Issues with switch in the activity diagram](https://github.com/plantuml/plantuml/issues/722)
- [Using AWSPuml and code causes Java error](https://forum.plantuml.net/14804/using-awspuml-and-code-causes-java-error)
- [Use style with map](https://forum.plantuml.net/14714/can-we-apply-style-to-map?show=14714#q14714)
- [Add new chr(), size() and loadJSON() functions in preprocessor](preprocessing)
- [Fix folder width growing with length of alias](https://github.com/plantuml/plantuml/pull/735)
- [Improve transparent support](https://github.com/plantuml/plantuml/pull/751)
- [Better themes support](https://github.com/plantuml/plantuml/tree/master/themes)

## V1.2021.13 (November 1, 2021)

- [Update Smetana arrow colors](https://github.com/plantuml/plantuml/pull/738)
- [Fix folder width growing with length of alias](https://github.com/plantuml/plantuml/pull/735)
- [Fix Braille text descent calculation](https://github.com/plantuml/plantuml/pull/732)
- [Update C4-PlantUML to v2.4.0](https://github.com/plantuml/plantuml-stdlib/pull/49)
- [Update awslib to iconset 10.0.0 2021.04.30](https://github.com/plantuml/plantuml-stdlib/pull/46)
- [Is something planed that chinese text supports word wraps too](https://forum.plantuml.net/14830/something-planed-that-chinese-text-supports-word-wraps-too)
- [Description on an returning arrow of repeat is not rendered](https://github.com/plantuml/plantuml/issues/727)
- [The combination of while, if, note, and break statements does not draw the figure.](https://forum.plantuml.net/14819/the-combination-while-note-break-statements-does-draw-figure)
- [Additional text for elseif missing when using "useVerticalIf"](https://forum.plantuml.net/14810/additional-text-for-elseif-missing-when-using-useverticalif)
- [Issues with switch in the activity diagram](https://github.com/plantuml/plantuml/issues/722)
- [Using AWSPuml and code causes Java error](https://forum.plantuml.net/14804/using-awspuml-and-code-causes-java-error)
- [Can we apply style to map?](https://forum.plantuml.net/14714/can-we-apply-style-to-map?show=14714#q14714)

## V1.2021.12 (October 5, 2021)

- [Add ability to contol placement of a constraint in a timing diagram](https://forum.plantuml.net/11937/add-ability-to-contol-placement-constraint-timing-diagram)
- [[Activity][Style] Allow full style on diamond (e.g. internal label and external label)](https://forum.plantuml.net/14529/activity-style-allow-style-diamond-internal-label-external)

## V1.2021.11 (October 2, 2021)

- [timing diagrams: can we get an "offset" for clocks](https://forum.plantuml.net/14647/timing-diagrams-can-we-get-an-offset-for-clocks)
- [Optional signal name for clock signals](https://forum.plantuml.net/14631/optional-signal-name-for-clock-signals)
- [Possible bug in nwdiag](https://forum.plantuml.net/14589/possible-bug-in-nwdiag)
- [[Style][State] Allow FontColor style on State](https://forum.plantuml.net/14554/style-state-allow-fontcolor-style-on-state)
- [[Style][Object] Allow style on Object diagram](https://forum.plantuml.net/14563/style-object-allow-style-on-object-diagram)
- [Crash in ganttDiagram with style and progress > 100%](https://forum.plantuml.net/14558/crash-in-ganttdiagram-with-style-and-progress-100%25)
- [[Style] Allow style on nwdiag Diagram](https://forum.plantuml.net/14479/style-allow-style-on-nwdiag-diagram)
- [Is it possible to color the days in the default Gantt Diagram](https://forum.plantuml.net/14494/is-it-possible-to-color-the-days-in-the-default-gantt-diagram)
- [Activity [beta] broken switch/case arrows when using kill/detach](https://forum.plantuml.net/14515/activity-beta-broken-switch-case-arrows-when-using-kill-detach)
- [skinparam shadowing in nwdiag](https://forum.plantuml.net/14516/skinparam-shadowing-in-nwdiag)
- [Cannot easily customize note on class members](https://forum.plantuml.net/14530/cannot-easily-customize-note-on-class-members)
- [[Sequence] Improve background color of group with RoundCorner](https://forum.plantuml.net/14423/sequence-improve-background-color-group-with-roundcorner)

## V1.2021.10 (August 30, 2021)

- [Nwdiag Issue (on other internal networks) with the new layout engine](https://forum.plantuml.net/14458/nwdiag-issue-other-internal-networks-with-the-layout-engine)
- [nwdiag group description can intersect with ip address](https://forum.plantuml.net/14403/nsdiag-group-description-can-intersect-with-ip-address)
- [Allow Shadowing with RoundCorner on sequence reference](https://forum.plantuml.net/14442/style-allow-shadowing-with-roundcorner-sequence-reference)
- [Improve background color of group with RoundCorner](https://forum.plantuml.net/14423/sequence-improve-background-color-group-with-roundcorner)
- [Broken diagram with nested rectangles and remove @unlinked](https://forum.plantuml.net/14092/broken-diagram-with-nested-rectangles-and-remove-%40unlinked?show=14094#c14094)
- [Locale DE showing Month Number not Name](https://forum.plantuml.net/14190/locale-de-showing-month-number-not-name?show=14218#c14218)
- [Task is paused, but this did not subtract allocation](https://forum.plantuml.net/14251/paused-subtract-allocation-resource-status-oversubscribed)
- [Differences between PNG and SVG outputs, for circles on JSON or YAML diagram](https://forum.plantuml.net/14407/differences-between-png-outputs-circles-json-yaml-diagram)
- ["!pragma teoz true" ignores border color of participant activation box](https://forum.plantuml.net/14339/pragma-teoz-true-ignores-border-color-participant-activation)
- [color of arrow in timing diagram](https://forum.plantuml.net/14340/color-of-arrow-in-timing-diagram)
- [Using parenthesis in object diagram field values](https://forum.plantuml.net/14341/using-parenthesis-in-object-diagram-field-values)
- [Hyphen in node id causes syntax error](https://forum.plantuml.net/14346/hyphen-in-node-id-causes-syntax-error)
- [Allow RoundCorner on sequence reference](https://forum.plantuml.net/14383/style-allow-roundcorner-on-sequence-reference)
- [Styling descendents error in WBS diagrams](https://forum.plantuml.net/14362/styling-descendents-error-in-wbs-diagrams)
- [Regular expression denial of service using very long and never ending arrow](https://github.com/plantuml/plantuml/issues/624)
- [Ensure that PlantUML does not crash when EmbeddedDiagram meets wrap_width.](https://forum.plantuml.net/14247/ensure-that-plantuml-crash-embeddeddiagram-meets-wrap_width)
- [Switch arrow doesn't get drawn with end in activity diagram](https://forum.plantuml.net/14173/switch-arrow-doesnt-get-drawn-with-end-in-activity-diagram)
- [Plant UML Gantt Diagram: persentage completed determines color of task-bar](https://forum.plantuml.net/8297/plant-gantt-diagram-persentage-completed-determines-color)

## V1.2021.9 (July 25, 2021)

- [Encoding error with nested diagrams](https://forum.plantuml.net/13983/encoding-error-with-nested-diagrams?show=14127#c14127)
- [Sequence diagram incoming/outgoing some arrows are inverted](https://forum.plantuml.net/14104/sequence-diagram-incoming-outgoing-some-arrows-are-inverted)
- [Udpate of some stdlib (archimate, azure, C4, cloudinsight, kubernetes, logos)](stdlib)
- [Management on CLI of -P option](https://github.com/plantuml/plantuml/issues/582)
- [Adding new Preprocessing Builtin functions (%dec2hex, %hex2dec, %hsl_color)](https://forum.plantuml.net/14128)
- [On switch-case, horizontal line missing 'case-diamond'](https://forum.plantuml.net/13954/activity-switch-horizontal-missing-diamond-last-kill-detach)

## V1.2021.8 (June 26, 2021)

- [Removed JavaScript engine from Math](https://plantuml.com/ascii-math)
- [Add an eval function on Preprocessing Builtin functions](https://forum.plantuml.net/12277/add-an-eval-function-on-preprocessing-builtin-functions)
- [[Activity] Switch/Case - Notes are not working](https://forum.plantuml.net/14015/activity-switch-case-notes-are-not-working)
- [Calendar locale (German) for PlantUML gantt diagrams](https://stackoverflow.com/questions/66087145/calendar-locale-german-for-plantuml-gantt-diagrams)
- [Note text has no text alignment skinparam & default alignment is not applied](https://github.com/plantuml/plantuml/issues/134)
- [using exitPoint stereotype in parallelized state causes plantuml to render a NullPointerException](https://github.com/plantuml/plantuml/issues/565)
- [Encoding error with nested diagrams](https://forum.plantuml.net/13983/encoding-error-with-nested-diagrams?show=13983#q13983)
- [Expose as a builtin functions a color reverse function](https://forum.plantuml.net/13888/preprocessing-expose-builtin-functions-reverse-function)
- [License output broken](https://github.com/plantuml/plantuml/issues/575)
- [Feature: Gantt progress](https://forum.plantuml.net/10679/feature-gantt-progress?show=14108#c14108)
- [How prevent PlantUML from creating error images?](https://forum.plantuml.net/14067/how-prevent-plantuml-from-creating-error-images)

## V1.2021.7 (May 23, 2021)

- [Plantuml generating invalid link example:](https://forum.plantuml.net/13886/plantuml-generating-invalid-example-plantuml-written-beside)
- [Bug Report: automatic text color will crash if participant body includes icon](https://forum.plantuml.net/13879/report-automatic-text-color-will-crash-participant-includes)
- [Crash when using @startnwdiag](https://forum.plantuml.net/13837/crash-when-using-%40startnwdiag?show=13841#c13841)
- [Missing arrowheads in sequence diagram](https://forum.plantuml.net/13843/missing-arrowheads-in-sequence-diagram?show=13846#c13846)
- [An error has occured : java.lang.UnsupportedOperationException](https://forum.plantuml.net/13848/error-has-occured-java-lang-unsupportedoperationexception?show=13849)
- [message to itself on left side?](https://forum.plantuml.net/1361/message-to-itself-on-left-side?show=13828#a13828)
- [[Activity] Layout issue or java error, on end merge, with more than 2 fork](https://forum.plantuml.net/13731/activity-layout-issue-java-error-end-merge-with-more-than-fork)
- [Getting UnsupportedOperation when adding stop and/or end to case](https://forum.plantuml.net/13824/getting-unsupportedoperation-when-adding-stop-and-end-case)

## V1.2021.6 (May 14, 2021)

- [Upgrading C4 library to 2.2.0](https://github.com/plantuml/plantuml-stdlib/commit/8653c5071182f6bd98610e48e09b7a2f12e2f66d)
- [Choose a different theme for rendering your diagrams](theme)
- [Support SVG Opacity Correctly](https://forum.plantuml.net/13809/support-svg-opacity-correctly)
- [[UseCase] Problem to apply syle class on use case](https://forum.plantuml.net/13758/usecase-problem-to-apply-syle-class-on-use-case?show=13763#c13763)
- [[Gantt] Add zoom for daily scale](https://forum.plantuml.net/13725/gantt-add-zoom-for-daily-scale)
- [[Gantt] Force today's color even if this day is colored after](https://forum.plantuml.net/13726/gantt-force-todays-color-even-if-this-day-is-colored-after)
- [Spaces in Markdown syntax in MindMap](https://forum.plantuml.net/13669/spaces-in-markdown-syntax-in-mindmap?show=13704#c13704)
- [Hide empty descriptions removes inline style in State Diagram](https://forum.plantuml.net/13655/hide-empty-descriptions-removes-inline-style-state-diagram)

## V1.2021.5 (April 25, 2021)

- [[Style] Allow BackgroundColor for all closed days on Gantt diagram](https://forum.plantuml.net/13672/style-allow-backgroundcolor-for-closed-days-gantt-diagram)
- [[Style] Allow FontColor transparent or #00000000 on SVG](https://forum.plantuml.net/13622/style-allow-fontcolor-transparent-or-%2300000000-on-svg)
- [YAML chart parsing issue](https://github.com/plantuml/plantuml/issues/528)
- [[Style] Regression on document background-color style](https://forum.plantuml.net/13623/style-regression-on-document-background-color-style)
- [Is it possible to display milestones on same row as tasks that have notes?](https://forum.plantuml.net/13367/possible-display-milestones-same-row-tasks-that-have-notes?show=13380#c13380)
- [Add  in GANTT](https://forum.plantuml.net/10835/add-style-style-in-gantt?show=12005#a12005)
- [Can you style the days and months of a gantt chart](https://forum.plantuml.net/13570/can-you-style-the-days-and-months-of-a-gantt-chart)
- [[Gantt] Issue with yearly print when project does not begin at beginning of year](https://forum.plantuml.net/13560/gantt-issue-with-yearly-print-when-project-begin-beginning)

## V1.2021.4 (April 4, 2021)

- [Adding new "person" keyword](https://twitter.com/simonbrown/status/1377927953170976771)
- [Color inheritance in wbs](https://forum.plantuml.net/12807/color-inheritance-in-wbs?show=13527#c13527)
- [Add quarterly and yearly print scale to gantt diagram](https://github.com/plantuml/plantuml/pull/517)

## V1.2021.3 (March 22, 2021)

- [Matthew Leather has started several very interesting code refactorings.](https://github.com/plantuml/plantuml/pull/493)
- [Gantt: Minor issues of coloring current week during printscale weekly and closed days](https://forum.plantuml.net/12415/gantt-issues-coloring-current-during-printscale-weekly-closed?show=13435#c13435)
- [Gantt milestone bug](https://forum.plantuml.net/13434/gantt-milestone-bug?show=13448#c13448)
- [UnsupportedOperationException in while loops](https://github.com/plantuml/plantuml/issues/491)
- [Simple default value for undefined variables](https://forum.plantuml.net/13424/simple-default-value-for-undefined-variables?show=13426#c13426)
- [UnsupportedOperationException: class net.sourceforge.plantuml.ugraphic.UPixel](https://forum.plantuml.net/13387/unsupportedoperationexception-sourceforge-plantuml-ugraphic)
- [teoz, deactivate not working](https://forum.plantuml.net/13381/teoz-deactivate-not-working)
- [Cannot use symbols at the beginning of keys in YAML](https://forum.plantuml.net/13376/cannot-use-symbols-at-the-beginning-of-keys-in-yaml)
- [[WBS] Allow boxless node on all level and not only on leafnode](https://forum.plantuml.net/13355/wbs-allow-boxless-node-on-all-level-and-not-only-on-leafnode)
- [Lollipop overlaps with arrows label](https://forum.plantuml.net/13345/lollipop-overlaps-with-arrows-label)
- [[Inline style] Manage 'line style' (bold, dashed or dotted) and 'text color' for nested element (Deployment)](https://forum.plantuml.net/13336/inline-style-manage-dashed-dotted-nested-element-deployment)
- [The ability to customise the highlight for json/yaml](https://forum.plantuml.net/13288/the-ability-to-customise-the-highlight-for-json-yaml?show=13397#c13397)
- [C4 and Archimate StdLib update](https://forum.plantuml.net/13415/function-containerdb-rendering-deployment-diagram-plantuml?show=13465#c13465)
- [Could you allow MaximumWidth on style for note [test on activity]](https://forum.plantuml.net/13408/could-you-allow-maximumwidth-on-style-for-note-test-activity)
- [Unsupported background colour for YAML parser](https://github.com/plantuml/plantuml/issues/503)
- [Crash when there is a missing label on timing diagram](https://forum.plantuml.net/13473/crash-when-there-is-a-missing-label-on-timing-diagram)
- [Fix style for simple nested package](https://forum.plantuml.net/13261/accept-hexagon-on-style-deployment-diagram?show=13452#c13452)

## V1.2021.2 (March 7, 2021)

- [Add interactive functionality for Usecase diagrams exported to SVG](https://github.com/plantuml/plantuml/pull/475)
- [Skinparam ArrowColor cannot be combined via multiple stereotypes](https://forum.plantuml.net/13245/skinparam-arrowcolor-cannot-combined-multiple-stereotypes)
- [[Inline style] Manage 'line style' (dashed or dotted) and 'text color' for package and usecase (Deployment/Usecase)](https://forum.plantuml.net/13243/inline-manage-dashed-dotted-package-usecase-deployment-usecase?show=13263#c13263)
- [The ability to customise the highlight for json/yaml](https://forum.plantuml.net/13288/the-ability-to-customise-the-highlight-for-json-yaml)
- [WBS OrgMode notation should support removing the box](https://forum.plantuml.net/13297/wbs-orgmode-notation-should-support-removing-the-box)
- [Allow style on WBS boxless node](https://forum.plantuml.net/13298/allow-style-on-wbs-boxless-node)
- ['hide members' break when a note is attached to a member](https://github.com/plantuml/plantuml/issues/470)
- [Is there a way to style JSON and/or YAML input (i.e. startjson, startyaml)?](https://forum.plantuml.net/13123/is-there-way-to-style-json-and-yaml-input-startjson-startyaml?show=13132#c13132)
- [Differences between PNG and SVG outputs, for ArrowLollipopColor on component diagram](https://forum.plantuml.net/13091/differences-between-outputs-arrowlollipopcolor-component)
- [Timing diagram scale fails with certain sequence of times](https://forum.plantuml.net/13095/timing-diagram-scale-fails-with-certain-sequence-of-times)
- [Newline in state diagrams is inconsistent](https://forum.plantuml.net/13071/newline-in-state-diagrams-is-inconsistent?show=13073#c13073)
- [Broadcast or a Multicast message in a sequence diagram](https://forum.plantuml.net/2585/broadcast-or-a-multicast-message-in-a-sequence-diagram?show=13008#c13008)
- [YAML Sequence of Mappings doesn't work at top level](https://forum.plantuml.net/13042/yaml-sequence-of-mappings-doesnt-work-at-top-level?show=13042#q13042)
- [Activation shorthand for sequence diagrams](https://forum.plantuml.net/4834/activation-shorthand-for-sequence-diagrams?show=12981#c12981)
- [Support annotations with members](https://github.com/plantuml/plantuml/issues/458)
- [style: HorizontalAlignment management also for usecase [Deployment diagram]](https://forum.plantuml.net/13022/horizontalalignment-management-usecase-deployment-diagram)
- [beta-style: is style management local or global? [Deployment diagram vs Mindmap]](https://forum.plantuml.net/13000/style-style-management-global-deployment-diagram-mindmap)
- [Regression: Line break in state actions ignored](https://forum.plantuml.net/12997/regression-line-break-in-state-actions-ignored)

## V1.2021.1 (February 2, 2021)

- [SVG in img do not render](https://forum.plantuml.net/12578/svg-in-img-do-not-render?show=12931#a12931)
- [Destroy not displayed with teoz](https://forum.plantuml.net/12884/destroy-not-displayed-with-teoz)
- [Component Regression with version 1.2021.01beta7](https://forum.plantuml.net/12957/component-regression-with-version-1-2021-01beta7?show=12959#c12959)
- [beta-style: HorizontalAlignment management for Component or Deployment diagram](https://forum.plantuml.net/12920/horizontalalignment-management-component-deployment-diagram)
- [Indented creole tree treated as seperate trees](https://forum.plantuml.net/12856/indented-creole-tree-treated-as-seperate-trees)
- [Allow style for collections or database [Deployment-diagram]](https://forum.plantuml.net/12923/allow-style-for-collections-or-database-deployment-diagram?show=12925#c12925)
- [Accept bracket long description form for circle [Deployment-diagram]](https://forum.plantuml.net/12921/accept-bracket-long-description-circle-deployment-diagram)
- [Bug in new YAML parser?](https://forum.plantuml.net/12946/bug-in-new-yaml-parser?show=12951#c12951)
- [How to convert {curly brackets} to tikz?](https://forum.plantuml.net/12953/how-to-convert-curly-brackets-to-tikz)
- [Object diagram: crash when map refers to object inside a group](https://forum.plantuml.net/12864/object-diagram-crash-when-map-refers-to-object-inside-group?show=12875#a12875)
- [Please allow #transparent to be a synonym of #00000000 [on arrow color of activity-diagram]](https://forum.plantuml.net/12844/please-allow-%23transparent-synonym-%2300000000-activity-diagram?show=12885#c12885)
- [Change Activity Diagram "Stop" and "End" symbols to fill using the diagram background color instead of always using white](https://github.com/plantuml/plantuml/pull/450)
- [Change link decorators to fill with diagram background color instead of white](https://github.com/plantuml/plantuml/pull/448)
- [[gantt] thursday are colored in #AAF](https://github.com/plantuml/plantuml/issues/432#issuecomment-761818919)
- [[Bug] Sequence diagram: ascii art output includes html-style tags for messages to self](https://github.com/plantuml/plantuml/issues/416)
- [YAML Diagrams: accept YAML diagram as sub-diagram or embedded diagram](https://forum.plantuml.net/12820/yaml-diagrams-accept-yaml-diagram-diagram-embedded-diagram)
- [Please provide a hexagon shape](https://forum.plantuml.net/10418/please-provide-a-hexagon-shape?show=12813#a12813)

## V1.2021.0 (January 10, 2021)

- [Color attribute is not working in arithmetic mindmap](https://forum.plantuml.net/12785/color-attribute-is-not-working-in-arithmetic-mindmap)
- [[GANTT] Implement "[day] are colored in #AAAAFF"](https://github.com/plantuml/plantuml/pull/440)
- [[GANTT] Implement arrow style color](https://github.com/plantuml/plantuml/pull/438)
- [Add YAML data diagram, same concept as JSON data](https://github.com/plantuml/plantuml/issues/434)
- [Letters 'i' and 'I' in the comments rendering like 'l'](https://github.com/plantuml/plantuml-server/issues/167#issuecomment-754719353)
- [Better support for %filename()](https://forum.plantuml.net/12731/add-null-character-to-%25filename-on-server-and-picoweb?show=12762)
- [second keyword argument with comma not working](https://forum.plantuml.net/12750/second-keyword-argument-with-comma-not-working?show=12753#c12753)
- [Using 0% workload on gantt diagram produces an infinite loop](https://github.com/plantuml/plantuml/issues/428#issuecomment-752234683)
- [Smetana doesn't allow [hide] in connections?](https://forum.plantuml.net/12685/smetana-doesnt-allow-hide-in-connections?show=12693#c12693)

## V1.2020.26 (December 21, 2020)

- For some reasons, there is no 1.2020.25 version.
- [We fixed a regression about GraphViz diagrams under Windows.](https://forum.plantuml.net/12695/since-last-update-creating-digraph-does-not-work-any-longer)

## V1.2020.24 (December 18, 2020)

- [PNG Metadata](https://blog.mrhaki.com/2016/12/plantuml-pleasantness-get-plantuml.html)
- [Incubation of hardware block diagram](https://forum.plantuml.net/12518/is-there-simple-way-use-plantuml-draw-hardware-block-diagram?show=12666#c12666)
- [Incubation of board diagram](https://github.com/plantuml/plantuml/issues/423)
- [Scaling of SVG sprites does not work](https://forum.plantuml.net/12623/scaling-of-svg-sprites-does-not-work)
- [variable increased 2 times in diagram (maybe function is called twice during preprocessing)](https://forum.plantuml.net/12624/variable-increased-diagram-function-called-preprocessing)
- [Ability to manage several groups on same network in nwdiag](https://forum.plantuml.net/12663/ability-to-manage-several-groups-on-same-network-in-nwdiag?show=12663#q12663)
- [Ability to add a label to a group in nwdiag](https://forum.plantuml.net/12056/ability-to-add-a-label-to-a-group-in-nwdiag)
- [[nwdiag] grouping does not work properly](https://github.com/plantuml/plantuml/issues/408)
- [Drawing issue multinetwork diag](https://forum.plantuml.net/12055/drawing-issue-multinetwork-diag)
- [Nwdiag overlapp problem with 3 networks](https://forum.plantuml.net/12655/nwdiag-overlapp-problem-with-3-newtorks)

## V1.2020.23 (December 13, 2020)

- [Image with data URI containing SVG does not render](https://forum.plantuml.net/12612/image-with-data-uri-containing-svg-does-not-render)
- [Sequence diagram: ascii art output includes html-style tags for messages to self](https://github.com/plantuml/plantuml/issues/416)
- [JSON Diagrams: accept JSON diagram as sub-diagram or embedded diagram](https://forum.plantuml.net/12609/json-diagrams-accept-json-diagram-diagram-embedded-diagram)
- [Table Syntax on Entity Class for ERM](https://github.com/plantuml/plantuml/issues/415)

## V1.2020.22 (December 6, 2020)

- [Differences between PNG and SVG outputs, for unicode char with size](https://forum.plantuml.net/12550/differences-between-png-and-outputs-unicode-char-with-size)
- [Color alpha channel ignored for text in SVG](https://forum.plantuml.net/12542/color-alpha-channel-ignored-for-text-in-svg?show=12546#c12546)
- [Missing Connection in multilane if structure](https://forum.plantuml.net/12554/missing-connection-in-multilane-if-structure)
- [Arrow not correct with Json Big Data](https://forum.plantuml.net/12531/arrow-not-correct-with-json-big-data)
- [InsideDiamond condition style not showing one of the branch label for activity diagram](https://forum.plantuml.net/12527/insidediamond-condition-showing-branch-activity-diagram?show=12527#q12527)

## V1.2020.21 (November 30, 2020)

- [Easily display your JSON data](json)
- [Repeat over multiple swimlanes bugged](https://forum.plantuml.net/12507/repeat-over-multiple-swimlanes-bugged)
- [New line in table built with variables broken [from 1.2020.20]](https://forum.plantuml.net/12480/new-line-in-table-built-with-variables-broken-from-1-2020-20)
- [Allow not significant space or indentation (on the beginning of the lines) on mindmap diagram](https://forum.plantuml.net/12230/allow-significant-indentation-beginning-mindmap-diagram?show=12477#c12477)
- [Black package background when transparent used for package and default background (ubuntu)](https://forum.plantuml.net/12469/package-background-transparent-package-default-background?show=12487#c12487)
- [wrapWidth wraps punctuation when a font size is set?](https://forum.plantuml.net/12437/wrapwidth-wraps-punctuation-when-a-font-size-is-set?show=12437)
- [Is there a way to indent text inside a shape?](https://forum.plantuml.net/6604/is-there-a-way-to-indent-text-inside-a-shape?show=12453#c12453)
- [styles (css method ) are not applied correctly in usecase diagram](https://forum.plantuml.net/12426/styles-css-method-are-not-applied-correctly-usecase-diagram?show=12426#q12426)

## V1.2020.20 (November 20, 2020)

- [user defined style targets in activity diagram (beta)](https://forum.plantuml.net/12396/user-defined-style-targets-in-activity-diagram-beta)
- [Strange stereotypes grouping](https://forum.plantuml.net/12398/strange-stereotypes-grouping)
- [Add support of node colors to WBS for single nodes](https://forum.plantuml.net/12374/add-support-of-node-colors-to-wbs-for-single-nodes)
- [Cypher not working properly](https://forum.plantuml.net/12358/cypher-not-working-properly)
- [activity diagram (beta) on error when adding fork or split under a if statement that contains a break](https://github.com/plantuml/plantuml/issues/399)
- [LifeLineBorderColor stereotype not working](https://forum.plantuml.net/12288/lifelinebordercolor-stereotype-not-working)
- [Allow not significant space or indentation (on the beginning of the lines) on mindmap diagram](https://forum.plantuml.net/12230/allow-significant-indentation-beginning-mindmap-diagram?show=12301#c12301)
- [Observations on preprocessing test of boolean expression [V1.2020.19]](https://forum.plantuml.net/12320/observations-preprocessing-test-boolean-expression-2020)
- [Improve, on activity-diagram, last label position when break on loop [1.2020.19]](https://forum.plantuml.net/12321/improve-activity-diagram-last-label-position-when-break-loop)
- [Transparence management with monochrome reverse](https://forum.plantuml.net/12317/transparence-management-with-monochrome-reverse)
- [conditionStyle InsideDiamond not work](https://github.com/plantuml/plantuml/issues/400)
- [New actor style - Hollow](https://github.com/plantuml/plantuml/pull/396)
- [Gantt, printscale weekly, coloring current week](https://forum.plantuml.net/12289/gantt-printscale-weekly-coloring-current-week?show=12291#c12291)
- ["o" sets wrong arrow direction](https://forum.plantuml.net/12278/o-sets-wrong-arrow-direction)
- [How to define background color to sprite in legend?](https://forum.plantuml.net/12244/how-to-define-background-color-to-sprite-in-legend)
- [How can I hide parts of a robust state in timing-diagram?](https://forum.plantuml.net/12222/how-can-i-hide-parts-of-a-robust-state-in-timing-diagram)

## V1.2020.19 (October 12, 2020)

- [Official release of PlantUML PicoWebServer](picoweb)
- [Arrow description for while loop](https://forum.plantuml.net/12211/arrow-description-for-while-loop)
- [Differences between PNG and SVG outputs, of BackgroundColor with salt on activity diagram](https://forum.plantuml.net/12219/differences-between-outputs-backgroundcolor-activity-diagram)
- [Uncorrect drawing with Weekly printscale](https://forum.plantuml.net/12175/uncorrect-drawing-with-weekly-printscale)
- [Unable to add arrow text description after backward keyword](https://forum.plantuml.net/12180/unable-to-add-arrow-text-description-after-backward-keyword)
- [Quotes in digraph name causes Syntax Error](https://forum.plantuml.net/12183/quotes-in-digraph-name-causes-syntax-error)
- [Jdot/Smetana random associations in class diagram](https://forum.plantuml.net/12187/jdot-smetana-random-associations-in-class-diagram)
- [Add support to Business Use Case](https://forum.plantuml.net/12179/add-support-to-business-use-case)
- [change color of salt button to represent disabled status](https://forum.plantuml.net/12177/change-color-of-salt-button-to-represent-disabled-status)
- [Association classes does not work with quotes inside the parentheses](https://github.com/plantuml/plantuml/issues/366)
- [Lollipop notation direction does not change when parties are re-positioned](https://github.com/plantuml/plantuml/issues/365)

## V1.2020.18 (September 30, 2020)

- [Gantt chart bug: weird interaction with notes, tasks and separators](https://github.com/plantuml/plantuml/issues/386)
- ['note right' doesn't always work on Activity (beta) when using swimlanes](https://github.com/plantuml/plantuml/issues/385)
- [An html-tag for code](https://forum.plantuml.net/12080/an-html-tag-for-code)
- [Gantt chart: allow closed days to be coloured](https://github.com/plantuml/plantuml/issues/381)
- [Embed sub diagrams (of all type, especially Mindmap or WBS) in (all type of) diagram](https://forum.plantuml.net/11895/embed-sub-diagrams-all-type-especially-mindmap-type-diagram)
- [You can no longer nest partitions from Version 2.13.11](https://forum.plantuml.net/11835/you-can-no-longer-nest-partitions-from-version-2-13-11)
- [scale not honoured in Gantt chart](https://forum.plantuml.net/11892/scale-not-honoured-in-gantt-chart)
- [beta-style: LineStyle and LineThickness management for all elements of Deployment diagram](https://forum.plantuml.net/11833/linestyle-linethickness-management-elements-deployment)
- [misintepretation of tooltip as operation](https://forum.plantuml.net/12062/misintepretation-of-tooltip-as-operation)
- [Allow Creole list on Component, Deployment, Use-Case and Creole sub-item on Class or Object [V1.2020.16]](https://forum.plantuml.net/12087/allow-creole-component-deployment-case-creole-class-object)
- [Order mismatch with embedded diagram and Creole line [on deployment-diagram]](https://forum.plantuml.net/12124/order-mismatch-embedded-diagram-creole-deployment-diagram)
- [Allow Creole horizontal lines on Object and strong horizontal lines on Activity, MindMap, Title or Legend](https://forum.plantuml.net/12089/creole-horizontal-object-strong-horizontal-activity-mindmap)
- [Arrow should point along diagonal line as well](https://github.com/plantuml/plantuml/issues/368)
- [Can't use repeat with swimlanes](https://forum.plantuml.net/12153/cant-use-repeat-with-swimlanes)
- [Missing tokens from -language option](https://github.com/plantuml/plantuml/issues/359)

## V1.2020.17 (September 19, 2020)

- [Rendering errors when nesting multiple repeat-while blocks](https://forum.plantuml.net/12063/rendering-errors-when-nesting-multiple-repeat-while-blocks)
- [Order mismatch between Note and rectangle with embedded salt](https://forum.plantuml.net/10967/order-mismatch-between-note-and-rectangle-with-embedded-salt?show=12060#c12060)
- [Could we have an Error report on one line (report any syntax error on one line)?](https://forum.plantuml.net/11805/could-have-error-report-one-line-report-any-syntax-error-line?show=12115#c12115)
- [Line numbers of error messages in the sequence diagram are different.](https://forum.plantuml.net/9835/line-numbers-error-messages-the-sequence-diagram-different)
- [Invalid activity diagram failing with internal exception](https://github.com/plantuml/plantuml/issues/372)
- [Observations on Common commands (title, header, footer, caption or legend) on all diagrams](https://forum.plantuml.net/12047/observations-common-commands-header-footer-caption-diagrams)
- [Package with only legend shows up empty](https://forum.plantuml.net/12017/package-with-only-legend-shows-up-empty)

## V1.2020.16 (August 23, 2020)

- [Nwdiag: issue with multi-connected networks](https://forum.plantuml.net/10297/how-to-report-this-possible-bug-in-the-beta-nwdiag)
- [ids generated by plantuml are not xml compliant](https://forum.plantuml.net/11968/ids-generated-by-plantuml-are-not-xml-compliant)
- [Path id in generated SVG](https://forum.plantuml.net/7109/path-id-in-generated-svg)
- [Dotted arrow is also the close of comment blocks (HTML, XML, Markdown)](https://forum.plantuml.net/11806/dashed-arrow-also-the-close-comment-blocks-html-xml-markdown)
- [Change task default color (You can use styles to retrieve old colors)](gantt-diagram#f80ba0c004d810f7)
- [Gantt diagram: tasks on the same line](gantt-diagram#8465bc7952c5dd2a)
- [Gantt diagram: pause tasks](gantt-diagram#d55fb3062151b65c)
- [Gantt Diagram: add memos or explanations to tasks](https://forum.plantuml.net/11528/gantt-diagram-add-memos-or-explanations-to-tasks)
- [Add style in GANTT](https://forum.plantuml.net/10835/add-style-style-in-gantt)
- [How to change color (or thickness, or style) of arrows, in gantt diagram?](https://forum.plantuml.net/11877/how-to-change-color-or-thickness-style-arrows-gantt-diagram)
- [Could be possible to define simply Task between two Milestones?](https://forum.plantuml.net/11911/could-be-possible-define-simply-task-between-two-milestones)

## V1.2020.15 (June 28, 2020)

- [Shape issue on stack element (Deployement diagram)](https://forum.plantuml.net/11776/shape-issue-on-stack-element-deployement-diagram-on-v1-2020)
- [Using hide stereotype overrides database stereotype customisation](https://forum.plantuml.net/11761/stereotype-overrides-database-stereotype-customisation)
- [Quote is visible in class name when using hide circle](https://github.com/plantuml/plantuml/issues/342#issuecomment-646623523)

## V1.2020.14 (June 20, 2020)

- [Does V1.2020.13 work with the PDF dependencies zip file?](https://forum.plantuml.net/11740/does-v1-2020-13-work-with-the-pdf-dependencies-zip-file)
- [Bug Fix: When port with added node in the cluster crashes PlantUML](https://github.com/plantuml/plantuml-epl/pull/1)
- [Cluster Empty node is not properly located when thereALinkFromOrToGroup2 is enabled](https://github.com/plantuml/plantuml-epl/pull/2)
- [beta-style: Backgroundcolor doesn't work with mix of group components and sub-diagram](https://forum.plantuml.net/11735/beta-style-backgroundcolor-doesnt-group-components-diagram)
- [packageStyle doesn't seem to always work](https://forum.plantuml.net/11731/packagestyle-doesnt-seem-to-always-work)
- [Automatic underlined name in Object Diagrams](https://twitter.com/_StephanRoth/status/1272805829142622208)
- [Timing diagram crash with constraint in binary](https://forum.plantuml.net/11728/timing-diagram-crash-with-constraint-in-binary)
- [New CSS styling is not recognized in class diagrams](https://forum.plantuml.net/11729/new-css-styling-is-not-recognized-in-class-diagrams)

## V1.2020.13 (June 13, 2020)

- [beta-style: LineStyle and LineThickness management for Component or Deployment diagram](https://forum.plantuml.net/11707/linestyle-linethickness-management-component-deployment)
- [Bibliotekon.getNodeUid throws IllegalStateException](https://github.com/plantuml/plantuml/issues/337)
- [mind map diagrams BackGroundColor transparent is failing with NullPointerException](https://forum.plantuml.net/11556/diagrams-backgroundcolor-transparent-nullpointerexception)
- [Is it possible to hide the component icon ?](https://forum.plantuml.net/10798/is-it-possible-to-hide-the-component-icon?show=11696#c11696)
- [Shadowing issues with (rounded) empty group with transparent BackgroundColor](https://forum.plantuml.net/11677/shadowing-issues-rounded-empty-transparent-backgroundcolor)
- [beta-style: How to disable shadowing?](https://forum.plantuml.net/11675/beta-style-how-to-disable-shadowing)
- [Sequence Diagrams: Anchros and Durations with Incoming/Outgoing Messages](https://forum.plantuml.net/11670/sequence-diagrams-anchros-durations-incoming-outgoing-messages)
- [beta-style: Cropped output images when we use beta-style functionality](https://forum.plantuml.net/11682/beta-style-cropped-output-images-when-style-functionality)

## V1.2020.12 (June 6, 2020)

- [Some improvement in transparent support for beta style](https://forum.plantuml.net/11657/test-open-discussion-about-transparency-comparison-between)
- [Gantt: Dependency arrows are drawn incorrectly when using weekscale](https://forum.plantuml.net/11629/gantt-dependency-arrows-drawn-incorrectly-using-weekscale)
- [Remove whitespace](https://forum.plantuml.net/11624/remove-whitespace)
- [Math/LaTex resolution/dpi](https://github.com/plantuml/plantuml/issues/333)
- [Full opacity (alpha compositing) support (for SVG and PNG)](https://forum.plantuml.net/11606/full-opacity-alpha-compositing-support-for-svg-and-png)
- [Multi-line message: comment handling changed](https://forum.plantuml.net/11617/multi-line-message-comment-handling-changed)

## V1.2020.11 (May 30, 2020)

- [How to deploy PlantUML safely.](security)
- [Backgroundcolor transparent doesn't work for empty group](https://forum.plantuml.net/11491/backgroundcolor-transparent-doesnt-empty-group-deployement?show=11491#q11491)
- [mind map diagrams BackGroundColor transparent is failing with NullPointerException](https://forum.plantuml.net/11556/diagrams-backgroundcolor-transparent-nullpointerexception)
- [Timing diagram using time & scale cuts off times](https://forum.plantuml.net/11557/timing-diagram-using-time-%26-scale-cuts-off-times)
- [Group components can't be set transparent](https://forum.plantuml.net/8359/group-components-cant-be-set-transparent?show=8359#q8359)
- [PNG export to 300 dpi no longer works correctly?](https://forum.plantuml.net/11535/png-export-to-300-dpi-no-longer-works-correctly)
- [Sate deep history first implementation](https://github.com/plantuml/plantuml/pull/329)

## V1.2020.10 (May 17, 2020)

- [Print between remove resources on Gantt chart](https://forum.plantuml.net/11503/print-between-remove-resources-on-gantt-chart)
- [Could you add Unicode and/or entities management on link's tooltip?](https://forum.plantuml.net/11505/could-you-add-unicode-and-entities-management-links-tooltip)
- [Preprocessor line merging break ditaa diagrams with sloped edge at line end](https://github.com/plantuml/plantuml/issues/324)
- [Ball-and-socket connection does not orient correctly for .eps output](https://github.com/plantuml/plantuml/issues/322)
- [Introduce padding setting](https://forum.plantuml.net/3118/introduce-padding-setting?show=11394#c11394)

## V1.2020.9 (May 10, 2020)

- [Do not statically initialize ImportedFiles](https://forum.plantuml.net/11460/do-not-statically-initialize-importedfiles%23include_path)
- [Backgroundcolor transparent doesn't work for only some element](https://forum.plantuml.net/11380/backgroundcolor-transparent-doesnt-element-alone-element?show=11418#c11418)
- [Few improvements on padding](https://forum.plantuml.net/3118/introduce-padding-setting?show=11394#c11394)
- [mixed signal timing diagram](https://forum.plantuml.net/11288/mixed-signal-timing-diagram?show=11369#c11369)
- [No text spacing with fork - Activity Diagram](https://forum.plantuml.net/11344/no-text-spacing-with-fork-activity-diagram?show=11364#c11364)
- [Creole trees do not respect indent levels in a component diagram](https://forum.plantuml.net/11365/creole-trees-do-not-respect-indent-levels-component-diagram)
- [Applying style to multiline node in mindmap diagram](https://forum.plantuml.net/11354/applying-style-to-multiline-node-in-mindmap-diagram)
- [Please allow to set notes skimparams by stereotypes in all notes](https://forum.plantuml.net/11330/please-allow-to-set-notes-skimparams-stereotypes-all-notes)
- [latex command requires space](https://forum.plantuml.net/11320/latex-command-requires-space-between-activity-object-08beta10)
- [Lines without arrows](https://forum.plantuml.net/11283/lines-without-arrows?show=11302#c11302)

## V1.2020.8 (April 26, 2020)

- [Backgroundcolor transparent doesn't work anymore](https://forum.plantuml.net/11298/backgroundcolor-transparent-doesnt-work-anymore)
- [Background color partial transparency/opacity support](https://forum.plantuml.net/11214/background-color-partial-transparency-opacity-support)
- [Lines without arrows](https://forum.plantuml.net/11283/lines-without-arrows)
- [backward for while: confusing arrow layout on continuation](https://forum.plantuml.net/11250/backward-for-while-confusing-arrow-layout-on-continuation)
- [nwdiag ignores on "title" keyword in plantuml.1.2020.7](https://forum.plantuml.net/11303/nwdiag-ignores-on-title-keyword-in-plantuml-1-2020-7)
- [Gantt: Add support for #color](https://forum.plantuml.net/11273/gantt-add-support-for-%23color)
- [is there a "compact" timing diagram?](https://forum.plantuml.net/11130/is-there-a-compact-timing-diagram)
- [backward for while: confusing arrow layout on continuation](https://forum.plantuml.net/11250/backward-for-while-confusing-arrow-layout-on-continuation)

## V1.2020.7 (April 19, 2020)

- [ifelse and swimlanes seems to break logic](https://forum.plantuml.net/11184/ifelse-and-swimlanes-seems-to-break-logic)
- [json structures inside a function](https://forum.plantuml.net/11192/json-structures-inside-a-function)
- [Multiple Function calls in Text: only one processed](https://forum.plantuml.net/11219/multiple-function-calls-in-text-only-one-processed)
- [Deployment Diagram: Creole does not work on 'card'](https://forum.plantuml.net/11189/deployment-diagram-creole-does-not-work-on-card)
- [Class HeaderBackgroundColor doesn't work when RoundCorner is defined](https://forum.plantuml.net/11176/class-headerbackgroundcolor-doesnt-roundcorner-defined)
- ["Ghost links" between diagrams](https://forum.plantuml.net/11205/ghost-links-between-diagrams)
- [Add Elastic Icon Set](https://github.com/plantuml/plantuml-stdlib/pull/18)
- [Update awslib to release 6.0](https://github.com/plantuml/plantuml-stdlib/pull/19)
- [Full support for Creole in legend](https://forum.plantuml.net/11147/full-support-for-cr%C3%A9ole-in-legend)
- [backward for while / endwhile](https://forum.plantuml.net/11144/backward-for-while-endwhile)

## V1.2020.6 (April 5, 2020)

- [Support for map-like objects](https://github.com/plantuml/plantuml/issues/307)
- [Cannot change separator on backward items](https://github.com/plantuml/plantuml/issues/309)
- [Javascript hyperlinks in SVG](https://forum.plantuml.net/11084/javascript-hyperlinks-in-svg)
- [IllegalArgumentException: height=0.0](https://forum.plantuml.net/11085/illegalargumentexception-height-0-0)
- [Remove unlinked components](https://forum.plantuml.net/11052/remove-unlinked-components)
- [How to make it render less "scrambled"](https://forum.plantuml.net/11027/how-to-make-it-render-less-scrambled)

## V1.2020.5 (March 19, 2020)

- [Anchors and Duration with groups: Do not work (sequence diagram)](https://github.com/plantuml/plantuml/issues/299)

## V1.2020.4 (March 19, 2020)

- [Rollback to regular license.](license)

## V1.2020.3 (March 17, 2020)

- [Updated software license to Coronavirus license. Please apply social distancing](license)
- [Deployment Diagram Regression: If name ends with "."](https://forum.plantuml.net/10995/deployment-diagram-regression-if-name-ends-with)
- [[Sequence] QueueBorderColor not respected](https://forum.plantuml.net/10964/sequence-queuebordercolor-not-respected)
- [Please provide macros to insert the current page number and total number of pages](https://forum.plantuml.net/6699/please-provide-macros-insert-current-number-total-number-pages)
- [GANTT printscale weekly](https://forum.plantuml.net/10948/gantt-printscale-weekly)
- [How to create a Creole table without a bolded first row?](https://forum.plantuml.net/10923/how-to-create-a-creole-table-without-a-bolded-first-row)
- [Issues with diagrams within diagrams](https://forum.plantuml.net/10940/issues-with-diagrams-within-diagrams)
- [State labels overlap with participants' names](https://forum.plantuml.net/10903/state-labels-overlap-with-participants-names)
- [Enable "RoundCorner" and "DiagonalCorner" for Participant Stereotypes on Sequence Diagrams](https://forum.plantuml.net/10877/roundcorner-diagonalcorner-participant-stereotypes-sequence?show=10917#c10917)

## V1.2020.2 (March 1, 2020)

- [Highlighted periods in timing diagrams](https://forum.plantuml.net/10868/highlighted-periods-in-timing-diagrams)
- [Gantt: Hyperlinks](https://forum.plantuml.net/10855/gantt-hyperlinks)
- [Minor fix for Gantt language](https://forum.plantuml.net/5782/gantt-diagram-variant-without-natural-language?show=10851#c10851)
- [While loop in preprocessor](https://forum.plantuml.net/10838/there-better-way-implement-while-loop-perprocess-function)
- [Bug fix for missing anchor](https://github.com/plantuml/plantuml/issues/294)
- [Includesub regression fix](https://forum.plantuml.net/10846/startsub-includesub-example-documentation-behaves-differently)
- [Sequence diagram incoming/outgoing half headed arrows are inverted](https://forum.plantuml.net/10848/sequence-diagram-incoming-outgoing-headed-arrows-inverted)

## V1.2020.1 (February 16, 2020)

- [GANTT Year incorrect for December](https://forum.plantuml.net/10831/gantt-year-incorrect-for-december)
- [Change gantt scale for long projects](https://forum.plantuml.net/7637/change-gantt-scale-for-long-projects)
- [interface does not work when allow_mixing](https://forum.plantuml.net/10825/interface-or-does-not-work-when-allow_mixing)
- [Font Style not working on title](https://forum.plantuml.net/10800/font-style-not-working-on-title)
- [https://forum.plantuml.net/10761/latex-export-limitations](https://forum.plantuml.net/10761/latex-export-limitations)
- [Repeat: Plus Colour](https://forum.plantuml.net/10676/repeat-plus-colour?show=10746#c10746)
- [Encountering java.lang.IllegalArgumentException](https://forum.plantuml.net/10664/encountering-java-lang-illegalargumentexception)

## V1.2020.0 (January 12, 2020)

- [PreprocessorV2: multiline function invocation](https://forum.plantuml.net/10597/preprocessorv2-multiline-function-invocation)
- [Sequence diagram: shortcut act/deact does not work with incoming/outgoing messages](https://forum.plantuml.net/10612/sequence-diagram-shortcut-deact-incoming-outgoing-messages)
- [Simple text element](https://forum.plantuml.net/10619/simple-text-element)
- [Creole in sequence diagram participants](https://forum.plantuml.net/10596/creole-in-sequence-diagram-participants)
- [Sequence diagram bug, missing polygon (outer box of object) with handwritten, create and SVG](https://forum.plantuml.net/10600/sequence-diagram-missing-polygon-object-handwritten-create)
- [Exception when using !includesub](https://forum.plantuml.net/10572/exception-when-using-includesub)
- [Cannot add preprocessing variables from commandline any more](https://forum.plantuml.net/10563/cannot-add-preprocessing-variables-from-commandline-more)
- [Vertical IF composition bug](https://forum.plantuml.net/10545/vertical-if-composition-bug)
- [Please allow adding edges to class members and methods with complex names](https://forum.plantuml.net/5261/please-allow-adding-edges-class-members-methods-complex-names)

## V1.2019.13 (December 10, 2019)

- [Class diagrams: Method to method arrow sometimes points to the wrong method](https://forum.plantuml.net/10194/class-diagrams-method-method-arrow-sometimes-points-method)
- [How can I customize the actor icon in SVG output](https://forum.plantuml.net/10493/how-can-i-customize-the-actor-icon-in-svg-output)
- [Is there a supported way to specify fall back fonts](https://forum.plantuml.net/10498/is-there-a-supported-way-to-specify-fall-back-fonts)
- [Can an img be supported as a thumbnail, linked to the original?](https://forum.plantuml.net/10495/can-an-img-be-supported-as-a-thumbnail-to-the-original)
- [Formatting when forking over colored swimlanes](https://forum.plantuml.net/10476/formatting-when-forking-over-colored-swimlanes)
- [link does not get parsed in plantuml.1.2019.12](https://forum.plantuml.net/10445/link-is-not-parsed-in-the-latest-version)
- [Can I reference a png from the include path](https://forum.plantuml.net/10549/can-i-reference-a-png-from-the-include-path)

## V1.2019.12 (November 3, 2019)

- [Fix coloring regression](https://github.com/plantuml/plantuml/issues/43#issuecomment-547150737)
- [Style rendering in mindmaps broken](https://forum.plantuml.net/10379/style-rendering-in-mindmaps-broken)
- [Kubernetes-icons included in PlantUML Standard Library](http://plantuml.com/stdlib)
- [plantuml_version no longer working, starting with version 1.2019.6](https://forum.plantuml.net/10347/%25plantuml_version%25-longer-working-starting-with-version)
- [Tilde character cannot be escaped](https://github.com/plantuml/plantuml/issues/268)
- [cannot remove shadow in sequence diagrams for all kind of participants](https://forum.plantuml.net/10348/cannot-remove-shadow-sequence-diagrams-kind-participants)
- [Part time workers in gantt diagrams (individual holidays)](https://forum.plantuml.net/10300/part-time-workers-in-gantt-diagrams-individual-holidays)
- [preserveAspectRatio is not configurable](https://github.com/plantuml/plantuml/issues/267)
- [CSS over two lines](https://github.com/plantuml/plantuml/issues/263)
- [Error if not at least a newline in class, namespace, package](https://forum.plantuml.net/10266/error-if-not-at-least-a-newline-in-class-namespace-package)

## V1.2019.11 (September 22, 2019)

- [Is it possible to combine the icons with text formats](https://forum.plantuml.net/10223/possible-combine-icons-with-formats-icon-replaced-anymore)
- [Don't require dot for shapeless diagrams and svg output](https://forum.plantuml.net/10200/dont-require-dot-for-shapeless-diagrams-and-svg-output)
- [Extend mindmap syntax to allow multiline nodes](https://forum.plantuml.net/10203/extend-mindmap-syntax-to-allow-multiline-nodes)
- [Cannot combine "skinparam wrapWidth" with icons](https://forum.plantuml.net/10195/cannot-combine-skinparam-wrapwidth-with-icons)
- [Sequence Diagrams with Diagrams In Note And Functions](https://forum.plantuml.net/10157/sequence-diagrams-with-diagrams-in-note-and-functions)
- [text of relations between "container rectangles" are not correct formatted](https://forum.plantuml.net/10188/relations-between-container-rectangles-correct-formatted)
- [UnsupportedOperationException: plantuml.creole.AtomImg](https://forum.plantuml.net/10163/unsupportedoperationexception-plantuml-creole-atomimg)
- [Preprocessor: function %substr 2nd parameter only takes the first value of the formula as parameter](https://github.com/plantuml/plantuml/issues/257)

## V1.2019.10 (September 14, 2019)

- [New preprocessor: returning elements from functions](https://forum.plantuml.net/10082/new-preprocessor-returning-elements-from-functions)
- [Teoz: note issue](https://forum.plantuml.net/10099/teoz-%26-note-over-a-b-does-not-work-vs-%26-note-over-a-does-work)
- [Assigning color to connectors](https://forum.plantuml.net/10077/assigning-color-to-connectors)
- [New activity diagram syntax error when using openicon](https://forum.plantuml.net/10062/new-activity-diagram-syntax-error-when-using-openicon)
- [UnsupportedOperationException: AtomWithMargin](https://forum.plantuml.net/10048/unsupportedoperationexception-atomwithmargin)
- [Activity-beta: Background color is ignored in case of more than one note](https://forum.plantuml.net/10044/activity-beta-background-color-ignored-case-more-than-note)
- [split fork if swimlane Bug](https://forum.plantuml.net/10017/split-fork-if-swimlane-bug)
- [Text before and after functions is discarded by the v2 preprocessor](https://forum.plantuml.net/9755/text-before-and-after-functions-discarded-the-preprocessor)
- [Namespace label formating](https://forum.plantuml.net/1762/namespace-label-formating)
- [Style-BETA: user defined style not working for mindmaps](https://forum.plantuml.net/10143/style-beta-user-defined-style-not-working-for-mindmaps)

## V1.2019.9 (August 26, 2019)

- [Macros in macro parameters does not work](https://forum.plantuml.net/9998/macros-in-macro-parameters-does-not-work)
- [Skinparam not working on Activity embedded into partition](https://forum.plantuml.net/9981/skinparam-working-partition-with-activity-syntax-embedded)
- [Bug + fix: white spaces in preprocessor macros](https://forum.plantuml.net/9963/bug-fix-white-spaces-in-preprocessor-macros)
- [Component Diagrams: please add link direction/type token into the id of the corresponding SVG path](https://forum.plantuml.net/9972/component-diagrams-please-direction-token-corresponding)
- [Max size for notes](https://github.com/plantuml/plantuml/issues/104)
- [Splicing Up Notes](https://forum.plantuml.net/9951/splicing-up-notes)
- [include file in tooltip](https://forum.plantuml.net/9943/include-file-in-tooltip)
- [Exception occurred rendering](https://github.com/esteinberg/plantuml4idea/issues/221)
- [Teoz renderer does not support "mainframe" keyword](https://github.com/plantuml/plantuml/issues/230)
- [Template parameter boxes rendered with no lines in eps](https://github.com/plantuml/plantuml/issues/233)
- [More compact specification of nested namespaces](https://forum.plantuml.net/9893/more-compact-specification-of-nested-namespaces)
- [Background color is ignored in case of more than one note](https://forum.plantuml.net/10044/activity-beta-background-color-ignored-case-more-than-note)
- [Pipemap for diagrams containing no links give non-zero exit code](https://forum.plantuml.net/10049/2019-pipemap-diagrams-containing-links-give-zero-exit-code)

## V1.2019.8 (July 13, 2019)

- [Alpha testing of new Style feature](http://wiki.plantuml.net/site/style-evolution)
- [backgroundColor of swimlane title](https://forum.plantuml.net/9653/backgroundcolor-of-swimlane-title)
- [Split/While Bug - with a couple of workarounds](https://forum.plantuml.net/9684/split-while-bug-with-a-couple-of-workarounds)
- [skinparam monochrome does not get inherited within the embedded diagram](https://forum.plantuml.net/9705/skinparam-monochrome-does-inherited-within-embedded-diagram)
- [No text alignment skinparam for labels in state diagram](https://github.com/plantuml/plantuml/issues/210)
- [Is it possible to add an hyperlink to an image](https://forum.plantuml.net/9671/is-it-possible-to-add-an-hyperlink-to-an-image)
- ["hide empty description" in state diagram breaks sequence diagram](https://github.com/plantuml/plantuml/issues/212)
- [Changed behaviour from Vers. 2019.5 to Vers. 2019.6](https://forum.plantuml.net/9880/changed-behaviour-from-vers-2019-5-to-vers-2019-6)
- [Teoz group header overlaps note](https://forum.plantuml.net/9861/teoz-group-header-overlaps-note)
- [Adding [dashed] style fails diagram generation](https://forum.plantuml.net/9845/adding-dashed-style-fails-diagram-generation)
- [New Activity diagrams don't support function calls in else branch](https://github.com/plantuml/plantuml/issues/226)
- [Include PlantUML version numer in testdot output](https://github.com/plantuml/plantuml/issues/216)
- [Java error occurs when sequence diagram message has both note and duration](https://github.com/plantuml/plantuml/issues/229)

## V1.2019.7 (June 24, 2019)

- [Sequence diagram: Note over all](https://forum.plantuml.net/9738/sequence-diagram-note-over-all)
- [Is it possible to add an hyperlink to an image](https://forum.plantuml.net/9671/is-it-possible-to-add-an-hyperlink-to-an-image)
- [Bad arrow routing in sequence diagram with swimlanes](https://forum.plantuml.net/9718/bad-arrow-routing-in-sequence-diagram-with-swimlanes)
- [skinparam monochrome does not get inherited within the embedded diagram](https://forum.plantuml.net/9705/skinparam-monochrome-does-inherited-within-embedded-diagram)
- [Split/While Bug - with a couple of workarounds](https://forum.plantuml.net/9684/split-while-bug-with-a-couple-of-workarounds)
- [backgroundColor of swimlane title](https://forum.plantuml.net/9653/backgroundcolor-of-swimlane-title)
- [Legend comes on top of title when having large header](https://forum.plantuml.net/9660/legend-comes-on-top-of-title-when-having-large-header)
- [Arrow inversion with skinparam linetype ortho and missing arrow part](http://forum.plantuml.net/9421/arrow-inversion-with-skinparam-linetype-ortho-missing-arrow)
- ["hide empty description" in state diagram breaks sequence diagram](https://github.com/plantuml/plantuml/issues/212)
- [No text alignment skinparam for labels in state diagram](https://github.com/plantuml/plantuml/issues/210)

## V1.2019.6 (May 24, 2019)

- [Syntax error with includesub with comments since 2018.11](https://forum.plantuml.net/9381/syntax-error-w-with-includesub-with-comments-since-2018-11)
- [Arrow inversion with skinparam linetype ortho and missing arrow part](https://forum.plantuml.net/9421/arrow-inversion-with-skinparam-linetype-ortho-missing-arrow)
- [Style Chopped-off Corners for Archimate](https://forum.plantuml.net/9530/style-chopped-off-corners-for-archimate-motivation-elements)
- [Archimate - using a Node for Technology: Device](https://forum.plantuml.net/9525/archimate-using-a-node-for-technology-device)
- [How can I style Archimate elements individually using skinparams](https://forum.plantuml.net/9509/how-style-archimate-elements-individually-using-skinparams)
- [Stereotype note over multiple participants is crashing](https://forum.plantuml.net/9405/stereotype-note-over-multiple-participants-is-crashing)
- [Decision node in loop](https://github.com/plantuml/plantuml-server/issues/101)
- [Crash when processing activity diagram](https://github.com/plantuml/plantuml/issues/202)
- [sequenceArrowThickness does not work with teoz](https://github.com/plantuml/plantuml/issues/198)
- [Activity diagram: ELSE arrow for a "switch-like" breaks sometimes](https://github.com/plantuml/plantuml/issues/193)

## V1.2019.5 (April 20, 2019)

- [Lifeline starts above created object; should not be visible](https://forum.plantuml.net/9330/diagrams-lifeline-starts-above-created-object-should-visible)
- [why queue "a" notation fails?](https://forum.plantuml.net/9333/why-queue-a-as-a-notation-fails)
- [color of activations/lifelines are same when they are on same row](https://forum.plantuml.net/9366/teoz-bug-color-activations-lifelines-are-same-when-they-same)
- [teoz + create + note issue](https://forum.plantuml.net/9321/teoz-create-%26-note-issue)
- [Embedding in interface note fails](https://forum.plantuml.net/9341/embedding-in-interface-note-fails)
- [Please allow to hide clases by stereotype using the "hide" keyword](https://forum.plantuml.net/4259/please-allow-hide-clases-stereotype-using-the-hide-keyword?show=9318#c9318)
- [activity diagram - swim lane -> whitespace issue](https://forum.plantuml.net/9288/issue-activity-diagram-swim-lane-whitespace-issue)
- [Syntax error with includesub with comments since 2018.11](https://forum.plantuml.net/9381/syntax-error-w-with-includesub-with-comments-since-2018-11)
- [Interface consumption socket](https://github.com/plantuml/plantuml-server/issues/94)
- [namespaceSeparator = none breaks class association](https://github.com/plantuml/plantuml/issues/185)

## V1.2019.4 (March 31, 2019)

- [Two or more break statement does not work correctly](https://forum.plantuml.net/9160/two-or-more-break-statement-doew-not-work-correctly)
- [Customize Stereotype display](https://forum.plantuml.net/9227/customize-stereotype-display)
- [Improved legend support](https://forum.plantuml.net/8706/improved-legend-support)

## V1.2019.3 (March 10, 2019)

- [Please provide skinparam shadowing false for all elements individually](https://forum.plantuml.net/5366/please-provide-skinparam-shadowing-elements-individually)
- [UnsupportedOperationException at latex output and interfaces](https://github.com/plantuml/plantuml/issues/178)
- [teoz crash with arrow to self](https://forum.plantuml.net/9131/teoz-crash-with-arrow-to-self)
- [Is combination of break and detach statement supported](https://forum.plantuml.net/9108/is-combination-of-break-and-detach-statement-supported)

## V1.2019.2 (March 1, 2019)

- [Not able to use partition inside repeat](https://forum.plantuml.net/9065/not-able-to-use-partition-inside-repeat)
- [skinparam handwritten true is not inherited within embedded diagram](https://forum.plantuml.net/9043/skinparam-handwritten-inherited-within-embedded-diagram)
- [Teoz wrong note position after array](https://forum.plantuml.net/8612/teoz-wrong-note-position-after-array)
- [Why no gradient support for sequence diagram boxes](https://forum.plantuml.net/9018/why-no-gradient-support-for-sequence-diagram-boxes)
- [Colored return lines in Sequence Diagrams](https://forum.plantuml.net/9017/colored-return-lines-in-sequence-diagrams)
- [Dependency between packages containing classes](https://forum.plantuml.net/8975/dependency-between-packages-containing-classes)
- [Scaling of the sprites or images](https://forum.plantuml.net/4267/scaling-of-the-sprites-or-images)
- [Notes on fields when some fields have visibility modifiers causes an exception](https://forum.plantuml.net/8984/notes-fields-fields-visibility-modifiers-causes-exception)
- [Links not working](https://forum.plantuml.net/8954/links-not-working)

## V1.2019.1 (February 9, 2019)

- [Box title syntax error](https://forum.plantuml.net/8933/box-title-syntax-error)
- [defaultTextAlignment too mighty](https://forum.plantuml.net/8932/defaulttextalignment-too-mighty)
- [the autonumber variable is displayed incorrectly if the note is assigned between two participants](https://forum.plantuml.net/8922/autonumber-variable-displayed-incorrectly-participants)
- [Improved legend support](https://forum.plantuml.net/8706/improved-legend-support)
- [Inconsistent placements of legend and title across diagram types](https://forum.plantuml.net/8751/inconsistent-placements-legend-title-across-diagram-types)
- [Elseif SkinParam doesn't seem to use the ActivityDiamond](https://forum.plantuml.net/8025/elseif-skinparam-doesnt-seem-to-use-the-activitydiamond)

## V1.2019.0 (January 13, 2019)

- [Footer text on sequence diagrams appears over sequences](https://forum.plantuml.net/8750/footer-text-on-sequence-diagrams-appears-over-sequences)
- [WrapWidth causes bullet and number lists to behave inconsistently](https://forum.plantuml.net/8749/wrapwidth-causes-bullet-number-lists-behave-inconsistently)
- [note right breaks split in Activity-beta](https://forum.plantuml.net/8729/note-right-breaks-split-in-activity-beta)
- [Color of sprite not working with archimate and sprite from zip file](https://forum.plantuml.net/8801/color-sprite-not-working-with-archimate-and-sprite-from-file)
- [Change color of sprite](https://forum.plantuml.net/8798/change-color-of-sprite)
- [Max size for long state names](https://github.com/plantuml/plantuml/issues/104)
- [gui not working on Windows](https://github.com/plantuml/plantuml/issues/163)
- [Class diagram skinparam not applied for enum, interface, or abstract](https://github.com/plantuml/plantuml/issues/164)

## V1.2018.14 (December 21, 2018)

- [Use scrollbar in Salt](salt)
- [Gantt chart - Add "open day" feature](https://github.com/plantuml/plantuml/issues/154)
- [New -stdrpt flag](https://github.com/plantuml/plantuml/issues/155)
- [skinparam ResponseMessageBelowArrow interacts badly with participant lifetimes](https://github.com/plantuml/plantuml/issues/156)
- [Artificat in activity diagram](https://github.com/plantuml/plantuml/issues/160)
- [Activity: Hidding arrow entering a split does not work](https://forum.plantuml.net/8662/activity-hidding-arrow-entering-a-split-does-not-work)
- [Activity: Arrow color before a start is assigned to the wrong arrow](https://forum.plantuml.net/8663/activity-arrow-color-before-start-assigned-the-wrong-arrow)
- [Use of ## in !define macro stops macro replacement](https://forum.plantuml.net/8649/use-of-%23%23-in-define-macro-stops-macro-replacement)
- [Cutting off component diagram interfaces](https://forum.plantuml.net/8652/cutting-off-component-diagram-interfaces)
- [Interaction frame](https://forum.plantuml.net/4019/interaction-frame)
- [Align text on arrows of sequence digrams](https://forum.plantuml.net/8626/align-text-on-arrows-of-sequence-digrams)
- [note right breaks split in Activity-beta](https://forum.plantuml.net/8729/note-right-breaks-split-in-activity-beta)
- [skinparam defaultTextAlignment center does not work on elseif boxes](https://forum.plantuml.net/8701/skinparam-defaulttextalignment-center-does-elseif-boxes)
- [Hide the Activities in Activity diagram](https://forum.plantuml.net/8690/hide-the-activities-in-activity-diagram)
- [Bug on class diagram relations with an "Header" class](https://forum.plantuml.net/8688/bug-on-class-diagram-relations-with-an-header-class)

## V1.2018.13 (November 26, 2018)

- [Support for Network Diagrams](http://plantuml.com/nwdiag)
- [UnsupportedOperationException in gantt](https://forum.plantuml.net/8532/unsupportedoperationexception-in-gantt)
- [Add option to hide alias on folder top part](https://forum.plantuml.net/8575/add-option-to-hide-alias-on-folder-top-part)
- [report when no diagram found in source](https://forum.plantuml.net/8571/suggestion-report-when-no-diagram-found-in-source)
- [svgLinkTarget not working](https://forum.plantuml.net/8572/svglinktarget-not-working)
- [FontColor for Timing diagrams](https://forum.plantuml.net/8527/fontcolor-for-timing-diagrams)
- [Skinparam RoundCorners breaks when setting individual background on elements with stereotype](https://forum.plantuml.net/8534/skinparam-roundcorners-individual-background-stereotype)
- [Skinparam from command line breaks salt diagrams](https://forum.plantuml.net/8491/skinparam-from-command-line-breaks-salt-diagrams)
- [How to conditionally connect components](https://forum.plantuml.net/8458/how-to-conditionally-connect-components)
- [Skinparam rectangle not working in Activity beta](https://forum.plantuml.net/8598/skinparam-rectangle-not-working-in-activity-beta)
- [Max size for long state names](https://github.com/plantuml/plantuml/issues/104)
- [Detach in split drawing wrong lines](https://forum.plantuml.net/8619/detach-in-split-drawing-wrong-lines)
- [autonumber problem with note right of](https://forum.plantuml.net/8614/autonumber-problem-with-note-right-of)
- [Teoz wrong note position after array](https://forum.plantuml.net/8612/teoz-wrong-note-position-after-array)
- [hide footbox not recognized in timing diagrams](https://forum.plantuml.net/8089/hide-footbox-not-recognized-in-timing-diagrams)
- [Align text on arrows of sequence digrams](https://forum.plantuml.net/8626/align-text-on-arrows-of-sequence-digrams)
- [interaction frame](https://forum.plantuml.net/4019/interaction-frame)
- [Option to throw ErrorUml](https://github.com/plantuml/plantuml/issues/152)

## V1.2018.12 (October 21, 2018)

- [Regression in component diagram layout](https://forum.plantuml.net/8442/regression-in-2018-03-2018-11-component-diagram-layout)
- [Gradient background colors respond to scale twice](https://forum.plantuml.net/8445/gradient-background-colors-respond-to-scale-twice)
- [Sprites are not interpreted in hyperlink display text](https://forum.plantuml.net/8434/sprites-are-not-interpreted-in-byperlink-display-text)
- [Encoding seems to be lost after export to PNG and extract back](https://forum.plantuml.net/8378/encoding-seems-to-be-lost-after-export-to-png-and-extract-back)
- [Version 1.2018.11 doesn't work with comments in config file](https://forum.plantuml.net/8339/plantuml-2018-11-jar-doesnt-work-with-comments-in-config-file)
- [Version 1.2018.11 cannot !include with pipe](https://forum.plantuml.net/8338/latest-plantuml-version-1-2018-11-cannot-include-with-pipe)
- [Adding diamond keyword in class diagram](https://forum.plantuml.net/8317/do-digraphs-not-work-with-entities)
- [Use !include from within a Macro](https://forum.plantuml.net/7939/use-include-from-within-a-macro)
- [Why don't sprites scale properly](https://forum.plantuml.net/8350/why-dont-sprites-scale-properly)
- [Use long description with archimate elements](https://forum.plantuml.net/8333/use-long-description-with-archimate-elements)
- [Issue when changing skinparam defaultTextAlignment from center to right](https://forum.plantuml.net/8309/spectacular-blowup-changing-skinparam-defaulttextalignment)
- [Support visibility on compositions and aggregations](https://forum.plantuml.net/8294/support-visibility-on-compositions-and-aggregations)
- [Text alignment skinparam for rnote and hnote](https://github.com/plantuml/plantuml/issues/146)
- [Relative !include path resolution in Eclipse preview broken](https://github.com/hallvard/plantuml/issues/73)

## V1.2018.11 (September 22, 2018)

- [Set Background Color of Latex Math Entries](https://forum.plantuml.net/8242/set-background-color-of-latex-math-entries)
- [skinparam packageShadowing not working for class-diagrams](https://forum.plantuml.net/8233/bug-skinparam-packageshadowing-not-working-class-diagrams)
- [Allow turn on/off shadowing for elements with stereotypes](https://forum.plantuml.net/8179/allow-turn-on-off-shadowing-for-elements-with-stereotypes)
- [class Method cannot be hidden](https://forum.plantuml.net/8159/class-method-cannot-be-hidden)
- [Max size for notes](https://github.com/plantuml/plantuml/issues/104)
- [Labels overlapping in component diagrams](https://github.com/plantuml/plantuml/issues/140)
- [svglinktarget param set by FileFormatOption is overridden](https://github.com/plantuml/plantuml/issues/144)
- [Tabulation character doesn't work in legend](https://forum.plantuml.net/8067/tabulation-character-doesnt-work-in-legend)
- [Teoz: Nesting a group causes parent group to expand all the way left](https://forum.plantuml.net/8104/teoz-nesting-group-causes-parent-group-expand-all-the-way-left)
- [Teoz: Autonumbering is not applied for messages to left or right of flow](https://forum.plantuml.net/8105/teoz-autonumbering-not-applied-for-messages-left-right-flow)
- [Includes from Classpath or local Zip-file](https://forum.plantuml.net/8108/includes-from-classpath-or-local-zip-file)
- [It is still would be useful to style partitions in activity-beta diagrams with skinparam](https://forum.plantuml.net/3626/still-would-useful-partitions-activity-diagrams-skinparam)
- [Elseif SkinParam doesn't seem to use the ActivityDiamond](https://forum.plantuml.net/8025/elseif-skinparam-doesnt-seem-to-use-the-activitydiamond)
- [Improve text on arrows in activity diagram](https://forum.plantuml.net/8158/improve-text-on-arrows-in-activity-diagram)
- [partition are not compacted if distributed over multiple swimlane](https://forum.plantuml.net/7859/partition-are-compacted-distributed-over-multiple-swimlane)
- [Formatting state actions sometimes doesn't work](https://forum.plantuml.net/8264/formatting-state-actions-sometimes-doesnt-work)

## V1.2018.10 (August 26, 2018)

- [Weird stereotype sprite alignment in rectangle and database containers](https://forum.plantuml.net/7986/stereotype-sprite-alignment-rectangle-database-containers)
- [Elseif SkinParam doesn't seem to use the ActivityDiamond](https://forum.plantuml.net/8025/elseif-skinparam-doesnt-seem-to-use-the-activitydiamond)
- [Style partitions in activity-beta diagrams with skinparam](https://forum.plantuml.net/3626/still-would-useful-partitions-activity-diagrams-skinparam)
- [Includes from Classpath or local Zip-file](https://forum.plantuml.net/8108/includes-from-classpath-or-local-zip-file)
- [Autonumbering is not applied for messages to left or right of flow](https://forum.plantuml.net/8105/teoz-autonumbering-not-applied-for-messages-left-right-flow)
- [Nesting a group causes parent group to expand all the way left](https://forum.plantuml.net/8104/teoz-nesting-group-causes-parent-group-expand-all-the-way-left)
- [PlantUML stdlib upgrade](https://forum.plantuml.net/8083/update-plantuml-icon-font-sprites)
- [Tabulation character doesn't work in legend](https://forum.plantuml.net/8067/tabulation-character-doesnt-work-in-legend)
- [Labels overlapping in component diagrams](https://github.com/plantuml/plantuml/issues/140)

## V1.2018.9 (July 27, 2018)

- [SVG in mathexpressions without style information](https://forum.plantuml.net/7983/svg-in-mathexpressions-without-style-information)
- [Weird stereotype sprite alignment in rectangle and database containers](https://forum.plantuml.net/7986/stereotype-sprite-alignment-rectangle-database-containers)
- [just a note over an activated lifeline does not work](https://forum.plantuml.net/7968/just-a-note-over-an-activated-lifeline-does-not-work)
- [How do you add a link to multiline component](https://forum.plantuml.net/7911/how-do-you-add-a-link-to-multiline-component)
- [Is it possible to run only the preprocessor](https://forum.plantuml.net/7944/is-it-possible-to-run-only-the-preprocessor)
- [Is it possible to wrap swimlane headings automatically](https://forum.plantuml.net/7876/possible-wrap-swimlane-headings-automatically-rather-using)
- [Is it possibly to automatically wrap text in swimlane boxes](https://forum.plantuml.net/7836/possibly-automatically-swimlane-boxes-rather-having-manually)
- [Documentation skinparameters](https://forum.plantuml.net/7882/documentation-skinparameters)
- [Version 1.2018.07 DPI handling](https://forum.plantuml.net/7801/version-1-2018-07-dpi-handling)
- [Milestones at fixed events](https://forum.plantuml.net/7782/milestones-at-fixed-events)
- [tasks ends on a date](https://forum.plantuml.net/7870/gantt-tasks-ends-on-a-date)
- [Missing title in the ASCII art of a sequence diagram](https://github.com/plantuml/plantuml/issues/137)
- [sequenceMessageAlign direction does not center for arrow in two directions](https://github.com/plantuml/plantuml/issues/132)
- [Note text has no text alignment skinparam and default alignment is not applied](https://github.com/plantuml/plantuml/issues/134)

## V1.2018.8 (June 24, 2018)

- [Crash with teoz](https://forum.plantuml.net/7821/crash-with-teoz)
- [Devicons and Font Awesome library](https://forum.plantuml.net/7827/devicons-and-font-awesome-library-in-%40salt)
- [How to use BoxPadding with Teoz](https://forum.plantuml.net/7817/how-to-use-boxpadding-with-teoz)
- [DPI handling](https://forum.plantuml.net/7801/version-1-2018-07-dpi-handling)
- [Please provide skinparam shadowing false for all elements individually](https://forum.plantuml.net/5366/please-provide-skinparam-shadowing-elements-individually)
- [Stereotyped multi-line notes on messages](https://forum.plantuml.net/7770/stereotyped-multi-line-notes-on-messages)
- [Gantt chart colorize time sections](https://forum.plantuml.net/7781/gantt-chart-colorize-time-sections)
- [Problem with txt / utxt (ASCII-art) output for standard commands](https://forum.plantuml.net/7799/problem-with-utxt-ascii-output-standard-commands-also-tscxml)

## V1.2018.7 (June 11, 2018)

- [New release of PlantUML Standard Library](stdlib)
- [Null pointer exception, possible erroneous output from newpage](https://github.com/plantuml/plantuml/issues/124)
- [Usage of Clipboard as hidden I/O pipe](https://forum.plantuml.net/7730/usage-clipboard-hidden-pipe-instead-input-text-output-image)
- [directory selection is broken preventing new target directory from being specified](https://forum.plantuml.net/7726/plantuml-directory-selection-preventing-directory-specified)
- [Support Allman brace style](https://github.com/plantuml/plantuml/issues/99)
- [Backgroundcolor in math block](https://forum.plantuml.net/7764/backgroundcolor-in-%40startmath-%40endmath-block)
- [text rendered in math is not scaled by scale command](https://forum.plantuml.net/7688/text-rendered-in-math-is-not-scaled-by-scale-command)
- [Formatting options inside startmath](https://forum.plantuml.net/7708/formatting-options-inside-%40startmath-%40endmath)
- [Skinparam and hidden Stereotypes](https://forum.plantuml.net/5124/skinparam-and-hidden-stereotypes)
- [Table vertical character can't be escaped](https://github.com/plantuml/plantuml/issues/125)
- [Timing Diagram: allow negative time values](https://forum.plantuml.net/7698/timing-diagram-allow-negative-time-values)
- [Don't take focus away from current window if ui is not needed](https://github.com/plantuml/plantuml/issues/121)
- [Teoz doesn't work in a "group" or "alt".](https://forum.plantuml.net/6438/teoz-doesnt-work-in-a-group-or-alt)
- [teoz box around participants](https://forum.plantuml.net/7675/teoz-box-around-participants)
- [teoz and parallel within groups is not working](https://forum.plantuml.net/7710/teoz-and-%26-within-groups-is-not-working)
- [Office Icons for PlantUML](https://github.com/Roemer/plantuml-office)
- [Cloudinsight PlantUML sprites](https://github.com/rabelenda/cicon-plantuml-sprites)

## V1.2018.6 (May 21, 2018)

- [Improved support for GraphViz on MacOS](https://forum.plantuml.net/7656/change-path-for-graphviz)
- [Fix newpage crash](https://forum.plantuml.net/7654/newpage-expression-crashes-versions-1-2018-4-%26-1-2018-5)
- [Improve jar start up time](https://github.com/plantuml/plantuml/issues/123)

## V1.2018.5 (May 5, 2018)

- [Order of states in timing diagram](https://forum.plantuml.net/6651/order-of-states-in-timing-diagram)
- [Activity beta: arrow is longer in partition](https://forum.plantuml.net/7617/activity-beta-arrow-is-loger-in-partition)

## V1.2018.4 (May 1, 2018)

- [EntityFont skinparams don't appear to work in sequence diagram](https://forum.plantuml.net/7591/entityfont-skinparams-dont-appear-to-work-sequence-diagram)
- [Rendering error on component diagram require/provide interface connection](https://forum.plantuml.net/7156/rendering-component-diagram-require-interface-connection)
- [With ParticipantPadding, Create Message arrow is on wrong position.](https://forum.plantuml.net/7574/with-participantpadding-create-message-arrow-wrong-position)
- [How do you color a partition in new Activity syntax](https://forum.plantuml.net/7551/how-do-you-color-a-partition-in-new-activity-syntax)
- [Component diagram crashes when changing from component to interface](https://forum.plantuml.net/7497/component-diagram-crashes-when-changing-component-interface)
- [Note breaks the component diagram if 0-dashed-0 arrow is used](https://forum.plantuml.net/7588/note-breaks-the-component-diagram-if-0-dashed-0-arrow-is-used)
- [miss an actual skinparameter from the -language list](https://forum.plantuml.net/7563/miss-an-actual-skinparameter-from-the-language-list)

## V1.2018.3 (April 5, 2018)

- [Diagonal Corner](https://forum.plantuml.net/7485/diagonal-corner)
- [Cards and rectangles have the same formatting](https://forum.plantuml.net/7463/cards-and-rectangles-have-the-same-formatting)
- [EPS output does not support dashed states](https://forum.plantuml.net/7464/eps-output-does-not-support-%23%23-dashed-states)
- [Support for multiple label arrows in use case diagram](https://forum.plantuml.net/7411/support-for-multiple-label-arrows-in-use-case-diagram)
- [Tool tip doesn't work on down arrow](https://forum.plantuml.net/7424/tool-tip-doesnt-work-on-down-arrow)
- [An error has occurred: java.lang.NullPointerException](https://github.com/plantuml/plantuml/issues/105)
- [Fix Timing diagram case when introducing constraint that lies before](https://github.com/plantuml/plantuml/pull/109)
- [New flag -checkmetadata in the command line](https://github.com/plantuml/plantuml/issues/112)
- [New Gantt diagram features.](gantt-diagram)

## V1.2018.2 (March 9, 2018)

- [Max size for notes](https://github.com/plantuml/plantuml/issues/104)
- [Hide/Remove feature](https://forum.plantuml.net/7337/classes-then-show-only-classes-bearing-given-class-diagram)
- [How do I change the spot letter by stereotype](https://forum.plantuml.net/7348/how-do-i-change-the-spot-letter-by-stereotype)
- [In State diagrams, Concurrent color customization not honored](https://forum.plantuml.net/7329/state-diagrams-concurrent-color-customization-not-honored)
- [single detach circle after ELSE as STOP symbol](https://forum.plantuml.net/7360/drawing-single-detach-circle-after-symbol-level-with-desicion)
- [A way to disable style, width and heigth attributes in SVG](https://forum.plantuml.net/7334/disable-style-heigth-attributes-exported-scaling-browsers)
- [Break in while loop renders incorrectly](https://forum.plantuml.net/7306/break-in-while-loop-renders-incorrectly)
- [Empty title results in java.lang.illegalArgumentException](https://forum.plantuml.net/7286/empty-title-results-in-java-lang-illegalargumentexception)
- [How can I hide members in ASCII art class diagram](https://forum.plantuml.net/7265/how-can-i-hide-members-in-ascii-art-class-diagram)
- [Set LegendBorderThickness to 0](https://forum.plantuml.net/7184/set-legendborderthickness-to-0)
- [componentBorderColor does not work for all notations](https://forum.plantuml.net/7172/componentbordercolor-does-not-work-for-all-notations)
- [autonumber variable in sequence diagram](https://forum.plantuml.net/7119/create-links-after-creating-a-diagram)
- [Defining two folder entities with the same name generate a java.lang.IllegalArgumentException](https://forum.plantuml.net/7081/defining-folder-entities-generate-illegalargumentexception)

## V1.2018.1 (January 28, 2018)

- [Prefix inlined dependencies](https://github.com/plantuml/plantuml/issues/91)
- [can i do round corners of elements in component diagrams](https://forum.plantuml.net/6915/can-i-do-round-corners-of-elements-in-component-diagrams)
- [change participant order in sequence diagram](https://forum.plantuml.net/6993/conditional-conditional-creation-participants-participants)
- [Simplier way to deactivate lifeline without return message](https://forum.plantuml.net/7024/simplier-way-to-deactivate-lifeline-without-return-message)
- [Shadowing false doesn't work with all elements](https://forum.plantuml.net/7000/shadowing-false-doesnt-work-with-all-elements)
- [Sequence Diagram Skinparam for Collections BorderColor is wrongly using ParticipantBorderColor setting.](https://forum.plantuml.net/6950/skinparam-collections-bordercolor-participantbordercolor)

## V1.2018.0 (January 4, 2018)

- [Fix image rendering in Gitlab](https://github.com/plantuml/plantuml-server/issues/63)
- [Improved Sphinx integration](https://github.com/plantuml/plantuml/issues/62)
- [The -D option of command line does't work when -pipe option is used](https://forum.plantuml.net/6868/the-option-of-command-line-doest-work-when-pipe-option-is-used)
- [Dashed Border on Single Rectangle](https://forum.plantuml.net/6852/dashed-border-on-single-rectangle)
- [definelong requires extra { charater](https://forum.plantuml.net/6837/definelong-requires-extra-charater)
- [Comments are interpreted as code in macro](https://forum.plantuml.net/6863/comments-are-interpreted-as-code-in-macro)
- [Adding componentBorderThickness](https://forum.plantuml.net/1831/border-thickness)
- [Timing Diagram: Feature request for adding notes](https://forum.plantuml.net/6877/timing-diagram-feature-request-for-adding-notes)

## V1.2017.20 (December 11, 2017)

- [Integration of Google Material Icons](https://github.com/plantuml/plantuml-stdlib)
- [Block comment before code gives syntax error](https://forum.plantuml.net/6864/block-comment-before-code-gives-syntax-error)
- [Image transparency](https://forum.plantuml.net/6839/image-transparency)
- [how to best use the new icon features](https://forum.plantuml.net/6850/how-to-best-use-the-new-icon-features)
- [syntax breaking in component diagram](https://forum.plantuml.net/6830/syntax-breaking-in-component-diagram)
- [Dashed Border on Single Rectangle](https://forum.plantuml.net/6852/dashed-border-on-single-rectangle)
- [How do I change the border style of a rectangle](https://forum.plantuml.net/6249/how-do-i-change-the-border-style-of-a-rectangle)
- [Bugs of generating image map with pipe](https://forum.plantuml.net/6802/bugs-of-generating-image-map-with-pipe)
- [OpenIconic icons dont work inside labeled hyperlinks in sequence diagrams](https://forum.plantuml.net/6782/openiconic-icons-inside-labeled-hyperlinks-sequence-diagrams)
- [access to filename](https://forum.plantuml.net/6289/access-to-filename)
- [skinparam PartitionBorderColor does not work](https://forum.plantuml.net/6773/skinparam-partitionbordercolor-does-not-work)

## V1.2017.19 (November 12, 2017)

- [Integration of Icon-Font Sprites icons](https://github.com/tupadr3/plantuml-icon-font-sprites/issues/2)
- [Add "Zoom width" option](https://forum.plantuml.net/6712/add-zoom-width-option)
- [Performance problem](https://forum.plantuml.net/6351/performance-problem)
- [Add special char in LaTex-Export](https://forum.plantuml.net/6702/add-to-%26-in-latex-export)
- [Page numbers](https://forum.plantuml.net/6699/page-numbers)
- [Add support for "multiple instances" display in all diagram](https://forum.plantuml.net/6688/add-support-for-multiple-instances-display-in-all-diagram)
- [Alias of interfaces in component diagrams](https://forum.plantuml.net/6389/alias-of-interfaces-in-component-diagrams)
- [Ability to include blocks from other file without using startuml](https://forum.plantuml.net/6577/ability-include-blocks-from-other-file-without-using-startuml)
- [File encoding of LaTeX export](https://forum.plantuml.net/6596/file-encoding-of-latex-export)
- [Cannot recognize included file in config file](https://forum.plantuml.net/6718/cannot-recognize-included-file-in-config-file)
- [How do I change the border style of a rectangle](https://forum.plantuml.net/6249/how-do-i-change-the-border-style-of-a-rectangle)
- [Whether is it possible to set SequenceBoxBackgroundColor = transparent](https://forum.plantuml.net/6728/whether-possible-sequenceboxbackgroundcolor-transparent)
- [Config file doesn't include another config file using command line](https://forum.plantuml.net/6617/config-file-doesnt-include-another-config-file-using-command)
- [abstract and static not handled in class diagram for latex output](https://github.com/plantuml/plantuml/issues/79)
- [Special characters not handled in latex output](https://github.com/plantuml/plantuml/issues/81)
- [Dashed line is not generated for latex output](https://github.com/plantuml/plantuml/issues/80)

## V1.2017.18 (October 7, 2017)

- [title, note and legend are not supported in timing diagrams](https://forum.plantuml.net/6538/title-note-and-legend-are-not-supported-in-timing-diagrams)
- [Wrong class widths after LaTeX export](https://forum.plantuml.net/6495/wrong-class-widths-after-latex-export)
- [Acivity diagramm - loop without closing decider](https://forum.plantuml.net/6545/acivity-diagramm-loop-without-closing-decider)
- [Exceptions during export with color gradients](https://forum.plantuml.net/6481/exceptions-during-export-with-color-gradients)
- [Missing background color of databases after LaTeX export](https://forum.plantuml.net/6493/missing-background-color-of-databases-after-latex-export)
- [Create PDF generates Error](https://forum.plantuml.net/6497/create-generates-cannot-access-transcoder-image-application)
- [Beautiful C in classes after LaTeX export](https://forum.plantuml.net/6496/beautiful-c-in-classes-after-latex-export)
- [Multiple stereotypes on one component](https://forum.plantuml.net/4282/multiple-stereotypes-on-one-component)
- [allow_mixing not working for rectangle inside rectangle](https://forum.plantuml.net/6453/allow_mixing-not-working-for-rectangle-inside-rectangle)
- [How to style the lollipop color](https://forum.plantuml.net/6424/how-to-style-the-lollipop-color-of-a-deployment-diagram)
- [Issue in OpenJDK](https://github.com/plantuml/plantuml/issues/69)
- [txt, tutxt does not handle multi-byte string](https://github.com/plantuml/plantuml/issues/74)
- [Integrate AWS-PlantUML into PlantUML](https://github.com/milo-minderbinder/AWS-PlantUML/issues/20)

## V1.2017.16 (September 3, 2017)

- [Older way to show generics in a class](https://forum.plantuml.net/6346/older-way-to-show-generics-in-a-class)
- [Colored lines change order when returned from swimlane A to swimlane B](https://forum.plantuml.net/6334/colored-lines-change-order-returned-from-swimlane-swimlane)

## V1.2017.15 (July 3, 2017)

- [Timing Diagram bugs](https://forum.plantuml.net/6282/timing-diagram-bugs)
- [specifying default values in macro result in failure](https://forum.plantuml.net/6290/specifying-default-values-in-macro-result-in-failure)
- [Support for generics/templates](https://forum.plantuml.net/6253/support-for-generics-templates)
- [hide empty members bug](https://forum.plantuml.net/6248/hide-empty-members-bug)
- [Class attribute font size issue with SVG output](https://forum.plantuml.net/6275/class-attribute-font-size-issue-with-svg-output)
- [Archimate 3 Specifications](https://github.com/plantuml/plantuml/issues/61)
- [Hide sterotype on sequence diagram](https://github.com/plantuml/plantuml/issues/58)

## V1.2017.14 (June 5, 2017)

- [computeurl does not work with pipe](https://github.com/plantuml/plantuml/issues/56)
- [Unbalanced Padding on SVG with out shadowing](https://forum.plantuml.net/6217/unbalanced-padding-on-svg-with-out-shadowing)
- [preprocessor condition, based on the current plantuml.jar version](https://forum.plantuml.net/6199/preprocessor-condition-based-current-plantuml-jar-version)
- [Are collections supported in teoz](https://forum.plantuml.net/6190/are-collections-supported-in-teoz)
- [Different -right- interface generation](https://forum.plantuml.net/6218/different-right-interface-generation-between-plantuml-2017)
- [Can multiline links be properly supported](https://forum.plantuml.net/6181/can-multiline-links-be-properly-supported)
- [Line number in Error message not correct](https://forum.plantuml.net/6171/line-number-in-error-message-not-correct)
- [Component diagram invalid text positions](https://forum.plantuml.net/6156/component-diagram-invalid-text-positions)
- [hide unlinked results in error for the following code](https://forum.plantuml.net/6161/hide-unlinked-results-in-error-for-the-following-code)
- [Border thickness](https://forum.plantuml.net/1831/border-thickness)
- [Incorrect error line number when config file used](https://forum.plantuml.net/6149/incorrect-error-line-number-when-config-file-used)

## V1.2017.13 (May 10, 2017)

- [Styling failing on conditional blocks](https://forum.plantuml.net/6102/styling-failing-on-conditional-blocks-in-beta-16)
- [entity description fails in deployment beta](https://forum.plantuml.net/6096/entity-description-fails-in-deployment-beta)
- [where is the rest text of the note](https://forum.plantuml.net/6081/where-is-the-rest-text-of-the-note)
- [Queue display bug](https://forum.plantuml.net/6084/queue-display-bug-in-1-2017-12)
- [note goes out the partition](https://forum.plantuml.net/6071/note-goes-out-the-partition)
- [floating notes on their own in swimlanes](https://forum.plantuml.net/6054/floating-notes-on-their-own-in-swimlanes-is-it-possible)
- [Bug in drawing interface connection to left or right](https://forum.plantuml.net/6033/bug-in-drawing-interface-connection-to-left-or-right)
- [Center text in activity diagram](https://forum.plantuml.net/6010/center-text-in-activity-diagram)
- [Layout problems in TEOZ engine: DIVIDER and NOTE OVER](https://forum.plantuml.net/6108/layout-problems-in-teoz-engine-divider-and-note-over)

## V1.2017.12 (April 26, 2017)

- [output file naming bug if more than 1 diagram in a single input file](https://forum.plantuml.net/5995/2017-output-file-naming-more-than-diagram-single-input-file)
- [class Diagram : hide private](https://forum.plantuml.net/5974/class-diagram-hide-private-in-case-of-include-file-use)
- [would like to represent queues and topics](https://forum.plantuml.net/5961/i-would-like-to-represent-queues-and-topics)
- [timing diagram enhancements](https://forum.plantuml.net/5948/timing-diagram-enhancements)
- [Can a defined constant be parsed correctly after backslash n](https://forum.plantuml.net/6003/can-a-defined-constant-be-parsed-correctly-after-n)
- [id in svg output](https://forum.plantuml.net/298/id-in-svg-output)

## V2017.11 (April 19, 2017)

- [Skinparam for the background color of the actionDiamond](https://forum.plantuml.net/5932/skinparam-for-the-background-color-of-the-actiondiamond)
- [timing diagram with -tsvg output](https://forum.plantuml.net/5908/timing-diagram-with-tsvg-output)
- [plantuml.jar 2017.10 appears to be broken](https://forum.plantuml.net/5904/plantuml-jar-2017-10-appears-to-be-broken)

## V2017.10 (April 6, 2017)

- [Splitted diagrams are not correctly named](https://forum.plantuml.net/5896/online-problem-sequence-doc-images-dont-always-match-title)

## V2017.09 (April 5, 2017)

- [Support for sprites salt](https://forum.plantuml.net/5849/support-for-sprites-salt)
- [how to refer to methods with parameters / return values](https://forum.plantuml.net/5835/how-to-refer-to-methods-with-parameters-return-values)
- [Activity: Add action on the return arrow of a repeat](https://forum.plantuml.net/5206/activity-add-action-on-the-return-arrow-of-a-repeat)
- [How to start generating picture with pipe mode](https://forum.plantuml.net/5711/how-to-start-generating-picture-with-pipe-mode)
- [Groupbox in salt](https://forum.plantuml.net/5840/groupbox-in-salt)
- [Repeat loop starting with action instead of condition](https://forum.plantuml.net/5826/repeat-loop-starting-with-action-instead-of-condition)
- [page (hpages)x(vpages) and multiple diagrams in source file](https://forum.plantuml.net/5822/page-hpages-x-vpages-and-multiple-diagrams-in-source-file)
- [Include block from current file](https://forum.plantuml.net/5769/include-block-from-current-file)
- [Is it possible to add metadata to SVG file like it is done for PNG files](https://forum.plantuml.net/5797/it-possible-to-add-metadata-to-svg-file-like-done-for-png-files)
- [Does PlantUML expose Graphviz ratio setting](https://forum.plantuml.net/1226/does-plantuml-expose-graphviz-ratio-setting)
- [Timing diagram problems with very large values](https://forum.plantuml.net/5783/timing-diagram-problems-with-very-large-values)
- [Change of text alignment during recent updates](https://forum.plantuml.net/5768/change-of-text-alignment-during-recent-updates)
- [Initial stat and 1st time state](https://forum.plantuml.net/5776/initial-stat-and-1st-time-state)
- [make as work consistent](https://forum.plantuml.net/5757/make-as-work-consistent)
- [error message if same name is used for different objects](https://forum.plantuml.net/5760/error-message-if-same-name-is-used-for-different-objects)
- [latex rendering fails when escaped characters are used](https://forum.plantuml.net/5741/latex-rendering-fails-when-escaped-characters-are-used-such)
- [Latex formulas don't scale](https://forum.plantuml.net/5747/latex-formulas-dont-scale-using-e-g-scale-100-width)
- [How to draw the lollipop socket symbol in a class diagram](https://forum.plantuml.net/2259/how-draw-the-lollipop-socket-symbol-class-diagram-consumes)
- [box color gets hidden by the goup definition](https://forum.plantuml.net/5866/plantuml-plantuml-sequence-diagram-color-hidden-definition)

## V2017.08 (March 21, 2017)

- [latex rendering - transparent background instead of white background](https://forum.plantuml.net/5725/rendering-transparent-background-instead-white-background)
- [How to start generating picture with pipe mode](https://forum.plantuml.net/5711/how-to-start-generating-picture-with-pipe-mode)
- [Scaling of the sprites or images](https://forum.plantuml.net/4267/scaling-of-the-sprites-or-images)
- [How to draw the lollipop socket symbol in a class diagram](https://forum.plantuml.net/2259/how-draw-the-lollipop-socket-symbol-class-diagram-consumes)
- [Hyperlink and tooltip for namespace and package](https://forum.plantuml.net/5709/wish-hyperlink-and-tooltip-for-namespace-and-package)
- [Split and Lanes not working together](https://forum.plantuml.net/5686/activity-diagram-split-and-lanes-not-working-together)
- Note for Java developers: in SourceStringReader class, methods generateDiagramDescription
have been renamed to generateImage

## V8059 (March 15, 2017)

- [Why UML Frame are now in blank and don't have the color under](https://forum.plantuml.net/5661/why-uml-frame-are-now-in-blank-and-dont-have-the-color-under)
- [Notes can not be added beside a grouping message](https://forum.plantuml.net/5641/notes-can-not-be-added-beside-a-grouping-message)
- [Include file(s) or path via command line](https://forum.plantuml.net/5649/include-file-s-or-path-via-command-line)
- [Pop-Up box with FileNotFoundException when including directory](https://github.com/hallvard/plantuml/issues/19)

## V8058 (March 12, 2017)

- [how to get the nth generated image at server](https://forum.plantuml.net/5590/generated-image-server-scrolling-through-newpage-with-query)
- [Ability to define hyperlink on diagram elements](https://forum.plantuml.net/542/ability-to-define-hyperlink-on-diagram-elements)
- [Adding +/- button on GUI](https://forum.plantuml.net/5577/enable-reducing-note-size)
- [Proposal for fixing some layout deficiences](https://forum.plantuml.net/5575/proposal-for-fixing-some-layout-deficiences)
- [Connector unexpectedly changes diagram type](https://forum.plantuml.net/5540/bug-connector-unexpectedly-changes-diagram-type)
- [Unnamed state in timing diagram](https://forum.plantuml.net/5525/feature-requests-for-timing-diagrams-dont-care)
- [Lifeline is not drawn on the new page, but only the shadow with SVG output](https://forum.plantuml.net/5627/lifeline-not-drawn-new-page-but-only-the-shadow-with-svg-output)
- [Grouping messages should be on top level](https://forum.plantuml.net/5639/grouping-messages-should-be-on-top-level)
- [Notes can not be added beside a grouping message](https://forum.plantuml.net/5641/notes-can-not-be-added-beside-a-grouping-message)

## V8057 (March 9, 2017)

- [Automatic line breaks for long lines](https://github.com/plantuml/plantuml/issues/35)
- [Two colors for an arrow line color (class diagram) crashes PlantUML](https://forum.plantuml.net/5495/two-colors-arrow-line-color-class-diagram-crashes-plantuml)
- [How to get some space beween participants](https://forum.plantuml.net/5493/some-space-beween-participants-which-source-module-ist-best)
- [Dates in Gantt diagrams](https://forum.plantuml.net/5510/dates-in-gantt-diagrams)
- [storage object parsed with tikz as rectangle](https://forum.plantuml.net/5507/bug-storage-object-parsed-with-tikz-as-rectangle)

## V8056 (February 24, 2017)

- [Timing Diagram enhancement (beta)](timing-diagram)
- [SVG hover style to tell apart arrows in a large component diagram](https://forum.plantuml.net/5453/svg-hover-style-tell-apart-arrows-in-large-component-diagram)
- [file extension when using @startuml filename](https://forum.plantuml.net/5483/file-extension-when-using-%40startuml-filename)
- [Empty while condition doesn't work](https://forum.plantuml.net/5477/empty-while-condition-doesnt-work)
- [Activity diag not generated](https://forum.plantuml.net/5472/activity-diag-not-generated)
- [Connection between fields in classes without descriptions not working](https://forum.plantuml.net/5491/connection-between-classes-without-descriptions-working)

## V8055 (February 15, 2017)

- [SVG monospace output has wrong font-family](https://forum.plantuml.net/5432/svg-monospace-output-has-wrong-font-family)
- [As for actor do not work in class diagram](https://forum.plantuml.net/5429/as-for-actor-do-not-work-in-class-diagram-mixing)
- [Note in XMI output becomes a class](https://forum.plantuml.net/5420/note-in-xmi-output-becomes-a-class)
- [Extends do not work with non empty rectangle](https://forum.plantuml.net/5416/do-not-work-with-non-empty-rect)
- [Timing Diagram (beta)](timing-diagram)

## V8054 (February 1, 2017)

- [How do I style Use Cases](https://forum.plantuml.net/5340/how-do-i-style-use-cases)
- [skinparam shadowing false for all](https://forum.plantuml.net/5366/skinparam-shadowing-false-for-all)
- [Sequence Participant Color Missing](https://forum.plantuml.net/5354/sequence-participant-color-missing)
- [Language definition](https://forum.plantuml.net/5329/language-definition)
- [joinspec for join nodes](https://forum.plantuml.net/5346/joinspec-for-join-nodes)
- [Border thickness](https://forum.plantuml.net/1831/border-thickness)
- [Information Engineering (IE) data modelling notation support](https://github.com/plantuml/plantuml/pull/31)

## V8053 (January 20, 2017)

- [Better XMI support](https://forum.plantuml.net/3761/generate-code-from-plant-uml)
- [Border thickness](https://forum.plantuml.net/1831/border-thickness)
- [Reverse colors](skinparam#reverse)

## V8052 (December 21, 2016)

- [Generate code from plant UML](https://forum.plantuml.net/3761/generate-code-from-plant-uml)
- [Round corners in component diagram](https://forum.plantuml.net/5299/round-corners-in-component-diagram)
- [Is the latex equation supported](https://forum.plantuml.net/5288/is-the-latex-equation-supported)
- [add possibility to show not navigable](https://forum.plantuml.net/4022/add-possibility-to-show-not-navigable)
- [How to use the PHP namespace separator with an association](https://forum.plantuml.net/5273/how-to-use-the-php-namespace-separator-with-an-association)
- [Attaching links to class members and methods with complex names](https://forum.plantuml.net/5261/attaching-links-class-members-and-methods-with-complex-names)
- [How can I unbold part of class name](https://forum.plantuml.net/5254/how-can-i-unbold-part-of-class-name)
- [Miss formed arrows in class diagram](https://forum.plantuml.net/5242/miss-formed-arrows-in-class-diagram)

## V8051 (December 14, 2016)

- [Place notes next to the boundary of partition in Activity Diagram](https://forum.plantuml.net/5208/place-notes-next-the-boundary-of-partition-activity-diagram)
- [Any support for math/equation rendering in Activity-Beta](https://forum.plantuml.net/5148/any-support-for-math-equation-rendering-in-activity-beta)
- [Equal width swimlanes in activity diagram](https://forum.plantuml.net/5201/equal-width-swimlanes-in-activity-diagram)
- [Preprocessor enhancement](https://forum.plantuml.net/5177/preprocessor-enhancement)
- [separator in element delaration](https://forum.plantuml.net/5178/separator-in-element-delaration)
- [ifdef A or B](https://forum.plantuml.net/5171/ifdef-a-b)

## V8050 (November 30, 2016)

- [Activity beta: default arrow direction with one-branch if](https://forum.plantuml.net/4806/activity-beta-default-arrow-direction-with-one-branch-if)
- [Activity diagrams - Bug on arrow position with note](https://forum.plantuml.net/5127/activity-diagrams-bug-on-arrow-position-with-note)
- [Can the hotspot areas of tooltips be controlled](https://forum.plantuml.net/5136/can-the-hotspot-areas-of-tooltips-be-controlled)
- [ASCII ART / Unicode Art : Delay not supported](https://forum.plantuml.net/5138/ascii-art-unicode-art-delay-not-supported)
- [Activity-Beta: Stack Overflow when Lane + Partition + Repeat](https://forum.plantuml.net/5141/activity-beta-stack-overflow-when-lane-partition-repeat)
- [Scaling does not work for latex output](https://forum.plantuml.net/5150/scaling-does-not-work-for-latex-output)
- [Hyperlink interferes with visibility](https://forum.plantuml.net/5151/hyperlink-interferes-with-visibility)

## V8049 (November 16, 2016)

- [Page splitting with overlap](https://forum.plantuml.net/5090/page-splitting-with-overlap)
- [Expand environnement variable in constants](https://forum.plantuml.net/5095/expand-environnement-variable-in-constants)
- [Border thickness](https://forum.plantuml.net/1831/border-thickness)
- [Hide fields of objects](https://forum.plantuml.net/5029/hide-fields-of-objects)
- [Problem with making two links](https://forum.plantuml.net/5047/problem-with-making-two-links)
- [IS there a possiblity to align the text over the arrow for example to be aligned centered](https://forum.plantuml.net/206/there-possiblity-align-over-arrow-example-aligned-centered)
- [Skinparam for boundary, control, database, and entity in sequence diagram](https://forum.plantuml.net/5112/skinparam-boundary-control-database-entity-sequence-diagram)
- [Sprite as internal (in-jar resource) images](https://forum.plantuml.net/4080/sprite-as-internal-in-jar-resource-images)

## V8048 (November 3, 2016)

- [Different colors on if and elseif](https://forum.plantuml.net/4916/different-colors-on-if-and-elseif)
- [Activity beta --- Any way to put a text on arrow going to elseif node](https://forum.plantuml.net/4819/activity-beta-any-way-to-put-text-on-arrow-going-to-elseif-node)
- [An error has occured while creating diagram with ports and separators](https://forum.plantuml.net/4909/error-occured-whilst-creating-diagram-with-ports-separators)
- [Lifelines broken for txt seq diagrams when create is used](https://forum.plantuml.net/4826/lifelines-broken-for-txt-seq-diagrams-when-create-is-used)
- [Skinparam LegendBorderThickness is missing](https://forum.plantuml.net/4941/skinparam-legendborderthickness-is-missing)
- [Skinparam NoteBorderThickness seems not to work](https://forum.plantuml.net/4939/skinparam-noteborderthickness-seems-not-to-work)
- [Link with association class and note ignores the note](https://forum.plantuml.net/4933/link-with-association-class-and-note-ignores-the-note)
- [setting ad hoc gradient backgrounds in activity](https://forum.plantuml.net/4906/setting-ad-hoc-gradient-backgrounds-in-activity)
- [StereotypeABackgroundColor vs. Stereotype@BackgroundColor](https://forum.plantuml.net/4962/stereotypeabackgroundcolor-stereotype%40backgroundcolor)
- [Skinparam minClassWidth not part of java -jar plantuml.jar -language](https://forum.plantuml.net/4976/skinparam-minclasswidth-part-java-plantuml-beta-language)
- [Empty package ignores its stereotype](https://forum.plantuml.net/4973/empty-package-ignores-its-stereotype)
- [Skinparam svgLinkTarget not working for API](https://forum.plantuml.net/4969/skinparam-svglinktarget-not-working-for-api)
- [vector output formats: openiconic icons leak onto adjacent pages](https://forum.plantuml.net/4991/vector-output-formats-openiconic-icons-leak-adjacent-pages)
- [Rendering of several stereotypes is different for classes and objects](https://forum.plantuml.net/4988/rendering-several-stereotypes-different-classes-objects)
- [Classes with individual spot hide their stereotypes](https://forum.plantuml.net/4987/classes-with-individual-spot-hide-their-stereotypes)
- [add possibility to show not navigable](https://forum.plantuml.net/4022/add-possibility-to-show-not-navigable)

## V8047 (September 28, 2016)

- [Translate Class Diagram to Braille](https://forum.plantuml.net/4752/translate-class-diagram-to-braille)
- [0 byte PNG generated when a while is nested in a repeat inside a swimlane](https://forum.plantuml.net/4799/byte-png-generated-when-while-nested-repeat-inside-swimlane)
- [Nodes name in svg file or more verbose debug](https://forum.plantuml.net/4716/nodes-name-in-svg-file-or-more-verbose-debug)
- [Activity beta: text of condition optionally outside the symbol](https://forum.plantuml.net/4809/activity-diagram-beta-text-condition-optionally-outside-the-symbol)
- [Label on upward edge in while loop](https://forum.plantuml.net/4804/label-on-upward-edge-in-while-loop)

## V8046 (September 23, 2016)

- [Salt fails when there is an empty line between @startuml and salt keywords](https://forum.plantuml.net/4778/salt-fails-when-there-empty-between-%40startuml-salt-keywords)
- [Marking class diagram if is public, private, or protected](https://forum.plantuml.net/4755/marking-class-diagram-if-is-public-private-or-protected)
- [Problem with a while inside a fork](https://forum.plantuml.net/4751/problem-with-a-while-inside-a-fork)
- [Apply skinparam defaultTextAlignment to other items](https://forum.plantuml.net/4731/apply-skinparam-defaulttextalignment-to-other-items)
- [Need a way to color and number different routes on an activity diagram](https://forum.plantuml.net/4411/need-way-color-and-number-different-routes-activity-diagram)

## V8045

- [Set background color for one note](https://forum.plantuml.net/4710/set-background-color-for-one-note)
- [Database modeling](https://forum.plantuml.net/331/database-modeling)
- [Does PlantUML support references between class/component members](https://forum.plantuml.net/3636/plantuml-support-references-between-class-component-members)
- [Ability to hide packages](https://forum.plantuml.net/4687/ability-to-hide-packages)
- [Tooltip issue on sequence diagram](https://forum.plantuml.net/4671/tooltip-issue-on-sequence-diagram)
- [Param to center text in activity](https://forum.plantuml.net/4682/param-to-center-text-in-activity)
- [Why do strange symbols appear on an eps printout, but not on the screen](https://forum.plantuml.net/4669/why-strange-symbols-appear-eps-printout-but-not-on-the-screen)
- [Package style erase Partition style](https://forum.plantuml.net/4664/package-style-erase-partition-style)
- [Notes on conditionnal elements](https://forum.plantuml.net/4696/notes-on-conditionnal-elements)

## V8043

- [Arrow's thickness in sequence diagrams and skins](https://forum.plantuml.net/2161/arrows-thickness-in-sequence-diagrams-and-skins)
- [Arrow marker`s background color is incorrect in v. 8042](https://forum.plantuml.net/4610/arrow-marker-s-background-color-is-incorrect-in-v-8042)
- [Leak in TranscoderUtil](https://forum.plantuml.net/4617/leak-in-transcoderutil)

## V8042

- [newpage makes the actors go vertical](https://forum.plantuml.net/4580/newpage-makes-the-actors-go-vertical-why)
- [Need a way to color and number different routes on an activity diagram](https://forum.plantuml.net/4411/need-way-color-and-number-different-routes-activity-diagram)
- [Set colour of font to hide text in Sequence Diagram](https://forum.plantuml.net/4566/set-colour-of-font-to-%23hidden-hide-text-in-sequence-diagram)
- [StackOverflowError](https://forum.plantuml.net/4563/stackoverflowerror)
- [Syntax error causes 10x slower syntax checking and generation of image](https://forum.plantuml.net/4553/syntax-error-causes-slower-syntax-checking-generation-image)
- [JDK 1.6.0.45 java.lang.IllegalArgumentException: Illegal pattern character u](https://forum.plantuml.net/4544/lang-illegalargumentexception-illegal-pattern-character)
- [Restore the method OptionFlags.setDotExecutable](https://github.com/asciidoctor/asciidoctor-diagram/issues/112)

## V8041

- [How to move a node to left](https://forum.plantuml.net/4387/how-to-move-a-node-to-left)

## V8040

- [detach after if statement in activity diagram](https://forum.plantuml.net/4457/detach-after-if-statement-in-activity-diagram)
- [Alias for links in sequence diagrams](https://forum.plantuml.net/4424/alias-for-links-in-sequence-diagrams)
- [Add custom label for bracket syntax](https://forum.plantuml.net/4480/add-custom-label-for-bracket-syntax)
- [Formatting of repeat loops spread trough several swimlanes](https://forum.plantuml.net/4470/formatting-of-repeat-loops-spread-trough-several-swimlanes)
- [select !include block based on a "identifier" instead of its number](https://forum.plantuml.net/4467/select-include-block-based-on-identifier-instead-its-number)

## V8039

- [How to move a node to left](https://forum.plantuml.net/4387/how-to-move-a-node-to-left)

## V8038

- [Scaling does not work correctly when non-default fonts are used](https://forum.plantuml.net/4290/scaling-does-not-work-correctly-when-default-fonts-are-used)
- [Sometimes Missing Response-Headers for broken PNG Images](https://forum.plantuml.net/4367/sometimes-missing-response-headers-for-broken-png-images)
- [From Plant Uml to a structured object](https://forum.plantuml.net/4348/from-plant-uml-to-a-structured-object)
- [Would it be possible to provide more information in the error stream](https://forum.plantuml.net/4353/would-it-possible-provide-more-information-the-error-stream)
- [Error java.lang.StackOverflowError](https://forum.plantuml.net/4301/error-java-lang-stackoverflowerror)
- [New shapes for entrypoints and exitpoints](https://forum.plantuml.net/4309/new-shapes-for-entrypoints-and-exitpoints)

## V8037

- [How do I hide all classes having a given stereotype](https://forum.plantuml.net/4259/how-do-i-hide-all-classes-having-a-given-stereotype)
- [Repeat followed by detach](https://forum.plantuml.net/4275/repeat-followed-by-detach-on-plantuml-8036)
- [Is there a "plain" style](https://forum.plantuml.net/4260/is-there-a-plain-style-if-not-can-it-be-added)
- [stereotype is not displayed when component has nested one](https://forum.plantuml.net/4252/stereotype-is-not-displayed-when-component-has-nested-one)
- [Stereotype Fontcolor](https://forum.plantuml.net/4188/stereotype-fontcolor)
- [Graphviz strict mode not supported](https://forum.plantuml.net/4210/graphviz-strict-mode-not-supported-with-fix)
- [request on sequence participant individual border color](https://forum.plantuml.net/4225/urgent-request-sequence-participant-individual-border-color)
- [Swimlanes not showing in SVG](https://forum.plantuml.net/4197/swimlanes-not-showing-in-svg)
- [Crash of the PlantUML](https://forum.plantuml.net/4253/crash-of-the-plantuml-v-8036)
- [Multiple stereotypes on one component](https://forum.plantuml.net/4282/multiple-stereotypes-on-one-component)

## V8036

- [If you comment out swimlane lines the drawing is correct.](https://forum.plantuml.net/4166/following-activity-correctly-comment-swimlane-drawing-correct)
- [How can I limit the column width of ascii-art sequence drawings.](https://forum.plantuml.net/4147/limit-column-width-ascii-sequence-drawings-inclusion-rfcs)
- [Please support PHP namespace separator](https://forum.plantuml.net/1139/please-support-php-namespace-separator)
- [Is the PNG output size limited to 4096 pixels only](https://forum.plantuml.net/4145/is-the-png-output-size-limited-to-4096-pixels-only)
- [Error generating uml when same file included in two different uml diagram](https://forum.plantuml.net/3389/error-generating-when-same-file-included-different-diagram)
- [Image link not working anymore](https://forum.plantuml.net/4150/image-link-not-working-anymore)
- [Is it possible to only use straight lines in a class diagram](https://forum.plantuml.net/1608/is-it-possible-to-only-use-straight-lines-in-a-class-diagram)
- [Can I not put the title at the bottom in a diagram](https://forum.plantuml.net/4119/can-i-not-put-the-title-at-the-bottom-in-a-diagram)
- [how to change background color in a table](https://forum.plantuml.net/4114/how-to-change-background-color-in-a-table)
- [Double quote in a event](https://forum.plantuml.net/4111/double-quote-in-a-event)

## V8035

- [Package composition regression](https://forum.plantuml.net/4124/package-composition)
- [Double quote in a event](https://forum.plantuml.net/4111/double-quote-in-a-event)
- [how to change background color in a table](https://forum.plantuml.net/4114/how-to-change-background-color-in-a-table)
- [Is it possible to only use straight lines in a class diagram](https://forum.plantuml.net/1608/is-it-possible-to-only-use-straight-lines-in-a-class-diagram)

## V8034

- [Keep same pan position after rerendering](https://forum.plantuml.net/1205/keep-same-pan-position-after-rerendering)
- [Vertical blocks can't be right aligned (e.g. for stereotype and title of a component)](https://forum.plantuml.net/4075/vertical-blocks-right-aligned-stereotype-title-componen)
- [No stereotype on empty components](https://forum.plantuml.net/4074/no-stereotype-on-empty-components)
- [Is it possible to draw if/elseif/else structure vertically](https://forum.plantuml.net/3931/is-it-possible-to-draw-if-elseif-else-structure-vertically)
- [java.lang.ClassCastException bug](https://forum.plantuml.net/4064/java-lang-classcastexception-bug)
- [Note on grouping component](https://forum.plantuml.net/3985/note-on-grouping-component)
- [It is still would be useful to style partitions in activity-diagram-beta diagrams with skinparam](https://forum.plantuml.net/3626/still-useful-style-partitions-activity-diagrams-skinparam)
- [Association Node breaks link direction](https://forum.plantuml.net/4037/association-node-breaks-link-direction)
- [Multi-line tooltip on note/hnote of sequence diagram](https://forum.plantuml.net/4025/multi-line-tooltip-on-note-hnote-of-sequence-diagram)
- [newpage don't keep params](https://forum.plantuml.net/4004/newpage-dont-keep-params)
- [How to style package titles](https://forum.plantuml.net/4021/how-to-style-package-titles)

## V8033

- [Clipping in Activity Diagram](https://forum.plantuml.net/3938/clipping-in-activity-diagram)
- [skinparam for swimlanes](https://forum.plantuml.net/3971/skinparam-for-swimlanes)
- [How do I add link notes in sub states](https://forum.plantuml.net/3964/how-do-i-add-link-notes-in-sub-states)
- [How to set font color inside controling elements in activity2 diagrams](https://forum.plantuml.net/3166/font-color-inside-controling-elements-activity2-diagrams)
- [json content tooltip on sequence diagram](https://forum.plantuml.net/3945/json-content-tooltip-on-sequence-diagram)
- [An error has occured java.lang.NullPointerException](https://forum.plantuml.net/3941/an-error-has-occured-java-lang-nullpointerexception)

## V8032

- [Sequence: note right rendering issue after activate](https://forum.plantuml.net/3132/sequence-note-right-rendering-issue-after-activate)
- [stereotypes for notes to be used when defining note's skinparam](https://forum.plantuml.net/3891/stereotypes-for-notes-be-used-when-defining-notes-skinparam)
- [The deprecated BlueModern skin cannot be replicated exactly using skinparam directives](https://forum.plantuml.net/3893/deprecated-bluemodern-replicated-exactly-skinparam-directives)
- [Concurrent state nesting limit](https://forum.plantuml.net/3890/concurrent-state-nesting-limit)
- [Overlapping into Activity Diagram between a big note and an arrow](https://forum.plantuml.net/3936/overlapping-into-activity-diagram-between-big-note-and-arrow)
- [Make multi-line comment delimiters work on a single line](https://forum.plantuml.net/3910/make-multi-line-cimment-delimiters-and-work-on-a-single-line)
- [Compilation Network Issue](https://forum.plantuml.net/3905/compilation-network-issue)
- [Can a block quote begin and end on the same line](https://forum.plantuml.net/3906/can-a-block-quote-begin-and-end-on-the-same-line)
- [multi-line tooltip](https://forum.plantuml.net/3924/multi-line-tooltip)

## V8031

- [Embedding images (bitmap or svg) in diagrams](https://forum.plantuml.net/3790/embedding-images-bitmap-or-svg-in-diagrams)
- [Stereotype not show with uml2 component style](https://forum.plantuml.net/3814/stereotype-not-show-with-uml2-component-style)
- [Change tab spacing to 2](https://forum.plantuml.net/3820/change-tab-spacing-to-2)
- [Adding Pages between Objects](https://forum.plantuml.net/3830/adding-pages-between-objects)
- [alias of folder is drawn in top part](https://forum.plantuml.net/3832/alias-of-folder-is-drawn-in-top-part-8031beta5)
- [How to acces to different blocks in a included file](https://forum.plantuml.net/3864/how-to-acces-to-diferent-blocks-in-a-included-file)

## V8030

- [How do you change the font used for monospaced-style text](https://forum.plantuml.net/3720/how-do-you-change-the-font-used-for-monospaced-style-text)
- [Arrow Color, "While" inside partition and if](https://forum.plantuml.net/3719/arrow-color-while-inside-partition-and-if)
- [Macro expansion goes wrong depending on argument content](https://forum.plantuml.net/3750/macro-expansion-goes-wrong-depending-on-argument-content)
- [HTML code for use cases to show that sub-use-cases are available](https://forum.plantuml.net/3688/html-code-for-use-cases-show-that-sub-use-cases-are-available)
- [Class diagram: Crash when specifying visibility on a method/attribute and attaching a note to it](https://forum.plantuml.net/3747/diagram-specifying-visibility-method-attribute-attaching)
- [auto scaling based on declared max-size](https://forum.plantuml.net/3748/auto-scaling-based-on-declared-max-size)

## V8029

- [startUML capitalization causes crash](https://forum.plantuml.net/3641/%40startuml-capitalization-causes-crash)
- [Is the number of nesting levels in activity diagrams limitated](https://forum.plantuml.net/3544/is-the-number-nesting-levels-in-activity-diagrams-limitated)

## V8027

- [How to change font color of a composite state](https://forum.plantuml.net/3470/how-to-change-font-color-of-a-composite-state)
- [hide empty members no longer working](https://forum.plantuml.net/3547/hide-empty-members-no-longer-working)
- [Implement shortcuts for Previous, Copy, Next and Zoom fit](https://forum.plantuml.net/3541/implement-shortcuts-for-previous-copy-next-and-zoom-fit)
- [java.lang.IllegalStateException for @startdot without installed Graphiz](https://forum.plantuml.net/3248/illegalstateexception-%40startdot-without-installed-graphiz)
- [activity-diagram-beta : Condition of RepeatWhile multi-lines](https://forum.plantuml.net/3453/activity-diagram-beta-condition-of-repeatwhile-multi-lines)
- [How can I escape the HTML img tag](https://forum.plantuml.net/3527/how-can-i-escape-the-html-img-tag)

## V8026

- [Flow final activity](https://forum.plantuml.net/3505/flow-final-activity)
- [Bug on API for included files](https://forum.plantuml.net/3501/provide-api-to-get-included-files)
- [Distribute jars with allowed debugging](https://forum.plantuml.net/3503/distribute-jars-with-allowed-debugging)
- [supporting comments inside a skinparam section](https://forum.plantuml.net/3492/version-stopped-supporting-comments-inside-skinparam-section)
- [URLs are not shown when mixed with text in component captions](https://forum.plantuml.net/3412/urls-are-not-shown-when-mixed-with-text-in-component-captions)
- [SVG background is not set according to SkinParam](https://forum.plantuml.net/2838/svg-background-is-not-set-according-to-skinparam)
- [Decreasing visibility of links](https://forum.plantuml.net/2866/decreasing-visibility-of-links)
- [Error generating uml when same file included in two different uml diagram](https://forum.plantuml.net/3389/error-generating-when-same-file-included-different-diagram)

## V8023

- [Detach not working with nested splits](https://forum.plantuml.net/2780/detach-not-working-with-nested-splits-in-sequence-diagrams)
- [Swimlines disappear in multi-page diagrams with ellipsis](https://forum.plantuml.net/3342/sequence-diagrams-swimlines-disappear-diagrams-ellipsis)
- [Stereotyping does not work for composite states](https://forum.plantuml.net/3341/stereotyping-does-not-work-for-composite-states)
- [inconsistent units pt and px in generated SVG image](https://forum.plantuml.net/3343/inconsistent-units-pt-and-px-in-generated-svg-image)
- [IllegalArgumentException when note's name is already known in a package diagram](https://forum.plantuml.net/3318/illegalargumentexception-already-known-package-diagram)
- [Can PlantUML produce diagram in 'hand drawn' style?](https://forum.plantuml.net/3313/plantuml-produce-diagram-hand-drawn-style-sparx-systems-does)

## V8021

- [SyntaxChecker produces IndexOutOfBoundsException](https://forum.plantuml.net/3216/syntaxchecker-produces-indexoutofboundsexception)
- [Placement of sprites wrong with "newpage" for vector formats](https://forum.plantuml.net/3202/placement-of-sprites-wrong-with-newpage-for-vector-formats)
- [Grouping inheritance arrow ends](https://forum.plantuml.net/3193/grouping-inheritance-arrow-ends)
- [Sequence diagram: "cross arrow style" ignored for message to itself](https://forum.plantuml.net/3197/sequence-diagram-cross-arrow-style-ignored-message-itself)
- [Dashed arrows to Sequence Diagram edges cannot be colored](https://forum.plantuml.net/3151/dashed-arrows-to-sequence-diagram-edges-cannot-be-colored)
- [Add norank option on links](https://forum.plantuml.net/3188/add-norank-option-on-links)
- [Component diagram arrow color bug](https://forum.plantuml.net/3185/component-diagram-arrow-color-bug)

## V8020

- [activity-diagram-beta Diagram: long text on arrow after elseif](https://forum.plantuml.net/3074/activity-diagram-beta-diagram-long-text-on-arrow-after-elseif)
- [Activity : while within fork doesn't work](https://forum.plantuml.net/3039/activity-while-within-fork-doesnt-work)
- [Is there a way to disaply summary table (right side) in Sequence diagram](https://forum.plantuml.net/3040/there-way-disaply-summary-table-right-side-sequence-diagram)
- [Activity Beta - labelling an arrow that enters a partition, label is never shown](https://forum.plantuml.net/3085/activity-labelling-arrow-enters-partition-label-never-shown)
- [Activity Beta - labelling an arrow before an end split - label is shown on the recombined arrow](https://forum.plantuml.net/3087/activity-labelling-arrow-before-split-shown-recombined-arrow)
- [support \l and \r in additon to \n](https://forum.plantuml.net/3055/support-l-and-r-in-additon-to-n)
- [Bug : Arrow with "elseif" in activity-diagram-beta diagram](https://forum.plantuml.net/3069/bug-arrow-with-elseif-in-activity-diagram-beta-diagram)
- [Incorrect rnote layout](https://forum.plantuml.net/3083/incorrect-rnote-layout)

## V8019

- [Note for while](https://forum.plantuml.net/2993/note-for-while)
- [Left-aligning transition text in state diagrams](https://forum.plantuml.net/3015/left-aligning-transition-text-in-state-diagrams)
- [Class diagram / Package border thickness](https://forum.plantuml.net/3030/class-diagram-package-border-thickness)
- [Activity : while within fork doesn't work](https://forum.plantuml.net/3039/activity-while-within-fork-doesnt-work)
- [First release of Teoz layout engine](teoz)

## V8018

- [sequence delays break double-activated lifelines](https://forum.plantuml.net/2926/sequence-delays-break-double-activated-lifelines-and-github)
- [Represent if/then or while loop over swimlanes to show a document review process](https://forum.plantuml.net/2970/represent-while-over-swimlanes-show-document-review-process)
- [loop bottom border encloses trailing deactivate](https://forum.plantuml.net/2927/loop-bottom-border-encloses-trailing-deactivate)
- [Activity Beta: Arraw text and color problems](https://forum.plantuml.net/2942/activity-diagram-beta-arraw-text-and-color-problems)
- [Represent if/then or while loop over swimlanes to show a document review process](https://forum.plantuml.net/2970/represent-while-over-swimlanes-show-document-review-process)
- [Activity Beta: drawing improvements](https://forum.plantuml.net/2961/activity-diagram-beta-drawing-improvements)

## V8016

- [Decreasing visibility of links](https://forum.plantuml.net/2866/decreasing-visibility-of-links)
- [Activity Diagram: More then one stop states](https://forum.plantuml.net/2868/activity-diagram-more-then-one-stop-states)
- [Stereotyping does not work for activityShape](https://forum.plantuml.net/2899/stereotyping-does-work-for-activityshape-plantuml-8015-jar)
- [Sequence Chart: diagram doesn't scale with long text in 'else' of a group message](https://forum.plantuml.net/2871/sequence-chart-diagram-doesnt-scale-long-else-group-message)

## V8015

- [Web links in generated images](https://forum.plantuml.net/90/web-links-in-generated-images-e-g-using-image-maps)

## V8013

- [New !includeurl feature in preprocessing.](preprocessing)
- [Sub package / namespace conflicts](https://forum.plantuml.net/2816/sub-package-namespace-conflicts)
- [Detach not working with nested splits in sequence diagrams](https://forum.plantuml.net/2780/detach-not-working-with-nested-splits-in-sequence-diagrams)

## V8011

- [Activity: fork within repeat and while loop doesn't work](https://forum.plantuml.net/2807/activity-fork-within-repeat-and-while-loop-doesnt-work)

## V8010

- [Solid Life Line in Sequence Diagrams](https://forum.plantuml.net/2794/solid-life-line-in-sequence-diagrams)
- [Activity Beta: how to set default font color?](https://forum.plantuml.net/2792/activity-diagram-beta-how-to-set-default-font-color)

## V8009

- [Name of Class does not fit in the box](https://forum.plantuml.net/2591/name-of-class-does-not-fit-in-the-box)
- [URL in name of link not working in class diagram](https://forum.plantuml.net/2604/url-in-name-of-link-not-working-in-class-diagram)

## V8008

- [Rendering bug solved](https://forum.plantuml.net/2492/render-problems)
- [Define a multi line macro](https://forum.plantuml.net/1527/define-a-multi-line-macro)

## V8007

- [Fix the broken eclipse plugin](https://forum.plantuml.net/2458/has-version-8005-broken-the-eclipse-plugin)

## V8005

- [Substituting variable using !define](https://forum.plantuml.net/2424/substituting-variable-using-define)
- [EPS output format with Salt](https://forum.plantuml.net/2444/eps-output-format-with-salt)
- [Incorrect propagation of defined variables](https://forum.plantuml.net/2425/incorrect-propagation-of-defined-variables)
- [How-to get visible double double quotes](https://forum.plantuml.net/2382/how-to-get-visible-double-double-quotes)

## V8004

- [PlantUML jars in Maven repositories don't contain OpenIconic SVGs](https://forum.plantuml.net/2329/plantuml-maven-repositories-dont-contain-openiconic-svg)
- [Increasing visibility of links](https://forum.plantuml.net/2322/increasing-visibility-of-links)
- [Partitions (group of actions) in Activity Diagram Beta](https://forum.plantuml.net/2047/partitions-group-of-actions-in-activity-diagram-beta)
- [Unexpected Error when using Stereotype with Activity (Beta)](https://forum.plantuml.net/2317/unexpected-error-when-using-stereotype-with-activity-diagram-beta)
- [Pre-alpha goto implementation.](https://forum.plantuml.net/1626/there-refer-existing-activity-inside-activitydiagram-goto)

## V8003

- [Line separator for generic types](https://forum.plantuml.net/2304/line-separator-for-generic-types)
- [Is multiple inheritance or implementation possible?](https://forum.plantuml.net/2239/is-multiple-inheritance-or-implementation-possible)
- [alt does not work -tlatex, with IllegalArgumentException](https://forum.plantuml.net/2276/alt-does-not-work-tlatex-with-illegalargumentexception)
- [Names of nested nodes with stereotype](https://forum.plantuml.net/2253/names-of-nested-nodes-with-stereotype-component-diagrams)
- [why there's an error when using both 'extends' and 'implements' statements in the same class](https://forum.plantuml.net/2237/class-diagram-theres-using-extends-implements-statements)

## V7998

- [OpenIconic integration](openiconic)
- [Border thickness](https://forum.plantuml.net/1831/border-thickness)

## V7997

- New <space:30> feature, still undocumented
- [Beta Latex support](latex)

## V7996

- [associating class in two different naemspace](https://forum.plantuml.net/1753/associating-class-in-two-different-naemspace)
- [Left-hand tab exceeds boundaries](https://forum.plantuml.net/1734/left-hand-tab-exceeds-boundaries)
- [New Zoom fit feature](gui)

## V7995

- [How to specify incomplete specification](https://forum.plantuml.net/1672/specify-incomplete-specification-ellipsis-attributes-diagram)
- [Tree Table in Salt](https://forum.plantuml.net/1265/feature-request-tree-tables)
- [hide stereotype in component diagrams](https://forum.plantuml.net/1710/hide-stereotype-in-component-diagrams)
- [Creole support](https://forum.plantuml.net/1592/uniform-support-of-diagram-independent-features)
- [## macro](https://forum.plantuml.net/1651/macro-variable-expansion)
- [pause/unpause](https://forum.plantuml.net/1525/%40pauseuml-for-splitting-uml-code)
- Allowing hide footbox in class diagram

## V7994

- [New options in table for Salt](salt#table)



