/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerFilterObjectType
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerFilterObjectType.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DatabaseNavigatorTree navigatorTree = NavigatorUtils.getNavigatorTree(event);
        if (navigatorTree != null) {
            DatabaseNavigatorTreeFilterObjectType objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)event.getParameter("type"));
            if (objectType == null) {
                DatabaseNavigatorTreeFilterObjectType[] types = DatabaseNavigatorTreeFilterObjectType.values();
                DatabaseNavigatorTreeFilterObjectType selection = navigatorTree.getFilterObjectType();
                objectType = types[(selection.ordinal() + 1) % types.length];
            }
            if (objectType == navigatorTree.getFilterObjectType()) {
                return null;
            }
            navigatorTree.setFilterObjectType(objectType);
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
            ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.navigator.filter.object.type"});
        } else {
            log.debug((Object)"Can't find active navigator tree");
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DatabaseNavigatorTreeFilterObjectType objectType;
        DatabaseNavigatorTree navigatorTree = NavigatorUtils.getNavigatorTree(element.getServiceLocator());
        DatabaseNavigatorTreeFilterObjectType curObjectType = DatabaseNavigatorTreeFilterObjectType.connection;
        if (navigatorTree != null) {
            curObjectType = navigatorTree.getFilterObjectType();
        }
        if ((objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)CommonUtils.toString(parameters.get("type")))) == null) {
            element.setTooltip(NLS.bind((String)"{0} (click to cycle through)", (Object)curObjectType.getDescription()));
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)curObjectType.getIcon()));
        } else {
            element.setText(objectType.getName());
            element.setTooltip(objectType.getDescription());
            element.setChecked(objectType == curObjectType);
            element.setIcon(null);
        }
    }
}

