// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, NavigationPage, Swipeable};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwNavigationView")]
    pub struct NavigationView(Object<ffi::AdwNavigationView, ffi::AdwNavigationViewClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, Swipeable;

    match fn {
        type_ => || ffi::adw_navigation_view_get_type(),
    }
}

impl NavigationView {
    #[doc(alias = "adw_navigation_view_new")]
    pub fn new() -> NavigationView {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_navigation_view_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`NavigationView`] objects.
    ///
    /// This method returns an instance of [`NavigationViewBuilder`](crate::builders::NavigationViewBuilder) which can be used to create [`NavigationView`] objects.
    pub fn builder() -> NavigationViewBuilder {
        NavigationViewBuilder::new()
    }

    #[doc(alias = "adw_navigation_view_add")]
    pub fn add(&self, page: &impl IsA<NavigationPage>) {
        unsafe {
            ffi::adw_navigation_view_add(self.to_glib_none().0, page.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "adw_navigation_view_find_page")]
    pub fn find_page(&self, tag: &str) -> Option<NavigationPage> {
        unsafe {
            from_glib_none(ffi::adw_navigation_view_find_page(
                self.to_glib_none().0,
                tag.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_get_animate_transitions")]
    #[doc(alias = "get_animate_transitions")]
    #[doc(alias = "animate-transitions")]
    pub fn is_animate_transitions(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_get_animate_transitions(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_navigation_view_get_hhomogeneous")]
    #[doc(alias = "get_hhomogeneous")]
    #[doc(alias = "hhomogeneous")]
    pub fn is_hhomogeneous(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_get_hhomogeneous(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_get_navigation_stack")]
    #[doc(alias = "get_navigation_stack")]
    #[doc(alias = "navigation-stack")]
    pub fn navigation_stack(&self) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::adw_navigation_view_get_navigation_stack(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_get_pop_on_escape")]
    #[doc(alias = "get_pop_on_escape")]
    #[doc(alias = "pop-on-escape")]
    pub fn is_pop_on_escape(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_get_pop_on_escape(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_get_previous_page")]
    #[doc(alias = "get_previous_page")]
    pub fn previous_page(&self, page: &impl IsA<NavigationPage>) -> Option<NavigationPage> {
        unsafe {
            from_glib_none(ffi::adw_navigation_view_get_previous_page(
                self.to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_navigation_view_get_vhomogeneous")]
    #[doc(alias = "get_vhomogeneous")]
    #[doc(alias = "vhomogeneous")]
    pub fn is_vhomogeneous(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_get_vhomogeneous(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_get_visible_page")]
    #[doc(alias = "get_visible_page")]
    #[doc(alias = "visible-page")]
    pub fn visible_page(&self) -> Option<NavigationPage> {
        unsafe {
            from_glib_none(ffi::adw_navigation_view_get_visible_page(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_navigation_view_get_visible_page_tag")]
    #[doc(alias = "get_visible_page_tag")]
    #[doc(alias = "visible-page-tag")]
    pub fn visible_page_tag(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_navigation_view_get_visible_page_tag(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_pop")]
    pub fn pop(&self) -> bool {
        unsafe { from_glib(ffi::adw_navigation_view_pop(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_navigation_view_pop_to_page")]
    pub fn pop_to_page(&self, page: &impl IsA<NavigationPage>) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_pop_to_page(
                self.to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_pop_to_tag")]
    pub fn pop_to_tag(&self, tag: &str) -> bool {
        unsafe {
            from_glib(ffi::adw_navigation_view_pop_to_tag(
                self.to_glib_none().0,
                tag.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_navigation_view_push")]
    pub fn push(&self, page: &impl IsA<NavigationPage>) {
        unsafe {
            ffi::adw_navigation_view_push(self.to_glib_none().0, page.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "adw_navigation_view_push_by_tag")]
    pub fn push_by_tag(&self, tag: &str) {
        unsafe {
            ffi::adw_navigation_view_push_by_tag(self.to_glib_none().0, tag.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_navigation_view_remove")]
    pub fn remove(&self, page: &impl IsA<NavigationPage>) {
        unsafe {
            ffi::adw_navigation_view_remove(self.to_glib_none().0, page.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "adw_navigation_view_replace")]
    pub fn replace(&self, pages: &[NavigationPage]) {
        let n_pages = pages.len() as _;
        unsafe {
            ffi::adw_navigation_view_replace(
                self.to_glib_none().0,
                pages.to_glib_none().0,
                n_pages,
            );
        }
    }

    #[doc(alias = "adw_navigation_view_replace_with_tags")]
    pub fn replace_with_tags(&self, tags: &[&str]) {
        let n_tags = tags.len() as _;
        unsafe {
            ffi::adw_navigation_view_replace_with_tags(
                self.to_glib_none().0,
                tags.to_glib_none().0,
                n_tags,
            );
        }
    }

    #[doc(alias = "adw_navigation_view_set_animate_transitions")]
    #[doc(alias = "animate-transitions")]
    pub fn set_animate_transitions(&self, animate_transitions: bool) {
        unsafe {
            ffi::adw_navigation_view_set_animate_transitions(
                self.to_glib_none().0,
                animate_transitions.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_navigation_view_set_hhomogeneous")]
    #[doc(alias = "hhomogeneous")]
    pub fn set_hhomogeneous(&self, hhomogeneous: bool) {
        unsafe {
            ffi::adw_navigation_view_set_hhomogeneous(
                self.to_glib_none().0,
                hhomogeneous.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_navigation_view_set_pop_on_escape")]
    #[doc(alias = "pop-on-escape")]
    pub fn set_pop_on_escape(&self, pop_on_escape: bool) {
        unsafe {
            ffi::adw_navigation_view_set_pop_on_escape(
                self.to_glib_none().0,
                pop_on_escape.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_navigation_view_set_vhomogeneous")]
    #[doc(alias = "vhomogeneous")]
    pub fn set_vhomogeneous(&self, vhomogeneous: bool) {
        unsafe {
            ffi::adw_navigation_view_set_vhomogeneous(
                self.to_glib_none().0,
                vhomogeneous.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "get-next-page")]
    pub fn connect_get_next_page<F: Fn(&Self) -> Option<NavigationPage> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn get_next_page_trampoline<
            F: Fn(&NavigationView) -> Option<NavigationPage> + 'static,
        >(
            this: *mut ffi::AdwNavigationView,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::AdwNavigationPage {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this)).to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"get-next-page".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    get_next_page_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "popped")]
    pub fn connect_popped<F: Fn(&Self, &NavigationPage) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn popped_trampoline<
            F: Fn(&NavigationView, &NavigationPage) + 'static,
        >(
            this: *mut ffi::AdwNavigationView,
            page: *mut ffi::AdwNavigationPage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(page))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"popped".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    popped_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "pushed")]
    pub fn connect_pushed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn pushed_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"pushed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    pushed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "replaced")]
    pub fn connect_replaced<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn replaced_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"replaced".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    replaced_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "animate-transitions")]
    pub fn connect_animate_transitions_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_animate_transitions_trampoline<
            F: Fn(&NavigationView) + 'static,
        >(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::animate-transitions".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_animate_transitions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "hhomogeneous")]
    pub fn connect_hhomogeneous_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::hhomogeneous".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_hhomogeneous_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "navigation-stack")]
    pub fn connect_navigation_stack_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_navigation_stack_trampoline<
            F: Fn(&NavigationView) + 'static,
        >(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::navigation-stack".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_navigation_stack_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "pop-on-escape")]
    pub fn connect_pop_on_escape_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pop_on_escape_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::pop-on-escape".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_pop_on_escape_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "vhomogeneous")]
    pub fn connect_vhomogeneous_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::vhomogeneous".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_vhomogeneous_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "visible-page")]
    pub fn connect_visible_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_page_trampoline<F: Fn(&NavigationView) + 'static>(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible-page".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_page_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "visible-page-tag")]
    pub fn connect_visible_page_tag_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_page_tag_trampoline<
            F: Fn(&NavigationView) + 'static,
        >(
            this: *mut ffi::AdwNavigationView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible-page-tag".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_page_tag_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl Default for NavigationView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`NavigationView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct NavigationViewBuilder {
    builder: glib::object::ObjectBuilder<'static, NavigationView>,
}

impl NavigationViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn animate_transitions(self, animate_transitions: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("animate-transitions", animate_transitions),
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    pub fn hhomogeneous(self, hhomogeneous: bool) -> Self {
        Self {
            builder: self.builder.property("hhomogeneous", hhomogeneous),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn pop_on_escape(self, pop_on_escape: bool) -> Self {
        Self {
            builder: self.builder.property("pop-on-escape", pop_on_escape),
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    pub fn vhomogeneous(self, vhomogeneous: bool) -> Self {
        Self {
            builder: self.builder.property("vhomogeneous", vhomogeneous),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`NavigationView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> NavigationView {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
