/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class HammingDistanceTest {
    private static HammingDistance distance;

    @BeforeAll
    public static void setUp() {
        distance = new HammingDistance();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputsEquals()"})
    public void testHammingDistance(Class<?> cls) {
        Assertions.assertEquals((int)0, (Integer)distance.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)0, (Integer)distance.apply(SimilarityInputTest.build(cls, "pappa"), SimilarityInputTest.build(cls, "pappa")));
        Assertions.assertEquals((int)1, (Integer)distance.apply(SimilarityInputTest.build(cls, "papaa"), SimilarityInputTest.build(cls, "pappa")));
        Assertions.assertEquals((int)3, (Integer)distance.apply(SimilarityInputTest.build(cls, "karolin"), SimilarityInputTest.build(cls, "kathrin")));
        Assertions.assertEquals((int)3, (Integer)distance.apply(SimilarityInputTest.build(cls, "karolin"), SimilarityInputTest.build(cls, "kerstin")));
        Assertions.assertEquals((int)2, (Integer)distance.apply(SimilarityInputTest.build(cls, "1011101"), SimilarityInputTest.build(cls, "1001001")));
        Assertions.assertEquals((int)3, (Integer)distance.apply(SimilarityInputTest.build(cls, "2173896"), SimilarityInputTest.build(cls, "2233796")));
        Assertions.assertEquals((int)2, (Integer)distance.apply(SimilarityInputTest.build(cls, "ATCG"), SimilarityInputTest.build(cls, "ACCC")));
    }

    @Test
    public void testHammingDistance_nullLeftValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> distance.apply(null, (CharSequence)""));
    }

    @Test
    public void testHammingDistance_nullRightValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> distance.apply((CharSequence)"", null));
    }

    @Test
    public void testHammingDistanceCharSequence() {
        Assertions.assertEquals((int)0, (Integer)distance.apply((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (Integer)distance.apply((CharSequence)"pappa", (CharSequence)"pappa"));
        Assertions.assertEquals((int)1, (Integer)distance.apply((CharSequence)"papaa", (CharSequence)"pappa"));
        Assertions.assertEquals((int)3, (Integer)distance.apply((CharSequence)"karolin", (CharSequence)"kathrin"));
        Assertions.assertEquals((int)3, (Integer)distance.apply((CharSequence)"karolin", (CharSequence)"kerstin"));
        Assertions.assertEquals((int)2, (Integer)distance.apply((CharSequence)"1011101", (CharSequence)"1001001"));
        Assertions.assertEquals((int)3, (Integer)distance.apply((CharSequence)"2173896", (CharSequence)"2233796"));
        Assertions.assertEquals((int)2, (Integer)distance.apply((CharSequence)"ATCG", (CharSequence)"ACCC"));
    }
}

