#include <iostream>
#include <limits>
#include <cassert>

#include "Rivet/Tools/RivetSTL.hh"

using namespace std;
using namespace Rivet;

int main() {

  vector<int> v{1,2,3,4};
  set<float> s{1.0f, 4.0f, 9.0f};
  //map<int, double> m{ {1, M_PI}, {2, M_PI/2}, {5, M_PI*2} };

  /// @todo Would be nice to be able to just pass std::to_string, but the templating+SFINAE doesn't resolve which overload :-/
  strings s1 = mkVecOf<string>(v, [](int x){return to_string(x);} );
  cout << s1 << endl;
  strings s2 = mkStrings(s);
  cout << s2 << endl;
  strings s3 = mkStrings({5,4,3,2,1});
  cout << s3 << endl;
  // strings s4 = mkVecOf<string>(m, [](const auto& kv){return to_string(kv.second).c_str();});
  // cout << s4 << endl;

  cout << endl;
  doubles d1 = mkVecOf<double>(v);
  cout << d1 << endl;
  doubles d2 = mkDoubles(s);
  cout << d2 << endl;
  doubles d3 = mkDoubles({1.2,3.4,5.6});
  cout << d3 << endl;

  cout << endl;
  floats f1 = mkVecOf<float>(v);
  cout << f1 << endl;
  floats f2 = mkFloats(s);
  cout << f2 << endl;
  floats f3 = mkFloats({1,3,5});
  cout << f3 << endl;

  cout << endl;
  ints i1 = mkVecOf<int>(v);
  cout << i1 << endl;
  ints i2 = mkInts(s);
  cout << i2 << endl;
  ints i3 = mkInts({1,3,5});
  cout << i3 << endl;
  ints i4 = mkInts({1.,3.1,5.2});
  cout << i4 << endl;

  return EXIT_SUCCESS;
}
