// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+ e- > n nbar
  class SND_2022_I2102082 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(SND_2022_I2102082);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_nneutron, 1, 1, 1);
      for (const string& en : _nneutron.binning().edges<0>()) {
        double eval = stod(en)*MeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size()!=2) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::NEUTRON) vetoEvent;
      }
      _nneutron->fill(_sqs);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nneutron, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _nneutron;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(SND_2022_I2102082);
}
