// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+e- -> pi+pi-
  class CMD_1985_I221309 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CMD_1985_I221309);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_sigma1, 1,1,1);
      book(_sigma2, 2,1,1);
      for (const string& en : _sigma1.binning().edges<0>()) {
        double eval = stod(en)*MeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      for (int en : _sigma2.binning().edges<0>()) {
        double eval = en*MeV;
        if (isCompatibleWithSqrtS(eval)) {
          _isqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty() && _isqs < 0.);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size()!=2) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::PIPLUS) vetoEvent;
      }
      if (!_sqs.empty()) _sigma1->fill(_sqs);
      if (_isqs > 0)  _sigma2->fill(_isqs);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_sigma1, crossSection()/sumOfWeights()/nanobarn);
      scale(_sigma2, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string>  _sigma1;
    BinnedHistoPtr<int>     _sigma2;
    string _sqs = "";
    int _isqs = -1;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(CMD_1985_I221309);
}
