// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief Cross-sections for light hadrons at 3.773 and 3.650 GeV
  class BESII_2008_I801208 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESII_2008_I801208);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      for (size_t ix=1; ix<7; ++ix) {
        book(_nMeson[ix], 1, 1, ix);
      }
      for (const string& en : _nMeson[2].binning().edges<0>()) {
        double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (nCount[310]!=1) vetoEvent;

      if (ntotal==3) {
        if ((nCount[ 211]==1 && nCount[-321]==1) ||
            (nCount[-211]==1 && nCount[ 321]==1) ) {
          if (_sqs=="3.773"s) _nMeson[1]->fill(_sqs);
        }
      }
      else if (ntotal==4&&nCount[111]==1) {
        if ((nCount[ 211]==1 && nCount[-321]==1) ||
            (nCount[-211]==1 && nCount[ 321]==1) ) _nMeson[2]->fill(_sqs);
      }
      else if(ntotal==5) {
        if ((nCount[ 211]==2 && nCount[-211]==1 && nCount[-321]==1) ||
            (nCount[-211]==2 && nCount[ 211]==1 && nCount[ 321]==1) )   _nMeson[3]->fill(_sqs);
        if (((nCount[ 211]==1 &&  nCount[-321]==1) ||
             (nCount[-211]==1 &&  nCount[ 321]==1) ) && nCount[111]==2) _nMeson[6]->fill(_sqs);
      }
      else if(ntotal==6&&nCount[111]==1) {
        if ((nCount[ 211]==2 && nCount[-211]==1 && nCount[-321]==1) ||
            (nCount[-211]==2 && nCount[ 211]==1 && nCount[ 321]==1) )   _nMeson[4]->fill(_sqs);
      }
      else if(ntotal==7) {
        if ((nCount[ 211]==3 && nCount[-211]==2 && nCount[-321]==1) ||
            (nCount[-211]==3 && nCount[ 211]==2 && nCount[ 321]==1) ) {
          if (_sqs=="3.773"s) _nMeson[5]->fill(_sqs);
        }
      }
    }

    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nMeson, crossSection()/ sumOfWeights() /picobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _nMeson[7];
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESII_2008_I801208);


}
