/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grinvičo laikas",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Ako standartinis laikas",
               "",
               "Ako vasaros laikas",
               "",
               "Ako laikas",
               "",
            };
        final String[] Apia = new String[] {
               "Apijos žiemos laikas",
               "",
               "Apijos vasaros laikas",
               "",
               "Apijos laikas",
               "",
            };
        final String[] Cook = new String[] {
               "Kuko Salų žiemos laikas",
               "",
               "Kuko Salų pusės vasaros laikas",
               "",
               "Kuko Salų laikas",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubos žiemos laikas",
               "CST",
               "Kubos vasaros laikas",
               "CDT",
               "Kubos laikas",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidžio žiemos laikas",
               "",
               "Fidžio vasaros laikas",
               "",
               "Fidžio laikas",
               "",
            };
        final String[] Gulf = new String[] {
               "Persijos įlankos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdo žiemos laikas",
               "",
               "Hovdo vasaros laikas",
               "",
               "Hovdo laikas",
               "",
            };
        final String[] Iran = new String[] {
               "Irano žiemos laikas",
               "",
               "Irano vasaros laikas",
               "",
               "Irano laikas",
               "",
            };
        final String[] Niue = new String[] {
               "Niujė laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsko žiemos laikas",
               "",
               "Omsko vasaros laikas",
               "",
               "Omsko laikas",
               "",
            };
        final String[] Peru = new String[] {
               "Peru žiemos laikas",
               "",
               "Peru vasaros laikas",
               "",
               "Peru laikas",
               "",
            };
        final String[] Truk = new String[] {
               "Čuko laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Veiko Salos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Čilės žiemos laikas",
               "",
               "Čilės vasaros laikas",
               "",
               "Čilės laikas",
               "",
            };
        final String[] China = new String[] {
               "Kinijos žiemos laikas",
               "CST",
               "Kinijos vasaros laikas",
               "CDT",
               "Kinijos laikas",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosų Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Deiviso laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijos laikas",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japonijos žiemos laikas",
               "JST",
               "Japonijos vasaros laikas",
               "JDT",
               "Japonijos laikas",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korėjos žiemos laikas",
               "KST",
               "Korėjos vasaros laikas",
               "KST",
               "Korėjos laikas",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalo laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa žiemos laikas",
               "SST",
               "Samoa vasaros laikas",
               "SST",
               "Samoa laikas",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Siovos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongos žiemos laikas",
               "",
               "Tongos vasaros laikas",
               "",
               "Tongos laikas",
               "",
            };
        final String[] Yukon = new String[] {
               "Jukono laikas",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Aliaskos žiemos laikas",
               "AKST",
               "Aliaskos vasaros laikas",
               "AKDT",
               "Aliaskos laikas",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonės žiemos laikas",
               "",
               "Amazonės vasaros laikas",
               "",
               "Amazonės laikas",
               "",
            };
        final String[] Azores = new String[] {
               "Azorų Salų žiemos laikas",
               "",
               "Azorų Salų vasaros laikas",
               "",
               "Azorų Salų laikas",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butano laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunėjaus Darusalamo laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Velykų salos žiemos laikas",
               "",
               "Velykų Salos vasaros laikas",
               "",
               "Velykų Salos laikas",
               "",
            };
        final String[] Guyana = new String[] {
               "Gajanos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Havajų–Aleutų žiemos laikas",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Izraelio žiemos laikas",
               "IST",
               "Izraelio vasaros laikas",
               "IDT",
               "Izraelio laikas",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrajė laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mosono laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Maskvos žiemos laikas",
               "MSK",
               "Maskvos vasaros laikas",
               "MSK",
               "Maskvos laikas",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapės laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samaros žiemos laikas",
               "",
               "Samaros vasaros laikas",
               "",
               "Samaros laikas",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahičio laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipėjaus žiemos laikas",
               "CST",
               "Taipėjaus vasaros laikas",
               "CDT",
               "Taipėjaus laikas",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Turkijos žiemos laikas",
               "",
               "Turkijos vasaros laikas",
               "",
               "Turkijos laikas",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoko laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Voliso ir Futūnos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabijos žiemos laikas",
               "",
               "Arabijos vasaros laikas",
               "",
               "Arabijos laikas",
               "",
            };
        final String[] Armenia = new String[] {
               "Armėnijos žiemos laikas",
               "",
               "Armėnijos vasaros laikas",
               "",
               "Armėnijos laikas",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivijos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Čatamo žiemos laikas",
               "",
               "Čatamo vasaros laikas",
               "",
               "Čatamo laikas",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "pasaulio suderintasis laikas",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoro laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambyro laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijos žiemos laikas",
               "",
               "Gruzijos vasaros laikas",
               "",
               "Gruzijos laikas",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko žiemos laikas",
               "",
               "Irkutsko vasaros laikas",
               "",
               "Irkutsko laikas",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadano žiemos laikas",
               "",
               "Magadano vasaros laikas",
               "",
               "Magadano laikas",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mianmaro laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolko Salų žiemos laikas",
               "",
               "Norfolko Salų vasaros laikas",
               "",
               "Norfolko Salų laikas",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronjos žiemos laikas",
               "",
               "Fernando de Noronjos vasaros laikas",
               "",
               "Fernando de Noronjos laikas",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunjono laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roteros laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Saliamono Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajaus žiemos laikas",
               "",
               "Urugvajaus vasaros laikas",
               "",
               "Urugvajaus laikas",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu žiemos laikas",
               "",
               "Vanuatu vasaros laikas",
               "",
               "Vanuatu laikas",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsko žiemos laikas",
               "",
               "Jakutsko vasaros laikas",
               "",
               "Jakutsko laikas",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlanto žiemos laikas",
               "AST",
               "Atlanto vasaros laikas",
               "AST",
               "Atlanto laikas",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brazilijos žiemos laikas",
               "",
               "Brazilijos vasaros laikas",
               "",
               "Brazilijos laikas",
               "",
            };
        final String[] Chamorro = new String[] {
               "Čamoro laikas",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbijos žiemos laikas",
               "",
               "Kolumbijos vasaros laikas",
               "",
               "Kolumbijos laikas",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklandų Salų žiemos laikas",
               "",
               "Folklando Salų vasaros laikas",
               "",
               "Folklando Salų laikas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaizijos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldyvų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batoro žiemos laikas",
               "",
               "Ulan Batoro vasaros laikas",
               "",
               "Ulan Batoro laikas",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistano žiemos laikas",
               "PKT",
               "Pakistano vasaros laikas",
               "PKST",
               "Pakistano laikas",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajaus žiemos laikas",
               "",
               "Paragvajaus vasaros laikas",
               "",
               "Paragvajaus laikas",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkerno laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamo laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinos žiemos laikas",
               "",
               "Argentinos vasaros laikas",
               "",
               "Argentinos laikas",
               "",
            };
        final String[] Christmas = new String[] {
               "Kalėdų Salos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongo žiemos laikas",
               "HKT",
               "Honkongo vasaros laikas",
               "HKST",
               "Honkongo laikas",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokinijos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamčiatkos Petropavlovsko žiemos laikas",
               "",
               "Kamčiatkos Petropavlovsko vasaros laikas",
               "",
               "Kamčiatkos Petropavlovsko laikas",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistano laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lordo Hau žiemos laikas",
               "",
               "Lordo Hau vasaros laikas",
               "",
               "Lordo Hau laikas",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markizo Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijaus žiemos laikas",
               "",
               "Mauricijaus vasaros laikas",
               "",
               "Mauricijaus laikas",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapūro laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venesuelos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaidžano žiemos laikas",
               "",
               "Azerbaidžano vasaros laikas",
               "",
               "Azerbaidžano laikas",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladešo žiemos laikas",
               "",
               "Bangladešo vasaros laikas",
               "",
               "Bangladešo laikas",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Žaliojo Kyšulio žiemos laikas",
               "",
               "Žaliojo Kyšulio vasaros laikas",
               "",
               "Žaliojo Kyšulio laikas",
               "",
            };
        final String[] East_Timor = new String[] {
               "Rytų Timoro laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazachstano laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seišelių laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadžikistano laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistano žiemos laikas",
               "",
               "Uzbekistano vasaros laikas",
               "",
               "Uzbekistano laikas",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistano laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsko žiemos laikas",
               "",
               "Krasnojarsko vasaros laikas",
               "",
               "Krasnojarsko laikas",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Naujosios Zelandijos žiemos laikas",
               "NZST",
               "Naujosios Zelandijos vasaros laikas",
               "NZDT",
               "Naujosios Zelandijos laikas",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Filipinų žiemos laikas",
               "PST",
               "Filipinų vasaros laikas",
               "PDT",
               "Filipinų laikas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoko žiemos laikas",
               "",
               "Vladivostoko vasaros laikas",
               "",
               "Vladivostoko laikas",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijos vandenyno laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Laino Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Niufaundlendo žiemos laikas",
               "NST",
               "Niufaundlendo vasaros laikas",
               "NDT",
               "Niufaundlendo laikas",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmėnistano žiemos laikas",
               "",
               "Turkmėnistano vasaros laikas",
               "",
               "Turkmėnistano laikas",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Prancūzijos Gvianos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Naujosios Kaledonijos žiemos laikas",
               "",
               "Naujosios Kaledonijos vasaros laikas",
               "",
               "Naujosios Kaledonijos laikas",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Pietų Džordžijos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgo žiemos laikas",
               "",
               "Jekaterinburgo vasaros laikas",
               "",
               "Jekaterinburgo laikas",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centrinės Afrikos laikas",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Rytų Afrikos laikas",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Vakarų Afrikos laikas",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Diumono d’Urvilio laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Vidurio Europos žiemos laikas",
               "CET",
               "Vidurio Europos vasaros laikas",
               "CEST",
               "Vidurio Europos laikas",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Rytų Europos žiemos laikas",
               "EET",
               "Rytų Europos vasaros laikas",
               "EEST",
               "Rytų Europos laikas",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Vakarų Europos žiemos laikas",
               "WET",
               "Vakarų Europos vasaros laikas",
               "WEST",
               "Vakarų Europos laikas",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikos Ramiojo vandenyno žiemos laikas",
               "MST",
               "Meksikos Ramiojo vandenyno vasaros laikas",
               "MDT",
               "Meksikos Ramiojo vandenyno laikas",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Pietų Afrikos laikas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Šiaurės Amerikos centro žiemos laikas",
               "CST",
               "Šiaurės Amerikos centro vasaros laikas",
               "CDT",
               "Šiaurės Amerikos centro laikas",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Šiaurės Amerikos rytų žiemos laikas",
               "EST",
               "Šiaurės Amerikos rytų vasaros laikas",
               "EST",
               "Šiaurės Amerikos rytų laikas",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Šiaurės Amerikos Ramiojo vandenyno žiemos laikas",
               "PST",
               "Šiaurės Amerikos Ramiojo vandenyno vasaros laikas",
               "PDT",
               "Šiaurės Amerikos Ramiojo vandenyno laikas",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Pietų Prancūzijos ir antarktinis laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberto Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajų–Aleutų žiemos laikas",
               "HST",
               "Havajų–Aleutų vasaros laikas",
               "HDT",
               "Havajų-Aleutų laikas",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fenikso Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen Pjero ir Mikelono žiemos laikas",
               "",
               "Sen Pjero ir Mikelono vasaros laikas",
               "",
               "Sen Pjero ir Mikelono laikas",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Šiaurės Amerikos kalnų žiemos laikas",
               "MST",
               "Šiaurės Amerikos kalnų vasaros laikas",
               "MST",
               "Šiaurės Amerikos kalnų laikas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Maršalo Salų laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Naujosios Gvinėjos laikas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Centrinės Australijos žiemos laikas",
               "ACST",
               "Centrinės Australijos vasaros laikas",
               "ACDT",
               "Centrinės Australijos laikas",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Rytų Australijos žiemos laikas",
               "AEST",
               "Rytų Australijos vasaros laikas",
               "AEDT",
               "Rytų Australijos laikas",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Vakarų Australijos žiemos laikas",
               "AWST",
               "Vakarų Australijos vasaros laikas",
               "AWDT",
               "Vakarų Australijos laikas",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centrinės Indonezijos laikas",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Rytų Indonezijos laikas",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vakarų Indonezijos laikas",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Centrinės vakarų Australijos žiemos laikas",
               "",
               "Centrinės vakarų Australijos vasaros laikas",
               "",
               "Centrinės vakarų Australijos laikas",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Airijos vasaros laikas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "pasaulio suderintasis laikas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Airijos vasaros laikas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Grinvičo laikas",
                    "GMT",
                    "Britanijos vasaros laikas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adenas" },
            { "timezone.excity.Asia/Dili", "Dilis" },
            { "timezone.excity.Asia/Gaza", "Gazos ruožas" },
            { "timezone.excity.Asia/Hovd", "Hovdas" },
            { "timezone.excity.Asia/Omsk", "Omskas" },
            { "timezone.excity.Asia/Oral", "Uralskas" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amanas" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Čita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubajus" },
            { "timezone.excity.Asia/Kabul", "Kabulas" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Kataras" },
            { "timezone.excity.Asia/Seoul", "Seulas" },
            { "timezone.excity.Asia/Tokyo", "Tokijas" },
            { "timezone.excity.Asia/Tomsk", "Tomskas" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Džuba" },
            { "timezone.excity.Africa/Lome", "Lomė" },
            { "timezone.excity.Asia/Almaty", "Alma Ata" },
            { "timezone.excity.Asia/Anadyr", "Anadyris" },
            { "timezone.excity.Asia/Aqtobe", "Aktiubinskas" },
            { "timezone.excity.Asia/Beirut", "Beirutas" },
            { "timezone.excity.Asia/Brunei", "Brunėjus" },
            { "timezone.excity.Asia/Hebron", "Hebronas" },
            { "timezone.excity.Asia/Kuwait", "Kuveitas" },
            { "timezone.excity.Asia/Muscat", "Maskatas" },
            { "timezone.excity.Asia/Riyadh", "Rijadas" },
            { "timezone.excity.Asia/Saigon", "Hošiminas" },
            { "timezone.excity.Asia/Taipei", "Taipėjus" },
            { "timezone.excity.Asia/Tehran", "Teheranas" },
            { "timezone.excity.Asia/Urumqi", "Urumči" },
            { "timezone.excity.Etc/Unknown", "nežinomas miestas" },
            { "timezone.excity.Europe/Kiev", "Kijevas" },
            { "timezone.excity.Europe/Oslo", "Oslas" },
            { "timezone.excity.Europe/Riga", "Ryga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mahė" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kairas" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Dakar", "Dakaras" },
            { "timezone.excity.Africa/Lagos", "Lagosas" },
            { "timezone.excity.Africa/Tunis", "Tunisas" },
            { "timezone.excity.America/Adak", "Eidakas" },
            { "timezone.excity.America/Nome", "Nomas" },
            { "timezone.excity.Asia/Baghdad", "Bagdadas" },
            { "timezone.excity.Asia/Bahrain", "Bahreinas" },
            { "timezone.excity.Asia/Bangkok", "Bankokas" },
            { "timezone.excity.Asia/Barnaul", "Barnaulas" },
            { "timezone.excity.Asia/Bishkek", "Biškekas" },
            { "timezone.excity.Asia/Colombo", "Kolombas" },
            { "timezone.excity.Asia/Irkutsk", "Irkutskas" },
            { "timezone.excity.Asia/Jakarta", "Džakarta" },
            { "timezone.excity.Asia/Karachi", "Karačis" },
            { "timezone.excity.Asia/Kuching", "Kučingas" },
            { "timezone.excity.Asia/Magadan", "Magadanas" },
            { "timezone.excity.Asia/Nicosia", "Nikosija" },
            { "timezone.excity.Asia/Rangoon", "Rangūnas" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisis" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutskas" },
            { "timezone.excity.Asia/Yerevan", "Jerevanas" },
            { "timezone.excity.Europe/Kirov", "Kirovas" },
            { "timezone.excity.Europe/Minsk", "Minskas" },
            { "timezone.excity.Europe/Paris", "Paryžius" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Europe/Vaduz", "Vaducas" },
            { "timezone.excity.Indian/Cocos", "Kokosų sala" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Fiji", "Fidžis" },
            { "timezone.excity.Pacific/Guam", "Guamas" },
            { "timezone.excity.Pacific/Niue", "Niujė" },
            { "timezone.excity.Pacific/Truk", "Čukas" },
            { "timezone.excity.Pacific/Wake", "Veiko sala" },
            { "timezone.excity.Africa/Bamako", "Bamakas" },
            { "timezone.excity.Africa/Bangui", "Bangis" },
            { "timezone.excity.Africa/Banjul", "Bandžulis" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Harare", "Hararė" },
            { "timezone.excity.Africa/Kigali", "Kigalis" },
            { "timezone.excity.Africa/Malabo", "Malabas" },
            { "timezone.excity.Africa/Maputo", "Maputas" },
            { "timezone.excity.Africa/Niamey", "Niamėjus" },
            { "timezone.excity.America/Bahia", "Baija" },
            { "timezone.excity.America/Belem", "Belenas" },
            { "timezone.excity.America/Boise", "Boisis" },
            { "timezone.excity.America/Jujuy", "Chuchujus" },
            { "timezone.excity.America/Thule", "Kanakas" },
            { "timezone.excity.Asia/Ashgabat", "Ašchabadas" },
            { "timezone.excity.Asia/Damascus", "Damaskas" },
            { "timezone.excity.Asia/Dushanbe", "Dušanbė" },
            { "timezone.excity.Asia/Jayapura", "Džajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Makassar", "Makasaras" },
            { "timezone.excity.Asia/Qostanay", "Kostanajus" },
            { "timezone.excity.Asia/Sakhalin", "Sachalinas" },
            { "timezone.excity.Asia/Shanghai", "Šanchajus" },
            { "timezone.excity.Asia/Tashkent", "Taškentas" },
            { "timezone.excity.Asia/Ust-Nera", "Ust Nera" },
            { "timezone.excity.Europe/Athens", "Atėnai" },
            { "timezone.excity.Europe/Berlin", "Berlynas" },
            { "timezone.excity.Europe/Dublin", "Dublinas" },
            { "timezone.excity.Europe/Jersey", "Džersis" },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Europe/London", "Londonas" },
            { "timezone.excity.Europe/Madrid", "Madridas" },
            { "timezone.excity.Europe/Monaco", "Monakas" },
            { "timezone.excity.Europe/Moscow", "Maskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Skopje", "Skopjė" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varšuva" },
            { "timezone.excity.Europe/Zagreb", "Zagrebas" },
            { "timezone.excity.Europe/Zurich", "Ciurichas" },
            { "timezone.excity.Indian/Chagos", "Čagosas" },
            { "timezone.excity.Indian/Comoro", "Komoras" },
            { "timezone.excity.Pacific/Efate", "Efatė" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidžanas" },
            { "timezone.excity.Africa/Algiers", "Alžyras" },
            { "timezone.excity.Africa/Conakry", "Konakris" },
            { "timezone.excity.Africa/Mbabane", "Mbabanė" },
            { "timezone.excity.Africa/Nairobi", "Nairobis" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Belize", "Belizas" },
            { "timezone.excity.America/Cancun", "Kankūnas" },
            { "timezone.excity.America/Cayman", "Kaimanas" },
            { "timezone.excity.America/Cuiaba", "Kujaba" },
            { "timezone.excity.America/Dawson", "Dosonas" },
            { "timezone.excity.America/Denver", "Denveris" },
            { "timezone.excity.America/Guyana", "Gvajana" },
            { "timezone.excity.America/Inuvik", "Inuvikas" },
            { "timezone.excity.America/Juneau", "Džunas" },
            { "timezone.excity.America/La_Paz", "La Pasas" },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Manaus", "Manausas" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "timezone.excity.America/Recife", "Resifė" },
            { "timezone.excity.America/Regina", "Redžina" },
            { "timezone.excity.Asia/Hong_Kong", "Honkongas" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalė" },
            { "timezone.excity.Asia/Kamchatka", "Kamčiatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianakas" },
            { "timezone.excity.Asia/Pyongyang", "Pchenjanas" },
            { "timezone.excity.Asia/Qyzylorda", "Kzyl-Orda" },
            { "timezone.excity.Asia/Samarkand", "Samarkandas" },
            { "timezone.excity.Asia/Singapore", "Singapūras" },
            { "timezone.excity.Asia/Vientiane", "Vientianas" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Saratovas" },
            { "timezone.excity.Europe/Tallinn", "Talinas" },
            { "timezone.excity.Europe/Vatican", "Vatikanas" },
            { "timezone.excity.Indian/Mayotte", "Majotas" },
            { "timezone.excity.Indian/Reunion", "Reunjonas" },
            { "timezone.excity.Pacific/Easter", "Velykų sala" },
            { "timezone.excity.Pacific/Kosrae", "Kosrajė" },
            { "timezone.excity.Pacific/Majuro", "Madžūras" },
            { "timezone.excity.Pacific/Midway", "Midvėjus" },
            { "timezone.excity.Pacific/Noumea", "Numėja" },
            { "timezone.excity.Pacific/Ponape", "Ponapė" },
            { "timezone.excity.Pacific/Saipan", "Saipanas" },
            { "timezone.excity.Pacific/Tahiti", "Taitis" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "timezone.excity.Pacific/Wallis", "Volisas" },
            { "timezone.excity.Africa/Blantyre", "Blantairas" },
            { "timezone.excity.Africa/Djibouti", "Džibutis" },
            { "timezone.excity.Africa/El_Aaiun", "al Ajūnas" },
            { "timezone.excity.Africa/Freetown", "Fritaunas" },
            { "timezone.excity.Africa/Gaborone", "Gaboronas" },
            { "timezone.excity.Africa/Khartoum", "Chartumas" },
            { "timezone.excity.Africa/Kinshasa", "Kinšasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "timezone.excity.Africa/Ndjamena", "Ndžamena" },
            { "timezone.excity.Africa/Sao_Tome", "San Tomė" },
            { "timezone.excity.Africa/Windhoek", "Vindhukas" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.America/Caracas", "Karakasas" },
            { "timezone.excity.America/Cayenne", "Kajenas" },
            { "timezone.excity.America/Chicago", "Čikaga" },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Creston", "Krestonas" },
            { "timezone.excity.America/Curacao", "Kiurasao" },
            { "timezone.excity.America/Detroit", "Detroitas" },
            { "timezone.excity.America/Godthab", "Nūkas" },
            { "timezone.excity.America/Halifax", "Halifaksas" },
            { "timezone.excity.America/Iqaluit", "Ikaluitas" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.America/Managua", "Managva" },
            { "timezone.excity.America/Marigot", "Marigo" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.America/Moncton", "Monktonas" },
            { "timezone.excity.America/Noronha", "Noronja" },
            { "timezone.excity.America/Ojinaga", "Ochinaga" },
            { "timezone.excity.America/Phoenix", "Finiksas" },
            { "timezone.excity.America/Tijuana", "Tichuana" },
            { "timezone.excity.America/Toronto", "Torontas" },
            { "timezone.excity.America/Yakutat", "Jakutatas" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompenis" },
            { "timezone.excity.Atlantic/Azores", "Azorai" },
            { "timezone.excity.Atlantic/Canary", "Kanarų salos" },
            { "timezone.excity.Atlantic/Faeroe", "Farerai" },
            { "timezone.excity.Australia/Eucla", "Jukla" },
            { "timezone.excity.Australia/Perth", "Pertas" },
            { "timezone.excity.Europe/Belgrade", "Belgradas" },
            { "timezone.excity.Europe/Brussels", "Briuselis" },
            { "timezone.excity.Europe/Budapest", "Budapeštas" },
            { "timezone.excity.Europe/Busingen", "Biusingenas" },
            { "timezone.excity.Europe/Chisinau", "Kišiniovas" },
            { "timezone.excity.Europe/Guernsey", "Gernsis" },
            { "timezone.excity.Europe/Helsinki", "Helsinkis" },
            { "timezone.excity.Europe/Istanbul", "Stambulas" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevas" },
            { "timezone.excity.Indian/Maldives", "Maldyvai" },
            { "timezone.excity.Pacific/Chatham", "Čatamas" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofas" },
            { "timezone.excity.Pacific/Gambier", "Gambyras" },
            { "timezone.excity.Pacific/Norfolk", "Norfolkas" },
            { "timezone.excity.Africa/Bujumbura", "Bužumbūra" },
            { "timezone.excity.Africa/Mogadishu", "Mogadišas" },
            { "timezone.excity.America/Anguilla", "Angilija" },
            { "timezone.excity.America/Asuncion", "Asunsjonas" },
            { "timezone.excity.America/Barbados", "Barbadosas" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmontonas" },
            { "timezone.excity.America/Eirunepe", "Eirunepė" },
            { "timezone.excity.America/Mazatlan", "Masatlanas" },
            { "timezone.excity.America/Miquelon", "Mikelonas" },
            { "timezone.excity.America/New_York", "Niujorkas" },
            { "timezone.excity.America/Resolute", "Resolutas" },
            { "timezone.excity.America/Santarem", "Santarenas" },
            { "timezone.excity.America/Santiago", "Santjagas" },
            { "timezone.excity.America/St_Johns", "Sent Džonsas" },
            { "timezone.excity.America/St_Kitts", "Sent Kitsas" },
            { "timezone.excity.America/St_Lucia", "Sent Lusija" },
            { "timezone.excity.America/Winnipeg", "Vinipegas" },
            { "timezone.excity.Antarctica/Casey", "Keisis" },
            { "timezone.excity.Antarctica/Davis", "Deivisas" },
            { "timezone.excity.Antarctica/Syowa", "Siova" },
            { "timezone.excity.Antarctica/Troll", "Trolis" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarskas" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirskas" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Batoras" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostokas" },
            { "timezone.excity.Atlantic/Stanley", "Stenlis" },
            { "timezone.excity.Australia/Darwin", "Darvinas" },
            { "timezone.excity.Australia/Hobart", "Hobartas" },
            { "timezone.excity.Australia/Sydney", "Sidnėjus" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdamas" },
            { "timezone.excity.Europe/Astrakhan", "Astrachanė" },
            { "timezone.excity.Europe/Bucharest", "Bukareštas" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltaras" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Mariehamn", "Marianhamina" },
            { "timezone.excity.Europe/Stockholm", "Stokholmas" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovskas" },
            { "timezone.excity.Europe/Volgograd", "Volgogradas" },
            { "timezone.excity.Indian/Christmas", "Kalėdų Sala" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenas" },
            { "timezone.excity.Indian/Mauritius", "Mauricijus" },
            { "timezone.excity.Pacific/Auckland", "Oklandas" },
            { "timezone.excity.Pacific/Funafuti", "Funafutis" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkerno sala" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.Africa/Libreville", "Librevilis" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbašis" },
            { "timezone.excity.Africa/Nouakchott", "Nuakšotas" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novas" },
            { "timezone.excity.America/Anchorage", "Ankoridžas" },
            { "timezone.excity.America/Araguaina", "Aragvajana" },
            { "timezone.excity.America/Boa_Vista", "Bua Vista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "Čihuahua" },
            { "timezone.excity.America/Coyhaique", "Kojhaikė" },
            { "timezone.excity.America/Glace_Bay", "Gleis Bėjus" },
            { "timezone.excity.America/Goose_Bay", "Gus Bėjus" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/Guayaquil", "Gvajakilis" },
            { "timezone.excity.America/Matamoros", "Matamorosas" },
            { "timezone.excity.America/Menominee", "Menominis" },
            { "timezone.excity.America/Monterrey", "Monterėjus" },
            { "timezone.excity.America/Sao_Paulo", "San Paulas" },
            { "timezone.excity.America/St_Thomas", "Sent Tomasas" },
            { "timezone.excity.America/Vancouver", "Vankuveris" },
            { "timezone.excity.Antarctica/Mawson", "Mosonas" },
            { "timezone.excity.Antarctica/Palmer", "Palmeris" },
            { "timezone.excity.Antarctica/Vostok", "Vostokas" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kvala Lumpūras" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneckas" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhaga" },
            { "timezone.excity.Europe/Luxembourg", "Liuksemburgas" },
            { "timezone.excity.Europe/San_Marino", "San Marinas" },
            { "timezone.excity.Europe/Simferopol", "Simferopolis" },
            { "timezone.excity.Pacific/Enderbury", "Kantono sala" },
            { "timezone.excity.Pacific/Galapagos", "Galapagai" },
            { "timezone.excity.Pacific/Kwajalein", "Kvadžaleinas" },
            { "timezone.excity.Pacific/Marquesas", "Markizo salos" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pagas" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazavilis" },
            { "timezone.excity.Africa/Ouagadougou", "Vagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.America/Grand_Turk", "Grand Terkas" },
            { "timezone.excity.America/Guadeloupe", "Gvadalupė" },
            { "timezone.excity.America/Hermosillo", "Hermosiljas" },
            { "timezone.excity.America/Kralendijk", "Kralendeikas" },
            { "timezone.excity.America/Louisville", "Luisvilis" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "timezone.excity.America/Montevideo", "Montevidėjas" },
            { "timezone.excity.America/Montserrat", "Montseratas" },
            { "timezone.excity.America/Paramaribo", "Paramaribas" },
            { "timezone.excity.America/Rio_Branco", "Rio Brankas" },
            { "timezone.excity.America/St_Vincent", "Sent Vincentas" },
            { "timezone.excity.America/Whitehorse", "Vaithorsas" },
            { "timezone.excity.Antarctica/McMurdo", "Makmerdas" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymskas" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburgas" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikjavikas" },
            { "timezone.excity.Atlantic/St_Helena", "Sent Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaidė" },
            { "timezone.excity.Australia/Brisbane", "Brisbanas" },
            { "timezone.excity.Australia/Lindeman", "Lindemanas" },
            { "timezone.excity.Europe/Isle_of_Man", "Meno sala" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningradas" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimatis" },
            { "timezone.excity.Africa/Johannesburg", "Johanesburgas" },
            { "timezone.excity.America/El_Salvador", "Salvadoras" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelsonas" },
            { "timezone.excity.America/Los_Angeles", "Los Andželas" },
            { "timezone.excity.America/Mexico_City", "Meksikas" },
            { "timezone.excity.America/Porto_Velho", "Porto Veljas" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rikas" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjyrbienas" },
            { "timezone.excity.Atlantic/Cape_Verde", "Žaliasis Kyšulys" },
            { "timezone.excity.Australia/Lord_Howe", "Lordo Hau sala" },
            { "timezone.excity.Australia/Melbourne", "Melburnas" },
            { "timezone.excity.Indian/Antananarivo", "Antananaryvas" },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanalis" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salamas" },
            { "timezone.excity.America/Blanc-Sablon", "Blanč Sablonas" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Airės" },
            { "timezone.excity.America/Campo_Grande", "Kampo Grandė" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshaunas" },
            { "timezone.excity.America/Dawson_Creek", "Doson Krikas" },
            { "timezone.excity.America/Indiana/Knox", "Noksas, Indiana" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenasas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inletas" },
            { "timezone.excity.America/Scoresbysund", "Itokortormitas" },
            { "timezone.excity.Antarctica/Macquarie", "Makvoris" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvilis" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Morsbis" },
            { "timezone.excity.America/Cambridge_Bay", "Keimbridž Bėjus" },
            { "timezone.excity.America/Ciudad_Juarez", "Siudad Chuaresas" },
            { "timezone.excity.America/Coral_Harbour", "Atikokanas" },
            { "timezone.excity.America/Indiana/Vevay", "Vivis, Indiana" },
            { "timezone.excity.America/Lower_Princes", "Žemutinis Prinses Kvorteris" },
            { "timezone.excity.America/Port_of_Spain", "Port of Speinas" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingas" },
            { "timezone.excity.America/St_Barthelemy", "Sen Bartelemi" },
            { "timezone.excity.America/Swift_Current", "Svift Karentas" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hilis" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderasas" },
            { "timezone.excity.America/Port-au-Prince", "Port o Prensas" },
            { "timezone.excity.Atlantic/South_Georgia", "Pietų Džordžija" },
            { "timezone.excity.America/Argentina/Salta", "Saltas" },
            { "timezone.excity.America/Indiana/Marengo", "Marengas, Indiana" },
            { "timezone.excity.America/Indiana/Winamac", "Vinamakas, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumanas" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ušuaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Tel Sitis, Indiana" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsenas, Indiana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Diumonas d’Urvilis" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riocha" },
            { "timezone.excity.America/Argentina/San_Juan", "San Chuanas" },
            { "timezone.excity.America/Argentina/San_Luis", "Sent Luisas" },
            { "timezone.excity.America/Indiana/Petersburg", "Pitersbergas, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "Montiselas, Kentukis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bjula, Šiaurės Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Senteris, Šiaurės Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Galjegosas" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Niu Seilemas, Šiaurės Dakota" },
        };
        return data;
    }
}
