/*
 * SPDX-FileCopyrightText: Copyright (c) 2021-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <core/core.h>
#include <gpu/gpu.h>
#include <gpu/eng_desc.h>
#include <g_allclasses.h>
#include <ctrl/ctrl0080/ctrl0080gpu.h> // NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE


const NvU32 *
gpuGetGenericClassList_IMPL(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 genericClassDescriptorList[] = {
        LOCK_STRESS_OBJECT,
        LOCK_TEST_RELAXED_DUP_OBJECT,
        NV01_CONTEXT_DMA,
        NV01_DEVICE_0,
        NV01_EVENT,
        NV01_EVENT_KERNEL_CALLBACK,
        NV01_EVENT_KERNEL_CALLBACK_EX,
        NV01_EVENT_OS_EVENT,
        NV01_MEMORY_LIST_SYSTEM,
        NV01_MEMORY_SYSTEM,
        NV01_MEMORY_SYSTEM_OS_DESCRIPTOR,
        NV01_ROOT,
        NV01_ROOT_CLIENT,
        NV01_ROOT_NON_PRIV,
        NV20_SUBDEVICE_0,
    };
    *pNumClassDescriptors = 15;
    return genericClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_TU102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halTU102ClassDescriptorList[] = {
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_MEMORY_EXPORT,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 31;
    return halTU102ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_TU102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halTU102ClassDescriptorList);
    return halTU102ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_TU104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halTU104ClassDescriptorList[] = {
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_MEMORY_EXPORT,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 31;
    return halTU104ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_TU104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halTU104ClassDescriptorList);
    return halTU104ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_TU106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halTU106ClassDescriptorList[] = {
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_MEMORY_EXPORT,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 31;
    return halTU106ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_TU106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halTU106ClassDescriptorList);
    return halTU106ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_TU116(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halTU116ClassDescriptorList[] = {
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_MEMORY_EXPORT,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 31;
    return halTU116ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_TU116(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU116ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halTU116ClassDescriptorList);
    return halTU116ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_TU117(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halTU117ClassDescriptorList[] = {
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_MEMORY_EXPORT,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 31;
    return halTU117ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_TU117(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU117ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVB4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halTU117ClassDescriptorList);
    return halTU117ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA100ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 40;
    return halGA100ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_A, ENG_GR(0) },
        { AMPERE_COMPUTE_A, ENG_GR(1) },
        { AMPERE_COMPUTE_A, ENG_GR(2) },
        { AMPERE_COMPUTE_A, ENG_GR(3) },
        { AMPERE_COMPUTE_A, ENG_GR(4) },
        { AMPERE_COMPUTE_A, ENG_GR(5) },
        { AMPERE_COMPUTE_A, ENG_GR(6) },
        { AMPERE_COMPUTE_A, ENG_GR(7) },
        { AMPERE_DMA_COPY_A, ENG_CE(0) },
        { AMPERE_DMA_COPY_A, ENG_CE(1) },
        { AMPERE_DMA_COPY_A, ENG_CE(2) },
        { AMPERE_DMA_COPY_A, ENG_CE(3) },
        { AMPERE_DMA_COPY_A, ENG_CE(4) },
        { AMPERE_DMA_COPY_A, ENG_CE(5) },
        { AMPERE_DMA_COPY_A, ENG_CE(6) },
        { AMPERE_DMA_COPY_A, ENG_CE(7) },
        { AMPERE_DMA_COPY_A, ENG_CE(8) },
        { AMPERE_DMA_COPY_A, ENG_CE(9) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC4D1_VIDEO_NVJPG, ENG_NVJPG },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVC6FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA100ClassDescriptorList);
    return halGA100ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA102ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halGA102ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA102ClassDescriptorList);
    return halGA102ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA103(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA103ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halGA103ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA103(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA103ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA103ClassDescriptorList);
    return halGA103ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA104ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halGA104ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA104ClassDescriptorList);
    return halGA104ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA106ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halGA106ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA106ClassDescriptorList);
    return halGA106ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GA107(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGA107ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halGA107ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GA107(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA107ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGA107ClassDescriptorList);
    return halGA107ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_AD102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halAD102ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halAD102ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_AD102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halAD102ClassDescriptorList);
    return halAD102ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_AD103(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halAD103ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halAD103ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_AD103(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD103ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halAD103ClassDescriptorList);
    return halAD103ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_AD104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halAD104ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halAD104ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_AD104(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halAD104ClassDescriptorList);
    return halAD104ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_AD106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halAD106ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halAD106ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_AD106(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halAD106ClassDescriptorList);
    return halAD106ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_AD107(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halAD107ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 41;
    return halAD107ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_AD107(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD107ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halAD107ClassDescriptorList);
    return halAD107ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GH100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGH100ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGH100ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GH100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGH100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_A, ENG_GR(0) },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_COMPUTE_A, ENG_GR(0) },
        { HOPPER_COMPUTE_A, ENG_GR(1) },
        { HOPPER_COMPUTE_A, ENG_GR(2) },
        { HOPPER_COMPUTE_A, ENG_GR(3) },
        { HOPPER_COMPUTE_A, ENG_GR(4) },
        { HOPPER_COMPUTE_A, ENG_GR(5) },
        { HOPPER_COMPUTE_A, ENG_GR(6) },
        { HOPPER_COMPUTE_A, ENG_GR(7) },
        { HOPPER_DMA_COPY_A, ENG_CE(0) },
        { HOPPER_DMA_COPY_A, ENG_CE(1) },
        { HOPPER_DMA_COPY_A, ENG_CE(2) },
        { HOPPER_DMA_COPY_A, ENG_CE(3) },
        { HOPPER_DMA_COPY_A, ENG_CE(4) },
        { HOPPER_DMA_COPY_A, ENG_CE(5) },
        { HOPPER_DMA_COPY_A, ENG_CE(6) },
        { HOPPER_DMA_COPY_A, ENG_CE(7) },
        { HOPPER_DMA_COPY_A, ENG_CE(8) },
        { HOPPER_DMA_COPY_A, ENG_CE(9) },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVB8FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGH100ClassDescriptorList);
    return halGH100ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB100ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB100ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB100(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(10) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(11) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(12) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(13) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(14) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(15) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(16) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(17) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(18) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(19) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(1) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB100ClassDescriptorList);
    return halGB100ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB102ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB102ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB102(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB102ClassDescriptorList);
    return halGB102ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB10B(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB10BClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_MEMORY_SYNCPOINT,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 46;
    return halGB10BClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB10B(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB10BClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC970_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC971_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC973_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC97A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC97B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCEB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCEB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCEB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCEB7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCEFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB10BClassDescriptorList);
    return halGB10BClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB110(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB110ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB110ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB110(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB110ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(10) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(11) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(12) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(13) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(14) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(15) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(16) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(17) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(18) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(19) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(1) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB110ClassDescriptorList);
    return halGB110ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB112(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB112ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB112ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB112(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB112ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB112ClassDescriptorList);
    return halGB112ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB202(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB202ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB202ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB202(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB202ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(3) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB202ClassDescriptorList);
    return halGB202ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB203(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB203ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB203ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB203(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB203ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB203ClassDescriptorList);
    return halGB203ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB205(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB205ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB205ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB205(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB205ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB205ClassDescriptorList);
    return halGB205ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB206(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB206ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB206ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB206(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB206ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB206ClassDescriptorList);
    return halGB206ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB207(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB207ClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 45;
    return halGB207ClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB207(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB207ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB207ClassDescriptorList);
    return halGB207ClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB20B(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB20BClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_MEMORY_SYNCPOINT,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 46;
    return halGB20BClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB20B(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB20BClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCB71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCB73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCB7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCB7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVD1B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVD1B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVD1FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB20BClassDescriptorList);
    return halGB20BClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_GB20C(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halGB20CClassDescriptorList[] = {
        AMPERE_SMC_CONFIG_SESSION,
        AMPERE_SMC_EXEC_PARTITION_REF,
        AMPERE_SMC_MONITOR_SESSION,
        AMPERE_SMC_PARTITION_REF,
        FABRIC_MANAGER_SESSION,
        GF100_CHANNEL_GPFIFO,
        GF100_PROFILER,
        GT200_DEBUGGER,
        HOPPER_MMU_VIDMEM_ACCESS_BIT_BUFFER,
        KERNEL_GRAPHICS_CONTEXT,
        MAXWELL_PROFILER_CONTEXT,
        MAXWELL_PROFILER_DEVICE,
        MMU_VIDMEM_ACCESS_BIT_BUFFER,
        MPS_COMPUTE,
        NV0020_GPU_MANAGEMENT,
        NV0092_RG_LINE_CALLBACK,
        NV01_MEMORY_DEVICELESS,
        NV01_MEMORY_FLA,
        NV01_MEMORY_FRAMEBUFFER_CONSOLE,
        NV01_MEMORY_HW_RESOURCES,
        NV01_MEMORY_LIST_FBMEM,
        NV01_MEMORY_LIST_OBJECT,
        NV01_MEMORY_LOCAL_PHYSICAL,
        NV01_MEMORY_LOCAL_PRIVILEGED,
        NV01_MEMORY_SYNCPOINT,
        NV01_TIMER,
        NV2081_BINAPI,
        NV2082_BINAPI_PRIVILEGED,
        NV20_SUBDEVICE_DIAG,
        NV30_GSYNC,
        NV40_DEBUG_BUFFER,
        NV40_I2C,
        NV9010_VBLANK_CALLBACK,
        NV_CE_UTILS,
        NV_COUNTER_COLLECTION_UNIT,
        NV_EVENT_BUFFER,
        NV_IMEX_SESSION,
        NV_MEMORY_EXPORT,
        NV_MEMORY_EXTENDED_USER,
        NV_MEMORY_FABRIC,
        NV_MEMORY_FABRIC_IMPORTED_REF,
        NV_MEMORY_FABRIC_IMPORT_V2,
        NV_MEMORY_MAPPER,
        NV_MEMORY_MULTICAST_FABRIC,
        NV_SEMAPHORE_SURFACE,
        UVM_CHANNEL_RETAINER,
    };
    *pNumClassDescriptors = 46;
    return halGB20CClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_GB20C(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB20CClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FABRIC_VASPACE_A, ENG_INVALID },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { IO_VASPACE_A, ENG_INVALID },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MAXWELL_PROFILER, ENG_INVALID },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_CHANNEL_GPFIFO, ENG_INVALID },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCC70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCC71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCC73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCC7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCC7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCC7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCC7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCED0_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVD1B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVD1B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVD1FA_VIDEO_OFA, ENG_OFA(0) },
        { NVENC_SW_SESSION, ENG_SW },
        { NVFBC_SW_SESSION, ENG_SW },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halGB20CClassDescriptorList);
    return halGB20CClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_T234D(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halT234DClassDescriptorList[] = {
        NV01_MEMORY_SYNCPOINT,
    };
    *pNumClassDescriptors = 1;
    return halT234DClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_T234D(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halT234DClassDescriptorList[] = {
        { GF100_HDACODEC, ENG_HDACODEC },
        { IO_VASPACE_A, ENG_INVALID },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halT234DClassDescriptorList);
    return halT234DClassDescriptorList;
}

const NvU32 *
gpuGetNoEngClassList_T264D(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const NvU32 halT264DClassDescriptorList[] = {
        NV01_MEMORY_SYNCPOINT,
    };
    *pNumClassDescriptors = 1;
    return halT264DClassDescriptorList;
}

const CLASSDESCRIPTOR *
gpuGetEngClassDescriptorList_T264D(OBJGPU *pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halT264DClassDescriptorList[] = {
        { GF100_HDACODEC, ENG_HDACODEC },
        { IO_VASPACE_A, ENG_INVALID },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC970_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC971_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC973_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC97A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC97B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
    };
    *pNumClassDescriptors = NV_ARRAY_ELEMENTS(halT264DClassDescriptorList);
    return halT264DClassDescriptorList;
}

ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= (15 /* generic */ + 116 /* GB20B */));
