/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDate;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXPercentage;
import com.tapsterrock.mpx.MPXTime;
import com.tapsterrock.mpx.MPXUnits;
import com.tapsterrock.mpx.NumericBoolean;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Date;

class MPXRecord {
    private MPXFile m_mpx;
    private Object[] m_array;
    private Object[] m_extended;
    static final char EOL_PLACEHOLDER = '\u007f';
    static final String EOL_PLACEHOLDER_STRING = new String(new byte[]{127});
    protected static final int EXTENDED_OFFSET = 1000;

    protected MPXRecord(MPXFile mpx, int size) {
        this.m_mpx = mpx;
        this.m_array = new Object[size];
    }

    protected MPXRecord(MPXFile mpx, int size, int extendedSize) {
        this(mpx, size);
        this.m_extended = new Object[extendedSize];
    }

    protected final String stripLineBreaks(String text, String replacement) {
        if (text.indexOf(13) != -1 || text.indexOf(10) != -1) {
            int index;
            StringBuffer sb = new StringBuffer(text);
            while ((index = sb.indexOf("\r\n")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\n\r")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\r")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            while ((index = sb.indexOf("\n")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            text = sb.toString();
        }
        return text;
    }

    private String escapeQuotes(String value) {
        StringBuffer sb = new StringBuffer();
        int length = value.length();
        sb.append('\"');
        for (int index = 0; index < length; ++index) {
            char c = value.charAt(index);
            sb.append(c);
            if (c != '\"') continue;
            sb.append('\"');
        }
        sb.append('\"');
        return sb.toString();
    }

    protected final String format(char sepchar, Object o) {
        String result;
        if (o == null) {
            result = "";
        } else {
            result = o instanceof Boolean ? LocaleData.getString(this.m_mpx.getLocale(), (Boolean)o == true ? "YES" : "NO") : (o instanceof Float || o instanceof Double ? this.m_mpx.getDecimalFormat().format(((Number)o).doubleValue()) : (o instanceof ToStringRequiresFile ? ((ToStringRequiresFile)o).toString(this.m_mpx) : o.toString()));
            if ((result = this.stripLineBreaks(result, EOL_PLACEHOLDER_STRING)).indexOf(34) != -1) {
                result = this.escapeQuotes(result);
            } else if (result.indexOf(sepchar) != -1) {
                result = '\"' + result + '\"';
            }
        }
        return result;
    }

    protected String toString(int code) {
        StringBuffer buf = new StringBuffer(String.valueOf(code));
        char sepchar = this.m_mpx.getDelimiter();
        for (int loop = 0; loop < this.m_array.length; ++loop) {
            buf.append(sepchar);
            buf.append(this.format(sepchar, this.m_array[loop]));
        }
        this.stripTrailingDelimiters(buf, sepchar);
        buf.append("\r\n");
        return buf.toString();
    }

    protected String toString(int code, int[] fields) {
        int field;
        StringBuffer buf = new StringBuffer(String.valueOf(code));
        char sepchar = this.m_mpx.getDelimiter();
        for (int loop = 0; loop < fields.length && (field = fields[loop]) != -1; ++loop) {
            buf.append(sepchar);
            buf.append(this.format(sepchar, this.get(field)));
        }
        this.stripTrailingDelimiters(buf, sepchar);
        buf.append("\r\n");
        return buf.toString();
    }

    protected final void stripTrailingDelimiters(StringBuffer buffer, char delimiter) {
        int index;
        for (index = buffer.length() - 1; index > 0 && buffer.charAt(index) == delimiter; --index) {
        }
        buffer.setLength(index + 1);
    }

    public void put(int key, Object value) {
        if (key < this.m_array.length) {
            this.m_array[key] = value;
        } else {
            this.m_extended[key - 1000] = value;
        }
    }

    protected void put(int key, char value) {
        this.put(key, new Character(value));
    }

    protected void put(int key, int value) {
        this.put(key, new Integer(value));
    }

    protected void put(int key, boolean value) {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected MPXDate toDate(Date value) {
        MPXDate result = null;
        if (value != null) {
            result = !(value instanceof MPXDate) ? new MPXDate(this.m_mpx.getDateTimeFormat(), value) : (MPXDate)value;
        }
        return result;
    }

    protected void putDate(int key, Date value) {
        this.put(key, this.toDate(value));
    }

    protected MPXCurrency toCurrency(Number value) {
        MPXCurrency result = null;
        if (value != null) {
            result = !(value instanceof MPXCurrency) ? (value.doubleValue() == 0.0 ? this.m_mpx.getZeroCurrency() : new MPXCurrency(this.m_mpx.getCurrencyFormat(), value.doubleValue())) : (MPXCurrency)value;
        }
        return result;
    }

    protected void putCurrency(int key, Number value) {
        this.put(key, this.toCurrency(value));
    }

    protected void putUnits(int key, Number value) {
        if (value != null && !(value instanceof MPXUnits)) {
            value = new MPXUnits(value);
        }
        this.put(key, value);
    }

    protected MPXPercentage toPercentage(Number value) {
        MPXPercentage result = null;
        if (value != null) {
            result = !(value instanceof MPXPercentage) ? MPXPercentage.getInstance(value) : (MPXPercentage)value;
        }
        return result;
    }

    protected void putPercentage(int key, Number value) {
        this.put(key, this.toPercentage(value));
    }

    protected MPXTime toTime(Date value) {
        MPXTime result = null;
        if (value != null) {
            result = !(value instanceof MPXTime) ? new MPXTime(this.m_mpx.getTimeFormat(), value) : (MPXTime)value;
        }
        return result;
    }

    protected void putTime(int key, Date value) {
        this.put(key, this.toTime(value));
    }

    public Object get(int key) {
        Object result = key < this.m_array.length ? this.m_array[key] : this.m_extended[key - 1000];
        return result;
    }

    protected byte getByteValue(int key) {
        Number value = (Number)this.get(key);
        byte result = value == null ? (byte)0 : value.byteValue();
        return result;
    }

    protected boolean getBooleanValue(int key) {
        Boolean value = (Boolean)this.get(key);
        boolean result = value == null ? false : value;
        return result;
    }

    protected boolean getNumericBooleanValue(int key) {
        NumericBoolean value = (NumericBoolean)this.get(key);
        boolean result = value == null ? false : value.booleanValue();
        return result;
    }

    protected char getCharValue(int key) {
        Character value = (Character)this.get(key);
        char result = value == null ? (char)'\u0000' : value.charValue();
        return result;
    }

    protected int getIntValue(int key) {
        Integer value = (Integer)this.get(key);
        int result = value == null ? 0 : value;
        return result;
    }

    protected float getFloatValue(int key) {
        Number value = (Number)this.get(key);
        float result = value == null ? 0.0f : value.floatValue();
        return result;
    }

    protected double getDoubleValue(int key) {
        return this.getDoubleValue((Number)this.get(key));
    }

    protected double getDoubleValue(Number value) {
        double result = value == null ? 0.0 : value.doubleValue();
        return result;
    }

    public final MPXFile getParentFile() {
        return this.m_mpx;
    }
}

