/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXNumberFormat;
import com.tapsterrock.mpx.ToStringRequiresFile;

final class MPXPercentage
extends Number
implements ToStringRequiresFile {
    private double m_value;
    static final String DECIMAL_FORMAT_STRING = "##0.##";
    private static final MPXNumberFormat DEFAULT_DECIMAL_FORMAT = new MPXNumberFormat("##0.##", '.', ',');
    private static final MPXPercentage ZERO = new MPXPercentage(0.0);

    private MPXPercentage(double value) {
        this.m_value = value;
    }

    public String toString() {
        return this.toString(DEFAULT_DECIMAL_FORMAT);
    }

    public String toString(MPXFile mpx) {
        return this.toString(mpx.getPercentageDecimalFormat());
    }

    String toString(MPXNumberFormat format) {
        return format.format(this.m_value) + "%";
    }

    public int intValue() {
        return (int)this.m_value;
    }

    public long longValue() {
        return (long)this.m_value;
    }

    public float floatValue() {
        return (float)this.m_value;
    }

    public double doubleValue() {
        return this.m_value;
    }

    public static MPXPercentage getInstance(double value) {
        MPXPercentage result = value == 0.0 ? ZERO : new MPXPercentage(value);
        return result;
    }

    public static MPXPercentage getInstance(Number value) {
        return MPXPercentage.getInstance(value.doubleValue());
    }

    public static MPXPercentage getInstance(String value, MPXNumberFormat format) throws MPXException {
        return MPXPercentage.getInstance(format.parse(value).doubleValue());
    }
}

