/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.DateRange;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.MPXCalendarException;
import com.tapsterrock.mpx.MPXCalendarHours;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.TimeUnit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class MPXCalendar
extends MPXRecord {
    private int m_uniqueID;
    private String m_name;
    private boolean m_baseCalendar;
    private String m_baseCalendarName;
    private int[] m_days = new int[7];
    private LinkedList m_exceptions = new LinkedList();
    private MPXCalendarHours[] m_hours = new MPXCalendarHours[7];
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    public static final int NON_WORKING = 0;
    public static final int WORKING = 1;
    public static final int DEFAULT = 2;
    static final int BASE_CALENDAR_RECORD_NUMBER = 20;
    static final int RESOURCE_CALENDAR_RECORD_NUMBER = 55;

    MPXCalendar(MPXFile file, boolean baseCalendar) {
        this(file, Record.EMPTY_RECORD, baseCalendar);
    }

    MPXCalendar(MPXFile file, Record record, boolean baseCalendar) {
        super(file, 0);
        this.m_baseCalendar = baseCalendar;
        if (this.m_baseCalendar) {
            this.setName(record.getString(0));
        } else {
            this.setBaseCalendarName(record.getString(0));
        }
        this.setWorkingDay(Day.SUNDAY, record.getInteger(1));
        this.setWorkingDay(Day.MONDAY, record.getInteger(2));
        this.setWorkingDay(Day.TUESDAY, record.getInteger(3));
        this.setWorkingDay(Day.WEDNESDAY, record.getInteger(4));
        this.setWorkingDay(Day.THURSDAY, record.getInteger(5));
        this.setWorkingDay(Day.FRIDAY, record.getInteger(6));
        this.setWorkingDay(Day.SATURDAY, record.getInteger(7));
        if (file.getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getCalendarUniqueID());
        }
    }

    public MPXCalendarException addCalendarException() throws MPXException {
        return this.addCalendarException(Record.EMPTY_RECORD);
    }

    MPXCalendarException addCalendarException(Record record) throws MPXException {
        MPXCalendarException bce = new MPXCalendarException(this.getParentFile(), this, record);
        this.m_exceptions.add(bce);
        return bce;
    }

    public LinkedList getCalendarExceptions() {
        return this.m_exceptions;
    }

    public MPXCalendarHours addCalendarHours(Day day) throws MPXException {
        MPXCalendarHours bch = new MPXCalendarHours(this.getParentFile(), this, Record.EMPTY_RECORD);
        bch.setDay(day);
        this.m_hours[day.getValue() - 1] = bch;
        return bch;
    }

    MPXCalendarHours addCalendarHours(Record record) throws MPXException {
        MPXCalendarHours bch;
        this.m_hours[bch.getDay().getValue() - 1] = bch = new MPXCalendarHours(this.getParentFile(), this, record);
        return bch;
    }

    public MPXCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setBaseCalendarName(String name) {
        this.m_baseCalendarName = name;
    }

    public String getBaseCalendarName() {
        return this.m_baseCalendarName;
    }

    public MPXCalendar getBaseCalendar() {
        String name = this.getBaseCalendarName();
        if (name == null || name.length() == 0) {
            name = DEFAULT_BASE_CALENDAR_NAME;
        }
        return this.getParentFile().getBaseCalendar(name);
    }

    public String toString() {
        int loop;
        StringBuffer buf = new StringBuffer();
        char delimiter = this.getParentFile().getDelimiter();
        if (this.m_baseCalendar) {
            buf.append(20);
            buf.append(delimiter);
            if (this.m_name != null) {
                buf.append(this.m_name);
            }
        } else {
            buf.append(55);
            buf.append(delimiter);
            if (this.m_baseCalendarName != null) {
                buf.append(this.m_baseCalendarName);
            }
        }
        for (loop = 0; loop < this.m_days.length; ++loop) {
            buf.append(delimiter);
            buf.append(this.m_days[loop]);
        }
        buf.append("\r\n");
        for (loop = 0; loop < this.m_hours.length; ++loop) {
            if (this.m_hours[loop] == null) continue;
            buf.append(this.m_hours[loop].toString());
        }
        if (!this.m_exceptions.isEmpty()) {
            Iterator iter = this.m_exceptions.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().toString());
            }
        }
        return buf.toString();
    }

    public boolean isWorkingDay(Day day) {
        boolean result;
        int value = this.m_days[day.getValue() - 1];
        if (value == 2) {
            MPXCalendar cal = this.getBaseCalendar();
            result = cal.isWorkingDay(day);
        } else {
            result = value == 1;
        }
        return result;
    }

    public int getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, int working) {
        this.m_days[day.getValue() - 1] = working;
    }

    public void setWorkingDay(Day day, boolean working) {
        this.setWorkingDay(day, working ? 1 : 0);
    }

    public void setWorkingDay(Day day, Integer working) {
        int value = working == null ? (!this.m_baseCalendar ? 2 : 1) : working;
        this.setWorkingDay(day, value);
    }

    public void addDefaultCalendarHours() throws MPXException {
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            Date from1 = df.parse("08:00");
            Date to1 = df.parse("12:00");
            Date from2 = df.parse("13:00");
            Date to2 = df.parse("17:00");
            MPXCalendarHours hours = this.addCalendarHours(Day.SUNDAY);
            hours = this.addCalendarHours(Day.MONDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.TUESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.WEDNESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.THURSDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.FRIDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.SATURDAY);
        }
        catch (ParseException ex) {
            throw new MPXException("Invalid time", ex);
        }
    }

    public MPXDuration getDuration(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dayIndex = cal.get(7);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), Day.getInstance(dayIndex))) {
                ++duration;
            }
            --days;
            if (++dayIndex > 7) {
                dayIndex = 1;
            }
            cal.set(6, cal.get(6) + 1);
        }
        return MPXDuration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getDate(Date startDate, MPXDuration duration) {
        boolean negative;
        MPXDuration dur = duration.convertUnits(TimeUnit.DAYS);
        int days = (int)dur.getDuration();
        if (days < 0) {
            negative = true;
            days = -days;
        } else {
            negative = false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dayIndex = cal.get(7);
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), Day.getInstance(dayIndex))) {
                --days;
            }
            if (!negative) {
                if (++dayIndex > 7) {
                    dayIndex = 1;
                }
                cal.set(6, cal.get(6) + 1);
                continue;
            }
            if (--dayIndex < 1) {
                dayIndex = 7;
            }
            cal.set(6, cal.get(6) - 1);
        }
        return cal.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Day day = Day.getInstance(cal.get(7));
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        boolean result = false;
        Iterator iter = this.m_exceptions.iterator();
        MPXCalendarException exception = null;
        while (iter.hasNext()) {
            exception = (MPXCalendarException)iter.next();
            if (exception.contains(date)) {
                result = exception.getWorkingValue();
                break;
            }
            exception = null;
        }
        if (exception == null) {
            result = this.isWorkingDay(day);
        }
        return result;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        return result;
    }

    public boolean isBaseCalendar() {
        return this.m_baseCalendar;
    }

    public void setUniqueID(int uniqueID) {
        this.m_uniqueID = uniqueID;
    }

    public int getUniqueID() {
        return this.m_uniqueID;
    }
}

