/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.chart.pert;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnit;
import org.ganttproject.chart.pert.PertChart;
import org.ganttproject.chart.pert.PertChartAbstraction;

public class ActivityOnNodePertChart
extends PertChart {
    private List myTaskGraphNodes;
    private List myGraphicalArrows;
    private List myGraphicalNodes;
    private int nbCols;
    private PertChartAbstraction myPertAbstraction;
    private int myMaxX = 1;
    private int myMaxY = 1;
    private GraphicalNode myPressedGraphicalNode;
    int myXClickedOffset;
    int myYClickedOffset;
    private Graphics myGraphics;
    private static GanttLanguage ourLanguage = GanttLanguage.getInstance();
    private static final int NODE_WIDTH = 110;
    private static final int NODE_HEIGHT = 70;
    private static final int X_GAP = 30;
    private static final int Y_GAP = 15;
    private static final int ARROW_HEIGHT = 10;
    private static final int ARROW_WIDTH = 15;
    private static final int ARROW_CORNER_WIDTH = 6;
    private static final int X_OFFSET = 5;
    private static final int Y_OFFSET = 5;
    private static final Color NORMAL_COLOR = Color.BLUE.brighter();
    private static final Color SUPER_COLOR = Color.RED;
    private static final Color MILESTONE_COLOR = Color.BLACK;
    private static final Color ARROW_COLOR = Color.GRAY;

    public ActivityOnNodePertChart() {
        super((TaskManager)null);
        this.setBackground(Color.WHITE.brighter());
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (ActivityOnNodePertChart.this.myPressedGraphicalNode != null) {
                    ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.x = e.getX() - ActivityOnNodePertChart.this.myXClickedOffset;
                    ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.y = e.getY() - ActivityOnNodePertChart.this.myYClickedOffset;
                    if ((double)e.getX() > ActivityOnNodePertChart.this.getPreferredSize().getWidth()) {
                        ActivityOnNodePertChart.this.setPreferredSize(new Dimension(((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.x + 110 + 30, (int)ActivityOnNodePertChart.this.getPreferredSize().getHeight()));
                        ActivityOnNodePertChart.this.revalidate();
                    }
                    if ((double)e.getY() > ActivityOnNodePertChart.this.getPreferredSize().getHeight()) {
                        ActivityOnNodePertChart.this.setPreferredSize(new Dimension((int)ActivityOnNodePertChart.this.getPreferredSize().getWidth(), ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.y + 70 + 15));
                        ActivityOnNodePertChart.this.revalidate();
                    }
                    ActivityOnNodePertChart.this.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent e) {
                ActivityOnNodePertChart.this.myPressedGraphicalNode = ActivityOnNodePertChart.this.getGraphicalNode(e.getX(), e.getY());
                if (ActivityOnNodePertChart.this.myPressedGraphicalNode != null) {
                    ActivityOnNodePertChart.this.myXClickedOffset = e.getX() - ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.x;
                    ActivityOnNodePertChart.this.myYClickedOffset = e.getY() - ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.y;
                    ActivityOnNodePertChart.this.myPressedGraphicalNode.backgroundColor = ActivityOnNodePertChart.this.myPressedGraphicalNode.backgroundColor.darker();
                }
                ActivityOnNodePertChart.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                if (ActivityOnNodePertChart.this.myPressedGraphicalNode != null) {
                    if (ActivityOnNodePertChart.this.myPressedGraphicalNode.node.isCritical()) {
                        ActivityOnNodePertChart.this.myPressedGraphicalNode.backgroundColor = GraphicalNode.defaultCriticalColor;
                    } else {
                        ActivityOnNodePertChart.this.myPressedGraphicalNode.backgroundColor = GraphicalNode.defaultBackgroundColor;
                    }
                    ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.x = ActivityOnNodePertChart.getGridX(e.getX() - ActivityOnNodePertChart.this.myXClickedOffset + 55);
                    ((ActivityOnNodePertChart)ActivityOnNodePertChart.this).myPressedGraphicalNode.y = ActivityOnNodePertChart.getGridY(e.getY());
                    ActivityOnNodePertChart.this.myPressedGraphicalNode = null;
                    ActivityOnNodePertChart.this.repaint();
                }
                ActivityOnNodePertChart.this.recalculatPreferredSize();
                ActivityOnNodePertChart.this.revalidate();
                ActivityOnNodePertChart.this.repaint();
            }
        });
    }

    private void recalculatPreferredSize() {
        int maxX = 0;
        int maxY = 0;
        Iterator it = this.myGraphicalNodes.iterator();
        while (it.hasNext()) {
            GraphicalNode gn = (GraphicalNode)it.next();
            int x = gn.x + 110;
            int y = gn.y + 70;
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        this.setPreferredSize(new Dimension(maxX, maxY));
        this.myMaxX = maxX;
        this.myMaxY = maxY;
    }

    private static boolean isInRectancle(int x, int y, int rectX, int rectY, int rectWidth, int rectHeight) {
        return x > rectX && x < rectX + rectWidth && y > rectY && y < rectY + rectHeight;
    }

    private GraphicalNode getGraphicalNode(int x, int y) {
        Iterator it = this.myGraphicalNodes.iterator();
        while (it.hasNext()) {
            GraphicalNode gn = (GraphicalNode)it.next();
            if (!ActivityOnNodePertChart.isInRectancle(x, y, gn.x, gn.y, 110, 70)) continue;
            return gn;
        }
        return null;
    }

    protected void buildPertChart() {
        if (this.myPertAbstraction == null) {
            this.myPertAbstraction = new PertChartAbstraction(this.myTaskManager);
            this.myTaskGraphNodes = this.myPertAbstraction.getTaskGraphNodes();
            this.myGraphicalNodes = new ArrayList();
            this.myGraphicalArrows = new ArrayList();
            this.nbCols = 0;
            this.setBackground(Color.WHITE);
            this.process();
            this.avoidCrossingNode();
            this.avoidCrossingLine();
            this.removeEmptyColumn();
            this.calculateGraphicalNodesCoordinates();
            this.calculateArrowsCoordinates();
            this.setPreferredSize(new Dimension(this.myMaxX, this.myMaxY));
        } else {
            this.myPertAbstraction = new PertChartAbstraction(this.myTaskManager);
            this.myTaskGraphNodes = this.myPertAbstraction.getTaskGraphNodes();
            this.updateGraphNodesInfo();
        }
    }

    private void updateGraphNodesInfo() {
        if (this.myTaskGraphNodes != null) {
            Iterator it = this.myTaskGraphNodes.iterator();
            while (it.hasNext()) {
                PertChartAbstraction.TaskGraphNode tgn = (PertChartAbstraction.TaskGraphNode)it.next();
                int id = tgn.getID();
                if (this.getGraphicalNodeByID(id) == null) continue;
                this.getGraphicalNodeByID(id).updateData(tgn);
            }
        }
    }

    private boolean isZeroPosition(PertChartAbstraction.TaskGraphNode taskGraphNode) {
        Iterator it = this.myTaskGraphNodes.iterator();
        while (it.hasNext()) {
            PertChartAbstraction.TaskGraphNode t = (PertChartAbstraction.TaskGraphNode)it.next();
            if (!t.getSuccessors().contains(taskGraphNode)) continue;
            return false;
        }
        return true;
    }

    private static int getGridX(int x) {
        int tmp = 0;
        for (int res = 5; res < x; res += 140) {
            tmp = res;
        }
        return tmp;
    }

    private static int getGridY(int y) {
        int tmp = 0;
        for (int res = 5; res < y; res += 85) {
            tmp = res;
        }
        return tmp;
    }

    private void process() {
        Iterator it = this.myTaskGraphNodes.iterator();
        while (it.hasNext()) {
            PertChartAbstraction.TaskGraphNode tgn = (PertChartAbstraction.TaskGraphNode)it.next();
            if (!this.isZeroPosition(tgn)) continue;
            this.add(0, new GraphicalNode(tgn));
        }
        int col = 0;
        List l = this.getNodesThatAreInASpecificSuccessorPosition(col);
        while (l != null) {
            Iterator it2 = l.iterator();
            while (it2.hasNext()) {
                PertChartAbstraction.TaskGraphNode tnode = (PertChartAbstraction.TaskGraphNode)it2.next();
                GraphicalNode gnode = this.getGraphicalNodeByID(tnode.getID());
                if (gnode == null) {
                    gnode = this.createGraphicalNode(tnode);
                } else {
                    this.remove(gnode);
                }
                this.add(col + 1, gnode);
            }
            l = this.getNodesThatAreInASpecificSuccessorPosition(++col);
        }
    }

    private GraphicalNode createGraphicalNode(PertChartAbstraction.TaskGraphNode taskGraphNode) {
        GraphicalNode res = this.getGraphicalNodeByID(taskGraphNode.getID());
        if (res != null) {
            return res;
        }
        return new GraphicalNode(taskGraphNode);
    }

    private void correctPositionBecauseOfSuperTasks() {
        TaskContainmentHierarchyFacade hierarchy = this.myTaskManager.getTaskHierarchy();
        Task[] tasks = this.myTaskManager.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            Task task = tasks[i];
            Task[] nestedTasks = hierarchy.getNestedTasks(task);
            this.correctPositions(nestedTasks);
        }
    }

    private void correctPositions(Task[] tasks) {
        if (tasks == null) {
            return;
        }
        TaskContainmentHierarchyFacade hierarchy = this.myTaskManager.getTaskHierarchy();
        for (int j = 0; j < tasks.length; ++j) {
            Task nestedTask = tasks[j];
            GraphicalNode gn = this.getGraphicalNodeByID(nestedTask.getTaskID());
            int oldPosition = gn.col;
            this.changePosition(gn, oldPosition + 1);
            this.correctPositions(hierarchy.getNestedTasks(nestedTask));
        }
    }

    private void changePosition(GraphicalNode graphicalNode, int newCol) {
        this.remove(graphicalNode);
        this.add(newCol, graphicalNode);
    }

    private void moveDown(GraphicalNode graphicalNode) {
        int row = graphicalNode.row;
        while (this.isOccupied(++row, graphicalNode.col)) {
        }
        graphicalNode.row = row;
    }

    private GraphicalNode getNode(int row, int col) {
        Iterator inCol = this.getNodeInColumn(col).iterator();
        while (inCol.hasNext()) {
            GraphicalNode node = (GraphicalNode)inCol.next();
            if (node.row != row) continue;
            return node;
        }
        return null;
    }

    private void moveRight(GraphicalNode graphicalNode) {
        Iterator successors = graphicalNode.node.getSuccessors().iterator();
        while (successors.hasNext()) {
            PertChartAbstraction.TaskGraphNode successor = (PertChartAbstraction.TaskGraphNode)successors.next();
            this.moveRight(this.getGraphicalNodeByID(successor.getID()));
        }
        int newCol = graphicalNode.col + 1;
        if (this.isOccupied(graphicalNode.row, newCol)) {
            this.moveRight(this.getNode(graphicalNode.row, newCol));
        }
        graphicalNode.col = newCol;
        if (newCol == this.nbCols) {
            ++this.nbCols;
        }
    }

    private void remove(GraphicalNode graphicalNode) {
        this.myGraphicalNodes.remove(graphicalNode);
        if (graphicalNode.col == -1) {
            return;
        }
        Iterator gnodes = this.getNodeInColumn(graphicalNode.col).iterator();
        while (gnodes.hasNext()) {
            GraphicalNode gnode = (GraphicalNode)gnodes.next();
            if (gnode.row <= graphicalNode.row) continue;
            gnode.row--;
        }
        if (graphicalNode.col == this.nbCols - 1) {
            List list = this.getNodeInColumn(this.nbCols - 1);
            while (list.size() == 0) {
                --this.nbCols;
                list = this.getNodeInColumn(this.nbCols - 1);
            }
        }
        graphicalNode.row = -1;
        graphicalNode.col = -1;
    }

    private GraphicalNode getGraphicalNodeByID(int id) {
        GraphicalNode res = null;
        Iterator it = this.myGraphicalNodes.iterator();
        while (it.hasNext()) {
            GraphicalNode gn = (GraphicalNode)it.next();
            if (gn.node.getID() != id) continue;
            res = gn;
            break;
        }
        return res;
    }

    private void add(int col, GraphicalNode graphicalNode) {
        this.myGraphicalNodes.remove(graphicalNode);
        if (this.nbCols - 1 < col) {
            this.nbCols = col + 1;
        }
        int row = 0;
        while (this.isOccupied(row, col)) {
            ++row;
        }
        graphicalNode.row = row;
        graphicalNode.col = col;
        this.myGraphicalNodes.add(graphicalNode);
    }

    private List getNodesThatAreInASpecificSuccessorPosition(int col) {
        List graphicaleNodes = this.getNodeInColumn(col);
        if (graphicaleNodes.size() == 0) {
            return null;
        }
        ArrayList res = new ArrayList();
        for (int i = 0; i < graphicaleNodes.size(); ++i) {
            GraphicalNode gn = (GraphicalNode)graphicaleNodes.get(i);
            PertChartAbstraction.TaskGraphNode tgn = gn.node;
            res.addAll(tgn.getSuccessors());
        }
        return res;
    }

    private List getNodeInColumn(int col) {
        ArrayList<GraphicalNode> list = new ArrayList<GraphicalNode>();
        Iterator gnodes = this.myGraphicalNodes.iterator();
        while (gnodes.hasNext()) {
            GraphicalNode gnode = (GraphicalNode)gnodes.next();
            if (gnode.col != col) continue;
            list.add(gnode);
        }
        return list;
    }

    private boolean isOccupied(int row, int col) {
        List list = this.getNodeInColumn(col);
        if (list.size() != 0) {
            Iterator gnodes = list.iterator();
            while (gnodes.hasNext()) {
                GraphicalNode gnode = (GraphicalNode)gnodes.next();
                if (gnode.row != row) continue;
                return true;
            }
        }
        return false;
    }

    private List getAncestor(PertChartAbstraction.TaskGraphNode tgn) {
        ArrayList<PertChartAbstraction.TaskGraphNode> ancestors = new ArrayList<PertChartAbstraction.TaskGraphNode>();
        Iterator tnodes = this.myTaskGraphNodes.iterator();
        while (tnodes.hasNext()) {
            PertChartAbstraction.TaskGraphNode tnode = (PertChartAbstraction.TaskGraphNode)tnodes.next();
            List successor = tnode.getSuccessors();
            if (!successor.contains(tgn)) continue;
            ancestors.add(tnode);
        }
        return ancestors;
    }

    private boolean isCrossingNode(GraphicalNode gnode) {
        PertChartAbstraction.TaskGraphNode tgn = gnode.node;
        List list = this.getAncestor(tgn);
        if (list.size() > 0) {
            Iterator ancestors = list.iterator();
            while (ancestors.hasNext()) {
                PertChartAbstraction.TaskGraphNode ancestor = (PertChartAbstraction.TaskGraphNode)ancestors.next();
                GraphicalNode gancestor = this.getGraphicalNodeByID(ancestor.getID());
                if (gancestor.col >= gnode.col - 1) continue;
                for (int col = gnode.col - 1; col > gancestor.col; --col) {
                    if (!this.isOccupied(gnode.row, col)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void avoidCrossingNode() {
        if (this.nbCols == 0) {
            return;
        }
        int col = this.nbCols - 1;
        while (col > 0) {
            boolean hasmoved = false;
            Iterator gnodes = this.getNodeInColumn(col).iterator();
            while (gnodes.hasNext()) {
                GraphicalNode gnode = (GraphicalNode)gnodes.next();
                while (this.isCrossingNode(gnode)) {
                    this.moveDown(gnode);
                    hasmoved = true;
                }
            }
            if (hasmoved && col < this.nbCols - 1) {
                ++col;
                continue;
            }
            --col;
        }
    }

    private boolean isCrossingArrow(GraphicalNode gnode) {
        int maxUp = 1000000;
        int maxDown = -1;
        Iterator successors = gnode.node.getSuccessors().iterator();
        while (successors.hasNext()) {
            GraphicalNode successor = this.getGraphicalNodeByID(((PertChartAbstraction.TaskGraphNode)successors.next()).getID());
            if (successor.row < maxUp) {
                maxUp = successor.row;
            }
            if (successor.row <= maxDown) continue;
            maxDown = successor.row;
        }
        List othernodes = this.getNodeInColumn(gnode.col);
        othernodes.remove(gnode);
        Iterator nodes = othernodes.iterator();
        while (nodes.hasNext()) {
            GraphicalNode othergnode = (GraphicalNode)nodes.next();
            Iterator othersuccessors = othergnode.node.getSuccessors().iterator();
            while (othersuccessors.hasNext()) {
                PertChartAbstraction.TaskGraphNode othersuccessor = (PertChartAbstraction.TaskGraphNode)othersuccessors.next();
                GraphicalNode othersuccessornode = this.getGraphicalNodeByID(othersuccessor.getID());
                if (maxUp < gnode.row && othersuccessornode.row <= gnode.row && !gnode.node.getSuccessors().contains(othersuccessor)) {
                    return true;
                }
                if (maxDown <= gnode.row || othersuccessornode.row < gnode.row || gnode.node.getSuccessors().contains(othersuccessor)) continue;
                return true;
            }
        }
        return false;
    }

    private void avoidCrossingLine() {
        boolean restart = true;
        block0: while (restart) {
            restart = false;
            for (int col = 0; col < this.nbCols; ++col) {
                List list = this.getNodeInColumn(col);
                if (list.size() <= 1) continue;
                Iterator gnodes = list.iterator();
                while (gnodes.hasNext()) {
                    GraphicalNode gnode = (GraphicalNode)gnodes.next();
                    if (!this.isCrossingArrow(gnode)) continue;
                    this.moveRight(gnode);
                    this.avoidCrossingNode();
                    restart = true;
                    break;
                }
                if (restart) continue block0;
            }
        }
    }

    private void removeEmptyColumn() {
        for (int col = this.nbCols - 1; col >= 0; --col) {
            if (this.getNodeInColumn(col).size() != 0) continue;
            if (col != this.nbCols - 1) {
                for (int c = col + 1; c < this.nbCols; ++c) {
                    Iterator gnodes = this.getNodeInColumn(c).iterator();
                    while (gnodes.hasNext()) {
                        GraphicalNode gnode = (GraphicalNode)gnodes.next();
                        gnode.col--;
                    }
                }
            }
            --this.nbCols;
        }
    }

    public RenderedImage getRenderedImage(GanttExportSettings settings) {
        return this.getChart(settings);
    }

    public BufferedImage getChart(GanttExportSettings settings) {
        BufferedImage image = new BufferedImage(this.myMaxX, this.myMaxY, 1);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, this.myMaxX, this.myMaxY);
        this.paint(g);
        return image;
    }

    public String getName() {
        return ourLanguage.getText("pertChartLongName");
    }

    public void reset() {
        this.myPertAbstraction = null;
    }

    public void paint(Graphics g) {
        int i;
        this.buildPertChart();
        this.myGraphics = g;
        super.paint(g);
        for (i = 0; i < this.myGraphicalNodes.size(); ++i) {
            ((GraphicalNode)this.myGraphicalNodes.get(i)).paint(g);
        }
        for (i = 0; i < this.myGraphicalArrows.size(); ++i) {
            ((GraphicalArrow)this.myGraphicalArrows.get(i)).paintMe(g);
        }
    }

    private void calculateGraphicalNodesCoordinates() {
        this.myMaxX = 0;
        this.myMaxY = 0;
        Iterator gnodes = this.myGraphicalNodes.iterator();
        while (gnodes.hasNext()) {
            GraphicalNode gnode = (GraphicalNode)gnodes.next();
            gnode.x += 140 * gnode.col;
            gnode.y += 85 * gnode.row;
            this.myMaxX = gnode.x > this.myMaxX ? gnode.x : this.myMaxX;
            this.myMaxY = gnode.y > this.myMaxY ? gnode.y : this.myMaxY;
        }
        this.myMaxX += 140;
        this.myMaxY += 85;
    }

    private void calculateArrowsCoordinates() {
        Iterator it = this.myGraphicalNodes.iterator();
        while (it.hasNext()) {
            GraphicalNode gn = (GraphicalNode)it.next();
            Iterator itSuccessors = gn.node.getSuccessors().iterator();
            while (itSuccessors.hasNext()) {
                PertChartAbstraction.TaskGraphNode tgn = (PertChartAbstraction.TaskGraphNode)itSuccessors.next();
                int id = tgn.getID();
                GraphicalArrow arrow = new GraphicalArrow(gn, this.getGraphicalNodeByID(id));
                this.myGraphicalArrows.add(arrow);
            }
        }
    }

    public Icon getIcon() {
        URL iconUrl = this.getClass().getResource("/icons/pert_16.gif");
        return iconUrl == null ? null : new ImageIcon(iconUrl);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(Container.class) || adapter.equals(Chart.class)) {
            return this;
        }
        return null;
    }

    public void addTimeUnitVisitor(TimeUnitVisitor visitor) {
    }

    public TaskLength calculateLength(int posX) {
        return null;
    }

    public IGanttProject getProject() {
        return null;
    }

    public void paintChart(Graphics g) {
    }

    public void resetRenderers() {
    }

    public void scrollLeft() {
    }

    public void scrollRight() {
    }

    public void setBottomUnit(TimeUnit bottomUnit) {
    }

    public void setBottomUnitWidth(int width) {
    }

    public void setDimensions(int height, int width) {
    }

    public void setStartDate(Date startDate) {
    }

    public void setTopUnit(TimeUnit topUnit) {
    }

    private static class GraphicalArrow {
        GraphicalNode from;
        GraphicalNode to;

        GraphicalArrow(GraphicalNode from, GraphicalNode to) {
            this.from = from;
            this.to = to;
        }

        private void paintMe(Graphics g) {
            g.setColor(ARROW_COLOR);
            int arrowFromX = this.from.x + 110;
            int arrowFromY = this.from.y + 35;
            int arrowToX = this.to.x;
            int arrowToY = this.to.y + 35;
            int[] xS = new int[]{arrowToX, arrowToX - 15, arrowToX - 15};
            int[] yS = new int[]{arrowToY, arrowToY - 5, arrowToY + 5};
            int nb = xS.length;
            g.fillPolygon(xS, yS, nb);
            if (arrowFromY != arrowToY) {
                int[] middleLineX = new int[]{arrowFromX + 15 - 6, arrowFromX + 15, arrowFromX + 15, arrowFromX + 15 + 6};
                int[] middleLineY = new int[]{arrowFromY, arrowFromY < arrowToY ? arrowFromY + 6 : arrowFromY - 6, arrowFromY < arrowToY ? arrowToY - 6 : arrowToY + 6, arrowToY};
                int middleLineNb = middleLineX.length;
                g.drawPolyline(middleLineX, middleLineY, middleLineNb);
                g.drawLine(arrowFromX, arrowFromY, middleLineX[0], middleLineY[0]);
                g.drawLine(arrowFromX + 15 + 6, arrowToY, arrowToX - 15, arrowToY);
            } else {
                g.drawLine(arrowFromX, arrowFromY, arrowToX, arrowToY);
            }
        }
    }

    private static class GraphicalNode
    extends JComponent {
        static int xName = 10;
        static int yName = 0;
        private PertChartAbstraction.TaskGraphNode node;
        private int col = -1;
        private int row = -1;
        private static final Color defaultBackgroundColor = new Color(0.9f, 0.9f, 0.9f);
        private static final Color defaultCriticalColor = new Color(250, 250, 115).brighter();
        private Color backgroundColor = null;
        int x = 5;
        int y = 5;

        GraphicalNode(PertChartAbstraction.TaskGraphNode node) {
            this.node = node;
            this.backgroundColor = defaultBackgroundColor;
            if (node.isCritical()) {
                this.backgroundColor = defaultCriticalColor;
            }
        }

        public void updateData(PertChartAbstraction.TaskGraphNode node) {
            this.node = node;
        }

        public void paint(Graphics g) {
            this.backgroundColor = this.node.isCritical() ? defaultCriticalColor : defaultBackgroundColor;
            this.paintMe(g);
        }

        private void paintMe(Graphics g) {
            g.setFont(g.getFont().deriveFont(11.0f).deriveFont(1));
            FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
            int type = this.node.getType();
            Color color = NORMAL_COLOR;
            switch (type) {
                case 0: {
                    color = NORMAL_COLOR;
                    break;
                }
                case 1: {
                    color = SUPER_COLOR;
                    break;
                }
                case 2: {
                    color = MILESTONE_COLOR;
                }
            }
            g.setColor(this.backgroundColor);
            g.fillRoundRect(this.x, this.y, 110, 70, 16, 16);
            g.setColor(color);
            g.drawRoundRect(this.x, this.y, 110, 70, 16, 16);
            g.drawRoundRect(this.x + 1, this.y + 1, 108, 68, 14, 14);
            g.drawLine(this.x, this.y + yName + fontMetrics.getHeight() + 5, this.x + 110, this.y + yName + fontMetrics.getHeight() + 5);
            g.setColor(Color.BLACK);
            String name = this.node.getName();
            int nameWidth = fontMetrics.stringWidth(name);
            g.drawString(GraphicalNode.getTruncatedString(name, 110 - xName, fontMetrics), this.x + xName, this.y + yName + fontMetrics.getHeight());
            g.setFont(g.getFont().deriveFont(0));
            fontMetrics = g.getFontMetrics(g.getFont());
            g.setColor(Color.BLACK);
            g.drawString(ourLanguage.getText("start") + ": " + this.node.getStartDate().toString(), this.x + xName, (int)((double)(this.y + yName) + 2.3 * (double)fontMetrics.getHeight()));
            g.drawString(ourLanguage.getText("end") + ": " + this.node.getEndDate().toString(), this.x + xName, (int)((double)(this.y + yName) + 3.3 * (double)fontMetrics.getHeight()));
            if (this.node.getDuration() != null) {
                g.drawString(ourLanguage.getText("duration") + ": " + this.node.getDuration().getLength(), this.x + xName, (int)((double)(this.y + yName) + 4.3 * (double)fontMetrics.getHeight()));
            }
        }

        private static String getTruncatedString(String str, int width, FontMetrics fontMetrics) {
            String res = str;
            int strWidth = fontMetrics.stringWidth(str);
            int maxwidth = 0;
            if (strWidth > width) {
                char c;
                int cWidth;
                int i;
                for (i = 0; i < str.length() && (maxwidth += (cWidth = fontMetrics.charWidth(c = str.charAt(i)))) <= width; ++i) {
                }
                res = str.substring(0, i - 2);
                res = res + "...";
            }
            return res;
        }

        public boolean equals(Object o) {
            if (o instanceof GraphicalNode) {
                return this.node.equals(((GraphicalNode)o).node);
            }
            return false;
        }

        public String toString() {
            return "[" + this.node.getName() + " (" + this.col + ") " + this.node.getSuccessors() + "]";
        }
    }
}

