/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.form;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swing.JXTable;
import org.jdesktop.swing.data.DataModel;

public class RowSelector {
    private DataModel dataModel;
    private JComponent component;

    public RowSelector(JTable table, DataModel dataModel) {
        this(table.getSelectionModel(), dataModel);
        this.component = table;
    }

    public RowSelector(JList list, DataModel dataModel) {
        this(list.getSelectionModel(), dataModel);
        this.component = list;
    }

    public RowSelector(ListSelectionModel selectModel, DataModel dataModel) {
        this.dataModel = dataModel;
        if (dataModel.getRecordCount() > 0) {
            selectModel.setLeadSelectionIndex(0);
            selectModel.setAnchorSelectionIndex(0);
            dataModel.setRecordIndex(0);
        }
        selectModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int selectionIndex = selectionModel.getLeadSelectionIndex();
                if (RowSelector.this.component != null && selectionModel.isSelectedIndex(selectionIndex)) {
                    if (RowSelector.this.component instanceof JXTable) {
                        selectionIndex = ((JXTable)RowSelector.this.component).convertRowIndexToModel(selectionIndex);
                    }
                    RowSelector.this.dataModel.setRecordIndex(selectionIndex);
                }
            }
        });
    }
}

