/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.form;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swing.JXGlassBox;
import org.jdesktop.swing.binding.Binding;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.NumberMetaData;

public class BindingBorder
implements Border {
    private static final int PAD = 0;
    private static Icon defaultValidIcon;
    private static Icon defaultInvalidIcon;
    private static Icon defaultRequiredIcon;
    private Binding binding;
    private Icon validIcon;
    private Icon invalidIcon;
    private Icon requiredIcon;
    private int iconPosition;
    private FocusListener focusListener;
    private Rectangle validIconBounds = new Rectangle();
    private Timer messageTriggerTimer;
    private int messageTriggerX;
    private int messageTriggerY;
    private JXGlassBox messageBox;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.form.BindingBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL url = clazz.getResource("resources/blue-tipicon.png");
        defaultValidIcon = new ImageIcon(url);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jdesktop.swing.form.BindingBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        url = clazz2.getResource("resources/red-tipicon.png");
        defaultInvalidIcon = new ImageIcon(url);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.jdesktop.swing.form.BindingBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        url = clazz3.getResource("resources/asterisk.8x8.png");
        defaultRequiredIcon = new ImageIcon(url);
    }

    public BindingBorder(Binding binding) {
        this(binding, 3);
    }

    public BindingBorder(Binding binding, int iconPosition) {
        this(binding, defaultValidIcon, defaultInvalidIcon, iconPosition);
    }

    public BindingBorder(Binding binding, Icon validIcon, Icon invalidIcon, int iconPosition) {
        this(binding, validIcon, invalidIcon, null, iconPosition);
    }

    public BindingBorder(Binding binding, Icon validIcon, Icon invalidIcon, Icon requiredIcon, int iconPosition) {
        this.binding = binding;
        this.validIcon = validIcon;
        this.invalidIcon = invalidIcon;
        this.iconPosition = iconPosition;
        JComponent component = binding.getComponent();
        MetaData metaData = binding.getDataModel().getMetaData(binding.getFieldName());
        if (metaData.isRequired()) {
            this.requiredIcon = requiredIcon;
        }
        binding.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Binding binding = (Binding)e.getSource();
                if (e.getPropertyName().equals("validState")) {
                    binding.getComponent().repaint();
                }
            }
        });
        this.addFocusListener(component);
        this.messageTriggerTimer = new Timer(1000, new MessageTrigger());
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (!BindingBorder.this.isMessageBoxShowing() && BindingBorder.this.validIconBounds.contains(x, y)) {
                    if (BindingBorder.this.messageTriggerTimer.isRunning()) {
                        BindingBorder.this.messageTriggerTimer.stop();
                    }
                    BindingBorder.this.showMessageBox(x, y);
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (!BindingBorder.this.isMessageBoxShowing()) {
                    int x = e.getX();
                    int y = e.getY();
                    if (!BindingBorder.this.messageTriggerTimer.isRunning()) {
                        if (BindingBorder.this.validIconBounds.contains(x, y)) {
                            BindingBorder.this.messageTriggerX = x;
                            BindingBorder.this.messageTriggerY = y;
                            BindingBorder.this.messageTriggerTimer.start();
                        }
                    } else if (!BindingBorder.this.validIconBounds.contains(x, y)) {
                        BindingBorder.this.messageTriggerTimer.stop();
                    }
                }
            }

            public void mouseExited(MouseEvent e) {
                if (BindingBorder.this.messageTriggerTimer.isRunning()) {
                    BindingBorder.this.messageTriggerTimer.stop();
                }
            }
        };
        component.addMouseMotionListener(mouseAdapter);
        component.addMouseListener(mouseAdapter);
    }

    public Insets getBorderInsets(Component c) {
        if (this.requiredIcon != null) {
            return new Insets(0, 0, 0, this.validIcon.getIconWidth() + this.requiredIcon.getIconWidth() + 0);
        }
        return new Insets(0, 0, 0, this.validIcon.getIconWidth() + 0);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int requiredIconSpace;
        boolean paintValid;
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = null;
        boolean bl = paintValid = this.binding.getValidState() != 2;
        if (!this.hasFocus(c)) {
            oldComp = g2d.getComposite();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.35f);
            g2d.setComposite(alphaComp);
        }
        Icon validIcon = paintValid ? this.validIcon : this.invalidIcon;
        int n = requiredIconSpace = this.requiredIcon != null ? this.requiredIcon.getIconWidth() + 0 : 0;
        if (!this.isMessageBoxShowing()) {
            this.validIconBounds.x = x + width - 0 - requiredIconSpace - validIcon.getIconWidth();
            this.validIconBounds.y = this.iconPosition == 2 ? y + 0 : y + (height - validIcon.getIconHeight()) / 2;
            this.validIconBounds.width = validIcon.getIconWidth();
            this.validIconBounds.height = validIcon.getIconHeight();
            validIcon.paintIcon(c, g, this.validIconBounds.x, this.validIconBounds.y);
        }
        if (this.requiredIcon != null) {
            int requiredX = x + width - 0 - this.requiredIcon.getIconWidth();
            int requiredY = y + (height - this.requiredIcon.getIconHeight()) / 2;
            this.requiredIcon.paintIcon(c, g, requiredX, requiredY);
        }
        if (!paintValid) {
            Color save = g.getColor();
            Color invalidColor = new Color(255, 0, 0, 225);
            g.setColor(invalidColor);
            g.drawRect(0, 0, c.getWidth(), c.getHeight());
            g.drawRect(1, 1, c.getWidth() - 2, c.getHeight() - 2);
            g.setColor(save);
        }
        if (oldComp != null) {
            g2d.setComposite(oldComp);
        }
    }

    private void addFocusListener(Component component) {
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    BindingBorder.this.binding.getComponent().repaint();
                }

                public void focusLost(FocusEvent e) {
                    BindingBorder.this.binding.getComponent().repaint();
                }
            };
        }
        component.addFocusListener(this.focusListener);
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            int i = 0;
            while (i < children.length) {
                this.addFocusListener(children[i]);
                ++i;
            }
        }
    }

    private boolean hasFocus(Component component) {
        if (component.isFocusOwner()) {
            return true;
        }
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            int i = 0;
            while (i < children.length) {
                if (this.hasFocus(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isMessageBoxShowing() {
        return this.messageBox != null && this.messageBox.getParent() != null;
    }

    private void showMessageBox(int x, int y) {
        JComponent component = this.binding.getComponent();
        boolean valid = this.binding.getValidState() != 2;
        Color borderColor = valid ? Color.blue : Color.red;
        Icon messageIcon = valid ? this.validIcon : this.invalidIcon;
        MetaData metaData = this.binding.getDataModel().getMetaData(this.binding.getFieldName());
        this.messageBox = new JXGlassBox();
        this.messageBox.setAlpha(0.95f);
        this.messageBox.setBorder(new LineBorder(borderColor, 1));
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.messageBox.setLayout(gridBag);
        JLabel label = new JLabel(String.valueOf(metaData.getLabel()) + ":");
        Font boldFont = label.getFont().deriveFont(1);
        label.setFont(boldFont);
        c.anchor = 18;
        c.insets = new Insets(2, 4, 0, 2);
        gridBag.setConstraints(label, c);
        this.messageBox.add(label);
        Box textContent = new Box(0);
        c.gridx = 1;
        c.anchor = 11;
        c.insets = new Insets(2, 2, 2, 2);
        gridBag.setConstraints(textContent, c);
        this.messageBox.add(textContent);
        JLabel iconLabel = new JLabel(messageIcon);
        c.gridx = 2;
        c.anchor = 12;
        c.insets = new Insets(1, 0, 0, 1);
        gridBag.setConstraints(iconLabel, c);
        this.messageBox.add(iconLabel);
        textContent.add(Box.createHorizontalStrut(4));
        Box content = new Box(1);
        textContent.add(content);
        if (!valid) {
            String[] errors = this.binding.getValidationErrors();
            if (errors.length > 0) {
                int i = 0;
                while (i < errors.length) {
                    content.add(new JLabel(errors[i]));
                    ++i;
                }
            } else {
                content.add(new JLabel("contains invalid value"));
            }
        } else {
            content.add(new JLabel("value must be of type " + metaData.getElementClass().getName()));
            content.add(new JLabel("value is " + (metaData.isRequired() ? "required" : "optional")));
            if (metaData instanceof NumberMetaData) {
                Number maximum;
                NumberMetaData numberMetaData = (NumberMetaData)metaData;
                Number minimum = numberMetaData.getMinimum();
                if (minimum != null) {
                    content.add(new JLabel("minimum value is " + minimum.toString()));
                }
                if ((maximum = numberMetaData.getMaximum()) != null) {
                    content.add(new JLabel("maximum value is " + maximum.toString()));
                }
            }
        }
        Container glassPane = (Container)component.getRootPane().getGlassPane();
        Component[] glassPaneChildren = glassPane.getComponents();
        int i = 0;
        while (i < glassPaneChildren.length) {
            glassPaneChildren[i].setVisible(false);
            glassPane.remove(glassPaneChildren[i]);
            ++i;
        }
        this.messageBox.showOnGlassPane(glassPane, component, x, y, 1);
    }

    private class MessageTrigger
    implements ActionListener {
        private MessageTrigger() {
        }

        public void actionPerformed(ActionEvent e) {
            BindingBorder.this.messageTriggerTimer.stop();
            BindingBorder.this.showMessageBox(BindingBorder.this.messageTriggerX, BindingBorder.this.messageTriggerY);
        }
    }
}

