/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.event;

import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.jdesktop.swing.event.MessageEvent;
import org.jdesktop.swing.event.MessageListener;
import org.jdesktop.swing.event.MessageSource;
import org.jdesktop.swing.event.ProgressEvent;
import org.jdesktop.swing.event.ProgressListener;
import org.jdesktop.swing.event.ProgressSource;

public class MessageSourceSupport
implements MessageSource,
ProgressSource {
    private EventListenerList listeners;
    private Object source;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MessageSourceSupport(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source Object cannot be null");
        }
        this.source = source;
        this.listeners = new EventListenerList();
    }

    public void addMessageListener(MessageListener l) {
        if (l != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jdesktop.swing.event.MessageListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listeners.add(clazz, l);
        }
    }

    public void removeMessageListener(MessageListener l) {
        if (l != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jdesktop.swing.event.MessageListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listeners.remove(clazz, l);
        }
    }

    public MessageListener[] getMessageListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.event.MessageListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MessageListener[])this.listeners.getListeners(clazz);
    }

    public void addProgressListener(ProgressListener l) {
        if (l != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.jdesktop.swing.event.ProgressListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listeners.add(clazz, l);
        }
    }

    public void removeProgressListener(ProgressListener l) {
        if (l != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.jdesktop.swing.event.ProgressListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listeners.remove(clazz, l);
        }
    }

    public ProgressListener[] getProgressListeners() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jdesktop.swing.event.ProgressListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ProgressListener[])this.listeners.getListeners(clazz);
    }

    public void fireProgressStarted(int minimum, int maximum) {
        this.fireProgressStarted(new ProgressEvent(this.source, minimum, maximum));
    }

    public void fireProgressIncremented(int progress) {
        this.fireProgressIncremented(new ProgressEvent(this.source, progress));
    }

    public void fireProgressEnded() {
        this.fireProgressEnded(new ProgressEvent(this.source));
    }

    public void fireException(Throwable t) {
        this.fireMessage(new MessageEvent(this.source, t, Level.SEVERE));
    }

    public void fireMessage(String message) {
        this.fireMessage(message, Level.INFO);
    }

    public void fireMessage(Object value, Level level) {
        this.fireMessage(value, level, 0L);
    }

    public void fireMessage(Object value, Level level, long when) {
        this.fireMessage(new MessageEvent(this.source, value, level, when));
    }

    public void fireMessage(MessageEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        MessageListener[] ls = this.getMessageListeners();
        int i = 0;
        while (i < ls.length) {
            ls[i].message(evt);
            ++i;
        }
    }

    public void fireProgressIncremented(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        int i = 0;
        while (i < ls.length) {
            ls[i].progressIncremented(evt);
            ++i;
        }
    }

    public void fireProgressStarted(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        int i = 0;
        while (i < ls.length) {
            ls[i].progressStarted(evt);
            ++i;
        }
    }

    public void fireProgressEnded(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        int i = 0;
        while (i < ls.length) {
            ls[i].progressEnded(evt);
            ++i;
        }
    }
}

