/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.Filter;
import org.jdesktop.swing.decorator.PipelineEvent;
import org.jdesktop.swing.decorator.PipelineListener;
import org.jdesktop.swing.decorator.Sorter;

public class FilterPipeline {
    protected EventListenerList listenerList = new EventListenerList();
    private ComponentAdapter adapter = null;
    private Sorter sorter = null;
    private final Filter[] filters;
    static /* synthetic */ Class class$0;

    public FilterPipeline(Filter[] inList) {
        this.filters = this.reorderSorters(inList, this.locateSorters(inList));
        int i = 0;
        while (i < this.filters.length) {
            if (this.filters[i].order >= 0) {
                throw new IllegalArgumentException("Element " + i + " is part of another pipeline.");
            }
            this.filters[i].order = i;
            ++i;
        }
    }

    void setSorter(Sorter sorter) {
        this.sorter = sorter;
    }

    public final void assign(ComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = adapter;
            int i = 0;
            while (i < this.filters.length) {
                this.filters[i].assign(this);
                this.filters[i].assign(adapter);
                ++i;
            }
        } else if (this.adapter != adapter) {
            throw new IllegalStateException("Can't bind to a different adapter");
        }
    }

    boolean contains(Filter filter) {
        return filter.order >= 0 && this.filters.length > 0 && this.filters[filter.order] == filter;
    }

    Filter first() {
        return this.filters.length > 0 ? this.filters[0] : null;
    }

    Filter last() {
        return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
    }

    Filter next(Filter filter) {
        return this.last().equals(filter) ? null : this.filters[filter.order + 1];
    }

    Filter previous(Filter filter) {
        return this.first().equals(filter) ? null : this.filters[filter.order - 1];
    }

    protected void filterChanged(Filter filter) {
        Filter next;
        Filter filter2 = next = this.contains(filter) ? this.next(filter) : null;
        if (next == null) {
            if (this.sorter == null) {
                this.fireContentsChanged();
            } else {
                this.sorter.refresh();
            }
        } else {
            next.refresh();
        }
    }

    int getInputSize(Filter filter) {
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                return this.adapter.getRowCount();
            }
            return previous.getSize();
        }
        if (filter.getPipeline() == this) {
            return this.getOutputSize();
        }
        return 0;
    }

    public int getOutputSize() {
        Filter last = this.last();
        return last == null ? this.adapter.getRowCount() : last.getSize();
    }

    public int convertRowIndexToModel(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToModel(row);
    }

    int convertRowIndexToModel(Filter filter, int row) {
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                return row;
            }
            return previous.convertRowIndexToModel(row);
        }
        Filter last = this.last();
        if (last == null) {
            return row;
        }
        return last.convertRowIndexToModel(row);
    }

    public int convertRowIndexToView(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToView(row);
    }

    int convertRowIndexToView(Filter filter, int row) {
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                return row;
            }
            return previous.convertRowIndexToView(row);
        }
        Filter last = this.last();
        if (last == null) {
            return row;
        }
        return last.convertRowIndexToView(row);
    }

    public Object getValueAt(int row, int column) {
        Filter last = this.last();
        return last == null ? null : last.getValueAt(row, column);
    }

    Object getInputValueFor(Filter filter, int row, int column) {
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                return this.adapter.getValueAt(row, this.adapter.modelToView(column));
            }
            return previous.getValueAt(row, column);
        }
        Filter last = this.last();
        if (last == null) {
            return this.adapter.getValueAt(row, this.adapter.modelToView(column));
        }
        return last.getValueAt(row, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Filter last = this.last();
        if (last != null) {
            last.setValueAt(aValue, row, column);
        }
    }

    void setInputValueFor(Object aValue, Filter filter, int row, int column) {
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                this.adapter.setValueAt(aValue, row, this.adapter.modelToView(column));
            } else {
                previous.setValueAt(aValue, row, column);
            }
        } else {
            Filter last = this.last();
            if (last == null) {
                this.adapter.setValueAt(aValue, row, this.adapter.modelToView(column));
            } else {
                last.setValueAt(aValue, row, column);
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        Filter last = this.last();
        return last == null ? false : last.isCellEditable(row, column);
    }

    boolean isInputEditableFor(Filter filter, int row, int column) {
        int inputRow = filter.translateToPreviousFilter(row);
        if (this.contains(filter)) {
            Filter previous = this.previous(filter);
            if (previous == null) {
                return this.adapter.isCellEditable(inputRow, this.adapter.modelToView(column));
            }
            return previous.isCellEditable(inputRow, column);
        }
        Filter last = this.last();
        if (last == null) {
            return this.adapter.isCellEditable(inputRow, this.adapter.modelToView(column));
        }
        return last.isCellEditable(inputRow, column);
    }

    public void flush() {
        if (this.filters != null && this.filters.length > 0) {
            this.filters[0].refresh();
        } else if (this.sorter != null) {
            this.sorter.refresh();
        }
    }

    public void addPipelineListener(PipelineListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removePipelineListener(PipelineListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public PipelineListener[] getPipelineListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PipelineListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireContentsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        PipelineEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new PipelineEvent(this, 0);
                }
                ((PipelineListener)listeners[i + 1]).contentsChanged(e);
            }
            i -= 2;
        }
    }

    private List locateSorters(Filter[] inList) {
        BitSet sortableColumns = new BitSet();
        Vector<Integer> sorterLocations = new Vector<Integer>();
        int i = 0;
        while (i < inList.length) {
            if (inList[i] instanceof Sorter) {
                int columnIndex = inList[i].getColumnIndex();
                if (columnIndex < 0) {
                    throw new IndexOutOfBoundsException("Negative column index for filter: " + inList[i]);
                }
                if (sortableColumns.get(columnIndex)) {
                    throw new IllegalArgumentException("Filter " + i + " attempting to overwrite sorter for column " + columnIndex);
                }
                sortableColumns.set(columnIndex);
                sorterLocations.add(new Integer(i));
            }
            ++i;
        }
        return sorterLocations;
    }

    private Filter[] reorderSorters(Filter[] inList, List sorterLocations) {
        Filter[] outList = (Filter[])inList.clone();
        int max = sorterLocations.size() - 1;
        int i = 0;
        while (i <= max) {
            int orig = (Integer)sorterLocations.get(max - i);
            int copy = (Integer)sorterLocations.get(i);
            outList[copy] = inList[orig];
            ++i;
        }
        return outList;
    }
}

