/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdesktop.swing.data.AbstractDataModel;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.TabularDataModel;

public class TabularDataModelAdapter
extends AbstractDataModel {
    private TabularDataModel model;
    private int rowIndex = -1;
    private boolean updatingModel = false;

    public TabularDataModelAdapter(TabularDataModel model) {
        this.model = model;
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (TabularDataModelAdapter.this.updatingModel) {
                    return;
                }
                if (e.getType() == 0 && TabularDataModelAdapter.this.rowIndex >= e.getFirstRow() && TabularDataModelAdapter.this.rowIndex <= e.getLastRow()) {
                    int columnIndex = e.getColumn();
                    TabularDataModel model = TabularDataModelAdapter.this.model;
                    this.fireColumnsChanged(model, columnIndex, columnIndex);
                }
            }

            private void fireColumnsChanged(TabularDataModel model, int firstColumn, int lastColumn) {
                if (firstColumn < 0) {
                    firstColumn = 0;
                    lastColumn = model.getColumnCount() - 1;
                }
                int col = firstColumn;
                while (col <= lastColumn) {
                    TabularDataModelAdapter.this.fireValueChanged(model.getColumnMetaData(col).getName());
                    ++col;
                }
            }
        });
    }

    public String[] getFieldNames() {
        int columnCount = this.model.getColumnCount();
        String[] columnNames = new String[columnCount];
        MetaData[] metaData = this.model.getMetaData();
        int i = 0;
        while (i < columnCount) {
            columnNames[i] = metaData[i].getName();
            ++i;
        }
        return columnNames;
    }

    public MetaData getMetaData(String fieldName) {
        return this.model.getColumnMetaData(this.model.getColumnIndex(fieldName));
    }

    public int getFieldCount() {
        return this.model.getColumnCount();
    }

    public Object getValue(String fieldName) {
        return this.getRecordIndex() >= 0 ? this.model.getValueAt(this.getRecordIndex(), this.model.getColumnIndex(fieldName)) : null;
    }

    protected void setValueImpl(String fieldName, Object value) {
        if (this.getRecordIndex() < 0) {
            return;
        }
        this.updatingModel = true;
        this.model.setValueAt(value, this.getRecordIndex(), this.model.getColumnIndex(fieldName));
        this.updatingModel = false;
    }

    public void setRecordIndex(int rowIndex) {
        if (rowIndex >= this.model.getRowCount()) {
            throw new IndexOutOfBoundsException("row index " + rowIndex + "exceeds row count " + this.model.getRowCount());
        }
        if (this.rowIndex != rowIndex) {
            this.rowIndex = rowIndex;
            String[] fieldNames = this.getFieldNames();
            int i = 0;
            while (i < fieldNames.length) {
                this.fireValueChanged(fieldNames[i]);
                ++i;
            }
        }
    }

    public int getRecordIndex() {
        return this.rowIndex;
    }

    public int getRecordCount() {
        return this.model.getRowCount();
    }
}

