/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class JXDatePickerFormatterFactory
extends JFormattedTextField.AbstractFormatterFactory {
    protected JFormattedTextField.AbstractFormatter formatter = null;

    public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField ftf) {
        if (this.formatter == null) {
            this.formatter = new JXDatePickerFormatter();
        }
        return this.formatter;
    }

    private class JXDatePickerFormatter
    extends JFormattedTextField.AbstractFormatter {
        private SimpleDateFormat[] _formats = new SimpleDateFormat[3];
        private int _formatIndex = 0;

        public JXDatePickerFormatter() {
            String format = UIManager.getString("JXDatePicker.longFormat");
            if (format == null) {
                format = "EEE MM/dd/yyyy";
            }
            this._formats[0] = new SimpleDateFormat(format);
            format = UIManager.getString("JXDatePicker.mediumFormat");
            if (format == null) {
                format = "MM/dd/yyyy";
            }
            this._formats[1] = new SimpleDateFormat(format);
            format = UIManager.getString("JXDatePicker.shortFormat");
            if (format == null) {
                format = "MM/dd";
            }
            this._formats[2] = new SimpleDateFormat(format);
        }

        public Object stringToValue(String text) throws ParseException {
            Date result = null;
            ParseException pex = null;
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            if (result == null) {
                int i = 0;
                while (i < this._formats.length) {
                    try {
                        result = this._formats[i].parse(text);
                        this._formatIndex = i;
                        pex = null;
                        break;
                    }
                    catch (ParseException ex) {
                        pex = ex;
                        ++i;
                    }
                }
            }
            if (pex != null) {
                throw pex;
            }
            return result;
        }

        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                return this._formats[this._formatIndex].format(value);
            }
            return null;
        }
    }
}

