/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import org.jdesktop.swing.Application;
import org.jdesktop.swing.actions.Targetable;

public class TargetManager {
    private static TargetManager INSTANCE;
    private List targetList;
    private Targetable target;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public static TargetManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetManager();
        }
        return INSTANCE;
    }

    public void addTarget(Targetable target, boolean prepend) {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        if (prepend) {
            this.targetList.add(0, target);
        } else {
            this.targetList.add(target);
        }
    }

    public void addTarget(Targetable target) {
        this.addTarget(target, false);
    }

    public void removeTarget(Targetable target) {
        if (this.targetList != null) {
            this.targetList.remove(target);
        }
    }

    public Targetable[] getTargets() {
        Targetable[] targets;
        if (this.targetList == null) {
            targets = new Targetable[]{};
        } else {
            targets = new Targetable[this.targetList.size()];
            targets = this.targetList.toArray(new Targetable[this.targetList.size()]);
        }
        return targets;
    }

    public void setTarget(Targetable newTarget) {
        Targetable oldTarget = this.target;
        if (oldTarget != newTarget) {
            this.target = newTarget;
            this.propertySupport.firePropertyChange("target", oldTarget, newTarget);
        }
    }

    public Targetable getTarget() {
        return this.target;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean doCommand(Object command, Object value) {
        ActionMap map;
        Action action;
        if (this.target != null && this.target.hasCommand(command) && this.target.doCommand(command, value)) {
            return true;
        }
        if (this.targetList != null) {
            Iterator iter = this.targetList.iterator();
            while (iter.hasNext()) {
                Targetable target = (Targetable)iter.next();
                if (!target.hasCommand(command) || !target.doCommand(command, value)) continue;
                return true;
            }
        }
        ActionEvent evt = null;
        if (value instanceof ActionEvent) {
            evt = (ActionEvent)value;
        }
        Component comp = FocusManager.getCurrentManager().getPermanentFocusOwner();
        while (comp != null) {
            ActionMap map2;
            Action action2;
            if (comp instanceof JComponent && (action2 = (map2 = ((JComponent)comp).getActionMap()).get(command)) != null) {
                if (evt == null) {
                    evt = new ActionEvent(comp, 0, command.toString());
                }
                action2.actionPerformed(evt);
                return true;
            }
            comp = comp.getParent();
        }
        Application app = Application.getInstance();
        if (app != null && (action = (map = app.getActionMap()).get(command)) != null) {
            if (evt == null) {
                evt = new ActionEvent(comp, 0, command.toString());
            }
            action.actionPerformed(evt);
            return true;
        }
        return false;
    }

    void reset() {
        if (this.targetList != null) {
            this.targetList.clear();
            this.targetList = null;
        }
        this.target = null;
        PropertyChangeListener[] listeners = this.propertySupport.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            this.propertySupport.removePropertyChangeListener(listeners[i]);
            ++i;
        }
        INSTANCE = null;
    }
}

