/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class TablePrintable
implements Printable {
    private JTable table;
    private JTableHeader header;
    private TableColumnModel colModel;
    private int totalColWidth;
    private int printMode;
    private MessageFormat headerFormat;
    private MessageFormat footerFormat;
    private int last = -1;
    private int row = 0;
    private int col = 0;
    private final Rectangle clip = new Rectangle(0, 0, 0, 0);
    private final Rectangle hclip = new Rectangle(0, 0, 0, 0);
    private final Rectangle tempRect = new Rectangle(0, 0, 0, 0);
    private static final int H_F_SPACE = 8;
    private static final float HEADER_FONT_SIZE = 18.0f;
    private static final float FOOTER_FONT_SIZE = 12.0f;
    private Font headerFont;
    private Font footerFont;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.TablePrintable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TablePrintable(JTable table, int printMode, MessageFormat headerFormat, MessageFormat footerFormat) {
        this.table = table;
        this.header = table.getTableHeader();
        this.colModel = table.getColumnModel();
        this.totalColWidth = this.colModel.getTotalColumnWidth();
        if (this.header != null) {
            this.hclip.height = this.header.getHeight();
        }
        if (printMode != 0 && printMode != 1) {
            throw new IllegalArgumentException("Unknown Print Mode: " + printMode);
        }
        this.printMode = printMode;
        this.headerFormat = headerFormat;
        this.footerFormat = footerFormat;
        this.headerFont = table.getFont().deriveFont(1, 18.0f);
        this.footerFont = table.getFont().deriveFont(0, 12.0f);
    }

    /*
     * Unable to fully structure code
     */
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        imgWidth = (int)pageFormat.getImageableWidth();
        imgHeight = (int)pageFormat.getImageableHeight();
        if (imgWidth <= 0) {
            throw new PrinterException("Width of printable area is too small.");
        }
        pageNumber = new Object[]{new Integer(pageIndex + 1)};
        headerText = null;
        if (this.headerFormat != null) {
            headerText = this.headerFormat.format(pageNumber);
        }
        footerText = null;
        if (this.footerFormat != null) {
            footerText = this.footerFormat.format(pageNumber);
        }
        hRect = null;
        fRect = null;
        headerTextSpace = 0;
        footerTextSpace = 0;
        availableSpace = imgHeight;
        if (headerText != null) {
            graphics.setFont(this.headerFont);
            hRect = graphics.getFontMetrics().getStringBounds(headerText, graphics);
            headerTextSpace = (int)Math.ceil(hRect.getHeight());
            availableSpace -= headerTextSpace + 8;
        }
        if (footerText != null) {
            graphics.setFont(this.footerFont);
            fRect = graphics.getFontMetrics().getStringBounds(footerText, graphics);
            footerTextSpace = (int)Math.ceil(fRect.getHeight());
            availableSpace -= footerTextSpace + 8;
        }
        if (availableSpace <= 0) {
            throw new PrinterException("Height of printable area is too small.");
        }
        sf = 1.0;
        if (this.printMode == 1 && this.totalColWidth > imgWidth) {
            if (!TablePrintable.$assertionsDisabled && imgWidth <= 0) {
                throw new AssertionError();
            }
            if (!TablePrintable.$assertionsDisabled && this.totalColWidth <= 1) {
                throw new AssertionError();
            }
            sf = (double)imgWidth / (double)this.totalColWidth;
        }
        if (TablePrintable.$assertionsDisabled || sf > 0.0) ** GOTO lbl44
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (this.row >= this.table.getRowCount() && this.col == 0) {
                return 1;
            }
            scaledWidth = (int)((double)imgWidth / sf);
            scaledHeight = (int)((double)(availableSpace - this.hclip.height) / sf);
            this.findNextClip(scaledWidth, scaledHeight);
            ++this.last;
lbl44:
            // 2 sources

            ** while (this.last < pageIndex)
        }
lbl45:
        // 1 sources

        g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (footerText != null) {
            oldTrans = g2d.getTransform();
            g2d.translate(0, imgHeight - footerTextSpace);
            this.printText(g2d, footerText, fRect, this.footerFont, imgWidth);
            g2d.setTransform(oldTrans);
        }
        if (headerText != null) {
            this.printText(g2d, headerText, hRect, this.headerFont, imgWidth);
            g2d.translate(0, headerTextSpace + 8);
        }
        this.tempRect.x = 0;
        this.tempRect.y = 0;
        this.tempRect.width = imgWidth;
        this.tempRect.height = availableSpace;
        g2d.clip(this.tempRect);
        if (sf != 1.0) {
            g2d.scale(sf, sf);
        } else {
            diff = (imgWidth - this.clip.width) / 2;
            g2d.translate(diff, 0);
        }
        oldTrans = g2d.getTransform();
        oldClip = g2d.getClip();
        if (this.header != null) {
            this.hclip.x = this.clip.x;
            this.hclip.width = this.clip.width;
            g2d.translate(-this.hclip.x, 0);
            g2d.clip(this.hclip);
            this.header.print(g2d);
            g2d.setTransform(oldTrans);
            g2d.setClip(oldClip);
            g2d.translate(0, this.hclip.height);
        }
        g2d.translate(-this.clip.x, -this.clip.y);
        g2d.clip(this.clip);
        this.table.print(g2d);
        g2d.setTransform(oldTrans);
        g2d.setClip(oldClip);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, this.clip.width, this.hclip.height + this.clip.height);
        return 0;
    }

    private void printText(Graphics2D g2d, String text, Rectangle2D rect, Font font, int imgWidth) {
        int tx = rect.getWidth() < (double)imgWidth ? (int)(((double)imgWidth - rect.getWidth()) / 2.0) : (this.table.getComponentOrientation().isLeftToRight() ? 0 : -((int)(Math.ceil(rect.getWidth()) - (double)imgWidth)));
        int ty = (int)Math.ceil(Math.abs(rect.getY()));
        g2d.setColor(Color.BLACK);
        g2d.setFont(font);
        g2d.drawString(text, tx, ty);
    }

    private void findNextClip(int pw, int ph) {
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        if (this.col == 0) {
            this.clip.x = ltr ? 0 : this.totalColWidth;
            this.clip.y += this.clip.height;
            this.clip.width = 0;
            this.clip.height = 0;
            int rowCount = this.table.getRowCount();
            int rowHeight = this.table.getRowHeight(this.row);
            do {
                this.clip.height += rowHeight;
            } while (++this.row < rowCount && this.clip.height + (rowHeight = this.table.getRowHeight(this.row)) <= ph);
        }
        if (this.printMode == 1) {
            this.clip.x = 0;
            this.clip.width = this.totalColWidth;
            return;
        }
        if (ltr) {
            this.clip.x += this.clip.width;
        }
        this.clip.width = 0;
        int colCount = this.table.getColumnCount();
        int colWidth = this.colModel.getColumn(this.col).getWidth();
        do {
            this.clip.width += colWidth;
            if (!ltr) {
                this.clip.x -= colWidth;
            }
            if (++this.col < colCount) continue;
            this.col = 0;
            break;
        } while (this.clip.width + (colWidth = this.colModel.getColumn(this.col).getWidth()) <= pw);
    }
}

