/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swing.UIAction;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.FilterPipeline;
import org.jdesktop.swing.decorator.HighlighterPipeline;

public class JXTree
extends JTree {
    private Method conversionMethod = null;
    private static final Class[] methodSignature;
    private static final Object[] methodArgs;
    protected FilterPipeline filters = null;
    protected HighlighterPipeline highlighters = null;
    private final ComponentAdapter dataAdapter = new TreeAdapter(this);
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        methodSignature = classArray;
        methodArgs = new Object[1];
    }

    public JXTree() {
        this.initActions();
    }

    public JXTree(Object[] value) {
        super(value);
        this.initActions();
    }

    public JXTree(Vector value) {
        super(value);
        this.initActions();
    }

    public JXTree(Hashtable value) {
        super(value);
        this.initActions();
    }

    public JXTree(TreeNode root) {
        super(root, false);
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.initActions();
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.initActions();
        this.conversionMethod = this.getValueConversionMethod(newModel);
    }

    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.conversionMethod = this.getValueConversionMethod(newModel);
    }

    private Method getValueConversionMethod(TreeModel model) {
        try {
            return model.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (this.conversionMethod == null) {
                return value.toString();
            }
            try {
                JXTree.methodArgs[0] = value;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    public void collapseAll() {
        int i = this.getRowCount() - 1;
        while (i >= 0) {
            this.collapseRow(i);
            --i;
        }
    }

    public void expandAll() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    public void setFilters(FilterPipeline pipeline) {
        this.filters = pipeline;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        this.highlighters = pipeline;
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }

    static class TreeAdapter
    extends ComponentAdapter {
        private final JTree tree;
        private TreePath path;

        public TreeAdapter(JTree component) {
            super(component);
            this.tree = component;
        }

        public JTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int row, int column) {
            return this.path.getLastPathComponent();
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.path.getLastPathComponent();
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }
    }
}

