/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JXGlassBox
extends JPanel {
    private static final int SHOW_DELAY = 30;
    private static final int TIMER_INCREMENT = 5;
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float animateAlpha = this.alphaStart;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;
    private transient Insets insets = new Insets(0, 0, 0, 0);

    public JXGlassBox() {
        this.setOpaque(false);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(5, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXGlassBox jXGlassBox = JXGlassBox.this;
                jXGlassBox.animateAlpha = jXGlassBox.animateAlpha + JXGlassBox.this.alphaIncrement;
                JXGlassBox.this.paintImmediately(0, 0, JXGlassBox.this.getWidth(), JXGlassBox.this.getHeight());
            }
        });
    }

    public JXGlassBox(float alpha) {
        this();
        this.setAlpha(alpha);
    }

    public void setAlpha(float alpha) {
        this.alphaEnd = alpha;
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 6.0f;
    }

    public float getAlpha() {
        return this.alphaEnd;
    }

    public void setDismissOnClick(boolean dismissOnClick) {
        boolean oldDismissOnClick = this.dismissOnClick;
        this.dismissOnClick = dismissOnClick;
        if (dismissOnClick && !oldDismissOnClick) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        JXGlassBox glassBox = JXGlassBox.this;
                        JComponent parent = (JComponent)glassBox.getParent();
                        Container toplevel = parent.getTopLevelAncestor();
                        parent.remove(glassBox);
                        toplevel.validate();
                        toplevel.repaint();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!dismissOnClick && oldDismissOnClick) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics g) {
        this.getInsets(this.insets);
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, Math.min(this.alphaEnd, this.animateAlpha));
        g2d.setComposite(alphaComp);
        g2d.setColor(this.getBackground());
        g2d.fillRect(this.insets.left, this.insets.top, this.getWidth() - this.insets.left - this.insets.right, this.getHeight() - this.insets.top - this.insets.bottom);
        super.paint(g2d);
        g2d.setComposite(oldComp);
        if (!this.animateTimer.isRunning() && this.animateAlpha < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.animateAlpha >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean visible) {
        this.animateAlpha = this.alphaStart;
        super.setVisible(visible);
    }

    private Container getTopLevel() {
        Container p = this.getParent();
        while (p != null && !(p instanceof Window) && !(p instanceof Applet)) {
            p = p.getParent();
        }
        return p;
    }

    public void showOnGlassPane(Container glassPane, Component component, int componentX, int componentY, int positionHint) {
        Dimension boxPrefSize = this.getPreferredSize();
        Dimension glassSize = glassPane.getSize();
        Rectangle compRect = component.getBounds();
        int boxX = 0;
        int boxY = 0;
        int boxWidth = Math.min(boxPrefSize.width, glassSize.width);
        int boxHeight = Math.min(boxPrefSize.height, glassSize.height);
        Point compLocation = SwingUtilities.convertPoint(component.getParent(), compRect.x, compRect.y, glassPane);
        if (positionHint == 1) {
            boxX = compLocation.x + componentX + boxWidth <= glassSize.width ? compLocation.x + componentX : glassSize.width - boxWidth;
            boxY = compLocation.y - boxHeight;
            if (boxY < 0) {
                boxY = compLocation.y + compRect.height <= glassSize.height ? compLocation.y + compRect.height : 0;
            }
        }
        glassPane.setLayout(null);
        this.setBounds(boxX, boxY, boxWidth, boxHeight);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }

    public void showOnGlassPane(Container glassPane, int originX, int originY) {
        Dimension boxPrefSize = this.getPreferredSize();
        Dimension glassSize = glassPane.getSize();
        int boxX = 0;
        int boxY = 0;
        int boxWidth = 0;
        int boxHeight = 0;
        boxWidth = Math.min(boxPrefSize.width, glassSize.width);
        boxHeight = Math.min(boxPrefSize.height, glassSize.height);
        boxY = originY - boxHeight >= 0 ? originY - boxHeight : (originY + boxHeight <= glassSize.height ? originY : glassSize.height - boxHeight);
        boxX = originX + boxWidth <= glassSize.width ? originX : (originX >= boxWidth ? originX - boxWidth : glassSize.width - boxWidth);
        glassPane.setLayout(null);
        this.setBounds(boxX, boxY, boxWidth, boxHeight);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }
}

