/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdnc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.jdesktop.swing.MouseMessagingHandler;
import org.jdesktop.swing.actions.Targetable;
import org.jdesktop.swing.event.MessageListener;
import org.jdesktop.swing.event.MessageSource;
import org.jdesktop.swing.event.MessageSourceSupport;

public abstract class JNComponent
extends JPanel
implements Targetable,
MessageSource {
    private JComponent component;
    private JPopupMenu popup;
    private PopupHandler popupHandler;
    private MouseMessagingHandler messageHandler;
    protected MessageSourceSupport support;
    protected JToolBar toolBar = null;
    protected Icon image = null;

    protected JNComponent() {
        super(new BorderLayout());
    }

    protected void setComponent(JComponent component) {
        JComponent oldComponent = this.component;
        this.component = component;
        component.setFont(this.getFont());
        component.setForeground(this.getForeground());
        component.setBackground(this.getBackground());
        if (this.popupHandler != null) {
            if (oldComponent != null) {
                oldComponent.removeMouseListener(this.popupHandler);
            }
            if (component != null) {
                component.addMouseListener(this.popupHandler);
            }
        }
        this.firePropertyChange("component", oldComponent, component);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public boolean doCommand(Object command, Object value) {
        ActionMap map = this.component.getActionMap();
        Action action = map.get(command);
        if (action == null) {
            map = this.getActionMap();
            action = map.get(command);
        }
        if (action != null) {
            if (value instanceof ActionEvent) {
                action.actionPerformed((ActionEvent)value);
            } else {
                action.actionPerformed(new ActionEvent(value, 0, command.toString()));
            }
            return true;
        }
        return false;
    }

    public Object[] getCommands() {
        ActionMap map = this.component.getActionMap();
        return map.keys();
    }

    public boolean hasCommand(Object command) {
        Object[] commands = this.getCommands();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].equals(command)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMessageListener(MessageListener l) {
        if (this.support == null) {
            this.support = new MessageSourceSupport(this);
        }
        if (this.messageHandler == null) {
            this.messageHandler = new MouseMessagingHandler((Object)this, this.support);
            if (this.toolBar != null) {
                this.messageHandler.registerListeners(this.toolBar.getComponents());
            }
            if (this.popup != null) {
                this.messageHandler.registerListeners(this.popup.getSubElements());
            }
        }
        this.support.addMessageListener(l);
    }

    public void removeMessageListener(MessageListener l) {
        if (this.support == null) {
            return;
        }
        this.support.removeMessageListener(l);
    }

    public MessageListener[] getMessageListeners() {
        if (this.support == null) {
            this.support = new MessageSourceSupport(this);
        }
        return this.support.getMessageListeners();
    }

    protected void sendMessage(String message) {
        if (this.support != null) {
            this.support.fireMessage(message);
        }
    }

    public JButton addAction(Action action) {
        Object delegate;
        if (this.toolBar == null) {
            this.addToolBar();
        }
        if ((delegate = action.getValue("delegate")) == null) {
            action.putValue("delegate", this);
        }
        JButton button = this.toolBar.add(action);
        button.setToolTipText((String)action.getValue("ShortDescription"));
        return button;
    }

    public void addSeparator() {
        if (this.toolBar != null) {
            this.toolBar.addSeparator();
        }
    }

    public void addToolBarComponent(JComponent component) {
        if (this.toolBar == null) {
            this.addToolBar();
        }
        this.toolBar.add(component);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.component != null) {
            this.component.setFont(font);
        }
    }

    public void setPopupMenu(JPopupMenu popup) {
        JPopupMenu oldPopup = this.popup;
        this.popup = popup;
        if (oldPopup != null) {
            if (this.messageHandler != null) {
                this.messageHandler.unregisterListeners(oldPopup.getSubElements());
            }
            if (this.getComponent() != null) {
                this.getComponent().removeMouseListener(this.popupHandler);
                this.popupHandler = null;
            }
        }
        if (popup != null) {
            if (this.messageHandler != null) {
                this.messageHandler.registerListeners(popup.getSubElements());
            }
            if (this.getComponent() != null) {
                this.popupHandler = new PopupHandler(popup);
                this.getComponent().addMouseListener(this.popupHandler);
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public Icon getBackgroundImage() {
        return this.image;
    }

    public void setBackgroundImage(Icon image) {
        if (this.image != image) {
            this.image = image;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.image != null) {
            Dimension size = this.getSize();
            int x = size.width - this.image.getIconWidth() >> 1;
            int y = size.height - this.image.getIconHeight() >> 1;
            this.image.paintIcon(this, g, x, y);
        }
    }

    protected JToolBar addToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        return this.toolBar;
    }

    private class PopupHandler
    extends MouseAdapter {
        private JPopupMenu popup;

        public PopupHandler(JPopupMenu popup) {
            this.setPopup(popup);
        }

        public void setPopup(JPopupMenu popup) {
            this.popup = popup;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.popup != null) {
                this.popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

