/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGAnimatedLength
implements SVGAnimatedLength,
LiveAttributeValue {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected static final String[] UNITS;
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected short direction;
    protected BaseSVGLength baseVal;
    protected boolean changing;

    protected AbstractSVGAnimatedLength(AbstractElement elt, String ns, String ln, short dir) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        this.direction = dir;
    }

    protected abstract String getDefaultValue();

    public SVGLength getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength();
        }
        return this.baseVal;
    }

    public SVGLength getAnimVal() {
        throw new RuntimeException("!!! TODO: getAnimVal()");
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    static {
        HORIZONTAL_LENGTH = (short)2;
        VERTICAL_LENGTH = 1;
        OTHER_LENGTH = 0;
        UNITS = new String[]{"", "", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    }

    protected class BaseSVGLength
    implements SVGLength {
        protected short unitType;
        protected float value;
        protected boolean valid;
        protected UnitProcessor.Context context = new DefaultContext();

        public void invalidate() {
            this.valid = false;
        }

        public short getUnitType() {
            this.revalidate();
            return this.unitType;
        }

        public float getValue() {
            this.revalidate();
            return UnitProcessor.svgToUserSpace(this.value, this.unitType, AbstractSVGAnimatedLength.this.direction, this.context);
        }

        public void setValue(float value) throws DOMException {
            this.revalidate();
            this.value = UnitProcessor.userSpaceToSVG(value, this.unitType, AbstractSVGAnimatedLength.this.direction, this.context);
            this.resetAttribute();
        }

        public float getValueInSpecifiedUnits() {
            this.revalidate();
            return this.value;
        }

        public void setValueInSpecifiedUnits(float value) throws DOMException {
            this.revalidate();
            this.value = value;
            this.resetAttribute();
        }

        public String getValueAsString() {
            Attr attr = AbstractSVGAnimatedLength.this.element.getAttributeNodeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName);
            if (attr == null) {
                return AbstractSVGAnimatedLength.this.getDefaultValue();
            }
            return attr.getValue();
        }

        public void setValueAsString(String value) throws DOMException {
            AbstractSVGAnimatedLength.this.element.setAttributeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName, value);
        }

        public void newValueSpecifiedUnits(short unit, float value) {
            this.unitType = unit;
            this.value = value;
            this.resetAttribute();
        }

        public void convertToSpecifiedUnits(short unit) {
            float v = this.getValue();
            this.unitType = unit;
            this.setValue(v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetAttribute() {
            try {
                AbstractSVGAnimatedLength.this.changing = true;
                this.setValueAsString(this.value + UNITS[this.unitType]);
                Object var2_1 = null;
                AbstractSVGAnimatedLength.this.changing = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AbstractSVGAnimatedLength.this.changing = false;
                throw throwable;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            String s = this.getValueAsString();
            try {
                LengthParser lengthParser = new LengthParser();
                UnitProcessor.UnitResolver ur = new UnitProcessor.UnitResolver();
                lengthParser.setLengthHandler((LengthHandler)ur);
                lengthParser.parse(s);
                this.unitType = ur.unit;
                this.value = ur.value;
            }
            catch (ParseException e) {
                this.unitType = 0;
                this.value = 0.0f;
            }
            this.valid = true;
        }

        protected class DefaultContext
        implements UnitProcessor.Context {
            protected DefaultContext() {
            }

            public Element getElement() {
                return ((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element;
            }

            public float getPixelUnitToMillimeter() {
                SVGContext ctx = ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext();
                return ctx.getPixelUnitToMillimeter();
            }

            public float getPixelToMM() {
                return this.getPixelUnitToMillimeter();
            }

            public float getFontSize() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getFontSize();
            }

            public float getXHeight() {
                return 0.5f;
            }

            public float getViewportWidth() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getViewportWidth();
            }

            public float getViewportHeight() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getViewportHeight();
            }
        }
    }
}

