/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPatternElementBridge
extends AbstractSVGBridge
implements PaintBridge,
ErrorConstants {
    public String getLocalName() {
        return "pattern";
    }

    public Paint createPaint(BridgeContext ctx, Element patternElement, Element paintedElement, GraphicsNode paintedNode, float opacity) {
        CompositeGraphicsNode patternContentNode = SVGPatternElementBridge.extractPatternContent(patternElement, ctx);
        if (patternContentNode == null) {
            return null;
        }
        Rectangle2D patternRegion = SVGUtilities.convertPatternRegion(patternElement, paintedElement, paintedNode, ctx);
        String s = SVGUtilities.getChainableAttributeNS(patternElement, null, "patternTransform", ctx);
        AffineTransform patternTransform = s.length() != 0 ? SVGUtilities.convertTransform(patternElement, "patternTransform", s) : new AffineTransform();
        boolean overflowIsHidden = CSSUtilities.convertOverflow(patternElement);
        s = SVGUtilities.getChainableAttributeNS(patternElement, null, "patternContentUnits", ctx);
        short contentCoordSystem = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(patternElement, "patternContentUnits", s);
        AffineTransform patternContentTransform = new AffineTransform();
        patternContentTransform.translate(patternRegion.getX(), patternRegion.getY());
        String viewBoxStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "viewBox", ctx);
        if (viewBoxStr.length() > 0) {
            String aspectRatioStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "preserveAspectRatio", ctx);
            float w = (float)patternRegion.getWidth();
            float h = (float)patternRegion.getHeight();
            AffineTransform preserveAspectRatioTransform = ViewBox.getPreserveAspectRatioTransform(patternElement, viewBoxStr, aspectRatioStr, w, h);
            patternContentTransform.concatenate(preserveAspectRatioTransform);
        }
        if (contentCoordSystem == 2) {
            AffineTransform patternContentUnitsTransform = new AffineTransform();
            Rectangle2D objectBoundingBox = paintedNode.getGeometryBounds();
            patternContentUnitsTransform.translate(objectBoundingBox.getX(), objectBoundingBox.getY());
            patternContentUnitsTransform.scale(objectBoundingBox.getWidth(), objectBoundingBox.getHeight());
            patternContentTransform.concatenate(patternContentUnitsTransform);
        }
        patternContentNode.setTransform(patternContentTransform);
        if (opacity != 1.0f) {
            Filter filter = patternContentNode.getGraphicsNodeRable(true);
            filter = new ComponentTransferRable8Bit(filter, ConcreteComponentTransferFunction.getLinearTransfer(opacity, 0.0f), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer());
            patternContentNode.setFilter(filter);
        }
        return new PatternPaint(patternContentNode, patternRegion, !overflowIsHidden, patternTransform);
    }

    protected static CompositeGraphicsNode extractPatternContent(Element patternElement, BridgeContext ctx) {
        LinkedList<ParsedURL> refs = new LinkedList<ParsedURL>();
        CompositeGraphicsNode content;
        while ((content = SVGPatternElementBridge.extractLocalPatternContent(patternElement, ctx)) == null) {
            String uri = XLinkSupport.getXLinkHref((Element)patternElement);
            if (uri.length() == 0) {
                return null;
            }
            SVGOMDocument doc = (SVGOMDocument)patternElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (!purl.complete()) {
                throw new BridgeException(patternElement, "uri.malformed", new Object[]{uri});
            }
            if (SVGPatternElementBridge.contains(refs, purl)) {
                throw new BridgeException(patternElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.add(purl);
            patternElement = ctx.getReferencedElement(patternElement, uri);
        }
        return content;
    }

    protected static CompositeGraphicsNode extractLocalPatternContent(Element e, BridgeContext ctx) {
        GVTBuilder builder = ctx.getGVTBuilder();
        CompositeGraphicsNode content = null;
        Node n = e.getFirstChild();
        while (n != null) {
            GraphicsNode gn;
            if (n.getNodeType() == 1 && (gn = builder.build(ctx, (Element)n)) != null) {
                if (content == null) {
                    content = new CompositeGraphicsNode();
                }
                content.getChildren().add(gn);
            }
            n = n.getNextSibling();
        }
        return content;
    }

    private static boolean contains(List urls, ParsedURL key) {
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            if (!key.equals(iter.next())) continue;
            return true;
        }
        return false;
    }
}

