/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf;

import java.lang.reflect.Array;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.ganttproject.impex.htmlpdf.Stylesheet;

abstract class StylesheetFactoryImpl {
    static final /* synthetic */ boolean $assertionsDisabled;

    StylesheetFactoryImpl() {
    }

    Stylesheet[] createStylesheets(Class stylesheetInterface) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = extensionRegistry.getConfigurationElementsFor(stylesheetInterface.getName());
        Stylesheet[] result = (Stylesheet[])Array.newInstance(stylesheetInterface, configElements.length);
        for (int i = 0; i < configElements.length; ++i) {
            try {
                String localizedName = configElements[i].getAttribute("name");
                String pluginRelativeUrl = configElements[i].getAttribute("url");
                String namespace = configElements[i].getDeclaringExtension().getNamespace();
                URL stylesheetUrl = Platform.getBundle((String)namespace).getResource(pluginRelativeUrl);
                if (!$assertionsDisabled && stylesheetUrl == null) {
                    throw new AssertionError((Object)("Failed to resolve url=" + pluginRelativeUrl));
                }
                URL resolvedUrl = Platform.resolve((URL)stylesheetUrl);
                if (!$assertionsDisabled && resolvedUrl == null) {
                    throw new AssertionError((Object)("Failed to resolve URL=" + stylesheetUrl));
                }
                result[i] = this.newStylesheet(resolvedUrl, localizedName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected abstract Stylesheet newStylesheet(URL var1, String var2);

    static {
        $assertionsDisabled = !StylesheetFactoryImpl.class.desiredAssertionStatus();
    }
}

