/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.export.ExportException;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.util.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.ganttproject.impex.htmlpdf.ExportJob;
import org.ganttproject.impex.htmlpdf.ExporterBase;
import org.ganttproject.impex.htmlpdf.HTMLStylesheet;
import org.ganttproject.impex.htmlpdf.Stylesheet;
import org.ganttproject.impex.htmlpdf.StylesheetFactoryImpl;
import org.ganttproject.impex.htmlpdf.StylesheetImpl;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ExporterToHTML
extends ExporterBase
implements Exporter {
    private static final String PNG_FORMAT_NAME = "png";
    private AdvancedOptionGroup myAdvancedOptions = new AdvancedOptionGroup(new GPOption[0]);
    private EnumerationOption myStylesheetOption;
    private HTMLStylesheet mySelectedStylesheet;
    private static final String GANTT_CHART_FILE_EXTENSION = "png";
    private static final String RESOURCE_CHART_FILE_EXTENSION = "res.png";
    static /* synthetic */ Class class$org$ganttproject$impex$htmlpdf$ExporterToHTML;

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("impex.html.description");
    }

    protected void setSelectedStylesheet(Stylesheet stylesheet) {
        this.mySelectedStylesheet = (HTMLStylesheet)stylesheet;
    }

    public GPOptionGroup[] getSecondaryOptions() {
        return null;
    }

    public String getFileNamePattern() {
        return "html";
    }

    protected Job[] createJobs(File outputFile, List resultFiles) {
        Job generateGanttChartJob = this.createGenerateGanttChartJob(outputFile, resultFiles);
        Job generateResourceChartJob = this.createGenerateResourceChartJob(outputFile, resultFiles);
        Job generatePagesJob = this.createGeneratePagesJob(outputFile, resultFiles);
        Job copyImagesJob = this.createCopyImagesJob(outputFile, resultFiles);
        return new Job[]{generateGanttChartJob, generateResourceChartJob, generatePagesJob, copyImagesJob};
    }

    private Job createGenerateGanttChartJob(final File outputFile, final List resultFiles) {
        ExportJob result = new ExportJob("generate gantt chart"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    RenderedImage ganttChartImage = ExporterToHTML.this.getGanttChart().getRenderedImage(new GanttExportSettings(true, true, true, true));
                    File ganttChartImageFile = ExporterToHTML.replaceExtension(outputFile, "png");
                    ImageIO.write(ganttChartImage, "png", ganttChartImageFile);
                    resultFiles.add(ganttChartImageFile);
                    monitor.worked(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.cancel();
                    return Status.CANCEL_STATUS;
                }
                catch (OutOfMemoryError e) {
                    this.cancel();
                    ExporterToHTML.this.getUIFacade().showErrorDialog((Throwable)new RuntimeException("Out of memory when creating Gantt chart image", e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createGenerateResourceChartJob(final File outputFile, final List resultFiles) {
        ExportJob result = new ExportJob("Generate resource chart"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    RenderedImage resourceChartImage = ExporterToHTML.this.getResourceChart().getRenderedImage(new GanttExportSettings(true, true, true, true));
                    File resourceChartImageFile = ExporterToHTML.replaceExtension(outputFile, ExporterToHTML.RESOURCE_CHART_FILE_EXTENSION);
                    ImageIO.write(resourceChartImage, "png", resourceChartImageFile);
                    resultFiles.add(resourceChartImageFile);
                    monitor.worked(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.cancel();
                    return Status.CANCEL_STATUS;
                }
                catch (OutOfMemoryError e) {
                    this.cancel();
                    ExporterToHTML.this.getUIFacade().showErrorDialog((Throwable)new RuntimeException("Out of memory when creating resource chart image", e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createGeneratePagesJob(final File outputFile, final List resultFiles) {
        ExportJob result = new ExportJob("Generate HTML pages"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    TransformerHandler handler = ExporterToHTML.this.mySelectedStylesheet.createTitlePageHandler();
                    handler.setResult(new StreamResult(outputFile));
                    ExporterToHTML.this.serialize(handler, outputFile);
                    resultFiles.add(outputFile);
                    handler = ExporterToHTML.this.mySelectedStylesheet.createTasksPageHandler();
                    File tasksPageFile = ExporterToHTML.appendSuffixBeforeExtension(outputFile, "-tasks");
                    handler.setResult(new StreamResult(tasksPageFile));
                    ExporterToHTML.this.serialize(handler, outputFile);
                    resultFiles.add(tasksPageFile);
                    handler = ExporterToHTML.this.mySelectedStylesheet.createGanttChartPageHandler();
                    File chartPageFile = ExporterToHTML.appendSuffixBeforeExtension(outputFile, "-chart");
                    handler.setResult(new StreamResult(chartPageFile));
                    ExporterToHTML.this.serialize(handler, outputFile);
                    resultFiles.add(chartPageFile);
                    handler = ExporterToHTML.this.mySelectedStylesheet.createResourcesPageHandler();
                    File resourcesPageFile = ExporterToHTML.appendSuffixBeforeExtension(outputFile, "-resources");
                    handler.setResult(new StreamResult(resourcesPageFile));
                    ExporterToHTML.this.serialize(handler, outputFile);
                    resultFiles.add(resourcesPageFile);
                    monitor.worked(1);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    this.cancel();
                }
                catch (IOException e) {
                    this.cancel();
                    e.printStackTrace();
                }
                catch (OutOfMemoryError e) {
                    this.cancel();
                    ExporterToHTML.this.getUIFacade().showErrorDialog((Throwable)new RuntimeException("Out of memory when running XSL transformation", e));
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (ExportException e) {
                    this.cancel();
                    ExporterToHTML.this.getUIFacade().showErrorDialog((Throwable)e);
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createCopyImagesJob(final File outputFile, List resultFiles) {
        ExportJob result = new ExportJob("Copying images"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    File resultImagesDir;
                    File[] lof;
                    File imagesDir = ExporterToHTML.this.mySelectedStylesheet.getImagesDirectory();
                    if (imagesDir != null && imagesDir.isDirectory() && imagesDir.exists() && (lof = imagesDir.listFiles()).length != 0 && (resultImagesDir = new File(outputFile.getParentFile(), imagesDir.getName())).mkdir()) {
                        for (int i = 0; i < lof.length; ++i) {
                            File nextInFile = lof[i];
                            if (nextInFile.isDirectory()) continue;
                            File outFile = new File(resultImagesDir, nextInFile.getName());
                            outFile.createNewFile();
                            FileInputStream inStream = new FileInputStream(nextInFile);
                            FileOutputStream outStream = new FileOutputStream(outFile);
                            byte[] buffer = new byte[(int)nextInFile.length()];
                            inStream.read(buffer);
                            outStream.write(buffer);
                        }
                    }
                    monitor.worked(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.cancel();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private void serialize(TransformerHandler handler, File outputFile) throws SAXException, IOException, ExportException {
        String filenameWithoutExtension = ExporterToHTML.getFilenameWithoutExtension(outputFile);
        handler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        this.writeViews(this.getUIFacade(), handler);
        this.startElement("ganttproject", attrs, handler);
        this.textElement("title", attrs, "GanttProject - " + filenameWithoutExtension, handler);
        this.addAttribute("prefix", filenameWithoutExtension, attrs);
        this.startElement("links", attrs, handler);
        this.textElement("home", attrs, this.i18n("home"), handler);
        this.textElement("chart", attrs, this.i18n("gantt"), handler);
        this.textElement("tasks", attrs, this.i18n("task"), handler);
        this.textElement("resources", attrs, this.i18n("human"), handler);
        this.endElement("links", handler);
        this.startElement("project", attrs, handler);
        this.addAttribute("title", this.i18n("project"), attrs);
        this.textElement("name", attrs, this.getProject().getProjectName(), handler);
        this.addAttribute("title", this.i18n("organization"), attrs);
        this.textElement("organization", attrs, this.getProject().getOrganization(), handler);
        this.addAttribute("title", this.i18n("webLink"), attrs);
        this.textElement("webLink", attrs, this.getProject().getWebLink(), handler);
        this.addAttribute("title", this.i18n("shortDescription"), attrs);
        this.textElement("description", attrs, this.getProject().getDescription(), handler);
        this.endElement("project", handler);
        String ganttChartFileName = ExporterToHTML.replaceExtension(outputFile, "png").getName();
        this.textElement("chart", attrs, ganttChartFileName, handler);
        this.addAttribute("name", this.i18n("colName"), attrs);
        this.addAttribute("role", this.i18n("colRole"), attrs);
        this.addAttribute("mail", this.i18n("colMail"), attrs);
        this.addAttribute("phone", this.i18n("colPhone"), attrs);
        this.startElement("resources", attrs, handler);
        this.writeResources((ResourceManager)((HumanResourceManager)this.getProject().getHumanResourceManager()), handler);
        String resourceChartFileName = ExporterToHTML.replaceExtension(outputFile, RESOURCE_CHART_FILE_EXTENSION).getName();
        this.addAttribute("path", resourceChartFileName, attrs);
        this.emptyElement("chart", attrs, handler);
        this.endElement("resources", handler);
        this.addAttribute("name", this.i18n("name"), attrs);
        this.addAttribute("begin", this.i18n("start"), attrs);
        this.addAttribute("end", this.i18n("end"), attrs);
        this.addAttribute("milestone", this.i18n("meetingPoint"), attrs);
        this.addAttribute("progress", this.i18n("advancement"), attrs);
        this.addAttribute("assigned-to", this.i18n("assignTo"), attrs);
        this.addAttribute("notes", this.i18n("notesTask"), attrs);
        try {
            this.writeTasks(this.getProject().getTaskManager(), handler);
        }
        catch (Exception e) {
            throw new ExportException("Failed to write tasks", (Throwable)e);
        }
        this.addAttribute("version", "Ganttproject (2.0.5)", attrs);
        this.addAttribute("date", GanttCalendar.getDateAndTime(), attrs);
        this.emptyElement("footer", attrs, handler);
        this.endElement("ganttproject", handler);
        handler.endDocument();
    }

    protected String getAssignedResourcesDelimiter() {
        return ", ";
    }

    public String proposeFileExtension() {
        return "html";
    }

    public String[] getFileExtensions() {
        String[] s = new String[]{"html"};
        return s;
    }

    protected String getStylesheetOptionID() {
        return "impex.html.stylesheet";
    }

    protected Stylesheet[] getStylesheets() {
        StylesheetFactoryImpl factory = new StylesheetFactoryImpl(){

            protected Stylesheet newStylesheet(URL resolvedUrl, String localizedName) {
                return new HTMLStylesheetImpl(resolvedUrl, localizedName);
            }
        };
        return factory.createStylesheets(HTMLStylesheet.class);
    }

    private static File replaceExtension(File f, String newExtension) throws IOException {
        File result = FileUtil.replaceExtension((File)f, (String)newExtension);
        if (!result.exists()) {
            result.createNewFile();
        }
        return result;
    }

    private static File appendSuffixBeforeExtension(File f, String suffix) throws IOException {
        return FileUtil.appendSuffixBeforeExtension((File)f, (String)suffix);
    }

    private static String getFilenameWithoutExtension(File f) {
        return FileUtil.getFilenameWithoutExtension((File)f);
    }

    class HTMLStylesheetImpl
    extends StylesheetImpl
    implements HTMLStylesheet {
        static final /* synthetic */ boolean $assertionsDisabled;

        HTMLStylesheetImpl(URL stylesheetURL, String localizedName) {
            super(stylesheetURL, localizedName);
        }

        public String getInputVersion() {
            return "ganttproject-1.x";
        }

        public TransformerHandler createTitlePageHandler() {
            try {
                URL titleUrl = new URL(this.getUrl(), "gantt.xsl");
                TransformerHandler result = ExporterToHTML.this.createHandler(titleUrl.toString());
                return result;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public TransformerHandler createTasksPageHandler() {
            try {
                URL tasksUrl = new URL(this.getUrl(), "gantt-tasks.xsl");
                TransformerHandler result = ExporterToHTML.this.createHandler(tasksUrl.toString());
                return result;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public TransformerHandler createGanttChartPageHandler() {
            try {
                URL tasksUrl = new URL(this.getUrl(), "gantt-chart.xsl");
                TransformerHandler result = ExporterToHTML.this.createHandler(tasksUrl.toString());
                return result;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public TransformerHandler createResourcesPageHandler() {
            try {
                URL tasksUrl = new URL(this.getUrl(), "gantt-resources.xsl");
                TransformerHandler result = ExporterToHTML.this.createHandler(tasksUrl.toString());
                return result;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public File getImagesDirectory() {
            try {
                URL imagesUrl = new URL(this.getUrl(), "images");
                if (!$assertionsDisabled && imagesUrl == null) {
                    throw new AssertionError();
                }
                File result = new File(imagesUrl.getPath());
                return result;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$ganttproject$impex$htmlpdf$ExporterToHTML == null ? (class$org$ganttproject$impex$htmlpdf$ExporterToHTML = ExporterToHTML.class$("org.ganttproject.impex.htmlpdf.ExporterToHTML")) : class$org$ganttproject$impex$htmlpdf$ExporterToHTML).desiredAssertionStatus();
        }
    }

    private class AdvancedOptionGroup
    extends GPOptionGroup
    implements GPOption {
        public AdvancedOptionGroup(GPOption[] options) {
            super("exporter.html.advanced", options);
        }

        public String getPersistentValue() {
            return null;
        }

        public void loadPersistentValue(String value) {
        }

        public boolean isChanged() {
            return false;
        }
    }
}

