/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.ganttproject.CustomProperty;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.export.ExportException;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.TaskVisitor;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.CustomColumnsValues;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.ganttproject.impex.htmlpdf.Stylesheet;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

abstract class ExporterBase {
    private IGanttProject myProject;
    private Chart myGanttChart;
    private GPOptionGroup myOptions;
    private Chart myResourceChart;
    private SAXTransformerFactory myFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private UIFacade myUIFacade;
    static Object EXPORT_JOB_FAMILY = new String("Export job family");

    ExporterBase() {
    }

    protected EnumerationOption createStylesheetOption(String optionID, final Stylesheet[] stylesheets) {
        String[] names = new String[stylesheets.length];
        for (int i = 0; i < stylesheets.length; ++i) {
            names[i] = stylesheets[i].getLocalizedName();
        }
        DefaultEnumerationOption stylesheetOption = new DefaultEnumerationOption(optionID, names){

            public void commit() {
                super.commit();
                String value = this.getValue();
                for (int i = 0; i < stylesheets.length; ++i) {
                    if (!stylesheets[i].getLocalizedName().equals(value)) continue;
                    ExporterBase.this.setSelectedStylesheet(stylesheets[i]);
                }
            }
        };
        return stylesheetOption;
    }

    protected abstract void setSelectedStylesheet(Stylesheet var1);

    protected abstract Stylesheet[] getStylesheets();

    protected abstract String getStylesheetOptionID();

    public void run(File outputFile, final ExportFinalizationJob finalizationJob) throws Exception {
        final IJobManager jobManager = Platform.getJobManager();
        final ArrayList resultFiles = new ArrayList();
        final Job[] jobs = this.createJobs(outputFile, resultFiles);
        final IProgressMonitor monitor = jobManager.createProgressGroup();
        IProgressMonitor familyMonitor = new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                monitor.beginTask(name, totalWork);
            }

            public void done() {
                monitor.done();
            }

            public void internalWorked(double work) {
                monitor.internalWorked(work);
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void setCanceled(boolean value) {
                monitor.setCanceled(value);
                if (value) {
                    System.err.println("ExporterBase: canceling value=" + EXPORT_JOB_FAMILY);
                    jobManager.cancel(EXPORT_JOB_FAMILY);
                }
            }

            public void setTaskName(String name) {
                monitor.setTaskName(name);
            }

            public void subTask(String name) {
                monitor.subTask(name);
            }

            public void worked(int work) {
                monitor.worked(work);
            }
        };
        Job starting = new Job("starting"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Running export", jobs.length);
                for (int i = 0; i < jobs.length; ++i) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    jobs[i].setProgressGroup(monitor, 1);
                    jobs[i].schedule();
                    try {
                        jobs[i].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Job finishing = new Job(this, "finishing"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.done();
                        3.access$100(this.this$1).run(3.access$000(this.this$1).toArray(new File[0]));
                        return Status.OK_STATUS;
                    }
                };
                finishing.setProgressGroup(monitor, 0);
                finishing.schedule();
                try {
                    finishing.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ List access$000(3 x0) {
                return x0.resultFiles;
            }

            static /* synthetic */ ExportFinalizationJob access$100(3 x0) {
                return x0.finalizationJob;
            }
        };
        starting.setProgressGroup(familyMonitor, 0);
        starting.schedule();
    }

    protected abstract Job[] createJobs(File var1, List var2);

    public void setContext(IGanttProject project, UIFacade uiFacade) {
        this.myGanttChart = uiFacade.getGanttChart();
        this.myResourceChart = uiFacade.getResourceChart();
        this.myProject = project;
        this.myUIFacade = uiFacade;
        Stylesheet[] stylesheets = this.getStylesheets();
        EnumerationOption stylesheetOption = this.createStylesheetOption(this.getStylesheetOptionID(), stylesheets);
        stylesheetOption.lock();
        stylesheetOption.setValue(stylesheets[0].getLocalizedName());
        stylesheetOption.commit();
        this.myOptions = new GPOptionGroup("exporter.html", new GPOption[]{stylesheetOption});
        this.myOptions.setTitled(false);
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    protected IGanttProject getProject() {
        return this.myProject;
    }

    protected CustomColumnsStorage getCustomColumnStorage() {
        return this.getProject().getCustomColumnsStorage();
    }

    protected Chart getGanttChart() {
        return this.myGanttChart;
    }

    public GPOptionGroup getOptions() {
        return this.myOptions;
    }

    protected Chart getResourceChart() {
        return this.myResourceChart;
    }

    protected void startElement(String name, AttributesImpl attrs, TransformerHandler handler) throws SAXException {
        handler.startElement("", name, name, attrs);
        attrs.clear();
    }

    protected void startPrefixedElement(String name, AttributesImpl attrs, TransformerHandler handler) throws SAXException {
        handler.startElement("http://ganttproject.sf.net/", name, "ganttproject:" + name, attrs);
        attrs.clear();
    }

    protected void endElement(String name, TransformerHandler handler) throws SAXException {
        handler.endElement("", name, name);
    }

    protected void endPrefixedElement(String name, TransformerHandler handler) throws SAXException {
        handler.endElement("http://ganttproject.sf.net/", name, "ganttproject:" + name);
    }

    protected void addAttribute(String name, String value, AttributesImpl attrs) {
        if (value != null) {
            attrs.addAttribute("", name, name, "CDATA", value);
        } else {
            System.err.println("[GanttOptions] attribute '" + name + "' is null");
        }
    }

    protected void emptyElement(String name, AttributesImpl attrs, TransformerHandler handler) throws SAXException {
        this.startElement(name, attrs, handler);
        this.endElement(name, handler);
        attrs.clear();
    }

    protected void textElement(String name, AttributesImpl attrs, String text, TransformerHandler handler) throws SAXException {
        if (text != null) {
            this.startElement(name, attrs, handler);
            handler.startCDATA();
            handler.characters(text.toCharArray(), 0, text.length());
            handler.endCDATA();
            this.endElement(name, handler);
            attrs.clear();
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        return this.myFactory;
    }

    protected TransformerHandler createHandler(String xsltPath) {
        try {
            TransformerHandler result = this.getTransformerFactory().newTransformerHandler(new StreamSource(xsltPath));
            Transformer transformer = result.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return result;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void addAttribute(String name, int value, AttributesImpl attrs) {
        this.addAttribute(name, String.valueOf(value), attrs);
    }

    protected String i18n(String key) {
        String text = GanttLanguage.getInstance().getText(key);
        return GanttLanguage.getInstance().correctLabel(text);
    }

    protected void writeColumns(TableHeaderUIFacade visibleFields, TransformerHandler handler) throws SAXException {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        int totalWidth = 0;
        for (i = 0; i < visibleFields.getSize(); ++i) {
            if (!visibleFields.getField(i).isVisible()) continue;
            totalWidth += visibleFields.getField(i).getWidth();
        }
        for (i = 0; i < visibleFields.getSize(); ++i) {
            TableHeaderUIFacade.Column field = visibleFields.getField(i);
            if (!field.isVisible()) continue;
            this.addAttribute("id", field.getID(), attrs);
            this.addAttribute("name", field.getName(), attrs);
            this.addAttribute("width", field.getWidth() * 100 / totalWidth, attrs);
            this.emptyElement("field", attrs, handler);
        }
    }

    protected void writeViews(UIFacade facade, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("id", "task-table", attrs);
        this.startElement("view", attrs, handler);
        this.writeColumns(facade.getTaskTree().getVisibleFields(), handler);
        this.endElement("view", handler);
        this.addAttribute("id", "resource-table", attrs);
        this.startElement("view", attrs, handler);
        this.writeColumns(facade.getResourceTree().getVisibleFields(), handler);
        this.endElement("view", handler);
    }

    protected void writeTasks(TaskManager taskManager, final TransformerHandler handler) throws ExportException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("xslfo-path", "", attrs);
        this.addAttribute("title", this.i18n("tasksList"), attrs);
        this.addAttribute("name", this.i18n("name"), attrs);
        this.addAttribute("begin", this.i18n("start"), attrs);
        this.addAttribute("end", this.i18n("end"), attrs);
        this.addAttribute("milestone", this.i18n("meetingPoint"), attrs);
        this.addAttribute("progress", "%", attrs);
        this.addAttribute("assigned-to", this.i18n("human"), attrs);
        this.addAttribute("notes", this.i18n("notes"), attrs);
        this.addAttribute("duration", this.i18n("duration"), attrs);
        this.startPrefixedElement("tasks", attrs, handler);
        TaskVisitor visitor = new TaskVisitor(){
            AttributesImpl myAttrs = new AttributesImpl();

            protected String serializeTask(Task t, int depth) throws Exception {
                ExporterBase.this.addAttribute("depth", depth, this.myAttrs);
                ExporterBase.this.startPrefixedElement("task", this.myAttrs, handler);
                ExporterBase.this.addAttribute("id", "tpd1", this.myAttrs);
                int priority = t.getPriority();
                if (priority < 0 || priority > 2) {
                    priority = 1;
                }
                String[] priorities = new String[]{ExporterBase.this.i18n("low"), ExporterBase.this.i18n("normal"), ExporterBase.this.i18n("hight")};
                ExporterBase.this.textElement("priority", this.myAttrs, priorities[priority], handler);
                ExporterBase.this.addAttribute("id", "tpd3", this.myAttrs);
                ExporterBase.this.textElement("name", this.myAttrs, t.getName(), handler);
                ExporterBase.this.addAttribute("id", "tpd4", this.myAttrs);
                ExporterBase.this.textElement("begin", this.myAttrs, t.getStart().toString(), handler);
                ExporterBase.this.addAttribute("id", "tpd5", this.myAttrs);
                ExporterBase.this.textElement("end", this.myAttrs, t.getEnd().toString(), handler);
                ExporterBase.this.textElement("milestone", this.myAttrs, Boolean.valueOf(t.isMilestone()).toString(), handler);
                ExporterBase.this.addAttribute("id", "tpd7", this.myAttrs);
                ExporterBase.this.textElement("progress", this.myAttrs, String.valueOf(t.getCompletionPercentage()), handler);
                ExporterBase.this.addAttribute("id", "tpd6", this.myAttrs);
                ExporterBase.this.textElement("duration", this.myAttrs, String.valueOf(t.getDuration().getLength()), handler);
                ProjectResource coordinator = t.getAssignmentCollection().getCoordinator();
                if (coordinator != null) {
                    ExporterBase.this.addAttribute("id", "tpd8", this.myAttrs);
                    ExporterBase.this.textElement("coordinator", this.myAttrs, coordinator.getName(), handler);
                }
                StringBuffer usersS = new StringBuffer();
                ResourceAssignment[] assignments = t.getAssignments();
                if (assignments.length > 0) {
                    for (int j = 0; j < assignments.length; ++j) {
                        ExporterBase.this.addAttribute("resource-id", assignments[j].getResource().getId(), this.myAttrs);
                        ExporterBase.this.emptyElement("assigned-resource", this.myAttrs, handler);
                        usersS.append(assignments[j].getResource().getName());
                        if (j >= assignments.length - 1) continue;
                        usersS.append(ExporterBase.this.getAssignedResourcesDelimiter());
                    }
                }
                ExporterBase.this.addAttribute("id", "tpdResources", this.myAttrs);
                ExporterBase.this.textElement("assigned-to", this.myAttrs, usersS.toString(), handler);
                if (t.getNotes() != null && t.getNotes().length() > 0) {
                    ExporterBase.this.textElement("notes", this.myAttrs, t.getNotes(), handler);
                }
                if (t.getColor() != null) {
                    ExporterBase.this.textElement("color", this.myAttrs, ExporterBase.getHexaColor(t.getColor()), handler);
                }
                AttributesImpl attrs = new AttributesImpl();
                CustomColumnsValues customValues = t.getCustomValues();
                Iterator it = ExporterBase.this.getCustomColumnStorage().getCustomColums().iterator();
                while (it.hasNext()) {
                    CustomColumn nextColumn = (CustomColumn)it.next();
                    Object value = customValues.getValue(nextColumn.getName());
                    String valueAsString = value == null ? "" : value.toString();
                    ExporterBase.this.addAttribute("id", nextColumn.getId(), attrs);
                    ExporterBase.this.textElement("custom-field", attrs, valueAsString, handler);
                }
                ExporterBase.this.endPrefixedElement("task", handler);
                return "";
            }
        };
        try {
            visitor.visit(taskManager);
        }
        catch (Exception e) {
            throw new ExportException("Failed to write tasks", (Throwable)e);
        }
        this.endPrefixedElement("tasks", handler);
    }

    protected String getAssignedResourcesDelimiter() {
        return " ";
    }

    protected void writeResources(ResourceManager resourceManager, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("title", this.i18n("resourcesList"), attrs);
        this.addAttribute("name", this.i18n("colName"), attrs);
        this.addAttribute("role", this.i18n("colRole"), attrs);
        this.addAttribute("mail", this.i18n("colMail"), attrs);
        this.addAttribute("phone", this.i18n("colPhone"), attrs);
        this.startPrefixedElement("resources", attrs, handler);
        List resources = resourceManager.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            HumanResource p = (HumanResource)resources.get(i);
            this.addAttribute("id", p.getId(), attrs);
            this.startPrefixedElement("resource", attrs, handler);
            this.addAttribute("id", "0", attrs);
            this.textElement("name", attrs, p.getName(), handler);
            this.addAttribute("id", "1", attrs);
            this.textElement("role", attrs, p.getRole().getName(), handler);
            this.addAttribute("id", "2", attrs);
            this.textElement("mail", attrs, p.getMail(), handler);
            this.addAttribute("id", "3", attrs);
            this.textElement("phone", attrs, p.getPhone(), handler);
            List customFields = p.getCustomProperties();
            for (int j = 0; j < customFields.size(); ++j) {
                CustomProperty nextProperty = (CustomProperty)customFields.get(j);
                this.addAttribute("id", nextProperty.getDefinition().getID(), attrs);
                String value = nextProperty.getValueAsString();
                this.textElement("custom-field", attrs, value, handler);
            }
            this.endPrefixedElement("resource", handler);
        }
        this.endPrefixedElement("resources", handler);
    }

    protected static String getHexaColor(Color color) {
        StringBuffer out = new StringBuffer();
        out.append("#");
        if (color.getRed() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getBlue()));
        return out.toString();
    }
}

