/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time.gregorian;

import java.util.Calendar;
import java.util.Date;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitFunctionOfDate;
import net.sourceforge.ganttproject.time.TimeUnitText;

class TimeFrameImpl
implements TimeFrame {
    private final Date myBaseDate;
    private final TimeUnit myTopUnit;
    private final TimeUnit myBottomUnit;
    private Date myNextFrameStartDate;
    private Calendar myCalendar;
    private DateFrameable myLowestFrameable;
    private Date myStartDate;
    private DateFrameable myHighestFrameable;
    private Date myEndDate;
    private LineHeader myLineHeader;

    TimeFrameImpl(Date baseDate, TimeUnit topUnit, TimeUnit bottomUnit) {
        if (topUnit instanceof TimeUnitFunctionOfDate) {
            topUnit = ((TimeUnitFunctionOfDate)topUnit).createTimeUnit(baseDate);
        }
        this.myBaseDate = baseDate;
        this.myHighestFrameable = this.calculateHighestFrameableUnit(topUnit, bottomUnit);
        this.myLowestFrameable = this.calculateLowestFrameableUnit(topUnit, bottomUnit);
        this.myTopUnit = topUnit;
        this.myBottomUnit = bottomUnit;
        this.myCalendar = (Calendar)Calendar.getInstance().clone();
        this.myCalendar.setTime(this.myBaseDate);
        if (this.myLowestFrameable == null) {
            throw new RuntimeException("Failed to find any time frameable unit :(");
        }
        this.myStartDate = this.myLowestFrameable.adjustLeft(this.myBaseDate);
        if (this.myStartDate.after(this.myBaseDate)) {
            throw new IllegalStateException("Start date is after base date");
        }
    }

    private DateFrameable calculateLowestFrameableUnit(TimeUnit topUnit, TimeUnit bottomUnit) {
        return bottomUnit;
    }

    private DateFrameable calculateHighestFrameableUnit(TimeUnit topUnit, TimeUnit bottomUnit) {
        return topUnit;
    }

    private Date calculateEndDate() {
        Date date = this.myTopUnit.adjustRight(this.myBaseDate);
        if (date.before(this.myStartDate)) {
            throw new IllegalStateException("End date=" + date + " start=" + this.myStartDate + " base=" + this.myBaseDate);
        }
        return date;
    }

    private LineHeader calculateLines(LineHeader lastHeader) {
        TimeUnit curUnit = lastHeader == null ? this.myTopUnit : lastHeader.myUnit.getDirectAtomUnit();
        LineHeader curHeader = this.createHeader(curUnit);
        this.fillLine(lastHeader, curHeader);
        if (lastHeader != null) {
            lastHeader.append(curHeader);
        }
        if (curUnit != this.myBottomUnit) {
            this.calculateLines(curHeader);
        }
        return curHeader;
    }

    private void fillLine(LineHeader higherHeader, LineHeader header) {
        if (higherHeader == null) {
            LineItem item;
            Date startDate = this.myStartDate;
            Date endDate = this.myTopUnit.adjustRight(this.myBaseDate);
            header.myFirstItem = item = this.createLineItem(startDate, endDate);
        } else {
            LineItem higherItem = higherHeader.myFirstItem;
            while (higherItem != null) {
                int unitCount = this.getUnitCount(higherHeader, header, higherItem);
                Date curStartDate = higherItem.myStartDate;
                LineItem curItem = null;
                for (int i = 0; i < unitCount && curStartDate.compareTo(higherItem.myEndDate) < 0; ++i) {
                    Date nextEndDate = header.myUnit.adjustRight(curStartDate);
                    LineItem newItem = this.createLineItem(curStartDate, nextEndDate);
                    if (curItem == null) {
                        header.myFirstItem = newItem;
                    } else {
                        curItem.myNextItem = newItem;
                    }
                    curItem = newItem;
                    curStartDate = nextEndDate;
                }
                higherItem = higherItem.myNextItem;
            }
        }
    }

    private int getUnitCount(LineHeader higherHeader, LineHeader header, LineItem higherItem) {
        TimeUnit higherUnit = higherHeader.myUnit instanceof TimeUnitFunctionOfDate ? ((TimeUnitFunctionOfDate)higherHeader.myUnit).createTimeUnit(higherItem.myStartDate) : higherHeader.myUnit;
        TimeUnit lowerUnit = header.myUnit;
        int result = higherUnit.getAtomCount(lowerUnit);
        return result;
    }

    private LineItem createLineItem(Date startDate, Date endDate) {
        return new LineItem(startDate, endDate);
    }

    private LineHeader createHeader(TimeUnit unit) {
        return new LineHeader(unit);
    }

    public Date getFinishDate() {
        if (this.myEndDate == null) {
            this.myEndDate = this.calculateEndDate();
        }
        return this.myEndDate;
    }

    public int getUnitCount(TimeUnit unit) {
        int result;
        LineHeader lineHeader = this.getLineHeader(unit);
        if (lineHeader == null) {
            lineHeader = new LineHeader(unit);
            this.fillLine(this.getLineHeader(), lineHeader);
            return lineHeader.getItemCount();
        }
        int n = result = lineHeader == null ? -1 : lineHeader.getItemCount();
        if (result == -1) {
            throw new RuntimeException("There is not time unit=" + unit + " in this time frame");
        }
        return result;
    }

    private LineHeader getLineHeader(TimeUnit timeUnit) {
        LineHeader result;
        for (result = this.getLineHeader(); result != null && result.myUnit != timeUnit; result = result.next()) {
        }
        return result;
    }

    public Date getStartDate() {
        return this.myStartDate;
    }

    public TimeUnit getTopUnit() {
        return this.myTopUnit;
    }

    public TimeUnit getBottomUnit() {
        return this.myBottomUnit;
    }

    public TimeUnitText getUnitText(TimeUnit unitLine, int position) {
        LineHeader lineHeader = this.getLineHeader(unitLine);
        LineItem lineItem = lineHeader == null ? null : lineHeader.getLineItem(position);
        Date startDate = lineItem == null ? null : lineItem.myStartDate;
        TimeUnitText result = startDate == null ? null : this.getUnitText(unitLine, startDate);
        return result;
    }

    private TimeUnitText getUnitText(TimeUnit unitLine, Date startDate) {
        Object result = null;
        return unitLine.format(startDate);
    }

    public Date getUnitStart(TimeUnit unitLine, int position) {
        LineHeader lineHeader = this.getLineHeader(unitLine);
        LineItem lineItem = lineHeader == null ? null : lineHeader.getLineItem(position);
        Date result = lineItem == null ? null : lineItem.myStartDate;
        return result;
    }

    public Date getUnitFinish(TimeUnit unitLine, int position) {
        LineHeader lineHeader = this.getLineHeader(unitLine);
        LineItem lineItem = lineHeader == null ? null : lineHeader.getLineItem(position);
        Date result = lineItem == null ? null : lineItem.myEndDate;
        return result;
    }

    public String toString() {
        return "Time frame start=" + this.getStartDate() + " end=" + this.getFinishDate() + "\n top unit=" + this.getTopUnit() + "\n bottom unit=" + this.getBottomUnit();
    }

    public void trimLeft(Date exactDate) {
        this.myStartDate = exactDate;
        this.myLineHeader = null;
    }

    private LineHeader getLineHeader() {
        if (this.myLineHeader == null) {
            this.myLineHeader = this.calculateLines(null);
        }
        return this.myLineHeader;
    }

    private static class LineItem {
        LineItem myNextItem;
        final Date myStartDate;
        final Date myEndDate;

        public LineItem(Date myStartDate, Date myEndDate) {
            this.myStartDate = myStartDate;
            this.myEndDate = myEndDate;
        }

        public String toString() {
            return this.myStartDate.toString() + " - " + this.myEndDate.toString();
        }
    }

    private static class LineHeader {
        final TimeUnit myUnit;
        LineItem myFirstItem;
        private LineHeader myNextHeader;
        private int myItemCount = -1;

        public LineHeader(TimeUnit myUnit) {
            this.myUnit = myUnit;
        }

        public String fullDump() {
            StringBuffer result = new StringBuffer(this.toString());
            for (int i = 0; i < this.getItemCount(); ++i) {
                LineItem next = this.getLineItem(i);
                result.append("\n" + next);
            }
            return result.toString();
        }

        public String toString() {
            return this.myUnit.toString();
        }

        void append(LineHeader next) {
            this.myNextHeader = next;
        }

        LineHeader next() {
            return this.myNextHeader;
        }

        public int getItemCount() {
            if (this.myItemCount == -1) {
                this.myItemCount = 0;
                LineItem item = this.myFirstItem;
                while (item != null) {
                    ++this.myItemCount;
                    item = item.myNextItem;
                }
            }
            return this.myItemCount;
        }

        LineItem getLineItem(int position) {
            LineItem result = this.myFirstItem;
            while (result != null && position-- > 0) {
                result = result.myNextItem;
            }
            return result;
        }
    }

    private static class UnitInfo {
        final int myTruncatedCount;
        final int myRoundedCount;
        private final Date lastDate;

        public UnitInfo(int myTruncatedCount, int myRoundedCount, Date lastDate) {
            this.myTruncatedCount = myTruncatedCount;
            this.myRoundedCount = myRoundedCount;
            this.lastDate = lastDate;
        }
    }
}

