/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time.gregorian;

import java.util.Date;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitGraph;
import net.sourceforge.ganttproject.time.TimeUnitPair;
import net.sourceforge.ganttproject.time.TimeUnitStack;
import net.sourceforge.ganttproject.time.gregorian.DayTextFormatter;
import net.sourceforge.ganttproject.time.gregorian.FramerImpl;
import net.sourceforge.ganttproject.time.gregorian.MonthTextFormatter;
import net.sourceforge.ganttproject.time.gregorian.TimeFrameImpl;
import net.sourceforge.ganttproject.time.gregorian.WeekFramerImpl;
import net.sourceforge.ganttproject.time.gregorian.WeekTextFormatter;
import net.sourceforge.ganttproject.time.gregorian.YearTextFormatter;

public class GPTimeUnitStack
implements TimeUnitStack {
    private TimeUnitGraph ourGraph = new TimeUnitGraph();
    public final TimeUnit DAY;
    public final TimeUnit WEEK;
    public final TimeUnit MONTH;
    public TimeUnit QUARTER;
    public TimeUnit YEAR = null;
    private final TimeUnitPair[] myPairs;
    private TimeUnit MONTH_FROM_WEEKS;
    public final TimeUnit WEEK_AS_BOTTOM_UNIT;

    public GPTimeUnitStack(GanttLanguage i18n) {
        TimeUnit atom = this.ourGraph.createAtomTimeUnit("atom");
        this.DAY = this.ourGraph.createDateFrameableTimeUnit("day", atom, 1, new FramerImpl(5));
        this.DAY.setTextFormatter(new DayTextFormatter());
        this.MONTH = this.ourGraph.createTimeUnitFunctionOfDate("month", this.DAY, new FramerImpl(2));
        this.MONTH.setTextFormatter(new MonthTextFormatter());
        this.WEEK = this.ourGraph.createDateFrameableTimeUnit("week", this.DAY, 7, new WeekFramerImpl());
        this.MONTH_FROM_WEEKS = this.ourGraph.createTimeUnitFunctionOfDate("month_from_weeks", this.WEEK, new FramerImpl(2));
        this.WEEK.setTextFormatter(new WeekTextFormatter(i18n.getText("week") + " {0}"));
        this.WEEK_AS_BOTTOM_UNIT = this.ourGraph.createDateFrameableTimeUnit("week", this.DAY, 7, new WeekFramerImpl());
        this.WEEK_AS_BOTTOM_UNIT.setTextFormatter(new WeekTextFormatter("{0}"));
        this.YEAR = this.ourGraph.createTimeUnitFunctionOfDate("year", this.DAY, new FramerImpl(1));
        this.YEAR.setTextFormatter(new YearTextFormatter());
        this.myPairs = new TimeUnitPair[]{new MyTimeUnitPair(this.WEEK, this.DAY), new MyTimeUnitPair(this.WEEK, this.DAY), new MyTimeUnitPair(this.MONTH, this.DAY), new MyTimeUnitPair(this.MONTH, this.WEEK_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.MONTH, this.WEEK_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.MONTH, this.WEEK_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.MONTH, this.WEEK_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.YEAR, this.WEEK_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.YEAR, this.WEEK_AS_BOTTOM_UNIT)};
    }

    public TimeFrame createTimeFrame(Date baseDate, TimeUnit topUnit, TimeUnit bottomUnit) {
        return new TimeFrameImpl(baseDate, topUnit, bottomUnit);
    }

    public String getName() {
        return "default";
    }

    public TimeUnit getDefaultTimeUnit() {
        return this.DAY;
    }

    public TimeUnitPair[] getTimeUnitPairs() {
        return this.myPairs;
    }

    private class MyTimeUnitPair
    extends TimeUnitPair {
        MyTimeUnitPair(TimeUnit topUnit, TimeUnit bottomUnit) {
            super(topUnit, bottomUnit, GPTimeUnitStack.this);
        }
    }
}

