/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time.gregorian;

import java.util.Calendar;
import java.util.Date;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;

public class FramerImpl
implements DateFrameable {
    private final int myCalendarField;
    private final Calendar myCalendar = (Calendar)GregorianCalendar.getInstance().clone();

    public FramerImpl(int calendarField) {
        this.myCalendarField = calendarField;
    }

    public Date adjustRight(Date baseDate) {
        Calendar c = this.myCalendar;
        c.setTime(baseDate);
        this.clearFields(c);
        c.add(this.myCalendarField, 1);
        return c.getTime();
    }

    private void clearFields(Calendar c) {
        for (int i = this.myCalendarField + 1; i <= 14; ++i) {
            c.clear(i);
        }
    }

    public Date adjustLeft(Date baseDate) {
        Calendar c = this.myCalendar;
        c.setTime(baseDate);
        Date beforeClear = c.getTime();
        this.clearFields(c);
        return c.getTime();
    }

    public Date jumpLeft(Date baseDate) {
        Calendar c = this.myCalendar;
        c.setTime(baseDate);
        c.add(this.myCalendarField, -1);
        return c.getTime();
    }
}

