/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.dependency;

import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyCollectionImpl;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;

public class TaskDependencyImpl
implements TaskDependency {
    private TaskDependencyConstraint myConstraint;
    private int myDifference;
    private final Task myDependant;
    private final Task myDependee;
    private TaskDependency.Hardness myHardness;
    private TaskDependencyCollectionImpl myCollection;

    public TaskDependencyImpl(Task dependant, Task dependee, TaskDependencyCollectionImpl collection) {
        this.myDependant = dependant;
        this.myDependee = dependee;
        this.myCollection = collection;
        if (dependee == null || dependant == null) {
            throw new IllegalArgumentException("invalid participants of dependency: dependee=" + dependee + " dependant=" + dependant);
        }
        this.myHardness = TaskDependency.Hardness.STRONG;
    }

    public Task getDependant() {
        return this.myDependant;
    }

    public Task getDependee() {
        return this.myDependee;
    }

    public void setConstraint(TaskDependencyConstraint constraint) {
        this.myConstraint = constraint;
        constraint.setTaskDependency(this);
        this.myCollection.fireChanged(this);
    }

    public TaskDependencyConstraint getConstraint() {
        return this.myConstraint;
    }

    public TaskDependency.ActivityBinding getActivityBinding() {
        return this.getConstraint().getActivityBinding();
    }

    public void delete() {
        this.myCollection.delete(this);
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof TaskDependency;
        if (result) {
            TaskDependency rvalue = (TaskDependency)obj;
            result = this.myDependant.equals(rvalue.getDependant()) && this.myDependee.equals(rvalue.getDependee());
        }
        return result;
    }

    public int hashCode() {
        return 7 * this.myDependant.hashCode() + 9 * this.myDependee.hashCode();
    }

    public void setDifference(int difference) {
        this.myDifference = difference;
    }

    public int getDifference() {
        return this.myDifference;
    }

    public TaskDependency.Hardness getHardness() {
        return this.myHardness;
    }

    public void setHardness(TaskDependency.Hardness hardness) {
        this.myHardness = hardness;
    }

    public String toString() {
        return this.myDependant + "->" + this.myDependee;
    }
}

