/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskMutator;
import net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.AlgorithmBase;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;

public abstract class RecalculateTaskScheduleAlgorithm
extends AlgorithmBase {
    private Set myMarkedTasks = new HashSet();
    private SortedMap myDistance2dependencyList = new TreeMap();
    private Set myModifiedTasks = new HashSet();
    private final AdjustTaskBoundsAlgorithm myAdjuster;
    private int myEntranceCounter;
    private boolean isRunning;

    public RecalculateTaskScheduleAlgorithm(AdjustTaskBoundsAlgorithm adjuster) {
        this.myAdjuster = adjuster;
    }

    public void run(Task changedTask) throws TaskDependencyException {
        if (!this.isEnabled()) {
            return;
        }
        this.isRunning = true;
        ++this.myEntranceCounter;
        this.myMarkedTasks.clear();
        this.buildDistanceGraph(changedTask);
        this.fulfilDependencies();
        this.myDistance2dependencyList.clear();
        this.myModifiedTasks.add(changedTask);
        this.myAdjuster.run(this.myModifiedTasks.toArray(new Task[0]));
        this.myDistance2dependencyList.clear();
        this.myModifiedTasks.clear();
        --this.myEntranceCounter;
        this.isRunning = false;
    }

    public void run(Set taskSet) throws TaskDependencyException {
        if (!this.isEnabled()) {
            return;
        }
        this.isRunning = true;
        ++this.myEntranceCounter;
        this.myMarkedTasks.clear();
        Iterator tasks = taskSet.iterator();
        while (tasks.hasNext()) {
            Task nextTask = (Task)tasks.next();
            this.buildDistanceGraph(nextTask);
            this.fulfilDependencies();
            this.myDistance2dependencyList.clear();
            this.myModifiedTasks.add(nextTask);
        }
        this.myAdjuster.run(this.myModifiedTasks.toArray(new Task[0]));
        this.myDistance2dependencyList.clear();
        this.myModifiedTasks.clear();
        --this.myEntranceCounter;
        this.isRunning = false;
    }

    public void run() throws TaskDependencyException {
        if (!this.isEnabled()) {
            return;
        }
        this.myDistance2dependencyList.clear();
        this.isRunning = true;
        TaskContainmentHierarchyFacade facade = this.createContainmentFacade();
        HashSet independentTasks = new HashSet();
        this.traverse(facade, facade.getRootTask(), independentTasks);
        Iterator it = independentTasks.iterator();
        while (it.hasNext()) {
            Task next = (Task)it.next();
            this.buildDistanceGraph(next);
        }
        this.fulfilDependencies();
        this.myDistance2dependencyList.clear();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void traverse(TaskContainmentHierarchyFacade facade, Task root, Set independentTasks) {
        TaskDependency[] asDependant = root.getDependenciesAsDependant().toArray();
        if (asDependant.length == 0) {
            independentTasks.add(root);
        }
        Task[] nestedTasks = facade.getNestedTasks(root);
        for (int i = 0; i < nestedTasks.length; ++i) {
            this.traverse(facade, nestedTasks[i], independentTasks);
        }
    }

    private void fulfilDependencies() throws TaskDependencyException {
        Iterator distances = this.myDistance2dependencyList.entrySet().iterator();
        while (distances.hasNext()) {
            Map.Entry nextEntry = distances.next();
            List nextDependenciesList = (List)nextEntry.getValue();
            for (int i = 0; i < nextDependenciesList.size(); ++i) {
                TaskDependency nextDependency = (TaskDependency)nextDependenciesList.get(i);
                TaskDependencyConstraint nextConstraint = nextDependency.getConstraint();
                TaskDependencyConstraint.Collision collision = nextConstraint.getCollision();
                if (!collision.isActive()) continue;
                this.fulfilConstraints(nextDependency);
                nextDependency.getDependant().applyThirdDateConstraint();
            }
        }
    }

    private void fulfilConstraints(TaskDependency dependency) throws TaskDependencyException {
        Task dependant = dependency.getDependant();
        TaskDependency[] depsAsDependant = dependant.getDependenciesAsDependant().toArray();
        if (depsAsDependant.length > 0) {
            GanttCalendar solution;
            ArrayList<GanttCalendar> startLaterVariations = new ArrayList<GanttCalendar>();
            ArrayList<GanttCalendar> startEarlierVariations = new ArrayList<GanttCalendar>();
            ArrayList<GanttCalendar> noVariations = new ArrayList<GanttCalendar>();
            block5: for (int i = 0; i < depsAsDependant.length; ++i) {
                TaskDependency next = depsAsDependant[i];
                TaskDependencyConstraint.Collision nextCollision = next.getConstraint().getCollision();
                GanttCalendar acceptableStart = nextCollision.getAcceptableStart();
                switch (nextCollision.getVariation()) {
                    case -1: {
                        startEarlierVariations.add(acceptableStart);
                        continue block5;
                    }
                    case 1: {
                        startLaterVariations.add(acceptableStart);
                        continue block5;
                    }
                    case 0: {
                        noVariations.add(acceptableStart);
                    }
                }
            }
            if (noVariations.size() > 1) {
                throw new TaskDependencyException("Failed to fulfill constraints of task=" + dependant + ". There are " + noVariations.size() + " constraints which don't allow for task start variation");
            }
            Collections.sort(startEarlierVariations);
            Collections.sort(startLaterVariations);
            GanttCalendar earliestStart = startEarlierVariations.size() == 0 ? null : startEarlierVariations.get(0);
            GanttCalendar latestStart = startLaterVariations.size() >= 0 ? startLaterVariations.get(startLaterVariations.size() - 1) : null;
            if (earliestStart == null && latestStart == null) {
                GanttCalendar solution2 = dependant.getStart();
            } else {
                if (earliestStart == null && latestStart != null) {
                    earliestStart = latestStart;
                } else if (earliestStart != null && latestStart == null) {
                    latestStart = earliestStart;
                }
                if (earliestStart.compareTo(latestStart) < 0) {
                    throw new TaskDependencyException("Failed to fulfill constraints of task=" + dependant);
                }
            }
            if (noVariations.size() > 0) {
                GanttCalendar notVariableStart = (GanttCalendar)noVariations.get(0);
                if (notVariableStart.compareTo(earliestStart) < 0 || notVariableStart.compareTo(latestStart) > 0) {
                    throw new TaskDependencyException("Failed to fulfill constraints of task=" + dependant);
                }
                solution = notVariableStart;
            } else {
                solution = latestStart;
            }
            this.modifyTaskStart(dependant, solution);
        }
    }

    private void modifyTaskStart(Task task, GanttCalendar newStart) {
        TaskMutator mutator = task.createMutatorFixingDuration();
        mutator.setStart(newStart);
        mutator.commit();
        this.myModifiedTasks.add(task);
    }

    private void modifyTaskEnd(Task task, GanttCalendar taskEnd) {
        task.setEnd(taskEnd);
        this.myModifiedTasks.add(task);
    }

    private void buildDistanceGraph(Task changedTask) {
        TaskDependency[] depsAsDependee = changedTask.getDependenciesAsDependee().toArray();
        this.buildDistanceGraph(depsAsDependee, 1);
    }

    private void buildDistanceGraph(TaskDependency[] deps, int distance) {
        if (deps.length == 0) {
            return;
        }
        Integer key = new Integer(distance);
        ArrayList<TaskDependency> depsList = (ArrayList<TaskDependency>)this.myDistance2dependencyList.get(key);
        if (depsList == null) {
            depsList = new ArrayList<TaskDependency>();
            this.myDistance2dependencyList.put(key, depsList);
        }
        depsList.addAll(Arrays.asList(deps));
        for (int i = 0; i < deps.length; ++i) {
            Task dependant = deps[i].getDependant();
            TaskDependency[] nextStepDeps = dependant.getDependenciesAsDependee().toArray();
            this.buildDistanceGraph(nextStepDeps, ++distance);
        }
    }

    private void markTask(Task task) {
        this.myMarkedTasks.add(task);
    }

    private boolean isMarked(Task task) {
        return this.myMarkedTasks.contains(task);
    }

    protected abstract TaskContainmentHierarchyFacade createContainmentFacade();
}

