/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskInfo;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskMutator;

public class TaskNode
extends DefaultMutableTreeNode {
    private final Task task;

    public TaskNode(Task t) {
        super(t);
        this.task = t;
    }

    public void setPriority(int priority) {
        this.task.setPriority(priority);
    }

    public int getPriority() {
        return this.task.getPriority();
    }

    public void setName(String newName) {
        this.task.setName(newName);
    }

    public String getName() {
        return this.task.getName();
    }

    public void setStart(GanttCalendar startDate) {
        TaskMutator mutator = this.task.createMutatorFixingDuration();
        mutator.setStart(startDate);
        mutator.commit();
    }

    public GanttCalendar getStart() {
        return this.task.getStart();
    }

    public void setEnd(GanttCalendar endDate) {
        TaskMutator mutator = this.task.createMutator();
        mutator.setEnd(endDate);
        mutator.commit();
    }

    public GanttCalendar getEnd() {
        return this.task.getEnd();
    }

    public void setDuration(TaskLength length) {
        TaskMutator mutator = this.task.createMutator();
        mutator.setDuration(length);
        mutator.commit();
    }

    public int getDuration() {
        return (int)this.task.getDuration().getValue();
    }

    public void setCompletionPercentage(int percentage) {
        this.task.setCompletionPercentage(percentage);
    }

    public int getCompletionPercentage() {
        return this.task.getCompletionPercentage();
    }

    public void setTaskInfo(TaskInfo info) {
        this.task.setTaskInfo(info);
    }

    public TaskInfo getTaskInfo() {
        return this.task.getTaskInfo();
    }

    public String toString() {
        return this.task.getName();
    }

    public Object getUserObject() {
        return this.task;
    }

    public void applyThirdDateConstraint() {
        if (this.task.getThird() != null) {
            switch (this.task.getThirdDateConstraint()) {
                case 1: {
                    if (!this.task.getThird().after(this.getStart())) break;
                    this.task.setStart(this.task.getThird().newAdd(0));
                }
            }
        }
    }
}

